/**************************************************************************
*
*                  Copyright (c) 2012 ZTE Corporation.
*
***************************************************************************
* ģ   : frģ
*    : zmmp_fr_test.h
* ļ : 
* ʵֹ : frԴͷļ
*      : 
*      : 
*  : 20130813
* ˵ : 
**************************************************************************/
/**************************************************************************
* ޸ļ¼
**************************************************************************/

#ifndef _ZMMP_FR_TEST_H
#define _ZMMP_FR_TEST_H

/**************************************************************************
* #include
**************************************************************************/
#include "oss_api.h"
#include "wbt_pub.h"
#include "owngsmfr.h"

#ifdef __cplusplus
extern "C"
{
#endif
/**************************************************************************
* 
**************************************************************************/


/**************************************************************************
* ݽṹ
**************************************************************************/
/* ͳƽṹ */
typedef struct
{
   UINT64 totalTicks;   /* ߽֡ҪѵTicks  */
   UINT32 maxTicks;     /* һ֡ҪTicks  */
   UINT32 minTicks;     /* һ֡ҪСTicks  */
   UINT32 count;        /* ֡                     */
}T_zFr_OprElem;

/**************************************************************************
* 
**************************************************************************/
extern T_ZOsa_ThreadUserArea *Osa_GetThreadUserArea(ZOSS_THREAD_ID thread_id, BOOL bupdate);

/**************************************************************************
* :     ͳƱ
* ˵:     
*   ()  pOprElem:ͳƲ
*   ()  
*   ֵ:     
* ˵:     
**************************************************************************/ 
static inline VOID zFr_ResetOprElem(T_zFr_OprElem *pOprElem)
{
    zOss_ASSERT(pOprElem != NULL);
    zOss_Memset(pOprElem, 0, sizeof(T_zFr_OprElem));
    pOprElem->minTicks = 0xffffffff;
}

/**************************************************************************
* :     㵱ǰTicksTicksСTicks
* ˵:     
*   ()  pOprElem:ͳƲ
                ticks   :ǰµһ֡Ticks
*   ()  
*   ֵ:     
* ˵:     
**************************************************************************/ 
static inline VOID zFr_AddTicks(T_zFr_OprElem *pOprElem, UINT32 ticks)
{
    zOss_ASSERT(pOprElem != NULL);
    if(pOprElem->maxTicks < ticks)
    {
        pOprElem->maxTicks = ticks;
    }
    if(pOprElem->minTicks > ticks)
    {
        pOprElem->minTicks = ticks;
    }
    pOprElem->totalTicks += ticks;
    pOprElem->count++;
}

/**************************************************************************
* :     ȡTicks
* ˵:     
*   ()  pOprElem:ͳƲ
*   ()  
*   ֵ:     Ticks
* ˵:     
**************************************************************************/ 
static inline UINT32 zFr_GetMaxTicks(const T_zFr_OprElem *pOprElem)
{
    zOss_ASSERT(pOprElem != NULL);
    return pOprElem->maxTicks;
}

/**************************************************************************
* :     ȡһ֡ʱ(λ:΢)
* ˵:     
*   ()  pOprElem:ͳƲ
*   ()  
*   ֵ:     һ֡ʱ
* ˵:     1 tick = 1/52 ΢
**************************************************************************/ 
static inline FLOAT zFr_GetMaxTime(const T_zFr_OprElem *pOprElem)
{
    zOss_ASSERT(pOprElem != NULL);
    return (FLOAT)((FLOAT)pOprElem->maxTicks / (FLOAT)52);
}

/**************************************************************************
* :     ȡСTicks
* ˵:     
*   ()  pOprElem:ͳƲ
*   ()  
*   ֵ:     СTicks
* ˵:     
**************************************************************************/ 
static inline UINT32 zFr_GetMinTicks(const T_zFr_OprElem *pOprElem)
{
    zOss_ASSERT(pOprElem != NULL);
    return pOprElem->minTicks;
}

/**************************************************************************
* :     ȡһ֡ʱ(λ:΢)
* ˵:     
*   ()  pOprElem:ͳƲ
*   ()  
*   ֵ:     һ֡ʱ
* ˵:     
**************************************************************************/ 
static inline FLOAT zFr_GetMinTime(const T_zFr_OprElem *pOprElem)
{
    zOss_ASSERT(pOprElem != NULL);
    return (FLOAT)((FLOAT)pOprElem->minTicks / (FLOAT)52);
}

/**************************************************************************
* :     ȡ֡
* ˵:     
*   ()  pOprElem:ͳƲ
*   ()  
*   ֵ:     ֡
* ˵:     
**************************************************************************/ 
static inline UINT32 zFr_GetCount(const T_zFr_OprElem *pOprElem)
{
    zOss_ASSERT(pOprElem != NULL);
    return pOprElem->count;
}

/**************************************************************************
* :     ȡһ֡ƽticks
* ˵:     
*   ()  pOprElem:ͳƲ
*   ()  
*   ֵ:     һ֡ƽticks
* ˵:     
**************************************************************************/ 
static inline UINT32 zFr_GetAvgTicks(const T_zFr_OprElem *pOprElem)
{
    zOss_ASSERT(pOprElem != NULL);
    return pOprElem->totalTicks / pOprElem->count;
}

/**************************************************************************
* :     ȡһ֡ƽʱ(λ:΢)
* ˵:     
*   ()  pOprElem:ͳƲ
*   ()  
*   ֵ:     һ֡ƽʱ
* ˵:     
**************************************************************************/ 
static inline FLOAT zFr_GetAvgTime(const T_zFr_OprElem *pOprElem)
{
    zOss_ASSERT(pOprElem != NULL);
    return (FLOAT)((DOUBLE)pOprElem->totalTicks/(DOUBLE)(pOprElem->count * 52));
}

/**************************************************************************
* :     ȡǰtick
* ˵:     
*   ()  
*   ()  
*   ֵ:     ǰtick
* ˵:     
**************************************************************************/ 
static inline UINT32 zFr_GetTick(VOID)
{
    return wbt_get_tick();
    //return (UINT32)(*(volatile unsigned int *)0xf4b00010) | ((UINT64)((*(volatile unsigned int *)0xf4b0002c)&0xFFFFFF) << 32);
}

/**************************************************************************
* :     ȡ߳ʹõջռ
* ˵:     
*   ()  
*   ()  
*   ֵ:     ʹõջռֽ
* ˵:     
**************************************************************************/ 
static inline UINT32 zFr_GetMaxStack(VOID)
{
    UINT32 maxStack = 0;
    ZOSS_THREAD_ID threadID = 0;
  
    #if defined (_OS_TOS)
    threadID = zOss_GetCurThreadID();
    maxStack = cyg_thread_measure_stack_usage((cyg_handle_t)threadID);
    #elif defined (_OS_OSE)
    T_ZOsa_ThreadUserArea *threadArea = NULL;
    threadID = zOss_GetCurThreadID();
    threadArea = (T_ZOsa_ThreadUserArea *)Osa_GetThreadUserArea(threadID, TRUE);
    maxStack = threadArea->maxstack * threadArea->stacksize / 100;
    #endif 

    return maxStack;
}

/**************************************************************************
* :     ȡ߳ʹõĶѿռ
* ˵:     
*   ()  
*   ()  
*   ֵ:     ʹõĶѿռֽ
* ˵:     
**************************************************************************/ 
static inline UINT32 zFr_GetMaxHeap(VOID)
{
    return sizeof(GSMFREncoder_Obj) + sizeof(GSMFRDecoder_Obj);
}


/**************************************************************************
* :     ӡͳƵܲ
* ˵:     
*   ()  pOprElem:ͳƲ
*   ()  
*   ֵ:     
* ˵:     
**************************************************************************/ 
static inline VOID zFr_PutoutOprElem(const T_zFr_OprElem *pOprElem)
{
    wbt_printf("%-20s%-20s%-20s%-20s%-20s%-20s",  "count", "max", "min", "mean", "maxStack", "maxheap");

    wbt_printf("%-20d%-20f%-20f%-20f%-20d%-20d",
            zFr_GetCount(pOprElem),
            zFr_GetMaxTime(pOprElem),
            zFr_GetMinTime(pOprElem),
            zFr_GetAvgTime(pOprElem),
            zFr_GetMaxStack(),
            zFr_GetMaxHeap()
            );
}
#ifdef __cplusplus
}
#endif

#endif  /* _ZMMP_FR_TEST_H */

