/*******************************************************************************
 * Copyright (C) 2007, ZTE Corporation.
 *
 * File Name:
 * File Mark:
 * Description:
 * Others:
 * Version:       null
 * Author:        huji
 * Date:          2007-12-4
 * History 1:
 *     Date:
 *     Version:
 *     Author:
 *     Modification:
 * History 2:
  ********************************************************************************/

/****************************************************************************
* 	                                           Include files
****************************************************************************/
#include "drvs_general.h"

#ifdef _OS_OSE_
#ifndef FAST_SEM
#define FAST_SEM
#endif
#endif

#if 0
#ifndef _OS_ARENA
#ifndef FAST_SEM
#define FAST_SEM
#endif
#endif
#endif

/****************************************************************************
* 	                                           Local Macros
****************************************************************************/
#ifndef FAST_SEM
#define HISR_SEM_NAME "hisr_sem/%d"
#endif

/****************************************************************************
* 	                                           Local Types
****************************************************************************/

/****************************************************************************
* 	                                           Local Constants
****************************************************************************/

/****************************************************************************
* 	                                           Local Function Prototypes
****************************************************************************/

/****************************************************************************
* 	                                          Global Constants
****************************************************************************/

/****************************************************************************
* 	                                          Global Variables
****************************************************************************/
static UINT32 ignore = 0;
/****************************************************************************
* 	                                          Global Function Prototypes
****************************************************************************/

/****************************************************************************
* 	                                          Function Definitions
****************************************************************************/
SINT32  zDrv_HisrCreate(T_Drv_Hisr * hisr, CHAR *name, SINT32 stackSize,  SINT32 priority,  FUNC_HISRENTRY hisrEntry, VOID *hisrDevice)
{

    assert(hisr != NULL);
    if (hisr == NULL)
    {
        return DRV_ERR_INVALID_PARAM;
    }

    hisr->active = 0;
    hisr->event = 0;
    hisr->devPtr = (void *)hisrDevice;

#ifndef FAST_SEM
{
   CHAR semName[32];
   static UINT8 i=0;

   memset(semName, 0, 32);

   sprintf((char *)semName, HISR_SEM_NAME, i++);

    hisr->semid = zOss_CreateSemaphore(semName, 0);
}
#endif
    hisr->pid=  zOss_CreateThread(name, hisrEntry, (SINT32)hisrDevice, ( UINT32 )stackSize, ( UINT32 )priority, 0, 1);

    if (hisr->pid == NULL)
    {
        return DRV_ERR_HISR_CREATE_FAIL;
    }

    return DRV_SUCCESS;
}

VOID  zDrv_HisrFree(T_Drv_Hisr * hisr)
{
    UINT32 nRet;
    if (hisr == NULL)
        return;
    if (hisr->pid != NULL)
    {
        nRet = zOss_DeleteThread(hisr->pid);
        if ( ZOSS_SUCCESS != nRet )
        {
        
        }
    }
#ifndef FAST_SEM
    if (hisr->semid != NULL)
    {
        nRet = zOss_DeleteSemaphore(hisr->semid);
        if ( ZOSS_SUCCESS != nRet )
        {
               
        }
    }
#endif
    
    return;
}

VOID  zDrv_HisrStart(T_Drv_Hisr * hisr, UINT32 event)
{
    UINT32 state = 0;
   assert(hisr != NULL);

    LOCK_SAVE(state);

    if ((hisr->event & event) != event)
    {
        hisr->event |=  event;
        if (!hisr->active)
        {
            LOCK_RESTORE(state);
            zDrv_HisrActivate(hisr);
            return;
        }
    }

    LOCK_RESTORE(state);
    state = state>0?0:1;
    return;
}

VOID zDrv_HisrResetEvent(T_Drv_Hisr *hisr, UINT32 event)
{
    UINT32 state = 0;
    assert(hisr != NULL);

    LOCK_SAVE(state);
    hisr->event &= ~event;
    LOCK_RESTORE(state);
    state = state>0?0:1;
    return;
}


SINT32 zDrv_HisrInitSem(T_Drv_Hisr * hisr)
{
#ifdef FAST_SEM
    PROCESS pid= 0;

    assert(hisr != NULL);
    if (hisr == NULL)
    {
        return DRV_ERR_INVALID_PARAM;
    }
    pid = current_process();
    hisr->pid = (ZOSS_SEMAPHORE_ID)pid;

    set_fsem(0, (PROCESS)hisr->pid);
#endif
    return DRV_SUCCESS;
}

VOID zDrv_HisrActivate(T_Drv_Hisr * hisr)
{

 assert(hisr != NULL);
   
#ifdef FAST_SEM
    signal_fsem((UINT32)hisr->pid);
#else
    ignore = zOss_PutSemaphore(hisr->semid);
#endif
    return;
}

VOID zDrv_HisrWaitSem(T_Drv_Hisr * hisr)
{
#ifdef FAST_SEM
    wait_fsem(1);
#else
    assert(hisr != NULL);
    ignore = zOss_GetSemaphore(hisr->semid, ZOSS_WAIT_FOREVER);
#endif
    if ( ignore )
    {}
    return;
}

