/************************************************************************
* Ȩ(C)2009,ͨѶɷ޹˾
* ģ   ¼ģ
* ļƣzte_audiorec.c
* ļʶ 
* ժҪ 
*
* ޸      汾     ޸ı       ޸       ޸      
* ----------------------------------------------------------------------
* 2009/10/27    1.0                                                   
************************************************************************/

/**************************************************************************
 *                        ͷļ                                      *
 **************************************************************************/
#include "zMsp_Com.h"
#include "zte_audiorec.h"
#include "ZMF_API.h"
#include "drv_api.h"
//#include "zplat_svr_api.h"
 
/**************************************************************************
 *                                                                    *
 **************************************************************************/
/* ¼ģϢ */
enum
{
    EV_REC_START_SYN = 1,   /* ¼ʼϢ */
    EV_REC_STOP_SYN,        /* ¼ֹͣϢ */
    EV_REC_PAUSE_SYN,       /* ¼ͣϢ */
    EV_REC_RESUME_SYN,      /* ¼ָϢ */
    EV_REC_CLOSE_SYN,       /* ¼Ϣ */
    EV_REC_GRAB_ASYN,       /* ݲɼϢ */
    EV_REC_DATASAVE_ASYN    /* ݱϢ */
};

#define ONE_CHANNEL       1    /* ¼ΪͨPCM      */
#define MP3_ENC_BITRATE   32   /* ¼ΪMP3ļ(32kbps)            */
#define PCM_SAMPLE_RATE   8000 /* PCMݵĲ                */
#define AMR_FRAME_TIME_MS 20   /* AMRһ֡20ms                            */
#define MAX_ONE_FRAME_LEN 34   /* һ֡ݵ󳤶(VOICE ֧FR) */

/**************************************************************************
 *                                                                      *
 **************************************************************************/
#define REC_DATAGRAB_PRI    19                     /* ݲɼ߳ȼ */
#define REC_DATASAVE_PRI    21                     /* ݱ߳ȼ */
#define REC_DATAGRAB_STACK  (32 * 1024)            /* ݲɼ߳ջռ */
#define REC_DATASAVE_STACK  (10 * 1024)            /* ݱ߳ջռ */
#define REC_DATAGRAB_SEM    "Rec_datatgrab_sem"    /* ݲɼͬź */
#define REC_DATASAVE_SEM    "Rec_datatsave_sem"    /* ݱͬź */
#define REC_DATAGRAB_THREAD "rec_datagrab_thread"  /* ݲɼ߳߳ */
#define REC_DATASAVE_THREAD "rec_datasave_thread"  /* ݱ߳߳ */
#define REC_DATALIST_MUTEX  "rec_datalist_mutex"   /* ¼ */

/**************************************************************************
 *                                                                 *
 **************************************************************************/
/* ¼ģ״̬־ */
typedef enum
{
    AUDIO_REC_STATE_IDLE,     /* AUDIOREC״̬   */
    AUDIO_REC_STATE_OPEN,     /* AUDIORECѾ */
    AUDIO_REC_STATE_PLAY,     /* AUDIORECѾʼ */ 
    AUDIO_REC_STATE_PAUSE     /* AUDIORECѾͣ */
}AUDIO_REC_STATE;

/* ¼ģ־ */
enum
{
    REC_SUCCESS   = 0,        /* RECģɹ     */
    REC_ERROR     = -1,       /* RECģһԴ   */
    REC_PARAM_ERR = -2,       /* RECģ     */
    REC_DEV_ERR   = -3,       /* RECģ豸 */
    REC_MEM_ERR   = -4,       /* RECģڴ */
    REC_CODE_ERR  = -5,       /* RECģ */
    REC_FILE_ERR  = -6        /* RECģļ */
};

/* ¼ģ쳣־ */
enum
{
    REC_NO_EXP         = 0,       /* 쳣             */
    REC_OP_EXP         = 1 << 0,  /* 쳣           */        
    REC_DATA_ENCODE    = 1 << 1,  /* ȡݱ쳣   */
    REC_SAVE_FILE_EXP  = 1 << 2,  /* ļ 쳣      */
    REC_LIST_READ_EXP  = 1 << 3,  /* ݶȡ쳣 */
    REC_LIST_WRITE_EXP = 1 << 4,  /* ݱ쳣 */
    REC_SPACE_FULL_EXP = 1 << 5   /* ¼ռ쳣     */ 
};

/* ¼ݽڵ */
typedef struct _T_RecDataNode
{
    T_ZOss_Node  tNode;
    VOID        *pData;
    UINT32       uiLen;
    UINT32       uiTime;
}T_RecDataNode;

/* ¼ */
typedef struct _T_RecDataList
{
    T_ZOss_List    *pList;        /*    */
    ZOSS_MUTEX_ID   pListMutex;   /*  */
}T_RecDataList;

typedef struct _T_RecConInfo
{
    BOOL                      bRecCc;       /* Ƿ绰¼         */
    SINT32                    iRecExp;      /* ¼ģ쳣־     */
    UINT32                    uiDevFd;      /* 豸ID           */
    UINT32                    uiFrames;     /* ѱ֡       */
    UINT32                    uiUsedMem;    /* ѱܴС       */
    UINT32                    uiFrameLen;   /* PCM  */
    UINT32                    uiFrameTime;  /* ÿɼһ֡ݵʱ */
    UINT32                    uiTotalTime;  /* ܹɼݵʱ   */
    UInt32                    uiFileId;     /* ļID         */
    T_MediaAudioEncHandle    *pEncHandle;   /*            */
    T_RecDataList            *pDataList;    /* ¼ݻ     */
    ZOSS_THREAD_ID            pGrabThread;  /* ݲɼ߳         */
    ZOSS_THREAD_ID            pSaveThread;  /* ļ߳         */
    EMediaAudioType           tEMediaAType; /*            */
    ZOSS_SEMAPHORE_ID         pGrabSem;     /* ݲɼͬź */
    ZOSS_SEMAPHORE_ID         pSaveSem;     /* ļͬź */
    T_ZDrvAudio_SampleRate    tSampleRate;  /*    */
}T_RecConInfo;

/**************************************************************************
 *                           ֲԭ                                  *
 **************************************************************************/
static VOID Rec_NotifyUser(SINT32 iExpFlag);

static VOID Rec_ConvertRcdParam(UINT8  uiChan, T_MSP_CHANNEL_INPUT      *pMspChan, 
                                UINT16 uiVol,  T_MSP_INPUT_VOLUME_LEVEL *pMspVol);
                                
static SINT32 Rec_OpenDevReq(BOOL bRecInCc);

static VOID Rec_CloseDevReq(BOOL bRecInCc);

static SINT32 Rec_StartDevReq(UINT32 uiDevFd, BOOL bRecInCc, UINT32 uiFrameLen);

static SINT32 Rec_StopDevReq(UINT32 uiDevFd, BOOL bRecInCc);

static T_RecDataList *Rec_CreateDataList(VOID);

static VOID Rec_DestroyDataList(T_RecDataList *pDataList);

static VOID Rec_ClearData(T_RecDataList *pDataList);

static SINT32 Rec_SaveData(T_RecDataList *pDataList, VOID *pData, UINT32 uiLen, UINT32 uiTime);

static SINT32 Rec_GetData(T_RecDataList *pDataList, VOID **pData, UINT32 *pLen, UINT32 *pTime);

static SINT32 Rec_OpenEncoder(BOOL       bRecInCc, EMediaAudioType         eMediaAType, 
                              T_MediaAudioEncHandle **pHandle,  T_ZDrvAudio_SampleRate  tSampleRate,
                              UINT32    *pFrameLen);
                              
static VOID Rec_CloseEncoder(BOOL bRecInCc, T_MediaAudioEncHandle *pEncHandle);

static VOID Rec_DataGrabProcStartMsg(VOID);

static VOID Rec_DataGrabProcStopMsg(VOID);

static VOID Rec_DataGrabProcPauseMsg(VOID);

static VOID Rec_DataGrabProcResumeMsg(VOID);

static SINT32 Rec_GrabAndEncData(BOOL       bRecCc,  UINT32   uiDevFd, 
                                 EncHandle  pHandle, UINT8  **pEncData, 
                                 UINT32    *pDataLen);
                                 
static VOID Rec_DataGrabProcGrabMsg(VOID);

static VOID Rec_DataGrabThreadEntry(SINT32 iArg);

static VOID Rec_DataSaveProcStartMsg(VOID);

static VOID Rec_DataSaveProcStopMsg(VOID);

static UINT8 REC_AMRIF1GetFrameType(UINT32 uiDataLen);

static VOID Rec_DataSaveFrameUnitFill(EMediaAudioType   tEMediaAType, UINT8  *pData,
                                      UINT32            uiDataLen,    UINT32  uiTime,
                                      T_ZMFOutPutUnit  *pAudioUnit);

static VOID Rec_DataSaveProcSaveMsg(VOID);

static VOID Rec_DataSaveThreadEntry(SINT32 iArg);

/**************************************************************************
 *                           ȫֱ                                      *
 **************************************************************************/
static SINT32                       g_iRecErrCode    = REC_SUCCESS;          /* RECģ */
static AUDIO_REC_STATE              g_tAudioRecState = AUDIO_REC_STATE_IDLE; /* RECģ״̬־   */
static T_RecConInfo                 g_tRecConInfo;                           /* ¼Ϣ */
static DD_REC_IOCTL                 g_tRecIoctl;                             /* ¼ṹ   */
static AUDIORECORDER_START_RECORD_T g_tRecordParam;                          /* ¼Ϣ */

/**************************************************************************
 *                ʵ--в֣CԵͷļɲü           *
 **************************************************************************/

/**************************************************************************
 *                ʵ--֣CԵͷļɲü           *
 **************************************************************************/

/**************************************************************************
 *                ʵ--˽в֣CԵͷļɲü           *
 **************************************************************************/

/**************************************************************************
 *                     ȫֺʵ                                      *
 **************************************************************************/
/**
 * ƣ REC_Open 
 *  ¼
 * ˵ (IN)record_in_cc Ƿ绰¼
 *   ֵ ɹDRECORDER_SUCCESS
 * ˵ 
 */
DRECORDER_RETURN_E REC_Open(BOOL record_in_cc, SINT32 iVoiceFd)
{    
    if(g_tAudioRecState != AUDIO_REC_STATE_IDLE)
    {
        zMspCom_Print();

        return DRECORDER_ERROR;
    }

    /* ʼȫֱ */
    g_iRecErrCode = REC_SUCCESS;
    zOss_Memset(&g_tRecConInfo,  0, sizeof(T_RecConInfo));
    zOss_Memset(&g_tRecordParam, 0, sizeof(AUDIORECORDER_START_RECORD_T));
    
    g_tRecConInfo.bRecCc = record_in_cc;

    if(record_in_cc)
    {
        if(iVoiceFd <= 0)
        {
            return DRECORDER_ERROR;
        }
        g_tRecConInfo.uiDevFd = (UINT32)iVoiceFd;
    }

    /* ݱ滺 */
    g_tRecConInfo.pDataList = Rec_CreateDataList();
    if(NULL == g_tRecConInfo.pDataList)
    {
        zMspCom_Print();

        return DRECORDER_ERROR;        
    }
    
    /* ͬõź */
    g_tRecConInfo.pGrabSem = zOss_CreateSemaphore(REC_DATAGRAB_SEM, 0);
    if(ZOSS_NULL == g_tRecConInfo.pGrabSem)
    {
        zMspCom_Print();
        Rec_DestroyDataList(g_tRecConInfo.pDataList);
        g_tRecConInfo.pDataList = NULL;
        
        return DRECORDER_ERROR;        
    }
    g_tRecConInfo.pSaveSem = zOss_CreateSemaphore(REC_DATASAVE_SEM, 0);
    if(ZOSS_NULL == g_tRecConInfo.pSaveSem)
    {
        zMspCom_Print();
        zOss_DeleteSemaphore(g_tRecConInfo.pGrabSem);
        Rec_DestroyDataList(g_tRecConInfo.pDataList);
        g_tRecConInfo.pGrabSem  = NULL;
        g_tRecConInfo.pDataList = NULL; 
        
        return DRECORDER_ERROR;        
    }

    /* ݲɼ߳ */
    g_tRecConInfo.pGrabThread = zOss_CreateThread(REC_DATAGRAB_THREAD,
                                                  Rec_DataGrabThreadEntry,
                                                  0,
                                                  REC_DATAGRAB_STACK,
                                                  REC_DATAGRAB_PRI,
                                                  1,
                                                  1);
    if(NULL == g_tRecConInfo.pGrabThread)
    {
        zMspCom_Print();
        zOss_DeleteSemaphore(g_tRecConInfo.pSaveSem);
        zOss_DeleteSemaphore(g_tRecConInfo.pGrabSem);
        Rec_DestroyDataList(g_tRecConInfo.pDataList);
        g_tRecConInfo.pSaveSem  = NULL;
        g_tRecConInfo.pGrabSem  = NULL;
        g_tRecConInfo.pDataList = NULL;

        return DRECORDER_ERROR;        
    }

    /* ļ߳ */
    g_tRecConInfo.pSaveThread = zOss_CreateThread(REC_DATASAVE_THREAD,
                                                  Rec_DataSaveThreadEntry,
                                                  0,
                                                  REC_DATASAVE_STACK,
                                                  REC_DATASAVE_PRI,
                                                  1,
                                                  1);    
    if(NULL == g_tRecConInfo.pSaveThread)
    {
        zMspCom_Print();
        zOss_DeleteThread(g_tRecConInfo.pGrabThread);
        zOss_DeleteSemaphore(g_tRecConInfo.pSaveSem);
        zOss_DeleteSemaphore(g_tRecConInfo.pGrabSem);
        Rec_DestroyDataList(g_tRecConInfo.pDataList);
        g_tRecConInfo.pSaveSem    = NULL;
        g_tRecConInfo.pGrabSem    = NULL;
        g_tRecConInfo.pDataList   = NULL;
        g_tRecConInfo.pGrabThread = NULL;

        return DRECORDER_ERROR;
    }

    /* ¼ģ״̬ǨΪOPEN */
    g_tAudioRecState = AUDIO_REC_STATE_OPEN;

    return DRECORDER_SUCCESS;
}

/**
 * ƣ REC_Close 
 *  ر¼
 * ˵ (IN)
 *   ֵ ɹDRECORDER_SUCCESS
 * ˵ 
 */
DRECORDER_RETURN_E REC_Close(void)
{
    SINT32 iRet = -1;
    
    if(g_tAudioRecState != AUDIO_REC_STATE_OPEN)
    {
        zMspCom_Print();

        return DRECORDER_ERROR;
    }

    /* ֪ͨݲɼ߳̽ */
    iRet = zMspCom_PostMsg(g_tRecConInfo.pGrabThread, EV_REC_CLOSE_SYN);
    if(iRet != MSP_COM_OP_SUCCESS)
    {
        return DRECORDER_ERROR;
    }    
    /* ȴݲɼ߳̽ */
    zOss_GetSemaphore(g_tRecConInfo.pGrabSem, ZOSS_WAIT_FOREVER);
    
    /* ֪ͨļ߳̽ */
    iRet = zMspCom_PostMsg(g_tRecConInfo.pSaveThread, EV_REC_CLOSE_SYN);
    if(iRet != MSP_COM_OP_SUCCESS)
    {
        return DRECORDER_ERROR;
    }
    /* ȴļ߳̽ */
    zOss_GetSemaphore(g_tRecConInfo.pSaveSem, ZOSS_WAIT_FOREVER);

    /* ɾźԴ¼ݻ */
    zOss_DeleteSemaphore(g_tRecConInfo.pSaveSem);
    zOss_DeleteSemaphore(g_tRecConInfo.pGrabSem);
    Rec_DestroyDataList(g_tRecConInfo.pDataList);
    g_tRecConInfo.pSaveSem  = NULL;
    g_tRecConInfo.pGrabSem  = NULL;    
    g_tRecConInfo.pDataList = NULL;
        
    /* ¼ģ״̬ǨΪIDLE */
    g_tAudioRecState = AUDIO_REC_STATE_IDLE;

    return DRECORDER_SUCCESS;
}

/**
 * ƣ REC_StartRecord 
 *  ʼ¼
 * ˵ (IN)record_param: ¼Ʋrec_sizeĵλΪK
 *   ֵ ɹ¼
 * ˵ 
 */
RECORD_HANDLE REC_StartRecord(AUDIORECORDER_START_RECORD_T *record_param)
{
    SINT32 iRet = -1;
    
    if(g_tAudioRecState != AUDIO_REC_STATE_OPEN)
    {
        zMspCom_Print();

        return NULL;
    }
    
    if(NULL == record_param
       || NULL == record_param->rec_filename
       || 0 == record_param->rec_size)
    {
        zMspCom_Print();
        
        return NULL;
    }

    g_tRecordParam = *record_param;

    /* Ϊ㣬˴λתΪֽ */
    g_tRecordParam.rec_size *= 1024;

    /* Ŀǰ¼ֱ֧ΪAMRļʽ */
    if(g_tRecConInfo.bRecCc)
    {
        g_tRecConInfo.tEMediaAType = ZM_CODEC_ID_AMR_NB;
    }
    else
    {
        g_tRecConInfo.tEMediaAType = ZM_CODEC_ID_AMR_NB;
    }
    //g_tRecConInfo.tEMediaAType = ZM_CODEC_ID_MP3; /* chenyouxin removed-20100525-<remove code for testing> */
    
    /* ֪ͨļ߳̿ʼ¼ */
    iRet = zMspCom_PostMsg(g_tRecConInfo.pSaveThread, EV_REC_START_SYN);
    if(iRet != MSP_COM_OP_SUCCESS)
    {
        return NULL;
    }
    /* ȴļ̴߳ */
    zOss_GetSemaphore(g_tRecConInfo.pSaveSem, ZOSS_WAIT_FOREVER);

    /* ļ߳Ƿ */
    if(g_iRecErrCode != REC_SUCCESS)
    {
        g_iRecErrCode = REC_SUCCESS;

        return NULL;
    }

    /* ֪ͨݲɼ߳̿ʼ¼ */
    iRet = zMspCom_PostMsg(g_tRecConInfo.pGrabThread, EV_REC_START_SYN);
    if(iRet != MSP_COM_OP_SUCCESS)
    {
        return NULL;
    }
    /* ȴݲɼ̴߳ */
    zOss_GetSemaphore(g_tRecConInfo.pGrabSem, ZOSS_WAIT_FOREVER);

    /* ݲɼ߳Ƿ */
    if(g_iRecErrCode != REC_SUCCESS)
    {
        g_iRecErrCode = REC_SUCCESS;

        return NULL;
    }

    /* ¼ģ״̬ǨΪPLAY */
    g_tAudioRecState = AUDIO_REC_STATE_PLAY;

    /* ¼ */
    g_tRecIoctl.rec_filename = g_tRecordParam.rec_filename;
    g_tRecIoctl.rec_size     = g_tRecordParam.rec_size;
    g_tRecIoctl.rec_mode     = (UINT32)g_tRecConInfo.bRecCc;
    
    return &g_tRecIoctl;    
}

/**
 * ƣ REC_StopRecord 
 *  ֹͣ¼
 * ˵ (IN)handle: ¼
 *   ֵ ɹDRECORDER_SUCCESS
 * ˵ 
 */
DRECORDER_RETURN_E REC_StopRecord(RECORD_HANDLE handle)
{
    SINT32 iRet = -1;
    
    if(g_tAudioRecState != AUDIO_REC_STATE_PLAY
       && g_tAudioRecState != AUDIO_REC_STATE_PAUSE)
    {
        zMspCom_Print();

        return DRECORDER_ERROR;
    }
    
    if(NULL == handle
       || handle != &g_tRecIoctl)
    {
        zMspCom_Print();
        
        return DRECORDER_ERROR;
    }

    /* ֪ͨݲɼֹ߳ͣ¼Ϣ */
    iRet = zMspCom_PostMsg(g_tRecConInfo.pGrabThread, EV_REC_STOP_SYN);
    if(iRet != MSP_COM_OP_SUCCESS)
    {
        zMspCom_Print();
        
        return DRECORDER_ERROR;
    }
    /* ȴݲɼ̴߳ */
    zOss_GetSemaphore(g_tRecConInfo.pGrabSem, ZOSS_WAIT_FOREVER);

    /* ˴д飬ʹļ߳Ҳ̴ֹܽͣ
     * ˲ϣʹstopҲܽcloseͷԴ
     */

    /* ֪ͨļֹ߳ͣ¼Ϣ */
    iRet = zMspCom_PostMsg(g_tRecConInfo.pSaveThread, EV_REC_STOP_SYN);
    if(iRet != MSP_COM_OP_SUCCESS)
    {
        zMspCom_Print();
        
        return DRECORDER_ERROR;
    }
    /* ȴļ̴߳ */
    zOss_GetSemaphore(g_tRecConInfo.pSaveSem, ZOSS_WAIT_FOREVER);

    /* ļ߳Ƿ */
    if(g_iRecErrCode != REC_SUCCESS)
    {
        zMspCom_Print();
        g_iRecErrCode = REC_SUCCESS;

        /* ¼ģ״̬ǿǨΪOPENϣcloseرԴ */
        g_tAudioRecState = AUDIO_REC_STATE_OPEN;

        return DRECORDER_ERROR;
    }

    /* ¼ģ״̬ǨΪOPEN */
    g_tAudioRecState = AUDIO_REC_STATE_OPEN;

    /* Ϊ֧StopٴִStartһЩȫֱ */
    g_tRecConInfo.iRecExp     = 0;
    g_tRecConInfo.uiFrames    = 0;
    g_tRecConInfo.uiUsedMem   = 0;   
    g_tRecConInfo.uiTotalTime = 0;
    
    return DRECORDER_SUCCESS;    
}

/**
 * ƣ REC_PauseRecord 
 *  ͣ¼
 * ˵ (IN)handle: ¼
 *   ֵ ɹDRECORDER_SUCCESS
 * ˵ 
 */
DRECORDER_RETURN_E REC_PauseRecord(RECORD_HANDLE handle)
{
    SINT32 iRet = -1;
    
    if(g_tAudioRecState != AUDIO_REC_STATE_PLAY)
    {
        zMspCom_Print();

        return DRECORDER_ERROR;
    }
    
    if(NULL == handle
       || handle != &g_tRecIoctl)
    {
        zMspCom_Print();
        
        return DRECORDER_ERROR;
    }

    /* ֪ͨݲɼֹ߳ͣ¼Ϣ */
    iRet = zMspCom_PostMsg(g_tRecConInfo.pGrabThread, EV_REC_PAUSE_SYN);
    if(iRet != MSP_COM_OP_SUCCESS)
    {
        zMspCom_Print();
        
        return DRECORDER_ERROR;
    }
    
    /* ȴݲɼ̴߳ */
    zOss_GetSemaphore(g_tRecConInfo.pGrabSem, ZOSS_WAIT_FOREVER);

    /* ݲɼ߳Ƿ */
    if(g_iRecErrCode != REC_SUCCESS)
    {
        zMspCom_Print();
        g_iRecErrCode = REC_SUCCESS;

        return DRECORDER_ERROR;
    }

    /* ¼ģ״̬ǨΪPAUSE */
    g_tAudioRecState = AUDIO_REC_STATE_PAUSE;
    
    return DRECORDER_SUCCESS;    
}

/**
 * ƣ REC_ResumeRecord 
 *  ָ¼
 * ˵ (IN)handle: ¼
 *   ֵ ɹDRECORDER_SUCCESS
 * ˵ 
 */
DRECORDER_RETURN_E REC_ResumeRecord(RECORD_HANDLE handle)
{
    SINT32 iRet = -1;
    
    if(g_tAudioRecState != AUDIO_REC_STATE_PAUSE)
    {
        zMspCom_Print();

        return DRECORDER_ERROR;
    }
    
    if(NULL == handle
      || handle != &g_tRecIoctl)
    {
        zMspCom_Print();
        
        return DRECORDER_ERROR;
    }

    /* ֪ͨݲɼָ̻߳¼Ϣ */
    iRet = zMspCom_PostMsg(g_tRecConInfo.pGrabThread, EV_REC_RESUME_SYN);
    if(iRet != MSP_COM_OP_SUCCESS)
    {
        zMspCom_Print();
        
        return DRECORDER_ERROR;
    }
    
    /* ȴݲɼ̴߳ */
    zOss_GetSemaphore(g_tRecConInfo.pGrabSem, ZOSS_WAIT_FOREVER);

    /* ݲɼ߳Ƿ */
    if(g_iRecErrCode != REC_SUCCESS)
    {
        zMspCom_Print();
        g_iRecErrCode = REC_SUCCESS;

        return DRECORDER_ERROR;
    }

    /* ¼ģ״̬ǨΪPLAY */
    g_tAudioRecState = AUDIO_REC_STATE_PLAY;
    
    return DRECORDER_SUCCESS;
}

/**
 * ƣ REC_GetCurTime 
 *  ȡǰ¼ʱ
 * ˵ (OUT)cur_time: ǰ¼ʱ
 *            (IN)handle:    ¼
 *   ֵ ɹDRECORDER_SUCCESS
 * ˵ 
 */
DRECORDER_RETURN_E  REC_GetCurTime(UINT32 *cur_time, RECORD_HANDLE handle)
{
    if(g_tAudioRecState <= AUDIO_REC_STATE_OPEN)
    {
        zMspCom_Print();
        
        return DRECORDER_ERROR;
    }

    if(NULL == cur_time
       || NULL == handle
       || handle != &g_tRecIoctl)
    {
        zMspCom_Print();
        
        return DRECORDER_ERROR;
    }

    *cur_time = g_tRecConInfo.uiTotalTime;
    
    return DRECORDER_SUCCESS;
}

/**************************************************************************
 *                      ֲʵ                                      *
 **************************************************************************/
/**
 * ƣ Rec_NotifyUser 
 *  ¼ģ֪ͨû
 * ˵ (IN)iExpFlag: 쳣ģʽ־
 *   ֵ 
 * ˵ KM2.0ӿƣģδṩעắ
 *            ˴ֻITCϢϱ
 */
static VOID Rec_NotifyUser(SINT32 iExpFlag)
{
    if(iExpFlag & REC_SPACE_FULL_EXP)
    {
        tp_comm_channel_post_msg(NULL, MAN_MM_AUDRECORD_BUF_FULL, NULL, 0);
    }
    else
    {
        tp_comm_channel_post_msg(NULL, MAN_MM_AUDRECORD_ABNORMITY, NULL, 0);
    }

    return;
}

/**
 * ƣ Rec_ConvertRcdParam 
 *  ¼ģת˽ӿҪǶKM2.0MMIϲת
 * ˵ (IN)uiChan:    ͨ(KM2.0 MMI)
 *            (OUT)pMspChan: ͨ
 *            (IN)uiVol:     (KM2.0 MMI)
 *            (OUT)pMspVol:  
 *   ֵ 
 * ˵ 
 */
static VOID Rec_ConvertRcdParam(UINT8  uiChan, T_MSP_CHANNEL_INPUT      *pMspChan, 
                                UINT16 uiVol,  T_MSP_INPUT_VOLUME_LEVEL *pMspVol)
{
    if(NULL == pMspChan || NULL == pMspVol)
    {
        zMspCom_Print();
        
        return;
    }

    switch(uiChan)
    {
        case 4:     /* MAN_MM_CHANNEL_IN_MIC */
        {
            *pMspChan = MSP_CHANNEL_INPUT_MICPHONE;
            break;
        }

        case 5:     /* MAN_MM_CHANNEL_IN_EARPHONE */
        {
            *pMspChan = MSP_CHANNEL_INPUT_HEADSET;
            break;
        }

        default:
        {
            *pMspChan = MSP_CHANNEL_INPUT_MICPHONE;
            break;
        }        
    }

    if(uiVol <= 20)
    {
        *pMspVol = MSP_INPUT_VOLUME_LEVEL_0;
    }
    else if(uiVol <= 40)
    {
        *pMspVol = MSP_INPUT_VOLUME_LEVEL_1;
    }
    else if(uiVol <= 60)
    {
        *pMspVol = MSP_INPUT_VOLUME_LEVEL_2;
    }
    else if(uiVol <= 80)
    {
        *pMspVol = MSP_INPUT_VOLUME_LEVEL_3;
    }
    else if(uiVol <= 100)
    {
        *pMspVol = MSP_INPUT_VOLUME_LEVEL_4;
    }
    else
    {
        *pMspVol = MSP_INPUT_VOLUME_LEVEL_5;
    }

    return;
}

/**
 * ƣ Rec_OpenDevReq 
 *  ¼ģ豸
 * ˵ (IN)bRecInCc: Ƿ绰¼
 *   ֵ ش豸ľ
 * ˵ 
 */
static SINT32 Rec_OpenDevReq(BOOL bRecInCc)
{
    SINT32   iRet   = -1;
    SINT32   iDevFd = -1;
    
    if(bRecInCc)
    {   
        iDevFd = g_tRecConInfo.uiDevFd;
    }
    else
    {    
        iDevFd = zMspCom_AudioOpen();
    }
    
    return iDevFd;
}

/**
 * ƣ Rec_CloseDevReq 
 *  ¼ģر豸
 * ˵ (IN)bRecInCc: Ƿ绰¼
 *   ֵ 
 * ˵ 
 */
static VOID Rec_CloseDevReq(BOOL bRecInCc)
{
    if(bRecInCc)
    {
        g_tRecConInfo.uiDevFd = 0;
    }
    else
    {
        zMspCom_AudioClose();       
        g_tRecConInfo.uiDevFd = 0;
    }

    return;
}

/**
 * ƣ Rec_StartDevReq 
 *  ¼ģ鿪ʼ豸
 * ˵ (IN)uiDevFd:    ¼豸
 *            (IN)bRecInCc:   Ƿ绰¼
 *            (IN)uiFrameLen: һӦɼݳ(¼ʹ)
 *   ֵ ɹREC_SUCCESS
 * ˵ 
 */
static SINT32 Rec_StartDevReq(UINT32 uiDevFd, BOOL bRecInCc, UINT32 uiFrameLen)
{
    SINT32               iRet     = -1;
    T_ZDrvRcd_InfoParam  tRcdInfo;
    
    if(bRecInCc)
    {
        /* 绰¼ֱ֧ΪAMRļʽ */
        tRcdInfo.dataformat = RECORD_DATA_FORMAT_AMR;
        tRcdInfo.bufsize    = MAX_ONE_FRAME_LEN;

        iRet = zDrv_Ioctl(uiDevFd, IOCTL_VOICE_RECORD_START, &tRcdInfo);
        if(iRet != DRV_SUCCESS)
        {  
            zMspCom_Print();
            
            return REC_DEV_ERR;
        }        
    }
    else
    {
        T_MSP_CHANNEL_INPUT       tInputChannel = MSP_CHANNEL_INPUT_MICPHONE;
        T_ZDrvAudio_SampleRate    tSampleRate   = AUDIO_RATE_8_KHZ;
        T_MSP_INPUT_VOLUME_LEVEL  tInputVol     = MSP_INPUT_VOLUME_LEVEL_5;

        /* ¼ĲҪʾ */
        iRet = zDrv_Ioctl(uiDevFd, IOCTL_AUDIO_SET_RECORD_SAMPLE, &tSampleRate);
        if (iRet != DRV_SUCCESS)
        {    
            zMspCom_Print();
            
            return REC_DEV_ERR;
        }

        if(g_tRecordParam.record_param != NULL)
        {        
            Rec_ConvertRcdParam(g_tRecordParam.record_param->channel_in, 
                                &tInputChannel,
                                g_tRecordParam.record_param->input_gain,
                                &tInputVol);
        }
        
        iRet = zMspCom_SetInputChannel(tInputChannel);
        if (iRet != MSP_COM_OP_SUCCESS)
        {    
            zMspCom_Print();
            
            return REC_DEV_ERR;
        }

        iRet = zMspCom_SetInputVol(tInputVol);
        if (iRet != MSP_COM_OP_SUCCESS)
        {    
            zMspCom_Print();
            
            return REC_DEV_ERR;
        }

        tRcdInfo.dataformat = RECORD_DATA_FORMAT_AMR;
        tRcdInfo.bufsize    = uiFrameLen * 2;           /* תΪֽ */
 
        iRet = zDrv_Ioctl(uiDevFd, IOCTL_AUDIO_RECORD_START, &tRcdInfo);
        if(iRet != DRV_SUCCESS)
        {   
            zMspCom_Print();
            
            return REC_DEV_ERR;
        }        
    }

    return REC_SUCCESS;
}

/**
 * ƣ Rec_StopDevReq 
 *  ¼ģֹͣ豸
 * ˵ (IN)uiDevFd:  ¼豸
 *            (IN)bRecInCc: Ƿ绰¼
 *   ֵ ɹREC_SUCCESS
 * ˵ 
 */
static SINT32 Rec_StopDevReq(UINT32 uiDevFd, BOOL bRecInCc)
{
    SINT32 iRet = -1;
    
    if(bRecInCc)
    {
        iRet = zDrv_Ioctl(uiDevFd, IOCTL_VOICE_RECORD_STOP, NULL);
    }
    else
    {
        iRet = zDrv_Ioctl(uiDevFd, IOCTL_AUDIO_RECORD_STOP, NULL);
    }

    if(iRet != DRV_SUCCESS)
    {
        zMspCom_Print();
        
        return REC_ERROR;
    }

    return REC_SUCCESS;
}

/**
 * ƣ Rec_CreateDataList 
 *  ¼ݻ
 * ˵ (IN): 
 *   ֵ ָ
 * ˵ 
 */
static T_RecDataList *Rec_CreateDataList(VOID)
{
    T_RecDataList *pDataList = NULL;
    
    pDataList = (T_RecDataList *)zOss_Malloc(sizeof(T_RecDataList));
    if(NULL == pDataList)
    {
        zMspCom_Print();
        
        return NULL;
    }

    /* ݱ滺 */
    pDataList->pList = (T_ZOss_List *)zOss_Malloc(sizeof(T_ZOss_List));
    if(NULL == pDataList->pList)
    {
        zMspCom_Print();
        zOss_Free(pDataList);
        
        return NULL;
    }
    zOss_Memset(pDataList->pList, 0, sizeof(T_ZOss_List));
    zOss_ListInit(pDataList->pList);

    pDataList->pListMutex = zOss_CreateMutex(REC_DATALIST_MUTEX, ZOSS_NO_INHERIT);
    if(NULL == pDataList->pListMutex)
    {
        zMspCom_Print();
        zOss_Free(pDataList->pList);
        zOss_Free(pDataList);
        
        return NULL;
    }

    return pDataList;
}

/**
 * ƣ Rec_DestroyDataList 
 *  ¼ݻ
 * ˵ (IN) pDataList: ָ
 *   ֵ 
 * ˵ 
 */
static VOID Rec_DestroyDataList(T_RecDataList *pDataList)
{
    if(NULL == pDataList
       || NULL == pDataList->pListMutex
       || NULL == pDataList->pList)
    {
        zMspCom_Print();
        
        return;
    }
    
    zOss_DeleteMutex(pDataList->pListMutex);
    zOss_Free(pDataList->pList);
    zOss_Free(pDataList);

    return;
}

/**
 * ƣ Rec_ClearData 
 *  ջ
 * ˵ (IN) pDataList: ָ
 *   ֵ 
 * ˵ 
 */
static VOID Rec_ClearData(T_RecDataList *pDataList)
{
    SINT32         iNodeCount = -1;
    T_RecDataNode *pDataNode  = NULL;
    
    if(NULL == pDataList
       || NULL == pDataList->pList
       || NULL == pDataList->pListMutex
       )
    {
        zMspCom_Print();
        
        return;
    }

    zOss_GetMutex(pDataList->pListMutex, ZOSS_WAIT_FOREVER);

    iNodeCount = zOss_ListCount(pDataList->pList);
    if (iNodeCount < 1)
    {
        zOss_PutMutex(pDataList->pListMutex);
        
        return;
    }

    while(iNodeCount > 0)
    {
        pDataNode = (T_RecDataNode *)zOss_ListFirst(pDataList->pList);
        if(NULL == pDataNode)
        {
            break;
        }

        zOss_Free(pDataNode->pData);
        zOss_ListDelete(pDataList->pList, (T_ZOss_Node *)pDataNode);
        zOss_Free(pDataNode);

        iNodeCount = zOss_ListCount(pDataList->pList);
    }

    zOss_PutMutex(pDataList->pListMutex);

    return;
}

/**
 * ƣ Rec_SaveData 
 *  ¼д뻺
 * ˵ (IN) pDataList: ָ
 *            (IN) pData:     д뻺
 *            (IN) uiLen:     ݳ
 *            (IN) uiTime:    ʱϢ
 *   ֵ ɹREC_SUCCESS
 * ˵ 
 */
static SINT32 Rec_SaveData(T_RecDataList *pDataList, VOID *pData, UINT32 uiLen, UINT32 uiTime)
{
    T_RecDataNode *pRecDataNode = NULL;

    if(NULL == pDataList
       || NULL == pDataList->pListMutex
       || NULL == pDataList->pList
       || NULL == pData)
    {
        zMspCom_Print();
        
        return REC_PARAM_ERR;
    }    

    pRecDataNode = (T_RecDataNode *)zOss_Malloc(sizeof(T_RecDataNode));
    if (NULL == pRecDataNode)
    {
        zMspCom_Print();

        return REC_MEM_ERR;
    }
    zOss_Memset(pRecDataNode, 0, sizeof(T_RecDataNode));

    pRecDataNode->pData  = pData;
    pRecDataNode->uiLen  = uiLen;
    pRecDataNode->uiTime = uiTime;

    zOss_GetMutex(pDataList->pListMutex, ZOSS_WAIT_FOREVER);

    /* ݼ */
    zOss_ListAdd(pDataList->pList, (T_ZOss_Node *)pRecDataNode);

    zOss_PutMutex(pDataList->pListMutex);
    
    return REC_SUCCESS;
}

/**
 * ƣ Rec_GetData 
 *  ¼ݻȡ
 * ˵ (IN)  pDataList: ָ
 *            (OUT) pData:     뻺ݵַ
 *            (OUT) pLen:      뻺ݳ
 *            (OUT) pTime:     뻺Ϣ
 *   ֵ ɹREC_SUCCESS
 * ˵ 
 */
static SINT32 Rec_GetData(T_RecDataList *pDataList, VOID **pData, UINT32 *pLen, UINT32 *pTime)
{
    SINT32         iNodeCount = 0;
    T_RecDataNode *pDataNode  = NULL;

    if(NULL == pDataList
       || NULL == pDataList->pList
       || NULL == pDataList->pListMutex
       || NULL == pData
       || NULL == pLen
       || NULL == pTime)
    {
        zMspCom_Print();
        
        return REC_PARAM_ERR;
    }
    
    zOss_GetMutex(pDataList->pListMutex, ZOSS_WAIT_FOREVER);

    iNodeCount = zOss_ListCount(pDataList->pList);
    if(iNodeCount < 1)
    {
        zOss_PutMutex(pDataList->pListMutex);
        zMspCom_Print();
        
        return REC_PARAM_ERR;
    }
    
    pDataNode = (T_RecDataNode *)zOss_ListFirst(pDataList->pList);

    if(NULL == pDataNode || NULL == pDataNode->pData)
    {
        zOss_PutMutex(pDataList->pListMutex);
        zMspCom_Print();
        
        return REC_ERROR;
    }

    *pData = pDataNode->pData;
    *pLen  = pDataNode->uiLen;
    *pTime = pDataNode->uiTime;

    zOss_ListDelete(pDataList->pList, (T_ZOss_Node *)pDataNode);

    /* pDataNodeедļͷ */
    zOss_Free(pDataNode);

    zOss_PutMutex(pDataList->pListMutex);
    
    return REC_SUCCESS;    
}

/**
 * ƣ Rec_OpenEncoder 
 *  ¼ģ򿪱
 * ˵ (IN) bRecInCc:    Ƿ绰¼
 *            (IN) eMediaAType: ʽ
 *            (OUT)pHandle:     
 *            (OUT)pSampleRate: 
 *            (OUT)pFrameLen:   PCMݳ
 *   ֵ ɹREC_SUCCESS
 * ˵ 
 */
static SINT32 Rec_OpenEncoder(BOOL       bRecInCc, EMediaAudioType         eMediaAType, 
                              T_MediaAudioEncHandle **pHandle,  T_ZDrvAudio_SampleRate  tSampleRate,
                              UINT32    *pFrameLen)
{
    SINT32                    iRet        = -1;
    UINT32                    uiFrameLen  = 0;
    T_MediaAudioEncHandle *pEncHandle  = NULL;

    /* 绰¼Ҫ򿪱 */
    if(bRecInCc)
    {
        return REC_SUCCESS;
    }
    
    if(NULL == pHandle || NULL == pFrameLen)
    {
        zMspCom_Print();

        return REC_PARAM_ERR;
    }

    /* ر */
    iRet = zMspCom_LoadAudioEnCodeLib(eMediaAType);
    if(iRet != MSP_COM_OP_SUCCESS)
    {
        zMspCom_Print();
        
        return REC_CODE_ERR;
    }

    /* 򿪱 */
    if(ZM_CODEC_ID_AMR_NB == eMediaAType)
    {
        pEncHandle = zMspCom_OpenAudioEncoder(eMediaAType, NULL, &uiFrameLen);
    }
    else if(ZM_CODEC_ID_MP3 == eMediaAType)
    {
        T_MP3AddEnCoderData tAddData;

        /* MP3 */
        tAddData.iBitrate    = MP3_ENC_BITRATE;
        tAddData.iChannelIn  = ONE_CHANNEL;
        tAddData.iChannelOut = ONE_CHANNEL;
        tAddData.iSampleRate = PCM_SAMPLE_RATE;
        
        pEncHandle = zMspCom_OpenAudioEncoder(eMediaAType, &tAddData, &uiFrameLen);
    }

    if(NULL == pEncHandle)
    {
        zMspCom_Print();
        zMspCom_UnLoadAudioEnCodeLib(eMediaAType);
        
        return REC_CODE_ERR;
    }

    *pHandle   = pEncHandle;
    *pFrameLen = uiFrameLen;
    
    return REC_SUCCESS;
}

/**
 * ƣ Rec_CloseEncoder 
 *  ¼ģرձ
 * ˵ (IN) bRecInCc:    Ƿ绰¼
 *            (IN) eMediaAType: ʽ
 *            (IN) pHandle:     
 *   ֵ 
 * ˵ 
 */
static VOID Rec_CloseEncoder(BOOL bRecInCc, T_MediaAudioEncHandle *pEncHandle)
{
    /* 绰¼Ҫ򿪱 */
    if(bRecInCc)
    {
        return;
    }
    
    if(NULL == pEncHandle)
    {
        zMspCom_Print();

        return;
    }
    
    zMspCom_CloseAudioEncoder(pEncHandle);
    zMspCom_UnLoadAudioEnCodeLib(g_tRecConInfo.tEMediaAType);

    return;
}

/**
 * ƣ Rec_DataGrabProcStartMsg 
 *  Ƶݲɼ̴߳StartϢ
 * ˵ (IN): 
 *   ֵ 
 * ˵ 
 */
static VOID Rec_DataGrabProcStartMsg(VOID)
{
    SINT32           iRet         = -1;
    SINT32           iDevFd       = -1;

    /* Ŀǰֻ֧8Kʵ¼ */
    g_tRecConInfo.tSampleRate = AUDIO_RATE_8_KHZ;
    
    /* 򿪱 */
    iRet = Rec_OpenEncoder(g_tRecConInfo.bRecCc,      
                           g_tRecConInfo.tEMediaAType, 
                           &g_tRecConInfo.pEncHandle, 
                           g_tRecConInfo.tSampleRate,
                           &g_tRecConInfo.uiFrameLen);
    if(iRet != REC_SUCCESS)
    {
        g_iRecErrCode = REC_CODE_ERR;
        zMspCom_Print();

        return;
    }

    if(g_tRecConInfo.bRecCc)
    {
        g_tRecConInfo.uiFrameTime = AMR_FRAME_TIME_MS;   /* 绰¼һ֡ӦʱΪ20ms */
    }
    else
    {
        g_tRecConInfo.uiFrameTime = g_tRecConInfo.uiFrameLen / 8; /* ԲʵĹһλms */ 
    }
    
    /* 豸 */
    iDevFd = Rec_OpenDevReq(g_tRecConInfo.bRecCc);
    if(iDevFd <= 0)
    {
        g_iRecErrCode = REC_DEV_ERR;
        zMspCom_Print();
        Rec_CloseEncoder(g_tRecConInfo.bRecCc, g_tRecConInfo.pEncHandle);
        
        return;
    }
    g_tRecConInfo.uiDevFd = (UINT32)iDevFd;

    /* ʼ豸 */
    iRet = Rec_StartDevReq(g_tRecConInfo.uiDevFd, g_tRecConInfo.bRecCc, g_tRecConInfo.uiFrameLen);
    if(iRet != REC_SUCCESS)
    {
        g_iRecErrCode = REC_DEV_ERR;
        zMspCom_Print();
        Rec_CloseDevReq(g_tRecConInfo.bRecCc);
        Rec_CloseEncoder(g_tRecConInfo.bRecCc, g_tRecConInfo.pEncHandle);
        g_tRecConInfo.uiDevFd    = 0;
        g_tRecConInfo.pEncHandle = NULL;
        
        return;
    }
    
    /* ֪ͨݲɼ */
    iRet = zMspCom_PostMsg(g_tRecConInfo.pGrabThread, EV_REC_GRAB_ASYN);
    if(iRet != MSP_COM_OP_SUCCESS)
    {
        g_iRecErrCode = REC_ERROR;
        zMspCom_Print();
        Rec_StopDevReq(g_tRecConInfo.uiDevFd, g_tRecConInfo.bRecCc);
        Rec_CloseDevReq(g_tRecConInfo.bRecCc);
        Rec_CloseEncoder(g_tRecConInfo.bRecCc, g_tRecConInfo.pEncHandle);
        g_tRecConInfo.uiDevFd    = 0;
        g_tRecConInfo.pEncHandle = NULL;
        
        return;
    }

    /* ˴״̬ǿǨ */
    g_tAudioRecState = AUDIO_REC_STATE_PLAY;
    
    return;
}

/**
 * ƣ Rec_DataGrabProcStopMsg 
 *  Ƶݲɼ̴߳StopϢ
 * ˵ (IN): 
 *   ֵ 
 * ˵ 
 */
static VOID Rec_DataGrabProcStopMsg(VOID)
{
    SINT32 iRet = -1;

    if(g_tRecConInfo.uiDevFd > 0)
    {
        if(AUDIO_REC_STATE_PLAY == g_tAudioRecState)
        {
            /* ״ֹ̬ͣ¼豸 */
            iRet = Rec_StopDevReq(g_tRecConInfo.uiDevFd, g_tRecConInfo.bRecCc);
            if(iRet != REC_SUCCESS)
            {
                g_iRecErrCode = REC_DEV_ERR;
                zMspCom_Print();

                return;
            }
        }
        
        /* ر豸 */
        Rec_CloseDevReq(g_tRecConInfo.bRecCc);
        g_tRecConInfo.uiDevFd = 0;
        
        /* رձ */
        Rec_CloseEncoder(g_tRecConInfo.bRecCc, g_tRecConInfo.pEncHandle);
        g_tRecConInfo.pEncHandle = NULL;

        /* ˴״̬ǿǨƣΪ˺ϢܶGrabϢ */
        g_tAudioRecState = AUDIO_REC_STATE_OPEN;
    }
    
    return;
}

/**
 * ƣ Rec_DataGrabProcPauseMsg 
 *  Ƶݲɼ̴߳PauseϢ
 * ˵ (IN): 
 *   ֵ 
 * ˵ 
 */
static VOID Rec_DataGrabProcPauseMsg(VOID)
{
    SINT32 iRet = -1;
    
    /* ֹͣ豸 */
    iRet = Rec_StopDevReq(g_tRecConInfo.uiDevFd, g_tRecConInfo.bRecCc);
    if(iRet != REC_SUCCESS)
    {        
        g_iRecErrCode = iRet;
        zMspCom_Print();

        return;
    }
    
    /* ˴״̬ǿǨƣΪ˺ϢܶGrabϢ */
    g_tAudioRecState = AUDIO_REC_STATE_PAUSE;

    return;
}   

/**
 * ƣ Rec_DataGrabProcPauseMsg 
 *  Ƶݲɼ̴߳ResumeϢ
 * ˵ (IN): 
 *   ֵ 
 * ˵ 
 */
static VOID Rec_DataGrabProcResumeMsg(VOID)
{
    SINT32 iRet = -1;

    /* ʼ豸 */
    iRet = Rec_StartDevReq(g_tRecConInfo.uiDevFd, g_tRecConInfo.bRecCc, g_tRecConInfo.uiFrameLen);
    if(iRet != REC_SUCCESS)
    {
        zMspCom_Print();
        g_iRecErrCode = iRet;

        return;
    }

    /* ֪ͨɼ */
    iRet = zMspCom_PostMsg(g_tRecConInfo.pGrabThread, EV_REC_GRAB_ASYN);
    if(iRet != MSP_COM_OP_SUCCESS)
    {
        zMspCom_Print();
        g_iRecErrCode = REC_ERROR;        
        
        return;
    }

    /* ˴״̬ǿǨƣΪܴGrabϢ */
    g_tAudioRecState = AUDIO_REC_STATE_PLAY;
    
    return;
}   

/**
 * ƣ Rec_GrabAndEncData 
 *  ɼ
 * ˵ (IN)bRecCc:    Ƿ绰¼
 *            (IN)uiDevFd:   ¼豸
 *            (IN)pHandle:   
 *            (OUT)pEncData: 
 *            (OUT)pDataLen: ݵĳ
 *   ֵ ɹREC_SUCCESS
 * ˵ pEncDataɸýӿڶ̬䣬ɵ߸ͷ
 */
static SINT32 Rec_GrabAndEncData(BOOL       bRecCc,  UINT32   uiDevFd, 
                                 EncHandle  pHandle, UINT8  **pEncData, 
                                 UINT32    *pDataLen)
{
    UINT8               *pOutData     = NULL;  /*      */
    SINT32               iRet         = -1;
    UINT32               uiOutDataLen = 0;  
    T_ZDrvAudio_BufInfo  tABufInfo    = {NULL, 0};
    T_ZDrvVoice_BufInfo  tVBufInfo    = {NULL, 0};
    
    if(NULL == pEncData
       || NULL == pDataLen)
    {
        zMspCom_Print();

        return REC_PARAM_ERR;
    }

    /* 绰¼ */
    if(bRecCc)
    {
        iRet = zDrv_Ioctl(uiDevFd, IOCTL_VOICE_RECORD_DATA_READ, &tVBufInfo);
        if(iRet != DRV_SUCCESS)
        {
            zMspCom_Print();

            return REC_DEV_ERR;
        }

        /* 绰¼еһֽڶ࣬ȥ */
        pOutData = (UINT8 *)zOss_Malloc(tVBufInfo.bufferSize - 1);
        if(NULL == pOutData)
        {
            zMspCom_Print();
            zDrv_Ioctl(uiDevFd, IOCTL_VOICE_RCD_FREE_BUFF, tVBufInfo.pBuf);
            
            return REC_MEM_ERR;
        }

        /* ݿ */
        zOss_Memcpy(pOutData, (VOID *)((CHAR *)tVBufInfo.pBuf + 1), tVBufInfo.bufferSize - 1);
        uiOutDataLen = tVBufInfo.bufferSize - 1;
        
        /* ͷBufferռ */
        iRet = zDrv_Ioctl(uiDevFd, IOCTL_VOICE_RCD_FREE_BUFF, tVBufInfo.pBuf);
        if(iRet != DRV_SUCCESS)
        {
            zMspCom_Print();
            zOss_Free(pOutData);
            
            return REC_DEV_ERR;
        }
    }
    else
    {        
        iRet = zDrv_Read(uiDevFd, (VOID *)&tABufInfo, sizeof(tABufInfo));
        if(iRet < 0)
        {
            zMspCom_Print();

            return REC_DEV_ERR;
        }

        /* ԲɼPCMݽб룬˿ռļ߳̽ͷ */
        pOutData = zMspCom_AudioEncode(g_tRecConInfo.pEncHandle, 
                                       tABufInfo.buf, 
                                       tABufInfo.buffersize, 
                                       &uiOutDataLen);
        if(NULL == pOutData)
        {
            zMspCom_Print();
            zDrv_Ioctl(uiDevFd, IOCTL_AUDIO_RCD_FREE_BUFF, (VOID *)(tABufInfo.buf));

            return REC_CODE_ERR;        
        }
        
        /* ͷBufferռ */
        iRet = zDrv_Ioctl(uiDevFd, IOCTL_AUDIO_RCD_FREE_BUFF, (VOID *)(tABufInfo.buf));
        if(iRet != DRV_SUCCESS)
        {
            zMspCom_Print();
            zOss_Free(pOutData);
            
            return REC_DEV_ERR;
        }
    }

    *pEncData = pOutData;
    *pDataLen = uiOutDataLen;

    return REC_SUCCESS;
}

/**
 * ƣ Rec_DataGrabProcGrabMsg 
 *  Ƶݲɼ̴߳GrabϢ
 * ˵ (IN): 
 *   ֵ 
 * ˵ 
 */
static VOID Rec_DataGrabProcGrabMsg(VOID)
{
    UINT8   *pOutData     = NULL;  /*      */
    SINT32   iRet         = -1;
    UINT32   uiOutDataLen = 0;     /* ݳ */    

    /* ȡ */
    iRet = Rec_GrabAndEncData(g_tRecConInfo.bRecCc, g_tRecConInfo.uiDevFd, 
                              g_tRecConInfo.pEncHandle, &pOutData, &uiOutDataLen);
    if(iRet != REC_SUCCESS)
    {
        zMspCom_Print();
        g_tRecConInfo.iRecExp |= REC_OP_EXP;
        
        return;
    }

    /* MP3ʱһ֡벢б룬ʱݱɼ */
    if(0 == uiOutDataLen && ZM_CODEC_ID_MP3 == g_tRecConInfo.tEMediaAType)
    {
        zOss_Free(pOutData);
        
        /* ֪ͨݲɼ */
        iRet = zMspCom_PostMsg(g_tRecConInfo.pGrabThread, EV_REC_GRAB_ASYN);
        if(iRet != MSP_COM_OP_SUCCESS)
        {
            zMspCom_Print();
            g_tRecConInfo.iRecExp |= REC_OP_EXP;

            return;
        }

        return;
    }
    
    /* д뻺 */
    iRet = Rec_SaveData(g_tRecConInfo.pDataList, pOutData, uiOutDataLen, g_tRecConInfo.uiTotalTime);
    if(iRet != REC_SUCCESS)
    {
        zMspCom_Print();
        zOss_Free(pOutData);
        g_tRecConInfo.iRecExp |= REC_OP_EXP;
        g_tRecConInfo.iRecExp |= REC_LIST_WRITE_EXP;

        return;
    }

    /* FIXME: ˴¼AMRMP3ʽļ
     * uiTime趨ԼǷ񳬹¼ռƶҪ¿
     */
    /* ±֡ͳϢ */
    g_tRecConInfo.uiTotalTime += g_tRecConInfo.uiFrameTime;    
    ++g_tRecConInfo.uiFrames;
    if(ZM_CODEC_ID_AMR_NB == g_tRecConInfo.tEMediaAType)
    {
        /* AMRļʽÿ֡һֽڵ֡ͷ */
        g_tRecConInfo.uiUsedMem += (uiOutDataLen + 1);        
    }
    else
    {
        g_tRecConInfo.uiUsedMem += uiOutDataLen;
    }

    /* Ƿ񳬹¼ռ */
    if(g_tRecConInfo.uiUsedMem > g_tRecordParam.rec_size)
    {
        g_tRecConInfo.iRecExp |= REC_OP_EXP;
        g_tRecConInfo.iRecExp |= REC_SPACE_FULL_EXP;

        /* Ϣѭĩβͳһ쳣 */
        /* Rec_NotifyUser(g_tRecConInfo.iRecExp); */

        return;
    }

    /* ֪ͨݲɼ */
    iRet = zMspCom_PostMsg(g_tRecConInfo.pGrabThread, EV_REC_GRAB_ASYN);
    if(iRet != MSP_COM_OP_SUCCESS)
    {
        zMspCom_Print();
        g_tRecConInfo.iRecExp |= REC_OP_EXP;

        return;
    }
    
    /* ֪ͨļ */
    iRet = zMspCom_PostMsg(g_tRecConInfo.pSaveThread, EV_REC_DATASAVE_ASYN);
    if(iRet != MSP_COM_OP_SUCCESS)
    {
        zMspCom_Print();
        g_tRecConInfo.iRecExp |= REC_OP_EXP;

        return;
    }
    
    return;
}   

/**
 * ƣ Rec_DataGrabThreadEntry 
 *  ļȡ߳ں
 * ˵ (IN)iArg: ̲߳
 *   ֵ 
 * ˵ 
 */
static VOID Rec_DataGrabThreadEntry(SINT32 iArg)
{
    BOOL    bQuit       = FALSE;
    BOOL    bNotifyUser = FALSE;  /* ֪ͨû쳣ϱ */
    UINT32  uiMsg       = 0;
    SINT32  iRet        = -1;
    
    while(1)
    {
        /* Ϣ */
        iRet = zMspCom_RecvMsg(&uiMsg, ZOSS_WAIT_FOREVER);
        if(iRet != MSP_COM_OP_SUCCESS)
        {
            continue;
        }

        /* OPEN״̬½startcloseϢ */
        if(AUDIO_REC_STATE_OPEN == g_tAudioRecState)
        {
            if(uiMsg != EV_REC_START_SYN
               && uiMsg != EV_REC_CLOSE_SYN)
            {
                /* ͷϢԴ */                
                uiMsg = 0;
                
                continue;
            }
        }
        
        /* ͣ״̬½resumestopϢ(GrabϢ) */
        if(AUDIO_REC_STATE_PAUSE == g_tAudioRecState)
        {
            if(uiMsg != EV_REC_RESUME_SYN
               && uiMsg != EV_REC_STOP_SYN)
            {
                /* ͷϢԴ */                
                uiMsg = 0;
                
                continue;
            }
        }

        /* 쳣״̬ϢֹֻͣرϢ */
        if(g_tRecConInfo.iRecExp & REC_OP_EXP)
        {
            if(EV_REC_START_SYN     == uiMsg
               || EV_REC_PAUSE_SYN  == uiMsg 
               || EV_REC_RESUME_SYN == uiMsg)
            {
                /* ͷͬź֪ͨû߳̿ռϢ */
                zOss_PutSemaphore(g_tRecConInfo.pGrabSem); 
            
                /* ͷϢԴ */
                uiMsg = 0;

                continue;
            }

            if(EV_REC_GRAB_ASYN == uiMsg)
            {
                /* ͷϢԴ */
                uiMsg = 0;

                continue;
            }
        }
        
        switch(uiMsg)
        {
            /* ݲɼ */
            case EV_REC_GRAB_ASYN:
            {
                Rec_DataGrabProcGrabMsg();
                
                break;
            }

            /* ʼ¼ */
            case EV_REC_START_SYN:
            {
                Rec_DataGrabProcStartMsg();

                /* ͷͬź֪ͨûռ */
                zOss_PutSemaphore(g_tRecConInfo.pGrabSem);
                
                break;
            }

            /* ֹͣ¼ */
            case EV_REC_STOP_SYN:
            {
                Rec_DataGrabProcStopMsg();

                /* ͷͬź֪ͨûռ */
                zOss_PutSemaphore(g_tRecConInfo.pGrabSem);
                
                break;
            }            

            /* ͣ¼ */
            case EV_REC_PAUSE_SYN:
            {
                Rec_DataGrabProcPauseMsg();

                /* ͷͬź֪ͨûռ */
                zOss_PutSemaphore(g_tRecConInfo.pGrabSem);
                
                break;
            }

            /* ָ¼ */
            case EV_REC_RESUME_SYN:
            {
                Rec_DataGrabProcResumeMsg();

                /* ͷͬź֪ͨûռ */
                zOss_PutSemaphore(g_tRecConInfo.pGrabSem);
                
                break;
            }

            /* ر¼ */
            case EV_REC_CLOSE_SYN:
            {
                bQuit = TRUE;
                
                break;
            }
            
            default:
            {
                break;            
            }            
        }

        /* Ϣз쳣֪ͨϲû֪ͨһ */
        if(g_tRecConInfo.iRecExp & REC_OP_EXP
           && !bNotifyUser)
        {
            Rec_NotifyUser(g_tRecConInfo.iRecExp);
            bNotifyUser = TRUE;
        }
        
        /* ͷϢԴ */
        uiMsg = 0;

        /* ˳Ϣѭ */
        if(bQuit)
        {
            break;
        }
    }

    /* ͷͬź֪ͨû¼ر */
    zOss_PutSemaphore(g_tRecConInfo.pGrabSem);

    return;
}

/**
 * ƣ Rec_DataSaveProcStartMsg 
 *  ļ̴߳StartϢ
 * ˵ (IN): 
 *   ֵ 
 * ˵ 
 */
static VOID Rec_DataSaveProcStartMsg(VOID)
{
    UInt32          u32OutFileID = 0;
    SINT32          iRet         = -1;
    T_ZMFFileInfo   tFileInfo;
    EZMFResultCode  eRet         = ZMF_RS_ERROR;

    /* ʼļģ */
    iRet = zMspCom_InitFileParseModule();
    if(iRet != MSP_COM_OP_SUCCESS)
    {
        zMspCom_Print();
        g_iRecErrCode = REC_ERROR;  

        return;
    }

    /* ļͨ */
    eRet = OpenMediaFileHandler((const char *)g_tRecordParam.rec_filename, 
                                ZMF_FILE_WRITE, &u32OutFileID);
    if (eRet != ZMF_RS_OK)
    {
        zMspCom_Print();
        g_iRecErrCode = REC_ERROR;  

        return;
    }

    zOss_Memset(&tFileInfo, 0, sizeof(T_ZMFFileInfo));
    
    if(ZM_CODEC_ID_AMR_NB == g_tRecConInfo.tEMediaAType)
    {
        tFileInfo.eFileType                            = ZM_FileID_AMR;
        tFileInfo.tFileInfo.t_amrInfo.eFileID          = ZM_FileID_AMR;
        tFileInfo.tFileInfo.t_amrInfo.u8ChannelNum     = ONE_CHANNEL;       /*                */
        //tFileInfo.tFileInfo.t_amrInfo.u8FrameTypeIndex = (UInt8)REC_MR122;  /* 12.2K AMR֡Ϊ7 */
        tFileInfo.u32Duration      = AMR_FRAME_TIME_MS;
    }
    else if(ZM_CODEC_ID_MP3 == g_tRecConInfo.tEMediaAType)
    {
        tFileInfo.eFileType                         = ZM_FileID_MP3;
        tFileInfo.tFileInfo.t_mp3Info.eFileID       = ZM_FileID_MP3;
        tFileInfo.tFileInfo.t_mp3Info.bVBR          = FALSE;
        tFileInfo.tFileInfo.t_mp3Info.u32FrameNum   = 0;
        tFileInfo.u32Duration   = 0;
        tFileInfo.tFileInfo.t_mp3Info.u32FileLength = 0;
    }
    
    /* ɵļ */
    eRet = Create(u32OutFileID, &tFileInfo);
    if (eRet != ZMF_RS_OK)
    {
        zMspCom_Print();
        g_iRecErrCode = REC_ERROR; 
        CloseMediaFileHandler(u32OutFileID);

        return;
    }

    g_tRecConInfo.uiFileId = u32OutFileID;
    
    return;
}

/**
 * ƣ Rec_DataSaveProcStopMsg 
 *  ļ̴߳StopϢ
 * ˵ (IN): 
 *   ֵ 
 * ˵ 
 */
static VOID Rec_DataSaveProcStopMsg(VOID)
{
    EZMFResultCode eRet = ZMF_RS_ERROR;
    
    /* ¼ */
    Rec_ClearData(g_tRecConInfo.pDataList);

    /* رļ */
    eRet = WriteOver(g_tRecConInfo.uiFileId);
    if(eRet != ZMF_RS_OK)
    {
        zMspCom_Print();
        g_iRecErrCode = REC_ERROR; 
        
        return;
    }

    /* رļͨ */
    eRet = CloseMediaFileHandler(g_tRecConInfo.uiFileId);
    if(eRet != ZMF_RS_OK)
    {
        zMspCom_Print();
        g_iRecErrCode = REC_ERROR; 
        
        return;
    }    
    
    g_tRecConInfo.uiFileId = 0;
    
    return;
}

/**
 * ƣREC_AMRIF1GetFrameType
 * AMR֡ȡAMR IF1ʽ֡
 * ˵(IN)uiDataLen: AMR IF1ʽ֡
 *   ֵ AMR IF1ʽ֡͡
 * ˵ 
 */
static UINT8 REC_AMRIF1GetFrameType(UINT32 uiDataLen)
{
    UINT8  uiFrameType = 8;

    switch(uiDataLen)
    {
        case 12:
        {
            uiFrameType = 0;  /* 4.75k */
            break;
        }
        case 13:
        {
            uiFrameType = 1;  /* 5.15k */
            break;
        }
        case 15:
        {
            uiFrameType = 2;  /* 5.9k */
            break;
        }
        case 17:
        {
            uiFrameType = 3;  /* 6.7k */
            break;
        }
        case 19:
        {
            uiFrameType = 4;  /* 7.4k */
            break;
        }
        case 20:
        {
            uiFrameType = 5;  /* 7.95k */
            break;
        }
        case 26:
        {
            uiFrameType = 6;  /* 10.2k */
            break;
        }
        case 31:
        {
            uiFrameType = 7;  /* 12.2k */
            break;
        }
        case 5:
        {
            uiFrameType = 8;  /* SID */
            break;
        }
        case 0:
        {
            uiFrameType = 15; /* no transmission */
            break;
        }
        default:
        {
            uiFrameType = 8;  /* SID */
            break;
        }
    }
    
    return uiFrameType;
}


/**
 * ƣ Rec_DataSaveFrameUnitFill 
 *  ýʽϢýļ֡Ԫ
 * ˵ (IN)tEMediaAType: ý
 *            (IN)pData:        
 *            (IN)uiDataLen:    
 *            (IN)uiTime:       ʱϢ
 *            (OUT)pAudioUnit:  ļ֡Ԫ
 *   ֵ 
 * ˵ 
 */
static VOID Rec_DataSaveFrameUnitFill(EMediaAudioType   tEMediaAType, UINT8  *pData,
                                      UINT32            uiDataLen,    UINT32  uiTime,
                                      T_ZMFOutPutUnit  *pAudioUnit)
{
    pAudioUnit->pPacket       = pData;
    pAudioUnit->u32Len        = uiDataLen;
    pAudioUnit->u32DecodeTime = uiTime;
        
    if(ZM_CODEC_ID_AMR_NB == tEMediaAType)
    {
        UINT8   uFrameType   = 0;
        
        uFrameType = REC_AMRIF1GetFrameType(uiDataLen);
        pAudioUnit->eCodeID = ZM_CODEC_ID_AMR_NB;
        pAudioUnit->uFrameUnit.t_AMRFrameUnit.u8FrameType   = uFrameType;
        /* pAudioUnit->uFrameUnit.t_AMRFrameUnit.u16PacketMode = uFrameType; */
        pAudioUnit->uFrameUnit.t_AMRFrameUnit.cFrameQuality = 1;            /* ֡ */
    }
    else if(ZM_CODEC_ID_MP3 == tEMediaAType)
    {
        pAudioUnit->eCodeID = ZM_CODEC_ID_MP3;
        pAudioUnit->uFrameUnit.t_MP3FrameUnit.u32BitRate                        = MP3_ENC_BITRATE;
        pAudioUnit->uFrameUnit.t_MP3FrameUnit.f64SampleRate                     = PCM_SAMPLE_RATE;      
        /*
        pAudioUnit->uFrameUnit.t_MP3FrameUnit.tMP3FrameHeader.sync1             = 0;//255;
        pAudioUnit->uFrameUnit.t_MP3FrameUnit.tMP3FrameHeader.error_protection  = 0;
        pAudioUnit->uFrameUnit.t_MP3FrameUnit.tMP3FrameHeader.layer             = 0;//1;
        pAudioUnit->uFrameUnit.t_MP3FrameUnit.tMP3FrameHeader.version           = 0;//3;
        pAudioUnit->uFrameUnit.t_MP3FrameUnit.tMP3FrameHeader.sync2             = 0;//7;
        pAudioUnit->uFrameUnit.t_MP3FrameUnit.tMP3FrameHeader.extension         = 0;//1;
        pAudioUnit->uFrameUnit.t_MP3FrameUnit.tMP3FrameHeader.padding           = 0;
        pAudioUnit->uFrameUnit.t_MP3FrameUnit.tMP3FrameHeader.sample_rate_index = 0;
        pAudioUnit->uFrameUnit.t_MP3FrameUnit.tMP3FrameHeader.bit_rate_index    = 0;//11;
        pAudioUnit->uFrameUnit.t_MP3FrameUnit.tMP3FrameHeader.emphasis          = 0;
        pAudioUnit->uFrameUnit.t_MP3FrameUnit.tMP3FrameHeader.original          = 0;
        pAudioUnit->uFrameUnit.t_MP3FrameUnit.tMP3FrameHeader.copyright         = 0;
        pAudioUnit->uFrameUnit.t_MP3FrameUnit.tMP3FrameHeader.mode_extension    = 0;
        pAudioUnit->uFrameUnit.t_MP3FrameUnit.tMP3FrameHeader.channel_mode      = 0;
        */
        pAudioUnit->uFrameUnit.t_MP3FrameUnit.eChannel            = ZMF_MP3_SINGLESTEREO;
        pAudioUnit->uFrameUnit.t_MP3FrameUnit.eLayer              = ZMF_MP3_LAYER1;
        pAudioUnit->uFrameUnit.t_MP3FrameUnit.eMpegVersion        = ZMF_MP3_MPEG1;
        pAudioUnit->uFrameUnit.t_MP3FrameUnit.u8Padding           = 0;
    }
    else
    {
        zOss_ASSERT(0);
    }

    return;
}

/**
 * ƣ Rec_DataSaveProcSaveMsg 
 *  ļ̴߳SaveϢ
 * ˵ (IN): 
 *   ֵ 
 * ˵ 
 */

static VOID Rec_DataSaveProcSaveMsg(VOID)
{
    UINT8           *pData        = NULL;
    SINT32           iRet         = -1;
    UINT32           uiTime       = 0;
    UINT32           uiDataLen    = 0;
    EZMFResultCode   eRet         = ZMF_RS_ERROR;
    T_ZMFOutPutUnit  tAudioUnit   = {0};

    /* ӻȡ */
    iRet = Rec_GetData(g_tRecConInfo.pDataList, (VOID **)&pData, &uiDataLen, &uiTime);
    if(iRet != REC_SUCCESS)
    {
        zMspCom_Print();
        g_tRecConInfo.iRecExp |= REC_OP_EXP;
        g_tRecConInfo.iRecExp |= REC_LIST_READ_EXP;
        
        return;
    }

    zOss_Memset(&tAudioUnit, 0, sizeof(T_ZMFOutPutUnit));

    /* ýļ֡Ԫ */
    Rec_DataSaveFrameUnitFill(g_tRecConInfo.tEMediaAType, pData, 
                              uiDataLen, uiTime, &tAudioUnit);    
 
    /* дļ */    
    eRet = WriteNextFrame(g_tRecConInfo.uiFileId, /*1,*/ &tAudioUnit);
    if(eRet != ZMF_RS_OK)
    {
        zOss_Free(pData);
        zMspCom_Print();
        g_tRecConInfo.iRecExp |= REC_OP_EXP;
        g_tRecConInfo.iRecExp |= REC_SAVE_FILE_EXP;

        return;
    }

    /* ͷű */
    zOss_Free(pData);

    return;
}

/**
 * ƣ Rec_DataSaveThreadEntry 
 *  ļ߳ں
 * ˵ (IN)iArg: ̲߳
 *   ֵ 
 * ˵ 
 */
static VOID Rec_DataSaveThreadEntry(SINT32 iArg)
{
    BOOL    bQuit  = FALSE;
    UINT32  uiMsg  = 0;
    SINT32  iRet   = -1;
    
    while(1)
    {
        /* Ϣ */
        iRet = zMspCom_RecvMsg(&uiMsg, ZOSS_WAIT_FOREVER);
        if(iRet != MSP_COM_OP_SUCCESS)
        {
            continue;
        }
        
        switch(uiMsg)
        {
            /* ݲɼ */
            case EV_REC_DATASAVE_ASYN:
            {
                Rec_DataSaveProcSaveMsg();
                
                break;
            }

            /* ʼ¼ */
            case EV_REC_START_SYN:
            {
                Rec_DataSaveProcStartMsg();

                /* ͷͬź֪ͨûռ */
                zOss_PutSemaphore(g_tRecConInfo.pSaveSem);
                
                break;
            }

            /* ֹͣ¼ */
            case EV_REC_STOP_SYN:
            {
                Rec_DataSaveProcStopMsg();

                /* ͷͬź֪ͨûռ */
                zOss_PutSemaphore(g_tRecConInfo.pSaveSem);
                
                break;
            }
            
            /* ر¼ */
            case EV_REC_CLOSE_SYN:
            {
                bQuit = TRUE;
                
                break;
            }
            
            default:
            {
                break;            
            }            
        }
        
        /* ͷϢԴ */
        uiMsg = 0;

        /* ˳Ϣѭ */
        if(bQuit)
        {
            break;
        }
    }

    /* ͷͬź֪ͨûռ */
    zOss_PutSemaphore(g_tRecConInfo.pSaveSem);

    return;
}

