/**************************************************************************
*
*                  Copyright (c) 2012 ZTE Corporation.
*
***************************************************************************
* ģ   : 
*    : oss_trace.c
* ļ : ose_trace.ctos_trace.c
* ʵֹ : ϲosetosϵͳļ
*      : zhangxiaofei
*      : V1.0
*  : 2012/10/19
* ˵ : 
**************************************************************************/

/**************************************************************************
* #include
**************************************************************************/
#ifdef _OS_TOS
#include <cyg/kernel/kapi.h>
#include <cyg/hal/hal_arch.h>
#include <cyg/hal/hal_intr.h>
#endif
#include "oss_api.h"

#ifdef __cplusplus
extern "C" 
{
#endif

/**************************************************************************
* ⲿ
**************************************************************************/
UINT32 oss_trace_get_time(VOID)   __attribute__((weak));
UINT64 oss_trace_get_time64(VOID) __attribute__((weak));
UINT32 oss_trace_get_ratio(VOID)  __attribute__((weak));

VOID oss_trace_thread_swapout(ZOSS_THREAD_ID thread) __attribute__((weak));
VOID oss_trace_thread_swapin(ZOSS_THREAD_ID thread) __attribute__((weak));

/**************************************************************************
* 궨
**************************************************************************/
#define OSS_TRACE_DEBUG
#ifdef OSS_TRACE_DEBUG
# define DBG(fmt, ...) do { zOss_Printf(SUBMDL_OSA, PRINT_LEVEL_NORMAL, fmt, ##__VA_ARGS__); } while (0);
#else    
# define DBG(fmt, ...)
#endif

#define OSS_TRACE_LOCK()    ZOSS_DISABLE_IRQ()
#define OSS_TRACE_UNLOCK()  ZOSS_ENABLE_IRQ()

#ifdef OSS_TRACE_THREAD
# define OSS_TRACE_THREAD_NUM       (100)
# define OSS_TRACE_THREAD_NAME_LEN  (63)
#endif

#ifdef OSS_TRACE_FUNC
# define OSS_TRACE_FUNC_NUM         (100)
#endif

/**************************************************************************
* ݽṹ
**************************************************************************/
#ifdef OSS_TRACE_THREAD
typedef struct
{
#ifdef _OS_OSE
    CHAR            thread_name[OSS_TRACE_THREAD_NAME_LEN + 1];
#elif defined (_OS_TOS)
    CHAR            *thread_name;
#endif
    ZOSS_THREAD_ID  thread_id;
    UINT32          tick;
} oss_trace_thread_t;
#endif

#ifdef OSS_TRACE_FUNC
typedef struct 
{
    SINT32              flag;
    CHAR                *func_name;
    ZOSS_THREAD_ID      trace_thread;
    ZOSS_THREAD_ID      execute_thread;
    UINT64              start_tick;
    UINT64              swapin_tick;
    UINT64              execute_tick;
    UINT64              consume_tick;
} oss_trace_func_t;
#endif

/**************************************************************************
* ֲԭ
**************************************************************************/
 
/**************************************************************************
* ȫֳ/
**************************************************************************/
#ifdef OSS_TRACE_THREAD
static SINT32               oss_trace_thread_swapout_flag                           = 0;
static UINT32               oss_trace_thread_swapout_count                          = 0;
static oss_trace_thread_t   oss_trace_thread_swapout_array[OSS_TRACE_THREAD_NUM]    = {0};

static SINT32               oss_trace_thread_swapin_flag                            = 0;
static UINT32               oss_trace_thread_swapin_count                           = 0;
static oss_trace_thread_t   oss_trace_thread_swapin_array[OSS_TRACE_THREAD_NUM]     = {0};
#ifdef _USE_MONITOR
T_ZOss_Mon_Event oss_trace_event_info = {0};
#endif

#endif
#ifdef OSS_TRACE_FUNC
static UINT32           oss_trace_func_count                                    = 0;
static oss_trace_func_t oss_trace_func_array[OSS_TRACE_FUNC_NUM]                = {0};
#endif

/**************************************************************************
* ֲʵ
**************************************************************************/

/**************************************************************************
* :     רж/̸߳ٵĻȡʱ亯32λ
* ˵:     
*   ()  void
*   ()  void
*   ֵ:     ǰʱֵ
* ˵:     void
**************************************************************************/
UINT32 oss_trace_get_time(VOID)
{
    return *(volatile UINT32 *)0xf4b00010;
}

/**************************************************************************
* :     רж/̸߳ٵĻȡʱ亯64λ
* ˵:     
*   ()  void
*   ()  void
*   ֵ:     ǰʱֵ
* ˵:     void
**************************************************************************/
UINT64 oss_trace_get_time64(VOID)
{
    return (UINT64)(*(UINT32 *)0xf4b00010) | ((UINT64)((*(UINT32 *)0xf4b0002c)&0xFFFFFF) << 32);
}

UINT32 oss_trace_get_ratio(VOID)
{
    /* ļʱ㷨ʹL1G52MʱӼ */
    return 52;
}

#ifdef OSS_TRACE_FUNC
/**************************************************************************
* :     tickus
* ˵:     
*   ()  tick:   δ
*   ()  void
*   ֵ:     ΢
* ˵:     void
**************************************************************************/
static DOUBLE oss_trace_func_tick_to_us(UINT64 tick)
{
    return (DOUBLE)((DOUBLE)tick / (DOUBLE)oss_trace_get_ratio());
}

/**************************************************************************
* :     ٺʼִСִй켣ʱʹõtickȡ
* ˵:     
*   ()  void
*   ()  void
*   ֵ:     ǰtickֵ
* ˵:     void
**************************************************************************/
#endif

/**************************************************************************
* ȫֺʵ
**************************************************************************/

#ifdef OSS_TRACE_THREAD
/**************************************************************************
* :     ̵߳ĸٹܣ
* ˵:     
*   ()  void
*   ()  void
*   ֵ:     void
* ˵:     void
**************************************************************************/
VOID oss_trace_thread_open(VOID)
{
    oss_trace_thread_swapout_flag  = 1;
    oss_trace_thread_swapin_flag   = 1;
#ifdef _USE_MONITOR    
    oss_trace_event_info.num = 0;
    if (oss_trace_event_info.ele == NULL)
    {
        oss_trace_event_info.ele = (T_ZOss_Mon_Event_Ele *)zOss_GetUB(OSS_MON_INFO_MAX_NUMBER * sizeof(T_ZOss_Mon_Event_Ele));
        zOss_AssertExN(oss_trace_event_info.ele != NULL);
    }
#endif
}

/**************************************************************************
* :     ر̵߳ĸٹܣ
* ˵:     
*   ()  void
*   ()  void
*   ֵ:     void
* ˵:     void
**************************************************************************/
VOID oss_trace_thread_close(VOID)
{
    oss_trace_thread_swapout_flag  = 0;
    oss_trace_thread_swapin_flag   = 0;
#ifdef _USE_MONITOR    
    oss_trace_event_info.num = 0;
    if (oss_trace_event_info.ele != NULL)
    {
        zOss_RetUB(oss_trace_event_info.ele);
        oss_trace_event_info.ele = NULL;
    }
#endif
}
#endif

#ifdef OSS_TRACE_FUNC
/**************************************************************************
* :     ̵߳г켣
* ˵:     
*   ()  thread:     г̵߳id
*   ()  void
*   ֵ:     void
* ˵:     void
**************************************************************************/
VOID oss_trace_thread_swapout(ZOSS_THREAD_ID thread)
{
    if (oss_trace_thread_swapout_flag) 
    {
# ifdef _OS_OSE
        zOss_GetThreadName(thread, (CHAR *)(oss_trace_thread_swapout_array[oss_trace_thread_swapout_count].thread_name));
# elif defined (_OS_TOS)
        oss_trace_thread_swapout_array[oss_trace_thread_swapout_count].thread_name	= zOss_GetThreadName(thread, NULL);
# endif
        oss_trace_thread_swapout_array[oss_trace_thread_swapout_count].thread_id    = thread;
        oss_trace_thread_swapout_array[oss_trace_thread_swapout_count].tick         = oss_trace_get_time();
        oss_trace_thread_swapout_count++;
        if (oss_trace_thread_swapout_count >= OSS_TRACE_THREAD_NUM)
        {
            oss_trace_thread_swapout_count = 0x00;
        }
        
#ifdef _USE_MONITOR 
        if (gOsa_MonitorFlag)
        {
            UINT32 cnt = oss_trace_event_info.num;
            
            oss_trace_event_info.ele[cnt].event        = OSS_MON_EVENT_THREAD_SWAPOUT;
# ifdef _OS_OSE
            zOss_GetThreadName(thread, oss_trace_event_info.ele[cnt].name);	
# elif defined (_OS_TOS)
            oss_trace_event_info.ele[cnt].name         = zOss_GetThreadName(thread, NULL);
# endif            
            oss_trace_event_info.ele[cnt].handle       = (UINT32)thread;
            oss_trace_event_info.ele[cnt].tickstamp    = oss_trace_get_time64();
            if (++cnt >= OSS_MON_INFO_MAX_NUMBER)
            {
                cnt = 0;
            }
            oss_trace_event_info.num = cnt;
        }
#endif
    }
}

/**************************************************************************
* :     ̵߳켣
* ˵:     
*   ()  thread:     ̵߳id
*   ()  void
*   ֵ:     void
* ˵:     void
**************************************************************************/
VOID oss_trace_thread_swapin(ZOSS_THREAD_ID thread)
{
    if (oss_trace_thread_swapin_flag) 
    {
# ifdef _OS_OSE
        zOss_GetThreadName(thread, (CHAR *)(oss_trace_thread_swapin_array[oss_trace_thread_swapin_count].thread_name));
# elif defined (_OS_TOS)
        oss_trace_thread_swapin_array[oss_trace_thread_swapin_count].thread_name    = zOss_GetThreadName(thread, NULL);
# endif
        oss_trace_thread_swapin_array[oss_trace_thread_swapin_count].thread_id      = thread;
        oss_trace_thread_swapin_array[oss_trace_thread_swapin_count].tick           = oss_trace_get_time();
        oss_trace_thread_swapin_count++;
        if (oss_trace_thread_swapin_count >= OSS_TRACE_THREAD_NUM)
        {
            oss_trace_thread_swapin_count = 0x00;
        }
        
#ifdef _USE_MONITOR 
        if (gOsa_MonitorFlag)
        {
            UINT32 cnt = oss_trace_event_info.num;
            
            oss_trace_event_info.ele[cnt].event        = OSS_MON_EVENT_THREAD_SWAPIN;
# ifdef _OS_OSE
            zOss_GetThreadName(thread, oss_trace_event_info.ele[cnt].name);	
# elif defined (_OS_TOS)
            oss_trace_event_info.ele[cnt].name         = zOss_GetThreadName(thread, NULL);
# endif
            oss_trace_event_info.ele[cnt].handle       = (UINT32)thread;
            oss_trace_event_info.ele[cnt].tickstamp    = oss_trace_get_time64();
            if (++cnt >= OSS_MON_INFO_MAX_NUMBER)
            {
                cnt = 0;                
            }
            oss_trace_event_info.num = cnt;
        }
#endif
    }
}

/**************************************************************************
* :     ̺߳Ŀʼִй켣
* ˵:     
*   ()  td_ptr: ָ(Trace Descriptor Pointer)
                func:   
*   ()  void
*   ֵ:     void
* ˵:     void
**************************************************************************/
VOID oss_trace_func_start(VOID **td_ptr, const CHAR *func)
{
    oss_trace_func_t *trace = NULL;
    
    zOss_AssertExN(td_ptr != NULL && func != NULL);
    
    if (*td_ptr == NULL) 
    {
        if (oss_trace_func_count >= OSS_TRACE_FUNC_NUM)
        {
            return;
        }
        
        OSS_TRACE_LOCK();
        trace = &oss_trace_func_array[oss_trace_func_count++];
        OSS_TRACE_UNLOCK();
        *((oss_trace_func_t **)td_ptr) = trace;
    } 
    else
    {
        trace = *((oss_trace_func_t **)td_ptr);
    }
    
    if (trace->flag) 
    {
        trace->func_name        = (CHAR *)func;
        trace->trace_thread     = zOss_GetCurThreadID();
        trace->execute_thread   = zOss_GetCurThreadID();
        trace->start_tick       = oss_trace_get_time64();
        trace->swapin_tick      = oss_trace_get_time64();
        trace->execute_tick     = 0x00;
        trace->consume_tick     = 0x00;
    }
}

/**************************************************************************
* :     ̺߳Ľִй켣
* ˵:     
*   ()  trace:  ٽṹָ
                func:   
*   ()  void
*   ֵ:     void
* ˵:     void
**************************************************************************/
VOID oss_trace_func_end(VOID *td)
{
    oss_trace_func_t *trace = NULL;
    
    if (td == NULL)
    {
        return;
    }
    
    trace = (oss_trace_func_t *)td;
    if (trace->flag) 
    {
        trace->execute_tick     += oss_trace_get_time64() - trace->swapin_tick;
        trace->consume_tick     = oss_trace_get_time64() - trace->start_tick;
        trace->execute_thread   = 0x00;
    }
}

/**************************************************************************
* :     ̺߳г켣
* ˵:     
*   ()  thread:     г̵߳id
*   ()  void
*   ֵ:     void
* ˵:     void
**************************************************************************/
VOID oss_trace_func_swapout(ZOSS_THREAD_ID thread)
{
    if (oss_trace_thread_swapout_flag)
    {
        UINT32              cnt     = 0;
        oss_trace_func_t *trace     = NULL;
        
        for (cnt = 0x00; cnt < oss_trace_func_count; cnt++) 
        {
            trace = &oss_trace_func_array[cnt];
            if (trace->flag && trace->execute_thread == thread)
            {
                trace->execute_tick += oss_trace_get_time64() - trace->swapin_tick;
            }
        }
    }
}

/**************************************************************************
* :     ̺߳켣
* ˵:     
*   ()  thread:     ̵߳id
*   ()  void
*   ֵ:     void
* ˵:     void
**************************************************************************/
VOID oss_trace_func_swapin(ZOSS_THREAD_ID thread)
{
    if (oss_trace_thread_swapin_flag)
    {
        UINT32              cnt     = 0;
        oss_trace_func_t    *trace  = NULL;
        
        for (cnt = 0x00; cnt < oss_trace_func_count; cnt++) 
        {
            trace = &oss_trace_func_array[cnt];
            if (trace->flag && trace->execute_thread == thread)
            {
                trace->swapin_tick = oss_trace_get_time64();
            }
        }
    }
}

#endif

/**************************************************************************
* :     ʼ̺߳ı־λ
* ˵:     
*   ()  void
*   ()  void
*   ֵ:     void
* ˵:     void
**************************************************************************/
VOID zOss_TraceFuncInit(VOID)
{
#ifdef OSS_TRACE_FUNC
    static SINT32 init_flag = 0;
    
    if (init_flag == 0) 
    {
        UINT32  cnt;
        
        OSS_TRACE_LOCK();
        for(cnt = 0x00; cnt < OSS_TRACE_FUNC_NUM; cnt++)
        {
            oss_trace_func_array[cnt].flag = 1;
        }
        init_flag = 1;
        OSS_TRACE_UNLOCK();
    }
#endif
}

/**************************************************************************
* :     ͳƸٺģļ¼Ϣ
* ˵:     
*   ()  func_name:  ƣΪգʾͳбٺļ¼Ϣ
                            ǿʾͳָĸϢ.
*   ()  void
*   ֵ:     void
* ˵:     void
**************************************************************************/
VOID zOss_TraceFuncInfo(CHAR *func_name)
{
#ifdef OSS_TRACE_FUNC
    UINT32  cnt                  = 0;
    UINT32  ignore               = 0;
    UINT32  ret                  = 0x00;
    UINT32  exec_cnt             = 0;
    UINT32  exec_times           = 0;
    UINT64  execute_tick         = 0;
    UINT64  consume_tick         = 0;
    CHAR    *execute_thread_name = NULL;
    CHAR    *trace_thread_name   = NULL; //add by zhangxiaofei 20121029
    
    DBG("%-30s%28s%28s%18s%22s%22s%22s%22s",
        "function_name",
        "trace_thread",
        "execute_thread",
        "execute_times",
        "execute_tick",
        "average_execute_tick",
        "consume_tick",
        "average_consume_tick");
    for (cnt = 0x00; cnt < oss_trace_func_count; cnt++) 
    {
        if (func_name)
        {
            ret = (UINT32 )strcmp((const char *)oss_trace_func_array[cnt].func_name, (const char *)func_name);
        }
        
        if (ret == 0x00 && oss_trace_func_array[cnt].func_name != NULL) 
        {
            ignore = 0;
            for (exec_cnt = 0x00; exec_cnt < cnt; exec_cnt++) 
            {
                if (oss_trace_func_array[exec_cnt].func_name != NULL &&
                    strcmp((const char *)oss_trace_func_array[cnt].func_name, (const char *)oss_trace_func_array[exec_cnt].func_name) == 0x00)
                { 
                    ignore = 1;
                }
            }
            
            if (ignore == 0) 
            {
                exec_times = 1;
                execute_tick = oss_trace_func_array[cnt].execute_tick;
                consume_tick = oss_trace_func_array[cnt].consume_tick;
                for (exec_cnt = cnt + 1; exec_cnt < oss_trace_func_count; exec_cnt++) 
                {
                    if (oss_trace_func_array[exec_cnt].func_name != NULL &&
                        strcmp((const char *)oss_trace_func_array[cnt].func_name, (const char *)oss_trace_func_array[exec_cnt].func_name) == 0x00) 
                    {
                        exec_times++;
                        execute_tick += oss_trace_func_array[exec_cnt].execute_tick;
                        consume_tick += oss_trace_func_array[exec_cnt].consume_tick;
                    }
                }

                if (oss_trace_func_array[cnt].trace_thread)
                {
# ifdef _OS_OSE
                    zOss_GetThreadName(oss_trace_func_array[cnt].trace_thread, (CHAR *)trace_thread_name);
# elif defined (_OS_TOS)
                    trace_thread_name    = zOss_GetThreadName(oss_trace_func_array[cnt].trace_thread, NULL);
# endif                                       
                }
                else
                {
                    trace_thread_name = (CHAR *)"function trace over!";
                }
                
                if (oss_trace_func_array[cnt].execute_thread)
                {
# ifdef _OS_OSE
                    zOss_GetThreadName(oss_trace_func_array[cnt].execute_thread, (CHAR *)execute_thread_name);
# elif defined (_OS_TOS)
                    execute_thread_name    = zOss_GetThreadName(oss_trace_func_array[cnt].execute_thread, NULL);
# endif                                         
                }
                else
                {
                    execute_thread_name = (CHAR *)"function execute over!";
                }
                DBG("%-30s%28s%28s%18d%22f%22f%22f%22f",
                    oss_trace_func_array[cnt].func_name,
                    trace_thread_name,                    
                    execute_thread_name,
                    exec_times,
                    oss_trace_func_tick_to_us(oss_trace_func_array[cnt].execute_tick),
                    oss_trace_func_tick_to_us(execute_tick / exec_times),
                    oss_trace_func_tick_to_us(oss_trace_func_array[cnt].consume_tick),
                    oss_trace_func_tick_to_us(consume_tick / exec_times));
            }
        }
    }
#endif
}

/**************************************************************************
* :     ȡϵͳ¼Ϣ
* ˵:     
*   ()  void:                             
*   ()  pMonEventInfo: ϵͳ¼Ĵŵַ 
*   ֵ:     void
* ˵:     void
**************************************************************************/
VOID z0ss_GetEventInfo(T_ZOss_Mon_Event *pMonEventInfo)
{
#if defined (OSS_TRACE_THREAD) && defined(_USE_MONITOR)
    if(pMonEventInfo)
    {
        *pMonEventInfo = oss_trace_event_info;
    }
#endif
}

#ifdef __cplusplus
}
#endif
