/**************************************************************************************************
*
*                       Copyright(c) 2012 ZTE Corporation 
*
***************************************************************************************************
* 汾: ͨѶɷ޹˾ ֻҵ 
* ģ  : OSٹUE
*   :
* ļʶ:
* ļ:
* ʵֹ:
*     :
*     :
* :
* ˵:
***************************************************************************************************/

/**************************************************************************************************
* ޸ļ¼:
*     :
*   :
*   :
*     :
***************************************************************************************************/

#ifndef OSINFOPACK_H
#define OSINFOPACK_H

#ifdef _USE_MONITOR
/**************************************************************************************************
* include
***************************************************************************************************/
#include "oss_api.h"
#include "oss_monitor.h"

/**************************************************************************************************
* 
***************************************************************************************************/
#define NUMERIC_LEN                    4
#define VERSION_LEN                    32
#define FILE_LEN                       128
#define THREAD_NAME_LEN                64
#define TASK_NAME_LEN                  64
#define EVENT_NAME_LEN                 64
#define TICKSTAMP_LEN                  8
#define MMU_NAME_LEN                   64
#define OWNER_NAME_LEN                 64
#define SENDER_NAME_LEN                64
#define RECEIVER_NAME_LEN              64
#define TIMER_EXPIRY_NUM               2
#define TIMER_EXPIRY_LEN               4
#define EVENT_NUM                      4
#define EVENT_LEN                      16
#define TASK_STATUS_NUM                4
#define TASK_STATUS_LEN                8
#define MMU_PERMISSION_NUM             6
#define MMU_PERMISSION_LEN             16
#define THREAD_STATUS_NUM              3
#define THREAD_STATUS_LEN              8

/**************************************************************************************************
* ݽṹ
***************************************************************************************************/
typedef struct
{
	char version[VERSION_LEN];
}T_Version;

typedef struct
{
	BYTE feq[NUMERIC_LEN];
}T_Frequency;

typedef struct
{
	BYTE load[NUMERIC_LEN];
}T_CpuLoad;

typedef struct
{
	BYTE size[NUMERIC_LEN];
	BYTE total[NUMERIC_LEN];
	BYTE used[NUMERIC_LEN];
	BYTE maxUsed[NUMERIC_LEN];
}T_Pool_Ele;

typedef struct
{
	BYTE address[NUMERIC_LEN];
	BYTE owner[NUMERIC_LEN];
	BYTE timeStamp[NUMERIC_LEN];
	char file[FILE_LEN];
	BYTE line[NUMERIC_LEN];
}T_Pool_Alloc_Ele, T_Pool_Leak_Ele;

typedef struct
{
    BYTE base[NUMERIC_LEN];
    BYTE size[NUMERIC_LEN];
    BYTE used[NUMERIC_LEN];
}T_Heap;

typedef struct//modified by zyn
{
    char name[THREAD_NAME_LEN];
    BYTE handle[NUMERIC_LEN];
    BYTE msg_no[NUMERIC_LEN];
    char status[THREAD_STATUS_LEN];
    BYTE priority[NUMERIC_LEN];
    BYTE stack_used[NUMERIC_LEN];
    BYTE stack_max_used[NUMERIC_LEN];
    BYTE cpu_load[NUMERIC_LEN];
	
}T_Thread_Ele;

typedef struct //modified by zyn
{
    char name[TASK_NAME_LEN];
    BYTE handle[NUMERIC_LEN];
    BYTE thread_handle[NUMERIC_LEN];
    char status[TASK_STATUS_LEN];
	
}T_Task_Ele;

typedef struct //modified by zyn
{
    char name[EVENT_NAME_LEN];
    char event[EVENT_LEN];
    BYTE handle[NUMERIC_LEN];
    BYTE tickstamp[TICKSTAMP_LEN];
	
}T_Event_Ele;

typedef struct
{
	BYTE msgId[NUMERIC_LEN];
    BYTE address[NUMERIC_LEN]; //ʼַ
	BYTE size[NUMERIC_LEN];    //
    char sender[SENDER_NAME_LEN];
    char receiver[RECEIVER_NAME_LEN];
    BYTE timestamp[NUMERIC_LEN];
}T_Msg_Ele;

typedef struct //modified by zyn
{
    BYTE handle[NUMERIC_LEN];
    BYTE start_time[NUMERIC_LEN];
    BYTE expire_time[NUMERIC_LEN];
    BYTE callback_func[NUMERIC_LEN];
    char is_period[TIMER_EXPIRY_LEN];
}T_Timer_Ele;

typedef struct
{
	char name[MMU_NAME_LEN];
    BYTE vir_addr[NUMERIC_LEN];
    BYTE phy_addr[NUMERIC_LEN];
    BYTE size[NUMERIC_LEN];
    char attr[MMU_PERMISSION_LEN]; /* permission and access */
}T_Mmu_Ele;

/**************************************************************************************************
* 
***************************************************************************************************/
VOID zOss_MonitorAgt_PackVersion(UINT8* code, T_ZOss_Mon_Version* version); 
VOID zOss_MonitorAgt_PackFrequency(UINT8* code, T_ZOss_Mon_Cpu_Frequency* frequency); 
VOID zOss_MonitorAgt_PackCpuLoad(UINT8* code, T_ZOss_Mon_Cpu_Load* cpuLoad); 
VOID zOss_MonitorAgt_PackPoolEle(UINT8* code, T_ZOss_Mon_Pool_Ele* pool_ele);
VOID zOss_MonitorAgt_PackPoolAllocEle(UINT8* code, T_ZOss_Mon_Pool_Alloc_Ele* pool_alloc_ele);
VOID zOss_MonitorAgt_PackPoolLeakEle(UINT8* code, T_ZOss_Mon_Pool_Leak_Ele* pool_leak_ele);
VOID zOss_MonitorAgt_PackHeap(UINT8* code, T_ZOss_Mon_Heap* heap);
VOID zOss_MonitorAgt_PackThreadEle(UINT8* code, T_ZOss_Mon_Thread_Ele* thread_ele);
VOID zOss_MonitorAgt_PackTaskEle(UINT8* code, T_ZOss_Mon_Task_Ele* task_ele);
VOID zOss_MonitorAgt_PackEventEle(UINT8* code, T_ZOss_Mon_Event_Ele* event_ele);
VOID zOss_MonitorAgt_PackMsgEle(UINT8* code, T_ZOss_Mon_Msg_Ele* msg_ele);
VOID zOss_MonitorAgt_PackTimerEle(UINT8* code, T_ZOss_Mon_Timer_Ele* timer_ele);
VOID zOss_MonitorAgt_PackMmuEle(UINT8* code, T_ZOss_Mon_Mmu_Ele* mmu_ele);

#endif
#endif

