/**************************************************************************************************
*
*                       Copyright(c) 2012 ZTE Corporation 
*
***************************************************************************************************
* 汾: ͨѶɷ޹˾ ֻҵ 
* ģ  : OSٹUE
*   :
* ļʶ:
* ļ:
* ʵֹ:
*     :
*     :
* :
* ˵:
***************************************************************************************************/

/**************************************************************************************************
* ޸ļ¼:
*     :
*   :
*   :
*     :
***************************************************************************************************/

#ifdef _USE_MONITOR
/**************************************************************************************************
* include
***************************************************************************************************/
#include "sup_agent_osinfopack.h"
#include "sup_agent_toolkit.h"

/**************************************************************************************************
* ݽṹ
***************************************************************************************************/
typedef struct
{
    UINT8 vistPermission;
    const CHAR* description;
}T_Mmu_VistPermission;

/**************************************************************************************************
* 
***************************************************************************************************/
#define NumericToByteArray(array, numeric) zOss_Memcpy(array, &numeric, sizeof(numeric))

static char s_timerExpiryTable[TIMER_EXPIRY_NUM][TIMER_EXPIRY_LEN] = {"no", "yes"};
static char s_eventTable[EVENT_NUM][EVENT_LEN] = {"thread swapin", 
                                                  "thread swapout", 
                                                  "dsr swapin",
                                                  "dsr swapout"};
static char s_taskStatusTable[TASK_STATUS_NUM][TASK_STATUS_LEN] = {"stop", 
                                                                   "idle", 
                                                                   "ready",
                                                                   "run"};

static T_Mmu_VistPermission s_mmuVistPermissionTable[] = { {1, "rw, nocache"}, 
                                                           {2, "ro, nocache"},
                                                           {9, "rw, writethrough"},
                                                           {10, "ro, writethrough"},
                                                           {13, "rw, writeback"},
                                                           {14, "ro, writeback"}};

static char s_threadStatusTable[THREAD_STATUS_NUM][THREAD_STATUS_LEN] = {"running", "ready", "waiting"};

/**************************************************************************************************

* ʵ

***************************************************************************************************/
static char* zOss_MonitorAgt_GetMmuPermissonDescription(UINT8 permission)
{
    int i = 0;
    for (i=0; i < MMU_PERMISSION_NUM; i++)
    {
        if (s_mmuVistPermissionTable[i].vistPermission == permission)
            return (char *)s_mmuVistPermissionTable[i].description;
    }

    return (char *)"";
}

VOID zOss_MonitorAgt_PackVersion(UINT8* code, T_ZOss_Mon_Version* version)
{
    T_Version packVersion = {0};
    zOss_MonitorAgt_CharToByteArray(packVersion.version, version->version, VERSION_LEN);
    NumericToByteArray(code, packVersion);
}

VOID zOss_MonitorAgt_PackFrequency(UINT8* code, T_ZOss_Mon_Cpu_Frequency* frequency)
{
    T_Frequency packFreq = {0};
    //memcpy(packFreq.feq, &frequency->frequency, sizeof(frequency->frequency));
    NumericToByteArray(packFreq.feq, frequency->frequency);
    NumericToByteArray(code, packFreq);
}

VOID zOss_MonitorAgt_PackCpuLoad(UINT8* code, T_ZOss_Mon_Cpu_Load* cpuLoad)
{
    T_CpuLoad packCpuLoad = {0};
    NumericToByteArray(packCpuLoad.load, cpuLoad->load);
    NumericToByteArray(code, packCpuLoad);
}

VOID zOss_MonitorAgt_PackPoolEle(UINT8* code, T_ZOss_Mon_Pool_Ele* pool_ele)
{
    T_Pool_Ele packPoolEle = {0};
    NumericToByteArray(packPoolEle.size, pool_ele->size);
    NumericToByteArray(packPoolEle.total, pool_ele->total);
    NumericToByteArray(packPoolEle.used, pool_ele->used);
    NumericToByteArray(packPoolEle.maxUsed, pool_ele->max_used);
    NumericToByteArray(code, packPoolEle);
}

VOID zOss_MonitorAgt_PackPoolAllocEle(UINT8* code, T_ZOss_Mon_Pool_Alloc_Ele* pool_alloc_ele)
{
    T_Pool_Alloc_Ele packPoolAllocEle = {0};
    NumericToByteArray(packPoolAllocEle.address, pool_alloc_ele->addr);
    NumericToByteArray(packPoolAllocEle.owner, pool_alloc_ele->owner);
    NumericToByteArray(packPoolAllocEle.timeStamp, pool_alloc_ele->timestamp);
    zOss_MonitorAgt_FileNameToByteArray(packPoolAllocEle.file, pool_alloc_ele->file, FILE_LEN);
    NumericToByteArray(packPoolAllocEle.line, pool_alloc_ele->line);
    NumericToByteArray(code, packPoolAllocEle);
}

VOID zOss_MonitorAgt_PackPoolLeakEle(UINT8* code, T_ZOss_Mon_Pool_Leak_Ele* pool_leak_ele)
{
    T_Pool_Leak_Ele packPoolLeakEle = {0};
    NumericToByteArray(packPoolLeakEle.address, pool_leak_ele->addr);
    NumericToByteArray(packPoolLeakEle.owner, pool_leak_ele->owner);
    NumericToByteArray(packPoolLeakEle.timeStamp, pool_leak_ele->timestamp);
    zOss_MonitorAgt_FileNameToByteArray(packPoolLeakEle.file, pool_leak_ele->file, FILE_LEN);
    NumericToByteArray(packPoolLeakEle.line, pool_leak_ele->line);
    NumericToByteArray(code, packPoolLeakEle);
}

VOID zOss_MonitorAgt_PackHeap(UINT8* code, T_ZOss_Mon_Heap* heap)
{
    T_Heap packHeap = {0};
    NumericToByteArray(packHeap.base, heap->base);
    NumericToByteArray(packHeap.size, heap->size);
    NumericToByteArray(packHeap.used, heap->used);
    NumericToByteArray(code, packHeap);
}

VOID zOss_MonitorAgt_PackThreadEle(UINT8* code, T_ZOss_Mon_Thread_Ele* thread_ele)
{
    T_Thread_Ele packThreadEle = {0};
    NumericToByteArray(packThreadEle.handle, thread_ele->handle);
    NumericToByteArray(packThreadEle.msg_no, thread_ele->msg_num);
    zOss_MonitorAgt_CharToByteArray(packThreadEle.status, s_threadStatusTable[thread_ele->status/2], THREAD_STATUS_LEN);
    NumericToByteArray(packThreadEle.priority, thread_ele->priority);
    NumericToByteArray(packThreadEle.stack_used, thread_ele->stack_used);
    NumericToByteArray(packThreadEle.stack_max_used, thread_ele->stack_max_used);
    NumericToByteArray(packThreadEle.cpu_load, thread_ele->cpu_load);
    zOss_MonitorAgt_CharToByteArray(packThreadEle.name, thread_ele->name, THREAD_NAME_LEN);
    NumericToByteArray(code, packThreadEle);
}

VOID zOss_MonitorAgt_PackTaskEle(UINT8* code, T_ZOss_Mon_Task_Ele* task_ele)
{
    T_Task_Ele packTaskEle = {0};
    NumericToByteArray(packTaskEle.handle, task_ele->handle);
    NumericToByteArray(packTaskEle.thread_handle, task_ele->thread_handle);
    zOss_MonitorAgt_CharToByteArray(packTaskEle.status, s_taskStatusTable[task_ele->status - 1], TASK_STATUS_LEN);
    zOss_MonitorAgt_CharToByteArray(packTaskEle.name, task_ele->name, TASK_NAME_LEN);
    NumericToByteArray(code, packTaskEle);
}

VOID zOss_MonitorAgt_PackEventEle(UINT8* code, T_ZOss_Mon_Event_Ele* event_ele)
{
    T_Event_Ele packEventEle = {0};
    zOss_MonitorAgt_CharToByteArray(packEventEle.event, s_eventTable[event_ele->event], EVENT_LEN);
    NumericToByteArray(packEventEle.handle, event_ele->handle);
    NumericToByteArray(packEventEle.tickstamp, event_ele->tickstamp);
    zOss_MonitorAgt_CharToByteArray(packEventEle.name, event_ele->name, EVENT_NAME_LEN);
    NumericToByteArray(code, packEventEle);
}

VOID zOss_MonitorAgt_PackMsgEle(UINT8* code, T_ZOss_Mon_Msg_Ele* msg_ele)
{
    T_Msg_Ele packMsgEle = {0};
    NumericToByteArray(packMsgEle.msgId, msg_ele->msgId);
    NumericToByteArray(packMsgEle.address, msg_ele->ptr);
    NumericToByteArray(packMsgEle.size, msg_ele->size);
    zOss_MonitorAgt_CharToByteArray(packMsgEle.sender, msg_ele->sender, SENDER_NAME_LEN);
    zOss_MonitorAgt_CharToByteArray(packMsgEle.receiver, msg_ele->receiver, RECEIVER_NAME_LEN);
    NumericToByteArray(packMsgEle.timestamp, msg_ele->timestamp);
    NumericToByteArray(code, packMsgEle);
}

VOID zOss_MonitorAgt_PackTimerEle(UINT8* code, T_ZOss_Mon_Timer_Ele* timer_ele)
{
    T_Timer_Ele packTimerEle = {0};
    NumericToByteArray(packTimerEle.start_time, timer_ele->start_time);
    NumericToByteArray(packTimerEle.expire_time, timer_ele->expire_time);
    NumericToByteArray(packTimerEle.callback_func, timer_ele->callback_func);
    zOss_MonitorAgt_CharToByteArray(packTimerEle.is_period, s_timerExpiryTable[timer_ele->is_period], TIMER_EXPIRY_LEN);
    NumericToByteArray(packTimerEle.handle, timer_ele->handle);
    NumericToByteArray(code, packTimerEle);
}

VOID zOss_MonitorAgt_PackMmuEle(UINT8* code, T_ZOss_Mon_Mmu_Ele* mmu_ele)
{
    T_Mmu_Ele packMmuEle = {0};
    NumericToByteArray(packMmuEle.vir_addr, mmu_ele->vir_addr);
    NumericToByteArray(packMmuEle.phy_addr, mmu_ele->phy_addr);
    NumericToByteArray(packMmuEle.size, mmu_ele->size);
    zOss_MonitorAgt_CharToByteArray(packMmuEle.attr, zOss_MonitorAgt_GetMmuPermissonDescription(mmu_ele->attr), MMU_PERMISSION_LEN);
    zOss_MonitorAgt_CharToByteArray(packMmuEle.name, mmu_ele->name, MMU_NAME_LEN);
    NumericToByteArray(code, packMmuEle);
}

#endif


