/**************************************************************************
*
*                  Copyright (c) 2012 ZTE Corporation.
*
***************************************************************************
* ģ   : P98C_OSS
*    : sup_shell.c
* ļ : 
* ʵֹ : shellʵļ
*      : ܹ
*      : V1.0
*  : 2008-04-21
* ˵ : 
**************************************************************************/

/**************************************************************************
* ޸ļ¼
**************************************************************************/
/**************************************************************************
* ޸ı : 0001
*    : chenxingfang
* ޸ : 2012-09-17
* ޸ : ʽ淶PC-LINT߲ EC:617001782014
**************************************************************************/
/**************************************************************************
* ޸ı : 0002
*    : chenxingfang
* ޸ : 2012-09-27
* ޸ : ߲ EC:617001782003
**************************************************************************/

/**************************************************************************
* #include
**************************************************************************/
#include "sup_shell_cmd.h"
#include "drv_api.h"
#include "commgt_api.h"

#ifdef __cplusplus
extern "C"
{
#endif

/**************************************************************************
* 궨
**************************************************************************/
#ifndef _OS_WIN
#ifndef stricmp
#define stricmp strcasecmp
#endif

#ifndef strnicmp
#define strnicmp strncasecmp
#endif
#endif

#define EV_ZOSS_SHELL_COMM_CMD  1000
#define SHELL_MAX_DYNAMIC_CMD   100

#define SHELL_ISNUMBER(x)       ((x) >= '0' && (x) <= '9')
#define SHELL_ISHEXNUMBER(x)    (SHELL_ISNUMBER((x)) || ((x) >= 'a' && (x) <= 'f') || ((x) >= 'A' && (x) <= 'F'))
#define SHELL_ISIDENTIFIER(x)   (SHELL_ISNUMBER((x)) || ((x) >= 'a' && (x) <= 'z') || ((x) >= 'A' && (x) <= 'Z') || (x) == '_')

/**************************************************************************
* ݽṹ
**************************************************************************/
 
/**************************************************************************
* ֲԭ
**************************************************************************/
VOID Shell_TaskEntry(UINT8 state, UINT32 msg_id, UINT8 *buf, UINT16 msg_len, UINT8 *private_data);

static SINT32 Shell_findCmd(CHAR *cmd);
static VOID ShellHelpProcess(T_Shell_CommandMessage *CmdMsg);
static UINT32 Shell_FindDynamicCmd(const CHAR *cmd);
static VOID Shell_help(T_Shell_CommandMessage *pCmdMsg);
static VOID Shell_MessageDivide(T_Shell_CommandMessage *msg);
static UINT32 Shell_Process(T_Shell_CommandMessage *CmdMsg);
static VOID Shell_CommCallBack(UINT32 msgID, const UINT8 *msg, UINT16 msgLen);
static UINT32 Shell_ParseMessageFromCommData(T_Shell_CommandMessage *CmdMsg, const UINT8 *buf, UINT32 bufLen);

/**************************************************************************
* ȫֳ/
**************************************************************************/ 
ZOSS_THREAD_ID  gShellTaskID                = NULL;     /* ȫֵshell ID   */
static UINT32   gShell_WintracePrintFlag    = 1;

/*  */
static T_Shell_Cmd gShell_Cmds[] =
{
    /*                      ں                                      ˵                                    */
    
    {(CHAR *)"help",                (Shell_Func)Shell_help,                       (CHAR *)"ṩSHELLİϢ"       },
#ifdef _USE_OSS_SHELL_MISC
    /*  */
    {(CHAR *)"bootInfo",            (Shell_Func)OSS_DbgShowBootInfo,              (CHAR *)"ʾϢ"                  },
    {(CHAR *)"threadSuspend",       (Shell_Func)OSS_DbgSuspendThread,             (CHAR *)"߳"                      },
    {(CHAR *)"threadResume",        (Shell_Func)OSS_DbgResumeThread,              (CHAR *)"ָ߳"                      },
    {(CHAR *)"setThreadPrior",      (Shell_Func)OSS_DbgSetThreadPri,              (CHAR *)"ı߳ȼ"                },
    {(CHAR *)"showMsg",             (Shell_Func)OSS_DbgShowMsg,                   (CHAR *)"ʾ/رϢ"             },
    {(CHAR *)"showReg",             (Shell_Func)OSS_DbgShowRegInfo,               (CHAR *)"ȡĴϢ"                },
    {(CHAR *)"ramdumpConfigRegion", (Shell_Func)OSS_DbgRamdumpConfigRegionInfo,   (CHAR *)"Ҫڴ"        },
    {(CHAR *)"showProcSig",         (Shell_Func)Shell_ShowProcSig,                (CHAR *)"ʾ߳signalʹ"        },
    {(CHAR *)"forceRamdump",        (Shell_Func)OSA_ForceRamdump,                 (CHAR *)"쳣ǿramdump"           },
    {(CHAR *)"reboot",              (Shell_Func)OSS_DbgReboot,                    (CHAR *)""                          },
    {(CHAR *)"setWintracePrint",    (Shell_Func)OSS_DbgSetWintracePrintFlag,      (CHAR *)"򿪹رwintraceӡ"          },
    {(CHAR *)"trace",               (Shell_Func)OSA_DbgTrace,                     (CHAR *)"鿴ģϢ"              },
    {(CHAR *)"profile",             (Shell_Func)OSS_DbgProfile,                   (CHAR *)"gmon.outдļϵͳ"        },
    {(CHAR *)"openTraceSwitch",     (Shell_Func)OSS_OpenTraceSwitch,              (CHAR *)"жϺ̵߳ĸϢ"  },
    {(CHAR *)"setAssertLevel",      (Shell_Func)OSS_SetAssertLevel,               (CHAR *)"ں˶ԵԼ"          },
#endif
#ifdef _USE_OSS_SHELL_MEM
    /* ڴ۲ */
    {(CHAR *)"mem",                 (Shell_Func)OSS_DbgShowMemInfo,               (CHAR *)"ӡϵͳڴϢ"              }, 
    {(CHAR *)"ub",                  (Shell_Func)OSS_DbgShowUbInfo,                (CHAR *)"ӡϵͳڴϢ"          },
    {(CHAR *)"threadUB",            (Shell_Func)OSS_DbgShowThreadUbInfo,          (CHAR *)"ӡ̵ָ߳UBϢ"          },
    {(CHAR *)"taskUB",              (Shell_Func)OSS_DbgShowTaskUbInfo,            (CHAR *)"ӡָUBϢ"          },
    {(CHAR *)"showPoolInfo",        (Shell_Func)Shell_ShowPoolInfo,               (CHAR *)"ʾpoolϢ"                  },
    {(CHAR *)"opendbgub",           (Shell_Func)OSA_SetUBDbgSwitch,               (CHAR *)"ubԿ"                },
    {(CHAR *)"checkUb",             (Shell_Func)OSA_DbgUbInfo,                    (CHAR *)"ubϢ"                    },
    {(CHAR *)"showMem",             (Shell_Func)OSS_DbgGetMem,                    (CHAR *)"鿴ڴϢ"                  },
    {(CHAR *)"setMem",              (Shell_Func)OSS_DbgSetMem,                    (CHAR *)"޸ڴϢ"                  },
    {(CHAR *)"checkMem",            (Shell_Func)OSA_DbgMemInfo,                   (CHAR *)"memʹϢ(й¶Խ)" },
    {(CHAR *)"checkLeakMem",        (Shell_Func)OSA_DbgMemTimeLeakInfo,           (CHAR *)"ĳʱMemй¶Ϣ" },
#endif
#ifdef _USE_OSS_SHELL_THREAD
    /* ͨѶ */
    {(CHAR *)"threadInfo",          (Shell_Func)OSS_DbgShowThreadInfo,            (CHAR *)"鿴߳Ϣ"                  },
    {(CHAR *)"taskInfo",            (Shell_Func)OSS_DbgShowTaskInfo,              (CHAR *)"ӡϵͳϢ"          },
    {(CHAR *)"threadCpu",           (Shell_Func)OSS_DbgDisplayThreadExecInfo,     (CHAR *)"ʾĳ̵ִ߳ʱ"        },
    {(CHAR *)"threadsCpu",          (Shell_Func)OSS_DbgDisplayThreadsExecInfo,    (CHAR *)"ʾ̵ִ߳ʱ"        },
    {(CHAR *)"threadSwapflag",      (Shell_Func)OSS_DbgThreadSetFlag,             (CHAR *)"ر/򿪼¼߳CPUʱ俪"  },
    {(CHAR *)"syscpu",              (Shell_Func)OSS_DbgGetSysCPU,                 (CHAR *)"ϵͳCPUռ"             },
    {(CHAR *)"setUpdateCpuTime",    (Shell_Func)OSS_DbgSetUpdateCPUTime,          (CHAR *)"CPUʹˢʱ"         },
    {(CHAR *)"startDaemonTask",     (Shell_Func)OSS_StartDaemonTask,              (CHAR *)"ѭ"            },    
#endif

#ifdef _USE_OSS_SHELL_PSM
#ifdef _USE_PSM
    {(CHAR *)"psminfo",             (Shell_Func)OSS_PsmTraceInfo,                 (CHAR *)"psmϢ"               },
#ifdef _USE_CPU_DFM
    {(CHAR *)"dfmifno",             (Shell_Func)OSS_DfmTraceInfo,                 (CHAR *)"dfmϢ"               },
#endif
#endif
#endif
};

static T_Shell_Cmd gShell_DynamicCmds[SHELL_MAX_DYNAMIC_CMD] = { 0 };

/**************************************************************************
* ȫֺʵ
**************************************************************************/

/**************************************************************************
* ƣShell_TaskEntry
* SHELLں
* ˵
*   ֵ
* ˵
**************************************************************************/
VOID Shell_TaskEntry(UINT8 state, UINT32 msg_id, UINT8 *buf, UINT16 msg_len, UINT8 *private_data)
{
    UINT32 status = ZOSS_ERROR;
    
    switch (state)
    {
    case ZOSS_STATUS_INIT:
        {
            switch (msg_id)
            {
            case EV_INIT:
                {
                    break;
                }
            case EV_POWERON:
                {
                    gShellTaskID = zOss_GetSelfTaskID();
                    /* ͨѶģעᵱǰģ */
                    #ifdef _USE_WINCOMM_SERVER
                    status = zTools_CommReg(SUBMDL_SHELL, ZDRV_DEV_USBSIO_2, (ModuleFunc)Shell_CommCallBack);
                    #else
                    status = zOss_CommReg(SUBMDL_SHELL, ZDRV_DEV_USBSIO_2, Shell_CommCallBack);
                    #endif
                    if (status != ZOSS_SUCCESS)
                    {
                        zOss_ASSERT(0);
                        zOss_Printf(SUBMDL_SHELL, PRINT_LEVEL_ABNORMAL, "SHELL_POWERON:Fail to register submodule!");
                        break;
                    }
                    status = zOss_SetState(ZOSS_STATUS_WORK);
                    if (status != ZOSS_SUCCESS)
                    {
                        zOss_ASSERT(0);
                        zOss_Printf(SUBMDL_SHELL, PRINT_LEVEL_ABNORMAL, "SHELL_POWERON:Fail to set state!");
                        break;
                    }
                    
                    break;
                }
            default:
                {
                    zOss_Printf(SUBMDL_SHELL, PRINT_LEVEL_ABNORMAL, "SHELL:Receive a invalid message");
                    break;
                }
            }
            break;
        }
    case ZOSS_STATUS_WORK:
        {
            switch (msg_id)
            {
            case EV_ZOSS_SHELL_COMM_CMD:
                {
                    T_Shell_CommandMessage cmdMsg = {0};
                    
                    /* ӽյݷ */
                    if (ZOSS_SUCCESS == Shell_ParseMessageFromCommData(&cmdMsg, (UINT8 *)buf, msg_len))
                    {
                        /* ִв */
                        Shell_MessageDivide(&cmdMsg);
                    }
                    
                    break;
                }
            default:
                {
                    zOss_Printf(SUBMDL_SHELL, PRINT_LEVEL_ABNORMAL, "SHELL:Receive a invalid message");
                    break;
                }
            }    
            break;
        }
    default:
        break;
    }
}

/**************************************************************************
* ƣzOss_AddShellCmd
* Ӷ̬
* ˵(IN)
            cmd:ַ,Ϊ
            func:ִк,ΪNULL
            description:,ΪNULL
            (OUT)
*   ֵɹZOSS_SUCCESS,ʧܷZOSS_ERROR
* ˵εú,ͬcmd_name,õĻḲǰõ
**************************************************************************/
UINT32 zOss_AddShellCmd(const CHAR *cmd_name, const Shell_Func func, const CHAR *description)
{
    UINT32 i            = 0;
    UINT32 name_size    = 0;
    UINT32 desc_size    = 0;
    
    zOss_AssertEx((NULL != cmd_name) && (func != NULL), ZOSS_ERROR);
    
    i = Shell_FindDynamicCmd(cmd_name);
    zOss_AssertEx(i < SHELL_MAX_DYNAMIC_CMD, ZOSS_ERROR);
    
    name_size = strlen((char *)cmd_name);
    if (NULL != description)
    {
        desc_size = strlen((char *)description);
    }
    
    if (NULL != gShell_DynamicCmds[i].cmd)
    {
        zOss_Free(gShell_DynamicCmds[i].cmd);
        zOss_Free(gShell_DynamicCmds[i].desc);
        gShell_DynamicCmds[i].cmd = NULL;
        gShell_DynamicCmds[i].func = NULL;
        gShell_DynamicCmds[i].desc = NULL;
    }
    
    gShell_DynamicCmds[i].cmd = (CHAR *)zOss_Malloc(name_size + 1);
    if (NULL == gShell_DynamicCmds[i].cmd)
    {
        return ZOSS_ERROR;
    }
    zOss_Memset(gShell_DynamicCmds[i].cmd, 0, name_size + 1);
    zOss_Memcpy(gShell_DynamicCmds[i].cmd, cmd_name, name_size);
    
    gShell_DynamicCmds[i].desc = (CHAR *)zOss_Malloc(desc_size + 1);    /* descΪNULL,1ַռ */
    if (NULL == gShell_DynamicCmds[i].desc)
    {
        zOss_Free(gShell_DynamicCmds[i].cmd);
        gShell_DynamicCmds[i].cmd = NULL;
        return ZOSS_ERROR;
    }
    zOss_Memset(gShell_DynamicCmds[i].desc, 0, desc_size + 1);
    if (0 != desc_size)
    {
        zOss_Memcpy(gShell_DynamicCmds[i].desc, description, desc_size);
    }
    
    gShell_DynamicCmds[i].func = func;
    
    return ZOSS_SUCCESS;
}

UINT32 Shell_GetWintracePrintFlag(VOID)
{
    return gShell_WintracePrintFlag;
}

UINT32 Shell_SetPrintFlag(UINT32 WintraceFlag)
{
    zOss_AssertEx(WintraceFlag < 2 , ZOSS_ERROR);

    gShell_WintracePrintFlag = WintraceFlag;     

    return ZOSS_SUCCESS;
}

/**************************************************************************
* ƣShell_StrisNumber
* ַǷȫ
* ˵(IN)
            pStr:ַָ
            (OUT)
*   ֵ0ʾȫ֣-1ʾ
* ˵֧10ƺ16ƣ16Ҫ0x0Xǰ׺
**************************************************************************/
SINT32 Shell_StrisNumber(const CHAR *pStr)
{
    const CHAR *tmp = NULL;
    
    zOss_AssertEx(pStr != NULL, (SINT32)ZOSS_ERROR);
    tmp = pStr;
    if (0 == strnicmp((char *)tmp, "0x", 2))
    {
        tmp = pStr + 2;
        while ('\0' != *tmp)
        {
            if (!SHELL_ISHEXNUMBER(*tmp))
            {
                return -1;
            }
            tmp++;
        }
    }
    else
    {
        while ('\0' != *tmp)
        {
            if (!SHELL_ISNUMBER(*tmp))
            {
                return -1;
            }
            tmp++;
        }
    }
    return 0;
}

/**************************************************************************
* ƣShell_isIdentifier
* ַǷȫ,ĸ»ߵ
* ˵(IN)
            Str:ַָ
            (OUT)
*   ֵ0ʾȫ,ĸ»ϣ-1ʾǷַ
* ˵
**************************************************************************/
SINT32 Shell_isIdentifier(const CHAR *pStr)
{
    const CHAR *tmp = NULL;
        
    zOss_AssertEx(pStr != NULL, (SINT32)ZOSS_ERROR);
    tmp = pStr;

    while ('\0' != *tmp)
    {
        if (!SHELL_ISIDENTIFIER(*tmp))
        {
            return -1;
        }
        tmp++;
    }
    return 0;
}

/**************************************************************************
* ֲʵ
**************************************************************************/
/**************************************************************************
* ƣShell_CommCallBack
* Shellص
* ˵(IN)
            msgID:  ϢID
            msg:    յϢ
            msgLen: յϢ
            (OUT)
*   ֵ
* ˵
**************************************************************************/
static VOID Shell_CommCallBack(UINT32 msgID, const UINT8 *msg, UINT16 msgLen)
{
    UINT32  RetCode         = 0;
    UINT8   *pCmdMsgBuff    = NULL;
    
    if (msgLen == 0 || msg == NULL)
    {
        return;
    }
    
    pCmdMsgBuff = (UINT8 *)zOss_GetUB(msgLen);           /* ȥϢͷ */
    if (NULL == pCmdMsgBuff)
    {
        return;
    }
    zOss_Memcpy((VOID *)pCmdMsgBuff, msg, msgLen);
    RetCode = zOss_TaskSend(EV_ZOSS_SHELL_COMM_CMD, pCmdMsgBuff, msgLen, gShellTaskID);   
    zOss_ASSERT(RetCode == ZOSS_SUCCESS);
    
    RetCode = zOss_RetUB(pCmdMsgBuff);
    zOss_ASSERT(RetCode == ZOSS_SUCCESS);
}

/***************************************************************************
* ƣShell_ParseMessageFromCommData
* յBUFFERн
* ˵(IN)
            uf:ݻ
            ufLen:ݻĳ
            (OUT)
*   ֵĽṹ
* ˵ڲӿ
*****************************************************************************/
static UINT32 Shell_ParseMessageFromCommData(T_Shell_CommandMessage *CmdMsg, const UINT8 *buf, UINT32 bufLen)
{
    UINT32      i           = 0;
    UINT16      offset      = 0;
    UINT32      strLen      = 0;
    const CHAR  *pStr       = NULL;
    
    zOss_AssertEx(NULL != CmdMsg && NULL != buf, ZOSS_ERROR);
    
    /* ʼ */
    zOss_Memset(CmdMsg, 0, sizeof(T_Shell_CommandMessage));
    CmdMsg->paraCount = (UINT32)buf[0];
    offset = 1;
    pStr = (CHAR *)&buf[offset];
    strLen = strlen((char *)pStr);
    strncpy((char *)CmdMsg->cmd, (char *)pStr, strLen > SHELL_CMD_LENGTH ? SHELL_CMD_LENGTH : strLen);  /* ȡ */
    
    /*  */
    offset += (UINT16)strLen + 1;      /* ȣ+1'\0' */
    while ((offset < bufLen) && (i < SHELL_CMD_PARAM_NUM))
    {
        pStr = (CHAR *)&buf[offset];
        strLen = strlen((char *)pStr);
        strncpy((char *)CmdMsg->para[i], (char *)pStr, strLen > SHELL_CMD_PARAM_LENGTH ? SHELL_CMD_PARAM_LENGTH : strLen); /* ȡ */
        offset += (UINT16)strLen + 1;    /* +1'\0' */
        i++;
    }
    return ZOSS_SUCCESS;
}

/***************************************************************************
* ƣShell_MessageDivide
* ַ:TESTģSHELLģ
* ˵(IN)
            msgϢṹ
            (OUT)
*   ֵ
* ˵ڲӿ
*****************************************************************************/
static VOID Shell_MessageDivide(T_Shell_CommandMessage *msg)
{
    zOss_AssertExN(NULL != msg);
    
    if (ZOSS_ERROR == Shell_Process(msg))       
    {
        ShellHelpProcess(msg);
    }
}

/**************************************************************************
* ƣShell_Process
* Shell
* ˵(IN)
            CmdMsg:ṹָ
            (OUT)
*   ֵҵִзZOSS_SUCCESSҲZOSS_ERROR
* ˵
**************************************************************************/
static UINT32 Shell_Process(T_Shell_CommandMessage *CmdMsg)
{
    SINT32  cmd_count   = 0;
    SINT32  i           = 0;
    
    zOss_AssertEx(CmdMsg != NULL, ZOSS_ERROR);
    
    cmd_count = sizeof(gShell_Cmds) / sizeof(gShell_Cmds[0]);
    i = Shell_findCmd(CmdMsg->cmd);     /* ƥ */
    
    if (i >= 0 && i < cmd_count)
    {
        gShell_Cmds[i].func(CmdMsg);    /* ִ     */
        return ZOSS_SUCCESS;
    }
    
    i = (SINT32)Shell_FindDynamicCmd(CmdMsg->cmd);        
    if (i < SHELL_MAX_DYNAMIC_CMD)
    {
        if (NULL != gShell_DynamicCmds[i].cmd)
        {
            gShell_DynamicCmds[i].func(CmdMsg);
            return ZOSS_SUCCESS;
        }
    }
    
    return ZOSS_ERROR;
}

/**************************************************************************
* ƣShell_findCmd
* 
* ˵(IN)
            cmd:ַ
            (OUT)
*   ֵҵ˷λãҲ-1
* ˵
**************************************************************************/
static SINT32 Shell_findCmd(CHAR *cmd)
{
    SINT32 cmd_count    = 0;
    SINT32 i            = 0;
    
    zOss_AssertEx(cmd != NULL, -1);
    cmd_count = sizeof(gShell_Cmds) / sizeof(gShell_Cmds[0]);
    for (i = 0; i < cmd_count; i++)
    {
        if (0 == stricmp((char *)cmd, (char *)gShell_Cmds[i].cmd))
        {
            zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_NORMAL, "\t%-60s ", "***********************************************************************");
            zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_NORMAL, "\t%-20s %s", "* :", gShell_Cmds[i].desc);
            zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_NORMAL, "\t%-20s ", "*ƽ̨֧ṩù");
            zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_NORMAL, "\t%-60s ", "***********************************************************************");
            return i;
        }
    }
    return -1;
}

/**************************************************************************
* ƣShell_FindDynamicCmd
* Ҷ̬
* ˵(IN)
            cmd:ַ
            (OUT)
*   ֵҵ˷λãҲһյλ
* ˵
**************************************************************************/
static UINT32 Shell_FindDynamicCmd(const CHAR *cmd)
{
    UINT32 i = 0;
    
    zOss_AssertEx(NULL != cmd, 0);
    for (i = 0; i < SHELL_MAX_DYNAMIC_CMD; i++)
    {
        if (NULL != gShell_DynamicCmds[i].cmd)
        {
            if (0 == stricmp((char *)cmd, (char *)gShell_DynamicCmds[i].cmd))
            {
                return i;
            }
        }
        else
        {
            return i;
        }
    }
    return i;
}

/**************************************************************************
* ƣShellFindStaticCmd
* Ҿ̬shellṩϢ
* ˵(IN)
            cmd:shell
            cmdLen:shellĳ
            (OUT)
*   ֵ
* ˵
**************************************************************************/
static UINT32 ShellHelpFindStaticCmd(CHAR *cmd, UINT32 cmdLen)
{
    UINT32  cmd_count       = sizeof(gShell_Cmds) / sizeof(gShell_Cmds[0]);
    UINT32  i               = 0;
    BOOL    cmdIsDisplay    = TRUE;

    zOss_AssertEx(cmd != NULL && cmdLen != 0, ZOSS_ERROR);
    for (i = 0; i < cmd_count; i++)
    {
        if (0 == strnicmp((char *)cmd, (char *)gShell_Cmds[i].cmd, (unsigned int)cmdLen))
        {
            if (cmdIsDisplay)
            {
                zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_ABNORMAL, "\t: %s ûҵ!", cmd);
                zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_NORMAL, "\t%sͷ:", cmd);
                cmdIsDisplay = FALSE;
            }
            zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_NORMAL, "\t%-20s \t%s", gShell_Cmds[i].cmd, gShell_Cmds[i].desc);
        }
    }
    if (cmdIsDisplay)
    {
        return ZOSS_ERROR;
    }
    return ZOSS_SUCCESS;
}

/**************************************************************************
* ƣShellHelpFindDynamicCmd
* Ҷ̬shell
* ˵(IN)
            cmd:shell
            cmdLen:shellĳ
            (OUT)
*   ֵ
* ˵
**************************************************************************/
static UINT32 ShellHelpFindDynamicCmd(CHAR *cmd, UINT32 cmdLen)
{
    UINT32  i               = 0;
    BOOL    cmdIsDisplay    = TRUE;
   
    zOss_AssertEx(cmd != NULL && cmdLen != 0, ZOSS_ERROR);
    for (i = 0; i < SHELL_MAX_DYNAMIC_CMD && NULL != gShell_DynamicCmds[i].cmd; i++)
    {
        if (0 == strnicmp((char *)cmd, (char *)gShell_DynamicCmds[i].cmd, (unsigned int)cmdLen))
        {
            if (cmdIsDisplay)
            {
                zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_ABNORMAL, "\t: %s ûҵ!", cmd);
                zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_NORMAL, "\t%sͷ:", cmd);
                cmdIsDisplay = FALSE;
            }
            zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_NORMAL, "\t%-20s \t%s", gShell_DynamicCmds[i].cmd, gShell_DynamicCmds[i].desc);
        }
    }
    if (cmdIsDisplay)
    {
        return ZOSS_ERROR;
    }
    return ZOSS_SUCCESS;
}

/**************************************************************************
* ƣShellHelpProcess
* ûҵӦshellṩһЩϢ
* ˵: (IN)
            CmdMsg:ṹָ
            (OUT)
*   ֵ
* ˵
**************************************************************************/
static VOID ShellHelpProcess(T_Shell_CommandMessage *CmdMsg)
{
    UINT32  ret1    = ZOSS_ERROR;
    UINT32  ret2    = ZOSS_ERROR;
    CHAR    *cmd    = NULL;
    UINT32  cmp_len = 0; 

    zOss_AssertExN(CmdMsg != NULL);
    cmd = CmdMsg->cmd;
    cmp_len = strlen((char *)cmd);
    ret1 = ShellHelpFindStaticCmd(cmd, cmp_len);
    ret2 = ShellHelpFindDynamicCmd(cmd, cmp_len);
    if ((ZOSS_ERROR == ret1) && (ZOSS_ERROR == ret2))
    {
        zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_ABNORMAL, "\t%sshell!", cmd);
        zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_ABNORMAL, "\thelpг");
    }
}

/**************************************************************************
* ƣshell_help
* Shell help
* ˵(IN)
            pCmdMsg:ṹָ
            (OUT)
*   ֵ
* ˵
**************************************************************************/
static VOID Shell_help(T_Shell_CommandMessage *pCmdMsg)
{
    SINT32  cmdCount    = sizeof(gShell_Cmds) / sizeof(gShell_Cmds[0]);
    SINT32  i           = 0;
    CHAR    *cmd        = NULL;
    SINT32  cmpLen      = 0;
    UINT32  ret         = 0;
    
    zOss_AssertExN(pCmdMsg != NULL);
    if (1 != pCmdMsg->paraCount)
    {
        zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_NORMAL, "\tйϸϢhelp ");
        
        for (i = 0; i < cmdCount; i++)
        {
            zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_NORMAL, "\t%-20s \t%s", gShell_Cmds[i].cmd, gShell_Cmds[i].desc);
        }
        for (i = 0; i < SHELL_MAX_DYNAMIC_CMD; i++)
        {
            if (NULL != gShell_DynamicCmds[i].cmd)
            {
                zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_NORMAL, "\t%-20s \t%s", gShell_DynamicCmds[i].cmd, gShell_DynamicCmds[i].desc);
            }
            else
            {
                break;
            }
        }
    }
    else
    {
        cmd = pCmdMsg->para[0];
        if (0 == strcmp((char *)cmd, "help"))
        {
            zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_NORMAL, "\thelp:\n\t help [command]\n\t hhelpͬ");
            return;
        }
        
        i = Shell_findCmd(cmd);
        if (i >= 0 && i < cmdCount)
        {
            cmpLen = strlen(pCmdMsg->para[0]);
            zOss_Memcpy((char *)pCmdMsg->cmd, pCmdMsg->para[0],cmpLen);
            pCmdMsg->cmd[cmpLen] = '\0';
            strncpy((char *)pCmdMsg->para[0], "help", SHELL_CMD_PARAM_LENGTH);
            pCmdMsg->para[0][SHELL_CMD_PARAM_LENGTH] = '\0';            
            gShell_Cmds[i].func(pCmdMsg);
            return;
        }
        i = (long)Shell_FindDynamicCmd(cmd);
        if (i >= SHELL_MAX_DYNAMIC_CMD)
            return;

        if (NULL != gShell_DynamicCmds[i].cmd)
        {
            cmpLen =  strlen(pCmdMsg->para[0]);
            zOss_Memcpy((char *)pCmdMsg->cmd, pCmdMsg->para[0],cmpLen);
            pCmdMsg->cmd[cmpLen] = '\0';
            strncpy((char *)pCmdMsg->para[0], "help", SHELL_CMD_PARAM_LENGTH);
            pCmdMsg->para[0][SHELL_CMD_PARAM_LENGTH] = '\0';
            gShell_DynamicCmds[i].func(pCmdMsg);
            return;
        }
        
        zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_ABNORMAL, "\t: %s ûҵ!", cmd);
        zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_NORMAL, "\t%sͷ:", cmd);
        cmpLen = (long)strlen((char *)cmd);
        ret = ZOSS_ERROR;
        for (i = 0; i < cmdCount; i++)
        {
            if (0 == strnicmp((char *)cmd, (char *)gShell_Cmds[i].cmd, ( unsigned int )cmpLen))
            {
                zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_NORMAL, "\t%-20s \t%s", gShell_Cmds[i].cmd, gShell_Cmds[i].desc);
                ret = ZOSS_SUCCESS;
            }
        }
        for (i = 0; i < SHELL_MAX_DYNAMIC_CMD; i++)
        {
            if (NULL != gShell_DynamicCmds[i].cmd)
            {
                if (0 == strnicmp((char *)cmd, (char *)gShell_DynamicCmds[i].cmd, ( unsigned int )cmpLen))
                {
                    zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_NORMAL, "\t%-20s \t%s", gShell_DynamicCmds[i].cmd, gShell_DynamicCmds[i].desc);
                    ret = ZOSS_SUCCESS;
                }
            }
            else
            {
                break;      /* ΪNULL, */
            }
        }
        if (ZOSS_ERROR == ret)
        {
            zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_ABNORMAL, "\tû%sͷ!", cmd);
            zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_ABNORMAL, "\thelpг");
        }
    }
}

#ifdef __cplusplus
}
#endif

