/*
 *  drivers/mtd/nandids.c
 *
 *  Copyright (C) 2002 Thomas Gleixner (tglx@linutronix.de)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 *
 */
#include "drvs_general.h"
#include "drvs_nand_ids.h"

const struct nand_flash_device_para nand_flash_para[] = {
    /* MT29F1G16ABBDA for 6301 modem evb */
    {0x2C,0xB1,0x80,1,2048,64,2,2,0x20000,64,1024,1,0,{60, 25, 100, 25, 100, 30, 25, 10, 35,100},{4,512}},
    /*H8BCS0QG0ABR for 6300 datacard*/
    {0xAD,0xB1,0x00,1,2048,64,2,2,0x20000,64,1024,1,0,{60, 20, 100, 20, 100, 20, 25, 10, 30, 80},{4,512}},
     /* k9F2G08U0B for 7510 FPGA */
    {0xEC,0xDA,0x10,0,2048,64,2,3,0x20000,64,2048,1,0,{60, 25, 100, 25, 100, 20, 20, 10, 20, 100},{4,512}},
    /* MT29F2G08ABBEA for 7510 evb 256MB X 8 */
	{0x2C,0xAA,0x90,0,2048,64,2,3,0x20000,64,2048,1,0,{60, 25, 100, 25, 100, 20, 20, 15, 25, 60},{4,512}},
    /* H9TA4GG2GDMCPR for 7510 evb 512MB X 8 */
	{0xAD,0xAC,0x90,0,2048,128,2,3,0x20000,64,4096,1,0,{60, 25, 100, 25, 100, 20, 25, 15, 35, 80},{8,512}},
	/* JSFBA3YHABB for 7510 evb 256MB X 8 */
	{0xAD,0xAA,0x90,0,2048,128,2,3,0x20000,64,2048,1,0,{60, 25, 100, 25, 100, 20, 25, 15, 35, 80},{8,512}},
	/* FM6BD2G1GA for 7510 evb 256MB X 8 */
	{0xC8,0xAA,0x90,0,2048,64,2,3,0x20000,64,2048,1,0,{60, 25, 100, 25, 100, 20, 25, 15, 35, 80},{4,512}},
	/* JSFCBX3Y7ABB for 7510 evb 512MB X 8 */
	{0x01,0xAC,0x90,0,2048,128,2,3,0x20000,64,4096,1,0,{60, 25, 100, 25, 100, 20, 25, 15, 35, 80},{8,512}},
	/* NM1281KSLAXAJ for 7510 evb 256MB X 8 */	
	{0x98,0xAA,0x90,0,2048,128,2,3,0x20000,64,2048,1,0,{60, 25, 100, 25, 100, 20, 25, 15, 35, 60},{8,512}},
	/* FM6BD4G2GA for 7510 evb 512MB X 8 */
	{0xC8,0xAC,0x90,0,2048,64,2,3,0x20000,64,4096,1,0,{60, 25, 100, 25, 100, 20, 25, 15, 35, 80},{4,512}},
	/* W71NW20GF3FW for 7510 evb 256MB X 8 */
	{0xEF,0xAA,0x90,0,2048,64,2,3,0x20000,64,2048,1,0,{80, 25, 100, 25, 100, 20, 25, 15, 35, 80},{4,512}},
	/* JSFAAB3YHABB for 7520 cpe_L810 128MB X 8 ---> DDR 128M */
	{0xAD,0xA1,0x80,0,2048,64,2,2,0x20000,64,1024,1,0,{60, 25, 100, 25, 100, 20, 25, 15, 20, 80},{4,512}},
	/* MT29F4G08ABBDAH4 for 7520V3 evb 512MB X 8 */
	{0x2C,0xAC,0x90,0,2048,64,2,3,0x20000,64,4096,1,0,{60, 25, 100, 25, 100, 20, 20, 15, 25, 60},{4, 512}},


	
    /* GIGADEVICE GD5F1GQ4R for 7520 evb 128MB SPI-NAND */
    {0xC8,0xC1,0x00,0,2048,128,0,0,0x20000,64,1024,1,0,{2,1,1,9,0,0,0,0,0,0},{0,0}},
    /* GIGADEVICE GD5F4GQ4R for 7520 evb 512MB SPI-NAND */
    {0xC8,0xC4,0x00,0,4096,256,0,0,0x40000,64,2048,1,0,{2,1,1,9,0,0,0,0,0,0},{0,0}},
    /* GIGADEVICE GD2G4RBY1G for 7520 FPGA 256MB SPI-NAND */
    {0xC8,0xC2,0x00,0,2048,128,2,3,0x20000,64,2048,1,0,{2,1,1,9,0,0,0,0,0,0},{0,0}},
	 /* HYF1GQ4IAACAE SPI-NAND  */	
	{0xC9,0x51,0x00,0,2048,128,0,0,0x20000,64,1024,1,0,{2,1,1,9,0,0,0,0,0,0},{0,0}},
	 /* HYF2GQ4IAACAE SPI-NAND  */	
	{0xC9,0x52,0x00,0,2048,128,0,0,0x20000,64,2048,1,0,{2,1,1,9,0,0,0,0,0,0},{0,0}},
	{0xA1,0xC1,0x00,0,2048,128,0,0,0x20000,64,1024,1,0,{2,1,1,9,0,0,0,0,0,0},{0,0}},
	/* PARAGON PN26Q02AWSIUG for 7520 evb 256MB SPI-NAND */
	{0xA1,0xC2,0x00,0,2048,128,0,0,0x20000,64,2048,1,0,{2,1,1,9,0,0,0,0,0,0},{0,0}},
	/*winbond W25N01G*/
	{0xEF,0xBA,0x00,0,2048,64,0,0,0x20000,64,1024,1,0,{2,1,1,9,0,0,0,0,0,0},{0,0}},
	/*winbond W25N02G*/
	{0xEF,0xBB,0x00,0,2048,64,0,0,0x20000,64,2048,2,0,{2,1,1,9,0,0,0,0,0,0},{0,0}},
	 /* TOSHIBA TC58CYG0S3HRAIG 128MB SPI-NAND*/
    {0x98,0xB2,0x00,0,2048,128,0,0,0x20000,64,1024,1,0,{2,1,1,9,0,0,0,0,0,0},{0,0}},
    /* TOSHIBA TC58CYG1S3HRAIG 256MB SPI-NAND*/
    {0x98,0xBB,0x00,0,2048,128,0,0,0x20000,64,2048,1,0,{2,1,1,9,0,0,0,0,0,0},{0,0}},
    {0,}
};


/*
*	Chip ID list
*
*	Name. ID code, pagesize, chipsize in MegaByte, eraseblock size,
*	options
*
*	Pagesize; 0, 256, 512
*	0	get this information from the extended chip ID
+	256	256 Byte page size
*	512	512 Byte page size
*/
const struct nand_flash_dev nand_flash_ids[] = {

    {"NAND 128MiB 1,8V 16-bit",	0xB1, 2048, 128, 0x20000, NAND_BUSWIDTH_16},    //MT29F1G16ABBDA
    {"NAND 128MiB 1,8V 8-bit",	0xA1, 2048, 128, 0x20000, 0},  //7520 L810 MICRON
	{"NAND 256MiB 1,8V 8-bit",	0xDA, 2048, 256, 0x20000, 0},                   //7510FPGA SAMSUNG
    {"NAND 512MiB 1,8V 8-bit",	0xAC, 2048, 512, 0x20000, 0},                   //7510 EVB H9TA4GG2GDMCPR
    {"NAND 256MiB 1,8V 8-bit",	0xAA, 2048, 256, 0x20000, 0},                   //7510 EVB MT29F2G08ABBEA
	{"SPI-NAND 256MiB 1,8V",	0xF2, 2048, 256, 0x20000, 0},                   //7520 FPGA GD5F2G 
	{"SPI-NAND 128MiB 1,8V",	0xC1, 2048, 128, 0x20000, 0},                   //7520 evb GD5F1G 
	{"SPI-NAND 512MiB 1,8V",	0xC4, 4096, 512, 0x40000, 0},                   //7520 EVB GD5F1G
    {"SPI-NAND 256MiB 1,8V 8-bit",	0xC2, 2048, 256, 0x20000, 0},  //7520 EVB MICRON
	{"SPI-NAND 128MiB 1,8V",	0xE1, 2048, 128, 0x20000, 0},  //7520m GD5F1G
	{"SPI-NAND 256MiB 1,8V",	0xE2, 2048, 256, 0x20000, 0},  //7520m GD5F2G
	{"SPI-NAND 512MiB 1,8V",	0xE4, 2048, 512, 0x20000, 0},  //7520m GD5F4G
	 {"NAND 128MiB 1,8V 8-bit",	0x51, 2048, 128, 0x20000, 0}, 
	 {"NAND  256MiB 1,8V 8-bit",0x52, 2048, 256, 0x20000, 0},  
	{"SPI-NAND 256MiB 1,8V",	0xBA, 2048, 128, 0x20000, 0},  //winbond W25N01G
	{"SPI-NAND 256MiB 1,8V",	0xBB, 2048, 256, 0x20000, 0},  //winbond W25N02G
	{"SPI-NAND 256MiB 1,8V",	0xB2, 2048, 128, 0x20000, 0},  
	{NULL,}
};

/*
*	Manufacturer ID list
*/
const struct nand_manufacturers nand_manuf_ids[] = {
	{NAND_MFR_TOSHIBA, "Toshiba"},
	{NAND_MFR_SAMSUNG, "Samsung"},
	{NAND_MFR_FUJITSU, "Fujitsu"},
	{NAND_MFR_NATIONAL, "National"},
	{NAND_MFR_RENESAS, "Renesas"},
	{NAND_MFR_STMICRO, "ST Micro"},
	{NAND_MFR_HYNIX, "Hynix"},
	{NAND_MFR_MICRON, "Micron"},
	{NAND_MFR_AMD, "AMD"},
    {NAND_MFR_GIGADEVICE, "GigaDevice"}, 
	{0x0, "Unknown"}
};

extern const struct nand_flash_dev nand_flash_ids[];
extern const struct nand_manufacturers nand_manuf_ids[];
