#ifndef _MMC_EXPORT_HEAD_H
#define _MMC_EXPORT_HEAD_H
#include "mmc_drvs_io.h"


typedef enum _e_notify_event
{
	MMC_CARD_ARRIVAL = 0,
	MMC_CARD_REMOVE,
	MMC_CARD_SUSPEND,
	MMC_CARD_RESUME,
	MMC_NOTIFY_NUM
}e_notify_event;

typedef enum _e_mmc_DrpEvent
{
	MMC_CARD_GET_CAPACITY,
	MMC_CARD_ERASE_BLK,
	MMC_CARD_SET_BLKSIZE,
	MMC_CARD_ENABLE_FUNC,
	MMC_CARD_DISABLE_FUNC,
	MMC_CARD_SET_FUNC_BLKSIZE,
	MMC_CARD_GET_FUNC_INFO,
	MMC_SDIO_CLAIM_IRQ,
	MMC_SDIO_RELEASE_IRQ,
	MMC_SDIO_CARD_RESET,
	MMC_CARD_OPEN,
	MMC_CARD_CLOSE,
	MMC_CARD_WRITE ,
	MMC_CARD_READ,
	MMC_CARD_IOCTROL,
	MMC_CARD_OP_NUM
}e_mmc_DrpEvent;

#define SD_DEFAULT_BLKSIZE 512


#define  MMC_CARD_TYPE_MMC    		0	/* MMC card */
#define  MMC_CARD_TYPE_SD     		1	/* SD card */
#define  MMC_CARD_TYPE_SDIO   		2	/* SDIO card */
#define  MMC_CARD_TYPE_SD_COMBO 	3 	/* SD combo (IO+mem) card */

SINT32 mmc_loadDrv(const char* drvName, VOID* param);

SINT32 mmc_unloadDrv(VOID* param);

typedef VOID (*mmcApp_notify)(e_notify_event, VOID*, VOID*);

SINT32 mmcApp_notifyRegister(const char* appName,mmcApp_notify mmcNotify);


#endif
