//**********************************************************************/
//void Syn_filt(
//     Word16 a[],                           /* (i) Q12 : a[m+1] prediction coefficients           */
//     Word16 x[],                           /* (i)     : input signal                             */
//     Word16 y[],                           /* (o)     : output signal                            */
//     Word16 mem[],                         /* (i/o)   : memory associated with this filtering.   */
//     Word16 lg,                            /* lgΪ4ı                                    */
//     Word16 update,
//     Word16 ScratchMem[]
//)
//***********************************************************************
// a[]    ---   r0
// x[]    ---   r1
// y[]    ---   r2
// mem[]  ---   r3
// lg     ---   stack 
// update ---   stack
// ScratchMem --- stack
// m ̶Ϊ 20 

#include "oscl_base_macros.h"
#include "oscl_base.h"


#if (PV_CPU_ARCH_VERSION >= 6 && PV_COMPILER == EPV_ARM_RVCT)
__asm    void wb_syn_filtm20_asm(
         int16 a[],                           /* (i) Q12 : a[m+1] prediction coefficients           */
         int16 x[],                           /* (i)     : input signal                             */
         int16 y[],                           /* (o)     : output signal                            */
         int16 mem[],                         /* (i/o)   : memory associated with this filtering.   */
         int16 lg,                            /* (i)     : size of filtering                        */
         int16 update,                        /* (i)     : 0=no update, 1=update of memory.         */
         int16 y_buf[]
         )
{
    PRESERVE8
    IMPORT voAWB_Copy
        
        STMFD   	r13!, {r4 - r12, r14}   
        SUB         r13, r13, #40                   // a[1 - 20]	
        LDR         r5,  [r13, #88]                 // copy y = y_buf address	
		
        //memy_bufʼַ
        LDRH          r6,  [r3], #2
        LDRH          r7,  [r3], #2
        LDRH          r8,  [r3], #2
        LDRH          r9,  [r3], #2
        LDRH          r10, [r3], #2
  
        STRH          r6,  [r5], #2
        STRH          r7,  [r5], #2
        STRH          r8,  [r5], #2
        STRH          r9,  [r5], #2
        STRH          r10, [r5], #2

        LDRH          r6,  [r3], #2
        LDRH          r7,  [r3], #2
        LDRH          r8,  [r3], #2
        LDRH          r9,  [r3], #2
        LDRH          r10, [r3], #2
		
        STRH          r6,  [r5], #2
        STRH          r7,  [r5], #2
        STRH          r8,  [r5], #2
        STRH          r9,  [r5], #2
        STRH          r10, [r5], #2
		
        LDRH          r6,  [r3], #2
        LDRH          r7,  [r3], #2
        LDRH          r8,  [r3], #2
        LDRH          r9,  [r3], #2
        LDRH          r10, [r3], #2
		
        STRH          r6,  [r5], #2
        STRH          r7,  [r5], #2
        STRH          r8,  [r5], #2
        STRH          r9,  [r5], #2
        STRH          r10, [r5], #2
		
        LDRH          r6,  [r3], #2
        LDRH          r7,  [r3], #2
        LDRH          r8,  [r3], #2
        LDRH          r9,  [r3], #2
        LDRH          r10, [r3], #2
		
        STRH          r6,  [r5], #2
        STRH          r7,  [r5], #2
        STRH          r8,  [r5], #2
        STRH          r9,  [r5], #2
        STRH          r10, [r5], #2		

        //load all a[]
        LDR     r6, [r13, #80]                 // ȡlglgΪ4ı
        LDR     r5, =0xffff
        LDRSH   r4, [r0]                       // load a[0]
        AND     r4, r4, r5
        AND     r6, r6, r5
        MOV     r5, r6, asr #2                 // ÿ4,64
        MOV     r4, r4, ASR #1                 // a0 = a[0] >> 1
        PKHBT   r4, r4, r5, LSL #16            // r4ִ߰ѭͰִa[0]
		
        LDRSH   r5, [r0, #2]
        LDRSH   r6, [r0, #4]
        PKHBT   r5, r5, r6, LSL #16                  //a1, a2
        STR     r5, [r13, #36]
		
        LDRSH   r5, [r0, #6]
        LDRSH   r6, [r0, #8]
        PKHBT   r5, r5, r6, LSL #16                  //a3, a4
        STR     r5, [r13, #32]

        LDRSH   r5, [r0, #10]
        LDRSH   r6, [r0, #12]
        PKHBT   r5, r5, r6, LSL #16                  //a5, a6
        STR     r5, [r13, #28]

        LDRSH   r5, [r0, #14]
        LDRSH   r6, [r0, #16]
        PKHBT   r5, r5, r6, LSL #16                  //a7, a8
        STR     r5, [r13, #24]

        LDRSH   r5, [r0, #18]
        LDRSH   r6, [r0, #20]
        PKHBT   r5, r5, r6, LSL #16                  //a9, a10
        STR     r5, [r13, #20]
		
        LDRSH   r5, [r0, #22]
        LDRSH   r6, [r0, #24]
        PKHBT   r5, r5, r6, LSL #16                  //a11, a12
        STR     r5, [r13, #16]
		
        LDRSH   r5, [r0, #26]
        LDRSH   r6, [r0, #28]
        PKHBT   r5, r5, r6, LSL #16                  //a13, a14
        STR     r5, [r13, #12]

        LDRSH   r5, [r0, #30]
        LDRSH   r6, [r0, #32]
        PKHBT   r5, r5, r6, LSL #16                  //a15, a16
        STR     r5, [r13, #8]	
		
        LDRSH   r5, [r0, #34]
        LDRSH   r6, [r0, #36]
        PKHBT   r5, r5, r6, LSL #16                  //a17, a18
        STR     r5, [r13, #4]		

        LDRSH   r5, [r0, #38]
        LDRSH   r6, [r0, #40]
        PKHBT   r5, r5, r6, LSL #16                  //a19, a20
        STR     r5, [r13]		
		
        // All a[] Has Save in Stack;
        LDR     r14, [r13, #88]      // load ybuf[]
        ADD     r14, r14, #40        // ƫ40Byte(mem)
		
        LDM     r13, {r5 - r8}       //Ϊ´ѭ׼
		
loop_begin
        //ÿѭ4y_bufֵļ㣬ͬʱy_bufy
        LDR     r0,  [r14, #-40]	
        SMUADX  r9,  r0, r5          // -20 * A20 + -19 * A19
        SMULTT  r10, r0, r5          // -19 * A20
		
        LDR     r0,  [r14, #-36]  
        SMLADX  r9,  r0, r6, r9      // -18 * A18 + -17 * A17
        SMLABB  r10, r0, r5, r10     // -18 * A17
        SMUADX  r11, r0, r5          // 18 * A20 + -17 * A19
		
        SMLATT  r10, r0, r6, r10     // -17 * A18
        SMULTT  r12, r0, r5          // -17 * A20
		
        LDR     r0,  [r14, #-32]
		
        SMLADX  r9,  r0, r7, r9      // -16 * A16 + -15 * A15
        SMLABB  r10, r0, r6, r10     // -16 * A17
        SMLADX  r11, r0, r6, r11     // -16 * A18 + -15 * A17
        SMLABB  r12, r0, r5, r12     // -16 * A19
		
        SMLATT  r10, r0, r7, r10     // -15 * A16
        SMLATT  r12, r0, r6, r12     // -15 * A18
		
        LDR     r0,  [r14, #-28]
		
        SMLADX  r9,  r0, r8, r9      // -14 * A14 + -13 * A13
        SMLABB  r10, r0, r7, r10     // -14 * A15 
        SMLADX  r11, r0, r7, r11     // -14 * A16 + -13 * A15
        SMLABB  r12, r0, r6, r12     // -14 * A17
        SMLATT  r10, r0, r8, r10     // -13 * A14
        SMLATT  r12, r0, r7, r12     // -13 * A16
       
        LDR     r5,  [r13, #16]      //ǰ
        LDR     r0,  [r14, #-24] 
		
        SMLADX  r9,  r0, r5, r9      // -12 * A12 + -11 * A11
        SMLABB  r10, r0, r8, r10     // -12 * A13 + -11 * A13
        SMLADX  r11, r0, r8, r11     // -12 * A14
        SMLABB  r12, r0, r7, r12     // -12 * A15
        SMLATT  r10, r0, r5, r10     // -11 * A12
        SMLATT  r12, r0, r8, r12     // -11 * A14
		
        LDR     r6,  [r13, #20]      //ǰ
        LDR     r0,  [r14, #-20] 
		
        SMLADX  r9,  r0, r6, r9      // -10 * A10 + -9 * A9
        SMLABB  r10, r0, r5, r10     // -10 * A11
        SMLADX  r11, r0, r5, r11     // -10 * A12 + -9 * A11
        SMLABB  r12, r0, r8, r12     // -10 * A13
        SMLATT  r10, r0, r6, r10     // -9 * A10
        SMLATT  r12, r0, r5, r12     // -9 * A12

        LDR     r7,  [r13, #24]      //ǰ
        LDR     r0,  [r14, #-16] 
		
        SMLADX  r9,  r0, r7, r9      // -8 * A8  + -7 * A7
        SMLABB  r10, r0, r6, r10     // -8 * A9
        SMLADX  r11, r0, r6, r11     // -8 * A10 + -7 * A9
        SMLABB  r12, r0, r5, r12     // -8 * A11

        SMLATT  r10, r0, r7, r10     // -7 * A8
        SMLATT  r12, r0, r6, r12     // -7 * A10

        LDR     r0,  [r14, #-12] 
        LDR     r8,  [r13, #28]      //ǰ
		
        SMLADX  r9,  r0, r8, r9      // -6 * A6 + -5 * A5
        SMLABB  r10, r0, r7, r10     // -6 * A7
        SMLADX  r11, r0, r7, r11     // -6 * A8 + -5 * A7
        SMLABB  r12, r0, r6, r12     // -6 * A9

        SMLATT  r10, r0, r8, r10     // -5 * A6
        SMLATT  r12, r0, r7, r12     // -5 * A8
		
        LDR     r0,  [r14, #-8] 
        LDR     r5,  [r13, #32]      //ǰ
		
        SMLADX  r9,  r0, r5, r9      // -4 * A4 + -3 * A3
        SMLABB  r10, r0, r8, r10     // -4 * A5
        SMLADX  r11, r0, r8, r11     // -4 * A6 + -3 * A5
        SMLABB  r12, r0, r7, r12     // -4 * A7

        SMLATT  r10, r0, r5, r10     // -3 * A4
        SMLATT  r12, r0, r8, r12     // -3 * A6
		
        LDR     r0,  [r14, #-4] 
        LDR     r6,  [r13, #36]      //ǰ
		
        SMLADX  r9,  r0, r6, r9      // -2 * A2 + -1 * A1
        SMLABB  r10, r0, r5, r10     // -2 * A3
        SMLADX  r11, r0, r5, r11     // -2 * A4 + -1 * A3
        SMLABB  r12, r0, r8, r12     // -2 * A5

        SMLATT  r10, r0, r6, r10     // -1 * A2
        SMLATT  r12, r0, r5, r12     // -1 * A4	
		
        //1	
        LDRSH   r0,  [r1], #2    //x0	
        RSB     r9, #0x0800
        SMLABB  r9, r4, r0, r9
        SSAT    r9, #16, r9, asr #12
        STRH    r9, [r14], #2        // save y_buf[0]
		
        //2	
        LDRSH   r0,  [r1], #2    //x1
        SMLABB  r10, r9, r6, r10     // 0 * A1
        RSB     r10, #0x0800
        SMLABB  r10, r4, r0, r10
        SSAT    r10, #16, r10, asr #12
        STRH    r10, [r14], #2       //save y_buf[1]
		
        //3	
        LDRSH   r0,  [r1], #2    //x3	
        SMLABT  r11, r9,  r6, r11    // 0 * A2
        SMLABB  r11, r10, r6, r11    // 1 * A1
        RSB     r11, #0x0800
        SMLABB  r11, r4,  r0, r11
        SSAT    r11, #16, r11, asr #12
        STRH    r11, [r14], #2       //save y_buf[2]
		
        //4	
        LDRSH   r0,  [r1], #2    //x3	
        SMLABB  r12, r9,  r5, r12    // 0 * A3    
        SMLABT  r12, r10, r6, r12    // 1 * A2
        SMLABB  r12, r11, r6, r12    // 2 * A1
        RSB     r12, #0x0800
        SMLABB  r12, r4, r0, r12
        SSAT    r12, #16, r12, asr #12
        STRH    r12, [r14],#2        //save y_buf[3]
	    
        STRH    r9,  [r2], #2        //save y[0]
        MOV	    r0,  r4, asr #16
        STRH    r10, [r2], #2        //save y[1]
        SUB	    r4,  r4, #0x10000     
        STRH    r11, [r2], #2        //save y[2]
        SUBS    r0, r0, #1
        STRH    r12, [r2], #2        //save y[3]
        LDM     r13, {r5 - r8}       //Ϊ´ѭ׼
        BNE	    loop_begin
		
        LDR     r6, [r13, #84]       //ȡupdate
        TEQ     r6, #0
        BEQ     Syn_filt_asm_end
        // update mem[]
        SUB     r0, r2, #40
        SUB     r1, r3, #40
        MOV     r2, #20
        BL      voAWB_Copy
		
Syn_filt_asm_end
        ADD     r13,  r13, #40
        LDMFD   r13!, {r4 - r12, r15}
}
		
#endif
