/************************************************************************
 * Ȩ (C)2010,ͨѶɷ޹˾
 * ģ  
 * ļƣ os_thread.c
 * ļʶ Zcoreļزӿ
 * ժҪ
 *
 * ޸    汾       ޸ı        ޸        ޸
 * ----------------------------------------------------------------------
 * 
 ************************************************************************/

/**************************************************************************
 *                        ͷļ                                                                         *
 **************************************************************************/

#include <pthread.h>
#include <sched.h>
#include <stdio.h>
#include "zcore_type.h"
#include "os_type.h"
#include "os_pub.h"
#include "os_thread.h"
#include "os_mutex.h"
#include "os_list.h"
/****************************************************************************
 *                          غ
 ****************************************************************************/
#define thread_context(tid)     ((OS_THREAD_CONTEXT *)tid)
#define thread_pth_t(tid)         (thread_context(tid)->pth_t)
#define thread_info(tid)        (thread_context(tid)->info)

typedef VOID    *ZOSS_THREAD_ID;
#define pthread_t        ZOSS_THREAD_ID


/****************************************************************************
 *                          
 ****************************************************************************/
typedef struct
{
    OS_LIST_NODE    node;
    pthread_t    pth_t;
    OS_THREAD_INFO  info;
} OS_THREAD_CONTEXT;
/****************************************************************************
 *                         ر
 ****************************************************************************/
static OS_LIST      s_thread_list = { 0 };//ڱ̵߳
static OS_MUTEX_ID  s_thread_mutex = OS_MUTEX_INVALID_ID;
/****************************************************************************
 *                          غԭ
 ****************************************************************************/
static SINT32 thread_context_add( OS_THREAD_CONTEXT **p_context );
static VOID thread_context_remove(OS_THREAD_CONTEXT  *p_context);
static VOID thread_context_get_by_pth_t( OS_THREAD_CONTEXT **p_context, pthread_t pth_t );
static BOOL thread_context_is_valid( OS_THREAD_CONTEXT *p_context );
/****************************************************************************
 *                          ȫֺʵ
 ****************************************************************************/
/**************************************************************************
* ƣ tp_os_thread_create
*  ̵߳Ĵ
* ˵ szName̵߳
				   proc_ThreadEntry߳к
				   pri̵ָ߳ȼ
				   size̶߳ջС
				   paramݸ߳ںĲ
*   ֵ     ɹ򷵻̱߳ʶţ򷵻OS_FAILURE
* ˵ ѡ
**************************************************************************/
OS_THREAD_ID tp_os_thread_create(CHAR *name, OS_THREAD_ENTRY entry, UINT8 pri, UINT32 size, VOID* param)
{
    OS_THREAD_CONTEXT   *p_context = NULL;
    int                                    ret = 0;
    pthread_attr_t                 attr;
    struct sched_param         sch_param;

    //printf("tp_os_thread_create begin  thread name is %s!\n",name);

    if ( OS_SUCCESS != thread_context_add( &p_context ) )
    {
        return OS_THREAD_INVALID_ID;
    }
    //printf("tp_os_thread_create threadid is 0x%x!\n",p_context->info.id);
     //printf("tp_os_thread_create p_context begin\n ");
    //¼Ϣ
    p_context->info.stack_size = size;
    p_context->info.priority = pri;
    if (name != NULL)
    {
        strncpy( p_context->info.name, name, OS_MAX_NAME_LEN-1 );
    }
    //̴߳
    pthread_attr_init(&attr);

    
   // pthread_attr_getschedparam(&attr,&sch_param);
    //printf("tp_os_thread_create sched_priority=%d\n",sch_param.sched_priority);
    pthread_attr_setstacksize(&attr,size);//̵߳ջС
   // pthread_attr_setschedpolicy(&attr,SCHED_RR);
   pthread_attr_setschedpolicy(&attr,SCHED_FIFO);
   //pthread_attr_setscope(&attr,PTHREAD_CREATE_DETACHED);
    sch_param.sched_priority = pri;      //̵߳ȼ
    pthread_attr_setschedparam(&attr,&sch_param);
    ret = pthread_create(&(p_context->pth_t),&attr,(void*)entry,(void*)param);//߳
    if (ret != 0)
    {
        //߳ϢƳб
        thread_context_remove(thread_context(p_context->info.id));
        printf("create thread failed!\n");
        return 0;
    }
    pthread_attr_destroy(&attr);
   
    printf("tp_os_thread_create end s 0x%x! \n",p_context->info.id);
    return p_context->info.id;
}
/**************************************************************************
* ƣ tp_os_thread_delete
*  ɾָ̣߳ͷԴ
* ˵ tidҪɾ̱߳ʶ
*   ֵ     ɹ򷵻OS_SUCCESS򷵻OS_FAILURE
* ˵ ѡ
**************************************************************************/
OS_STATUS tp_os_thread_delete( OS_THREAD_ID tid )
{
    return OS_SUCCESS;
}
/**************************************************************************
* ƣ tp_os_thread_suspend
*  ָ߳
* ˵ tidҪ̱߳ʶ
*   ֵ     ɹ򷵻OS_SUCCESS򷵻OS_FAILURE
* ˵ ѡ
**************************************************************************/
OS_STATUS tp_os_thread_suspend( OS_THREAD_ID tid )
{
    return OS_FAILURE;
}
/**************************************************************************
* ƣ tp_os_thread_resume
*  ָƶ߳
* ˵ tidҪָ̱߳ʶ
*   ֵ     ɹ򷵻OS_SUCCESS򷵻OS_FAILURE
* ˵ ѡ
**************************************************************************/
OS_STATUS tp_os_thread_resume( OS_THREAD_ID tid )
{
    return OS_FAILURE;
}
/**************************************************************************
* ƣ tp_os_thread_self
*  صǰ̵߳ıʶ
* ˵
*   ֵ     ǰ̵߳ıʶ
* ˵ ѡ
**************************************************************************/
OS_THREAD_ID tp_os_thread_self( VOID )
{
    OS_THREAD_CONTEXT   *p_context = NULL;
    OS_THREAD_ID               thread_id = 0;

    thread_context_get_by_pth_t(&p_context,pthread_self());
    if (p_context == NULL)
    {
        thread_id = OS_THREAD_INVALID_ID;
    }
    else
    {
        thread_id = p_context->info.id;
    }
    printf("tp_os_thread_self thread_id = 0x%x\n",thread_id);
    return thread_id;
}
/**************************************************************************
* ƣ tp_os_thread_sleep
*  ߳һָʱ
* ˵ timeout߳̽Ҫߵʱ䣬λΪ
*   ֵ     ɹ򷵻OS_SUCCESS򷵻OS_FAILURE
* ˵ ѡ
**************************************************************************/
OS_STATUS tp_os_thread_sleep( UINT32 timeout )
{
    return usleep(timeout*1000);
}
/**************************************************************************
* ƣ tp_os_thread_is_created
*  жָʶŵ߳Ƿ񱻴
* ˵ tid̵߳ıʶ
*   ֵ    ˱ʶŵ߳ѱ򷵻OS_TRUE򷵻OS_FALSE
* ˵ ѡ
**************************************************************************/
BOOL tp_os_thread_is_created( OS_THREAD_ID tid )
{
    TP_OS_ASSERTEx( OS_THREAD_INVALID_ID != tid, OS_FAILURE );

    return thread_context_is_valid( thread_context(tid) );
}
/**************************************************************************
* ƣ tp_os_thread_info_get
* ȡ̵ָ߳Ϣ
* ˵tidҪȡϢ̱߳ʶ
				  info_ptr̵߳Ϣṹ
*   ֵ    ɹ򷵻OS_SUCCESS򷵻OS_FAILURE
* ˵ ѡ
**************************************************************************/
OS_STATUS tp_os_thread_info_get( OS_THREAD_ID tid, OS_THREAD_INFO *info_ptr )
{
    TP_OS_ASSERTEx( OS_THREAD_INVALID_ID != tid, OS_FAILURE );
    TP_OS_ASSERTEx( NULL != info_ptr, OS_FAILURE );

    tp_os_mem_cpy( info_ptr, &thread_info(tid), sizeof(OS_THREAD_INFO) );
    return OS_SUCCESS;
}
/**************************************************************************
* ƣ tp_os_thread_pri_set
* ̵ָ߳ȼ
* ˵tidҪȼ̱߳ʶ
				  priõȼ
*   ֵ    ɹ򷵻OS_SUCCESS򷵻OS_FAILURE
* ˵ ѡ
**************************************************************************/
OS_STATUS tp_os_thread_pri_set( OS_THREAD_ID tid, UINT8 pri )
{
    return OS_SUCCESS;
}
/**************************************************************************
* ƣ tp_os_thread_pri_get
* ȡ̵ָ߳ȼ
* ˵tidҪȡȼ̱߳ʶ
				  pri_ptr߳ȼĵַָ
*   ֵ    ɹ򷵻OS_SUCCESS򷵻OS_FAILURE
* ˵ ѡ
**************************************************************************/
OS_STATUS tp_os_thread_pri_get( OS_THREAD_ID tid, UINT8 *pri_ptr )
{
    TP_OS_ASSERTEx( OS_THREAD_INVALID_ID != tid, OS_FAILURE );
    TP_OS_ASSERTEx( NULL != pri_ptr, OS_FAILURE );

    *pri_ptr = thread_info(tid).priority;

    return OS_SUCCESS;
}
/**************************************************************************
* ƣ tp_os_thread_init
* ʼ߳Դ
* ˵
*   ֵ    ɹ򷵻OS_SUCCESS򷵻OS_FAILURE
* ˵ ѡ
**************************************************************************/
OS_STATUS tp_os_thread_init( VOID )
{
    s_thread_mutex = tp_os_mutex_create( "thread_mutex", TRUE );
    TP_OS_ASSERTEx( OS_MUTEX_INVALID_ID != s_thread_mutex, OS_FAILURE );

    tp_os_list_init( &s_thread_list );

    return OS_SUCCESS;
}
/**************************************************************************
* ƣ tp_os_thread_uninit
* ͷŴ߳Դ
* ˵
*   ֵ    ɹ򷵻OS_SUCCESS򷵻OS_FAILURE
* ˵ ѡ
**************************************************************************/
VOID tp_os_thread_uninit( VOID )
{
    tp_os_list_init( &s_thread_list );

    tp_os_mutex_delete( s_thread_mutex );
    s_thread_mutex = OS_MUTEX_INVALID_ID;
    return ;
}
/*******************************************************************************
 * Function      : tp_os_thread_status                                                                                                     
 * Description:  This function get the status of the task 
 * Relation      : NA.
 * Params        :                                                                                                                      
 *                                                                                                                                                         
 *   Name               Type            In/Out          Description                                                        
 * --------             ----            ------          -----------                                    
 *  tid        OS_THREAD_ID    In        the identifier of a task 
 *  state       UINT32        Out       the status of the task                               
 * Return:  if success, return OS_SUCCESS,else return OS_FAILURE,and exactly error             
 *           number store in errno.
 * Note: 
 *          
 *******************************************************************************/
OS_STATUS tp_os_thread_get_state(OS_THREAD_ID tid,UINT32 * state)
{
	if (state != 0)
	{
		*state = 1;
	}
	return OS_FAILURE;
}


/**************************************************************************
* ƣ thread_context_add
* ߳ڴ棬б
* ˵
*   ֵ    ɹ򷵻OS_SUCCESS򷵻OS_FAILURE
* ˵ ѡ
**************************************************************************/
static SINT32 thread_context_add( OS_THREAD_CONTEXT **p_context )
{
    OS_THREAD_CONTEXT	*p_thread_context = NULL;

    p_thread_context = (OS_THREAD_CONTEXT *)tp_os_mem_malloc( sizeof(OS_THREAD_CONTEXT) );
    if ( NULL == p_thread_context )
    {
        return OS_FAILURE;
    }
    tp_os_mutex_get( s_thread_mutex, OS_WAIT_FOREVER );
    tp_os_list_add( &s_thread_list, (OS_LIST_NODE *)p_thread_context );
    tp_os_mutex_put( s_thread_mutex );
    p_thread_context->info.id       = (OS_THREAD_ID)p_thread_context;
    *p_context = p_thread_context;

    return OS_SUCCESS;
}
/**************************************************************************
* ƣ thread_context_add
* ͷ߳ڴ棬Ƴб
* ˵
*   ֵ    ɹ򷵻OS_SUCCESS򷵻OS_FAILURE
* ˵ ѡ
**************************************************************************/
static VOID thread_context_remove(OS_THREAD_CONTEXT  *p_context)
{
    tp_os_mutex_get( s_thread_mutex, OS_WAIT_FOREVER );
    tp_os_list_delete( &s_thread_list, (OS_LIST_NODE *)p_context );
    tp_os_mutex_put( s_thread_mutex );

    tp_os_mem_free( p_context );
    p_context = NULL;
}
/**************************************************************************
* ƣ thread_context_get_by_pth_t
* 
* ˵
*   ֵ    
* ˵ ѡ
**************************************************************************/
static VOID thread_context_get_by_pth_t( OS_THREAD_CONTEXT **p_context, pthread_t pth_t )
{
    OS_THREAD_CONTEXT	*p_node = NULL;

    tp_os_mutex_get( s_thread_mutex, OS_WAIT_FOREVER );//ֹs_thread_listͬʱʣ
    printf("thread_context_get_by_pth_t pth_t=0x%x",pth_t);

    p_node = (OS_THREAD_CONTEXT *)tp_os_list_first( &s_thread_list );
    while ( (NULL != p_node) && (pth_t != p_node->pth_t) )
    {
        p_node = (OS_THREAD_CONTEXT *)tp_os_list_next( (OS_LIST_NODE *)p_node );
    }
    tp_os_mutex_put( s_thread_mutex );
    *p_context = p_node;

    return ;

}
/**************************************************************************
* ƣ thread_context_is_valid
* 
* ˵
*   ֵ    
* ˵ ѡ
**************************************************************************/
static BOOL thread_context_is_valid( OS_THREAD_CONTEXT *p_context )
{
    BOOL    is_valid = FALSE;

    tp_os_mutex_get( s_thread_mutex, OS_WAIT_FOREVER );
    is_valid = ( -1 != tp_os_list_find( &s_thread_list, (OS_LIST_NODE *)p_context ) );
    tp_os_mutex_put( s_thread_mutex );

    return is_valid;
}


