/**
 *   Copyright (C) Infineon Technologies Denmark A/S. All rights reserved.
 *
 * This document contains proprietary information belonging to Infineon
 * Technologies Denmark A/S. Passing on and copying of this document, use
 * and communication of its contents is not permitted without prior written
 * authorisation.
 *
 * Description:
 *   Contains variables and functions accessed from path and volume control
 *
 * Revision Information:
 *   File name: \dwddrv\AUD\src\aud_gain_lib.c
 *   Version: \main\8
 *   Date: 2007-08-20 13:28:21
 *   Responsible: johansek
 *   Comment:
 *     Mute mix_afe when master volume is muted.
 */

/*******************************************************************************
*
*                               Include files
*
*******************************************************************************/
//#include "scttypes.h"           /* must be included in all files */
//#include "ms.h"                 /* must be included in all files */ 
#include "bastypes.h"           /* must be included in all files */
//#include "dsp.h"                /* for DSP command types */
#include "aud_drv.h"            /* audio types and functions */
#include "aud_data.h"           /* data describing the paths */
#include "aud_com.h"            /* types and functions used only within the audio driver */
#include "aud_volume.h"         /* for calculating side tone and getting master volume */
#include "aud_path_control.h"   /* path_settings_result */
#include "aud_gain_lib.h"       /* header file for gain cells that are common to path and volume control */
#include "drvs_teak.h"

/*******************************************************************************
*
*                              Local variables
*
*******************************************************************************/
T_DSP_CMD_CBUF_GAIN             aud_dsp_cbuf_gain_parms;
T_DSP_CMD_VB_SET_GAIN_PAR       aud_dsp_gain_parms;
T_DSP_CMD_VM_SET_COEFF_PAR      aud_dsp_vm_parms;

/*******************************************************************************
*
*                        Externally visible functions
*
*******************************************************************************/
/*------------------------------------------------------------------------------
* Function...: aud_dsp_set_vb_gains
* Return.....: -
* Description: Program the Voiceband gain cells to the DSP.
* Modified...: dd.mm.yyyy by NN
------------------------------------------------------------------------------*/
void aud_dsp_set_vb_gains(void)
{
    /*[Begin] [lvwenhua-2010/7/28]*/
    if(aud_one_SM_active())
    {
        aud_llt_struct_type llt_trace_data;
        llt_trace_data.DataSize = sizeof(aud_dsp_gain_parms);
        llt_trace_data.LLT_Type_ID = E_audio_llt_type_id_0;
        memcpy( &llt_trace_data.llt_struct, &aud_dsp_gain_parms, sizeof(aud_dsp_gain_parms) );
    	
        aud_dsp_gain_parms.side_tone_fact = 0;  /* dangmaochang  xxxx, this line should move after loop test */

        DSP_ASYNC_VB_SET_GAIN(&aud_dsp_gain_parms);
#ifdef AUDIO_LLT
        aud_common_trace(llt_group_audio, llt_type_audio_dsp_VB_gain, 1, sizeof(llt_trace_data),  /* LLT params */
                         'd', 0x06,                                                               /* LIS params */
                         aud_log_lis_raw_data, aud_log_lis_display_data, aud_log_llt_trace,       /* LIS params */
                         (void*)&llt_trace_data );
#endif
    }
    /*[End] [lvwenhua-2010/7/28]*/
}

/*------------------------------------------------------------------------------
* Function...: aud_dsp_set_cbuf_gains
* Return.....: -
* Description: Program the circular buffer gain cells to the DSP.
* Modified...: dd.mm.yyyy by NN
------------------------------------------------------------------------------*/
void aud_dsp_set_cbuf_gains(void)
{
    /*[Begin] [lvwenhua-2010/7/28]*/
    if(aud_one_cbuf_SM_active())
    {
        DSP_ASYNC_CBUF_GAIN(&aud_dsp_cbuf_gain_parms);
#ifdef AUDIO_LLT
        aud_common_trace(llt_group_audio, llt_type_audio_dsp_CBUF_gain, 5, 0,                   /* LLT params */
                         'd', 0x07,                                                             /* LIS params */
                         aud_log_lis_display, aud_log_lis_display_data, aud_log_lis_llt_trace,  /* LIS params */
                         (U32) aud_dsp_cbuf_gain_parms.scal_sapp,
                         (U32) aud_dsp_cbuf_gain_parms.scal_ext,
                         (U32) aud_dsp_cbuf_gain_parms.mix_afe,
                         (U32) aud_dsp_cbuf_gain_parms.mix_i2s1,
                         (U32) aud_dsp_cbuf_gain_parms.scal_pcm );
#endif
    }
    /*[End] [lvwenhua-2010/7/28]*/
}

/*------------------------------------------------------------------------------
* Function...: aud_dsp_set_vm_gains
* Return.....: -
* Description: Program the Voice memo gain cells to the DSP.
* Modified...: dd.mm.yyyy by NN
------------------------------------------------------------------------------*/
void aud_dsp_set_vm_gains(void)
{
    DSP_ASYNC_VM_CMD(&aud_dsp_vm_parms); 
#ifdef AUDIO_LLT
    aud_common_trace(llt_group_audio, llt_type_audio_dsp_VM_gain, 7, 0,                     /* LLT params */
                     'd', 0x01,                                                             /* LIS params */
                     aud_log_lis_raw_data, aud_log_lis_display_data, aud_log_lis_llt_trace, /* LIS params */
                     (U32) aud_dsp_vm_parms.vm_mode,
                     (U32) aud_dsp_vm_parms.alpha0,
                     (U32) aud_dsp_vm_parms.alpha1,
                     (U32) aud_dsp_vm_parms.beta0,
                     (U32) aud_dsp_vm_parms.beta1,
                     (U32) aud_dsp_vm_parms.gamma0,
                     (U32) aud_dsp_vm_parms.gamma1 );
#endif
}

/*------------------------------------------------------------------------------
* Function...: aud_update_side_tone
* Return.....: -
* Description: Calculates the sidetone value based on path and volume settings.
* Modified...: dd.mm.yyyy by NN
------------------------------------------------------------------------------*/
/* The side tone depends on both paths, master volume, and speech muting */
void aud_update_side_tone(void)
{
    U8 cnt = 0;
    BOOL tty_active = FALSE;

    /* check whether aud_tty_uplink is active */
    while(aud_get_uplink_path_with_priority(cnt)<aud_uplink_source_end && FALSE==tty_active)
    {
        if(aud_tty_uplink == aud_get_uplink_path_with_priority(cnt))
        {
            tty_active = TRUE;
        }
        cnt++;
    }
    /* mute side tone if aud_tty_uplink is active */
    if(TRUE == tty_active)
    {
        aud_dsp_gain_parms.side_tone_fact = 0;
    }
    /* mute side tone if the speech resource is muted uplink */
    else if( (TRUE == aud_SM_active(aud_resource_speech)) &&
             (aud_mute_enable == aud_get_resource_mute_status_uplink(aud_resource_speech)) )
    {
        aud_dsp_gain_parms.side_tone_fact = 0;
    }
    /* otherwise, balance side tone against master volume and active paths */
    else
    {
        aud_dsp_gain_parms.side_tone_fact = aud_calc_side_tone_volume(aud_get_master_volume());
    }
}

/*------------------------------------------------------------------------------
* Function...: aud_update_mix_afe
* Return.....: -
* Description: Calculate the mix_afe value based on path and volume settings.
* Modified...: 20.08.2007 by KBJ (Mute mix_afe when master volume is muted)
------------------------------------------------------------------------------*/
/* mix_afe depends on the active paths and the master volume */
void aud_update_mix_afe(void)
{
    if(aud_mute_enable==aud_get_master_mute_status())
    {
        aud_dsp_cbuf_gain_parms.mix_afe = 0;
    }
    else if(aud_path_settings_result.downlink_parms.p_downlink_gain_cells->mix_afe)
    {
        aud_dsp_cbuf_gain_parms.mix_afe = aud_get_master_volume_digital();
    }
    else
    {
        aud_dsp_cbuf_gain_parms.mix_afe = 0;
    }
}

