/*******************************************************************************
 * Copyright (C) 2013, ZTE Corporation.
 *
 * File Name:  hal_init.c
 * File Mark:
 * Description:  hal layer  initialization
 * Others:
 * Version:       1.0
 * Author:        lmf
 * Date:          
 * History 1:
 *     Date: 	  
 *     Version:	
 *     Author: 	
 *     Modification:  
  ********************************************************************************/

/****************************************************************************
* 	                                           Include files
****************************************************************************/
#include "drvs_general.h"
#include "drvs_sys.h"		  	/*  for sys function  */
#include "NvConfig.h"
/****************************************************************************
* 	                                           Local Macros
****************************************************************************/
/*define the numbers of device that will be init firstly.*/
#define HAL_DEV_INIT_NUM_MAX       64
#if (defined _HAL_TEST)
extern VOID Hal_TestInit( VOID );
#define HAL_TEST() Hal_TestInit()
#else
#define HAL_TEST()
#endif
/****************************************************************************
* 	                                           Local Types
****************************************************************************/

typedef struct
{
    SINT32 (*Init)(VOID);
}
T_Hal_DevRegister;


/****************************************************************************
* 	                                           Local Constants
****************************************************************************/

/****************************************************************************
* 	                                           Local Function Prototypes
****************************************************************************/
extern SINT32 zDrv_Product_Halinit(VOID);
extern SINT32 	zDrvRtc_Initiate(VOID);
extern SINT32 zDrvNand_Read(UINT32 dwStart, UINT32 dwLen, UINT8* to);
/****************************************************************************
* 	                                          Global Constants
****************************************************************************/

/****************************************************************************
* 	                                          Global Variables
****************************************************************************/

#ifdef _CORE_ARM_PS
static T_Hal_DevRegister gHal_PlatDev_RegisterTbl[] =
    {
        /*00        config*/            	{zDrvConfig_Initiate},
		/*01	 io dev*/				{zDrvIODev_Initiate},
		/*02        rtc*/               //{zDrvRtc_Initiate},
        {NULL}
    };
#endif   /*_CORE_ARM_PS*/

#ifdef _CORE_ARM_PHY
static T_Hal_DevRegister gHal_PlatDev_RegisterTbl[] =
    {
        /*Number    Device Name         Device Init*/
        /*00        ramlog*/            	{zDrvRamLog_Initiate},
		/*01	 io dev*/				{zDrvIODev_Initiate},
        /*02        Timer*/             	{zDrvTimer_Initiate},
        /*03        Dma */	         		{zDrvDma_Initiate},
        /*04        icp */					{zDrvIcp_Initiate},
	 {NULL}
    };
#endif  /*_CORE_ARM_PHY*/


static UINT32 gHal_PlatDev_Num = (sizeof(gHal_PlatDev_RegisterTbl)/sizeof(T_Hal_DevRegister)) - 1;

/****************************************************************************
* 	                                          Global Function Prototypes
****************************************************************************/

/****************************************************************************
* 	                                          Function Definitions
****************************************************************************/

/*******************************************************************************
 * Function: zDrv_Halinit
 * Description: Initialize device drivers in hal
 * Parameters:
 *   Input:
 *
 *   Output:
 *
 * Returns:
 *
 *
 * Others:
 ********************************************************************************/
SINT32 zDrv_Halinit(VOID)
{
    UINT32 dev_index = 0;
    SINT32 nRet;

   /* if (gHal_PlatDev_Num > HAL_DEV_INIT_NUM_MAX)
    {
        return DRV_ERROR;
    }*/

    for (; dev_index<gHal_PlatDev_Num; dev_index++)
    {

        if (gHal_PlatDev_RegisterTbl[dev_index].Init !=NULL)
        {

            nRet = gHal_PlatDev_RegisterTbl[dev_index].Init();
            if (nRet != DRV_SUCCESS)
            {
                zOss_RamLog("Hal_init:init fail,dev_index=%d!\n", dev_index);
                zOss_RamLog("Hal_init:ret=%d!\n", nRet);
                zOss_ASSERT(0);
                return nRet;
            }
        }
    }
#ifdef _CORE_ARM_PS
    /*ͺŻصHalʼadded by limeifeng 2013.10.15*/
    nRet = zDrv_Product_Halinit();
    if (nRet != DRV_SUCCESS)
    {
        return nRet;
    }
#endif

    HAL_TEST();

    return DRV_SUCCESS;
}

/*******************************************************************************
 * Function: zDrv_Halinit
 * Description: Initialize device drivers in hal
 * Parameters:
 *   Input:
 *
 *   Output:
 *
 * Returns:
 *
 *
 * Others:
 ********************************************************************************/
SINT32 ARM1_Init(VOID)
{
    return DRV_SUCCESS;
}

/* added by lmf 2013/09/05*/
#if defined (_CORE_ARM_PS)
 
/**************************************************************************
* Function: zDrvNand_PhyNvReadToRam
* Description:Nand  LTE/TDS/GGE У׼NVݵRam, 
* Parameters:
*   Input:None
* Output: None
* Returns:None
**************************************************************************/
SINT32 zDrvNand_PhyNvReadToRam(VOID)		
{
    UINT32 index = 0;
    SINT32 ret = DRV_ERROR;
	#ifndef _USE_AMT
    while(g_PhyNVCfg[index].uNVFlashBaseAddr != PHY_NV_CFG_END)
    {
    	ret = zDrvNand_Read(g_PhyNVCfg[index].uNVFlashBaseAddr, g_PhyNVCfg[index].uNVSize , (UINT8*)g_PhyNVCfg[index].uNVRamBaseAddr);
	if(ret != 0)
	  return DRV_ERROR;
	index++;
    }
	#endif/*_USE_AMT*/
    return DRV_SUCCESS;
}
 
#endif/*_CORE_ARM_PS*/

