/*******************************************************************************
 * Copyright (C) 2007, ZTE Corporation.
 *
 * File Name:    hal_ring.c
 * File Mark:
 * Description:  ring buffer.
 * Others:
 * Version:       1.0
 * Author:        qinxiao
 * Date:          2009-09-03
 * History 1:     created
 *     Date:
 *     Version:
 *     Author:
 *     Modification:
 * History 2:
  ********************************************************************************/
#ifdef __cplusplus
   extern "C"
   {
#endif 
/**************************************************************************
 *                    Include files                                	    *
 **************************************************************************/
#include "oss_api.h"

#include "drvs_general.h"

/****************************************************************************
* 	                              Local Macros
****************************************************************************/
#define DATA_BUF_ALIGNMENT	3	
#define MIN(a,b) ((a)<(b)?(a):(b))
/****************************************************************************
* 	                               Local Types
****************************************************************************/

/****************************************************************************
* 	                               Local Constants
****************************************************************************/

/****************************************************************************
* 	                               Local Function Prototypes
****************************************************************************/
static VOID hal_RingCopy(const UINT8 *source, UINT8 *destination, UINT32 nbytes);
/****************************************************************************
* 	                               Global Constants
****************************************************************************/

/****************************************************************************
* 	                               Global Variables
****************************************************************************/

/****************************************************************************
* 	                               Function Definitions
****************************************************************************/
/******************************************************************************
 * Function:	hal_RingCreate
 * Description:		λ
 * Parameters:
 *   Input:
 *			nbytes -- λĴСλֽ
 *   Output:
 *			None
 * Returns:
 *			ɹλָ; ʧ:NULL
 *
 * Others:
 ******************************************************************************/
T_Hal_Ring *hal_RingCreate(UINT32 nBytes)
{
    T_Hal_Ring *ring = NULL;
    UINT8 *dataBuf = NULL;

    if(nBytes <= 0)
    {
        return NULL;
    }
    
    ring = zOss_Malloc(sizeof(T_Hal_Ring));

    if(ring == NULL)
    {
        //zDrv_ASSERT(0);
		printf("ring == NULL\n");
        return NULL;
    }

    zOss_Memset(ring, 0, sizeof(T_Hal_Ring));

    /*㷨ʹһֽڣҪһֽ*/
    dataBuf = zOss_Malloc(++nBytes);
    if(dataBuf == NULL)
    {
       //zDrv_ASSERT(0);
	   printf("dataBuf == NULL\n");
       zOss_Free(ring);
       return NULL;
    }
    zOss_Memset(dataBuf, 0, nBytes);
    
    ring->pBuf = dataBuf;

    ring->bufSize = nBytes;

    hal_RingFlush(ring);

    return ring;
}

/******************************************************************************
 * Function:	hal_RingDelete
 * Description:		ɾλ
 * Parameters:
 *   Input:
 *			pRing -- λָ
 *   Output:
 *			None
 * Returns:
 *			None
 *
 * Others:
 ******************************************************************************/
VOID hal_RingDelete(T_Hal_Ring *pRing)
{
    if(pRing == NULL)
    {
        printf("pRing == NULL\n");
        return;

    }
    
    if(pRing->pBuf == NULL)
    {
        printf("pRing->pBuf == NULL\n");
        zOss_Free(pRing);
        return;

    }

    zOss_Free(pRing->pBuf);
    zOss_Free(pRing);

    return;
}

/******************************************************************************
 * Function:	hal_RingFlush
 * Description:	λ
 * Parameters:
 *   Input:
 *			pRing -- λָ
 *   Output:
 *			None
 * Returns:
 *          None
 * Others: 
 ******************************************************************************/
VOID hal_RingFlush(T_Hal_Ring *pRing)
{
    if (pRing == NULL || pRing->pBuf == NULL)
    {
        //zDrv_ASSERT(0);
		printf("pRing == NULL || pRing->pBuf == NULL\n");
        return;
    }

    pRing->writePos = 0;
    pRing->readPos  = 0;
 
    zOss_Memset(pRing->pBuf, 0, pRing->bufSize);

    return;
}
/**************************************************************************
*:  Ring_Bcopy
* : ڴ渴ƺԴַĿĵַص
* ˵ (IN)
			source:Դַָ
			destination:Ŀĵַ
			nbytes:ҪƵֽ
                      (OUT)
*   ֵ:  None
* ˵:  
**************************************************************************/ 
static VOID hal_RingCopy(const UINT8 *source, UINT8 *destination, UINT32 nbytes)
{
    /*
    UINT8 *pDest = NULL;
    const UINT8 *pSource = NULL;
    UINT8 *pCopyEnd = NULL;
    SINT32 tmp = destination - source;
    UINT32 *pSrc32 = NULL,*pDest32 = NULL;
    UINT32 temp2 = 0;*/

   memmove((void*)destination, (void*)source, nbytes);
#if 0
    
    if (tmp <= 0 || tmp >= nbytes)
    {
        /* forward copy */
        pCopyEnd = destination + nbytes;
        pSource = source;
        pDest = destination;

        temp2 = ((UINT32)pDest ^ (UINT32)pSource) & DATA_BUF_ALIGNMENT;
        
        /* do int copy if bytes larger than ten or alignment match */
        if (nbytes >= 10 && temp2 == 0)
        {
            /* if odd-aligned copy byte */
            while ((UINT32)pDest & DATA_BUF_ALIGNMENT)
            {
                *(pDest++) = *(pSource++);
            }        

            pSrc32 = (UINT32 *)(pSource);
            pDest32 = (UINT32 *)(pDest);
            
            /*four bytes copy*/
            do
            {
                *pDest32++ = *pSrc32++;
            }
            while (((UINT8 *)pDest32 + sizeof (UINT32)) <= pCopyEnd);

            pDest = (UINT8 *)pDest32;
            pSource = (UINT8 *)pSrc32;
            
        }

        /*Byte copy*/
        while (pDest < pCopyEnd)
        {
            *pDest++ = *pSource++;
        }           
        
    }
    else
    {
        /* backward copy */
        pCopyEnd = destination;
        pDest = destination + nbytes;
        pSource = source + nbytes;
        
        temp2 = ((UINT32)pDest ^ (UINT32)pSource) & DATA_BUF_ALIGNMENT;
        
        /* do int copy if bytes larger than ten or alignment match */
        if (nbytes >= 10 && temp2 == 0)
        {
            /* if odd-aligned copy byte */
            while ((UINT32)pDest & DATA_BUF_ALIGNMENT)
            {
                *(--pDest) = *(--pSource);
            }

            pSrc32 = (UINT32 *)(pSource);
            pDest32 = (UINT32 *)(pDest);

            do
            {
                *(--pDest32) = *(--pSrc32);
            }while(((UINT8 *)pDest32 - sizeof(UINT32)) >= pCopyEnd);

            pSource = (UINT8 *)pSrc32;
            pDest = (UINT8 *)pDest32;
        }
        /*Byte copy*/
        if(pDest > pCopyEnd)
        {
            *(--pDest) = *(--pSource);
        }
    }
    #endif
}

/******************************************************************************
 * Function:	hal_RingRead
 * Description:		ȡλе
 * Parameters:
 *   Input:
 *			pRing -- λָ
 *			pBuffer -- ָ	  
 *			maxbytes -- Ҫȡֽ
 *   Output:
 *			buffer -- ָ	
 * Returns:
 *			ʵʶȡֽ
 *
 * Others: ֵҪȡֽһ¡Ϊգ򷵻0.
 ******************************************************************************/
UINT32 hal_RingRead(T_Hal_Ring *pRing, UINT8 *pBuffer, UINT32 maxBytes)
{
    //UINT32 writePos = 0, readPos = 0;
    UINT32 copiedBytes = 0,copiedBytes2 = 0;
    UINT32 pRingTemp = 0;
    
    if (pRing == NULL || pRing->pBuf == NULL || pBuffer == NULL)
    {
        //zDrv_ASSERT(0);
		printf("pRing == NULL || pRing->pBuf == NULL || pBuffer == NULL\n");
        return 0;
    }
    
    /*Buffer is empty*/
    if(pRing->writePos == pRing->readPos)
    {
        return 0;
    }   
    else if(pRing->writePos > pRing->readPos)
    {
        /*read Pos is ahead of write pos*/
        copiedBytes = MIN(maxBytes,(pRing->writePos - pRing->readPos));
        hal_RingCopy(&pRing->pBuf[pRing->readPos],pBuffer,copiedBytes);
        pRing->readPos += copiedBytes;
    }
    else
    {
		/* readPos has wrapped around, and its not 0, so we can read
		 * at least to the end of the ring buffer.  then see if we need
		 * to roll back and read more bytes at the beginning of the buffer. */
        copiedBytes = MIN(maxBytes,(pRing->bufSize - pRing->readPos));
        hal_RingCopy(&pRing->pBuf[pRing->readPos],pBuffer,copiedBytes);
        pRingTemp = pRing->readPos + copiedBytes;

        if(pRingTemp == pRing->bufSize)
        {
            if(copiedBytes < maxBytes)
            {
                copiedBytes2 = MIN(maxBytes - copiedBytes,pRing->writePos);
                hal_RingCopy(pRing->pBuf,(pBuffer + copiedBytes),copiedBytes2);
                pRing->readPos = copiedBytes2;
                copiedBytes += copiedBytes2;
            }
            else
            {
                pRing->readPos = 0;        
            }
        }
        else
        {
            pRing->readPos = pRingTemp;
        }
    }

    return copiedBytes;
}

/******************************************************************************
 * Function:	hal_RingWrite
 * Description:	λд
 * Parameters:
 *   Input:
 *			pRing -- λָ
 *			pBuffer -- ָ	  
 *			nBytes -- дݵĴС
 *   Output:
 *			None
 * Returns:
 *			ʵдֽ
 *
 * Others: ֵҪдֽһ¡Ϊ򷵻0.
 ******************************************************************************/
UINT32 hal_RingWrite(T_Hal_Ring * pRing, UINT8 *pBuffer, UINT32 nBytes)
{
    UINT32 writeBytes = 0, writeBytes2 = 0;
    UINT32 pRingTemp = 0;

    if(pRing == NULL || pRing->pBuf == NULL || pBuffer == NULL)
    {
        //zDrv_ASSERT(0);
		printf("pRing == NULL || pRing->pBuf == NULL || pBuffer == NULL\n");
        return 0;
    }

    if(hal_RingIsFull(pRing))
    {
        return 0;
    }

    if(pRing->writePos < pRing->readPos)
    {
		 /* writePos is ahead of readPos.  We can fill up to two bytes
		  * before it */
        writeBytes = MIN(nBytes,pRing->readPos - pRing->writePos -1);
        hal_RingCopy(pBuffer, &pRing->pBuf[pRing->writePos], writeBytes);
        pRing->writePos += writeBytes;
    }
    else if(pRing ->readPos == 0)
    {
        /* readPos is at the beginning of the buffer.  We can fill till
        * the next-to-last element */
        writeBytes = MIN(nBytes,pRing->bufSize- pRing->writePos -1);
        hal_RingCopy(pBuffer, &pRing->pBuf[pRing->writePos], writeBytes);
        pRing->writePos += writeBytes;
    }
    else
    {
		/* pFromBuf has wrapped around, and its not 0, so we can fill
		 * at least to the end of the ring buffer.  Do so, then see if
		 * we need to wrap and put more at the beginning of the buffer. */
		 writeBytes = MIN(nBytes,pRing->bufSize- pRing->writePos);
         hal_RingCopy(pBuffer, &pRing->pBuf[pRing->writePos], writeBytes);
         pRingTemp = pRing->writePos + writeBytes;
         if(pRingTemp == pRing->bufSize)
         {
            if(writeBytes< nBytes)
            {
                writeBytes2 = MIN(nBytes - writeBytes, pRing->readPos-1);
                hal_RingCopy(pBuffer + writeBytes, pRing->pBuf, writeBytes2);
                pRing->writePos = writeBytes2;
                writeBytes += writeBytes2;
            }
            else
            {
                pRing->writePos = 0;
            }           
         }
         else
         {
            pRing->writePos = pRingTemp;
         }
    }

    return writeBytes;
}

/******************************************************************************
 * Function:	hal_RingIsEmpty
 * Description:		жϻλǷΪ
 * Parameters:
 *   Input:
 *			pRing - :λָ
 *   Output:
 *			None
 * Returns:
 *			:TRUE; ǿ:FALSE
 *
 * Others:
 ******************************************************************************/
BOOL hal_RingIsEmpty( T_Hal_Ring *pRing)
{
    if(pRing == NULL)
    {
        //zDrv_ASSERT(0);
		printf("pRing == NULL\n");
		return 1;
    }

    return(pRing->readPos == pRing->writePos);
}

/******************************************************************************
 * Function:	hal_RingIsFull
 * Description:		жϻλǷ
 * Parameters:
 *   Input:
 *			pRing -- λָ
 *   Output:
 *			None
 * Returns:
 *			:TRUE; :FALSE
 *
 * Others:
 ******************************************************************************/
BOOL hal_RingIsFull(T_Hal_Ring *pRing)
{
    if(pRing == NULL)
    {
        //zDrv_ASSERT(0);
		printf("pRing == NULL\n");
		return 1;
    }
	
	SINT32 n = (pRing->writePos- pRing->readPos) + 1;

    return ((n == 0) || (n == pRing->bufSize));
}

/******************************************************************************
 * Function:	hal_RingFreeBytes
 * Description:	ȡλʣֽ
 * Parameters:
 *   Input:
 *			pRing -- λָ
 *   Output:
 *			None
 * Returns:
 *			ʣÿռֽ
 *
 * Others: 
 ******************************************************************************/
UINT32 hal_RingFreeBytes(T_Hal_Ring *pRing)
{
    if(pRing == NULL)
    {
        //zDrv_ASSERT(0);
		printf("pRing == NULL\n");
        return 0;
    }
	
	SINT32 n = (pRing->readPos - pRing->writePos) - 1;

    if (n < 0)
    {
        n += pRing->bufSize;
    }

    return n;
}

/******************************************************************************
 * Function:	hal_RingUsedBytes
 * Description:	ȡλʹõֽ
 * Parameters:
 *   Input:
 *			pRing -- λָ
 *   Output:
 *			None
 * Returns:
 *			ʹõֽ
 *
 * Others: 
 ******************************************************************************/
UINT32 hal_RingUsedBytes(T_Hal_Ring *pRing)
{
    if(pRing == NULL)
    {
        //zDrv_ASSERT(0);
		printf("pRing == NULL\n");
		return 0;
    }
	
	SINT32 n = pRing->writePos - pRing->readPos;
    
    if (n < 0)
	{
		n += pRing->bufSize;
	}

    return (n);
}
#if 0
/******************************************************************************
 * Function:	hal_RingGetPossibleReadBlock
 * Description:	ȡλɶȡָֽ
 * Parameters:
 *   Input:
 *			pRing -- λָ
 *   Output:
 *			nBytes -- ɶȡֽ
 *          UINT8 * -- bufferָ
 * Returns:
 *			ʹõֽ
 *
 * Others: 
 ******************************************************************************/
UINT8 *hal_RingGetPossibleReadBlock(T_Hal_Ring * pRing, UINT32 *nBytes)
{
    if(pRing == NULL)
    {
        //zDrv_ASSERT(0);
		printf("pRing == NULL\n");
    }

    *nBytes = hal_RingUsedBytes(pRing);

    return (pRing->pBuf + pRing->readPos);
}

/******************************************************************************
 * Function:	hal_RingMoveWritePos
 * Description:	λдָƶֽ
 * Parameters:
 *   Input:
 *			pRing -- λָ
 *          nBytes -- Ҫƶֽ,ǰƶƶ
 *                    Χ:-λֽ-- +λֽ
 *   Output:
 *			None
 * Returns:
 *          None
 * Others: дָ볬󳤶ʱԶ.
 ******************************************************************************/
VOID hal_RingMoveWritePos(T_Hal_Ring * pRing, SINT32 nBytes)
{
    nBytes += pRing->writePos;

    if (nBytes >= pRing->bufSize)
    {
        nBytes -= pRing->bufSize;
    }
    if(nBytes < 0)
    {
        nBytes += pRing->bufSize;
    }

    pRing->writePos = nBytes;
}

/******************************************************************************
 * Function:	hal_RingMoveAhead
 * Description:	λ嵱ǰдָƫƴдһ
 *              ƶдָ
 * Parameters:
 *   Input:
 *			pRing -- λָ
 *          byte:д
 *          offset -- ƫ, ǰƶ, ƶ;
 *                    Χ:-λֽ-- +λֽ,
 *   Output:
 *			None
 * Returns:
 *          None
 * Others: дָ볬󳤶ʱԶ.
 ******************************************************************************/
VOID hal_RingPutAhead(T_Hal_Ring * pRing, UINT8 byte, SINT32 offset)
{
    SINT32 n = pRing->writePos + offset;

    if (n >= pRing->bufSize)
    {
		n -= pRing->bufSize;
    }
    
    if (n < 0)
    {
		n += pRing->bufSize;
    }
    
    *(pRing->pBuf + n) = byte;
}

/******************************************************************************
 * Function:	hal_RingMoveReadPos
 * Description:	λĶָƶֽ
 * Parameters:
 *   Input:
 *			pRing -- λָ
 *          nBytes -- Ҫƶֽ,ǰƶƶ
 *                    Χ:-λֽ-- +λֽ
 *   Output:
 *			None
 * Returns:
 *          None
 * Others: дָ볬󳤶ʱԶ.
 ******************************************************************************/
VOID hal_RingMoveReadPos(T_Hal_Ring * pRing, SINT32 nBytes)
{
    nBytes += pRing->readPos;

    if (nBytes >= pRing->bufSize)
    {
        nBytes -= pRing->bufSize;
    }
    if(nBytes < 0)
    {
        nBytes += pRing->bufSize;
    }

    pRing->readPos = nBytes;
}
 #endif
 
