/************************************************************************
* Ȩ (C)2001,ͨѶɷ޹˾
* 
* ļƣ base_api.h
* ļʶ 
* ժҪ 
*
* ޸     汾     ޸ı     ޸	     ޸      
* ---------------------------------------------------------------------
* 2007/11/24	            V0.5	                                      	         create
************************************************************************/

#ifndef BASE_API_H_
#define	BASE_API_H_
/**************************************************************************
 *                        ͷļ                                      *
 **************************************************************************/
#include "oss_api.h"
#include "base_pub.h"


 /**************************************************************************
 *                                                                    *
 **************************************************************************/


/**************************************************************************
 *                         궨                                         *
 **************************************************************************/
/*KangShuJie 2008.04.03*/
#ifndef CLOCK_TICK
#define CLOCK_TICK       4615385  
#endif

#define P_many_receiver  126
#define P_no_receiver    125


#define HISR_ENTRY_CONG(HISR_NAME,ENTRY,PRIO,STACK_SIZE) \
{#HISR_NAME"HISR",ENTRY, &HISR_NAME##_HISR_control,STACK_SIZE,PRIO}

#define PROCESS_ENTRY(PROC_NAME,INSTANCE,ENTRY,PRIO,TIME_SLICE,STACK_SIZE) \
  #PROC_NAME":"#INSTANCE, ENTRY, &PROC_NAME##INSTANCE##_task, STACK_SIZE, \
  PRIO, TIME_SLICE, { ( P_##PROC_NAME + INSTANCE - 1 ), (queue_table+P_##PROC_NAME+INSTANCE-1) }

#define SIGNAL_NAME(SIG_NAME, SIG_IDNODE) \
   (XSIGTYPE)(SIG_NAME & (SIGREFTYPE)0xFFFFFFFF)

#define NU_SUSPEND      0xFFFFFFFFUL     

#define NU_MAX_NAME                     8

#define SDL_pid SDL_PId
#define SDL_Pid SDL_PId

#define SIGREFTYPE UINT32

#define XINPUTREFTYPE  SIGREFTYPE

#define XSIGTYPE  SIGREFTYPE

#define XSIGNALHEADERTYPE xSignalHeaderRec

/*SDL״̬*/
#define xInput                 (xInputAction)0
#define xSave                  (xInputAction)1
#define xDiscard              (xInputAction)2
#define xEnablCond         (xInputAction)3
#define xPrioInput           (xInputAction)4
#define xNotInSignalSet  (xInputAction)5

#define SDL_NULL                (SDL_PId)0

#define STARTUP_SIGNAL_NAME  SIGNAL_NAME(~0, 0)

#define OSS_TASKSELFID_BEGIN  0x00007f00

#define MS_OS_CRITICAL_SECTION_SUPPORT 1

/**************************************************************************
 *                                                                *
 **************************************************************************/
/*߳ں*/ 
typedef void (*ENTRY)(unsigned long, void *);
typedef void (*HISRENTRY)(void);

typedef struct s_queue *QID;

typedef QID        SDL_PId;

typedef struct xSignalHeaderStruct *xSignalHeader;
typedef struct xTimerHeaderStruct *xTimerHeader;

/**************************************************************************
*                         ݽṹ                                       *
**************************************************************************/
/*HISRƿ*/ 
typedef struct NU_HISR_STRUCT{
    UNSIGNED      words[22];   
    VOID(*hisrEntry)(VOID);
    ZOSS_THREAD_ID hisrTaskId;   
} NU_HISR;

/*߳ΣںͲ*/
typedef struct entryCb{
    ENTRY entry;
    unsigned long argc;
    VOID *argv;
}EntryCB;

/*HISR߳Σں*/
typedef struct hisrEntryCb{
    HISRENTRY entry;
}HisrEntryCB;

/*SDLIDͨѶID*/
struct args{
    UINT32   self_id;
    SDL_PId self;
};

/*SDL̵߳ǼǱ*/
struct process_desc{
    CHAR     *name;
    VOID     (*entry)(UNSIGNED, VOID *);
    ZOSS_THREAD_ID task;
    UNSIGNED stack_size;
    UINT32   prio;
    UNSIGNED time_slice;
    struct args args;
}; 

/*HISRǼǱ*/ 
struct hisr_desc{
    CHAR           *name;
    VOID           (*entry)( VOID );
    NU_HISR        *hcb;
    UNSIGNED stack_size;
    UINT32          prio;   
};

typedef struct NU_PROTECT_STRUCT
{
    UNSIGNED       words[2];
}NU_PROTECT;

/*źʶ*/
typedef struct NU_SEMAPHORE_STRUCT{
    ZOSS_SEMAPHORE_ID sem_id;
    UNSIGNED initial_count;
    DATA_ELEMENT sm_fifo_suspend;
}NU_SEMAPHORE;

/*SDLϢͷ*/
typedef struct xSignalHeaderStruct{
    xSignalHeader pred; 
    xSignalHeader succ; 
    SIGREFTYPE    SignalCode; 
    UINT32  sender_id; 
    SDL_PId          Sender;
}xSignalHeaderRec;

/*SDLͨѶID*/
typedef struct s_queue{
#if 0
    ZOSS_THREAD_ID  thread_id;
#endif
    xSignalHeaderRec list;
    ZOSS_SEMAPHORE_ID  events;
    ZOSS_MUTEX_ID  mutex;   
    VOID *ECB;
}t_queue;

/*SDLϸϢÿSDLԼά*/
typedef struct process_vars{
    SDL_PId           Offspring; 
    SDL_PId           Parent; 
    SDL_PId           Self; 
    SDL_PId           Sender; 
    xSignalHeaderRec  *yInSignalPtr; 
    xSignalHeaderRec  SaveQ; 
    xSignalHeader     CurrentInSaveQ; 
    UINT8     xState; 
    XINPUTREFTYPE     RestartAddress; 
    UINT32     SelfId;
}t_process_vars;

/*SDL״̬תƱ*/
typedef struct s_trans_desc{
  const xInputAction *ystah;
  const XINPUTREFTYPE *ystai;
}t_trans_desc;

/*ʱƿ飬ԵϢͷʹ*/
typedef struct xTimerHeaderStruct{
    xTimerHeader ee_succ; 
    xTimerHeader le_succ; 
    SIGREFTYPE   SignalCode; 
    SDL_PId      Sender; 
    SdlTimeSpec  ee_time; 
    SdlTimeSpec  le_time;
    t_timer_param param;
}xTimerHeaderRec;

#if 0
#define MAXIMUMTIMER  1024
typedef struct _TimerContext
{
	char timerName[MAX_THREADNAME_LEN];/* ʱ ,ֵͬ߳*/
	ZOSS_TIMER_FUN timerFun;	/* ʱִлص */
	UINT32 input;		/* صڲ */
	UINT32 timer_expire;	/* ʱʱʱʱ */
	UINT32 auto_activate;	/* ʱǷմþͼ */
	BOOL active;		/* ǰʱǷڼ״̬ */
	UINT32 index;		/* ǰĵ */
	ZOSS_TIMER_ID timerid;	/* ʱID */
	HANDLE threadHandle;	/* ʱ̵߳ľ */
	BOOL isInUse;		/* ǰǷѾʹ */
	BOOL cycle;		/* ǰʱԵĻִֻһ */
}TimerContext;
#endif

 /**************************************************************************
 *                        ȫֺԭ                                     *
 **************************************************************************/
 /*===========================================*/
/*ϵͳģ*/
/*===========================================*/
/**************************************************************************
* ƣ nu_is_booting
*  Ƿʼ
* ˵ (IN)
                               (OUT)
*   ֵ    TURE: the system is booted
                               FALSE: not completed
* ˵ 
**************************************************************************/
extern SINT32 nu_is_booting(VOID);

/**************************************************************************
* ƣ SDL_Task_Start
*  SDL 
* ˵ (IN)
                               process:
                               staticEntry:
                               (OUT)
*   ֵ    ɹZOSS_SUCCESSʧܷZOSS_ERROR
* ˵ 
**************************************************************************/
extern UINT32 SDL_Task_Start(struct process_desc *process);

/**************************************************************************
* ƣ Non_SDL_Task_Start
*  SDL 
* ˵ (IN)
                               process:
                               additionalEntry:
                               (OUT)
*   ֵ    ɹZOSS_SUCCESSʧܷZOSS_ERROR
* ˵ 
**************************************************************************/
extern UINT32 Non_SDL_Task_Start(struct process_desc *process);

/**************************************************************************
* ƣ HIRS_Task_Start
*  HISR 
* ˵ (IN)
                               hisr:
                               (OUT)
*   ֵ    ɹZOSS_SUCCESSʧܷZOSS_ERROR
* ˵ 
**************************************************************************/
extern UINT32 HIRS_Task_Start(struct hisr_desc *hisr);

/*===========================================*/
/*HISRģ*/
/*===========================================*/
/**************************************************************************
* :  NU_Create_HISR
* : HISR߳
* ˵: hisr:HISRָ
                 name:߳
                 hisr_entry:߳ں
		priority:ȼ
		stack_address:ջַ
		stack_size:ջС
*   ֵ:  ȷZOSS_SUCCESS󷵻ZOSS_ERROR
* ˵:  
**************************************************************************/
extern UINT32 NU_Create_HISR(NU_HISR *hisr, CHAR *name, VOID (*hisr_entry)(VOID), 
                                     OPTION priority, VOID *stack_address, UNSIGNED stack_size);

/**************************************************************************
* :  NU_Activate_HISR
* : HISR߳
* ˵: HISRָ
*   ֵ:  ȷZOSS_SUCCESS󷵻ZOSS_ERROR
* ˵:  
**************************************************************************/
extern UINT32 NU_Activate_HISR(NU_HISR *hisr);

/**************************************************************************
* : NU_Init_HISR_Sem
* : ʼHISR̵߳Ŀź
* ˵: 
*   ֵ:  
* ˵:  
**************************************************************************/
extern VOID NU_Init_HISR_Sem(VOID);
/**************************************************************************
* : NU_Wait_HISR_Sem
* : ȴźͷ
* ˵: 
*   ֵ:  
* ˵:  
**************************************************************************/
extern VOID NU_Wait_HISR_Sem(VOID);

/**************************************************************************
* :  NU_Delete_HISR
* : ɾHISR
* ˵: 
*   ֵ:  ȷZOSS_SUCCESS󷵻ZOSS_ERROR
* ˵:  
**************************************************************************/
// P98C-YXS extern UINT32 NU_Delete_HISR(NU_HISR *hisr);

/**************************************************************************
* :  NU_Current_HISR_Pointer
* : õǰHISRָ
* ˵: 
*   ֵ:  õǰHISRָ
* ˵:  
**************************************************************************/
// P98C-YXS extern NU_HISR *NU_Current_HISR_Pointer(VOID);

/**************************************************************************
* :  NU_Current_Task_Pointer
* : õǰָ
* ˵: 
*   ֵ: ǰָ
* ˵:  ж̷߳ؿ
**************************************************************************/
extern VOID *NU_Current_Task_Pointer(VOID);

/**************************************************************************
* :  NU_Create_Semaphore
* : ź
* ˵: semaphoreźָ
                  name:ź
                  initial_count:ʼֵ
                  suspend_type:
*   ֵ:  ȷZOSS_SUCCESS󷵻ZOSS_ERROR
* ˵:  
**************************************************************************/
extern UINT32 NU_Create_Semaphore(NU_SEMAPHORE *semaphore, CHAR *name, 
                                           UNSIGNED initial_count, OPTION suspend_type);

/**************************************************************************
* :  NU_Delete_Semaphore
* : ɾź
* ˵: semaphore:źָ
*   ֵ:  ȷZOSS_SUCCESS󷵻ZOSS_ERROR
* ˵:  
**************************************************************************/
extern UINT32 NU_Delete_Semaphore(NU_SEMAPHORE *semaphore);

/**************************************************************************
* :  NU_Obtain_Semaphore
* : ź
* ˵: semaphore:źָ
                  suspend:
*   ֵ: ȷZOSS_SUCCESS󷵻ZOSS_ERROR
* ˵:  
**************************************************************************/
extern UINT32 NU_Obtain_Semaphore(NU_SEMAPHORE *semaphore, UNSIGNED suspend);

/**************************************************************************
* :  NU_Release_Semaphore
* : ͷź
* ˵: semaphore:źָ
*   ֵ:  ȷZOSS_SUCCESS󷵻ZOSS_ERROR
* ˵:  
**************************************************************************/
extern UINT32 NU_Release_Semaphore(NU_SEMAPHORE *semaphore);

/**************************************************************************
* :  NU_Reset_Semaphore
* : ź
* ˵: semaphore:źָ
                 initial_count:ʼֵ
*   ֵ:  ȷZOSS_SUCCESS󷵻ZOSS_ERROR
* ˵:  
**************************************************************************/
extern UINT32 NU_Reset_Semaphore(NU_SEMAPHORE *semaphore, UNSIGNED initial_count);

/*===========================================*/
/*쳣ģ*/
/*===========================================*/
/**************************************************************************
* ƣnu_exception
*  쳣
* ˵ (IN)
                               line_number:
                               filename:ļ
                               un_status:״ֵ̬
                               (OUT)
*   ֵ    
* ˵ 
**************************************************************************/
// P98C-YXS extern VOID nu_exception (SINT32 line_number, CHAR *filename, STATUS nu_status);

/*===========================================*/
/*ڴģ*/
/*===========================================*/
/**************************************************************************
* : ps_calloc
* : һռ
* ˵: (IN)
                           nel:
                           size:ÿĴС
                           (OUT)
*   ֵ: 
* ˵: 
**************************************************************************/
extern VOID *ps_calloc(size_t nel, size_t size);

/**************************************************************************
* : ps_malloc
* : Ӷзռ
* ˵: (IN)
                           size:С                           
                           (OUT)
*   ֵ: 
* ˵: 
**************************************************************************/
extern VOID *ps_malloc(size_t size);

/**************************************************************************
* : zrealloc
* : ·ռ
* ˵: (IN)
                           block:ԭڴָ
                           newsize:µĴС
                           (OUT)
*   ֵ: 
* ˵: 
**************************************************************************/
extern VOID *zrealloc(void *block, size_t newsize);

/**************************************************************************
* : ps_free
* : ͷſռ
* ˵: (IN)
                           memp:ڴָ                          
                           (OUT)
*   ֵ: 
* ˵: 
**************************************************************************/
extern VOID  ps_free(void *memp);

#if 0
extern VOID *malloc_dma_buffer(size_t size);
extern VOID  free_dma_buffer(void *ptr);
#endif

/*===========================================*/
/*Ϣģ*/
/*===========================================*/
/**************************************************************************
* : alloc_sig_loc
* : Ϣռ
* ˵: (IN)
                           size:С
                           file:ļ
                           line:ʼֵ
                           (OUT)
*   ֵ:  ȷڴָ룬󷵻NULL
* ˵:  
**************************************************************************/
extern xSignalHeaderRec *alloc_sig_loc(UINT32 size, CHAR *file, SINT32 line);
#define alloc_sig(_size)      alloc_sig_loc ((_size), __FILE__, __LINE__)

/**************************************************************************
* : free_sig_loc
* : ͷϢռ
* ˵: (IN)
                           signal_ptr:Ҫͷŵڴָ
                           file:ļ
                           line:ʼֵ
                           (OUT)
*   ֵ:  
* ˵:  
**************************************************************************/
extern VOID free_sig_loc(xSignalHeaderRec *signal_ptr, CHAR *file, SINT32 line);
#define free_sig(_sig_ptr)    free_sig_loc((_sig_ptr), __FILE__, __LINE__)

/**************************************************************************
* : send_sig_loc
* : һSDL̷߳Ϣ
* ˵: (IN)
                           signal_ptr:Ϣ
                           rec_queue:նͷָ
                           sig_name:ź
                           file:ļ
                           line:
                           (OUT)
*   ֵ:  
* ˵:  
**************************************************************************/
extern void send_sig_loc(
    xSignalHeaderRec *signal_ptr, t_queue *rec_queue, char *sig_name, char *file, int line );

#define send_sig(_signal_ptr,_rec_queue ,_sig_name) \
    send_sig_loc ((_signal_ptr), (_rec_queue),(_sig_name), __FILE__, __LINE__)

/**************************************************************************
* : send_sig_no_to_loc
* : ϢһSDL̷߳Ϣ
* ˵: (IN)
                           signal_ptr:Ϣ
                           signal_cod:Ϣ
                           file:ļ
                           line:
                           (OUT)
*   ֵ:  
* ˵:  hehaijian  for win debug
**************************************************************************/
extern void send_sig_no_to_loc (
    xSignalHeaderRec *signal_ptr, unsigned signal_code, CHAR *file, SINT32 line );

#define send_sig_no_to(_signal_ptr, _signal_code, _sig_name ) \
    send_sig_no_to_loc ((_signal_ptr), ( _signal_code), __FILE__, __LINE__)

/**************************************************************************
* : send_startup_sig_loc
* : һSDL̷߳Ϣ
* ˵: (IN)
                           rec_queue:һ̷߳Ϣ
                           file:ļ
                           line:
                           (OUT)
*   ֵ:  
* ˵:  
**************************************************************************/
extern VOID send_startup_sig_loc (
    t_queue *rec_queue, CHAR *file, SINT32 line );

#define send_startup_sig(_rec_queue) \
    send_startup_sig_loc ((_rec_queue), __FILE__, __LINE__)

/**************************************************************************
* : receive_sig_loc
* : Ϣ
* ˵: (IN)
                           queue:Ϣͷ
                           file:ļ
                           line:
                           (OUT)
*   ֵ:  Ϣָ
* ˵:  SDL
**************************************************************************/
extern xSignalHeaderRec *receive_sig_loc(t_queue *queue, CHAR *file, SINT32 line);
#define receive_sig(_queue)   receive_sig_loc ((_queue), __FILE__, __LINE__)

/*===========================================*/
/*SDLʱģ*/
/*===========================================*/
/**************************************************************************
* : SDL_Set_Dur
* : һSDLʱ
* ˵: (IN)
                           Tick_Expr:ʱ
                           timer_name:ʱ
                           timer_param:ʱ
                           yVarP:߳Ϣָ
                           (OUT)
*   ֵ: 
* ˵:  Ҷʱҵָ򴴽һµ
**************************************************************************/
extern VOID SDL_Set_Dur(SDL_Duration Tick_Expr, UINT32 timer_name,
                   t_timer_param timer_param, t_process_vars *yVarP,BYTE sample_id);

/**************************************************************************
* : SDL_Set_Dur_Ex
* : һSDLʱ
* ˵: (IN)
                           Earliest_Tick_Expr:ʱ
                           Latest_Tick_Expr:ʱ
                           timer_name:ʱ
                           timer_param:ʱ
                           yVarP:߳Ϣָ
                           (OUT)
*   ֵ: 
* ˵:  Ҷʱҵڻָ򴴽һµ
**************************************************************************/
extern VOID SDL_Set_Dur_Ex(SDL_Duration Earliest_Tick_Expr, SDL_Duration Latest_Tick_Expr,
                      UINT32 timer_name, t_timer_param timer_param, t_process_vars *yVarP,BYTE sample_id);

/**************************************************************************
* : SDL_Set
* : һSDLʱ
* ˵: (IN)
                           Tick_Expr:ʱ
                           timer_name:ʱ
                           timer_param:ʱ
                           yVarP:߳Ϣָ
                           (OUT)
*   ֵ: 
* ˵:  Ҷʱҵָ򴴽һµ
**************************************************************************/
// P98C-YXS extern VOID SDL_Set(SDL_Time Time, UINT32 timer_name,
// P98C-YXS                t_timer_param timer_param, t_process_vars *yVarP);

/**************************************************************************
* : SDL_Set_Ex
* : һSDLʱ
* ˵: (IN)
                           Earliest_Tick_Expr:ʱ
                           Latest_Tick_Expr:ʱ
                           timer_name:ʱ
                           timer_param:ʱ
                           yVarP:߳Ϣָ
                           (OUT)
*   ֵ: 
* ˵:  Ҷʱҵָ򴴽һµ
**************************************************************************/
// P98C-YXS extern VOID SDL_Set_Ex(SDL_Time Earliest_Time, SDL_Time Latest_Time, UINT32 timer_name,
// P98C-YXS                t_timer_param timer_param, t_process_vars *yVarP);

/**************************************************************************
* : SDL_Reset
* : ɾһSDLʱ
* ˵: (IN)
                           timer_name:ʱ
                           timer_param:ʱ
                           yVarP:߳Ϣָ
                           (OUT)
*   ֵ: 
* ˵:  
**************************************************************************/
extern VOID SDL_Reset (UINT32 TimerName, t_timer_param timer_param,
                 t_process_vars *yVarP,BYTE sample_id);

/**************************************************************************
* : SDL_Active
* : 鶨ʱǷ
* ˵: (IN)
                           timer_name:ʱ
                           timer_param:ʱ
                           yVarP:߳Ϣָ
                           (OUT)
*   ֵ: ڷTRUE򷵻FALSE
* ˵:  
**************************************************************************/
// P98C-YXS extern SDL_Boolean SDL_Active(UINT32 TimerName, t_timer_param timer_param,
// P98C-YXS                          t_process_vars *yVarP);

extern SDL_Time RetrieveClock(BYTE sample_id);

extern SDL_Duration SDL_Duration_Lit (SINT32 secs, SINT32 nsecs);

/*===========================================*/
/*SDLģ*/
/*===========================================*/
/**************************************************************************
* : SDL_Create
* : һSDL
* ˵: (IN)
                           task_entry:ں
                           stack_size:ջС
                           self_id:ID
                           prio:ȼ
                           task_name:
                           startup_signal:ʼϢ
                           (OUT)
*   ֵ: 
* ˵: 
**************************************************************************/
extern SDL_PId SDL_Create (
     VOID ( *task_entry )( UNSIGNED argc, VOID *argv ),
     SINT32 stack_size,
     SINT32 self_id,
     SINT32 prio,
     CHAR *task_name,
     xSignalHeader startup_signal
    );

/**************************************************************************
* : SDL_Stop
* : ɾһSDL
* ˵: (IN)
                           varp:߳Ϣ
                           yInSignalPtr:Ϣָ
                           self_if:ID
                           (OUT)
*   ֵ: 
* ˵: еãһɾԼ
**************************************************************************/
extern VOID SDL_Stop(t_process_vars *varp, xSignalHeaderRec *yInSignalPtr);

/**************************************************************************
* : SDL_Loop
* : ѭϢ
* ˵: (IN)
                           proc_insig_tab:Ϣ״̬
                           trans_tab:״̬תƾ
                           yVarP:߳Ϣṹָ
                           self_id:߳ID
                           (OUT)
*   ֵ: Ϣָ
* ˵: 
**************************************************************************/
extern xSignalHeaderRec *SDL_Loop(const XSIGTYPE *proc_insig_tab,
                                  const t_trans_desc *trans_tab,
                                  struct process_vars *yVarP,
                                  char *file, int line);

#endif

