/********************************************************************
* Ȩ (C)2001, ͨѶɷ޹˾
*
* ļƣw_nv_param.h
* ļʶ
* ժҪ
* ˵㹲ͷļ
* ǰ汾
*     ߣ
* ڣ
*
* ޸    汾     ޸	     ޸
* -----------------------------------------------
  2014.08.18  V1.0             ½
  2014.08.27  V1.1             ûNVУ׼NVƵݣ޸ԭṹ岿ֲ
  2014.09.10  V1.2             ŻUserNv߿NVṹ
  2014.09.10  V1.3             ޸ֶ֧APT
  2014.11.12  V1.4             ӲƵУ׼NV
********************************************************************/
#ifndef _W_NV_PARAM_H
#define _W_NV_PARAM_H

/************************************************************************/
/*                            У׼NV                            */
/************************************************************************/
#define FREQ_MAX                    12     /* Ƶ֧Ƶ */
#define FDT_TX_INIT_POW             10      /* ʼ书10dbm */
#define FDT_TX_POW_STEP_LEN         6       /* TX APCУ׼ʱÿʵʱ䣬λSlot */
#define FDT_RX_AGC_STEP_ELN         (FDT_TX_POW_STEP_LEN << 1)       /* RX AGCУ׼ʱÿʵAGCʱ䣬λSlotPA棬˴Ϊ9Ƶʱ迼ƵӦ */

#define TX_APC_POW_PA_HIGH_MAX          ((signed short)(112))        /* ((signed short)(28 * 4))  PAΧ28~-6dbm */
#define TX_APC_POW_PA_HIGH_MIN          ((signed short)(-24))        /* ((signed short)((-6) * 4)) */
#define TX_APC_NV_PA_HIGH_LEN           ((unsigned short)(137))      /* ((unsigned short)(TX_APC_POW_PA_HIGH_MAX - TX_APC_POW_PA_HIGH_MIN + 1)) */

#define TX_APC_POW_PA_LOW_MAX           ((signed short)(56))         /* ((signed short)(14 *4))         PAΧ14~-60dbm */
#define TX_APC_POW_PA_LOW_MIN           ((signed short)(-240))       /* ((signed short)((-60) * 4)) */
#define TX_APC_NV_PA_LOW_LEN            ((unsigned short)(297))      /* ((unsigned short)(TX_APC_POW_PA_LOW_MAX - TX_APC_POW_PA_LOW_MIN + 1)) */

#define RX_AGC_POW_MAX                  ((signed short)(-19))        /* У׼ʷΧ-19~-110dbm */
#define RX_AGC_POW_MIN                  ((signed short)(-110))
#define RX_AGC_NV_LEN                   ((unsigned short)(92))       /* ((unsigned short)(RX_AGC_POW_MAX - RX_AGC_POW_MIN + 1)) */

#define FREQ_COMP_NUM                    32                          /* ƵÿƵڵĶ */
#define TMP_COMP_NUM                     40                          /* ²ÿƵڵ */

#define TX_APC_PA_HIGH_LEN_MAX           300
#define TX_APC_PA_MID_LEN_MAX            300
#define TX_APC_PA_LOW_LEN_MAX            600

typedef struct
{
    unsigned short wApcInd;
    unsigned short wAptDac;
}T_WcdmaFdtApcCtrlInfo;

typedef struct
{
    unsigned short wFreqTx;
    unsigned short wFreqRx;
}T_WcdmaFdtFreqInfo;

typedef struct
{
    unsigned short          wTotalSlotLen;                                       /* wTotalSlotLen = (wPaHighLen+wPaMidLen+wPaLowLen)*FDT_TX_POW_STEP_LEN */
    unsigned short          wPaHighLen;                                          /* ƵPAΪ湦ʵ */
    unsigned short          wPaMidLen;                                           /* ƵPAΪ湦ʵ */
    unsigned short          wPaLowLen;                                           /* ƵPAΪ湦ʵ */
    
    T_WcdmaFdtApcCtrlInfo   tWcdmaFdtApcPaHighCtrlInfo[TX_APC_PA_HIGH_LEN_MAX];
    T_WcdmaFdtApcCtrlInfo   tWcdmaFdtApcPaMidCtrlInfo[TX_APC_PA_MID_LEN_MAX];
    T_WcdmaFdtApcCtrlInfo   tWcdmaFdtApcPaLowCtrlInfo[TX_APC_PA_LOW_LEN_MAX];
}T_WcdmaFdtPaCtrlInfo;


typedef struct
{
    unsigned short wApcIndex;
	unsigned short wPadding;
    signed short   swReg285;
    signed short   swReg286;
    signed short   swReg285_10MHz;   /*reg285/10MHz*/
    signed short   swReg286_10MHz;   /*reg286/10MHz*/
}T_WcdmaFdtDcocData;

/* AMT FDT stepṹ */
typedef struct
{
    unsigned short wCenterChannel;  /*DCOCУ׼Ƶ*/
    unsigned short wNum;            /*DCOCУ׼Ч֧6*/
    T_WcdmaFdtDcocData wDcoc[6];    /*DCOCУ׼*/
}T_WcdmaFdtDcocInfo;

/* PCL1WУ׼Ϣ */
typedef struct
{

    unsigned short          wFreqNum;                                            /* ƵӦһwFreqNumȷЧƵ */
    unsigned short          wPadding;

    T_WcdmaFdtFreqInfo      tWcdmaFdtFreqInfo[FREQ_MAX];

    T_WcdmaFdtPaCtrlInfo    tWcdmaFdtPaCtrlInfo;

	T_WcdmaFdtDcocInfo      tWcdmaFdtDcocInfo;
}T_WcdmaFdtCtrlInfo;



/************************************************************************/
/*                           RFУ׼ֵNV                             */
/************************************************************************/

typedef struct
{
    unsigned short  wRate;
    signed short    swFreqErr;
    unsigned short  awReserved[10];
}T_WcdmaNvAfcCalibData;

typedef struct
{
    unsigned long    dCtrlWord0;
    unsigned long    dCtrlWord1;
    unsigned long    dAptDac0;
    unsigned long    dAptDac1;
}T_WcdmaNvApcCtrlWord;

typedef struct
{
    unsigned long    dCtrlWord0;
    unsigned long    dCtrlWord1;
}T_WcdmaNvAgcCtrlWord;

typedef struct
{
    T_WcdmaNvApcCtrlWord   atWcdmaNvApcCtrlWordPaH[TX_APC_NV_PA_HIGH_LEN];
    T_WcdmaNvApcCtrlWord   atWcdmaNvApcCtrlWordPaL[TX_APC_NV_PA_LOW_LEN];
}T_WcdmaNvApcCalibData;

typedef struct
{
    T_WcdmaNvAgcCtrlWord   atWcdmaNvAgcMainCtrlWord[RX_AGC_NV_LEN];
    T_WcdmaNvAgcCtrlWord   atWcdmaNvAgcAuxCtrlWord[RX_AGC_NV_LEN];
}T_WcdmaNvAgcCalibData;

typedef struct
{
    signed short           aswWcdmaNvApcFreqCompPaH[FREQ_COMP_NUM];
    signed short           aswWcdmaNvApcFreqCompPaL[FREQ_COMP_NUM];
}T_WcdmaNvApcFreqCompData;

typedef struct
{
    signed short           aswWcdmaNvAgcFreqCompMain[FREQ_COMP_NUM];
    signed short           aswWcdmaNvAgcFreqCompAux[FREQ_COMP_NUM];
}T_WcdmaNvAgcFreqCompData;

typedef struct
{
    unsigned short      wTmpVal;       /* ADC¶ֵ */
    signed short        swDeltaPow;     /* ͬ¶볣书ʵĲֵ */
}T_WcdmaNvApcTmpCompData;


typedef struct
{
    unsigned long        dGroup;
    unsigned long        dRxMain;
    unsigned long        dRxAux;
    unsigned long        dRxAll;
    unsigned long        dTx;
    unsigned long        dIdleRxMain;
    unsigned long        dIdleRxAux;
    unsigned long        dIdleRxAll;
    unsigned long        dIdleTx;
    unsigned long        dIdle;
    unsigned long        adReserved[6];
}T_WcdmaNvSwitchGpioCtrlWord;

typedef struct
{
    unsigned long        dRxMain;
    unsigned long        dRxAux;
    unsigned long        dRxAll;
    unsigned long        dTx;
    unsigned long        dIdleRxMain;
    unsigned long        dIdleRxAux;
    unsigned long        dIdleRxAll;
    unsigned long        dIdleTx;
    unsigned long        dIdle;
    unsigned long        adReserved[6];
}T_WcdmaNvSwitchMipiCtrlWord;

typedef struct
{
    T_WcdmaNvSwitchGpioCtrlWord tWcdmaNvSwitchGpioCtrlWord0;
    T_WcdmaNvSwitchGpioCtrlWord tWcdmaNvSwitchGpioCtrlWord1;
    unsigned long               adReserved0[32];

    T_WcdmaNvSwitchMipiCtrlWord tWcdmaNvSwitchMipiCtrlWord0;
    T_WcdmaNvSwitchMipiCtrlWord tWcdmaNvSwitchMipiCtrlWord1;
    unsigned long               adReserved1[30];
}T_WcdmaNvSwitchData;


typedef struct
{
    unsigned long        dGroup;
    unsigned long        dPaHigh;
    unsigned long        dPaMid;
    unsigned long        dPaLow;
	unsigned long        dIdle;
    unsigned long        adReserved[7];
}T_WcdmaNvPaGpioCtrlWord;

typedef struct
{
    unsigned long        dPaHigh;
    unsigned long        dPaMid;
    unsigned long        dPaLow;
	unsigned long        dIdle;
    unsigned long        adReserved[7];
}T_WcdmaNvPaMipiCtrlWord;

typedef struct
{
    T_WcdmaNvPaGpioCtrlWord tWcdmaNvPaGpioCtrlWord0;
    T_WcdmaNvPaGpioCtrlWord tWcdmaNvPaGpioCtrlWord1;
    unsigned long           adReserved0[24];

    T_WcdmaNvPaMipiCtrlWord tWcdmaNvPaMipiCtrlWord0;
    T_WcdmaNvPaMipiCtrlWord tWcdmaNvPaMipiCtrlWord1;
    unsigned long           adReserved1[22];
}T_WcdmaNvPaData;

typedef struct
{
    signed   short      swTxMaxPow;
    unsigned short      awResved[39];
}T_WcdmaNvCtrl;

typedef enum
{
    APC_CALIB_PATCH_B1=0,
    APC_CALIB_PATCH_B2,
    APC_CALIB_PATCH_B5,
    APC_CALIB_PATCH_B8,
}E_ApcCalibPatchBand;

typedef struct
{
    unsigned long               dPatchFlag;                                 /* ƵӦƵ 0:B1,1:B2,2:B5,3:B8 */
    unsigned long               dPatchHL;                           		/* ߵѡ 0:ߣ1: */
    unsigned long               dPatchfreq;                                 /* Ƶ磬(С)ڴƵȡPatchеУ׼ֵ */
    T_WcdmaNvApcCalibData       tWcdmaNvApcCalibDataPatch;                  /* ƵУ׼ֵ */
}T_WcdmaNvApcCalibPatch;
/* AMTУ׼صNV */
typedef struct
{
    unsigned short              wTotalLen;                                  /* ܳȣλBYTE */
    signed   short              swRssiOffset;                               /* RSSIƫֵ */

	unsigned long               adReserved[20];

    T_WcdmaNvAfcCalibData       tWcdmaNvAfcCalibData;                       /* AFCУ׼NV */

    /* B1ƵУ׼Ϣ */
    T_WcdmaNvApcCalibData       tWcdmaNvApcCalibDataB1;                     /* B1ƵAPCУ׼ֵ */
    T_WcdmaNvApcFreqCompData    tWcdmaNvApcFreqCompDataB1;                  /* B1ƵAPCƵֵ */
    T_WcdmaNvAgcCalibData       tWcdmaNvAgcCalibDataB1;                     /* B1ƵAGCУ׼ֵ */
    T_WcdmaNvAgcFreqCompData    tWcdmaNvAgcFreqCompDataB1;                  /* B1ƵAGCƵֵ */

	/* B2ƵУ׼Ϣ */
    T_WcdmaNvApcCalibData       tWcdmaNvApcCalibDataB2;                     /* B2ƵAPCУ׼ֵ */
    T_WcdmaNvApcFreqCompData    tWcdmaNvApcFreqCompDataB2;                  /* B2ƵAPCƵֵ */
    T_WcdmaNvAgcCalibData       tWcdmaNvAgcCalibDataB2;                     /* B2ƵAGCУ׼ֵ */
    T_WcdmaNvAgcFreqCompData    tWcdmaNvAgcFreqCompDataB2;                  /* B2ƵAGCƵֵ */

    /* B5ƵУ׼Ϣ */
    T_WcdmaNvApcCalibData       tWcdmaNvApcCalibDataB5;                     /* B5ƵAPCУ׼ֵ */
    T_WcdmaNvApcFreqCompData    tWcdmaNvApcFreqCompDataB5;                  /* B5ƵAPCƵֵ */
    T_WcdmaNvAgcCalibData       tWcdmaNvAgcCalibDataB5;                     /* B5ƵAGCУ׼ֵ */
    T_WcdmaNvAgcFreqCompData    tWcdmaNvAgcFreqCompDataB5;                  /* B5ƵAGCƵֵ */

	/* B8ƵУ׼Ϣ */
    T_WcdmaNvApcCalibData       tWcdmaNvApcCalibDataB8;                     /* B8ƵAPCУ׼ֵ */
    T_WcdmaNvApcFreqCompData    tWcdmaNvApcFreqCompDataB8;                  /* B8ƵAPCƵֵ */
    T_WcdmaNvAgcCalibData       tWcdmaNvAgcCalibDataB8;                     /* B8ƵAGCУ׼ֵ */
    T_WcdmaNvAgcFreqCompData    tWcdmaNvAgcFreqCompDataB8;                  /* B8ƵAGCƵֵ */

    /* ƵУ׼Ϣ */
    unsigned long               dPatchEnable;                               /* ƵУ׼ʹܱ־ */  
    T_WcdmaNvApcCalibPatch      tWcdmaNvApcCalibPatch;                      /* ƵУ׼Ϣ */
}T_WcdmaCalibNv;

typedef struct
{
    unsigned long		dDac0PaH;
	unsigned long		dDac1PaH;
	unsigned long		dDac0PaL;
	unsigned long		dDac1PaL;
    unsigned long       adResved[12];
}T_WcdmaNvApt;

/* ͺŻNV߿ءPA² */
typedef struct
{
    unsigned short              wTotalLen;                                  /* ܳȣλBYTE */
    unsigned short              wPadding;

    unsigned long               adReserved[40];

    T_WcdmaNvCtrl               tWcdmaNvCtrl;                               /* صNV */

	T_WcdmaNvApt				tWcdmaNvApt;								/* APTNV */

    T_WcdmaNvApcTmpCompData     atWcdmaNvApcTmpCompDataB1[TMP_COMP_NUM];    /* B1ƵAPC² */
    T_WcdmaNvSwitchData         tWcdmaNvSwitchDataB1;                       /* B1Ƶ߿ */
    T_WcdmaNvPaData             tWcdmaNvPaDataB1;                           /* B1ƵPA */

	T_WcdmaNvApcTmpCompData     atWcdmaNvApcTmpCompDataB2[TMP_COMP_NUM];    /* B2ƵAPC² */
    T_WcdmaNvSwitchData         tWcdmaNvSwitchDataB2;                       /* B2Ƶ߿ */
    T_WcdmaNvPaData             tWcdmaNvPaDataB2;                           /* B2ƵPA */

	T_WcdmaNvApcTmpCompData     atWcdmaNvApcTmpCompDataB5[TMP_COMP_NUM];    /* B5ƵAPC² */
    T_WcdmaNvSwitchData         tWcdmaNvSwitchDataB5;                       /* B5Ƶ߿ */
    T_WcdmaNvPaData             tWcdmaNvPaDataB5;                           /* B5ƵPA */

    T_WcdmaNvApcTmpCompData     atWcdmaNvApcTmpCompDataB8[TMP_COMP_NUM];    /* B8ƵAPC² */
    T_WcdmaNvSwitchData         tWcdmaNvSwitchDataB8;                       /* B8Ƶ߿ */
    T_WcdmaNvPaData             tWcdmaNvPaDataB8;                           /* B8ƵPA */
}T_WcdmaUserNv;


/************************************************************************/
/*                           NV                                 */
/************************************************************************/
/********** L1S NV**********/
typedef struct
{
    unsigned short wL1wSegUpdateNum;        /* Դʹãÿָ֡Ϣʱ̸ıһ   (Ĭֵ:16) */
    unsigned short wL1wRfctrlStartIndex;    /* Դʼλõ֡           (Ĭֵ:0) */
    unsigned short wL1wRfctrlStartSlot;     /* Դʼλƫ                 (Ĭֵ:6) */
    unsigned short wL1wRfctrlEndSlot;       /* Դλƫ                 (Ĭֵ:5) */
    unsigned short wL1wDchRfctrlStartSlot;  /* DCH̬Դʼλƫ            (Ĭֵ:12) */
	unsigned short wL1wDchRfctrlEndSlot;    /* DCH̬Դλƫ            (Ĭֵ:11) */
	unsigned short wL1wFreqChProtectChip;   /* ͬƵƵıλchips      (Ĭֵ:768) */
    unsigned short wEngReserved[5];         /*  */
}T_L1wNvL1sCmn;

typedef struct
{
    unsigned short wStep1Slot;                      /*STEP1ۼʱ϶Ĭֵ30*/
    unsigned short wStep2Slot;                      /*STEP2ۼʱ϶Ĭֵ60*/
    unsigned short wStep3Slot;                      /*STEP3ۼʱ϶Ĭֵ15*/
    unsigned short wFsAcclength;                    /*FULLSCANۼӳȣĬֵ4*/
    unsigned long  wStep23ResLength;                /*STEP23ԴȣĬֵ16*38400*/
    unsigned short wCsAbortTime;                    /*CS Abort time1000,Ĭֵ10*/
	unsigned short wEngReserved[5];                 /*  */
}T_L1wNvCs;

/********** BCH NV **********/
typedef struct
{
	unsigned short	wBchAfcSlotNum;			/* BCHCPICHս׶ΣAFCͶٸʱ϶ݣĬֵ: 13 */
	unsigned short	wPichAfcSlotNum;		/* PICHս׶Σ AFCͶٸʱ϶ݣĬֵ: 3 */

	unsigned short	wMinPichCfgAheadChip;	/* PICHʱӲӦǰCHIPĬֵ: 2560 */
	unsigned short	wNormBchCfgAheadChip;	/* step5ӲǰãǰٸCHIPĬֵ: 3072 */
	unsigned short	wMaxBchCfgAheadChip;	/* step5ӲǰãǰٸCHIPĬֵ: 3584 */
	unsigned short	wMaxBchIntDelayChip;	/* step5ӲBCHʱжϾ֡βٸCHIP Ĭֵ: 3584 */
	unsigned short	wBchFilterChipLen;		/* step5ӲǰCPICHӴCHIPĬֵ2048 */
	unsigned short	wPichStartAheadChip;	/* PICHӲPAGEPiPosǰĬֵ1536 */

	unsigned short	wBchSlotendIntIndex;	/* step5ӲCPICHʱ϶жĬֵ: 4 */
	unsigned short	wBchCrcIntIndex;		/* step5ӲBCHPICHжĬֵ: 5 */

	unsigned short	wAfcConvergeLen;		/* AFCƵƫԴ׼ÿι֡Ĭֵ: 3 */
	unsigned short	wAfcLockOldInterval;	/* AFCƵƫ־ϻʱ䣬Ĭֵ: 10 */

	unsigned short	wMaxBchSerialIntDelay;	/* BCH֡жϣȴʱ䣬Ĭֵ: 11 */
	unsigned short	wMaxPreSyncTryCount;	/* ǰSFN봦ೢԴĬֵ: 8 */
	unsigned short  wMaxBchDecodeIntCnt;	/* BCHжϣжϴĬֵ: 8 */
	unsigned short  wL1wBchReserved0[1];    /*  */

	unsigned short	wPathOldInterval;		/* ྶϻʱ䣬Ĭֵ: 4 */
	unsigned short	wBchInnerSchedMinDist;	/* BCH_OPEN׶ΣʱڲʱСSIB룬Ĭֵ: 9 */

	unsigned long	wCpichIntMask;			/* CPICHжΣĬֵ: 0x000003f0 */
	unsigned long	wMaxAfcRuntime;			/* AFCʱ䣬Ĭֵ: 0xfff */
	unsigned short  wL1wBchReserved1[14];/*  */
}T_L1wNvBch;

/********** PSR NV **********/
typedef struct
{
	unsigned short  wAdvanceTime;       /*ǰ32sampleӲ                       ֵĬΪ  32*/
	unsigned short  wPsrWorkFrame;      /*PSRӲ֡                            ֵĬΪ4*/
	unsigned short  wPsrCalMode;        /*PSRӲļģʽ                            ĬΪ4*/
	unsigned short  wPsrUpdateRl;       /*PSR߽֡ʱҪӵ֡                    ֵĬΪ5*/
	unsigned short  wSrchLength;        /*,                                    ĬΪ640*/
	unsigned short  wPathDetectDiff;    /*о                             ĬΪ3*/
	unsigned short  wPathDetectIndex;   /*С                         ĬΪ1*/
	unsigned short  wOutStepThr;        /*ͬеʧ                         ĬΪ3*/
	unsigned short  wSyncThr;           /*ͬеͬ                         ĬΪ2*/
	unsigned short  wFigUpdateFator;    /*ָˢ0.8165ΪU(16,15),          ĬΪ26755*/
	unsigned short  wFigUpdateDeno;     /*ָˢ0.8165ΪU(16,15),Ҫ15λֵĬΪ15*/
	unsigned short  wCandUpdateThr;     /*ѡָˢµľֵ                       ĬΪ3*/
	unsigned short  wAdrWindowFator;    /*ADR0.9ΪU(16,16),            ֵĬΪ58982*/
	unsigned short  wAdrWindowDeno;     /*ADR0.9ΪU(16,16),            ֵĬΪ16*/
	unsigned short  wFstStrongDiff;     /*ǿ羶ľ                       ĬΪ8*/
	unsigned short  wNoiseThrFathr;     /*ֵ1.6ΪU(16,14),           ĬΪ26214*/
	unsigned short  wMaxThrFathr;       /*ֵֵ0.28ΪU(16,16),          ĬΪ18350*/
	unsigned short  wIntiMaxThrFathr;   /*־ֵֵ0.24*1.2 ΪU(16,16), ĬΪ18874*/
	unsigned short  wIntiNoiseThrFathr; /*־ֵ1.6*1.2 ΪU(16,14),    ĬΪ34157*/
	unsigned short  wMaxDeno;           /*ֵֵλ                           ĬΪ16*/
	unsigned short  wNoiseDeno;         /*ֵλ                             ĬΪ14*/
	unsigned short  wDpchLeftOffset;    /*Χڵ䣬                         ĬΪ592*/
	unsigned short  wDpchRightOffset;   /*Χڵұ䣬                         ĬΪ912*/
	unsigned short  wL1wPsrReserved0[1]; /*  */
	unsigned long   dOverFrameThr;      /*жϿ߽֡磬ֵΪ76800,                   Ĭ76800*/
	unsigned short  wL1wPsrReserved1[14];/*  */
}T_L1wNvPsr;

/********** RTX NV **********/
typedef struct
{
    unsigned short wDchStartCsrCycle;           /* DCHCSϻʱ                       ȱʡֵ15 */
    unsigned short wPichAndBchCheck;            /* PICHBCHͬʱյļǰ             ȱʡֵ3 ֡ */
    unsigned short wReserved[6];
}T_L1wNvRtxProc;

typedef struct
{
    //RAKE
    unsigned short wAccCtrl;                    /* finger1źŽλ        ȱʡֵ5 */
    unsigned short wCpichInterp;                /* CPICHŵƵڲģʽ    ȱʡֵ1  ԣ */
    /*Rake˲*/
    unsigned short wAlphaCtrl;                  /* ˲ѡ                 ȱʡֵ1   ѡalpha˲ */
    unsigned short wAlphaA;                     /* alphaֵ                    ȱʡֵ192 */
    unsigned short wAlphaB;                     /* alphbֵ                    ȱʡֵ23 */
    unsigned short wTpcPlRlProc;                /* TpcPilot RLھϲ    ȱʡֵ82 */

    unsigned short wFingerOffsetThred;          /*                  ȱʡֵ2 samples */
    unsigned short wFingerPowerThred;           /* ѡ                 ȱʡֵ643 8db 8bit㻯 */
    unsigned short wFbiAlphaN;                  /* Fbi alpha              ȱʡֵ7 */
    unsigned short wFbiAlphaD;                  /* Fbi alphaĸ              ȱʡֵ10 */
    unsigned short wAiAlphaN;                   /* Ai alpha               ȱʡֵ3 */
    unsigned short wAiAlphaD;                   /* Ai alphaĸ               ȱʡֵ4 */
    unsigned short wAiPowerThred;               /* Ai                 ȱʡֵ77 0.3 8bit㻯 */
    unsigned short wEAiPowerThred;              /* EAi                ȱʡֵ73 0.285 8bit㻯 */
    unsigned short wRtxPcCrcWindow;             /* PCCRCͳƳ            ȱʡֵ20000 */
    unsigned short wRtxNoiseGapNum;             /* NOISE ˲ʼֵĴ    ȱʡֵ5 */

    signed long dRtxDpchSirThred;                /* DPCH sirɿ         ȱʡֵ-393216 fffa0000-6db 16bit㻯 */
    signed long dRtxFdpchSirThred;               /* FdPCH sirɿ        ȱʡֵ-262144 fffc0000-4db 16bit㻯 */

    unsigned short  wRakeReserved[16];

    //GDTR
    unsigned short wDtrTurboMapNum;             /* turbo     ȱʡֵ16 */
    unsigned short wDtrOverlapSize;             /* turbo     ȱʡֵ32 */
    unsigned short wDtrMaxAlgMode;              /* 㷨ģʽ            ȱʡֵ0 */
    unsigned short wDtrInterMapMode;            /* һν֯ݷתģʽ  ȱʡֵ0 */
    unsigned short wDtrByteOrder;               /* ϱݷתģʽ    ȱʡֵ1 */
    unsigned short wDtrAgcMode;                 /* AGCģʽģʽ         ȱʡֵ0  رգ */

    unsigned short wDtrReserved[4];

    //DS
    unsigned long wDpchInSyncThred;             /* dpch ͬ    ȱʡֵ0x73334 */
    unsigned long wDpchOutSyncThred;            /* dpch ʧ    ȱʡֵ0x11999a */
    unsigned long wFdpchInSyncThred;            /* fdpch ͬ   ȱʡֵ0x73334 */
    unsigned long wFdpchOutSyncThred;           /* fdpch ʧ   ȱʡֵ0x11999a */
    unsigned short wDrxEnable;                 /* Drxʹܱʶ    ȱʡֵ0 */

    unsigned short wDSReserved[7];

}T_L1wNvRtxRx;

typedef struct
{

   //prach
   unsigned short wPreambleStageLen;             /* preamble׶ηͳ         ȱʡֵ64 */
   //dpch
   unsigned short wTxFirTimeOffset;              /* firӳ                  ȱʡֵ28 chips */
   unsigned short wReserved[8];

}T_L1wNvRtxTx;

typedef struct
{
    T_L1wNvRtxProc      tL1wNvRtxProc;       /* ҵ̵NV */
    T_L1wNvRtxRx        tL1wNvRtxRx;         /* RTX豸NV */
    T_L1wNvRtxTx        tL1wNvRtxTx;         /* RTX豸NV */
}T_L1wNvRtx;

/********** PC NV **********/
typedef struct
{
    signed long wFdpchSirTh;             /*Fdpch Sir, Ĭֵ -262144/fffc0000*/
    signed long wDpchSirTh;              /*Dpch Sir, Ĭֵ -393216 /fffa0000*/
    unsigned long wReserved[6];
}T_L1wNvPc;

/********** ENG NV **********/
typedef struct
{
  unsigned short wEngStandardMsg;           /* ׼LOGǷ          (Ĭ:1) */
  unsigned short wEngPrintMsg;              /* ԶӡϢǷ   (Ĭ:1) */
  unsigned short wEngHciMsg;                /* ЭջӿϢǷ (Ĭ:1) */
  unsigned short wEngHookMsg;               /* HOOKϢǷ         (ĬϽֹ:0) */
  unsigned short wEngDataDump;              /* ץȡǷ         (ĬϽֹ:0) */
  unsigned short wEngReserved[11];          /*  */
}T_L1wNvEng;

/********** MEAS NV **********/
typedef struct
{
  signed short   swSidelobeThr;            /* ԰                (Ĭֵ:-3,0xFFFD) */
  unsigned short wSidelobeThrMin;          /* С԰λƫ            (Ĭֵ:5) */
  unsigned short wSidelobeThrMax;          /* ԰λƫ            (Ĭֵ:7) */

  unsigned short wMaxThrMan;               /* ֵβ        (Ĭֵ:1) */
  signed short   swMaxThrExp;              /* ֵָ        (Ĭֵ:-3,0xFFFD) */
  unsigned short wRscpNoiseThrMan;         /* RSCPβ  (Ĭֵ:2150) */
  signed short   swRscpNoiseMaxThrExp;     /* RSCPָ  (Ĭֵ:-10,0xFFF6) */
  unsigned short wPreSyncNoiseThrMan;      /* Ԥͬβ    (Ĭֵ:3) */
  signed short   swPreSyncNoiseThrExp;     /* Ԥָͬ    (Ĭֵ:-1,0xFFFF) */

  unsigned short wSttdOnCoe;               /* STTD ONļ           (Ĭֵ:2) */
  unsigned short wSttdOffCoe;              /* STTD OFFļ          (Ĭֵ:3) */

  unsigned short wHwAgcRevertEn;           /* ӲAGCԭģǷʹ     (Ĭʹ:1Ӳԭ) */
  signed short   swRscpCalcDelta;          /* CPICH RSCPֵ      (Ĭֵ:-17,,0xFFEF) */
  signed short   swRssiCalcDelta;          /* RSSIֵ            (Ĭֵ:0) */

  unsigned short wAdrWindowAlphaMan;       /* ADRӵβ     (Ĭֵ:291) */
  signed short   swAdrWindowAlphaExp;      /* ADRӵָ     (Ĭֵ:-10,0xFFF6) */
  unsigned short wFirstSrongRange;         /* ǿ羶λõĲֵ    (Ĭֵ:8) */

  unsigned short wL1wMeasReserved[15];     /*  */
}T_L1wNvMeas;

/********** DPA NV **********/
typedef struct
{
   unsigned short wNvRxDivMode;         /* 0-߽գ1-˫߽                  Ĭֵ0 */
   unsigned short wNvHsscchInfSelMode;  /* 0-ADRգ1-RAKE                       Ĭֵ0 */
   unsigned short wNvCirFingerSelMode;  /* 0-ѡ1-ѡ                  Ĭֵ1 */
   unsigned short wNvEqNoiseSelMode;    /* 0-ʹϵ1-Ӳ  Ĭֵ0 */
   unsigned short wNvHsdschDemodMode;   /* 0-÷Ⱦֵ 1-ӲȾֵ       Ĭֵ1 */
   unsigned short wNvCqiAdjMode;        /* 0-CQIرգ1-                       Ĭֵ0 */
   unsigned short wNvDataMovMode;       /* 0-رDMAˣ1-                       Ĭֵ1 */
   unsigned short wPadding[121];        /* չADRSCCHDSCH̬òĸı */
}T_L1wNvHsdpa;

/********** UPA NV **********/
typedef struct
{
   unsigned short wNvRgHiAlg;               /* 0-RgHi㷨1-RgHi㷨     Ĭֵ0 */
   unsigned short wNvSchCancelEn;           /* 0-SCHʹܣ1-SCHʹܣ Ĭֵ0 */
   unsigned short wNvUpaDlDelay;            /* 0,1,2,3-RgHiAgӲӳ6,7,8,9ţ  Ĭֵ0 */
   unsigned short wPadding[29];             /* չ  */
}T_L1wNvHsupa;

/********** RFC NV **********/
typedef struct
{
   unsigned long wL1wRfcReserved[20];     /*  */
}T_L1wNvRfc;

/********** NV **********/
typedef struct
{
    unsigned short      wTotalLen;           /* ܳȣλBYTE */
    unsigned short      wPadding;
    T_L1wNvL1sCmn       tL1wNvL1sCmn;
    T_L1wNvCs           tL1wNvCs;
    T_L1wNvBch          tL1wNvBch;
    T_L1wNvPsr          tL1wNvPsr;
    T_L1wNvRtx          tL1wNvRtx;
    T_L1wNvPc           tL1wNvPc;
    T_L1wNvEng          tL1wNvEng;
    T_L1wNvMeas         tL1wNvMeas;
    T_L1wNvHsdpa        tL1wNvHsdpa;
    T_L1wNvHsupa        tL1wNvHsupa;
	T_L1wNvRfc          tL1wNvRfc;
}T_L1wNvBb;

#endif

