/************************************************************
*************************************************************
            MSPƵź¼ӿͷļ
*************************************************************
************************************************************/

#ifndef ZTE_AUDIO_H
#define ZTE_AUDIO_H

#ifndef FOR_2960
#include "mm_error.h"
#endif
#include "msm_type.h"
#include "mm_def.h"
#include "zte_display.h"

typedef VOID (*MSP_NOTIFY_ERROR) (MM_MODULE_ID_E uiModule, DWORD dwParam);
typedef VOID (*MSP_NOTIFY_END) (MM_MODULE_ID_E uiModule);

typedef enum
{
    dd_volume_lev_0,
    dd_volume_lev_1,
    dd_volume_lev_2,
    dd_volume_lev_3,
    dd_volume_lev_4,
    dd_volume_lev_5,        
}VOLUME_DD_level;

typedef enum
{
    DD_RECEIVER = 1,
    DD_SPEAKER,
    DD_HEADPHONE,
    DD_SPEAKER_AND_HEADPHONE,
    DD_BLUETOOTH_PHONE,     
}DD_CODEC_PATHOUT;

SINT32 Msp_SetEndCallback(MSP_NOTIFY_END EndCallbackFunc);
SINT32 Msp_SetErrorCallback(MSP_NOTIFY_ERROR ErrorCallbackFunc);

AUDIO_RESULT_E	Audio_Init(void);

AUDIO_RESULT_E	Audio_Release(void);

FILE_HANDLE		Audio_Open_File(unsigned char *filename);

AUDIO_RESULT_E	Audio_Close(FILE_HANDLE handle);

AUDIO_RESULT_E	PLAYER_AUDIO_StartPlay(FILE_HANDLE handle, unsigned long offset, unsigned short play_times);

AUDIO_RESULT_E	Audio_StopPlay(FILE_HANDLE handle);

AUDIO_RESULT_E	Audio_PausePlay(FILE_HANDLE handle);

AUDIO_RESULT_E	Audio_ResumePlay(FILE_HANDLE handle);


AUDIO_RESULT_E	Audio_GetCurTime(FILE_HANDLE handle, long *curtime);

AUDIO_RESULT_E	Audio_GetTotalTime(FILE_HANDLE handle, unsigned long *totaltime);

AUDIO_RESULT_E	Audio_Seek(FILE_HANDLE handle, unsigned long offset);


AUDIO_RESULT_E	Audio_Mute(FILE_HANDLE handle, BOOL enable_mute);

AUDIO_RESULT_E	Audio_Volume_Get(FILE_HANDLE handle, AUDIO_VOLUME_LEVEL_E *volume_level);

AUDIO_RESULT_E	Audio_Volume_Set(FILE_HANDLE handle, AUDIO_VOLUME_LEVEL_E volume_level);


AUDIO_RESULT_E	Audio_ChannelOut_Set(FILE_HANDLE handle, AUDIO_CHANNEL_OUT_E channel);

/*
AUDIO_RESULT_E Audio_Effect3D_Set(FILE_HANDLE handle,UINT8 *enable);

AUDIO_RESULT_E Audio_EQmode_Set(FILE_HANDLE handle,MM_AUDIO_EQMODE_E audioEqMode);

AUDIO_RESULT_E Audio_GetAuthorInfo(FILE_HANDLE handle, MP3_ID3_INFO_T *info);

AUDIO_RESULT_E Audio_GetFileInfo(FILE_HANDLE handle, T_MM_AUDIO_PLAY_INFO *info);
*/

DRECORDER_RETURN_E REC_Open(BOOL record_in_cc, SINT32 uiVoiceFd);

DRECORDER_RETURN_E REC_Close(void);

RECORD_HANDLE REC_StartRecord(AUDIORECORDER_START_RECORD_T *record_param);

DRECORDER_RETURN_E REC_StopRecord(RECORD_HANDLE handle);

DRECORDER_RETURN_E REC_PauseRecord(RECORD_HANDLE handle);

DRECORDER_RETURN_E REC_ResumeRecord(FILE_HANDLE handle);

DRECORDER_RETURN_E  REC_GetCurTime(UINT32 *cur_time, FILE_HANDLE handle);


/*LFX 20090507 for tone play begin*/
AUDIO_RESULT_E Tone_Play(char toneID, char volume_level, char Priority);

AUDIO_RESULT_E Tone_Stop(char toneID, char stop_type);
/*LFX 20090507 for tone play end*/

/* zhanghaoting add for 2960 tone 2009-08-14 */
#ifdef FOR_2960
extern void Audio_Open_Tone(VOID);

extern void Audio_Play_Tone(T_MM_TONE_PARAM *ptParam);

extern void Audio_Stop_Tone(VOID);

extern void Audio_Close_Tone(VOID);
#endif
/* zhanghaoting add for 2960 tone 2009-08-14 end */

#endif
