/************************************************************************
* Ȩ(C)2007,ͨѶɷ޹˾
* ģ   ƵŲģ
* ļƣzMsp_Com.c
* ļʶ 
* ժҪ 
* 
* ޸      汾     ޸ı       ޸       ޸      
* ----------------------------------------------------------------------
* 2009/3/25    1.0                                              
* 2012/07/18    P98CV3.2.3B01      P98C-CXX-0001           EC:617001630060þ񡢰ƽ쳣 
************************************************************************/
  
/**************************************************************************
 *                        ͷļ                                      *
 **************************************************************************/
#include "zMsp_Com.h"
#include "amr_alg.h"
#include "mp3d_alg.h"
#include "aacd_alg.h"
#include "mp3_enc_alg.h"
#include "drv_api.h"
#include "ZMF_API.h"
#include "zMsp_FileFunc.h"
  
/**************************************************************************
 *                                                                    *
 **************************************************************************/
#define COORDINATE_CALIBRATE   16  /* Ƶʼֵ        */
#define WIDTH_HEIGHT_CALIBRATE 16  /* ƵͼƬֵ        */

UINT32 g_uiScreenWidth     = 240;
UINT32 g_uiScreenHeight    = 320;
UINT32 g_uiDefaultYSize    = 240 * 320;       /* ȫYUV420ʽYС */
UINT32 g_uiDefaultUSize    = 240 * 320 / 4;   /* ȫYUV420ʽUС */
UINT32 g_uiDefaultVSize    = 240 * 320 / 4;   /* ȫYUV420ʽVС */
UINT32 g_uiDefaultARGBSize = 240 * 320 * 4;   /* ȫARGB888С         */

#if 0
/* 롢Ʊ */
static UINT32 g_WidthTable96[]  = {96,  144, 240, 480};
static UINT32 g_WidthTable128[] = {64,  128, 176, 320, 352, 480, 640};
static UINT32 g_WidthTable144[] = {96,  144, 240, 480};
static UINT32 g_WidthTable176[] = {64,  128, 160, 176, 320, 352, 480, 640, 704};
static UINT32 g_WidthTable240[] = {96,  144, 240, 480};
static UINT32 g_WidthTable288[] = {96,  144, 240, 480};
static UINT32 g_WidthTable320[] = {128, 160, 176, 320, 480, 640, 720};
static UINT32 g_WidthTable352[] = {128, 160, 176, 320, 352, 480, 640, 704};
static UINT32 g_WidthTable480[] = {128, 144, 160, 240, 320, 480, 640, 720};
static UINT32 g_WidthTable576[] = {144, 240, 480};
static UINT32 g_WidthTable640[] = {160, 208, 320, 352, 480, 640, 704, 720};
static UINT32 g_WidthTable704[] = {176, 256, 320, 352, 480, 640, 704};
static UINT32 g_WidthTable720[] = {240, 320, 480, 640, 720};

/* 롢߶Ʊ */
static UINT32 g_HeightTable96[]  = {48,  96,  144, 240, 288, 360, 480};
static UINT32 g_HeightTable128[] = {128, 176, 320, 640};
static UINT32 g_HeightTable144[] = {48,  96,  120, 144, 240, 288, 360, 480, 576};
static UINT32 g_HeightTable176[] = {128, 176, 320, 640};
static UINT32 g_HeightTable240[] = {96,  120, 144, 240, 288, 360, 480, 576};
static UINT32 g_HeightTable288[] = {96,  120, 144, 240, 288, 360, 480, 576};
static UINT32 g_HeightTable320[] = {128, 160, 176, 320, 640};
static UINT32 g_HeightTable352[] = {128, 176, 320, 640};
static UINT32 g_HeightTable480[] = {120, 128, 144, 240, 288, 360, 480, 576};
static UINT32 g_HeightTable576[] = {240, 288, 480, 576};
static UINT32 g_HeightTable640[] = {160, 176, 320, 640};
static UINT32 g_HeightTable704[] = {176, 320, 640};
static UINT32 g_HeightTable720[] = {320, 640};
#endif

/**************************************************************************
 *                                                                      *
 **************************************************************************/
#define AAC_DECODE_LEN              4096               /* AAC(˫)һ֡ */
#define AMR_NB_DECODE_LEN           160                /* AMRһ֡       */
#define MAX_AMR_FRAME_LEN           31                 /* һ֡AMR IF1ݵ󳤶 */
#define MP3_DECODE_LEN_WORD         (1152 * 2)         /* MP3(˫)һ֡ */
#define DEFAULT_AUDIO_BUFFER_SIZE   3072               /* ĬϵƵС  */
#define DEFAULT_AUDIO_SAMPLE_RATE   AUDIO_RATE_8_KHZ   /* ĬϵPCM           */

/**************************************************************************
 *                                                                 *
 **************************************************************************/
/* AMRӿ */     
typedef short (*AMR_Decoder_Init_ZTE) (T_AMRDecParam  *pParam);

/**
 * ƣ AMR_Decoder_Proc_ZTE 
 *  һͨݽAMR_NB
 * ˵ (IN)     pucInputPnt ݻ׵ַ
 *            (IN)     wInSize     ݳ
 *            (IN/OUT) pwOutputPnt ݻ׵ַ
 *            (IN/OUT) pwOutSize   ָС(λΪ)
 *                                 ַ, ĿǼǷдԽ
 *            (IN)     pParam      ṹĵַ
 *   ֵ һָʾóɹʧͣĺ:
 *            SUCCESS     0(óɹ), 
 *            FAIL        -1(ʧܣָΪ),
 *            PARAMERROR  -2(ʧܣ)
 * ˵ úʱӦȰڽĴСΪ
 *            *puwOutSizeд룬ԱǷܷдԽ硣
 *            ʵʳȣλΪ֣*puwOutSizeΪ
 *            ҪݷֵжϵǷɹ
 */
typedef short (*AMR_Decoder_Proc_ZTE) (unsigned char  *pucInputPnt, short  wInSize, short  *pwOutputPnt, short  *pwOutSize,  T_AMRDecParam  *pParam);


/* MP3ӿ */
typedef int (*MP3_Decoder_Init_ZTE) (T_MP3DecParam  *pParam, int const wChnSize, int const wParamSize);

/**
 * ƣ MP3_Decoder_Proc_ZTE 
 *  һͨݽMP3
 * ˵ (IN)     pucInputPnt ݻ׵ַ
 *            (IN)     wInSize     ݳ
 *            (IN/OUT) pwOutputPnt ݻ׵ַ
 *            (IN/OUT) pwOutSize   ָС(λΪ)
 *                                 ַ, ĿǼǷдԽ
 *            (OUT)    pwDecLen    ǰ֡֡
 *            (IN)     pParam      ṹĵַ
 *   ֵ һָʾóɹʧͣĺ:
 *            SUCCESS     0(óɹ), 
 *            FAIL        -1(ʧܣָΪ),
 *            PARAMERROR  -2(ʧܣ)
 * ˵ úʱӦȰڽĴСΪ
 *            *puwOutSizeд룬ԱǷܷдԽ硣
 *            ʵʳȣλΪ֣*puwOutSizeΪ
 *            ҪݷֵжϵǷɹ
 */
typedef int (*MP3_Decoder_Proc_ZTE) (unsigned char  *pucInputPnt, unsigned int wInSize, short *pwOutputPnt, unsigned int *pwOutSize,  unsigned int *pwDecLen, T_MP3DecParam *pParam);

/* AACӿ*/
typedef int (*AAC_Decoder_Init_ZTE)(unsigned char  *cfgbuf,
                                    int             CfgLen,
                                    T_AACDecParam  *paacdec_Param);

typedef int  (*AAC_Decoder_Proc_ZTE) (unsigned char   *pucInputPnt, 
                                      short            wInSize,
                                      short           *pwOutputPnt, 
                                      short           *pwOutSize,
                                      T_AACDecParam   *pParam);

typedef short (*AMR_Encoder_Init_ZTE) (T_AMREncParam  *pParam); 

typedef short (*AMR_Encoder_Proc_ZTE) (short         *pwInputPnt, 
                                       short          wInSize, 
                                       unsigned char *pucOutputPnt, 
                                       short         *pwOutSize, 
                                       T_AMREncParam *pParam); 

typedef int (*MP3_Encoder_Init_ZTE)(T_MP3EncParam  *pParam);

typedef int (*MP3_Encoder_Proc_ZTE)(short          *pwInputPntAll,
                                    short           wInSize,
                                    unsigned char  *pucOutputPnt,
                                    short          *pwOutSize,
                                    T_MP3EncParam  *pParam);

/* Ϣ(Ŀǰֻͨ¼,Ժչ)  */
typedef struct
{
    T_MSP_CHANNEL_OUTPUT      tOutputChannel;
    T_MSP_OUTPUT_VOLUME_LEVEL tOutputVol;
    BOOL                      bMute;
    
}T_MSP_PLAYPARAM;

/* 豸 */
typedef struct
{
    UINT32 uiAudioFd;      /* Audio豸  */
    UINT32 uiVideoFd;      /* Video豸  */
    UINT32 uiCamFd;        /* Sensor豸 */
    UINT32 uiMidiFd;       /* Midi豸   */
    UINT32 uiToneFd;       /* Tone豸 */
}T_MSP_DEV_FD;

/* 롢ȡֵӦ */
typedef struct _T_InOutValTable
{
    UINT32    uiInput;     /* (/)ֵ             */
    UINT32   *pOutAarry;   /* Ӧ(/)ȡֵ */
    UINT32    uiAarryLen;  /* 鳤                  */
}T_InOutValTable;

/**************************************************************************
 *                           ֲԭ                                  *
 **************************************************************************/
static VOID *zMsp_Malloc(UInt32 size);

static VOID zMsp_Free(VOID *mem_ptr);

static UINT32 Zte_GetAudioBufSize(EMediaAudioType eMediaAType);

static UINT32 Zte_GetAudioMaxFramePcmLen(EMediaAudioType eMediaAType);

static DecHandle Zte_AMRDecoderOpen(UINT8                  *buffer, 
                                    UINT32                  uiLen, 
                                    T_ZDrvAudio_Channel    *pChannelMode,
                                    T_ZDrvAudio_SampleRate *pSampleRate);

static DecHandle Zte_MP3DecoderOpen(UINT8                  *buffer, 
                                    UINT32                  uiLen, 
                                    T_ZDrvAudio_Channel    *pChannelMode,
                                    T_ZDrvAudio_SampleRate *pSampleRate);

static DecHandle Zte_AACDecoderOpen(UINT8                  *buffer, 
                                    UINT32                  uiLen,
                                    T_Audio_AacParam       *pAacParam,                                 
                                    T_ZDrvAudio_Channel    *pChannelMode,
                                    T_ZDrvAudio_SampleRate *pSampleRate);

static void Zte_GetOutChannelMode(EMediaAudioType eMediaAType, UINT32 iChannelMode, T_ZDrvAudio_Channel *pChannelMode);

static void Zte_GetSampleRate(UINT32 iSampleRate, T_ZDrvAudio_SampleRate *pSampleRate);

static UINT32 Zte_AMRDecodeAudio(DecHandle  pHandle,  T_ZMFOutPutUnit *pOutUnit, 
                                 VOID      *pPhyBuf,  UINT32           uiBufLen);

static UINT32 Zte_MP3DecodeAudio(DecHandle  pHandle,  T_ZMFOutPutUnit *pOutUnit, 
                                 VOID      *pPhyBuf,  UINT32           uiBufLen);

static UINT32 Zte_AACDecodeAudio(DecHandle  pHandle,  T_ZMFOutPutUnit *pOutUnit, 
                                 VOID      *pPhyBuf,  UINT32           uiBufLen);

static VOID Zte_AMRDecoderClose(DecHandle pHandle);

static VOID Zte_MP3DecoderClose(DecHandle pHandle);

static VOID Zte_AACDecoderClose(DecHandle pHandle);

static EncHandle Zte_AMREncoderOpen(UINT32 *pFrameLen);
									
static EncHandle Zte_MP3EncoderOpen(T_MP3AddEnCoderData *pAddData, UINT32  *pFrameLen);
                                    
static UINT8 *Zte_AMRAudioEncode(EncHandle  pHandle,   VOID   *pRawData, 
                                 UINT32     uiDataLen, UINT32 *pOutDataLen);

static UINT8 *Zte_MP3AudioEncode(EncHandle  pHandle,   VOID   *pRawData, 
                                 UINT32     uiDataLen, UINT32 *pOutDataLen);
								 
static VOID Zte_AMREncoderClose(EncHandle pHandle);

static VOID Zte_MP3EncoderClose(EncHandle pHandle);

static void zMsp_LogFunc(const char *sLoggerName, int nDebugLevel, 
                         const char* sFile,       int nLine, 
                         const char *sFormat,     va_list vaList);

static SINT32 zMspCom_PpuFindBestValue(T_InOutValTable *pValTable, UINT32   uiTableLen,
                                       UINT32           uiSrcVal,  UINT32   uiExpVal,
                                       UINT32          *pDestVal);

SINT32 zMspCom_OpenH263Encoder(T_VideoEncInitParam *pInitParam, 
                                       T_ZDrvVideo_EncCfg *pEncCfg);
SINT32 zMspCom_OpenAVCEncoder(T_VideoEncInitParam *pInitParam, 
                                       T_ZDrvVideo_EncCfg *pEncCfg);
SINT32 zMspCom_OpenMPEG4Encoder(T_VideoEncInitParam *pInitParam, 
                                       T_ZDrvVideo_EncCfg *pEncCfg);
SINT32 zMspCom_OpenMJPEGEncoder(T_VideoEncInitParam *pInitParam, 
                                       T_ZDrvVideo_EncCfg *pEncCfg);     
                                       
/**************************************************************************
 *                           ȫֱ                                      *
 **************************************************************************/
static T_ZMF_Callbacks  g_CallBack;

AMR_Decoder_Init_ZTE  Zte_AMR_Decoder_Init;
AMR_Decoder_Proc_ZTE  Zte_AMR_Decoder_Proc;
static UINT32   uiAMRDecByteSize = AMR_NB_DECODE_LEN * 2;  /* һ֡AMRʽֽ() */

MP3_Decoder_Init_ZTE  Zte_MP3_Decoder_Init;
MP3_Decoder_Proc_ZTE  Zte_MP3_Decoder_Proc;
static UINT32   uiMP3DecByteSize = MP3_DECODE_LEN_WORD * 2; /* һ֡MP3ʽֽ(˫) */

AAC_Decoder_Init_ZTE  Zte_AAC_Decoder_Init;
AAC_Decoder_Proc_ZTE  Zte_AAC_Decoder_Proc;
static UINT32   uiAACDecByteSize = AAC_DECODE_LEN * 2; /* һ֡AACʽֽ(˫) */

static UINT32   uiPCMDecByteSize = DEFAULT_AUDIO_BUFFER_SIZE * 2; /* wavļPCMֽ */

AMR_Encoder_Init_ZTE Zte_AMR_Encoder_Init;
AMR_Encoder_Proc_ZTE Zte_AMR_Encoder_Proc;

MP3_Encoder_Init_ZTE Zte_MP3_Encoder_Init;
MP3_Encoder_Proc_ZTE Zte_MP3_Encoder_Proc;

MSP_NOTIFY_ERROR     zMsp_Notify_Error = NULL;
MSP_NOTIFY_END       zMsp_Notify_End   = NULL;

static T_MSP_DEV_FD    g_tMspDevFd       = {0};
static T_MSP_PLAYPARAM g_tAudioPlayParam = {MSP_CHANNEL_OUTPUT_SPEAKER, MSP_OUTPUT_VOLUME_LEVEL_3};

#if 0
static T_InOutValTable g_tWidthTable[] = {
                                           {96,  g_WidthTable96,  sizeof(g_WidthTable96)/sizeof(UINT32)},
                                           {128, g_WidthTable128, sizeof(g_WidthTable128)/sizeof(UINT32)},
                                           {144, g_WidthTable144, sizeof(g_WidthTable144)/sizeof(UINT32)},
                                           {176, g_WidthTable176, sizeof(g_WidthTable176)/sizeof(UINT32)},
                                           {240, g_WidthTable240, sizeof(g_WidthTable240)/sizeof(UINT32)},
                                           {288, g_WidthTable288, sizeof(g_WidthTable288)/sizeof(UINT32)},
                                           {320, g_WidthTable320, sizeof(g_WidthTable320)/sizeof(UINT32)},
                                           {352, g_WidthTable352, sizeof(g_WidthTable352)/sizeof(UINT32)},
                                           {480, g_WidthTable480, sizeof(g_WidthTable480)/sizeof(UINT32)},
                                           {576, g_WidthTable576, sizeof(g_WidthTable576)/sizeof(UINT32)},
                                           {640, g_WidthTable640, sizeof(g_WidthTable640)/sizeof(UINT32)},
                                           {704, g_WidthTable704, sizeof(g_WidthTable704)/sizeof(UINT32)},
                                           {720, g_WidthTable720, sizeof(g_WidthTable720)/sizeof(UINT32)}
                                         };

static T_InOutValTable g_tHeightTable[] = {
                                            {96,   g_HeightTable96,   sizeof(g_HeightTable96)/sizeof(UINT32)},
                                            {128,  g_HeightTable128,  sizeof(g_HeightTable128)/sizeof(UINT32)},
                                            {144,  g_HeightTable144,  sizeof(g_HeightTable144)/sizeof(UINT32)},
                                            {176,  g_HeightTable176,  sizeof(g_HeightTable176)/sizeof(UINT32)},
                                            {240,  g_HeightTable240,  sizeof(g_HeightTable240)/sizeof(UINT32)},
                                            {288,  g_HeightTable288,  sizeof(g_HeightTable288)/sizeof(UINT32)},
                                            {320,  g_HeightTable320,  sizeof(g_HeightTable320)/sizeof(UINT32)},
                                            {352,  g_HeightTable352,  sizeof(g_HeightTable352)/sizeof(UINT32)},
                                            {480,  g_HeightTable480,  sizeof(g_HeightTable480)/sizeof(UINT32)},
                                            {576,  g_HeightTable576,  sizeof(g_HeightTable576)/sizeof(UINT32)},
                                            {640,  g_HeightTable640,  sizeof(g_HeightTable640)/sizeof(UINT32)},
                                            {704,  g_HeightTable704,  sizeof(g_HeightTable704)/sizeof(UINT32)},
                                            {720,  g_HeightTable720,  sizeof(g_HeightTable720)/sizeof(UINT32)},
                                          };
#endif

static  BOOL  s_bMp3DecoderInit = FALSE;
static  VOID *s_pAudioDecHandle = NULL;
/**************************************************************************
 *                ʵ--в֣CԵͷļɲü           *
 **************************************************************************/

/**************************************************************************
 *                ʵ--֣CԵͷļɲü           *
 **************************************************************************/

/**************************************************************************
 *                ʵ--˽в֣CԵͷļɲü           *
 **************************************************************************/

/**************************************************************************
 *                     ȫֺʵ                                      *
 **************************************************************************/
/**
 * ƣ zMspCom_InitFileParseModule 
 *  ʼļģ
 * ˵ (IN) 
 *   ֵ ɹMSP_COM_OP_SUCCESS
 * ˵ 
 */
SINT32 zMspCom_InitFileParseModule(VOID)
{
    static BOOL    init   = FALSE;
    EZMFResultCode rtCode = ZMF_RS_ERROR;
    UINT32         uiFileBlockSize = 8;
    
    if(!init)
    {
        g_CallBack.pMalloc      = (ZMF_Callback_Malloc)zMsp_Malloc;
        g_CallBack.pFree        = (ZMF_Callback_Free)zMsp_Free;
        g_CallBack.pMemcpy      = (ZMF_Callback_Memcpy)mem_memcpy;
        g_CallBack.pMemset      = (ZMF_Callback_Memset)mem_memset;

        g_CallBack.pGetUB       = (ZMF_Callback_GetUB)NULL;
        g_CallBack.pRetUB       = (ZMF_Callback_RetUB)NULL;
        
        g_CallBack.pFCreate     = (ZMF_Callback_FCreate)zMsp_FCreate;
        g_CallBack.pFOpen       = (ZMF_Callback_FOpen)zMsp_FOpen;
        g_CallBack.pFSeek       = (ZMF_Callback_FSeek)zMsp_FSeek;
        g_CallBack.pFRead       = (ZMF_Callback_FRead)zMsp_FRead;
        g_CallBack.pFWrite      = (ZMF_Callback_FWrite)zMsp_FWrite;
        g_CallBack.pFEof        = (ZMF_Callback_FEof)zMsp_FEof;
        g_CallBack.pFTell       = (ZMF_Callback_FTell)zMsp_FTell;
        g_CallBack.pFClose      = (ZMF_Callback_FClose)zMsp_FClose;
        g_CallBack.pFRename     = (ZMF_Callback_FRename)zMsp_FRename;
        g_CallBack.pFDelete     = (ZMF_Callback_FDelete)zMsp_FDelete;
        g_CallBack.pFLength     = (ZMF_Callback_FLength)zMsp_FLength;
        g_CallBack.pFExist      = (ZMF_Callback_FExist)zMsp_FExist;
        g_CallBack.pFModTime    = (ZMF_Callback_FModTime)zMsp_FModTime;
        g_CallBack.pFMod        = (ZMF_Callback_FMod)zMsp_FMod;
        
        g_CallBack.pCreateMutex = (ZMF_Callback_CreateMutex)zOss_CreateMutex;
        g_CallBack.pGetMutex    = (ZMF_Callback_GetMutex)zOss_GetMutex;
        g_CallBack.pPutMutex    = (ZMF_Callback_PutMutex)zOss_PutMutex;
        g_CallBack.pDeleteMutex = (ZMF_Callback_DeleteMutex)zOss_DeleteMutex;

        g_CallBack.pLogOut      = (LogOutCallBackFunc)zMsp_LogFunc;        

        rtCode = InitModule(TRUE, &g_CallBack);
        if(rtCode != ZMF_RS_OK)
        {
            return MSP_COM_OP_ERROR;
        }

        rtCode = SetFileBlockSize(uiFileBlockSize);
        if(rtCode != ZMF_RS_OK)
        {
            return MSP_COM_OP_ERROR;
        }
        
        init = TRUE;
        return MSP_COM_OP_SUCCESS;
    }
    else
    {
        return MSP_COM_OP_SUCCESS;
    }
}

/**
 * ƣ zMspCom_DecPreProcess 
 *  ýļǰĳʼļ֧ʶ
 * ˵ (IN)  eMoudleID       ģID
 *            (IN)  pFilePath       ýļ·
 *            (OUT) pFileInfoParam  ļýϢ
 *   ֵ ɹMSP_COM_OP_SUCCESS
 * ˵ ļʼýļļʽԼý
 *            ļϢȡز(˴ƵBufferĴС
 *            Ϣ)
 */
SINT32 zMspCom_DecPreProcess(MSP_MODULE_ID eMoudleID, const char *pFilePath, T_FileInfoParam *pFileInfoParam)
{
    SINT32                iRet        = MSP_COM_OP_ERROR;        
    UInt32                j           = 0;
    UInt32                u32FileID   = 0;
    UINT32                uiVideoTime = 0;       /* Ƶʱ */
    UINT32                uiAudioTime = 0;       /* Ƶʱ */
    T_ZMFFileInfo        *pFileInfo   = NULL;
    EZMFResultCode        rtCode      = ZMF_RS_ERROR;
    Bool16                b16_IsCreateIndex = TRUE;
    EMediaAudioType       eAudioType  = 0;

    if(NULL == pFilePath || NULL == pFileInfoParam)
    {
        return MSP_COM_OP_ERROR;
    }
    
    /* ʼļģ */
    iRet = zMspCom_InitFileParseModule();
    if(iRet != MSP_COM_OP_SUCCESS)
    {
        return iRet;
    }

    /* ýļȡļIDʶ */
    rtCode = OpenMediaFileHandler(pFilePath, ZMF_FILE_READ, &u32FileID);
    if (rtCode != ZMF_RS_OK)
    {
        return MSP_COM_OP_ERROR;
    }

    /* ļͣȡļϢ */
    rtCode = ParseFileType(u32FileID, &pFileInfo);
    if (rtCode != ZMF_RS_OK)
    {
        CloseMediaFileHandler(u32FileID);

        return MSP_COM_OP_ERROR;
    }

    /* Ƶģֵ֧ļͼ(ԺԴֵ֧) */
    if(MSP_MODULE_AUDIO == eMoudleID)
    {
        /* Ƶ֧AMR_NBAACMP3MIDI */
        if(pFileInfo->eFileType    != ZM_FileID_AMR
           && pFileInfo->eFileType != ZM_FileID_AAC
           && pFileInfo->eFileType != ZM_FileID_MP3
           && pFileInfo->eFileType != ZM_FileID_WAV
           && pFileInfo->eFileType != ZM_FileID_IMY
           && pFileInfo->eFileType != ZM_FileID_MIDI_10)
        {
            CloseMediaFileHandler(u32FileID);
            
            return MSP_COM_OP_ERROR;        
        }        
    }
    else if(MSP_MODULE_VIDEO == eMoudleID)
    {
        /* Ƶ֧MP43GP */
        if(pFileInfo->eFileType    != ZM_FileID_MP4
           && pFileInfo->eFileType != ZM_FileID_3GP
           && pFileInfo->eFileType != ZM_FileID_AVI)
        {
            CloseMediaFileHandler(u32FileID);
            
            return MSP_COM_OP_ERROR;        
        }        
    }

    if (pFileInfo->eFileType == ZM_FileID_MIDI_10
        || pFileInfo->eFileType == ZM_FileID_IMY)
    {
        pFileInfoParam->pFileInfo = pFileInfo;
        pFileInfoParam->u32FileID = u32FileID;
        
        return MSP_COM_OP_SUCCESS;
    }

#ifdef TEST_CREATE_INDEX
    /* MP3,AACʽȡ̨ */
    if (/*pFileInfo->eFileType == ZM_FileID_MP3
        || */pFileInfo->eFileType == ZM_FileID_AAC)
    {
        b16_IsCreateIndex = FALSE;
    }
    /* ʼļļϢ */
    rtCode = Initialize(u32FileID,b16_IsCreateIndex);
#else
    /* ʼļļϢ */
    rtCode = Initialize(u32FileID,b16_IsCreateIndex);
#endif

    if (rtCode != ZMF_RS_OK)
    {
        CloseMediaFileHandler(u32FileID);   

        return MSP_COM_OP_ERROR;
    }
    
    /* ýļϢ */
    pFileInfoParam->u32FileID     = u32FileID;
    pFileInfoParam->pFileInfo     = pFileInfo;
    pFileInfoParam->eFileDataInfo = FILE_DATA_NONE;  /* Ԥ */

    /* ƵļͶӦýļϢ */
    if(MSP_MODULE_AUDIO == eMoudleID)
    {
        if (ZM_FileID_AMR == pFileInfo->eFileType)
        {
            pFileInfoParam->eMediaAType = ZM_CODEC_ID_AMR_NB; 
            uiAudioTime = pFileInfo->u32Duration;
        }
        else if (ZM_FileID_MP3 == pFileInfo->eFileType)
        {
            pFileInfoParam->eMediaAType = ZM_CODEC_ID_MP3;
            uiAudioTime = pFileInfo->u32Duration;
        }
        else if (ZM_FileID_AAC == pFileInfo->eFileType)
        {
            pFileInfoParam->eMediaAType = ZM_CODEC_ID_AAC;
            uiAudioTime = pFileInfo->u32Duration;
        }
        else if (ZM_FileID_WAV == pFileInfo->eFileType)
        {
            eAudioType  = pFileInfo->tFileInfo.t_wavInfo.tWaveInfo.eAudioType;
            if(eAudioType >= ZM_CODEC_ID_PCM_S16LE && eAudioType <= ZM_CODEC_ID_ADPCM_SBPRO_2)
            {
                pFileInfoParam->eMediaAType = ZM_CODEC_ID_PCM_S16LE;
            }
            else if(ZM_CODEC_ID_MP3 == eAudioType)
            {
                pFileInfoParam->eMediaAType = ZM_CODEC_ID_MP3;
            }
            else if(ZM_CODEC_ID_AAC == eAudioType || ZM_CODEC_ID_AAC_PLUS == eAudioType)
            {
                pFileInfoParam->eMediaAType = ZM_CODEC_ID_AAC;
            }
            uiAudioTime = pFileInfo->u32Duration;
        }
        
        /* ƵʽȡƵ */
        pFileInfoParam->uiAudioBufsize    = Zte_GetAudioBufSize(pFileInfoParam->eMediaAType);
        pFileInfoParam->uiMaxFramePcmLen  = Zte_GetAudioMaxFramePcmLen(pFileInfoParam->eMediaAType);
    }
    
    /* ƵļͶӦýļϢ䣬½3GPMP4ļ
     * Ч
     */
    else if(MSP_MODULE_VIDEO == eMoudleID && 
        (pFileInfo->eFileType == ZM_FileID_3GP || pFileInfo->eFileType == ZM_FileID_MP4))
    {
        if (NULL == pFileInfo->tFileInfo.t_isoInfo.pTrackArray)
        {
            CloseMediaFileHandler(u32FileID);

            return MSP_COM_OP_ERROR;
        }
        
        pFileInfoParam->u32TrackNum = pFileInfo->tFileInfo.t_isoInfo.u32TrackNum;

        for (j = 0; j < pFileInfoParam->u32TrackNum; j++) 
        {
            if(ZM_CODEC_TYPE_AUDIO == pFileInfo->tFileInfo.t_isoInfo.pTrackArray[j].eMediaType)
            {
                /* ¼Ƶ±ꡢƵšʱʡƵݸʽ */
                pFileInfoParam->uiAudioIndex      = j;
                pFileInfoParam->u32AudioTrack     = pFileInfo->tFileInfo.t_isoInfo.pTrackArray[j].u32TrackID;
                pFileInfoParam->f64AudioTimeScale = pFileInfo->tFileInfo.t_isoInfo.pTrackArray[j].f64TimeScale;
                pFileInfoParam->eMediaAType       = pFileInfo->tFileInfo.t_isoInfo.pTrackArray[j].tTrackInfo.tAudioParam.eAudioType;
                pFileInfoParam->eFileDataInfo    |= FILE_DATA_ONLY_AUDIO;

                /* ƵʽȡƵ */
                pFileInfoParam->uiAudioBufsize    = Zte_GetAudioBufSize(pFileInfoParam->eMediaAType);
                pFileInfoParam->uiMaxFramePcmLen  = Zte_GetAudioMaxFramePcmLen(pFileInfoParam->eMediaAType);
                    
                /* ¼Ƶܲʱ */
                uiAudioTime = pFileInfo->tFileInfo.t_isoInfo.pTrackArray[j].u32Duration;

                /* MP43GPʽ򼤻ӦƵ */
                if (pFileInfo->eFileType == ZM_FileID_MP4 || pFileInfo->eFileType == ZM_FileID_3GP)
                {
                    rtCode = SetTrackActive(u32FileID, pFileInfo->tFileInfo.t_isoInfo.pTrackArray[j].u32TrackID, TRUE);
                }
            }
            else if(ZM_CODEC_TYPE_VIDEO == pFileInfo->tFileInfo.t_isoInfo.pTrackArray[j].eMediaType)
            {
                /* ¼Ƶ±ꡢƵšʱʡƵݸʽ */
                pFileInfoParam->uiVideoIndex      = j;
                pFileInfoParam->u32VideoTrack     = pFileInfo->tFileInfo.t_isoInfo.pTrackArray[j].u32TrackID;;
                pFileInfoParam->f64VideoTimeScale = pFileInfo->tFileInfo.t_isoInfo.pTrackArray[j].f64TimeScale;
                pFileInfoParam->eMediaVType       = pFileInfo->tFileInfo.t_isoInfo.pTrackArray[j].tTrackInfo.tVideoParam.eVideoType;
                pFileInfoParam->eFileDataInfo    |= FILE_DATA_ONLY_VIDEO;

                /* ¼Ƶܲʱ */
                uiVideoTime = pFileInfo->tFileInfo.t_isoInfo.pTrackArray[j].u32Duration;

                /* MP43GPʽ򼤻ӦƵ */
                if (pFileInfo->eFileType == ZM_FileID_MP4 || pFileInfo->eFileType == ZM_FileID_3GP)
                {
                    rtCode = SetTrackActive(u32FileID, pFileInfo->tFileInfo.t_isoInfo.pTrackArray[j].u32TrackID, TRUE);
                }
            }
        }
    }

    else if(MSP_MODULE_VIDEO == eMoudleID && pFileInfo->eFileType == ZM_FileID_AVI)
    {
        if(0 == pFileInfo->tFileInfo.t_aviInfo.u32StreamNum
            || NULL == pFileInfo->tFileInfo.t_aviInfo.pStreamInfo)
        {
            CloseMediaFileHandler(u32FileID);
            return MSP_COM_OP_ERROR;
        }

        for (j = 0; j < pFileInfo->tFileInfo.t_aviInfo.u32StreamNum; j++)
        {
            /* ¼Ƶ±ꡢƵšʱʡƵݸʽ */
            if (ZM_CODEC_TYPE_VIDEO == pFileInfo->tFileInfo.t_aviInfo.pStreamInfo[j].eMediaType)
            {
                pFileInfoParam->uiVideoIndex      = j;
                pFileInfoParam->u32VideoTrack     = pFileInfo->tFileInfo.t_aviInfo.pStreamInfo[j].u32StreamID;
                pFileInfoParam->f64VideoTimeScale = 1000;//aviĬʱ䵥λΪ
                pFileInfoParam->eMediaVType       = pFileInfo->tFileInfo.t_aviInfo.pStreamInfo[j].tStreamInfo.tBitMapInfo.eVideoType;
                pFileInfoParam->eFileDataInfo    |= FILE_DATA_ONLY_VIDEO;

                /* ¼Ƶܲʱ */
                uiVideoTime = (UINT32)pFileInfo->u32Duration;

                rtCode = SetTrackActive(u32FileID, pFileInfo->tFileInfo.t_aviInfo.pStreamInfo[j].u32StreamID,TRUE);
            }
            else if(ZM_CODEC_TYPE_AUDIO == pFileInfo->tFileInfo.t_aviInfo.pStreamInfo[j].eMediaType)
            {
                /* ¼Ƶ±ꡢƵšʱʡƵݸʽ */
                pFileInfoParam->uiAudioIndex      = j;
                pFileInfoParam->u32AudioTrack     = pFileInfo->tFileInfo.t_aviInfo.pStreamInfo[j].u32StreamID;
                pFileInfoParam->f64AudioTimeScale = 1000;//aviĬʱ䵥λΪ
                pFileInfoParam->eMediaAType       = pFileInfo->tFileInfo.t_aviInfo.pStreamInfo[j].tStreamInfo.tWaveFmtInfo.eAudioType;
                pFileInfoParam->eFileDataInfo    |= FILE_DATA_ONLY_AUDIO;

                /* ƵʽȡƵ */
                pFileInfoParam->uiAudioBufsize    = Zte_GetAudioBufSize(pFileInfoParam->eMediaAType);
                pFileInfoParam->uiMaxFramePcmLen  = Zte_GetAudioMaxFramePcmLen(pFileInfoParam->eMediaAType);
                    
                /* ¼Ƶܲʱ */
                uiAudioTime = (UINT32)pFileInfo->u32Duration;

                rtCode = SetTrackActive(u32FileID, pFileInfo->tFileInfo.t_aviInfo.pStreamInfo[j].u32StreamID,TRUE);
            }
        }
    }
        
    /* λŵ */
    rtCode = Seek(u32FileID, 0);
    if (rtCode != ZMF_RS_OK)
    {
        CloseMediaFileHandler(u32FileID);

        return MSP_COM_OP_ERROR;
    }

    /* ýļܲʱϢ */
    pFileInfoParam->uiFileTotalTime = (uiVideoTime > uiAudioTime) ? uiVideoTime : uiAudioTime;
    
    return MSP_COM_OP_SUCCESS;
}

/**
 * ƣ zMsp_AudioOpen 
 *  Ƶ豸
 * ˵ (IN)
 *            (OUT)
 *   ֵ ɹ豸þֵ0
 * ˵ 
 */
SINT32 zMspCom_AudioOpen(VOID)
{ 
    SINT32 iAudioFd = -1;
    SINT32 iToneFd  = -1;
    SINT32 iMidiFd  = -1;

    iToneFd = g_tMspDevFd.uiToneFd;
    if(iToneFd > 0)
    {
        zDrv_Ioctl(iToneFd, IOCTL_TONE_STOP, NULL);

        iToneFd = g_tMspDevFd.uiToneFd;
        if(iToneFd > 0)
    {
            zDrv_Close(iToneFd);
        }
        
        g_tMspDevFd.uiToneFd = 0;
        g_tAudioPlayParam.tOutputVol     = MSP_OUTPUT_VOLUME_LEVEL_3;
        g_tAudioPlayParam.tOutputChannel = MSP_CHANNEL_OUTPUT_SPEAKER;
        g_tAudioPlayParam.bMute          = FALSE;
    }

    iMidiFd = g_tMspDevFd.uiMidiFd;
    if(iMidiFd > 0)
    {
        zDrv_Ioctl(iMidiFd, IOCTL_MIDI_PLAY_STOP, NULL);

        iMidiFd = g_tMspDevFd.uiMidiFd;
        if(iMidiFd > 0)
    {
            zDrv_Close(iMidiFd);
        }
        g_tMspDevFd.uiMidiFd = 0;
        g_tAudioPlayParam.tOutputVol     = MSP_OUTPUT_VOLUME_LEVEL_3;
        g_tAudioPlayParam.tOutputChannel = MSP_CHANNEL_OUTPUT_SPEAKER;
        g_tAudioPlayParam.bMute          = FALSE;
    }

    if (g_tMspDevFd.uiAudioFd > 0)
    {
        return MSP_DEV_OPEN_TIMES;
    }

    iAudioFd = zDrv_Open(ZDRV_DEV_AUDIO, 0);
    if (iAudioFd <= 0)
    {
        return MSP_OPEN_DEV_FAILED;
    }
    
    g_tMspDevFd.uiAudioFd = (UINT32)iAudioFd;
    
    return g_tMspDevFd.uiAudioFd;
}

/**
 * ƣ zMspCom_AudioClose 
 *  رƵ豸
 * ˵ (IN)
 *            (OUT)
 *   ֵ 
 * ˵ 
 */
VOID zMspCom_AudioClose(VOID)
{
    if (0 == g_tMspDevFd.uiAudioFd)
    {
        return;
    }

    zDrv_Close(g_tMspDevFd.uiAudioFd);
    g_tMspDevFd.uiAudioFd = 0;
    g_tAudioPlayParam.tOutputVol     = MSP_OUTPUT_VOLUME_LEVEL_3;
    g_tAudioPlayParam.tOutputChannel = MSP_CHANNEL_OUTPUT_SPEAKER; 
    g_tAudioPlayParam.bMute          = FALSE;

    return;
}

/**
 * ƣ zMspCom_MidiOpen 
 *  Midi豸
 * ˵ (IN)
 *            (OUT)
 *   ֵ ɹ豸þֵ0
 * ˵ 
 */
 SINT32 zMspCom_MidiOpen(VOID)
{ 
    SINT32 iMidiFd = -1;

    if(g_tMspDevFd.uiAudioFd > 0)
    {
        return MSP_OPEN_DEV_FAILED;
    }

    if(g_tMspDevFd.uiMidiFd > 0)
    {
        zDrv_Ioctl(g_tMspDevFd.uiMidiFd, IOCTL_MIDI_PLAY_STOP, NULL);

        if (g_tMspDevFd.uiMidiFd > 0)
        {
        zDrv_Close(g_tMspDevFd.uiMidiFd);
        }
        
        g_tMspDevFd.uiMidiFd = 0;
        g_tAudioPlayParam.tOutputVol     = MSP_OUTPUT_VOLUME_LEVEL_3;
        g_tAudioPlayParam.tOutputChannel = MSP_CHANNEL_OUTPUT_SPEAKER;
    }

    iMidiFd = zDrv_Open(ZDRV_DEV_MIDI, 0);
    if (iMidiFd <= 0)
    {
        return MSP_OPEN_DEV_FAILED;
    }
    
    g_tMspDevFd.uiMidiFd = (UINT32)iMidiFd;
    
    return g_tMspDevFd.uiMidiFd;
}

/**
 * ƣ zMspCom_MidiClose 
 *  رMidi豸
 * ˵ (IN)
 *            (OUT)
 *   ֵ 
 * ˵ 
 */
VOID zMspCom_MidiClose(VOID)
{
    if (0 == g_tMspDevFd.uiMidiFd)
    {
        return;
    }

    zDrv_Close(g_tMspDevFd.uiMidiFd);
    g_tMspDevFd.uiMidiFd = 0;
    g_tAudioPlayParam.tOutputVol     = MSP_OUTPUT_VOLUME_LEVEL_3;
    g_tAudioPlayParam.tOutputChannel = MSP_CHANNEL_OUTPUT_SPEAKER;

    return;
}

/**
 * ƣ zMspCom_ToneOpen 
 *  Tone豸
 * ˵ (IN)
 *            (OUT)
 *   ֵ ɹ豸þֵ0
 * ˵ 
 */
 SINT32 zMspCom_ToneOpen(VOID)
{  
    SINT32 iToneFd = -1;

    if (g_tMspDevFd.uiToneFd > 0)
    {
        return MSP_DEV_OPEN_TIMES;
    }

    iToneFd = zDrv_Open(ZDRV_DEV_TONE, 0);
    if (iToneFd <= 0)
    {
        return MSP_OPEN_DEV_FAILED;
    }
    
    g_tMspDevFd.uiToneFd = (UINT32)iToneFd;
    
    return g_tMspDevFd.uiToneFd;
}

/**
 * ƣ zMspCom_ToneClose 
 *  رTone豸
 * ˵ (IN)
 *            (OUT)
 *   ֵ 
 * ˵ 
 */
VOID zMspCom_ToneClose(VOID)
{
    SINT32 iToneFd = -1;
    
    iToneFd = g_tMspDevFd.uiToneFd;
    if (0 == iToneFd)
    {
        return;
    }

    zDrv_Close(iToneFd);
    g_tMspDevFd.uiToneFd = 0;
    g_tAudioPlayParam.tOutputVol     = MSP_OUTPUT_VOLUME_LEVEL_3;
    g_tAudioPlayParam.tOutputChannel = MSP_CHANNEL_OUTPUT_SPEAKER;

    return;
}


/**
 * ƣ zMsp_VideoOpen 
 *  Ƶ豸
 * ˵ (IN)
 *            (OUT)
 *   ֵ ɹ:豸þֵ0
 * ˵ 
 */
SINT32 zMspCom_VideoOpen(VOID)
{
    SINT32 iVideoFd = -1;

    if (g_tMspDevFd.uiVideoFd > 0)
    {
        return MSP_DEV_OPEN_TIMES;
    }

    iVideoFd = zDrv_Open(ZDRV_DEV_VIDEO, 0);
    if (iVideoFd <= 0)
    {
        return MSP_OPEN_DEV_FAILED;
    }

    g_tMspDevFd.uiVideoFd = (UINT32)iVideoFd;

    return g_tMspDevFd.uiVideoFd;
}

/**
 * ƣ zMspCom_VideoClose 
 *  رƵ豸
 * ˵ (IN)
 *            (OUT)
 *   ֵ 
 * ˵ 
 */
VOID zMspCom_VideoClose(VOID)
{
    if (0 == g_tMspDevFd.uiVideoFd)
    {
        return;
    }

    zDrv_Close(g_tMspDevFd.uiVideoFd);

    g_tMspDevFd.uiVideoFd = 0;

    return;    
}

/**
 * ƣ zMsp_CamOpen 
 *  Cam豸
 * ˵ (IN)tSensor:ͷID
 *            (OUT)
 *   ֵ ɹ:豸
 * ˵ 
 */
SINT32 zMspCom_CamOpen(T_MSP_CAM_SENSOR tSensor)
{
    SINT32          iRet      = -1;
    SINT32          iCamFd    = -1;
    T_ZDrv_SensorId tSensorId = (T_ZDrv_SensorId)tSensor;
    T_ZDrv_MirrorType  t_MirrorType      = MIR_H;
    
    if (g_tMspDevFd.uiCamFd > 0)
    {
        return MSP_DEV_OPEN_TIMES;
    }

    iCamFd = zDrv_Open(ZDRV_DEV_CAM, 0);

    if (iCamFd <= 0)
    {
        return MSP_OPEN_DEV_FAILED;
    }

    /* ѡͷ */
    iRet = zDrv_Ioctl((UINT32)iCamFd, IOCTL_CAM_SELECT_SENSOR, &tSensorId);
    if (iRet != DRV_SUCCESS)
    {
        zDrv_Close((UINT32)iCamFd);
       
        return MSP_OPEN_DEV_FAILED;
    }
    
    if(SENSOR_SUB == tSensorId)
    {
        iRet = zDrv_Ioctl((UINT32)iCamFd, IOCTL_CAM_SET_MIRROR, &t_MirrorType);
        if(0 != DRV_SUCCESS)
        {
            zDrv_Close((UINT32)iCamFd);

            return MSP_OPEN_DEV_FAILED;
        }   
    }

    
    g_tMspDevFd.uiCamFd = (UINT32)iCamFd;

    return g_tMspDevFd.uiCamFd;   
}

/**
 * ƣ zMspCom_CamSelect 
 *  ͷѡ
 * ˵ (IN)tSensor:ͷID
 *            (OUT)
 *   ֵ ɹ:MSP_COM_OP_SUCCESS
 * ˵ 
 */
SINT32 zMspCom_CamSelect(T_MSP_CAM_SENSOR tSensor)
{
    SINT32          iRet      = -1;
    T_ZDrv_SensorId tSensorId = (T_ZDrv_SensorId)tSensor;
    
    if (0 == g_tMspDevFd.uiCamFd)
    {
        return MSP_DEV_UNOPENED;
    }
    
    /* ѡͷ */
    iRet = zDrv_Ioctl(g_tMspDevFd.uiCamFd, IOCTL_CAM_SELECT_SENSOR, &tSensorId);
    if (iRet != DRV_SUCCESS)
    {      
        return MSP_OPEN_DEV_FAILED;
    }

    return MSP_COM_OP_SUCCESS;
}

/**
 * ƣ zMspCom_CamClose 
 *  رCam豸
 * ˵ (IN)
 *            (OUT)
 *   ֵ 
 * ˵ 
 */
VOID zMspCom_CamClose(VOID)
{
    if (0 == g_tMspDevFd.uiCamFd)
    {
        return;
    }

    zDrv_Close(g_tMspDevFd.uiCamFd);

    g_tMspDevFd.uiCamFd = 0;

}

/**
 * ƣ zMspCom_GetCamFd 
 *  õCam豸
 * ˵ (IN)
 *            (OUT)
 *   ֵ Cam豸
 * ˵ 
 */
UINT32 zMspCom_GetCamFd(VOID)
{
    return g_tMspDevFd.uiCamFd;
}

/**
 * ƣ zMspCom_GetVideoFd 
 *  õVideo豸
 * ˵ (IN)
 *            (OUT)
 *   ֵ Video豸
 * ˵ 
 */
UINT32 zMspCom_GetVideoFd(VOID)
{
    return g_tMspDevFd.uiVideoFd;
}

/**
 * ƣ zMspCom_GetAudioFd 
 *  õAudio豸
 * ˵ (IN)
 *            (OUT)
 *   ֵ Audio豸
 * ˵ 
 */
UINT32 zMspCom_GetAudioFd(VOID)
{
    return g_tMspDevFd.uiAudioFd;
}

/**
 * ƣ zMspCom_GetMidiFd 
 *  õMidi豸
 * ˵ (IN)
 *            (OUT)
 *   ֵ Midi豸
 * ˵ 
 */
UINT32 zMspCom_GetMidiFd(VOID)
{
    return g_tMspDevFd.uiMidiFd;
}

/**
 * ƣ zMspCom_GetToneFd 
 *  õTone豸
 * ˵ (IN)
 *            (OUT)
 *   ֵ Midi豸
 * ˵ 
 */
UINT32 zMspCom_GetToneFd(VOID)
{
    return g_tMspDevFd.uiToneFd;
}

/**
 * ƣ zMspCom_SetOutputVol 
 *  
 * ˵ (IN)vol: 
 *            (OUT):
 *   ֵ ɹMSP_COM_OP_SUCCESS
 * ˵ 
 */
SINT32 zMspCom_SetOutputVol(T_MSP_OUTPUT_VOLUME_LEVEL vol)
{
    SINT32                     iRet       = -1;
    T_ZDrvAudio_OutputVolLevel tOutputVol = (T_ZDrvAudio_OutputVolLevel)vol;
    T_ZDrvMidi_OutputVolLevel  midiOutputVol;

    if (0 == g_tMspDevFd.uiAudioFd
        && 0 == g_tMspDevFd.uiMidiFd)
    {
        return MSP_DEV_UNOPENED;
    }
   
    if (0 == g_tMspDevFd.uiAudioFd)
    {
        midiOutputVol = (T_ZDrvMidi_OutputVolLevel)vol;
        if ((midiOutputVol < MIDI_OUTPUT_VOL_LEVEL_0)
        || (midiOutputVol > MAX_MIDI_OUTPUT_VOL_LEVEL))
        {
            midiOutputVol = MIDI_OUTPUT_VOL_LEVEL_5;
        }
        
        iRet = zDrv_Ioctl(g_tMspDevFd.uiMidiFd, IOCTL_MIDI_SET_OUTPUT_VOL, &midiOutputVol);
    }
    else
    {
        tOutputVol = (T_ZDrvAudio_OutputVolLevel)vol;        
        if ((tOutputVol < AUDIO_OUTPUT_VOL_LEVEL_0)
        || (tOutputVol > MAX_AUDIO_OUTPUT_VOL_LEVEL))
        {
            tOutputVol = AUDIO_OUTPUT_VOL_LEVEL_5;
        }
/**
        if (AUDIO_OUTPUT_VOL_LEVEL_0 == tOutputVol)
        {
            zMspCom_SetMute(TRUE);
        }
        else if (MSP_OUTPUT_VOLUME_LEVEL_0 == g_tAudioPlayParam.tOutputVol)
        {
            zMspCom_SetMute(FALSE);
        }
**/        
        iRet = zDrv_Ioctl(g_tMspDevFd.uiAudioFd, IOCTL_AUDIO_SET_OUTPUT_VOL, &tOutputVol);
        
    }    
    if (iRet != DRV_SUCCESS)
    {
        return MSP_COM_OP_ERROR;       
    }

    g_tAudioPlayParam.tOutputVol = vol;

    return MSP_COM_OP_SUCCESS;   
}

/**
 * ƣ zMspCom_GetOutputVol 
 *  õ
 * ˵ (IN):  
 *            (OUT): vol: 
 *   ֵ ɹMSP_COM_OP_SUCCESS
 * ˵ 
 */
SINT32 zMspCom_GetOutputVol(T_MSP_OUTPUT_VOLUME_LEVEL *vol)
{
    if (NULL == vol)
    {
        return MSP_PARAM_ERROR;
    }
    
    *vol = g_tAudioPlayParam.tOutputVol;

    return MSP_COM_OP_SUCCESS;
}

/**
 * ƣ zMspCom_SetInputVol 
 *  
 * ˵ (IN)vol: 
 *            (OUT):
 *   ֵ ɹMSP_COM_OP_SUCCESS
 * ˵ Ŀǰֻ¼õľ¼
 *             Ŀ
 */
SINT32 zMspCom_SetInputVol(T_MSP_INPUT_VOLUME_LEVEL vol)
{
    SINT32                    iRet      = -1;    
    T_ZDrvAudio_InputVolLevel tInputVol = (T_ZDrvAudio_InputVolLevel)vol;

    if (0 == g_tMspDevFd.uiAudioFd)
    {
        return MSP_DEV_UNOPENED;
    }
    
    if ((tInputVol < AUDIO_INPUT_VOL_LEVEL_0)
        || (tInputVol > AUDIO_INPUT_VOL_LEVEL_5))
    {
        tInputVol = AUDIO_INPUT_VOL_LEVEL_3;
    }

    iRet = zDrv_Ioctl(g_tMspDevFd.uiAudioFd, IOCTL_AUDIO_SET_RECORD_VOL, &tInputVol);
    if (iRet != DRV_SUCCESS)
    {
        return MSP_COM_OP_ERROR;       
    }

    return MSP_COM_OP_SUCCESS;   
}

/**
 * ƣ zMspCom_SetOutputChannel 
 *  ͨ
 * ˵ (IN)vol: ͨ
 *            (OUT):
 *   ֵ ɹMSP_COM_OP_SUCCESS
 * ˵ 
 */
SINT32  zMspCom_SetOutputChannel(T_MSP_CHANNEL_OUTPUT channel)
{
    SINT32                 iRet = -1;
    T_ZDrv_CodecOutputPath tOutputPath;
    
    if (0 == g_tMspDevFd.uiAudioFd
     && 0 == g_tMspDevFd.uiMidiFd)
    {
        return MSP_DEV_UNOPENED;
    }
    
    switch (channel)
    {
        case MSP_CHANNEL_OUTPUT_RECEIVER:
        {
            tOutputPath = CODEC_OUTPUT_RECEIVER;            
            break;
        }

        case MSP_CHANNEL_OUTPUT_SPEAKER:
        {
            tOutputPath = CODEC_OUTPUT_SPEAKER;            
            break;
        }

        case MSP_CHANNEL_OUTPUT_HEADPHONE:
        {
            tOutputPath = CODEC_OUTPUT_HEADSET;            
            break;
        }

        case MSP_CHANNEL_OUTPUT_SPEAKER_HEADPHONE:
        {
            tOutputPath = CODEC_OUTPUT_HSANDSPK;            
            break;
        }

        
        case MSP_CHANNEL_OUTPUT_BLUETOOTH:
        {
            tOutputPath = CODEC_OUTPUT_BLUETOOTH;
            break;
        }

        default:
        {
            tOutputPath = CODEC_OUTPUT_SPEAKER;           
            break;
        }
    }

    if (0 == g_tMspDevFd.uiAudioFd)
    {
        iRet = zDrv_Ioctl(g_tMspDevFd.uiMidiFd, IOCTL_MIDI_SET_OUTPUT_PATH, &tOutputPath);
    }
    else
    {
        iRet = zDrv_Ioctl(g_tMspDevFd.uiAudioFd, IOCTL_AUDIO_SET_OUTPUT_PATH, &tOutputPath);
    }
    if (iRet != DRV_SUCCESS)
    {
        return MSP_COM_OP_ERROR;
    }

    g_tAudioPlayParam.tOutputChannel = channel;

    return MSP_COM_OP_SUCCESS;  
}

/**
 * ƣ zMspCom_GetOutputChannel 
 *  ͨ
 * ˵ (IN):   
 *            (OUT): channel: ͨ
 *   ֵ ɹMSP_COM_OP_SUCCESS
 * ˵ 
 */
SINT32  zMspCom_GetOutputChannel(T_MSP_CHANNEL_OUTPUT *channel)
{
    if (NULL == channel)
    {
        return MSP_PARAM_ERROR;
    }
    
    *channel = g_tAudioPlayParam.tOutputChannel;

    return MSP_COM_OP_SUCCESS;
}

/**
 * ƣ zMspCom_SetInputChannel 
 *  ͨ
 * ˵ (IN)vol: ͨ
 *            (OUT)
 *   ֵ ɹMSP_COM_OP_SUCCESS
 * ˵ 
 */
SINT32  zMspCom_SetInputChannel (T_MSP_CHANNEL_INPUT channel)
{
    SINT32                iRet = -1;
    T_ZDrv_CodecInputPath tInputPath;

    if (0 == g_tMspDevFd.uiAudioFd
        && 0 == g_tMspDevFd.uiMidiFd)
    {
        return MSP_DEV_UNOPENED;
    }

    switch (channel)
    {
        case MSP_CHANNEL_INPUT_MICPHONE:
        {
            tInputPath = CODEC_INPUT_MICPHONE;            
            break;
        }

        case MSP_CHANNEL_INPUT_HEADSET:
        {
            tInputPath = CODEC_INPUT_HEADSET;            
            break;
        }

        default:
        {
            tInputPath = CODEC_INPUT_MICPHONE;           
            break;
        }
    }

    iRet = zDrv_Ioctl(g_tMspDevFd.uiAudioFd, IOCTL_AUDIO_SET_RECORD_PATH, &tInputPath);
    if (iRet != DRV_SUCCESS)
    {
        return MSP_COM_OP_ERROR;
    }

    return MSP_COM_OP_SUCCESS;  
}

/**
 * ƣ zMspCom_GetMute 
 *  ȡ
 * ˵ (IN): 
 *            (OUT):bFlag
 *   ֵ ɹMSP_COM_OP_SUCCESS
 * ˵ 
 */
SINT32  zMspCom_GetMute(BOOL *bFlag)
{
    if (0 == g_tMspDevFd.uiAudioFd
        && 0 == g_tMspDevFd.uiMidiFd)
    {
        return MSP_DEV_UNOPENED;
    }
    
    if (NULL == bFlag)
    {
        return MSP_PARAM_ERROR;
    }
    
    *bFlag = g_tAudioPlayParam.bMute;

    return MSP_COM_OP_SUCCESS;  
}


/**
 * ƣ zMspCom_SetMute 
 *  þ
 * ˵ (IN): bFlag: TRUE: þ
 *                         FALSE:ȡ
 *            (OUT):
 *   ֵ ɹMSP_COM_OP_SUCCESS
 * ˵ 
 */
SINT32  zMspCom_SetMute(BOOL bFlag)
{
    SINT32 iRet = -1;

    if (0 == g_tMspDevFd.uiAudioFd
        && 0 == g_tMspDevFd.uiMidiFd)
    {
        return MSP_DEV_UNOPENED;
    }

    if (0 == g_tMspDevFd.uiAudioFd)
    {
        iRet = zDrv_Ioctl(g_tMspDevFd.uiMidiFd, IOCTL_MIDI_SET_MUTE, &bFlag);
    }
    else
    {
        iRet = zDrv_Ioctl(g_tMspDevFd.uiAudioFd, IOCTL_AUDIO_SET_MUTE, &bFlag);
    }    
    if (iRet != DRV_SUCCESS)
    {
        return MSP_COM_OP_ERROR;       
    }
    
    g_tAudioPlayParam.bMute =  bFlag;
    
    return MSP_COM_OP_SUCCESS;
}

/**
 * ƣ zMspCom_SetZoom 
 *  ͷ
 * ˵ (IN)zoom: ż
 *            (OUT)
 *   ֵ ɹMSP_COM_OP_SUCCESS
 * ˵ ʱָ֧ù
 */
SINT32  zMspCom_SetZoom(T_MSP_ZOOM_LEVEL zoom)
{
    SINT32         iRet     = -1;
    T_ZDrv_CamZoom tCamZoom = (T_ZDrv_CamZoom)zoom;

    if (0 == g_tMspDevFd.uiCamFd)
    {
        return MSP_DEV_UNOPENED;
    }

    if ((tCamZoom < ZOOM_LEVEL_0) || (tCamZoom > ZOOM_LEVEL_4))
    {
        return MSP_PARAM_ERROR;
    }
    
    iRet = zDrv_Ioctl(g_tMspDevFd.uiCamFd, IOCTL_CAM_SENSOR_ZOOM, &tCamZoom);
    if (iRet != DRV_SUCCESS)
    {
        return MSP_COM_OP_ERROR;
    }

    return MSP_COM_OP_SUCCESS;    
}

/**
 * ƣ zMspCom_SetBrightness 
 *  ͷ
 * ˵ (IN)brightness: ȼ
 *            (OUT)
 *   ֵ ɹMSP_COM_OP_SUCCESS
 * ˵ 
 */
SINT32  zMspCom_SetBrightness(T_MSP_BRIGHTNESS_LEVEL brightness)
{
    SINT32               iRet       = -1;
    T_ZDrv_CamBrightness tCamBright = (T_ZDrv_CamBrightness)brightness;


    if (0 == g_tMspDevFd.uiCamFd)
    {
        return MSP_DEV_UNOPENED;
    }

    if ((tCamBright < BRI_LEVEL_0) || (tCamBright > BRI_LEVEL_4))
    {
        return MSP_PARAM_ERROR;
    }
    
    iRet = zDrv_Ioctl(g_tMspDevFd.uiCamFd, IOCTL_CAM_SENSOR_BRIGHTNESS, &tCamBright);
    if (iRet != DRV_SUCCESS)
    {
        return MSP_COM_OP_ERROR;
    }

    return MSP_COM_OP_SUCCESS;   
    
}

/**
 * ƣ zMspCom_SetContrast 
 *  ͷԱȶ
 * ˵ (IN)contrast: Աȶȼ
 *            (OUT)
 *   ֵ ɹMSP_COM_OP_SUCCESS
 * ˵ 
 */
SINT32  zMspCom_SetContrast(T_MSP_CONTRAST_LEVEL contrast)
{
    SINT32             iRet         = -1;
    T_ZDrv_CamContrast tCamContrast = (T_ZDrv_CamContrast)contrast;


    if (0 == g_tMspDevFd.uiCamFd)
    {
        return MSP_DEV_UNOPENED;
    }

    if ((tCamContrast < CON_LEVEL_0) || (tCamContrast > CON_LEVEL_4))
    {
        return MSP_PARAM_ERROR;
    }
    
    iRet = zDrv_Ioctl(g_tMspDevFd.uiCamFd, IOCTL_CAM_SENSOR_CONTRAST, &tCamContrast);
    if (iRet != DRV_SUCCESS)
    {
        return MSP_COM_OP_ERROR;
    }

    return MSP_COM_OP_SUCCESS;  

}

/**
 * ƣ zMspCom_SetEffect 
 *  ͷЧ
 * ˵ (IN)effect: Чֵ
 *            (OUT)
 *   ֵ ɹMSP_COM_OP_SUCCESS
 * ˵ 
 */
SINT32  zMspCom_SetEffect(T_MSP_EFFECT_LEVEL effect)
{
    SINT32 iRet = -1;
    T_ZDrv_CamEffect tCamEffect = EFF_NORMAL;

    if (0 == g_tMspDevFd.uiCamFd)
    {
        return MSP_DEV_UNOPENED;
    }
    
    switch (effect)
    {
        case MSP_EFF_NORMAL:
        {
            tCamEffect = EFF_NORMAL;
            break;
        }

        case MSP_EFF_BLACK_AND_WHITE:
        {
            tCamEffect = EFF_BLACK_AND_WHITE;
            break;
        }

        case MSP_EFF_SEPIA:
        {
            tCamEffect = EFF_ANTIQUE;
            break;
        }

        case MSP_EFF_NEGA:
        {
            tCamEffect = EFF_NEGATIVE;
            break;
        }

        case MSP_EFF_EMBOSS:
        {
            //tCamEffect = EFF_EMBOSS;
            break;
        }

        default:
        {
            tCamEffect = EFF_NORMAL;
            break;            
        }
    }

    iRet = zDrv_Ioctl(g_tMspDevFd.uiCamFd, IOCTL_CAM_SENSOR_EFFECT, &tCamEffect);
    if (iRet != DRV_SUCCESS)
    {
        return MSP_COM_OP_ERROR;
    }

    return MSP_COM_OP_SUCCESS;  
}

/**
 * ƣ zMspCom_SetCaputureMode
 *  ģʽ
 * ˵ (IN)modeCAPTURE_MODE_Eṹ
 *   ֵ ɹMSP_COM_OP_SUCCESS
 * ˵ ˺ƶģ cyx 2009-9-7
 */
SINT32 zMspCom_SetCaputureMode(CAPTURE_MODE_E mode)
{
    SINT32 iRet = -1;
    T_ZDrv_CamNightMode tNightMode = NIGHT_MODE_0;
    T_ZDrv_CamFps       tFrameRate = Fps714;
    if(g_tMspDevFd.uiCamFd <= 0)
    {
        return DCAMERA_OP_ERROR;
    }

    switch (mode)
    {
        case CAPTURE_MODE_NIGHT:
        {
            tNightMode = NIGHT_MODE_0;
            iRet = zDrv_Ioctl(g_tMspDevFd.uiCamFd, IOCTL_CAM_SENSOR_NIGHTMODE, &tNightMode);
            if (DRV_SUCCESS != iRet)
            {
                return DCAMERA_OP_ERROR;
            }
            
            break;
        }

        case CAPTURE_MODE_NORMAL:
        {
            tFrameRate = Fps15;
            iRet = zDrv_Ioctl(g_tMspDevFd.uiCamFd, IOCTL_CAM_SENSOR_FRAMERATE, &tFrameRate);
            if (DRV_SUCCESS != iRet)
            {
                return DCAMERA_OP_ERROR;
            }
            break;
        }

        default:
        {
            tFrameRate = Fps15;
            iRet = zDrv_Ioctl(g_tMspDevFd.uiCamFd, IOCTL_CAM_SENSOR_FRAMERATE, &tFrameRate);
            if (DRV_SUCCESS != iRet)
            {
                return DCAMERA_OP_ERROR;
            }
            break;
        }
    }

    return DCAMERA_OP_SUCCESS;       
}

/**
 * ƣ zMspCom_SetMirror
 *  þ
 * ˵ (IN)paramMIRROR_PARAM_Tṹ
 *   ֵ ɹDCAMERA_OP_SUCCESS;
 * ˵ 
 */
SINT32 zMspCom_SetMirror(MIRROR_PARAM_T *param)
{
    T_ZDrv_MirrorType  t_MirrorType = MIR_H;
    SINT32 iRet = 0;

    /* P98C-CXX-0001 2012-7-18EC:617001630060þ쳣  BEGIN */ 
    if(g_tMspDevFd.uiCamFd == 0)
    {
	zOss_Printf(1, 1, "ͷδ");
	return DCAMERA_OP_ERROR;	
    }	
    /* P98C-CXX-0001 2012-7-18EC:617001630060þ쳣  END */ 
    
    if(NULL == param)
    {
        return DCAMERA_OP_ERROR;
    }
    
    if(param->hMirror && param->vMirror)
    {
        t_MirrorType = MIR_V_H;
    }
    else if(param->hMirror)
    {
        t_MirrorType = MIR_H;
    }
    else if(param->vMirror)
    {
        t_MirrorType = MIR_V;
    }
    else
    {
        t_MirrorType = MIR_NONE;
    }
    
    iRet = zDrv_Ioctl((UINT32)g_tMspDevFd.uiCamFd, IOCTL_CAM_SET_MIRROR, &t_MirrorType);
    if(iRet != DRV_SUCCESS)
    {
        return DCAMERA_OP_ERROR;
    }
    
    return DCAMERA_OP_SUCCESS;
}

/**
 * ƣ zMspCom_SetWhiteBalance 
 *  ðƽ
 * ˵ (IN)whiteBalance: ƽֵ
 *            (OUT)
 *   ֵ ɹMSP_COM_OP_SUCCESS
 * ˵ Ŀǰ֧
 */
SINT32  zMspCom_SetWhiteBalance(T_MSP_WHITE_BALANCE whiteBalance)
{
    SINT32 iRet = -1;
    T_ZDrv_CamWhiteBalance tWhiteBalance = WB_AOTO;
    /* P98C-CXX-0001 2012-7-18EC:617001630060ðƽ쳣  BEGIN */ 
    if(g_tMspDevFd.uiCamFd == 0)
    {
	zOss_Printf(1, 1, "ͷδ");
	return DCAMERA_OP_ERROR;	
    }	
    /* P98C-CXX-0001 2012-7-18EC:617001630060ðƽ쳣  END*/ 

    if(whiteBalance == MSP_WHITEBALANCE_AUTO)
    {
        tWhiteBalance = WB_AOTO;
    }
    else if(whiteBalance == MSP_WHITEBALANCE_CLOUDY)
    {
        tWhiteBalance = WB_CLOUDY;
    }
    else if(whiteBalance == MSP_WHITEBALANCE_DAYLIGHT)
    {
        tWhiteBalance = WB_SUNNY;
    }
    else if(whiteBalance == MSP_WHITEBALANCE_FLUORESCENCE)
    {
        tWhiteBalance = WB_FLUORESCENT;
    }
    else if(whiteBalance == MSP_WHITEBALANCE_INCANDESCENCE)
    {
        tWhiteBalance = WB_BULB;
    }
    else
    {
        tWhiteBalance = WB_AOTO;
    }
        
    iRet = zDrv_Ioctl((UINT32)g_tMspDevFd.uiCamFd, IOCTL_CAM_SENSOR_WHITEBLANCE, &tWhiteBalance);
    if(iRet != DRV_SUCCESS)
    {
        return DCAMERA_OP_ERROR;
    }
    
    return MSP_COM_OP_SUCCESS;
    
}

/**
 * ƣ zMspCom_DecPostProcess 
 *  ýļ
 * ˵ (IN)  u32FileID   ýļͨID
 *   ֵ 
 * ˵ 
 */
VOID zMspCom_DecPostProcess(UInt32 u32FileID)
{
    CloseMediaFileHandler(u32FileID);   

    return;
}

/**
 * ƣ zMspCom_LoadAudioDecodeLib 
 *  Ƶ
 * ˵ (IN)  eMediaAType  Ƶݸʽ
 *   ֵ ɹMSP_COM_OP_SUCCESS
 * ˵ Ƶָ֧ʽԺҪ
 */
SINT32 zMspCom_LoadAudioDecodeLib(EMediaAudioType eMediaAType)
{
    SINT32  iRet = MSP_COM_OP_ERROR;

    /* Ժֶ֧̬ʱ˴޸ */
    switch(eMediaAType)
    {
        /*
        case MEDIA_AUDIO_UNKNOWN:
        {
            iRet = MSP_COM_OP_SUCCESS;
            break;
        }
        */
        case ZM_CODEC_ID_AMR_NB:
        {
            #ifdef __USE_AMR_DECODER__
            Zte_AMR_Decoder_Init = AMR_Decoder_Init;
            Zte_AMR_Decoder_Proc = AMR_Decoder_Proc; 
            
            iRet = MSP_COM_OP_SUCCESS;
            #else
            iRet = MSP_COM_OP_ERROR;
            #endif
 
            break;
        }

        case ZM_CODEC_ID_MP3:
        {
            #ifdef __USE_MP3_DECODER__
            Zte_MP3_Decoder_Init = MP3_Decoder_Init;
            Zte_MP3_Decoder_Proc = MP3_Decoder_Proc;

            iRet = MSP_COM_OP_SUCCESS;
            #else
            iRet = MSP_COM_OP_ERROR;
            #endif
         
            break;
        }

        case ZM_CODEC_ID_AAC:
        case ZM_CODEC_ID_AAC_PLUS:  
        {
            #ifdef __USE_AAC_DECODER__
            Zte_AAC_Decoder_Init = AAC_Decoder_Init;
            Zte_AAC_Decoder_Proc = AAC_Decoder_Proc;

            iRet = MSP_COM_OP_SUCCESS;
            #else
            iRet = MSP_COM_OP_ERROR;
            #endif
         
            break;
        }

        default:
        {
            iRet = MSP_COM_OP_ERROR;
            break;
        }
    }
    
    return iRet;
}

/**
 * ƣ zMspCom_UnLoadAudioDecodeLib 
 *  Ƶж
 * ˵ (IN)  eMediaAType  Ƶݸʽ
 *   ֵ 
 * ˵ Ƶָ֧ʽԺҪ
 */
VOID zMspCom_UnLoadAudioDecodeLib(EMediaAudioType eMediaAType)
{
    /* Ժֶ֧̬ʱ˴޸ */
    switch(eMediaAType)
    {
        /*
        case MEDIA_AUDIO_UNKNOWN:
        {
            break;
        }
        */
        case ZM_CODEC_ID_AMR_NB:
        {
            #ifdef __USE_AMR_DECODER__
            Zte_AMR_Decoder_Init = (AMR_Decoder_Init_ZTE)NULL;
            Zte_AMR_Decoder_Proc = (AMR_Decoder_Proc_ZTE)NULL;
            #endif
            
            break;
        }

        case ZM_CODEC_ID_MP3:
        {
            #ifdef __USE_MP3_DECODER__
            Zte_MP3_Decoder_Init = (MP3_Decoder_Init_ZTE)NULL;
            Zte_MP3_Decoder_Proc = (MP3_Decoder_Proc_ZTE)NULL;
           #endif

            break;
        }

        case ZM_CODEC_ID_AAC:
        case ZM_CODEC_ID_AAC_PLUS:
        {
            #ifdef __USE_AAC_DECODER__
            Zte_AAC_Decoder_Init = (AAC_Decoder_Init_ZTE)NULL;
            Zte_AAC_Decoder_Proc = (AAC_Decoder_Proc_ZTE)NULL;
           #endif

            break;
        }

        default:
        {
            break;
        }
    }
    
    return;
}

/**
 * ƣ zMspCom_LoadAudioEnCodeLib 
 *  Ƶ
 * ˵ (IN)  eMediaAType  Ƶݸʽ
 *   ֵ ɹMSP_COM_OP_SUCCESS
 * ˵ Ƶָ֧ʽԺҪ
 */
SINT32 zMspCom_LoadAudioEnCodeLib(EMediaAudioType eMediaAType)
{
    SINT32  iRet = MSP_COM_OP_ERROR;

    /* Ժֶ֧̬ʱ˴޸ */
    switch(eMediaAType)
    {
        case ZM_CODEC_ID_AMR_NB:
        {
            #ifdef __USE_AMR_ENCODER__
            Zte_AMR_Encoder_Init = AMR_Encoder_Init;
            Zte_AMR_Encoder_Proc = AMR_Encoder_Proc; 
            
            iRet = MSP_COM_OP_SUCCESS;
            #else
            iRet = MSP_COM_OP_ERROR;
            #endif
         
            break;
        }
        case ZM_CODEC_ID_MP3:
        {
            #ifdef __USE_MP3_ENCODER__
            Zte_MP3_Encoder_Init = MP3_Encoder_Init;
            Zte_MP3_Encoder_Proc = MP3_Encoder_Proc; 
		
            iRet = MSP_COM_OP_SUCCESS;
            #else
            iRet = MSP_COM_OP_ERROR;
            #endif
         
            break;
        }       
        default:
        {
            iRet = MSP_COM_OP_ERROR;
            break;
        }
    }
    
    return iRet;
}

/**
 * ƣ zMspCom_UnLoadAudioEnCodeLib 
 *  Ƶж
 * ˵ (IN)  eMediaAType  Ƶݸʽ
 *   ֵ 
 * ˵ Ƶָ֧ʽԺҪ
 */
VOID zMspCom_UnLoadAudioEnCodeLib(EMediaAudioType eMediaAType)
{
    /* Ժֶ֧̬ʱ˴޸ */
    switch(eMediaAType)
    {
        case ZM_CODEC_ID_AMR_NB:
        {
            #ifdef __USE_AMR_ENCODER__
            Zte_AMR_Encoder_Init = (AMR_Encoder_Init_ZTE)NULL;
            Zte_AMR_Encoder_Proc = (AMR_Encoder_Proc_ZTE)NULL;
            #endif
            
            break;
        }
        case ZM_CODEC_ID_MP3:
        {
            #ifdef __USE_MP3_ENCODER__
            Zte_MP3_Encoder_Init = (MP3_Encoder_Init_ZTE)NULL;
            Zte_MP3_Encoder_Proc = (MP3_Encoder_Proc_ZTE)NULL;
         #endif

            break;
        }
        default:
        {
            break;
        }
    }
    
    return;
}

/**
 * ƣ zMspCom_OpenAudioDecoder 
 *  Ƶ
 * ˵ (IN)  eMediaAType  Ƶݸʽ
 *            (IN)  buffer       ַ
 *            (IN)  uiLen        ݳ
 *            (IN)  pAacParam    Aac
 *            (OUT) pChannelMode ģʽ
 *            (OUT) pSampleRate  PCMݲ
 *   ֵ ʧܷNULL
 * ˵ Ƶָ֧ʽԺҪ
 */
T_MediaAudioDecHandle *zMspCom_OpenAudioDecoder(EMediaAudioType         eMediaAType, 
                                   UINT8                  *buffer, 
                                   UINT32                  uiLen, 
                                   T_Audio_AacParam       *pAacParam,
                                   T_ZDrvAudio_Channel    *pChannelMode,
                                   T_ZDrvAudio_SampleRate *pSampleRate)
{
    T_MediaAudioDecHandle  *pHandle = zOss_Malloc(sizeof(T_MediaAudioDecHandle));

    pHandle->eMediaAType = eMediaAType;
    
    switch(eMediaAType)
    {
        /*
        case MEDIA_AUDIO_UNKNOWN:
        {
            pHandle = NULL;
            break;
        }
        */
        case ZM_CODEC_ID_AMR_NB:
        {
            pHandle->pMediaDecHandle = Zte_AMRDecoderOpen(buffer, uiLen, pChannelMode, pSampleRate);
            break;
        }
        case ZM_CODEC_ID_MP3:
        {
            pHandle->pMediaDecHandle = Zte_MP3DecoderOpen(buffer, uiLen, pChannelMode, pSampleRate);
            break;
        }
        case ZM_CODEC_ID_AAC:
        case ZM_CODEC_ID_AAC_PLUS:
        {
            pHandle->pMediaDecHandle = Zte_AACDecoderOpen(buffer,
                                         uiLen,
                                         pAacParam,
                                         pChannelMode,
                                         pSampleRate);
            break;
        }
        default:
        {
            zOss_Free(pHandle);
            pHandle = NULL;
            break;
        }
    }

    if(pHandle->pMediaDecHandle == NULL)
    {
        zOss_Free(pHandle);
        pHandle = NULL;
    }

    return pHandle;
}

/**
 * ƣ zMspCom_CloseAudioDecoder 
 *  رƵ
 * ˵ (IN)  eMediaAType: Ƶݸʽ
 *            (IN)  pHandle:     
 *   ֵ 
 * ˵ Ƶָ֧ʽԺҪ
 */
VOID zMspCom_CloseAudioDecoder(T_MediaAudioDecHandle *pHandle)
{    
    switch(pHandle->eMediaAType)
    {
        /*
        case MEDIA_AUDIO_UNKNOWN:
        {
            break;
        }
        */
        case ZM_CODEC_ID_AMR_NB:
        {
            Zte_AMRDecoderClose(pHandle->pMediaDecHandle);
            zOss_Free(pHandle);

            break;
        }
        case ZM_CODEC_ID_MP3:
        {
            Zte_MP3DecoderClose(pHandle->pMediaDecHandle);
            zOss_Free(pHandle);

            break;
        }
        case ZM_CODEC_ID_AAC:
        case ZM_CODEC_ID_AAC_PLUS:
        {
            Zte_AACDecoderClose(pHandle->pMediaDecHandle);
            zOss_Free(pHandle);

            break;
        }
        default:
        {
            break;
        }
    }


    return;    
}

/**
 * ƣ zMspCom_AudioDecode 
 *  Ƶݽ
 * ˵ (IN) pHandle      
 *            (IN) eMediaAType  Ƶظʽ
 *            (IN) pOutUnit     һ֡Ƶ
 *            (IN) pPhyBuf      ַ
 *            (IN) uiLen        
 *   ֵ ʵд볤ȡ
 * ˵ 
 */
UINT32 zMspCom_AudioDecode(T_Audio_DecodeParam * pDecParam)
{
    UINT32  uiUsedLen = 0; 
    
    switch(pDecParam->pHandle->eMediaAType)
    {
        /*
        case MEDIA_AUDIO_UNKNOWN:
        {
            uiUsedLen = 0;
            break;
        }
        */
        case ZM_CODEC_ID_AMR_NB:
        {
            uiUsedLen = Zte_AMRDecodeAudio(pDecParam->pHandle->pMediaDecHandle, pDecParam->pOutUnit, 
                                             pDecParam->pPhyBuf, pDecParam->uiLen);
            break;
        }
        case ZM_CODEC_ID_MP3:
        {
            uiUsedLen = Zte_MP3DecodeAudio(pDecParam->pHandle->pMediaDecHandle, pDecParam->pOutUnit, 
                                             pDecParam->pPhyBuf, pDecParam->uiLen);
            break;
        }
        case ZM_CODEC_ID_AAC:
        case ZM_CODEC_ID_AAC_PLUS:
        { 
            uiUsedLen = Zte_AACDecodeAudio(pDecParam->pHandle->pMediaDecHandle, pDecParam->pOutUnit, 
                                             pDecParam->pPhyBuf, pDecParam->uiLen);
            break;
        }
        default:
        {
            uiUsedLen = 0;
            break;
        }
    }

    return uiUsedLen;
}

/**
 * ƣ zMspCom_OpenAudioEncoder 
 *  Ƶ
 * ˵ (IN)eMediaAType:  ʽ
 *            (IN)pAddData:     򿪱ĸӲ
 *            (OUT)pFrameLen:   ʱһPCMݳ(λ:)
 *   ֵ 
 * ˵ AMR˲ΪNULL; MP3
 *            ˲ΪT_MP3AddEnCoderDataṹ
 */
T_MediaAudioEncHandle * zMspCom_OpenAudioEncoder(EMediaAudioType         eMediaAType,
                                   VOID             *pAddData,
                                   UINT32                 *pFrameLen)
{
    T_MediaAudioEncHandle *  pHandle = zOss_Malloc(sizeof(T_MediaAudioEncHandle));

    pHandle->eMediaAType = eMediaAType;
    
    /* Ŀǰֻ֧AMRı */
    switch(eMediaAType)
    {
        case ZM_CODEC_ID_AMR_NB:
        {
            pHandle->pMediaEncHandle = Zte_AMREncoderOpen(pFrameLen);
            break;
        }
        case ZM_CODEC_ID_MP3:
        {
            pHandle->pMediaEncHandle = Zte_MP3EncoderOpen(pAddData, pFrameLen);
            break;
        }
        default:
        {
            zOss_Free(pHandle);
            pHandle = NULL;
            break;
        }
    }

    return pHandle;
}

/**
 * ƣ zMspCom_CloseAudioEncoder 
 *  رƵ
 * ˵ (IN)eMediaAType:  ʽ
 *            (IN)pHandle:      
 *   ֵ 
 * ˵ Ŀǰ֧AMR
 */
VOID zMspCom_CloseAudioEncoder(T_MediaAudioEncHandle *pHandle)
{
    switch(pHandle->eMediaAType)
    {
        case ZM_CODEC_ID_AMR_NB:
        {
            Zte_AMREncoderClose(pHandle->pMediaEncHandle);
            zOss_Free(pHandle);
            break;
        }
        case ZM_CODEC_ID_MP3:
        {
            Zte_MP3EncoderClose(pHandle->pMediaEncHandle);
            zOss_Free(pHandle);
            break;
        }
        default:
        {
            break;
        }
    }

    return; 
}

/**
 * ƣ zMspCom_AudioEncode 
 *  Ƶݱ
 * ˵ (IN)pHandle:      
 *            (IN)eMediaAType:  ʽ
 *            (IN)pRawData:     Դ
 *            (IN)uiRawDataLen: pRawData(λΪֽ)
 *            (OUT)pOutDataLen: ݳ(λΪֽ)
 *   ֵ ʵʱݣûʹϺͷ
 * ˵ 
 */
UINT8 *zMspCom_AudioEncode(T_MediaAudioEncHandle   *pHandle,  
                           VOID      *pRawData,  UINT32           uiRawDataLen,
                           UINT32    *pOutDataLen)
{
    UINT8 *pOutData = NULL;

    if(NULL == pHandle
       || NULL == pRawData
       || NULL == pOutDataLen
       || 0 == uiRawDataLen)
    {
        return 0;
    }
    
    switch(pHandle->eMediaAType)
    {
        case ZM_CODEC_ID_AMR_NB:
        {
            pOutData = Zte_AMRAudioEncode(pHandle->pMediaEncHandle, pRawData, uiRawDataLen, pOutDataLen);

            break;
        }
        case ZM_CODEC_ID_MP3:
        {
            pOutData = Zte_MP3AudioEncode(pHandle->pMediaEncHandle, pRawData, uiRawDataLen, pOutDataLen);

            break;
        }
        default:
        {
            pOutData = NULL;
            
            break;
        }
    }

    return pOutData;
}

/**
 * ƣ zMspCom_OpenH263Encoder 
 *  H263Ƶ
 * ˵ (IN) pInitParam:   ʼ  
                               (Out)pEncCfg:      Ƶò
 *   ֵ ɹ0
 * ˵ 
 */
SINT32 zMspCom_OpenH263Encoder(T_VideoEncInitParam *pInitParam, T_ZDrvVideo_EncCfg *pEncCfg)
{
    SINT32 iRet = -1;
    
    pEncCfg->tInput.uiStride   = pInitParam->uiStride;
    pEncCfg->tInput.tPixelFmt  = pInitParam->tPixelFmt;
    pEncCfg->tOutput.uiWidth   = pInitParam->uiWidth;
    pEncCfg->tOutput.uiHeight  = pInitParam->uiHeight;
    pEncCfg->tOutput.tCodecStd = pInitParam->tCodecStd;
    pEncCfg->tRotate           = pInitParam->tRotate;
    pEncCfg->tMirror           = pInitParam->tMirror;
    pEncCfg->uiFrameRate       = pInitParam->uiFrameRate;
    pEncCfg->uiBitrate         = pInitParam->uiBitrate;
    pEncCfg->uiGopSize         = 10;

    /* 򿪱ʼ */
    iRet = zDrv_Ioctl(pInitParam->uiVideoFd, IOCTL_VIDEO_ENCSTART, pEncCfg);

    return iRet;
}

/**
 * ƣ zMspCom_OpenMJPEGEncoder 
 *  MJPEGƵ
 * ˵ (IN) pInitParam:   ʼ  
                               (Out)pEncCfg:      Ƶò
 *   ֵ ɹ0
 * ˵ 
 */
SINT32 zMspCom_OpenMJPEGEncoder(T_VideoEncInitParam *pInitParam, T_ZDrvVideo_EncCfg *pEncCfg)
{
    SINT32 iRet = -1;
    
    pEncCfg->tInput.uiStride   = pInitParam->uiStride;
    pEncCfg->tInput.tPixelFmt  = pInitParam->tPixelFmt;
    pEncCfg->tOutput.uiWidth   = pInitParam->uiWidth;
    pEncCfg->tOutput.uiHeight  = pInitParam->uiHeight;
    pEncCfg->tOutput.tCodecStd = pInitParam->tCodecStd;
    pEncCfg->tRotate           = pInitParam->tRotate;
    pEncCfg->tMirror           = pInitParam->tMirror;
    pEncCfg->uiFrameRate       = pInitParam->uiFrameRate;
    pEncCfg->uiBitrate         = pInitParam->uiBitrate;
    pEncCfg->tEncStdParam.mjpegParam.tQualityType = pInitParam->tQuality;
    pEncCfg->uiGopSize         = 10;

    /* 򿪱ʼ */
    iRet = zDrv_Ioctl(pInitParam->uiVideoFd, IOCTL_VIDEO_ENCSTART, pEncCfg);

    return iRet;
}

/**
 * ƣ zMspCom_OpenAVCEncoder 
 *  AVCƵ
 * ˵ (IN) pInitParam:   ʼ  
                               (Out)pEncCfg:      Ƶò
 *   ֵ ɹ0
 * ˵ 
 */
SINT32 zMspCom_OpenAVCEncoder(T_VideoEncInitParam *pInitParam, T_ZDrvVideo_EncCfg *pEncCfg)
{
    SINT32 iRet = -1;
    
    pEncCfg->tInput.uiStride   = pInitParam->uiStride;
    pEncCfg->tInput.tPixelFmt  = pInitParam->tPixelFmt;
    pEncCfg->tOutput.uiWidth   = pInitParam->uiWidth;
    pEncCfg->tOutput.uiHeight  = pInitParam->uiHeight;
    pEncCfg->tOutput.tCodecStd = pInitParam->tCodecStd;
    pEncCfg->tRotate           = pInitParam->tRotate;
    pEncCfg->tMirror           = pInitParam->tMirror;
    pEncCfg->uiFrameRate       = pInitParam->uiFrameRate;
    pEncCfg->uiBitrate         = pInitParam->uiBitrate;
    pEncCfg->uiGopSize         = 10;

    /* 򿪱ʼ */
    iRet = zDrv_Ioctl(pInitParam->uiVideoFd, IOCTL_VIDEO_ENCSTART, pEncCfg);

    return iRet;
}

/**
 * ƣ zMspCom_OpenMPEG4Encoder 
 *  MPEG4Ƶ
 * ˵ (IN) pInitParam:   ʼ  
                               (Out)pEncCfg:      Ƶò
 *   ֵ ɹ0
 * ˵ 
 */
SINT32 zMspCom_OpenMPEG4Encoder(T_VideoEncInitParam *pInitParam, T_ZDrvVideo_EncCfg *pEncCfg)
{
    SINT32 iRet = -1;
    
    pEncCfg->tInput.uiStride   = pInitParam->uiStride;
    pEncCfg->tInput.tPixelFmt  = pInitParam->tPixelFmt;
    pEncCfg->tOutput.uiWidth   = pInitParam->uiWidth;
    pEncCfg->tOutput.uiHeight  = pInitParam->uiHeight;
    pEncCfg->tOutput.tCodecStd = pInitParam->tCodecStd;
    pEncCfg->tRotate           = pInitParam->tRotate;
    pEncCfg->tMirror           = pInitParam->tMirror;
    pEncCfg->uiFrameRate       = pInitParam->uiFrameRate;
    pEncCfg->uiBitrate         = pInitParam->uiBitrate;
    pEncCfg->uiGopSize         = 10;

    /* 򿪱ʼ */
    iRet = zDrv_Ioctl(pInitParam->uiVideoFd, IOCTL_VIDEO_ENCSTART, pEncCfg);

    return iRet;
}

/**
 * ƣ zMspCom_OpenVideoEncoder 
 *  Ƶ
 * ˵ (IN)pInitParam:      Ƶʼ
 *   ֵ Ƶʵ
 * ˵ 
 */
T_VideoEncInstParam *zMspCom_OpenVideoEncoder(T_VideoEncInitParam *pInitParam)
{
    SINT32               iRet = -1;
    T_ZDrvVideo_EncCfg   tEncCfgParam = {0};      /* òṹ */
    T_VideoEncInstParam *pVideoEncHandle = zOss_Malloc(sizeof(T_VideoEncInstParam));

    zOss_ASSERT(NULL != pVideoEncHandle);

    pVideoEncHandle->pHeaderData = NULL;
    pVideoEncHandle->uiHeaderLen = 0;

    switch (pInitParam->tCodecStd)
    {
        case VIDEO_CODEC_STD_MPEG4:
        {
            iRet = zMspCom_OpenMPEG4Encoder(pInitParam, &tEncCfgParam);
            if(DRV_SUCCESS == iRet)
            {
                if((tEncCfgParam.tOutput.tHeaderInfo.bufSize.streamBufSize<= 0)
                    || (tEncCfgParam.tOutput.tHeaderInfo.pDataBuf.streamDataBuf== NULL)
                    || (tEncCfgParam.tOutput.tHeaderInfo.bufType != STREAM_TYPE))
                {
                    zOss_ASSERT(0);
                }

                pVideoEncHandle->uiHeaderLen = tEncCfgParam.tOutput.tHeaderInfo.bufSize.streamBufSize;
                pVideoEncHandle->pHeaderData = zOss_Malloc(pVideoEncHandle->uiHeaderLen);
                
                zOss_Memcpy(pVideoEncHandle->pHeaderData, 
                    (const void *)(tEncCfgParam.tOutput.tHeaderInfo.pDataBuf.streamDataBuf), 
                    tEncCfgParam.tOutput.tHeaderInfo.bufSize.streamBufSize);
            }
            break;
        }
        case VIDEO_CODEC_STD_H263:
        {
            iRet = zMspCom_OpenH263Encoder(pInitParam, &tEncCfgParam);
            break;
        }
        case VIDEO_CODEC_STD_AVC:
        {
            iRet = zMspCom_OpenAVCEncoder(pInitParam, &tEncCfgParam);
            if(DRV_SUCCESS == iRet)
            {
                if((tEncCfgParam.tOutput.tHeaderInfo.bufSize.streamBufSize <= 0)
                    || (tEncCfgParam.tOutput.tHeaderInfo.pDataBuf.streamDataBuf== NULL)
                    || (tEncCfgParam.tOutput.tHeaderInfo.bufType != STREAM_TYPE))
                {
                    zOss_ASSERT(0);
                }

                pVideoEncHandle->uiHeaderLen = tEncCfgParam.tOutput.tHeaderInfo.bufSize.streamBufSize;
                pVideoEncHandle->pHeaderData = zOss_Malloc(pVideoEncHandle->uiHeaderLen);
                zOss_Memcpy(pVideoEncHandle->pHeaderData, 
                    (const void *)(tEncCfgParam.tOutput.tHeaderInfo.pDataBuf.streamDataBuf), 
                    tEncCfgParam.tOutput.tHeaderInfo.bufSize.streamBufSize);
            }
            break;
        }
        case VIDEO_CODEC_STD_MJPEG:
        {
            iRet = zMspCom_OpenMJPEGEncoder(pInitParam, &tEncCfgParam);
            break;
        }
        default:
        {
            iRet = -1;
            break;
        }
    }

    if(DRV_SUCCESS != iRet)
    {
        zOss_Free(pVideoEncHandle);
        return NULL;
    }

    pVideoEncHandle->uiVideoEncInst = tEncCfgParam.uiVideoInst;
    pVideoEncHandle->uiVideoFd      = pInitParam->uiVideoFd;

    return pVideoEncHandle;
}

/**
 * ƣ zMspCom_CloseVideoEncoder 
 *  رƵ
 * ˵ (IN)pHandle:      
 *   ֵ 
 * ˵ 
 */
VOID zMspCom_CloseVideoEncoder(T_VideoEncInstParam *pVideoEncHandle)
{
    if(NULL == pVideoEncHandle)
    {
        return;
    }
    
     /* رս */
    zDrv_Ioctl(pVideoEncHandle->uiVideoFd, IOCTL_VIDEO_ENCSTOP, &(pVideoEncHandle->uiVideoEncInst));

    if(NULL != pVideoEncHandle->pHeaderData && 0 != pVideoEncHandle->uiHeaderLen)
    {
        zOss_Free(pVideoEncHandle->pHeaderData);
    }
    zOss_Free(pVideoEncHandle);
}

/**
 * ƣ zMspCom_VideoEncode 
 *  Ƶݱ
 * ˵ (IN)pVideoEncHandle: 
 *            (IN)pVideoEncParam:  
 *   ֵ Ƿɹ
 * ˵ 
 */
SINT32 zMspCom_VideoEncode(T_VideoEncInstParam   *pVideoEncHandle,  
                           T_VideoEncParam *pVideoEncParam)
{
    SINT32               iRet = -1;
    T_ZDrvVideo_EncParam tEncParam = {0};   /* ṹ */
    T_ZDrvVideo_BufInfo  tStreamBuf;        /* Buffer */

    tEncParam.uiVideoInst = pVideoEncHandle->uiVideoEncInst;
    tEncParam.pDataIn     = pVideoEncParam->pDataIn;

    /* һ֡Ƶ */
    iRet = zDrv_Ioctl(pVideoEncHandle->uiVideoFd, IOCTL_VIDEO_ENCONEFRAME, &tEncParam);
    if(iRet != DRV_SUCCESS)
    {
        return MSP_COM_OP_ERROR;
    }

    /* BufferѾռ */
    if(pVideoEncParam->bIsBufferValid)
    {
        /* жϱǷBuffer֮ */
        if(tEncParam.uiLenOut > pVideoEncParam->uiLenOut)
        {
            /* ͷűռ */
            tStreamBuf.bufType                = STREAM_TYPE;
            tStreamBuf.pDataBuf.streamDataBuf = (PhyAddr *)(tEncParam.pDataOut);
            tStreamBuf.bufSize.streamBufSize  = tEncParam.uiLenOut;
            /* ͷŽBuffer */
            zDrv_Ioctl((UINT32)pVideoEncHandle->uiVideoFd, IOCTL_VIDEO_FREE_BUFFER, &tStreamBuf);

            return MSP_COM_OP_ERROR;
        }
    
        /* ݿûռ */
        zOss_Memcpy((PhyAddr *)(pVideoEncParam->pDataOut), tEncParam.pDataOut, tEncParam.uiLenOut);
        pVideoEncParam->uiLenOut = tEncParam.uiLenOut;
    }
    else
    {
        /* ΪBufferڴռ */
        pVideoEncParam->pDataOut = zOss_Malloc(tEncParam.uiLenOut);
        zOss_ASSERT(pVideoEncParam->pDataOut != NULL);

        /* ݿûռ */
        zOss_Memcpy((PhyAddr *)(pVideoEncParam->pDataOut), tEncParam.pDataOut, tEncParam.uiLenOut);
        pVideoEncParam->uiLenOut = tEncParam.uiLenOut;
    }
    
    tStreamBuf.bufType                = STREAM_TYPE;
    tStreamBuf.pDataBuf.streamDataBuf = (PhyAddr *)(tEncParam.pDataOut);
    tStreamBuf.bufSize.streamBufSize  = tEncParam.uiLenOut;

    /* ͷŽBuffer */
    zDrv_Ioctl((UINT32)pVideoEncHandle->uiVideoFd, IOCTL_VIDEO_FREE_BUFFER, &tStreamBuf);

    return MSP_COM_OP_SUCCESS;
}

/**
 * ƣ zMspCom_PostMsg 
 *  װ첽Ϣӿ
 * ˵ (IN) pThreadId  ߳ID
 *            (IN) uiMsgId    ϢID
 *   ֵ ɹMSP_COM_OP_SUCCESS
 * ˵ ӿڽ֧ϢʽϢ
 */
SINT32 zMspCom_PostMsg(ZOSS_THREAD_ID pThreadId, UINT32 uiMsgId)
{    
    UINT32   uiRet   = 0;
    UINT32   uiDummy = 0; 

    /* ע: ˴Ϊ˼ڴ䣬ϢַõջϵЧռ,
     *       ϢIDǷڵַдȥġ
     */
    uiRet = zOss_SendMsg(pThreadId, &uiDummy, uiMsgId, ZOSS_NO_WAIT);  
    if(uiRet != ZOSS_SUCCESS)
    {
        zMspCom_Print();
        return MSP_COM_OP_ERROR;
    }
    
    return MSP_COM_OP_SUCCESS;
}

/**
 * ƣ zMspCom_RecvMsg 
 *  Ϣ
 * ˵ (IN/OUT) pMsgId  ϢID
 *            (IN)     timeout յȴʱ
 *   ֵ ɹMSP_COM_OP_SUCCESS
 * ˵ ӿڽ֧ϢʽϢ
 */
SINT32 zMspCom_RecvMsg(UINT32 *pMsgId, UINT32  timeout)
{
    UINT32 *pMsg   = NULL;
    UINT32  uiRet  = ZOSS_ERROR;

    if(NULL == pMsgId)
    {
        return MSP_COM_OP_ERROR;
    }
    
    /* Ϣ */
    uiRet = zOss_RecvMsg((VOID **)&pMsg, pMsgId, timeout);
    if(uiRet != ZOSS_SUCCESS)
    {
        return MSP_COM_OP_ERROR;
    }
    
    return MSP_COM_OP_SUCCESS;
}

/**
 * ƣ zMspCom_DebugPrint 
 *  ӡӿ
 * ˵ (IN) 
 *   ֵ 
 * ˵ 
 */
VOID zMspCom_DebugPrint(UINT32 nModNo, UINT8 nPrintLevel, const CHAR *pFileName, UINT32 uiLine)
{
    zOss_Printf(nModNo, nPrintLevel, "***Msp Error: %s at line: %d***", pFileName, uiLine);
   
    return;
}

/**
 * ƣ zMspCom_VideoPlayRectModify 
 *  ƵͼƬʾʼ
 * ˵ (OUT) pRectDest   Ƶ
 *            (IN)  pRectSrc    ԴƵ
 *            (IN)  uiSrcWidth  ppuԴͼƬ
 *            (IN)  uiSrcHeight ppuԴͼƬ
 *   ֵ ɹVIDEO_OP_SUCCESS
 * ˵ ӲƣƵͼƬʾxy
 *            Ϊ16ı߱16ı 
 */
SINT32 zMspCom_VideoPlayRectModify(RECT_T *pRectDest,  RECT_T *pRectSrc, 
                                   UINT32  uiSrcWidth, UINT32  uiSrcHeight)
{
    SINT32    iRet        = 0;
    UINT32    uiTemp      = 0;
    UINT32    uiXoffset   = 0;     /* Xƫ */
    UINT32    uiYoffset   = 0;     /* Yƫ */
    UINT32    uiWidthTmp  = 0;
    UINT32    uiHeightTmp = 0;
    RECT_T    tTempRect   = {0,};  
    
    if(NULL == pRectDest || NULL == pRectSrc)
    {
        return MSP_COM_OP_ERROR;
    }
    
    /* xy꣬ȡԭֵӽ16 */
    uiTemp = pRectSrc->sx % COORDINATE_CALIBRATE;
    if(uiTemp != 0)
    {
        uiXoffset    = COORDINATE_CALIBRATE - uiTemp;
        tTempRect.sx = pRectSrc->sx + uiXoffset;
    }
    else
    {
        uiXoffset    = 0;
        tTempRect.sx = pRectSrc->sx;
    }

    uiTemp = pRectSrc->sy % COORDINATE_CALIBRATE;
    if(uiTemp != 0)
    {
        uiYoffset    = COORDINATE_CALIBRATE - uiTemp;
        tTempRect.sy = pRectSrc->sy + uiYoffset;
    }
    else
    {
        uiYoffset    = 0;
        tTempRect.sy = pRectSrc->sy;
    }

    /* ȡԭֵСӽ16 */
    if(pRectSrc->width <= uiXoffset)
    {
        return MSP_COM_OP_ERROR;
    }    
    uiWidthTmp  = pRectSrc->width  - uiXoffset;
    uiTemp      = uiWidthTmp % WIDTH_HEIGHT_CALIBRATE;
    if(uiTemp != 0)
    {
        tTempRect.width = uiWidthTmp - uiTemp;
    }
    else
    {
        tTempRect.width = uiWidthTmp;
    }

    /* ߶ȡԭֵСӽ16 */
    if(pRectSrc->height <= uiYoffset)
    {
        return MSP_COM_OP_ERROR;
    }
    uiHeightTmp = pRectSrc->height - uiYoffset;
    uiTemp      = uiHeightTmp % WIDTH_HEIGHT_CALIBRATE;
    if(uiTemp != 0)
    {
        tTempRect.height = uiHeightTmp - uiTemp;
    }
    else
    {
        tTempRect.height = uiHeightTmp;
    }

#if 0  
    /* ĿǰӲƣppu֧޵Ŀϣ
     * һ
     */
    /* ppuȡȣõӲֵ֧ */
    iRet = zMspCom_PpuFindBestValue(g_tWidthTable, sizeof(g_tWidthTable)/sizeof(g_tWidthTable[0]),
                                    uiSrcWidth,    tTempRect.width, &uiWidthTmp);
    if(iRet != MSP_COM_OP_SUCCESS)
    {
        return iRet;
    }
    
    /* ppu߶ȡ߶ȣõӲֵ֧߶ */
    iRet = zMspCom_PpuFindBestValue(g_tHeightTable, sizeof(g_tHeightTable)/sizeof(g_tHeightTable[0]),
                                    uiSrcHeight,    tTempRect.height, &uiHeightTmp);
    if(iRet != MSP_COM_OP_SUCCESS)
    {
        return iRet;
    }
 
    tTempRect.width  = uiWidthTmp;
    tTempRect.height = uiHeightTmp;
 #endif
 
    /* ʾ */
    if(tTempRect.sx + tTempRect.width     > g_uiScreenWidth
       || tTempRect.sy + tTempRect.height > g_uiScreenHeight)
    {
        return MSP_COM_OP_ERROR;
    }

    *pRectDest = tTempRect;
    
    return MSP_COM_OP_SUCCESS;
}

/**
 * ƣ zMspCom_NotifyUser 
 *  MSP֪ͨû쳣Ϣ
 * ˵ (IN) eModule  MSPģ־
 *            (IN) eMsg     MSP־
 *   ֵ 
 * ˵ 
 */
VOID zMspCom_NotifyUser(MSP_MODULE_ID eModule, MSP_OP_MSG eMsg)
{
    /* Ƶģ֪ͨ */
    if(MSP_MODULE_AUDIO == eModule)
    {
        switch(eMsg)
        {
            case MSP_PLAY_ERR:
            {
                #ifdef __KM1__
                zMmfSink_AudioChip_CallBack(AUDIO_INFO_PLAY_ERR);
                #endif
                
                #ifdef __KM2__
                if(zMsp_Notify_Error != NULL)
                {
                    zMsp_Notify_Error(MM_MODULE_AUDIO_DECODE, 0);
                }
                #endif
                
                break;
            }
            case MSP_PLAY_END:
            {
                #ifdef __KM1__
                zMmfSink_AudioChip_CallBack(AUDIO_INFO_PLAY_END);
                #endif
                
                #ifdef __KM2__
                if(zMsp_Notify_End != NULL)
                {
                    zMsp_Notify_End(MM_MODULE_AUDIO_DECODE);
                }
                #endif

                break;

            }

            default:
            {
                break;
            }
        }
    }
    else if(MSP_MODULE_VIDEO == eModule)  /* Ƶģ֪ͨ */

    {
        switch(eMsg)
        {
            case MSP_PLAY_ERR:
            {
                #ifdef __KM1__
                zMmfSink_VideoStopCallback();
                #endif
                
                #ifdef __KM2__                
                if(zMsp_Notify_Error != NULL)
                {
                    zMsp_Notify_Error(MM_MODULE_VIDEO_DECODE, 0);
                }
                #endif
                
                break;
            }
            case MSP_PLAY_END:
            {
                #ifdef __KM1__
                zMmfSink_VideoStopCallback();
                #endif
                
                #ifdef __KM2__
                if(zMsp_Notify_End != NULL)
                {
                    zMsp_Notify_End(MM_MODULE_VIDEO_DECODE);
                }
                #endif

                break;

            }

            default:
            {
                break;
            }
        }
    }  
    
    return;
}

/**
 * ƣ zMspCom_GetSampleRate 
 *  ȡƵ
 * ˵ (IN)  iSampleRate    
 *            (OUT) pSampleRate    Ƶ
 *   ֵ 
 * ˵ 
 */
VOID zMspCom_GetSampleRate(UINT32 iSampleRate, T_ZDrvAudio_SampleRate *pSampleRate)
{
    Zte_GetSampleRate(iSampleRate,pSampleRate);
}



/**************************************************************************
 *                      ֲʵ                                      *
 **************************************************************************/
/**
 * ƣ zMsp_Malloc 
 *  װmalloc
 * ˵ (IN)  size  ֽС
 *   ֵ Ŀռ
 * ˵ 
 */
static VOID *zMsp_Malloc(UInt32 size)
{
    return zOss_Malloc(size);
}

/**
 * ƣ zMsp_Free 
 *  ͷڴ
 * ˵ (IN)  mem_ptr   ͷŵڴ
 *   ֵ 
 * ˵ 
 */
static VOID zMsp_Free(VOID *mem_ptr)
{
    zOss_Free(mem_ptr);

    return;
}

/**
 * ƣ zMsp_LogFunc 
 *  ־ӡʵ
 * ˵ 
 *   ֵ 
 * ˵ ļģ
 */
void zMsp_LogFunc(const char *sLoggerName,int nDebugLevel,const char* sFile,int nLine,const char *sFormat,va_list vaList)
{
    return;
}

/**
 * ƣ Zte_GetAudioBufSize 
 *  ȡָƵʽӦС
 * ˵ (IN)  eMediaAType   ָƵʽ
 *   ֵ ָƵʽӦС
 * ˵ 
 */
static UINT32 Zte_GetAudioBufSize(EMediaAudioType eMediaAType)
{
    UINT32  uiAudioBufsize = DEFAULT_AUDIO_BUFFER_SIZE;
    
    switch(eMediaAType)
    {
        case ZM_CODEC_ID_AMR_NB:
        {
            uiAudioBufsize = 960;  /* ֡AMRPCM() */
            break;
        }

        case ZM_CODEC_ID_MP3:
        {
            uiAudioBufsize = uiMP3DecByteSize ; /* һ֡ */
            break;
        }

        case ZM_CODEC_ID_AAC:
        case ZM_CODEC_ID_AAC_PLUS:
        {
            uiAudioBufsize = AAC_DECODE_LEN * 2;   /* һ֡AAC(˫) */
            break;
        }
        case ZM_CODEC_ID_PCM_S16LE:
        {
            uiAudioBufsize = DEFAULT_AUDIO_BUFFER_SIZE * 2; /* PCMĬֳ */
            break;
        }

        default:
        {
            uiAudioBufsize = DEFAULT_AUDIO_BUFFER_SIZE;   
            break;
        }
    }

    return uiAudioBufsize;
}

/**
 * ƣ Zte_GetAudioMaxFramePcmLen 
 *  ȡһ֡Ƶռ
 * ˵ (IN)  eMediaAType   ָƵʽ
 *   ֵ һ֡ƵPCMݿռ
 * ˵ 
 */
static UINT32 Zte_GetAudioMaxFramePcmLen(EMediaAudioType eMediaAType)
{
    UINT32  uiMaxLen = uiAMRDecByteSize;
    
    switch(eMediaAType)
    {
        case ZM_CODEC_ID_AMR_NB:
        {
            uiMaxLen = uiAMRDecByteSize;  /* AMRPCMΪͨ */
            break;
        }

        case ZM_CODEC_ID_MP3:
        {
            uiMaxLen = uiMP3DecByteSize;  /* MP3PCMݰ˫ */
            break;            
        }

        case ZM_CODEC_ID_AAC:
        case ZM_CODEC_ID_AAC_PLUS:
        {
            uiMaxLen = uiAACDecByteSize;  /* AACPCMݰ˫ */
            break;
        }

        case ZM_CODEC_ID_PCM_S16LE:
        {
            uiMaxLen = uiPCMDecByteSize;  /* wavļеPCMݰ˫ */
            break;
        }
        
        default:
        {
            uiMaxLen = uiAMRDecByteSize;   
            break;
        }
    }

    return uiMaxLen;
}

/**
 * ƣ Zte_AMRDecoderOpen 
 *  AMRƵ
 * ˵ (IN)  buffer       AMRݻַ
 *            (IN)  uiLen        AMRݳ
 *            (OUT) pChannelMode ģʽָ
 *            (OUT) pSampleRate  pcmݲָ
 *   ֵ ʧܷNULL
 * ˵ 
 */
static DecHandle Zte_AMRDecoderOpen(UINT8                  *buffer, 
                                    UINT32                  uiLen, 
                                    T_ZDrvAudio_Channel    *pChannelMode,
                                    T_ZDrvAudio_SampleRate *pSampleRate)
{
    SINT32             iRet            = -2;
    T_AMRDecParam     *m_NBdecodeParam = NULL;

    m_NBdecodeParam = (T_AMRDecParam *)zOss_Malloc(sizeof(T_AMRDecParam));
    if(NULL == m_NBdecodeParam)
    {         
        return NULL;
    }
    zOss_Memset(m_NBdecodeParam, 0, sizeof(T_AMRDecParam));
    
    /* ʼݿռ*/
    m_NBdecodeParam->pDecChannelStAddr = zOss_Malloc(AMR_DEC_STATIC_SIZE);
    if(NULL == m_NBdecodeParam->pDecChannelStAddr)
    {
        zOss_Free(m_NBdecodeParam);
    
        return NULL;
    }

    m_NBdecodeParam->wChnSize           = AMR_DEC_STATIC_SIZE;
    m_NBdecodeParam->wParamSize         = sizeof(T_AMRDecParam);
    m_NBdecodeParam->cFQI               = 1;             
    m_NBdecodeParam->cBadFrameFlag      = 0;
    m_NBdecodeParam->cPackFormat        = 0;   /* ݰʽ 0Ϊʽ11Ϊʽ2 */
    m_NBdecodeParam->cDecMode           = 7;
    m_NBdecodeParam->cGlobalCheck       = 0;

    iRet = Zte_AMR_Decoder_Init(m_NBdecodeParam);
    if (0 != iRet)
    {
        zOss_Free(m_NBdecodeParam->pDecChannelStAddr);
        zOss_Free(m_NBdecodeParam);
    
        return NULL;
    }

    /* AMR㷨̶8K */
    *pChannelMode = AUDIO_MONO_CHANNEL;
    *pSampleRate  = AUDIO_RATE_8_KHZ;
    
    return (DecHandle)m_NBdecodeParam;
}

/**
 * ƣ Zte_MP3DecoderOpen 
 *  MP3Ƶ
 * ˵ (IN)  buffer       mp3ݻַ
 *            (IN)  uiLen        mp3ݳ
 *            (OUT) pChannelMode ģʽָ
 *            (OUT) pSampleRate  pcmݲָ
 *   ֵ ʧܷNULL
 * ˵ 
 */
static DecHandle Zte_MP3DecoderOpen(UINT8                  *buffer, 
                                    UINT32                  uiLen, 
                                    T_ZDrvAudio_Channel    *pChannelMode,
                                    T_ZDrvAudio_SampleRate *pSampleRate)
{
    SINT32          iRet             = -1;    
    short          *data             = NULL;
    unsigned        int OutSize      = MP3_DECODE_LEN_WORD;  /* صǰ */
    unsigned        int pwDecLen     = 0;                    /* صǰ֡֡     */
    T_MP3DecParam  *m_MP3decodeParam = NULL;

    if(!s_bMp3DecoderInit)
    {
    m_MP3decodeParam = (T_MP3DecParam *)zOss_Malloc(sizeof(T_MP3DecParam));
    if(NULL == m_MP3decodeParam)
    {         
        return NULL;
    }
    zOss_Memset(m_MP3decodeParam, 0, sizeof(T_MP3DecParam));
        s_pAudioDecHandle = (VOID *)m_MP3decodeParam;

    iRet = Zte_MP3_Decoder_Init(m_MP3decodeParam, MP3D_DECST_LEN, MP3D_DECPARAM_LEN);
    if (0 != iRet)
    {    
        zOss_Free(m_MP3decodeParam);
        
        return NULL;
    }
        s_bMp3DecoderInit = TRUE;
    }

    m_MP3decodeParam = (T_MP3DecParam *)s_pAudioDecHandle;
    
    data = (short *)zOss_Malloc(MP3_DECODE_LEN_WORD * sizeof(short));
    if(NULL == data)
    {
        zOss_Free(m_MP3decodeParam);
        
        return NULL;
    }

    /* ʼ */
    iRet = Zte_MP3_Decoder_Proc ((unsigned char*) buffer, uiLen,  data, &OutSize, &pwDecLen, m_MP3decodeParam);
    if (iRet < 0)
    {
#if 0
        zOss_Free(data);
        zOss_Printf(1, 1, "Init Mp3 Decoder error, Next Time to Continue!");
        return NULL;
#endif
        iRet = Zte_MP3_Decoder_Proc ((unsigned char*) buffer, uiLen,  data, &OutSize, &pwDecLen, m_MP3decodeParam);
        if(iRet < 0)
        {
            zOss_Free(data);
            return NULL;
        }

    }

    /* ȡģʽ */
    Zte_GetOutChannelMode(ZM_CODEC_ID_MP3, m_MP3decodeParam->channels, pChannelMode);
    
    /* ȡ */
    Zte_GetSampleRate(m_MP3decodeParam->samplerate, pSampleRate);
    
    zOss_Free(data);
    
    return (DecHandle)(m_MP3decodeParam);
}

/**
 * ƣ Zte_AACDecoderOpen 
 *  AACƵ
 * ˵ (IN)  buffer       AACݻַ
 *            (IN)  uiLen        AACݳ
 *            (IN)  pAacParam    AAC
 *            (OUT) pChannelMode ģʽָ
 *            (OUT) pSampleRate  pcmݲָ
 *   ֵ ʧܷNULL
 * ˵ 
 */
static DecHandle Zte_AACDecoderOpen(UINT8                  *buffer, 
                                    UINT32                  uiLen,
                                    T_Audio_AacParam       *pAacParam,                                 
                                    T_ZDrvAudio_Channel    *pChannelMode,
                                    T_ZDrvAudio_SampleRate *pSampleRate)
{
    SINT32          iRet            = -1;    
    short          *pOutData        = NULL;
    short           OutSize         = AAC_DECODE_LEN;       /* صǰ */
    T_AACDecParam  *pAACdecodeParam = NULL;

    /* AACҪڴ */
    pAACdecodeParam = (T_AACDecParam *)zOss_Malloc(sizeof(T_AACDecParam));
    if(NULL == pAACdecodeParam)
    {         
        return NULL;
    }
    zOss_Memset(pAACdecodeParam, 0, sizeof(T_AACDecParam));

    pAACdecodeParam->pDecChannelStAddr = zOss_Malloc(HisDatLenth);
    if(NULL == pAACdecodeParam->pDecChannelStAddr)
    {
        zOss_Free(pAACdecodeParam);

        return NULL;
    }
    
    pAACdecodeParam->wChnSize = HisDatLenth;
    pAACdecodeParam->wParamSize = sizeof(T_AACDecParam);

    /* ʼݿռ */
    if(NULL != pAacParam->pDecConfig)
    {
        pAACdecodeParam->iSampleRate     = -1;
        pAACdecodeParam->oSampleRate     = -1;
        //pAACdecodeParam->eSamplingRate   = 8000;
        //pAACdecodeParam->frameOK         = 1;
        pAACdecodeParam->oChannelNum     = 2;
        pAACdecodeParam->AudioObjectType = (AUDIO_OBJECT_TYPE)(*(pAacParam->pDecConfig));
    }
    else
    {
        /* ʡչҪȷ޸ */
        pAACdecodeParam->iSampleRate     = pAacParam->u32SampleRate;
        pAACdecodeParam->oSampleRate     = 8000;
        //pAACdecodeParam->eSamplingRate   = 8000;
        //pAACdecodeParam->frameOK         = 1;
        pAACdecodeParam->oChannelNum     = 2;
        pAACdecodeParam->AudioObjectType = (AUDIO_OBJECT_TYPE)pAacParam->u32Profile_ObjectType;
    }

    /* ʼһͨAAC봦 */
    iRet = Zte_AAC_Decoder_Init(pAacParam->pDecConfig, pAacParam->iConfigLen, pAACdecodeParam);
    if (0 != iRet)
    {   
        zOss_Free(pAACdecodeParam->pDecChannelStAddr);
        zOss_Free(pAACdecodeParam);
        
        return NULL;
    }

    /* ռ䣬ﰴ˫Ҫڴ */
    pOutData = (short *)zOss_Malloc(AAC_DECODE_LEN * sizeof(short));
    if(NULL == pOutData)
    {
        zOss_Free(pAACdecodeParam->pDecChannelStAddr);
        zOss_Free(pAACdecodeParam);
        
        return NULL;
    }

    /* ʼ */
    iRet = Zte_AAC_Decoder_Proc ((unsigned char*) buffer,
                                  (short)uiLen,
                                  pOutData,
                                  &OutSize,
                                  pAACdecodeParam);
    if (iRet < 0)
    {
        zOss_Free(pOutData);
        zOss_Free(pAACdecodeParam->pDecChannelStAddr);
        zOss_Free(pAACdecodeParam);
        
        return NULL;
    }

    /* ͷŽݵԪ */
    zOss_Free(pOutData);

    /* ȡģʽ */
    Zte_GetOutChannelMode(ZM_CODEC_ID_AAC, pAACdecodeParam->oChannelNum, pChannelMode);
    
    /* ȡ */
    Zte_GetSampleRate(pAACdecodeParam->oSampleRate, pSampleRate);
    
    return (DecHandle)(pAACdecodeParam);
}

/**
 * ƣ Zte_GetChannelMode 
 *  ȡƵģʽ
 * ˵ (IN)  iChannelMode    ģʽ
 *            (OUT) pChannelMode    Ƶģʽ
 *   ֵ ʧܷNULL
 * ˵ 
 */
static void Zte_GetOutChannelMode(EMediaAudioType eMediaAType, UINT32 iChannelMode, T_ZDrvAudio_Channel *pChannelMode)
{   
    if(NULL == pChannelMode)
    {
        return;
    }
    
    switch(eMediaAType)
    {
        case ZM_CODEC_ID_AAC:
        case ZM_CODEC_ID_AAC_PLUS:
        {
            if (1 == iChannelMode)
            {
                *pChannelMode = AUDIO_MONO_CHANNEL;
            }
            else
            {
                *pChannelMode = AUDIO_DUAL_CHANNEL;
            }
            break;
        }
        case ZM_CODEC_ID_MP3:
        {
            if (1 == iChannelMode)
            {
                *pChannelMode = AUDIO_MONO_CHANNEL;
            }
            else
            {
                *pChannelMode = AUDIO_DUAL_CHANNEL;
            }            
            break;
        }
        default:
        {
            break;
        }

    } 
    return;
}

/**
 * ƣ Zte_GetSampleRate 
 *  ȡƵ
 * ˵ (IN)  iSampleRate    
 *            (OUT) pSampleRate    Ƶ
 *   ֵ ʧܷNULL
 * ˵ 
 */
static void Zte_GetSampleRate(UINT32 iSampleRate, T_ZDrvAudio_SampleRate *pSampleRate)
{
    if(NULL == pSampleRate)
    {
        return;
    }
    
    if (8000 == iSampleRate)
    {
        *pSampleRate = AUDIO_RATE_8_KHZ;
    }
    else if (11025 == iSampleRate)
    {
        *pSampleRate = AUDIO_RATE_11_025_KHZ;
    }
    else if (12000 == iSampleRate)
    {
        *pSampleRate = AUDIO_RATE_12_KHZ;
    }
    else if (16000 == iSampleRate)
    {
        *pSampleRate = AUDIO_RATE_16_KHZ;
    }
    else if (22050 == iSampleRate)
    {
        *pSampleRate = AUDIO_RATE_22_050_KHZ;
    }
    else if (24000 == iSampleRate)
    {
        *pSampleRate = AUDIO_RATE_24_KHZ;
    }
    else if (32000 == iSampleRate)
    {
        *pSampleRate = AUDIO_RATE_32_KHZ;
    }
    else if (44100 == iSampleRate)
    {
        *pSampleRate = AUDIO_RATE_44_1_KHZ;
    }
    else if (48000 == iSampleRate)
    {
        *pSampleRate = AUDIO_RATE_48_KHZ;
    }
    else if (64000 == iSampleRate)
    {
        *pSampleRate = AUDIO_RATE_64_KHZ;
    }
    else if (96000 == iSampleRate)
    {
        *pSampleRate = AUDIO_RATE_96_KHZ;
    }
    else
    {
        *pSampleRate = DEFAULT_AUDIO_SAMPLE_RATE;
    }

    return;
}

/**
 * ƣ Zte_AMRDecodeAudio 
 *  AMRʽ
 * ˵ (IN) pHandle      
 *            (IN) pOutUnit     һ֡Ƶ
 *            (IN) pPhyBuf      ַ
 *            (IN) uiBufLen     
 *   ֵ ʵд볤(λֽ)
 * ˵ 
 */
static UINT32 Zte_AMRDecodeAudio(DecHandle  pHandle,  T_ZMFOutPutUnit *pOutUnit, 
                                 VOID      *pPhyBuf,  UINT32           uiBufLen)
{
    SInt16          retValue        = -1;    
    SInt16          Outsize         = AMR_NB_DECODE_LEN;     /* ֽת */
    T_AMRDecParam  *m_NBdecodeParam = NULL;

    if(uiBufLen < uiAMRDecByteSize)
    {
        zOss_Memset(pPhyBuf, 0, uiBufLen);
        return uiBufLen;
    }

    /* ת */
    m_NBdecodeParam = (T_AMRDecParam *)pHandle;

    m_NBdecodeParam->cFrmTypeIndex = pOutUnit->uFrameUnit.t_AMRFrameUnit.u8FrameType;
    m_NBdecodeParam->cBadFrameFlag = pOutUnit->uFrameUnit.t_AMRFrameUnit.cFrameQuality;

    if (m_NBdecodeParam->cFrmTypeIndex >= 0 
        && m_NBdecodeParam->cFrmTypeIndex <= 7)
    {
        m_NBdecodeParam->cDecMode = m_NBdecodeParam->cFrmTypeIndex;
    }    

    /* ƵAMR */
    retValue = Zte_AMR_Decoder_Proc(pOutUnit->pPacket, (SInt16)(pOutUnit->u32Len), pPhyBuf, &Outsize, m_NBdecodeParam);
    if (retValue != 0)
    {
        zOss_Memset(pPhyBuf, 0, uiAMRDecByteSize); 
        
        return uiAMRDecByteSize;
    }

    /* ֵֽڵת */
    return (UINT32)Outsize * 2;
}

/**
 * ƣ Zte_MP3DecodeAudio 
 *  MP3ʽ
 * ˵ (IN) pHandle      
 *            (IN) pOutUnit     һ֡Ƶ
 *            (IN) pPhyBuf      ַ
 *            (IN) uiBufLen         
 *   ֵ ʵд볤(λֽ)
 * ˵ 
 */
static UINT32 Zte_MP3DecodeAudio(DecHandle  pHandle,  T_ZMFOutPutUnit *pOutUnit, 
                                 VOID      *pPhyBuf,  UINT32           uiBufLen)
{
    int             retValue          = -1; 
    unsigned int    Outsize           = MP3_DECODE_LEN_WORD; /* ֽת     */
    unsigned int    DecLen            = 0;                   /* صǰ֡֡ */
    T_MP3DecParam  *m_Mp3decodeParam  = NULL;

    /* ǷMP3˫һ֡ռС */
    if (uiBufLen < uiMP3DecByteSize)
    {
        zOss_Memset(pPhyBuf, 0, uiBufLen);
        return uiBufLen;
    }

    /* ת */
    m_Mp3decodeParam = (T_MP3DecParam *)pHandle;

    /* ƵMP3 */
    retValue = Zte_MP3_Decoder_Proc(pOutUnit->pPacket, pOutUnit->u32Len, 
                                    (short *)pPhyBuf, &Outsize, &DecLen, m_Mp3decodeParam);
    if (retValue < 0)
    {
        zOss_Memset(pPhyBuf, 0, uiMP3DecByteSize);
        return 0;
    }

    /* תΪֽ */
    return Outsize * 2;
}

/**
 * ƣ Zte_AACDecodeAudio 
 *  AACʽ
 * ˵ (IN) pHandle      
 *            (IN) pOutUnit     һ֡Ƶ
 *            (IN) pPhyBuf      ַ
 *            (IN) uiBufLen         
 *   ֵ ʵд볤(λֽ)
 * ˵ 
 */
static UINT32 Zte_AACDecodeAudio(DecHandle  pHandle,  T_ZMFOutPutUnit *pOutUnit, 
                                 VOID      *pPhyBuf,  UINT32           uiBufLen)
{
    int             retValue        = -1; 
    short           Outsize         = AAC_DECODE_LEN; /* ֽת     */
    T_AACDecParam  *pAACdecodeParam = NULL;

    zOss_Memset(pPhyBuf, 0, uiBufLen);

    /* ת */
    pAACdecodeParam = (T_AACDecParam *)pHandle;

    /* ƵAAC */
    retValue = Zte_AAC_Decoder_Proc(pOutUnit->pPacket, (SInt16)pOutUnit->u32Len, 
                                    pPhyBuf,  &Outsize, pAACdecodeParam);
    if (retValue < 0)
    {
        zOss_Memset(pPhyBuf, 0, uiBufLen);
        return 0;
    }

    /* תΪֽ */
    return (UINT32)(Outsize * 2);
}

/**
 * ƣ Zte_AMRDecoderClose 
 *  رAMRƵ
 * ˵ (IN) pHandle:  Zte_AMRDecoderOpenõĽ
 *   ֵ 
 * ˵ 
 */
static VOID Zte_AMRDecoderClose(DecHandle pHandle)
{
    T_AMRDecParam  *m_NBdecodeParam = NULL;

    if(NULL == pHandle)
    {
        return;
    }

    m_NBdecodeParam = (T_AMRDecParam *)pHandle;

    zOss_Free(m_NBdecodeParam->pDecChannelStAddr);
    zOss_Free(m_NBdecodeParam);

    return;
}

/**
 * ƣ Zte_MP3DecoderClose 
 *  رMP3Ƶ
 * ˵ (IN) pHandle:  Zte_MP3DecoderOpenõĽ
 *   ֵ 
 * ˵ 
 */
static VOID Zte_MP3DecoderClose(DecHandle pHandle)
{
    if(NULL == pHandle)
    {
        return;
    }

    zOss_Free(pHandle);
    s_bMp3DecoderInit = FALSE;
    s_pAudioDecHandle = NULL;
    return;
}

/**
 * ƣ Zte_AACDecoderClose 
 *  رAMRƵ
 * ˵ (IN) pHandle:  Zte_AACDecoderOpenõĽ
 *   ֵ 
 * ˵ 
 */
static VOID Zte_AACDecoderClose(DecHandle pHandle)
{
    T_AACDecParam  *pAACdecodeParam = NULL;

    if(NULL == pHandle)
    {
        return;
    }

    pAACdecodeParam = (T_AACDecParam *)pHandle;

    zOss_Free(pAACdecodeParam->pDecChannelStAddr);
    zOss_Free(pAACdecodeParam);

    return;
}

/**
 * ƣ Zte_AMREncoderOpen 
 *  AMR
 * ˵ (OUT)pFrameLen: ʱһñPCMݳ(λ:)
 *   ֵ 
 * ˵ 
 */
static EncHandle Zte_AMREncoderOpen(UINT32  *pFrameLen)
{
    SINT32          iRet      = -1;
    T_AMREncParam  *pEncParam = NULL;

    if(NULL == pFrameLen)
    {
        return NULL;
    }

    pEncParam = (T_AMREncParam *)zOss_Malloc(sizeof(T_AMREncParam));
    if(NULL == pEncParam)
    {
        return NULL;
    }
    zOss_Memset(pEncParam, 0, sizeof(T_AMREncParam));
    
    pEncParam->pEncChannelStAddr = zOss_Malloc(AMR_ENC_STATIC_SIZE);
    if(NULL == pEncParam->pEncChannelStAddr)
    {
        zOss_Free(pEncParam);

        return NULL;
    }
	
    pEncParam->cEncMode     = AMR_12_2;
    pEncParam->cUseVx       = 1;
    pEncParam->cPackFormat  = 0;
    pEncParam->cTxType      = 0;
    pEncParam->wChnSize     = AMR_ENC_STATIC_SIZE;
    pEncParam->wParamSize   = sizeof(T_AMREncParam);
    pEncParam->cGlobalCheck = 1;

    iRet = Zte_AMR_Encoder_Init(pEncParam);
    if (iRet != 0)
    {
        zOss_Free(pEncParam->pEncChannelStAddr);
        zOss_Free(pEncParam);
        return NULL;
    }

    /* һ֡AMRҪ160ֳȵPCM */
    *pFrameLen = AMR_NB_DECODE_LEN;   

    return (EncHandle)pEncParam;    
}

static VOID Zte_GetRealSampleRate(T_ZDrvAudio_SampleRate  tSampleRate, UINT32 *pSampleRate)
{
    if(NULL == pSampleRate)
    {
        return;
    }

    switch(tSampleRate)
    {
        case AUDIO_RATE_8_KHZ:
        {
            *pSampleRate = 8000;
            break;
        }
        case AUDIO_RATE_11_025_KHZ:
        {
            *pSampleRate = 11025;
            break;
        }
        case AUDIO_RATE_12_KHZ:
        {
            *pSampleRate = 12000;
            break;
        }
        case AUDIO_RATE_16_KHZ:
        {
            *pSampleRate = 16000;
            break;
        }
        case AUDIO_RATE_22_050_KHZ:
        {
            *pSampleRate = 22050;
            break;
        }
        case AUDIO_RATE_24_KHZ:
        {
            *pSampleRate = 24000;
            break;
        }
        case AUDIO_RATE_32_KHZ:
        {
            *pSampleRate = 32000;
            break;
        }
        case AUDIO_RATE_44_1_KHZ:
        {
            *pSampleRate = 44100;
            break;
        }
        case AUDIO_RATE_48_KHZ:
        {
            *pSampleRate = 48000;
            break;
        }
        case AUDIO_RATE_64_KHZ:
        {
            *pSampleRate = 64000;
            break;
        }  
        case AUDIO_RATE_96_KHZ:
        {
            *pSampleRate = 96000;
            break;
        } 
        default:
        {
            zOss_ASSERT(0);
            break;
        }
    }
    
    return;
}

/**
 * ƣ Zte_MP3EncoderOpen 
 *  MP3
 * ˵ (IN)tChannelMode: ģʽ
 *            (IN)tSampleRate:  
 *            (OUT)pFrameLen:   ʱһñPCMݳ
 *   ֵ 
 * ˵ 
 */
static EncHandle Zte_MP3EncoderOpen(T_MP3AddEnCoderData *pAddData, UINT32  *pFrameLen)
{
    SINT32          iRet      = -1;
    T_MP3EncParam  *pEncParam = NULL;

    if(NULL == pAddData || NULL == pFrameLen)
    {
        return NULL;
    }

    pEncParam = (T_MP3EncParam *)zOss_Malloc(sizeof(T_MP3EncParam));
    if(NULL == pEncParam)
    {
        return NULL;
    }
    zOss_Memset(pEncParam, 0, sizeof(T_MP3EncParam));
    
    pEncParam->pEncChannelStAddr = zOss_Malloc(MP3_ENC_STATICE_SIZE);
    if(NULL == pEncParam->pEncChannelStAddr)
    {
        zOss_Free(pEncParam);

        return NULL;
    }

    pEncParam->wChnSize     = MP3_ENC_STATICE_SIZE;
    pEncParam->wParamSize   = sizeof(T_MP3EncParam);
    pEncParam->iSampleRate  = pAddData->iSampleRate;
    pEncParam->iFramesize   = 0;
    pEncParam->wBitrate     = pAddData->iBitrate;
    pEncParam->wEP          = 0;
    pEncParam->wCopyright   = 0;
    pEncParam->wOriginal    = 1;
    pEncParam->wChannel_in  = pAddData->iChannelIn;    
    pEncParam->wChannel_out = pAddData->iChannelOut;
    
    iRet = Zte_MP3_Encoder_Init(pEncParam);
    if (iRet != MP3_ENC_SUCCESS)
    {
        zOss_Free(pEncParam->pEncChannelStAddr);
        zOss_Free(pEncParam);
        return NULL;
    }

    /* һ֡AMRҪ160ֳȵPCM */
    *pFrameLen = pEncParam->iFramesize;   

    return (EncHandle)pEncParam;        
}

/**
 * ƣ Zte_AMRAudioEncode 
 *  AMR
 * ˵ (IN)pHandle:      
 *            (IN)pRawData:     ԭʼ
 *            (IN)uiDataLen:    pRawDataĳȣλΪֽ
 *            (OUT)pOutDataLen: ݵĳ
 *   ֵ ʵʱݳȣʧܷNULL
 * ˵ 
 */
static UINT8 *Zte_AMRAudioEncode(EncHandle  pHandle,   VOID   *pRawData, 
                                 UINT32     uiDataLen, UINT32 *pOutDataLen)
{
    UINT8          *pDataOut    = NULL;
    SINT16          iInDataLen  = 0; 
    SINT16          iOutDataLen = MAX_AMR_FRAME_LEN;
    SINT32          iRet        = -1;
    T_AMREncParam  *pEncParam   = NULL;

    pDataOut = zOss_Malloc(iOutDataLen);
    if(NULL == pDataOut)
    {
        return NULL;
    }
    zOss_Memset(pDataOut, 0, iOutDataLen);
    pEncParam = (T_AMREncParam *)pHandle;
    
    /* ǰݳȡռ䳤ȵλֽת */
    iInDataLen = (SINT16)(uiDataLen >> 1);    

    iRet = Zte_AMR_Encoder_Proc((short *)pRawData, (short)iInDataLen,
                                 pDataOut, (short *)&iOutDataLen, pEncParam);
    if(iRet != 0)
    {
        zOss_Free(pDataOut);
        
        return NULL;
    }

    /* ݳȣAMR˲Ĭֽڵλ */
    *pOutDataLen = iOutDataLen;
    
    return pDataOut;    
}

/**
 * ƣ Zte_MP3AudioEncode 
 *  MP3
 * ˵ (IN)pHandle:      
 *            (IN)pRawData:     ԭʼ
 *            (IN)uiDataLen:    pRawDataĳȣλΪֽ
 *            (OUT)pOutDataLen: ݵĳ
 *   ֵ ʵʱݳȣʧܷNULL
 * ˵ 
 */
static UINT8 *Zte_MP3AudioEncode(EncHandle  pHandle,   VOID   *pRawData, 
                                 UINT32     uiDataLen, UINT32 *pOutDataLen)
{
    UINT8          *pDataOut    = NULL;
    SINT16          iInDataLen  = 0; 
    SINT16          iOutDataLen = MP3_ENC_OUTBUF_LEN;
    SINT32          iRet        = -1;
    T_MP3EncParam  *pEncParam   = NULL;

    pDataOut = zOss_Malloc(iOutDataLen);
    if(NULL == pDataOut)
    {
        return NULL;
    }
    zOss_Memset(pDataOut, 0, iOutDataLen);
    pEncParam = (T_MP3EncParam *)pHandle;
    
    /* ǰݳȡռ䳤ȵλֽת */
    iInDataLen = (SINT16)(uiDataLen >> 1);    

    iRet = Zte_MP3_Encoder_Proc((short *)pRawData, (short)iInDataLen,
                                 pDataOut, (short *)&iOutDataLen, pEncParam);
    if(iRet != MP3_ENC_SUCCESS)
    {
        zOss_Free(pDataOut);
        return NULL;
    }

    /* ݳȣMP3Ĭֽڵλ */
    *pOutDataLen = iOutDataLen;
    
    return pDataOut;    
}

/**
 * ƣ Zte_AMREncoderClose 
 *  AMRر
 * ˵ (IN)pHandle:  
 *   ֵ 
 * ˵ 
 */
static VOID Zte_AMREncoderClose(EncHandle pHandle)
{
    T_AMREncParam  *pEncParam = NULL;

    if(NULL == pHandle)
    {
        return;
    }

    pEncParam = (T_AMREncParam *)pHandle;

    zOss_Free(pEncParam->pEncChannelStAddr);
    zOss_Free(pEncParam);

    return;
}

/**
 * ƣ Zte_MP3EncoderClose 
 *  MP3ر
 * ˵ (IN)pHandle:  
 *   ֵ 
 * ˵ 
 */
static VOID Zte_MP3EncoderClose(EncHandle pHandle)
{
    T_MP3EncParam  *pEncParam = NULL;

    if(NULL == pHandle)
    {
        return;
    }

    pEncParam = (T_MP3EncParam *)pHandle;

    zOss_Free(pEncParam->pEncChannelStAddr);
    zOss_Free(pEncParam);

    return;
}


/**
 * ƣ zMspCom_PpuFindBestValue 
 *  Դֵڴֵõֵ
 * ˵ (IN)  pValTable   Դֵƥ
 *            (IN)  uiTableLen  pValTable
 *            (IN)  uiSrcVal    Դֵ
 *            (IN)  uiExpVal    ڴֵ
 *            (OUT) pDestVal    ֵ
 *   ֵ ɹVIDEO_OP_SUCCESS
 * ˵ ӲƣPPUƵͼƬֻضֵ
 */
static SINT32 zMspCom_PpuFindBestValue(T_InOutValTable *pValTable, UINT32   uiTableLen,
                                       UINT32           uiSrcVal,  UINT32   uiExpVal,
                                       UINT32          *pDestVal)
{
    BOOL     bFind = FALSE;
    UINT32   i     = 0;
    UINT32   j     = 0;
     
    if(NULL == pValTable || NULL == pDestVal)
    {
        return MSP_COM_OP_ERROR;
    }

    for(i = 0; i < uiTableLen; i++)
    {
        /* λĳԴֵ */
        if(uiSrcVal == pValTable[i].uiInput)
        {
            /* Դֵֵ */
            for(j = 0; j < pValTable[i].uiAarryLen; j++)
            {
                if(uiExpVal >= pValTable[i].pOutAarry[j])
                {
                    bFind = TRUE;

                    /* Դֵһֵ */
                    if(j == pValTable[i].uiAarryLen - 1)
                    {
                        *pDestVal = pValTable[i].pOutAarry[j];

                        return MSP_COM_OP_SUCCESS;
                    }
                }
                else
                {
                    if(TRUE == bFind)
                    {
                        /* ΪbFindΪTRUEj϶0 */
                        *pDestVal = pValTable[i].pOutAarry[j - 1];

                        return MSP_COM_OP_SUCCESS;                        
                    }
                    else
                    {
                        return MSP_COM_OP_ERROR;
                    }
                }
            }
        }
    }

    return MSP_COM_OP_ERROR;    
}

