/*******************************************************************************
* Ȩ (C)2014, ͨѶɷ޹˾
* 
* ļ:     linux_kernel.c
* ļʶ:     linux_kernel.c
* ժҪ:     linuxϵͳOSS֧Ųģ
* 
* ޸        汾      ޸ı        ޸          ޸
* ------------------------------------------------------------------------------
* 2014/07/11      V1.0        Create                    
* 
*******************************************************************************/

/*******************************************************************************
*                                   ͷļ                                     *
*******************************************************************************/
#include "oss_api.h"
#include "osa.h"
#include "sup.h"
#include "linux_typedef.h"
#include "linux_stat.h"
#include <linux/sched.h>
#if (LINUX_VERSION_CODE >= KERNEL_VERSION(3,14,0))
#include <linux/sched/rt.h>
#endif
#include <linux/kthread.h>
#include <linux/jiffies.h>
#include <linux/delay.h>
#include <linux/spinlock.h>
#include <linux/semaphore.h>
#include <linux/mutex.h>
#include <linux/completion.h>
#include <linux/printk.h>
#include <linux/notifier.h>
#include <linux/profile.h>
#include <linux/perf_event.h>
#include <linux/sort.h>
#include <linux/pid.h>
#if (LINUX_VERSION_CODE < KERNEL_VERSION(3,14,0))
#include "rtmutex_common.h"
#else
#include "locking/rtmutex_common.h"
#endif
#include "sched/sched.h"
#include <asm/cacheflush.h>
#include <asm/asm-offsets.h>
#include <asm/mach/map.h>

#ifndef CONFIG_PROFILING
# error "linux thread exit need CONFIG_PROFILING == 1!"
#endif

#ifdef __cplusplus
extern "C" 
{
#endif

/*******************************************************************************
*                                ⲿ                                  *
*******************************************************************************/
extern UINT64 gTimer_CurTime;
extern struct task_struct *kthreadd_task;

/*******************************************************************************
*                                ⲿ                                  *
*******************************************************************************/
extern VOID Osa_SysErrHndInit(VOID);
extern void tos_cache_clean_all(void);
extern SINT32 Hal_GetArmCoreFreq(UINT32* feq);
extern UINT32 Osa_HwTimeRead(VOID);
void linux_thread_sched_stat(int type);

/*******************************************************************************
*                                   궨                                     *
*******************************************************************************/
#define THREAD_MSG_HEAD_SIZE        (sizeof(T_THREAD_MSG_HEAD))
#define THREAD_MSG_HEAD(buf)        ((T_THREAD_MSG_HEAD *)((UINT8 *)(buf) - THREAD_MSG_HEAD_SIZE))
#define THREAD_MSG_BUF(head)        ((VOID *)((UINT8 *)(head) + THREAD_MSG_HEAD_SIZE))
#define THREAD_MSG_SIZE(size)       ((size) + THREAD_MSG_HEAD_SIZE)
#define THREAD_MSG_MAGIC            0x3A3A3A3A
#define THREAD_MSG_HOOK_TYPE_MAX    ZOSS_SETHOOKFLAG_INTER
#define THREAD_MSG_HOOK_DIRE_MAX    ZOSS_MSGDIRE_INOUT

#define LINUX_IRQ_THREAD_PRIORITY   (MAX_USER_RT_PRIO/2)

//#define LINUX_THREAD_MSG_STAT
#define LINUX_THREAD_MSG_COMPLETION     0
#define LINUX_THREAD_MSG_SEMAPHORE      1
#define LINUX_THREAD_MSG                LINUX_THREAD_MSG_SEMAPHORE

#ifdef _UB_USE_HEAP
#define LINUX_THREAD_MSG_ALLOC(size)    kmalloc(size, GFP_KERNEL)
#define LINUX_THREAD_MSG_FREE(ptr)      kfree(ptr)
#else
#define LINUX_THREAD_MSG_ALLOC(size)    palloc(size)
#define LINUX_THREAD_MSG_FREE(ptr)      pfree(ptr)
#endif

#define LINUX_MUTEX_NESTING

#define for_each_processex(p) \
	for (p = &init_task ; next_task(p) != &init_task ; p = next_task(p))
        
/*******************************************************************************
*                                Ͷ                                  *
*******************************************************************************/
typedef struct {
    SIGSELECT   sig_no;
    UINT32      id;
    UINT32      buf_size;
    UINT32      magic;
} T_THREAD_MSG_HEAD;

typedef struct {
    T_ZOss_Node     Node;
    ZOSS_THREAD_ID  thread_id;
    UINT8           dire[THREAD_MSG_HOOK_TYPE_MAX];
    THREAD_MSG_HOOK func[THREAD_MSG_HOOK_TYPE_MAX];
} THREAD_MSG_HOOK_CONTENT;

typedef struct {
    char    *str;
    u64     keyval;
} linux_thread_sched_stat_t;

typedef struct {
    struct mutex    raw_mutex;
    const char      *name;
#ifdef LINUX_MUTEX_NESTING
    atomic_t        nesting;
#endif
} linux_mutex_t;

typedef struct {
    struct list_head    node;
    void                *msg;
    UINT32              size;
} linux_msg_queue_node_t;

typedef struct {
    struct list_head    head;
    raw_spinlock_t      lock;

#ifdef LINUX_THREAD_MSG_STAT
    u32                 count;
    u64                 send_time;
    u64                 recv_time;
#endif

#if (LINUX_THREAD_MSG == LINUX_THREAD_MSG_COMPLETION)
    struct completion   completion;
#elif (LINUX_THREAD_MSG == LINUX_THREAD_MSG_SEMAPHORE)
    struct semaphore    semaphore;
#endif
} linux_msg_queue_t;

typedef struct {
    struct list_head        all_node;
    struct task_struct      *task;
    linux_msg_queue_t       msg_queue;
    T_ZOsa_ThreadUserArea   user_area;
} linux_thread_t;

typedef void (*linux_thread_entry_t)(SINT32 arg);

typedef struct {
    linux_thread_entry_t    entry;
    SINT32                  arg;
    linux_thread_t          *thread;
} linux_create_thread_t;

/*******************************************************************************
*                                ֲ                                  *
*******************************************************************************/
static ZOSS_TIMER_ID zOss_GetStatisticTimesliceTimer(void);
static void zOss_SetStatisticTimesliceTimer(ZOSS_TIMER_ID timer_id);
static void zOss_StatisticTimesliceEnd(SINT32 param);

static int linux_thread_entry(void *arg);
static int linux_thread_exit(struct notifier_block *nb, unsigned long val, void *data);
static linux_thread_t *linux_thread_is_valid(ZOSS_THREAD_ID thread_id);
static linux_thread_t *linux_thread_task_is_valid(struct task_struct *task);
static linux_thread_t *linux_thread_current(void);
static linux_thread_t *linux_thread_get_thread_by_name(const char *name);
static UINT32 linux_thread_count_all_thread(void);
static UINT32 linux_thread_get_all_thread(linux_thread_t *thread_array[]);
static T_ZOsa_ThreadUserArea *linux_thread_get_user_area(ZOSS_THREAD_ID thread_id);
static linux_thread_t *linux_thread_alloc(void);
static void linux_thread_free(linux_thread_t *thread);
static void linux_thread_swapin(struct perf_event *event, int flags);
static void linux_thread_swapout(struct perf_event *event, int flags);

static void Osa_create_handler(void *thread, void *user_area);
static void Osa_kill_handler(void *thread, void *user_area);
#ifdef CONFIG_ACCURATE_CPU_PERCENT
static void Osa_swapin_handler(void *thread);
static void Osa_swapout_handler(void *thread);
#else
static void Osa_swapin_handler(void *thread, void *user_area);
static void Osa_swapout_handler(void *thread, void *user_area);
#endif

static void linux_stat_osa_callback(u32 idle_time, u32 total_time);

/*******************************************************************************
*                              ֲ̬                                *
*******************************************************************************/
__tcm_data static BOOL         gOsa_SwapFlag;
__tcm_data static UINT32       gOsa_SwapLastTime;
__tcm_data static UINT32       gOsa_CpuStartTime;
__tcm_data static ZOSS_TASK_ID *gOsa_AllTaskIdArray;

#ifdef _USE_MESSAGE
__tcm_data static T_ZOss_List  s_thread_msg_hook_list;
#endif

#ifdef _USE_MONITOR
static T_ZOss_Mon_Msg gOsa_MsgInfo;
#endif

#ifdef TOS_STATISTIC_TIMESLICE
static ZOSS_TIMER_ID tos_statistic_timeslice_timer;
#endif

#ifdef _USE_THREAD
__tcm_data static LIST_HEAD(linux_thread_all_head);
__tcm_data static DEFINE_RAW_SPINLOCK(linux_thread_spin_lock);

static struct notifier_block profile_nb = {
	.notifier_call = linux_thread_exit,
};

static struct pmu thread_pmu = {
    .task_ctx_nr    = perf_sw_context,
    .start          = linux_thread_swapin,
    .stop           = linux_thread_swapout,
};

static const char *linux_thread_sched_policy[] = {
    "SCHED_NORMAL",
    "SCHED_FIFO",
    "SCHED_RR",
    "SCHED_BATCH",
    "SCHED_IDLE",
};
#endif

/*******************************************************************************
*                                ȫֱ                                  *
*******************************************************************************/
__tcm_data UINT32  gOsa_SysCpuFreq;
__tcm_data BOOL    gOsa_SwapTimeFlag;

/*******************************************************************************
*                                ֲʵ                                  *
*******************************************************************************/

#ifdef _USE_THREAD

/*******************************************************************************
* :     ߳ͳһں
* ˵:     
*   ()  arg:    ߳
*   ()  void
*   ֵ:     ׼
* ˵:     void
*******************************************************************************/
static int linux_thread_entry(void *arg)
{
    linux_thread_t *thread;
    linux_create_thread_t *create_thread;

    zOss_AssertEx(arg != NULL, -EINVAL);

    create_thread = (linux_create_thread_t *)arg;

    thread = create_thread->thread;
    if (thread->task == NULL)
        thread->task = current;

    thread->user_area.topstack = round_up((UINT32)current->stack, THREAD_SIZE);

    create_thread->entry(create_thread->arg);

    kfree((void *)create_thread);
    do_exit(0x00);

    return 0x00;
}

/*******************************************************************************
* :     ߳ͳһں
* ˵:     
*   ()  nb:     ֪ͨṹָ
                val:    linux֪ͨƴݵֵ
                data:   ָ
*   ()  void
*   ֵ:     ׼
* ˵:     void
*******************************************************************************/
static int linux_thread_exit(struct notifier_block *nb, unsigned long val, void *data)
{
    linux_thread_t *thread;
    struct task_struct *task;

    zOss_AssertEx(data != NULL, -EINVAL);

    task = (struct task_struct *)data;
    thread = linux_thread_task_is_valid(task);
    if (thread) {
        Osa_kill_handler((void *)thread, (void *)&thread->user_area);
        linux_thread_free(thread);
    }

    return 0x00;
}

/*******************************************************************************
* :     ȡǰ߳̽ṹָ
* ˵:     
*   ()  void
*   ()  void
*   ֵ:     ɹصǰ߳̽ṹָ룬򷵻NULL
* ˵:     void
*******************************************************************************/
__tcm_func static linux_thread_t *linux_thread_current(void)
{
#if 0
    bool valid = false;
    unsigned long flags;
    linux_thread_t *thread;

    raw_spin_lock_irqsave(&linux_thread_spin_lock, flags);
    list_for_each_entry(thread, &linux_thread_all_head, all_node) {
        if (thread->task == current) {
            valid = true;
            break;
        }
    }
    raw_spin_unlock_irqrestore(&linux_thread_spin_lock, flags);

    if (valid)
        return thread;
    else
        return NULL;
#else
    return (linux_thread_t *)(current->zoss_thread);
#endif
}

/*******************************************************************************
* :     ߳ǷЧ
* ˵:     
*   ()  thread_id:  ߳ID
*   ()  void
*   ֵ:     ߳Ч߳̽ṹָ룬򷵻NULL
* ˵:     void
*******************************************************************************/
static linux_thread_t *linux_thread_is_valid(ZOSS_THREAD_ID thread_id)
{
#if 0
    bool valid = false;
    unsigned long flags;
    linux_thread_t *thread;

    raw_spin_lock_irqsave(&linux_thread_spin_lock, flags);
    list_for_each_entry(thread, &linux_thread_all_head, all_node) {
        if (thread == (linux_thread_t *)thread_id) {
            valid = true;
            break;
        }
    }
    raw_spin_unlock_irqrestore(&linux_thread_spin_lock, flags);

    if (valid)
        return thread;
    else
        return NULL;
#else
    return (linux_thread_t *)thread_id;
#endif
}

/*******************************************************************************
* :     ǷЧ
* ˵:     
*   ()  task:   ṹָ
*   ()  void
*   ֵ:     ЧضӦ߳̽ṹָ룬򷵻NULL
* ˵:     void
*******************************************************************************/
static linux_thread_t *linux_thread_task_is_valid(struct task_struct *task)
{
    bool valid = false;
    unsigned long flags;
    linux_thread_t *thread;

    raw_spin_lock_irqsave(&linux_thread_spin_lock, flags);
    list_for_each_entry(thread, &linux_thread_all_head, all_node) {
        if (thread->task == task) {
            valid = true;
            break;
        }
    }
    raw_spin_unlock_irqrestore(&linux_thread_spin_lock, flags);

    if (valid)
        return thread;
    else
        return NULL;
}

/*******************************************************************************
* :     ߳ƣȡ߳̽ṹָ
* ˵:     
*   ()  name:   ߳
*   ()  void
*   ֵ:     ߳Ч߳̽ṹָ룬򷵻NULL
* ˵:     void
*******************************************************************************/
__tcm_func static linux_thread_t *linux_thread_get_thread_by_name(const char *name)
{
    bool valid = false;
    unsigned long flags;
    linux_thread_t *thread;

    raw_spin_lock_irqsave(&linux_thread_spin_lock, flags);
    list_for_each_entry(thread, &linux_thread_all_head, all_node) {
        if (strcmp(thread->user_area.threadname, name) == 0) {
            valid = true;
            break;
        }
    }
    raw_spin_unlock_irqrestore(&linux_thread_spin_lock, flags);

    if (valid)
        return thread;
    else
        return NULL;
}

/*******************************************************************************
* :     ȡϵͳЧ߳
* ˵:     
*   ()  void
*   ()  void
*   ֵ:     ϵͳЧ߳
* ˵:     void
*******************************************************************************/
static UINT32 linux_thread_count_all_thread(void)
{
    UINT32 count = 0x00;
    unsigned long flags;
    linux_thread_t *thread;

    raw_spin_lock_irqsave(&linux_thread_spin_lock, flags);
    list_for_each_entry(thread, &linux_thread_all_head, all_node)
        count++;
    raw_spin_unlock_irqrestore(&linux_thread_spin_lock, flags);

    return count;
}

/*******************************************************************************
* :     ȡϵͳЧ߳
* ˵:     
*   ()  thread_array:   ߳̽ṹָ
*   ()  void
*   ֵ:     ϵͳЧ߳
* ˵:     void
*******************************************************************************/
static UINT32 linux_thread_get_all_thread(linux_thread_t *thread_array[])
{
    UINT32 cnt = 0x00;
    unsigned long flags;
    linux_thread_t *thread;

    zOss_AssertEx(thread_array != NULL, 0x00);

    raw_spin_lock_irqsave(&linux_thread_spin_lock, flags);
    list_for_each_entry(thread, &linux_thread_all_head, all_node)
        thread_array[cnt++] = thread;
    raw_spin_unlock_irqrestore(&linux_thread_spin_lock, flags);

    return cnt;
}

/*******************************************************************************
* :     ȡ߳û
* ˵:     
*   ()  thread:   ߳̽ṹָ
*   ()  void
*   ֵ:     ߳û
* ˵:     void
*******************************************************************************/
__tcm_func static T_ZOsa_ThreadUserArea *linux_thread_get_user_area(ZOSS_THREAD_ID thread_id)
{
#if 0
    unsigned long flags;
    linux_thread_t *thread;
    T_ZOsa_ThreadUserArea *user_area = NULL;

    raw_spin_lock_irqsave(&linux_thread_spin_lock, flags);
    list_for_each_entry(thread, &linux_thread_all_head, all_node) {
        if (thread == (linux_thread_t *)thread_id) {
            user_area = thread->user_area;
            break;
        }
    }
    raw_spin_unlock_irqrestore(&linux_thread_spin_lock, flags);

    return user_area;
#else
    return thread_id ? &(((linux_thread_t *)thread_id)->user_area) : NULL;
#endif
}

/*******************************************************************************
* :     ߳̽ṹ
* ˵:     
*   ()  void
*   ()  void
*   ֵ:     ߳̽ṹָ
* ˵:     void
*******************************************************************************/
static linux_thread_t *linux_thread_alloc(void)
{
    unsigned long flags;
    linux_thread_t *thread;

    thread = (linux_thread_t *)kmalloc(sizeof(linux_thread_t), GFP_ATOMIC);
    zOss_AssertEx(thread != NULL, NULL);

    INIT_LIST_HEAD(&thread->msg_queue.head);
    raw_spin_lock_init(&thread->msg_queue.lock);

#ifdef LINUX_THREAD_MSG_STAT
    thread->msg_queue.count        = 0x00;
    thread->msg_queue.send_time    = 0x00;
    thread->msg_queue.recv_time    = 0x00;
#endif

#if (LINUX_THREAD_MSG == LINUX_THREAD_MSG_COMPLETION)
    init_completion(&thread->msg_queue.completion);
#elif (LINUX_THREAD_MSG == LINUX_THREAD_MSG_SEMAPHORE)
    sema_init(&thread->msg_queue.semaphore, 0);
#endif

    raw_spin_lock_irqsave(&linux_thread_spin_lock, flags);
    list_add_tail(&thread->all_node, &linux_thread_all_head);
    raw_spin_unlock_irqrestore(&linux_thread_spin_lock, flags);

    Osa_create_handler((void *)thread, (void *)(&thread->user_area));

    return thread;
}

/*******************************************************************************
* :     ͷ߳̽ṹ
* ˵:     
*   ()  thread: ߳̽ṹָ
*   ()  void
*   ֵ:     void
* ˵:     void
*******************************************************************************/
static void linux_thread_free(linux_thread_t *thread)
{
    unsigned long flags;

    raw_spin_lock_irqsave(&linux_thread_spin_lock, flags);
    list_del(&thread->all_node);
    raw_spin_unlock_irqrestore(&linux_thread_spin_lock, flags);

    kfree((void *)thread);
}

/*******************************************************************************
* :     ߳빳Ӻ
* ˵:     
*   ()  event:  ¼ṹָ
                flags:  ־λ
*   ()  void
*   ֵ:     void
* ˵:     void
*******************************************************************************/
static void linux_thread_swapin(struct perf_event *event, int flags)
{
#if 0
    struct task_struct *task = event->ctx->task;

	event->hw.state = 0;
#endif
}

/*******************************************************************************
* :     ߳гӺ
* ˵:     
*   ()  event:  ¼ṹָ
                flags:  ־λ
*   ()  void
*   ֵ:     void
* ˵:     void
*******************************************************************************/
static void linux_thread_swapout(struct perf_event *event, int flags)
{
#if 0
    struct task_struct *task = event->ctx->task;

	event->hw.state = PERF_HES_STOPPED;
#endif
}

/*******************************************************************************
* :     ״̬ȽϺ
* ˵:     
*   ()  obj1:   1ָ
                obj2:   2ָ
*   ()  void
*   ֵ:     ״̬ȽϽ:
                    ret >  0ʾobj1 > obj2
                    ret == 0ʾobj1 == obj2
                    ret <  0ʾobj1 < obj2
* ˵:     sortȽϲ
*******************************************************************************/
static inline int linux_thread_sched_stat_cmp(const void *obj1, const void *obj2)
{
    u64 time1 = ((linux_thread_sched_stat_t *)obj1)->keyval;
    u64 time2 = ((linux_thread_sched_stat_t *)obj2)->keyval;

    if (time1 < time2)
        return 1;
    else if (time1 == time2)
        return 0;
    else
        return -1;
}

/*******************************************************************************
* :     ״̬
* ˵:     
*   ()  obj1:   1ָ
                obj2:   2ָ
                size:   С
*   ()  void
*   ֵ:     void
* ˵:     sort򽻻
*******************************************************************************/
static inline void linux_thread_sched_stat_swap(void *obj1, void *obj2, int size)
{
    linux_thread_sched_stat_t sched_stat;

    sched_stat = *(linux_thread_sched_stat_t *)obj1;
    *(linux_thread_sched_stat_t *)obj1 = *(linux_thread_sched_stat_t *)obj2;
    *(linux_thread_sched_stat_t *)obj2 = sched_stat;
}

/*******************************************************************************
* :     ʼ̵߳ûռ
* ˵:     
*   ()  thread_id:  ʼûݿռ߳
                user_area:  ߳ûָ
*   ()  void
*   ֵ:     void
* ˵:     void
*******************************************************************************/
static void zOss_InitThreadUserArea(ZOSS_THREAD_ID thread_id, T_ZOsa_ThreadUserArea *user_area)
{
    linux_thread_t *thread;

    zOss_AssertExN(thread_id != NULL && user_area != NULL);

    thread = linux_thread_is_valid(thread_id);
    zOss_AssertExN(thread != NULL);

    user_area->stacksize    = (UINT32)THREAD_SIZE;
    user_area->heapsize     = 0xFFFFFFFF;
    user_area->threadid     = (ZOSS_THREAD_ID)thread;
    user_area->ubsize       = 0;
    user_area->ptrf         = 0;
    user_area->runcount     = 0;
    user_area->curtaskid    = 0;
    user_area->cpupercent   = 0;
    user_area->runtime      = 0;
    user_area->cputime      = 0;
    user_area->RunTimeInMs  = 0;
}

/*******************************************************************************
* :     ̴߳ʱ֧Ų㹳Ӻ
* ˵:     
*   ()  thread:     ָ߳
                user_area:  ̵߳ûָ
*   ()  void
*   ֵ:     void
* ˵:     void
*******************************************************************************/
static void Osa_create_handler(void *thread, void *user_area)
{
    zOss_AssertExN(thread != NULL && user_area != NULL);

    if (gOsa_SysCpuFreq == 0x00) 
    {
        gOsa_SwapFlag       = TRUE;
        gOsa_SwapLastTime   = Osa_HwTimeRead();
#if defined (_USE_PSM) && defined (_USE_CPU_DFM)
        zOss_RecordPsmLastSwapTime();
#endif
        gOsa_SysCpuFreq     = 0x00;
    }

    zOss_InitThreadUserArea((ZOSS_THREAD_ID)thread, (T_ZOsa_ThreadUserArea *)user_area);
}

/*******************************************************************************
* :     ߳ɾʱ֧Ų㹳Ӻ
* ˵:     
*   ()  thread:     ָ߳
                user_area:  ̵߳ûָ
*   ()  void
*   ֵ:     void
* ˵:     void
*******************************************************************************/
static void Osa_kill_handler(void *thread, void *user_area)
{
    zOss_AssertExN(thread != NULL);
    if (thread == NULL || user_area == NULL)
        return;
}

#ifdef CONFIG_ACCURATE_CPU_PERCENT
/*******************************************************************************
* :     ߳ʱ֧Ų㹳Ӻ
* ˵:     
*   ()  thread:     ָ߳
                user_area:  ̵߳ûָ
*   ()  void
*   ֵ:     void
* ˵:     void
*******************************************************************************/
void Osa_swapin_handler(void *thread)
{
    struct task_struct *task = (struct task_struct *)thread;
    zOss_AssertExN(thread != NULL);

#ifdef OSS_TRACE_THREAD    
    oss_trace_thread_swapin(thread);
    oss_trace_func_swapin(thread);
#endif

#if defined (_USE_PSM) && defined (_USE_CPU_DFM)
    //zOss_ThreadSwapInPsmHook((T_ZOsa_ThreadUserArea *)user_area);
#endif
    
    if (gOsa_SwapTimeFlag) 
    {
        UINT32 past_time;
        UINT32 current_time;

        current_time        = Osa_HwTimeRead();
        past_time           = current_time - gOsa_SwapLastTime;
        gOsa_SwapLastTime   = current_time;
        task->ac_rtime     += past_time;
    }
}

/*******************************************************************************
* :     ߳гʱ֧Ų㹳Ӻ
* ˵:     
*   ()  thread:     ָ߳
                user_area:  ̵߳ûָ
*   ()  void
*   ֵ:     void
* ˵:     void
*******************************************************************************/
void Osa_swapout_handler(void *thread)
{
    struct task_struct *task = (struct task_struct *)thread;
    zOss_AssertExN(thread != NULL);

#ifdef OSS_TRACE_THREAD
    oss_trace_thread_swapout(thread);
    oss_trace_func_swapout(thread);
#endif    

#if defined (_USE_PSM) && defined (_USE_CPU_DFM)
    //zOss_ThreadSwapOutPsmHook((T_ZOsa_ThreadUserArea *)user_area);
#endif
    
    if (gOsa_SwapTimeFlag)
    {
        UINT32 past_time;
        UINT32 current_time;

        current_time        = Osa_HwTimeRead();
        past_time           = current_time - gOsa_SwapLastTime;
        gOsa_SwapLastTime   = current_time;
        task->ac_rtime     += past_time;
    }
}

#else
/*******************************************************************************
* :     ߳ʱ֧Ų㹳Ӻ
* ˵:     
*   ()  thread:     ָ߳
                user_area:  ̵߳ûָ
*   ()  void
*   ֵ:     void
* ˵:     void
*******************************************************************************/
static void Osa_swapin_handler(void *thread, void *user_area)
{
    zOss_AssertExN(thread != NULL && user_area != NULL);

#ifdef OSS_TRACE_THREAD    
    oss_trace_thread_swapin(thread);
    oss_trace_func_swapin(thread);
#endif

#if defined (_USE_PSM) && defined (_USE_CPU_DFM)
    zOss_ThreadSwapInPsmHook((T_ZOsa_ThreadUserArea *)user_area);
#endif
    
    if (gOsa_SwapTimeFlag) 
    {
        UINT32 past_time;
        UINT32 current_time;
        T_ZOsa_ThreadUserArea *ua = (T_ZOsa_ThreadUserArea *)user_area;

        current_time        = Osa_HwTimeRead();
        past_time           = current_time - gOsa_SwapLastTime;
        gOsa_SwapLastTime   = current_time;
        ua->runcount++;
        ua->cputime += past_time;
        ua->runtime += past_time;
        
        if (ua->curtaskid != NULL) 
        {
            T_ZOss_TCB *tcb = (T_ZOss_TCB *)(ua->curtaskid);
            
            tcb->cputime    += past_time;
            tcb->runtime    += past_time;
            tcb->task_time  = current_time;
        }
    }
}

/*******************************************************************************
* :     ߳гʱ֧Ų㹳Ӻ
* ˵:     
*   ()  thread:     ָ߳
                user_area:  ̵߳ûָ
*   ()  void
*   ֵ:     void
* ˵:     void
*******************************************************************************/
static void Osa_swapout_handler(void *thread, void *user_area)
{
    zOss_AssertExN(thread != NULL && user_area != NULL);

#ifdef OSS_TRACE_THREAD
    oss_trace_thread_swapout(thread);
    oss_trace_func_swapout(thread);
#endif    

#if defined (_USE_PSM) && defined (_USE_CPU_DFM)
    zOss_ThreadSwapOutPsmHook((T_ZOsa_ThreadUserArea *)user_area);
#endif
    
    if (gOsa_SwapTimeFlag)
    {
        UINT32 past_time;
        UINT32 current_time;
        T_ZOsa_ThreadUserArea *ua = (T_ZOsa_ThreadUserArea *)user_area;

        current_time        = Osa_HwTimeRead();
        past_time           = current_time - gOsa_SwapLastTime;
        gOsa_SwapLastTime   = current_time;
        ua->cputime += past_time;
        ua->runtime += past_time;
        
        if (ua->curtaskid != NULL)
        {
            T_ZOss_TCB *tcb = (T_ZOss_TCB *)(ua->curtaskid);

            past_time       = current_time - tcb->task_time;
            tcb->cputime    += past_time;
            tcb->runtime    += past_time;
        }
    }
}
#endif

#endif

/*******************************************************************************
* :     linux֧Ųͳƻص
* ˵:     
*   ()  idle_time:  ָʱϵͳʱ
                total_time: ָʱϵͳʱ
*   ()  void
*   ֵ:     void
* ˵:     void
*******************************************************************************/
static void linux_stat_osa_callback(u32 idle_time, u32 total_time)
{
    printf("system idle time:%-10u\n", idle_time);
    printf("system total time:%-10u\n", total_time);
}

/*******************************************************************************
* :     ߳ջռʹ
* ˵:     
*   ()  thread_id:  ̵߳id
*   ()  void
*   ֵ:     ߳ջռʹ
* ˵:     void
*******************************************************************************/
static UINT8 zOss_GetThreadStackUsed( ZOSS_THREAD_ID thread_id)
{
    struct task_struct *task;
    unsigned long stack_pointer, stack_base;

    task            = ((linux_thread_t *)thread_id)->task;
    stack_pointer   = thread_saved_sp(task);
    stack_base      = (unsigned long)task->stack;

    return (UINT8)(100 - (((stack_pointer - stack_base)/THREAD_SIZE)*100));
}

/*******************************************************************************
* :     ϵͳ̵߳CPUռ
* ˵:     
*   ()  void
*   ()  void
*   ֵ:     void
* ˵:     void
*******************************************************************************/
#ifdef CONFIG_ACCURATE_CPU_PERCENT
static void Osa_UpdateThreadCpu(void)
{
    UINT32 run_time;
    unsigned long flags;
    struct task_struct *task;
    T_ZOsa_ThreadUserArea *user_area;

    run_time = Osa_HwTimeRead() - gOsa_CpuStartTime;
    for_each_processex(task) {
        task->ac_cpupercent = (FLOAT)((task->ac_rtime)*100) / run_time;
        task->ac_rtime    = 0;
    }
}
#else
static void Osa_UpdateThreadCpu(void)
{
    UINT32 run_time;
    unsigned long flags;
    linux_thread_t *thread;
    T_ZOsa_ThreadUserArea *user_area;

    run_time = Osa_HwTimeRead() - gOsa_CpuStartTime;
    raw_spin_lock_irqsave(&linux_thread_spin_lock, flags);
    list_for_each_entry(thread, &linux_thread_all_head, all_node) {
        user_area = thread->user_area;
        zOss_ASSERT(user_area != NULL);
        if (user_area == NULL)
            break;

        user_area->cpupercent = (FLOAT)((user_area->cputime)*100) / run_time;
        user_area->cputime    = 0;
    }
    raw_spin_unlock_irqrestore(&linux_thread_spin_lock, flags);
}
#endif

/*******************************************************************************
* :     ϵͳCPUռ
* ˵:     
*   ()  void
*   ()  void
*   ֵ:     void
* ˵:     void
*******************************************************************************/
static void Osa_UpdateTaskCpu(void)
{
    UINT32      cnt         = 0;
    UINT32      tcb_no      = 0;
    T_ZOss_TCB  *tcb        = NULL;
    UINT32      run_time    = 0;
    
    zOss_AssertExN(gOsa_AllTaskIdArray != NULL);

    run_time = Osa_HwTimeRead() - gOsa_CpuStartTime;
    tcb_no = zOss_GetAllTaskID(gOsa_AllTaskIdArray);
    for (cnt = 0x00; cnt < tcb_no; cnt++)
    {
        tcb = (T_ZOss_TCB *)gOsa_AllTaskIdArray[cnt];
        if (tcb->task_id != tcb)
        {    
            continue;
        }
        tcb->cpupercent = (FLOAT)((tcb->cputime)*100) / run_time;
        tcb->cputime = 0;
    }
}

#ifdef _USE_MESSAGE

/*******************************************************************************
* :     ߳id߳ϢвƥĽڵ
* ˵:     
*   ()  thread_id:  ߳id
*   ()  void
*   ֵ:     ҳɹƥĽڵ㣬򷵻NULL
* ˵:     void
*******************************************************************************/
static THREAD_MSG_HOOK_CONTENT* find_thread_content(ZOSS_THREAD_ID thread_id)
{
    THREAD_MSG_HOOK_CONTENT *msg_hook = (THREAD_MSG_HOOK_CONTENT *)zOss_ListFirst(&s_thread_msg_hook_list);

    while (msg_hook) 
    {
        if (msg_hook->thread_id == thread_id)
        {
            break;
        }
        
        msg_hook = (THREAD_MSG_HOOK_CONTENT *)zOss_ListNext((T_ZOss_Node *)msg_hook);
    }

    return msg_hook;
}

/*******************************************************************************
* :     ȡϢӿڷϢ
* ˵:     
*   ()  msg_head:  ϢϢŵַ
*               thread_id: Ŀ̵߳߳id
*   ()  void
*   ֵ:     void
* ˵:     void
*******************************************************************************/
static inline void zOss_GetSendMsgInfo(thread_msg_t *msg_head, ZOSS_THREAD_ID thread_id)
{
#if defined (OSS_TRACE_THREAD) && defined(_USE_MONITOR)
    if (gOsa_MonitorFlag)
    {
        ZOSS_INTR   old_intr    = 0;
        UINT32      cnt         = 0;
        
        ZOSS_SAVE_IRQ(old_intr);
        cnt = gOsa_MsgInfo.num;
        gOsa_MsgInfo.ele[cnt].msgId     = 0x00;
        gOsa_MsgInfo.ele[cnt].ptr       = (UINT32)msg_head->msg_ptr;
        gOsa_MsgInfo.ele[cnt].size      = msg_head->msg_size;
        gOsa_MsgInfo.ele[cnt].receiver  = zOss_GetThreadName(thread_id, NULL);
#ifdef _OS_TOS
        gOsa_MsgInfo.ele[cnt].sender    = zOss_GetThreadName((ZOSS_THREAD_ID)cyg_thread_self(), NULL);
#elif defined (_OS_LINUX)
        gOsa_MsgInfo.ele[cnt].sender    = zOss_GetThreadName((ZOSS_THREAD_ID)linux_thread_current(), NULL);
#endif
        gOsa_MsgInfo.ele[cnt].timestamp = Osa_HwTimeRead();
        if (++cnt >= OSS_MON_INFO_MAX_NUMBER)
        {
            cnt = 0;
        }
        gOsa_MsgInfo.num = cnt;
        ZOSS_RESTORE_IRQ(old_intr);
    }
#endif 
}

/*******************************************************************************
* :     ȡϢӿڽϢ
* ˵:     
*   ()  msg_head:  ϢϢŵַ
*   ()  void
*   ֵ:     void
* ˵:     void
*******************************************************************************/
static inline void zOss_GetRecvMsgInfo(thread_msg_t *msg_head)
{
#ifdef _USE_MONITOR
    if (gOsa_MonitorFlag)
    {
        ZOSS_INTR   old_intr    = 0;
        UINT32      cnt         = 0;

        ZOSS_SAVE_IRQ(old_intr);
        cnt = gOsa_MsgInfo.num;
        gOsa_MsgInfo.ele[cnt].msgId     = 0x00;
        gOsa_MsgInfo.ele[cnt].ptr       = (UINT32)msg_head->msg_ptr;
        gOsa_MsgInfo.ele[cnt].size      = msg_head->msg_size;
#ifdef _OS_TOS
        gOsa_MsgInfo.ele[cnt].receiver  = zOss_GetThreadName((ZOSS_THREAD_ID)cyg_thread_self(), NULL);
#elif defined (_OS_LINUX)
        gOsa_MsgInfo.ele[cnt].receiver  = zOss_GetThreadName((ZOSS_THREAD_ID)linux_thread_current(), NULL);
#endif
        gOsa_MsgInfo.ele[cnt].sender    = "unknown";
        gOsa_MsgInfo.ele[cnt].timestamp = Osa_HwTimeRead();
        if (++cnt >= OSS_MON_INFO_MAX_NUMBER)
        {
            cnt = 0;
        }
        gOsa_MsgInfo.num = cnt;
        ZOSS_RESTORE_IRQ(old_intr);
    }
#endif
}

/*******************************************************************************
* :     ȡ߳ϢӿڷϢ
* ˵:     
*   ()  msg_id:           Ϣid
*               thread_msg_head:  ϢϢŵַ
*               thread_id:        Ŀ̵߳߳id
*   ()  void
*   ֵ:     void
* ˵:     void
*******************************************************************************/
static inline void zOss_GetThreadSendMsgInfo(
                            UINT32 msg_id, 
                            T_THREAD_MSG_HEAD *thread_msg_head,
                            ZOSS_THREAD_ID thread_id)
{
#ifdef _USE_MONITOR
        if (gOsa_MonitorFlag)
        {
            ZOSS_INTR   old_intr    = 0;
            UINT32      cnt         = 0;

            ZOSS_SAVE_IRQ(old_intr);
            cnt = gOsa_MsgInfo.num;
            gOsa_MsgInfo.ele[cnt].msgId     = msg_id;
            gOsa_MsgInfo.ele[cnt].ptr       = (UINT32)thread_msg_head;
            gOsa_MsgInfo.ele[cnt].size      = thread_msg_head->buf_size;
            gOsa_MsgInfo.ele[cnt].receiver  = zOss_GetThreadName(thread_id, NULL);
#ifdef _OS_TOS
            gOsa_MsgInfo.ele[cnt].sender    = zOss_GetThreadName((ZOSS_THREAD_ID)cyg_thread_self(), NULL);
#elif defined (_OS_LINUX)
        gOsa_MsgInfo.ele[cnt].receiver  = zOss_GetThreadName((ZOSS_THREAD_ID)linux_thread_current(), NULL);
#endif
            gOsa_MsgInfo.ele[cnt].timestamp = Osa_HwTimeRead();
            if (++cnt >= OSS_MON_INFO_MAX_NUMBER)
            {
                cnt = 0;
            }
            gOsa_MsgInfo.num = cnt;
            ZOSS_RESTORE_IRQ(old_intr);
        }
#endif
}

/*******************************************************************************
* :     ȡ߳ϢӿڽϢ
* ˵:     
*   ()  thread_msg_head:  ϢϢŵַ               
*   ()  void
*   ֵ:     void
* ˵:     void
*******************************************************************************/
static inline void zOss_GetThreadRecvMsgInfo(T_THREAD_MSG_HEAD *thread_msg_head)                       
{
#ifdef _USE_MONITOR
    if (gOsa_MonitorFlag)
    {
        ZOSS_INTR   old_intr    = 0;
        UINT32      cnt         = 0;

        ZOSS_SAVE_IRQ(old_intr);
        cnt = gOsa_MsgInfo.num; 
        gOsa_MsgInfo.ele[cnt].msgId     = thread_msg_head->id;
        gOsa_MsgInfo.ele[cnt].ptr       = (UINT32)thread_msg_head;
        gOsa_MsgInfo.ele[cnt].size      = thread_msg_head->buf_size;
#ifdef _OS_TOS
        gOsa_MsgInfo.ele[cnt].receiver  = zOss_GetThreadName((ZOSS_THREAD_ID)cyg_thread_self(), NULL);
#elif defined (_OS_LINUX)
        gOsa_MsgInfo.ele[cnt].receiver  = zOss_GetThreadName((ZOSS_THREAD_ID)linux_thread_current(), NULL);
#endif
        gOsa_MsgInfo.ele[cnt].sender    = "unknown";
        gOsa_MsgInfo.ele[cnt].timestamp = Osa_HwTimeRead();
        if (++cnt >= OSS_MON_INFO_MAX_NUMBER)
        {
            cnt = 0;
        }
        gOsa_MsgInfo.num = cnt;
        ZOSS_RESTORE_IRQ(old_intr);
    }
#endif
}

#endif  // #ifdef _USE_MESSAGE

/*******************************************************************************
*                                ȫֺʵ                                  *
*******************************************************************************/
#ifdef _USE_THREAD

/*******************************************************************************
* :     ϵͳ̴߳
* ˵:     
*   ()  б
*   ()  б
*   ֵ:     Ѵ߳̾
* ˵:     ̴߳ʧܣϵͳ
*******************************************************************************/
ZOSS_THREAD_ID zOss_CreateThread(
                    const CHAR *thread_name,    /* name                 */
                    VOID (*entry)(SINT32),      /* entry                */
                    SINT32 arg,                 /* arguments pointer    */
                    UINT32 stack_size,          /* stack size           */
                    UINT32 priority,            /* priority             */
                    UINT32 preempt,             /* useless              */
                    UINT32 auto_start)          /* auto start           */
{
    int ret;
    struct task_struct *task;
    struct sched_param param;
    linux_thread_t *thread;
    linux_create_thread_t *create_thread;
    static bool first_thread = true;

    if (first_thread) {
        param.sched_priority = MAX_USER_RT_PRIO - 2;
        ret = sched_setscheduler(kthreadd_task, SCHED_FIFO, &param);
        zOss_AssertEx(ret == 0x00, NULL);

        ret = profile_event_register(PROFILE_TASK_EXIT, &profile_nb);
        zOss_AssertEx(ret == 0x00, NULL);

#if 0
        ret = perf_pmu_register(&thread_pmu, "thread_pmu", PERF_TYPE_TRACEPOINT);
        zOss_AssertEx(ret == 0x00, NULL);
        if (ret != 0x00) {
            ret = profile_event_unregister(PROFILE_TASK_EXIT, &profile_nb);
            return NULL;
        }
#endif

        first_thread = false;
    }

    create_thread = (linux_create_thread_t *)kmalloc(sizeof(linux_create_thread_t), GFP_ATOMIC);
    zOss_AssertEx(create_thread != NULL, NULL);

    thread = linux_thread_alloc();
    if (thread == NULL) {
        kfree((void *)create_thread);
        zOss_ASSERT(0);
        return NULL;
    }
    strncpy(thread->user_area.threadname, thread_name, MAX_THREADNAME_LEN);

    create_thread->entry    = entry;
    create_thread->arg       = arg;
    create_thread->thread   = thread;

#ifdef CONFIG_STACK_SIZE
    if(stack_size >= 8192)
        create_thread =(void *)((unsigned long)create_thread + 1);
      	
#endif
    task = kthread_create(linux_thread_entry,
                        (void *)create_thread,
                        thread_name);

    task->zoss_thread = thread;
    thread->task = task;

    if (preempt == ZOSS_PREEMPT_IRQ_THREAD)
        priority = oss_max(priority, 1);
    else
        priority += LINUX_IRQ_THREAD_PRIORITY;
    param.sched_priority = oss_min(priority, MAX_USER_RT_PRIO - 1);
    param.sched_priority = MAX_USER_RT_PRIO - 1 - param.sched_priority;
    sched_setscheduler(task, SCHED_FIFO, &param);

    if (auto_start)
        wake_up_process(task);

    return (ZOSS_THREAD_ID)thread;
}

ZOSS_THREAD_ID zOss_CreateNormalThread(
                    const CHAR *thread_name,    /* name                 */
                    VOID (*entry)(SINT32),      /* entry                */
                    SINT32 arg,                 /* arguments pointer    */
                    UINT32 stack_size,          /* stack size           */
                    SINT32 priority,            /* priority             */
                    UINT32 preempt,             /* useless              */
                    UINT32 auto_start)          /* auto start           */
{
    int ret;
    struct task_struct *task;
    struct sched_param param;
    linux_thread_t *thread;
    linux_create_thread_t *create_thread;

    create_thread = (linux_create_thread_t *)kmalloc(sizeof(linux_create_thread_t), GFP_ATOMIC);
    zOss_AssertEx(create_thread != NULL, NULL);

    thread = linux_thread_alloc();
    if (thread == NULL) {
        kfree((void *)create_thread);
        zOss_ASSERT(0);
        return NULL;
    }
    strncpy(thread->user_area.threadname, thread_name, MAX_THREADNAME_LEN);

    create_thread->entry   = entry;
    create_thread->arg     = arg;
    create_thread->thread  = thread;

#ifdef CONFIG_STACK_SIZE
    if(stack_size >= 8192)
        create_thread =(void *)((unsigned long)create_thread + 1);
      	
#endif
    task = kthread_create(linux_thread_entry,(void *)create_thread, thread_name);

    task->zoss_thread = thread;
    thread->task = task;

    if (priority != 0)
        set_user_nice(task, priority);
    if (auto_start)
        wake_up_process(task);

    return (ZOSS_THREAD_ID)thread;
}

/*******************************************************************************
* :     ϵͳ߳˳
* ˵:     
*   ()  void
*   ()  void
*   ֵ:     void
* ˵:     void
*******************************************************************************/
VOID zOss_ExitThread(VOID)
{
    do_exit(0x00);
}

/*******************************************************************************
* :     ϵͳ̹߳
* ˵:     
*   ()  thread_id:  豻߳id
*   ()  void
*   ֵ:     ɹZOSS_SUCCESSϵͳ
* ˵:     ̵߳ҹ
*******************************************************************************/
UINT32 zOss_SuspendThread(ZOSS_THREAD_ID thread_id)
{
    linux_thread_t *thread;

    thread = linux_thread_is_valid(thread_id);
    zOss_AssertEx(thread != NULL, ZOSS_ERROR);

    set_task_state(thread->task, TASK_KILLABLE);
    if (thread->task == current) {
        schedule();

        if (fatal_signal_pending(current))
            do_exit(SIGKILL);
    }

    return ZOSS_SUCCESS;
}

/*******************************************************************************
* :     ϵͳָ̻߳
* ˵:     
*   ()  thread_id:  豻ָ߳id
*   ()  void
*   ֵ:     ɹZOSS_SUCCESSϵͳ
* ˵:     ֻʹ̬߳̽иȼִ߳лھ̬
                ߳ȴ.
*******************************************************************************/
UINT32 zOss_ResumeThread(ZOSS_THREAD_ID thread_id)
{
    linux_thread_t *thread;

    thread = linux_thread_is_valid(thread_id);
    zOss_AssertEx(thread != NULL, ZOSS_ERROR);

    wake_up_process(thread->task);

    return ZOSS_SUCCESS;
}

/*******************************************************************************
* :     ϵͳ߳˯ߺ
* ˵:     
*   ()  time_in_ms:     ߳̽Ҫ˯ߵʱ䣬λ: ms
*   ()  void
*   ֵ:     void
* ˵:     ϵͳʱӵƵδ֤ӳʱ䲻׼ȷ
*******************************************************************************/
__tcm_func VOID zOss_Sleep(UINT32 time_in_ms)
{
    signed long timeout = msecs_to_jiffies(time_in_ms);

    while (timeout) {
        timeout = schedule_timeout_killable(timeout);
        if (fatal_signal_pending(current))
            do_exit(SIGKILL);
    }
}

/*******************************************************************************
* :     ϵͳ߳ɾ
* ˵:     
*   ()  thread_id:  ɾ߳id
*   ()  void
*   ֵ:     ɹZOSS_SUCCESSϵͳ
* ˵:     void
*******************************************************************************/
UINT32 zOss_DeleteThread(ZOSS_THREAD_ID thread_id)
{
    linux_thread_t *thread;
    struct task_struct *task;
    struct completion *vfork_done;

    thread = linux_thread_is_valid(thread_id);
    zOss_AssertEx(thread != NULL, ZOSS_ERROR);

    task = thread->task;
    get_task_struct(task);
    barrier();
    vfork_done = task->vfork_done;
    force_sig(SIGKILL, task);
    wake_up_process(task);
    if (vfork_done)
        wait_for_completion(vfork_done);
    put_task_struct(task);

    return ZOSS_SUCCESS;
}

/*******************************************************************************
* :     ϵͳĻȡǰ߳idĺ
* ˵:     
*   ()  void
*   ()  void
*   ֵ:     ǰ̵ִ߳߳id
* ˵:     void
*******************************************************************************/
__tcm_func ZOSS_THREAD_ID zOss_GetCurThreadID(VOID)
{
    return (ZOSS_THREAD_ID)linux_thread_current();
}

/*******************************************************************************
* :     ݲṩ߳ƣҸ̵߳߳id
* ˵:     
*   ()  thread_name:    ߳
*   ()  void
*   ֵ:     ҳɹ̵߳Ч߳idϵͳ
* ˵:     void
*******************************************************************************/
ZOSS_THREAD_ID zOss_GetThreadIDByName (const CHAR *thread_name)
{
    return (ZOSS_THREAD_ID)linux_thread_get_thread_by_name(thread_name);
}

/*******************************************************************************
* :     ݲṩ߳idȡ̵߳߳
* ˵:     
*   ()  thread_id:      ȡ߳Ƶ߳id
*   ()  thread_name:    ߳ƴŵַ
*   ֵ:     ɹָ߳룻ϵͳԻ򷵻ؿָ
* ˵:     thread_nameǿգʾҪϵͳṩ߳ƿ
                ڴַ追ֻ践ָ߳
*******************************************************************************/
CHAR *zOss_GetThreadName(ZOSS_THREAD_ID thread_id, CHAR *thread_name)
{
    linux_thread_t *thread;

    thread = linux_thread_is_valid(thread_id);
    zOss_AssertEx(thread != NULL, NULL);

    if (thread_name)
        strcpy((char *)thread_name, thread->user_area.threadname);

    return (CHAR *)thread->user_area.threadname;
}

/*******************************************************************************
* :     ݲṩ߳idȡ̵߳߳Ϣ
* ˵:     
*   ()  thread_id:  ȡ߳Ϣ߳id
*   ()  б
*   ֵ:     ɹZOSS_SUCCESSϵͳ
* ˵:     void
*******************************************************************************/
UINT32 zOss_GetThreadInfo(ZOSS_THREAD_ID thread_id,   /* id       */
                          CHAR *thread_name,          /*      */
                          UINT32 *stat,               /* ״̬     */
                          UINT32 *priority,           /* ȼ   */
                          UINT32 *preempt)            /* ռ   */
{
    linux_thread_t *thread;

    thread = linux_thread_is_valid(thread_id);
    zOss_AssertEx(thread != NULL, ZOSS_ERROR);

    if (thread_name)
        strcpy(thread_name, thread->user_area.threadname);

    if (stat)
        *stat = thread->task->state;

    if (priority)
        *priority = thread->task->prio;

    if (preempt)
        *preempt = 1;

    return ZOSS_SUCCESS;
}

/*******************************************************************************
* :     ȡǰ̵߳Ϣ(ģ)
* ˵:     
*   ()  void              
*   ()  pMonThreadInfo: ߳Ϣŵַ
*   ֵ:     void
* ˵:     ˺ڴռ䣬ʹͷţڴй¶
*******************************************************************************/
VOID z0ss_GetAllThreadInfo(T_ZOss_Mon_Thread *pMonThreadInfo)
{
#ifdef _USE_MONITOR

#endif
}

/*******************************************************************************
* :     ݲṩ߳idø̵߳߳ȼ
* ˵:     
*   ()  thread_id:  ȼ߳id
                priority:   ߳̽õȼ
*   ()  void
*   ֵ:     ɹZOSS_SUCCESSϵͳ
* ˵:     void
*******************************************************************************/
UINT32 zOss_SetThreadPri(ZOSS_THREAD_ID thread_id, UINT32 priority)
{
    linux_thread_t *thread;
    struct sched_param param;

    thread = linux_thread_is_valid(thread_id);
    zOss_AssertEx(thread != NULL, ZOSS_ERROR);

    priority += LINUX_IRQ_THREAD_PRIORITY;
    param.sched_priority = oss_min(priority, MAX_USER_RT_PRIO - 1);
    param.sched_priority = MAX_USER_RT_PRIO - 1 - param.sched_priority;
    sched_setscheduler(thread->task, SCHED_FIFO, &param);

    return ZOSS_SUCCESS;
}

/*******************************************************************************
* :     ݲṩ߳idø̵߳߳ȼ
* ˵:     
*   ()  thread_id:  ȼ߳id
                priority:   ߳̽õȼ
*   ()  void
*   ֵ:     ɹZOSS_SUCCESSϵͳ
* ˵:     void
*******************************************************************************/
extern struct task_struct *find_task_by_vpid(pid_t vnr);
UINT32 zOss_SetProcessPri(VOID *thread_id, UINT32 priority)
{
    struct task_struct *thread;
    struct sched_param param;

    thread = find_task_by_vpid((pid_t)thread_id);
    if (thread == NULL){
        zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_NORMAL, "\twrong pid!");
        return ZOSS_ERROR;
    }
    else if (thread->mm != NULL)
    {
        zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_NORMAL, "\tcan`t set user process,use nice instead!");
        return ZOSS_ERROR;
    }

    param.sched_priority = priority;
    sched_setscheduler(thread, SCHED_FIFO, &param);

    return ZOSS_SUCCESS;
}

/*******************************************************************************
* :     ݲṩ߳idȡ̵߳߳ȼ
* ˵:     
*   ()  thread_id:  ȡȼ߳id
*   ()  priority:   ȡ߳ȼŵַ
*   ֵ:     ɹZOSS_SUCCESSϵͳ
* ˵:     void
*******************************************************************************/
UINT32 zOss_GetProcessPri(VOID *thread_id, UINT32 *priority)
{
    struct task_struct *thread;

    zOss_AssertEx(priority != NULL, ZOSS_ERROR);

    thread = find_task_by_vpid((pid_t)thread_id);
    if (thread == NULL)
    {
        zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_NORMAL, "\twrong pid!");
        return ZOSS_ERROR;
    }

    *priority = thread->rt_priority;

    return ZOSS_SUCCESS;
}

/*******************************************************************************
* :     ݲṩ߳idȡ̵߳߳ȼ
* ˵:     
*   ()  thread_id:  ȡȼ߳id
*   ()  priority:   ȡ߳ȼŵַ
*   ֵ:     ɹZOSS_SUCCESSϵͳ
* ˵:     void
*******************************************************************************/
UINT32 zOss_GetThreadPri(ZOSS_THREAD_ID thread_id, UINT32 *priority)
{
    linux_thread_t *thread;

    zOss_AssertEx(priority != NULL, ZOSS_ERROR);

    thread = linux_thread_is_valid(thread_id);
    zOss_AssertEx(thread != NULL, ZOSS_ERROR);

    *priority = thread->task->prio;

    return ZOSS_SUCCESS;
}

/*******************************************************************************
* :     ȡ߳ûݿռָ
* ˵:     
*   ()  thread_id:  ȡûݿռָ߳id
*   ()  void
*   ֵ:     ̵߳ûݿռָ
* ˵:     void
*******************************************************************************/
T_ZOsa_ThreadUserArea *zOss_GetThreadUserArea(ZOSS_THREAD_ID thread_id)
{
    return linux_thread_get_user_area(thread_id);
}

/*******************************************************************************
* :     ֤һ߳ǷЧ
* ˵:     
*   ()  thread_id:  ֤߳id
*   ()  void
*   ֵ:     ߳ЧZOSS_SUCCESSϵͳ
* ˵:     void
*******************************************************************************/
UINT32 zOss_IdentifyThread(ZOSS_THREAD_ID threadID)
{
    if (linux_thread_is_valid(threadID))
        return ZOSS_SUCCESS;
    else
        return ZOSS_ERROR;
}

/*******************************************************************************
* :     ݲṩ߳idø̵̵߳߳ʵʱȼL1Gʹ
* ˵:     
*   ()  thread_id:  ȼ߳id
                priority:   ߳̽õʵʱȼ
*   ()  void
*   ֵ:     ɹZOSS_SUCCESSϵͳ
* ˵:     void
*******************************************************************************/
UINT32 zOss_SetThreadRtPri(ZOSS_THREAD_ID thread_id, UINT32 priority)
{
    linux_thread_t *thread;
    struct sched_param param;

    thread = linux_thread_is_valid(thread_id);
    zOss_AssertEx(thread != NULL, ZOSS_ERROR);

    param.sched_priority = oss_min(priority, MAX_USER_RT_PRIO - 1);
    sched_setscheduler(thread->task, SCHED_FIFO, &param);

    return ZOSS_SUCCESS;
}
#endif

#ifdef _USE_MESSAGE
/*******************************************************************************
* :     ̷ָ߳Ϣ
* ˵:     
*   ()  thread_id:  Ŀ̵߳߳id
                msg_ptr:    Ϣݵָ
                size:       ϢĴСЧ
                time_out:   Ϣĳʱʱ
*   ()  void
*   ֵ:     ɹZOSS_SUCCESS򷵻ZOSS_ERROR
* ˵:     timeoutZOSS_WAIT_FOREVERһֱȴϢͳɹٷأ
                timeoutZOSS_NO_WAITԷϢʧܣֱӷأ
                timeoutǳʱʱ䣬㷽ǽǰϵͳʱtimeoutӣ
                Ϊabs_timeout,ȻһʱֱϢͳɹʱ
*******************************************************************************/
__tcm_func UINT32 zOss_SendMsg(ZOSS_THREAD_ID thread_id, VOID *msg_ptr, UINT32 size, UINT32 timeout)
{
    unsigned long flags;
    linux_thread_t *thread;
    linux_msg_queue_t *msg_queue;
    linux_msg_queue_node_t *msg_queue_node;

    zOss_AssertEx(msg_ptr != NULL, ZOSS_ERROR);

    thread = linux_thread_is_valid(thread_id);
    zOss_AssertEx(thread != NULL, ZOSS_ERROR);

    msg_queue_node = (linux_msg_queue_node_t *)LINUX_THREAD_MSG_ALLOC(sizeof(linux_msg_queue_node_t));
    zOss_AssertEx(msg_queue_node != NULL, ZOSS_ERROR);

    msg_queue_node->msg  = msg_ptr;
    msg_queue_node->size = size;

    msg_queue = &thread->msg_queue;
    raw_spin_lock_irqsave(&msg_queue->lock, flags);
    list_add_tail(&msg_queue_node->node, &msg_queue->head);
#ifdef LINUX_THREAD_MSG_STAT
    msg_queue->count++;
    msg_queue->send_time = cpu_clock(0);
#endif
    raw_spin_unlock_irqrestore(&msg_queue->lock, flags);

#if (LINUX_THREAD_MSG == LINUX_THREAD_MSG_COMPLETION)
    complete(&msg_queue->completion);
#elif (LINUX_THREAD_MSG == LINUX_THREAD_MSG_SEMAPHORE)
    up(&msg_queue->semaphore);
#endif

    return ZOSS_SUCCESS;
}

/*******************************************************************************
* :     Ϣ
* ˵:     
*   ()  time_out:   Ϣĳʱʱ
*   ()  msg_ptr:    ϢָĴŵַ
                size:       ϢݴСĴŵַЧ
*   ֵ:     ɹZOSS_SUCCESS򷵻ZOSS_ERROR
* ˵:     timeoutZOSS_WAIT_FOREVERһֱȴϢͳɹٷأ
                timeoutZOSS_NO_WAITԷϢʧܣֱӷأ
                timeoutǳʱʱ䣬㷽ǽǰϵͳʱtimeoutӣ
                Ϊabs_timeout,ȻһʱֱϢͳɹʱ
*******************************************************************************/
__tcm_func UINT32 zOss_RecvMsg(VOID **msg_ptr, UINT32 *size, UINT32  timeout)
{
    int ret = -1;
    unsigned long flags;
    linux_thread_t *thread;
    linux_msg_queue_t *msg_queue;
    linux_msg_queue_node_t *msg_queue_node;

    zOss_AssertEx(msg_ptr != NULL && size != NULL, ZOSS_ERROR);
    zOss_AssertEx(in_interrupt() == 0x00, ZOSS_ERROR);

    thread = linux_thread_current();
    zOss_AssertEx(thread != NULL, ZOSS_ERROR);

    msg_queue = &thread->msg_queue;
#if (LINUX_THREAD_MSG == LINUX_THREAD_MSG_COMPLETION)
    if (timeout == ZOSS_WAIT_FOREVER) {
        ret = wait_for_completion_killable(&msg_queue->completion);
        if (ret == -ERESTARTSYS)
            do_exit(SIGKILL);
    } else if (timeout == ZOSS_NO_WAIT) {
        ret = try_wait_for_completion(&msg_queue->completion);
        ret = ((ret == 1) ? 0 : 1);
    } else {
        ret = wait_for_completion_timeout(&msg_queue->completion, timeout);
        ret = ((ret == 1) ? 0 : 1);
    }
#elif (LINUX_THREAD_MSG == LINUX_THREAD_MSG_SEMAPHORE)
    if (timeout == ZOSS_WAIT_FOREVER) {
        ret = down_killable(&msg_queue->semaphore);
        if (ret == -EINTR)
            do_exit(SIGKILL);
        zOss_ASSERT(ret == 0);
    } else if (timeout == ZOSS_NO_WAIT) {
        ret = down_trylock(&msg_queue->semaphore);
    } else {
        ret = down_timeout(&msg_queue->semaphore, timeout);
    }
#endif

    if (ret == 0) {
        raw_spin_lock_irqsave(&msg_queue->lock, flags);
        zOss_ASSERT(!list_empty(&msg_queue->head));
#ifdef LINUX_THREAD_MSG_STAT
        zOss_ASSERT(msg_queue->count > 0);
#endif
        msg_queue_node  = list_first_entry(&msg_queue->head, linux_msg_queue_node_t, node);
        *msg_ptr        = msg_queue_node->msg;
        *size           = msg_queue_node->size;
        list_del(&msg_queue_node->node);
#ifdef LINUX_THREAD_MSG_STAT
        msg_queue->count--;
        msg_queue->recv_time = cpu_clock(0);
#endif
        raw_spin_unlock_irqrestore(&msg_queue->lock, flags);

        LINUX_THREAD_MSG_FREE((void *)msg_queue_node);

        return ZOSS_SUCCESS;
    }

    return ZOSS_ERROR;
}

/*******************************************************************************
* :     ȡϢշϢ(ģ)
* ˵:     
*   ()  void              
*   ()  pMonMsgInfo: ȡϢϢĴŵַ
*   ֵ:     void
* ˵:     
*******************************************************************************/
VOID z0ss_GetMsgInfo(T_ZOss_Mon_Msg *pMonMsgInfo)
{
#ifdef _USE_MONITOR
    if (pMonMsgInfo)
    {
        *pMonMsgInfo = gOsa_MsgInfo;
    }
#endif
}

/*******************************************************************************
* :     ڴϢͷ+ػָ
* ˵:     
*   ()  size:   С
*   ()  void
*   ֵ:     ָ
* ˵:     zOss_ThreadRetMsgBufʵ
*******************************************************************************/
__tcm_func VOID* zOss_ThreadGetMsgBuf(UINT32 size)
{
    T_THREAD_MSG_HEAD *msg_head = NULL;

    zOss_AssertEx(size != 0, NULL);

    msg_head = (T_THREAD_MSG_HEAD *)LINUX_THREAD_MSG_ALLOC(THREAD_MSG_SIZE(size));    
    zOss_AssertEx(msg_head != NULL, NULL);
    msg_head->sig_no    = SIGNAL_MSG_NUMBER;
    msg_head->magic     = THREAD_MSG_MAGIC;

    return THREAD_MSG_BUF(msg_head);
}

/*******************************************************************************
* :     ڴطϢͷ+
* ˵:     
*   ()  p_buf:  ָ
*   ()  void
*   ֵ:     void
* ˵:     zOss_ThreadGetMsgBufʵ
*******************************************************************************/
__tcm_func VOID zOss_ThreadRetMsgBuf(VOID *p_buf)
{
    zOss_AssertExN(p_buf != NULL);

    LINUX_THREAD_MSG_FREE(THREAD_MSG_HEAD(p_buf));
}

/*******************************************************************************
* :     thread_id̷߳Ϣ
* ˵:     
*   ()  msg_id:     Ϣid
                p_buf:      ָ
                buf_size:   С
                thread_id:  Ŀ߳id
*   ()  void
*   ֵ:     ɹZOSS_SUCCESS򷵻ZOSS_ERROR
* ˵:     zOss_ThreadRecvMsgʵ
*******************************************************************************/
__tcm_func UINT32 zOss_ThreadSendMsg(UINT32 msg_id, VOID *p_buf, UINT16 buf_size, ZOSS_THREAD_ID thread_id)
{
    unsigned long flags;
    linux_thread_t *thread;
    T_THREAD_MSG_HEAD *msg_head;

    if ((p_buf == NULL && buf_size != 0x00) || (p_buf != NULL && buf_size == 0x00))
        return ZOSS_ERROR;

    thread = linux_thread_is_valid(thread_id);
    zOss_AssertEx(thread != NULL, ZOSS_ERROR);

    if (p_buf == NULL) {
        msg_head = (T_THREAD_MSG_HEAD *)LINUX_THREAD_MSG_ALLOC(THREAD_MSG_SIZE(0));
        zOss_AssertEx(msg_head != NULL, ZOSS_ERROR);

        msg_head->sig_no = SIGNAL_MSG_NUMBER;
        msg_head->magic  = THREAD_MSG_MAGIC;
    } else {
        msg_head = THREAD_MSG_HEAD(p_buf);
        zOss_AssertEx(msg_head->magic == THREAD_MSG_MAGIC, ZOSS_ERROR);
        if (msg_head->magic != THREAD_MSG_MAGIC)
            return ZOSS_ERROR;
    }
    msg_head->id = msg_id;
    msg_head->buf_size = buf_size;
    
    return zOss_SendMsg(thread_id, (VOID *)msg_head, sizeof(msg_head), ZOSS_WAIT_FOREVER);
}

/*******************************************************************************
* :     ߳̽Ϣ
* ˵:     
*   ()  timeout:    Ϣĳʱʱ
*   ()  p_msg_id:   ϢidĴŵַ
                p_buf:      ϢָĴŵַ
                p_buf_size: ϢСĴŵַ
*   ֵ:     ɹZOSS_SUCCESS򷵻ZOSS_ERROR
* ˵:     zOss_ThreadSendMsgʵ
*******************************************************************************/
__tcm_func UINT32 zOss_ThreadRecvMsg(UINT32 *p_msg_id, VOID **p_buf, UINT32 *p_buf_size, UINT32 timeout)
{
    UINT32 ret;
    UINT32 size;
    unsigned long flags;
    linux_thread_t *thread;
    T_THREAD_MSG_HEAD *msg_head;

    zOss_AssertEx(p_msg_id != NULL && p_buf != NULL && p_buf_size != NULL, ZOSS_ERROR);
    zOss_AssertEx(in_interrupt() == 0x00, ZOSS_ERROR);

    thread = linux_thread_current();
    zOss_AssertEx(thread != NULL, ZOSS_ERROR);

    ret = zOss_RecvMsg((VOID **)&msg_head, &size, timeout);
    if (ret != ZOSS_SUCCESS)
        return ret;
    zOss_AssertEx(msg_head->magic == THREAD_MSG_MAGIC, ZOSS_ERROR);

    *p_msg_id   = msg_head->id;
    *p_buf_size = msg_head->buf_size;
    if (msg_head->buf_size == 0x00) {
        LINUX_THREAD_MSG_FREE((void *)msg_head);
        *p_buf = NULL;
    } else
        *p_buf = THREAD_MSG_BUF(msg_head);
    
    return ZOSS_SUCCESS;
}

/*******************************************************************************
* :     ע߳ϢӺ
* ˵:     
*   ()  thread_id:  ߳id
                type:       Ӻ
                dire:       Ӻ
                func:       Ӻָ
*   ()  void
*   ֵ:     ɹZOSS_SUCCESS򷵻ZOSS_ERROR
* ˵:     void
*******************************************************************************/
UINT32 zOss_RegThreadMsgHook(ZOSS_THREAD_ID thread_id, UINT8 type, UINT8 dire, THREAD_MSG_HOOK func)
{
    linux_thread_t *thread;
    THREAD_MSG_HOOK_CONTENT *msg_hook;

    zOss_AssertEx(type > 0 && type <= THREAD_MSG_HOOK_TYPE_MAX && dire <= THREAD_MSG_HOOK_DIRE_MAX && func != NULL, ZOSS_ERROR);
    
    thread = linux_thread_is_valid(thread_id);
    zOss_AssertEx(thread != NULL, ZOSS_ERROR);
    
    msg_hook = find_thread_content(thread_id);
    if (msg_hook == NULL) {
        msg_hook = (THREAD_MSG_HOOK_CONTENT *)zOss_Malloc(sizeof(THREAD_MSG_HOOK_CONTENT));
        zOss_AssertEx(msg_hook != NULL, ZOSS_ERROR);
        
        zOss_Memset(msg_hook, 0x00, sizeof(THREAD_MSG_HOOK_CONTENT));
        msg_hook->thread_id = thread_id;
        zOss_ListAdd(&s_thread_msg_hook_list, &msg_hook->Node);
    }
    msg_hook->dire[type - 1] = dire;
    msg_hook->func[type - 1] = func;
    
    return ZOSS_SUCCESS;
}
#endif

#ifdef _USE_SEMAPHORE
/*******************************************************************************
* :     ź
* ˵:     
*   ()  name_ptr:       źƣЧ
                initial_count:  źĳʼֵ
*   ()  void
*   ֵ:     ɹźľϵͳ
* ˵:     void
*******************************************************************************/
ZOSS_SEMAPHORE_ID zOss_CreateSemaphore(const CHAR *name_ptr, UINT32 initial_count)
{
    struct semaphore *sem;

    sem = (struct semaphore *)kmalloc(sizeof(struct semaphore), GFP_ATOMIC);
    zOss_AssertEx(sem != NULL, NULL);

    sema_init(sem, (int)initial_count);

    return (ZOSS_SEMAPHORE_ID)sem;
}

/*******************************************************************************
* :     ȡź
* ˵:     
*   ()  sem_id:     ڻȡźid
                timeout:    ʱ
*   ()  void
*   ֵ:     ɹZOSS_SUCCESS򷵻ZOSS_ERROR
* ˵:     timeoutZOSS_WAIT_FOREVERһֱȴϢͳɹٷأ
                timeoutZOSS_NO_WAITԷϢʧܣֱӷأ
                timeoutǳʱʱ䣬㷽ǽǰϵͳʱtimeoutӣ
                Ϊabs_timeout,ȻһʱֱϢͳɹʱ
*******************************************************************************/
__tcm_func UINT32 zOss_GetSemaphore(ZOSS_SEMAPHORE_ID sem_id, UINT32 timeout)
{
    int ret = 0x00;
    struct semaphore *sem = (struct semaphore *)sem_id;

    zOss_AssertEx(sem != NULL, ZOSS_ERROR);

    if (timeout == ZOSS_WAIT_FOREVER) {
        ret = down_killable(sem);
        if (ret == -EINTR)
            do_exit(SIGKILL);
    } else if (timeout == ZOSS_NO_WAIT)
        ret = down_trylock(sem);
    else
        ret = down_timeout(sem, timeout);

    if (ret == 0x00)
        return ZOSS_SUCCESS;
    else
        return ZOSS_ERROR;
}

/*******************************************************************************
* :     ͷź
* ˵:     
*   ()  sem_id:     ͷŵźid
*   ()  void
*   ֵ:     ɹZOSS_SUCCESSϵͳ
* ˵:     void
*******************************************************************************/
__tcm_func UINT32 zOss_PutSemaphore(ZOSS_SEMAPHORE_ID sem_id)
{
    struct semaphore *sem = (struct semaphore *)sem_id;

    zOss_AssertEx(sem != NULL, ZOSS_ERROR);

    //resched_task(current);

    up(sem);

    return ZOSS_SUCCESS;
}

/*******************************************************************************
* :     ȡźĵǰֵ
* ˵:     
*   ()  sem_id:     ڱȡֵźid
*   ()  void
*   ֵ:     źĵǰֵ
* ˵:     void
*******************************************************************************/
UINT32 zOss_GetSemaphoreCount(ZOSS_SEMAPHORE_ID sem_id)
{
    struct semaphore *sem = (struct semaphore *)sem_id;

    zOss_AssertEx(sem != NULL, ZOSS_ERROR);

    return sem->count;
}

/*******************************************************************************
* :     ɾź
* ˵:     
*   ()  sem_id:     ɾźid
*   ()  void
*   ֵ:     ɹZOSS_SUCCESSϵͳ
* ˵:     ҪͷzOss_CreateSemaphoreڴռ䣬ᵼ
                й¶
*******************************************************************************/
UINT32 zOss_DeleteSemaphore(ZOSS_SEMAPHORE_ID sem_id)
{
    struct semaphore *sem = (struct semaphore *)sem_id;

    zOss_AssertEx(sem != NULL, ZOSS_ERROR);

    zOss_AssertExA(list_empty(&sem->wait_list), kfree((void *)sem), ZOSS_ERROR);

    kfree((void *)sem);

    return ZOSS_SUCCESS;
}
#endif

#ifdef _USE_MUTEX

/*******************************************************************************
* :     
* ˵:     
*   ()  name_ptr:   
                priority_inherit:   ԣZOSS_INHERIT֮߳䰴
                ȼ˳ȡ壻ZOSS_NO_INHERIT򰴵ȴ˳ȡ
                
*   ()  void
*   ֵ:     ɹشĻϵͳ
* ˵:     void
*******************************************************************************/
ZOSS_MUTEX_ID zOss_CreateMutex(const CHAR *name_ptr, UINT32 priority_inherit)
{
    linux_mutex_t *mutex;

    zOss_AssertEx(priority_inherit == ZOSS_NO_INHERIT || priority_inherit == ZOSS_INHERIT, NULL);

    mutex = (linux_mutex_t *)kmalloc(sizeof(linux_mutex_t), GFP_ATOMIC);
    zOss_AssertEx(mutex != NULL, NULL);

    mutex->name = name_ptr;
#ifdef LINUX_MUTEX_NESTING
    atomic_set(&mutex->nesting, 0x00);
#endif
    mutex_init(&mutex->raw_mutex);

    return (ZOSS_MUTEX_ID)mutex;
}

/*******************************************************************************
* :     ȡ
* ˵:     
*   ()  mutex_id:   ȡĻid
                timeout:    ȡĳʱʱ
*   ()  void
*   ֵ:     ɹZOSS_SUCCESS򷵻ZOSS_ERROR
* ˵:     void
*******************************************************************************/
__tcm_func UINT32 zOss_GetMutex( ZOSS_MUTEX_ID mutex_id,  UINT32 timeout)
{
    int ret = false;
    linux_mutex_t *mutex = (linux_mutex_t *)mutex_id;

    zOss_AssertEx(mutex != NULL, ZOSS_ERROR);

#ifdef LINUX_MUTEX_NESTING
# ifdef CONFIG_PREEMPT_RT_FULL
    if (rt_mutex_owner(&mutex->raw_mutex.lock) == current) {
# else
    if (mutex->raw_mutex.owner == current) {
# endif
        atomic_inc(&mutex->nesting);
        return ZOSS_SUCCESS;
    }
#endif

    if (timeout == ZOSS_WAIT_FOREVER) {
        ret = mutex_lock_killable(&mutex->raw_mutex);
        if (ret == 0)
            return ZOSS_SUCCESS;
        else if (ret == -EINTR)
            do_exit(SIGKILL);
        else if (ret == -EDEADLK)
            panic("mutex_id:%p dead lock!\n", (void *)mutex);
        else
            panic("mutex_id:%p error!\n", (void *)mutex);
    } else if (timeout == ZOSS_NO_WAIT) {
        ret = mutex_trylock(&mutex->raw_mutex);
    } else {
        while (timeout--) {
            ret = mutex_trylock(&mutex->raw_mutex);
            if (ret == true)
                break;
            msleep(1);
        }
    }

    if (ret == true)
        return ZOSS_SUCCESS;
    else
        return ZOSS_ERROR;
}

/*******************************************************************************
* :     ͷŻ
* ˵:     
*   ()  mutex_id:   ͷŵĻid
*   ()  void
*   ֵ:     ɹZOSS_SUCCESSϵͳ
* ˵:     void
*******************************************************************************/
__tcm_func UINT32 zOss_PutMutex(ZOSS_MUTEX_ID mutex_id)
{
    linux_mutex_t *mutex = (linux_mutex_t *)mutex_id;

    zOss_AssertEx(mutex != NULL, ZOSS_ERROR);

#ifdef LINUX_MUTEX_NESTING
    if (atomic_read(&mutex->nesting)) {
# ifdef CONFIG_PREEMPT_RT_FULL
        zOss_ASSERT(rt_mutex_owner(&mutex->raw_mutex.lock) == current);
# else
        zOss_ASSERT(mutex->raw_mutex.owner == current);
# endif
        atomic_dec(&mutex->nesting);
        return ZOSS_SUCCESS;
    }
#endif

    mutex_unlock(&mutex->raw_mutex);

    return ZOSS_SUCCESS;
}

/*******************************************************************************
* :     ٻ
* ˵:     
*   ()  mutex_id:   ٵĻid
*   ()  void
*   ֵ:     ɹZOSS_SUCCESSϵͳ
* ˵:     ҪͷzOss_CreateMutexڴռ䣬ᵼڴ
                й¶
*******************************************************************************/
UINT32 zOss_DeleteMutex(ZOSS_MUTEX_ID mutex_id)
{
    linux_mutex_t *mutex = (linux_mutex_t *)mutex_id;

    zOss_AssertEx(mutex != NULL, ZOSS_ERROR);

#ifdef CONFIG_PREEMPT_RT_FULL
# if (LINUX_VERSION_CODE < KERNEL_VERSION(3,14,0))
    if (!plist_head_empty(&mutex->raw_mutex.lock.wait_list))
    {
        zOss_ASSERT(0);
        mutex_destroy(&mutex->raw_mutex);
        kfree((void *)mutex);
        return ZOSS_ERROR;
    }
# else
    if (!RB_EMPTY_ROOT(&mutex->raw_mutex.lock.waiters))
    {
        zOss_ASSERT(0);
        mutex_destroy(&mutex->raw_mutex);
        kfree((void *)mutex);
        return ZOSS_ERROR;
    }
# endif
#else
    if (!list_empty(&mutex->raw_mutex.wait_list))
    {
        zOss_ASSERT(0);
        mutex_destroy(&mutex->raw_mutex);
        kfree((void *)mutex);
        return ZOSS_ERROR;
    }
#endif

    mutex_destroy(&mutex->raw_mutex);
    kfree((void *)mutex);
    return ZOSS_SUCCESS;
}
#endif

#ifdef _USE_EVENT

/*******************************************************************************
* :      ¼־
* ˵:     
*   ()  name:   ¼־ƣЧ               
*   ()  void
*   ֵ:     ɹش ¼־ϵͳ
* ˵:     void
*******************************************************************************/
ZOSS_EVENT_ID zOss_CreateEvent(const CHAR *name_ptr)
{
    zOss_AssertEx(0, NULL);
}

/*******************************************************************************
* : zOss_GetEvent
* : ȡ¼
* ˵: (IN)
                event_id:¼id
                events:32λ¼
                get_options:λȡ¼
                    ZOSS_EVENTS_AND:ʾeventsָ¼ǶҪ
                    ZOSS_EVENTS_OR:ʾeventsָ¼ֻҪκһ
                                   ϼ
                    ZOSS_EVENTS_AND_CLEAR:ʾZOSS_EVENTS_ANDʽȡ,
                                          ¼Ϊ0
                    ZOSS_EVENTS_OR_CLEAR:ʾZOSS_EVENTS_ORʽȡ,
                                         ¼Ϊ0
                pEventsReceived:Żȡ¼־ָ,Ϊ
                timeout:ʱ.ZOSS_WAIT_FOREVER, ZOSS_NO_WAIT,ʱ
                        λ
*   ֵ: ɹ:ZOSS_SUCCESS;ʧ:ZOSS_ERROR
* ˵:
*******************************************************************************/
UINT32 zOss_GetEvent(ZOSS_EVENT_ID event_id, UINT32  events, UINT32 getOptions,
                     UINT32 *pEventsReceived, UINT32 timeout)
{
    zOss_AssertEx(0, ZOSS_ERROR);
}

/*******************************************************************************
* : zOss_SetEvent
* : ¼¼־λ뵱ǰ¼λ
* ˵: (IN)
                 eventId:¼id
                 events:32-bit unsigned variable that represents the 
                        requested event flags.
                 setOptions:ø¼
                            ZOSS_EVENTS_AND: eventsʹã32λ
                                             㹦ܡʱeventsΪ0
                            ZOSS_EVENTS_OR eventsͬǰֵл㡣
*   ֵ: ɹ:ZOSS_SUCCESS;ʧ:ZOSS_ERROR
* ˵:
*******************************************************************************/
UINT32 zOss_SetEvent(ZOSS_EVENT_ID event_id, UINT32  events, UINT32 setOptions)
{
    zOss_AssertEx(0, ZOSS_ERROR);
}

/*******************************************************************************
* : zOss_DeleteEvent
* : ɾ¼
* ˵: (IN)
                event_id:¼id
*   ֵ: ɹ:ZOSS_SUCCESS;ʧ:ZOSS_ERROR
* ˵:
*******************************************************************************/
UINT32 zOss_DeleteEvent(ZOSS_EVENT_ID event_id)
{
    zOss_AssertEx(0, ZOSS_ERROR);
}

/*******************************************************************************
* : zOss_QueryEvent
* :ѯ¼鵱ǰ־ֵ
* ˵: (IN)	
                event_id:¼id
*   ֵ: ¼鵱ǰ־ֵ
* ˵:  
*******************************************************************************/ 
UINT32 zOss_QueryEvent(ZOSS_EVENT_ID event_id)
{
    zOss_AssertEx(0, ZOSS_ERROR);
}

/*******************************************************************************
* : zOss_WaitingEvent
* :ѯǷ̵߳ȴ¼
* ˵: (IN)
                event_id:¼id
*   ֵ: ̵߳ȴ:True ;̵߳ȴ:False
* ˵:  
*******************************************************************************/ 
BOOL zOss_WaitingEvent(ZOSS_EVENT_ID event_id)
{
    zOss_AssertEx(0, false);
}
#endif

/*******************************************************************************
* :     ȡϵͳĵǰδ
* ˵:     
*   ()  void
*   ()  void
*   ֵ:     ϵͳĵǰδ
* ˵:     void
*******************************************************************************/
UINT32 zOss_GetTickCount(VOID)
{
#if 0
    return jiffies;
#else
    return (UINT32)gTimer_CurTime;
#endif
}

/*******************************************************************************
* :     OSEϵͳе̴߳TOSֻڴжϷ
* ˵:     
*   ()  беע
*   ()  void
*   ֵ:     жϴ̵ľ
* ˵:     Ŀǰģʹô˽ӿڣҪ˺OSEϵͳ
                ֲ
                1) ˺ֻڴжϷ̣
                2) ˺жеã
                3) ʧܣϵͳԣ
                4) Ƽģеô˺ӿڣ
*******************************************************************************/
PROCESS create_process(enum PROCESS_TYPE        proc_type,      /* ֻ߳ͣΪOS_INT_PROC  */
                       const char               *name,          /* Դ˲                   */
                       OSENTRYPOINT             *entrypoint,    /* ߳ڵ                   */
                       OSADDRESS                stack_size,     /* Դ˲                   */
                       OSPRIORITY               priority,       /* Դ˲                   */
                       OSTIME                   timeslice,      /* Դ˲                   */
                       PROCESS                  block,          /* Դ˲                   */
                       struct OS_redir_entry    *router_table,  /* Դ˲                   */
                       OSVECTOR                 vec,            /* ж                   */
                       OSUSER                   user)           /* Ϊ0                      */
{
    return ZOSS_ERROR;
}

/*******************************************************************************
* :     OSEϵͳе߳ɾ
* ˵:     
*   ()  id:     ɾ̵߳߳id
*   ()  void
*   ֵ:     void
* ˵:     1) ̴߳ʧܣϵͳԣ
                2) Ƽģеô˺ӿڣ
*******************************************************************************/
void kill_proc(PROCESS id)
{
    zOss_ASSERT(0);
}

/*******************************************************************************
* :     OSAģʼ,TOSϵͳʱ
* ˵:     
*   ()  void
*   ()  void
*   ֵ:     ɹZOSS_SUCCESSϵͳ
* ˵:     ظʼϵͳ
*******************************************************************************/
UINT32 OSA_Init(VOID)
{
    static BOOL init_flag   = FALSE;
    UINT32      ret         = 0x00;

    zOss_AssertEx(init_flag == FALSE, ZOSS_ERROR);

#ifdef _UB_USE_POOL
    pool_init();
#endif

    ret = MEM_Init();
    zOss_AssertEx(ret == ZOSS_SUCCESS, ZOSS_ERROR);

#ifdef _USE_OSS_FS
    FS_Init();
#endif

    //Osa_SysErrHndInit();
    
#ifdef _USE_MONITOR
    gOsa_MsgInfo.num = 0;
    gOsa_MsgInfo.ele = (T_ZOss_Mon_Msg_Ele *)zOss_GetUB(OSS_MON_INFO_MAX_NUMBER * sizeof(T_ZOss_Mon_Msg_Ele));
    zOss_AssertEx(gOsa_MsgInfo.ele != NULL, ZOSS_ERROR);
#endif

#ifdef _USE_PSM
    //linux_stat_register(3000, linux_stat_osa_callback);
#endif

    ret = TIMER_Init();
    zOss_AssertEx(ret == ZOSS_SUCCESS, ZOSS_ERROR);

#ifdef CONFIG_SINGLECORE
    zOss_NvCheck();
#endif

    init_flag = TRUE;

    return ZOSS_SUCCESS;
}

/*******************************************************************************
* :     ֤һ߳ǷЧ
* ˵:     
*   ()  thread_id:  ֤߳id
*   ()  void
*   ֵ:     ߳ЧZOSS_SUCCESSϵͳ
* ˵:     void
*******************************************************************************/
UINT32 OSA_IdentifyThread(ZOSS_THREAD_ID threadID)
{
    if (linux_thread_is_valid(threadID))
        return ZOSS_SUCCESS;
    else
        return ZOSS_ERROR;
}

/*******************************************************************************
* :     ȡ̵߳CPUռ
* ˵:     
*   ()  thread_id:  ߳id
*   ()  void
*   ֵ:     ̵߳CPUռ
* ˵:     void
*******************************************************************************/
#ifdef CONFIG_ACCURATE_CPU_PERCENT
FLOAT Osa_GetProcessCPU(ZOSS_THREAD_ID thread_id)
{
    struct task_struct    *task      = NULL;
    
    if (gOsa_SwapTimeFlag) {
        read_lock(&tasklist_lock);
        for_each_processex(task) {
            if((void *)task == (void *)thread_id){
                read_unlock(&tasklist_lock);
                return task->ac_cpupercent;
        }
    }
        read_unlock(&tasklist_lock);
        return 0;
    }
    return 0;
}
#else
FLOAT Osa_GetProcessCPU(ZOSS_THREAD_ID thread_id)
{
    linux_thread_t *thread;
    T_ZOsa_ThreadUserArea *user_area;
    
    if (gOsa_SwapTimeFlag) {
        thread = linux_thread_is_valid(thread_id);
        if (thread) {
            user_area = (T_ZOsa_ThreadUserArea *)linux_thread_get_user_area(thread_id);
            zOss_AssertEx(user_area != NULL, 0);
            if (user_area == NULL)
                return 0;

            return user_area->cpupercent;
        }
    }

    return 0;
}
#endif

/*******************************************************************************
* :     ȡ߳ûݿռָ
* ˵:     
*   ()  thread_id:  ȡûݿռָ߳id
                bupdate:    Ϊ棬ûݿռ䣻򷵻ûݿռָ
*   ()  void
*   ֵ:     ̵߳ûݿռָ
* ˵:     void
*******************************************************************************/
T_ZOsa_ThreadUserArea *Osa_GetThreadUserArea(ZOSS_THREAD_ID thread_id, BOOL bupdate)
{
    linux_thread_t *thread;
    struct task_struct *task;
    T_ZOsa_ThreadUserArea *user_area;

    thread = linux_thread_is_valid(thread_id);
    if (thread) {
        user_area = &thread->user_area;
        zOss_AssertEx(user_area != NULL, NULL);
    } else
        return NULL;
    
    if (bupdate == false)
        return user_area;

    task = thread->task;
    user_area->topstack = thread_saved_sp(task);
    user_area->maxstack = zOss_GetThreadStackUsed(thread_id);
    user_area->priority = (UINT8)task->prio;
    if (user_area->runtime > 0)
        user_area->RunTimeInMs = (UINT32)((FLOAT)user_area->runtime / 1000);

    switch (task->state) {
        case TASK_RUNNING:
            if (task == current)
                user_area->runstatus = ZOSS_OS_RUN;
            else
                user_area->runstatus = ZOSS_OS_READY;
            break;

        default:
            user_area->runstatus = ZOSS_OS_BLOCK;
            break;
    }
    
    return user_area;
}

/*******************************************************************************
* :     ȡ̵߳߳id
* ˵:     
*   ()  void
*   ()  threadarray:    ߳idݵָ
*   ֵ:     ̵߳
* ˵:     ˺ڴռ䣬ʹͷţڴй¶
*******************************************************************************/
UINT32 Osa_GetAllThreadId(ZOSS_THREAD_ID *threadarray[])
{
    UINT32 count;
    linux_thread_t **thread_array;

    zOss_AssertEx(threadarray != NULL, ZOSS_ERROR);

    count = linux_thread_count_all_thread();
    if (count == 0x00) {
        *threadarray = NULL;
        return 0x00;
    }

    thread_array = (linux_thread_t **)zOss_Malloc(count*sizeof(linux_thread_t *));
    if (thread_array == NULL) {
        *threadarray = NULL;
        zOss_ASSERT(0);
        return 0x00;
    }

    linux_thread_get_all_thread(thread_array);
    *threadarray = (ZOSS_THREAD_ID *)thread_array;

    return count;
}

#ifdef CONFIG_ACCURATE_CPU_PERCENT
/*******************************************************************************
* :     ӡ߳ʱϢ
* ˵:     
*   ()  pid:    ӡϢ߳id
*   ()  void
*   ֵ:     ɹZOSS_SUCCESSʧܣZOSS_ERROR
* ˵:     void
*******************************************************************************/
UINT32 Osa_DisplayThreadExecInfo(PROCESS pid)
{
    zOss_Printf(SUBMDL_EXCEP, PRINT_LEVEL_ABNORMAL, "Linuxݲָ֧ù\n");
    return ZOSS_SUCCESS;
}

/*******************************************************************************
* :     ӡ̵߳ʱϢ
* ˵:     
*   ()  type:   
*   ()  void
*   ֵ:     ɹZOSS_SUCCESSʧܣZOSS_ERROR
* ˵:     void
*******************************************************************************/
UINT32 Osa_DisplayThreadsExecInfo(UINT32 type)
{
    linux_thread_sched_stat(type);
    return ZOSS_SUCCESS;
}
#else
/*******************************************************************************
* :     ӡ߳ʱϢ
* ˵:     
*   ()  pid:    ӡϢ߳id
*   ()  void
*   ֵ:     ɹZOSS_SUCCESSʧܣZOSS_ERROR
* ˵:     void
*******************************************************************************/
UINT32 Osa_DisplayThreadExecInfo(PROCESS pid)
{
    T_ZOsa_ThreadUserArea *user_area = NULL;
    
    user_area = Osa_GetThreadUserArea((ZOSS_THREAD_ID)pid, TRUE);
    if (user_area == NULL)
    {
        return ZOSS_ERROR;
    }
        
    zOss_Printf(SUBMDL_EXCEP, PRINT_LEVEL_NORMAL, "%-28s  %-16s  %16s  %16s  %16s  %16s",
                "ThreadName", "ThreadID", "RunTimeInMs", "CpuPercent", "MsgNum", "RunCount");
    if (user_area->threadid) 
    {
        zOss_Printf(SUBMDL_EXCEP, PRINT_LEVEL_NORMAL, "%-28s  0x%08x  %16u  %16f  %16u  %16u",
                    user_area->threadname,
                    user_area->threadid,
                    user_area->RunTimeInMs,
                    user_area->cpupercent,
                    user_area->msgnum,
                    user_area->runcount);
    }
    else 
    {
        zOss_Printf(SUBMDL_EXCEP, PRINT_LEVEL_ABNORMAL, "ûҵ߳0x%08x", (UINT32)pid);
        return ZOSS_ERROR;
    }
    
    return ZOSS_SUCCESS;
}

/*******************************************************************************
* :     ӡ̵߳ʱϢ
* ˵:     
*   ()  type:   
*   ()  void
*   ֵ:     ɹZOSS_SUCCESSʧܣZOSS_ERROR
* ˵:     void
*******************************************************************************/
UINT32 Osa_DisplayThreadsExecInfo(UINT32 type)
{
    UINT32                  cnt             = 0;
#ifdef _USE_PSM
    UINT32                  freq            = 0;
#endif
    UINT32                  thread_num      = 0;
    FLOAT                   cpu_percent     = 0;
    UINT32                  run_time        = 0;
    ZOSS_THREAD_ID          *thread_array   = NULL;
#ifdef _OS_TOS
    cyg_tick_count_t        total_time      = 0;
#endif
    T_ZOsa_ThreadUserArea   *user_area      = NULL;
    
    thread_num = Osa_GetAllThreadId(&thread_array);
    if (thread_num == 0 || thread_array == NULL)
    {
        return ZOSS_ERROR;
    }
    
#ifdef _USE_PSM
    zOss_Printf(SUBMDL_EXCEP, PRINT_LEVEL_NORMAL, "\t**********************Current CPU Frequency is %u**********************",  zDrvPow_GetPsCoreFreq());
#endif
    zOss_Printf(SUBMDL_EXCEP, PRINT_LEVEL_NORMAL, "%-28s %-16s %16s %16s %16s %16s",
                "ThreadName", "ThreadID", "RunTimeInMs", "CpuPercent", "MsgNum", "RunCount");
    for (cnt = 0; cnt < thread_num; cnt++)
    {
        user_area = Osa_GetThreadUserArea(thread_array[cnt], TRUE);
        if (user_area == NULL)
        {        
            continue;
        }

        if (type & SUP_THREAD_STATISTIC_INFO_BIT)   /* ͳָʱڵִ߳,ʱĻȡʹϵͳʱtick,λ,Ƚϵ */
        {
#ifdef CYGOPT_KERNEL_EXTEND_THREAD_STATISTIC_TIMESLICE
            run_time    = (UINT32)cyg_thread_get_statistic_timeslice((cyg_handle_t)thread_array[cnt]);
            total_time  = cyg_current_statistic_time();
            cpu_percent = (FLOAT)run_time * 100 / total_time;
            run_time    = (UINT32)((FLOAT)run_time * (gOsa_SysCpuFreq / 1000));
#endif
        }
        else    /* ʱˢµִ߳,ʱĻȡĺ,λ΢,Ƚϸ */
        {
            run_time = user_area->RunTimeInMs;
            cpu_percent = user_area->cpupercent;
        }
        
        if ((type & SUP_THREAD_LIVE_BIT) && run_time == 0)
        {
            continue;   /* ûл߳ */
        }
        else if ((type & SUP_THREAD_LAZY_BIT) && run_time != 0)
        {
            continue;   /* ߳ */
        }
        
        zOss_Printf(SUBMDL_EXCEP, PRINT_LEVEL_NORMAL, "%-28s  0x%08x  %16u  %16f  %16u  %16u",
                    user_area->threadname,
                    user_area->threadid,
                    run_time,
                    cpu_percent,
                    user_area->msgnum,
                    user_area->runcount);
    }
    
    zOss_Free(thread_array);
    
    return ZOSS_SUCCESS;
}
#endif

/*******************************************************************************
* :     ߳л¼
* ˵:     
*   ()  enableRunTime:  Ƿ¼ʱϢ
*   ()  void
*   ֵ:     void
* ˵:     void
*******************************************************************************/
VOID Osa_SwapCtl(BOOL enableRunTime)
{    
    if ((enableRunTime == gOsa_SwapTimeFlag))
    {
        return;
    }
    
    if ((enableRunTime == TRUE) && (gOsa_SwapTimeFlag == FALSE)) 
    {
        if (gOsa_AllTaskIdArray == NULL)
        {
            T_OSS_PARAM *pPlatCfg;
            
            pPlatCfg = zOss_GetOssCfg();
            gOsa_AllTaskIdArray = (ZOSS_TASK_ID *)zOss_Malloc(sizeof(ZOSS_TASK_ID) * pPlatCfg->TaskCfg.max_task_num);
            zOss_AssertExN(gOsa_AllTaskIdArray != NULL);
        }
        
        gOsa_CpuStartTime = Osa_HwTimeRead();
        gOsa_SwapLastTime = gOsa_CpuStartTime;
    }
    
    gOsa_SwapTimeFlag   = enableRunTime;

#ifdef CONFIG_ACCURATE_CPU_PERCENT
    if(enableRunTime)
    {
        set_task_swaphook(Osa_swapin_handler, Osa_swapout_handler);
    }
    else
    {
        set_task_swaphook(NULL, NULL);
    }
#endif

}

/*******************************************************************************
* :     ϵͳ̺߳CPUռ
* ˵:     
*   ()  void
*   ()  void
*   ֵ:     void
* ˵:     void
*******************************************************************************/
VOID Osa_UpdateCpu(VOID)
{
    if (gOsa_SwapTimeFlag) 
    {   
        preempt_disable();
        Osa_UpdateThreadCpu();        
        //Osa_UpdateTaskCpu();

        gOsa_CpuStartTime = Osa_HwTimeRead();
        gOsa_SwapLastTime = gOsa_CpuStartTime;
        preempt_enable();
    }
}

#ifdef CONFIG_ACCURATE_CPU_PERCENT
/*******************************************************************************
* :     ӡ̵߳ĵͳϢ
* ˵:     
*   ()  void
*   ()  void
*   ֵ:     void
* ˵:     void
*******************************************************************************/
void linux_thread_sched_stat(int type)
{
    #define SCHED_STAT_STR_LEN  ((16 + 1) * 9)
    char *buf;
    char   percent[12] = {0};
    struct task_struct *task;
    unsigned long total = 0, cnt = 0;
    unsigned int  integer = 0, decimal = 0;
    linux_thread_sched_stat_t *sched_stat;

    zOss_Printf(SUBMDL_SCHE, PRINT_LEVEL_NORMAL,
                "%-16s %16s %16s %16s %16s %16s %16s",
                "thread_name", "pid", "sum_exec_runtime", "sched_policy",
                "priority", "rt_priority", "cpu_percent");

    read_lock(&tasklist_lock);
    for_each_processex(task)
        total++;
    read_unlock(&tasklist_lock);

    buf = (char *)kzalloc(total*SCHED_STAT_STR_LEN, GFP_ATOMIC);
    zOss_ASSERT(buf != NULL);

    sched_stat = (linux_thread_sched_stat_t *)kzalloc(total*sizeof(linux_thread_sched_stat_t), GFP_ATOMIC);
    zOss_ASSERT(sched_stat != NULL);

    if(type == 0){
    read_lock(&tasklist_lock);
        for_each_processex(task) {
            integer = (unsigned int)task->ac_cpupercent;
            decimal = (unsigned int)((task->ac_cpupercent - integer) * 100);
            snprintf(percent, sizeof(percent), "%u.%02u", integer, decimal);
            snprintf(buf + cnt*SCHED_STAT_STR_LEN, SCHED_STAT_STR_LEN,
                    "%-16s %16d %16llu %16s %16d %16u %16s\n",
                    &task->comm[0],
                    task->pid,
                    (unsigned long long)task->se.sum_exec_runtime,
                    linux_thread_sched_policy[task->policy],
                    task->prio, task->rt_priority, percent);
            (sched_stat + cnt)->str = buf + cnt*SCHED_STAT_STR_LEN;
            (sched_stat + cnt)->keyval = (u64)task->ac_cpupercent;
            if (++cnt == total)
                break;
        }
        read_unlock(&tasklist_lock);

        sort((void *)sched_stat, total, sizeof(linux_thread_sched_stat_t),
             linux_thread_sched_stat_cmp, linux_thread_sched_stat_swap);

        for (cnt = 0x00; cnt < total; cnt++)
            zOss_Printf(SUBMDL_SCHE, PRINT_LEVEL_NORMAL, "%s", (sched_stat + cnt)->str);
    }        
    else if(type == SUP_THREAD_LIVE_BIT){
        read_lock(&tasklist_lock);
        for_each_processex(task) {
            if(task->ac_cpupercent > 0){
                integer = (unsigned int)task->ac_cpupercent;
                decimal = (unsigned int)((task->ac_cpupercent - integer) * 100);
                snprintf(percent, sizeof(percent), "%u.%02u", integer, decimal);
                snprintf(buf + cnt*SCHED_STAT_STR_LEN, SCHED_STAT_STR_LEN,
                        "%-16s %16d %16llu %16s %16d %16u %16s\n",
                        &task->comm[0],
                        task->pid,
                        (unsigned long long)task->se.sum_exec_runtime,
                        linux_thread_sched_policy[task->policy],
                        task->prio, task->rt_priority, percent);
                (sched_stat + cnt)->str = buf + cnt*SCHED_STAT_STR_LEN;
                (sched_stat + cnt)->keyval = (u64)task->ac_cpupercent;
                if (++cnt == total)
                    break;
            }
        }
        read_unlock(&tasklist_lock);

        sort((void *)sched_stat, cnt, sizeof(linux_thread_sched_stat_t),
             linux_thread_sched_stat_cmp, linux_thread_sched_stat_swap);
        total = cnt;
        for (cnt = 0x00; cnt < total; cnt++)
            zOss_Printf(SUBMDL_SCHE, PRINT_LEVEL_NORMAL, "%s", (sched_stat + cnt)->str);
    }
    else
    {
        zOss_Printf(SUBMDL_SCHE, PRINT_LEVEL_NORMAL, "unsupported param--type=%d", type);
    }

    kfree((void *)buf);
    kfree((void *)sched_stat);
}

/*******************************************************************************
* :     ̵߳CPUռͳϢ
* ˵:     
*   ()  void
*   ()  void
*   ֵ:     void
* ˵:     void
*******************************************************************************/
void linux_reset_cpupinfo(void)
{
    struct task_struct *task;
    
    read_lock(&tasklist_lock);
    for_each_processex(task) {
        task->ac_rtime = 0;
        task->ac_cpupercent = 0;
    }
    read_unlock(&tasklist_lock);
}

/*******************************************************************************
* :     ȡӦID(ýӿڿԲѯϵͳе񣬲
*               OSS㴴߳)
* ˵:     
*   ()  
*   ()  void
*   ֵ:     ID(struct task_struct *)
* ˵:     void
*******************************************************************************/
void *linux_get_threadID_by_name(const char *name)
{
    void               *threadID = NULL;
    struct task_struct *task     = NULL;
    
    read_lock(&tasklist_lock);
    for_each_processex(task){
        if(strcmp(task->comm, name) == 0){
            threadID = (void *)task;
            break;
        }
    }
    read_unlock(&tasklist_lock);
    return threadID;
}
#else
/*******************************************************************************
* :     ӡ̵߳ĵͳϢ
* ˵:     
*   ()  void
*   ()  void
*   ֵ:     void
* ˵:     void
*******************************************************************************/
void linux_thread_sched_stat(int type)
{
#ifdef CONFIG_SCHEDSTATS
    #define SCHED_STAT_STR_LEN  ((16 + 1) * 7)
    char *buf;
    struct task_struct *task;
    unsigned long total = 0, cnt = 0;
    linux_thread_sched_stat_t *sched_stat;

    zOss_Printf(SUBMDL_SCHE, PRINT_LEVEL_NORMAL,
                "%-16s %16s %16s %16s %16s %16s %16s %16s",
                "thread_name", "pid", "sum_exec_runtime", "run_delay", "run_count",
                "sched_policy", "priority", "rt_priority");

    read_lock(&tasklist_lock);
    for_each_process(task)
        total++;
    read_unlock(&tasklist_lock);

    buf = (char *)kzalloc(total*SCHED_STAT_STR_LEN, GFP_ATOMIC);
    zOss_ASSERT(buf != NULL);

    sched_stat = (linux_thread_sched_stat_t *)kzalloc(total*sizeof(linux_thread_sched_stat_t), GFP_ATOMIC);
    zOss_ASSERT(sched_stat != NULL);

    read_lock(&tasklist_lock);
    for_each_process(task) {
        snprintf(buf + cnt*SCHED_STAT_STR_LEN, SCHED_STAT_STR_LEN,
                "%-16s %16d %16llu %16llu %16lu %16s %16d %16u\n",
                &task->comm[0],
                task->pid,
                (unsigned long long)task->se.sum_exec_runtime,
                (unsigned long long)task->sched_info.run_delay,
                task->sched_info.pcount,
                linux_thread_sched_policy[task->policy],
                task->prio, task->rt_priority);
        (sched_stat + cnt)->str = buf + cnt*SCHED_STAT_STR_LEN;
        (sched_stat + cnt)->keyval = task->se.sum_exec_runtime;

        if (++cnt == total)
            break;
    }
    read_unlock(&tasklist_lock);

    sort((void *)sched_stat, total, sizeof(linux_thread_sched_stat_t),
         linux_thread_sched_stat_cmp, linux_thread_sched_stat_swap);

    for (cnt = 0x00; cnt < total; cnt++)
        zOss_Printf(SUBMDL_SCHE, PRINT_LEVEL_NORMAL, "%s", (sched_stat + cnt)->str);

    kfree((void *)buf);
    kfree((void *)sched_stat);
#endif
}

/*******************************************************************************
* :     ̵߳CPUռͳϢ
* ˵:     
*   ()  void
*   ()  void
*   ֵ:     void
* ˵:     void
*******************************************************************************/
void linux_reset_cpupinfo(void)
{
    return;
}

/*******************************************************************************
* :     ȡӦID(ýӿڿԲѯϵͳе񣬲
*               OSS㴴߳)
* ˵:     
*   ()  
*   ()  void
*   ֵ:     ID(struct task_struct *)
* ˵:     void
*******************************************************************************/
void *linux_get_threadID_by_name(const char *name)
{
    return NULL;
}
#endif

/**************************************************************************
* :     zOss_DumpStack
* ˵:     
*   ()  to:   źùϵĿռ
*   ()  size: ռĴСֽڣ
*   ()  void
*   ֵ:     void
* ˵:     ֧GCC32λ
**************************************************************************/
VOID zOss_DumpStack(VOID *to, UINT32 size)
{
    return;
}

VOID zOss_IoRemapPages(VOID *base, UINT32 size)
{
    unsigned long start;
    const struct mem_type *mtype;

    if (!base || ((unsigned long)base & (PAGE_SIZE - 1)) || size == 0 || (size & (PAGE_SIZE - 1)))
        zOss_AssertExN(0);

    mtype = get_mem_type(MT_DEVICE);
    for(start = (unsigned long)base; start < (unsigned long)base + size; start += PAGE_SIZE)
    {
        if (ioremap_page(start, __pa(start), mtype) != 0)
            zOss_AssertExN(0);
    }
}

/* cache ַ line */
#define CACHE_LINESIZE                           L1_CACHE_BYTES
#define CACHE_ALIGN_TO_LINESIZE(ADDR, LEN)       ((LEN) = (((LEN) + ((ADDR) - ((ADDR) & (~(CACHE_LINESIZE - 1u)))) + \
		                                  CACHE_LINESIZE - 1u) & (~(CACHE_LINESIZE - 1u)))); \
		                                  ((ADDR) = ((ADDR) & (~(CACHE_LINESIZE - 1u))))

VOID zOss_CacheCleanRange(UINT32 base, UINT32 size)
{
    UINT32 old_intr;

    CACHE_ALIGN_TO_LINESIZE(base, size);
    ZOSS_SAVE_IRQ(old_intr);
    dmac_map_area(base, size, DMA_TO_DEVICE);
    outer_clean_range(base, base + size);
    ZOSS_RESTORE_IRQ(old_intr);
}

VOID zOss_CacheInvalidateRange(UINT32 base, UINT32 size)
{
    UINT32 old_intr;
    
    CACHE_ALIGN_TO_LINESIZE(base, size);
    ZOSS_SAVE_IRQ(old_intr);
    outer_inv_range(base, base + size);
    dmac_map_area(base, size, DMA_FROM_DEVICE);

    ZOSS_RESTORE_IRQ(old_intr);
}

VOID zOss_CacheCleanRangeFast(UINT32 base, UINT32 size)
{
    dmac_map_area(base, size, DMA_TO_DEVICE);
    outer_clean_range(base, base + size);
}

VOID zOss_CacheInvalidateRangeFast(UINT32 base, UINT32 size)
{
    outer_inv_range(base, base + size);
    dmac_map_area(base, size, DMA_FROM_DEVICE);
}

VOID zOss_CacheClean(VOID)
{
    UINT32 old_intr;

    ZOSS_SAVE_IRQ(old_intr);
    flush_cache_all();
    outer_flush_all();
    ZOSS_RESTORE_IRQ(old_intr);
}

#ifdef __cplusplus
}
#endif

