/**************************************************************************
*
*                  Copyright (c) 2012 ZTE Corporation.
*
***************************************************************************
* ģ   : 
*    : tos_ramlog.c
* ļ : 
* ʵֹ : TOS 3.0ϵͳ֧Ųramlogģ
*      : 
*      : V1.0
*  : 2012/04/10
* ˵ : 
**************************************************************************/

/**************************************************************************
* ޸ļ¼
**************************************************************************/
/**************************************************************************
* ޸ı : 0001
*    : dengningkun
* ޸ : 2012/9/27
* ޸ : ʽ淶PC-LINT  EC:617001782169
**************************************************************************/
/**************************************************************************
* ޸ı : 0002
*    : dengningkun
* ޸ : 2012/10/10
* ޸ : ߲               EC:617001782205
**************************************************************************/

/**************************************************************************
* #include
**************************************************************************/

#include <stdarg.h>
#include "oss_api.h"
#include "tos_ramlog.h"

#ifdef __cplusplus
extern "C" 
{
#endif


/**************************************************************************
* ⲿ
**************************************************************************/
#ifdef __GNUC__

extern char _ramlog_start[];
extern char _ramlog_end[];

#elif defined (__ARMCC_VERSION)

extern char Image$$RAMLOG$$ZI$$Base[];
extern char Image$$RAMLOG$$ZI$$Limit[];

# define _ramlog_start  Image$$RAMLOG$$ZI$$Base
# define _ramlog_end    Image$$RAMLOG$$ZI$$Limit

#endif

/**************************************************************************
* 궨
**************************************************************************/
#ifdef TOS_RAMLOG
# define RAMLOG_LOCK()      //ZOSS_SAVE_IRQ(old_intr)
# define RAMLOG_UNLOCK()    //ZOSS_RESTORE_IRQ(old_intr)
#endif


/**************************************************************************
* ݽṹ
**************************************************************************/
#ifdef TOS_RAMLOG
typedef struct {
    char * const start;
    char * const end;
    char *ptr;
    int full;
} tos_ramlog_t;
#endif


/**************************************************************************
* ֲԭ
**************************************************************************/
 
/**************************************************************************
* ȫֳ/
**************************************************************************/
#ifdef TOS_RAMLOG
static tos_ramlog_t tos_ramlog = {
    _ramlog_start,
    _ramlog_end,
    _ramlog_start,
    0x00,
};
#endif

/**************************************************************************
* ֲʵ
**************************************************************************/


/**************************************************************************
* ȫֺʵ
**************************************************************************/
/**************************************************************************
* :     ramlogӡ
* ˵:     
*   ()  fmt:    ʽ
                ...:    ɱб
*   ()  void
*   ֵ:     Ѵӡַ
* ˵:     void
**************************************************************************/
int tos_ramlog_printf(const char *fmt, ...)
{
#ifdef TOS_RAMLOG
    int size = 0;
    va_list ap;
    
    RAMLOG_LOCK();
    va_start(ap, fmt);
    size = vsnprintf(tos_ramlog.ptr, (size_t)(_ramlog_end - tos_ramlog.ptr), fmt, ap);
    va_end(ap);
    tos_ramlog.ptr += size;
    if (tos_ramlog.ptr >= _ramlog_end)
    {
        tos_ramlog.ptr = _ramlog_start;
        tos_ramlog.full = 0x01;
    }
    RAMLOG_UNLOCK();
    
    return size;
#else
    return 0x00;
#endif
}


/**************************************************************************
* :     ȡramlogʹϢ
* ˵:     
*   ()  void
*   ()  start:  ramlogʼַ
                end:    ramlogַ
*   ֵ:     void
* ˵:     full־λλʾramlog
**************************************************************************/
void tos_ramlog_info(char **start, char **end)
{
    if (start == NULL || end == NULL)
    {
        return;
    }
     
    RAMLOG_LOCK();
    *start = tos_ramlog.start;
    if (tos_ramlog.full)
    {
        *end = tos_ramlog.end;
    }      
    else
    {
        *end = tos_ramlog.ptr;
    }        
    RAMLOG_UNLOCK();
}


/**************************************************************************
* :     ṩramlogʹõĻϢϢ
* ˵:     
*   ()  void
*   ()  pMonRamlogInfo: ramlogϢŵַ             
*   ֵ:     void
* ˵:     
**************************************************************************/
VOID z0ss_GetRamlogInfo(T_ZOss_Mon_Ramlog *pMonRamlogInfo)
{
#ifdef _USE_MONITOR
    char *ramlogStart = NULL;
    char *ramlogEnd   = NULL;

    if (pMonRamlogInfo)
    {
        tos_ramlog_info(&ramlogStart, &ramlogEnd);
        pMonRamlogInfo->ramlog   = ramlogStart;
        pMonRamlogInfo->size     = (UINT32)(ramlogEnd - ramlogStart);
    }
#endif    
}

#ifdef __cplusplus
}
#endif

