/*******************************************************************************
* Ȩ (C)2016, ͨѶɷ޹˾
* 
* ļ:     ramdump_client.c
* ļʶ:     ramdump_client.c
* ժҪ:     ramdumpͻ쳣ֳݵʵ
* 
* ޸        汾      ޸ı        ޸          ޸
* ------------------------------------------------------------------------------
* 2016/6/10      V1.0        Create           Ծ          
* 
*******************************************************************************/

/*******************************************************************************
*                                   ͷļ                                     *
*******************************************************************************/
#include "ramdump_pub.h"
#include "ramdump_oss.h"
#ifdef __USE_CLIENT_WITH_COLLECT__
#include "ramdump_collect_server.h"
#endif

#ifdef __cplusplus
extern "C" {
#endif

/*******************************************************************************
*                                ⲿ                                  *
*******************************************************************************/
#ifdef _OS_TOS
extern void ramdump_open_tcm_clock(void);
#else 
void ramdump_open_tcm_clock(void){}
#endif

/*******************************************************************************
*                                                                      *
*******************************************************************************/

/*******************************************************************************
*                                   궨                                     *
*******************************************************************************/

#define RAMDUMP_ON_DEFAULT_VAL  (1)

#define RAMDUMP_CLIENT_SUCCESS (RAMDUMP_SUCCESS)
#define RAMDUMP_CLIENT_FAILED  (RAMDUMP_FAILED)

#define RAMDUMP_CLIENT_CMM_SCRNAME  "client_cmm.cmm"
#define RAMDUMP_CLIENT_ERR_LOG      "client_error_log.txt"

/*******************************************************************************
*                                Ͷ                                  *
*******************************************************************************/

/*******************************************************************************
*                                ֲ                                  *
*******************************************************************************/

/*******************************************************************************
*                              ֲ̬                                *
*******************************************************************************/

static int ramdump_client_init_flag = RAMDUMP_FALSE;
static int ramdump_count;

/* client ram conf table */
static ramdump_ram_config_t ramdump_client_ram_conf[RAMDUMP_RAMCONF_TABLE_MAX_ENTRYS];
/* client ram conf data done flag*/
static unsigned long ramdump_client_ram_conf_done_flag = RAMDUMP_SYNC_RESET;

/* Cmm file content */
static char ramdump_client_cmm_buf[RAMDUMP_CMM_SIZE];
/* */
static char ramdump_client_errno_log[RAMDUMP_ERROR_LOG_SIZE];

/*******************************************************************************
*                                ȫֱ                                  *
*******************************************************************************/

/*******************************************************************************
*                                ֲʵ                                  *
*******************************************************************************/

/*******************************************************************************
* :    ramdump_client_copy_data
* ˵:     
*   () void
*   () void
*   ֵ:    void
* ˵:    This function is used to copy some data to the addr
*******************************************************************************/
static void ramdump_client_copy_data(void)
{
    unsigned long i_ram_conf = 0;

    while (ramdump_client_ram_conf[i_ram_conf].phy != 0 && 
           ramdump_client_ram_conf[i_ram_conf].size != 0)
    {
        if (ramdump_client_ram_conf[i_ram_conf].flag == RAMDUMP_FLAG_NEED_COPY &&
            ramdump_client_ram_conf[i_ram_conf].copy != 0 &&
           (ramdump_client_ram_conf[i_ram_conf].phy != ramdump_client_ram_conf[i_ram_conf].copy))
            {
            memcpy(
                (int *)ramdump_client_ram_conf[i_ram_conf].copy,
                (int *)ramdump_client_ram_conf[i_ram_conf].phy,
                ramdump_client_ram_conf[i_ram_conf].size);
            }
        i_ram_conf++;
    }
}

/*******************************************************************************
* :    ramdump_client_cmm_and_log_recalc
* ˵:     
*   () void
*   () void
*   ֵ:    void
* ˵:    This function is used to create err log file
*******************************************************************************/
static void ramdump_client_cmm_and_log_recalc(void)
{
    unsigned long i_ram_conf = 0;

    while (ramdump_client_ram_conf[i_ram_conf].phy != 0 && 
           ramdump_client_ram_conf[i_ram_conf].size != 0)
    {
        if (ramdump_client_ram_conf[i_ram_conf].phy == (unsigned long)ramdump_client_cmm_buf)
            ramdump_client_ram_conf[i_ram_conf].size = strlen(ramdump_client_cmm_buf);
        else if (ramdump_client_ram_conf[i_ram_conf].phy == (unsigned long)ramdump_client_errno_log)
            ramdump_client_ram_conf[i_ram_conf].size = strlen(ramdump_client_errno_log);

        i_ram_conf++;
    }
}

/*******************************************************************************
* :    ramdump_client_error_log_create
* ˵:     
*   () void
*   () void
*   ֵ:    void
* ˵:    This function is used to create err log file
*******************************************************************************/
static void ramdump_client_error_log_create(void)
{
    int offset = 0;
    unsigned long *first_dump_cpu_id = ramdump_get_first_dump_cpu_id();

#ifdef __USE_CLIENT_WITH_COLLECT__

    offset = sprintf(
                ramdump_client_errno_log, 
                "core [%s]  exact error!\n", 
                ramdump_cpu_name[*first_dump_cpu_id]);

#endif

    ramdump_oss_error_log_creat(ramdump_client_errno_log + offset);

}

/*******************************************************************************
* :    ramdump_client_store_ram_conf
* ˵:     
*   () mem: addr
*   () void 
*   ֵ:    unsigend char*: changed addr
* ˵:    This function is used to store ram conf
*******************************************************************************/
static char *ramdump_client_store_ram_conf(char *mem)
{
    unsigned long i_ram_conf = 0;

    while ((ramdump_client_ram_conf[i_ram_conf].vir != 0) && 
           (ramdump_client_ram_conf[i_ram_conf].size != 0))
    {
        ramdump_ram_config_t *config_entry = &ramdump_client_ram_conf[i_ram_conf];
        if ((config_entry->phy == (unsigned long)ramdump_client_cmm_buf) ||
            (config_entry->phy == (unsigned long)ramdump_client_errno_log))
        {
            i_ram_conf++;
            continue;
        }
        if(config_entry->callback == NULL ||
           (config_entry->callback != NULL &&
           (*(config_entry->callback))() == RAMDUMP_TRUE))
            mem += sprintf(
                    mem,
                    "data.load.binary &ramdump_dir\\%s 0x%lx--0x%lx /noclear\n",
                    config_entry->name,
                    config_entry->phy, 
                    (config_entry->phy + config_entry->size));
        i_ram_conf++;
    }

    return mem;
}

/*******************************************************************************
* :    ramdump_client_cmm_create
* ˵:     
*   () void
*   () void 
*   ֵ:    void
* ˵:    This function is used for client to generate cmm scripts
*******************************************************************************/
static void ramdump_client_cmm_create(void)
{
    char *pcmm_buf = ramdump_client_cmm_buf;

    // store the cmm BEGIN
    pcmm_buf += sprintf(pcmm_buf, "ENTRY &ramdump_dir\n");
    // store procmodes regs
    pcmm_buf = ramdump_arch_store_modes_regs(pcmm_buf);
    // store ram config 
    pcmm_buf = ramdump_client_store_ram_conf(pcmm_buf);
    // store memory map control regs
    pcmm_buf = ramdump_arch_store_mm_regs(pcmm_buf);
    // store end symbol
    pcmm_buf += sprintf(pcmm_buf, "ENDDO\n");
}

/*******************************************************************************
*                                ȫֺʵ                                  *
*******************************************************************************/

/*******************************************************************************
* :    ramdump_ram_conf_table_add
* ˵:     
*   () ram_name:    dump ram name
               ram_start:   dump ram start(virtual addr)
               ram_size:    dump ram size
*   () void 
*   ֵ:    void 
* ˵:    This function is used to add dump ram conf into public table
*******************************************************************************/
void ramdump_ram_conf_table_add(
        char *ram_name, 
        unsigned long ram_phy, 
        unsigned long ram_size, 
        unsigned long ram_virt,
        unsigned long ram_flag,
        unsigned long ram_extra)
{
    static int i_entry = 0;

    if ((ram_phy == 0) && (ram_size == 0))
        return;

    strncpy(ramdump_client_ram_conf[i_entry].name, 
            ram_name, 
            RAMDUMP_RAMCONF_FILENAME_MAXLEN);
    ramdump_client_ram_conf[i_entry].phy   = ram_phy;
    ramdump_client_ram_conf[i_entry].size  = ram_size;
    ramdump_client_ram_conf[i_entry].vir   = ram_virt;
    ramdump_client_ram_conf[i_entry].flag  = ram_flag;

    switch (ram_flag & RAMDUMP_CLEAR_PRIO_FLAG)
    {
        case RAMDUMP_FLAG_NEED_COPY:
            ramdump_client_ram_conf[i_entry].copy  = ram_extra;
            break;
        case RAMDUMP_FLAG_HAS_EXTERNAL:
            ramdump_client_ram_conf[i_entry].exter  = ram_extra;
            break;
        case RAMDUMP_FLAG_HAS_CALLBACK:
            ramdump_client_ram_conf[i_entry].callback  = (ramdump_callback_t)ram_extra;
            break;
        default:
            break;
    }
    
    if (i_entry < RAMDUMP_RAMCONF_TABLE_MAX_ENTRYS - 1)
        i_entry++;
    else
        i_entry = 0;
}

/*******************************************************************************
* :     ramdump_init
* ˵:     
*   ()  void
*   ()  void
*   ֵ:     RAMDUMP_SUCCESS
* ˵:     This function is used for ramdump init
*******************************************************************************/
int ramdump_init(void)
{
    int ret = 0;
    unsigned long *first_dump_cpu_id = 0;
    ramdump_ram_config_sync_msg_t msg = {0};
    char bin_name[RAMDUMP_RAMCONF_FILENAME_MAXLEN] = {0};

    if (ramdump_client_init_flag == RAMDUMP_TRUE)
        return RAMDUMP_SUCCESS;

#ifdef __USE_CLIENT_WITH_COLLECT__

    ret = ramdump_collect_server_icp_init();
    if (ret != RAMDUMP_ICP_SUCCESS)
        return ret;
    ramdump_get_collect_server_ram_conf(&msg);
    msg.array[RAMDUMP_CPU_0].array     = ramdump_client_ram_conf;
    msg.array[RAMDUMP_CPU_0].nr        = RAMDUMP_RAMCONF_TABLE_MAX_ENTRYS;
    msg.array[RAMDUMP_CPU_0].done_flag = &ramdump_client_ram_conf_done_flag;
    /* default except core (the core with collect server)*/
    first_dump_cpu_id = ramdump_get_first_dump_cpu_id();
    *first_dump_cpu_id = RAMDUMP_CPU_0;

    /* set client ram data done flag */
    ramdump_client_ram_conf_done_flag = RAMDUMP_SYNC_RAM_CONFIG_DONE;

    /*
     * clean all the caches to make sure all data in ddr 
     */
    ramdump_arch_clean_caches();
    
#endif //#ifdef __USE_CLIENT_WITH_COLLECT__

    /* generate dump name prefix */
    sprintf(
        bin_name, 
        "%s-%s", 
        ramdump_cpu_name[RAMDUMP_CPU_0], 
        RAMDUMP_CLIENT_ERR_LOG);
    ramdump_ram_conf_table_add(
        bin_name, 
        (unsigned long)ramdump_client_errno_log, 
        RAMDUMP_ERROR_LOG_SIZE,
        0,
        RAMDUMP_FLAG_LEVEL_MEDIUM,
        0);
    /* generate dump name prefix */
    memset(bin_name, 0, sizeof(bin_name));
    sprintf(
            bin_name, 
            "%s-%s", 
            ramdump_cpu_name[RAMDUMP_CPU_0], 
            RAMDUMP_CLIENT_CMM_SCRNAME);
    ramdump_ram_conf_table_add(
        bin_name, 
        (unsigned long)ramdump_client_cmm_buf, 
        RAMDUMP_CMM_SIZE,
        0,
        RAMDUMP_FLAG_LEVEL_MEDIUM,
        0);

    OSS_PRINTF("Ramdump client init success!\n");
    ramdump_client_init_flag = RAMDUMP_TRUE;

    return RAMDUMP_SUCCESS;
}
OSS_INIT(ramdump_init);

/*******************************************************************************
* :     ramdump_client_entry
* ˵:     
*   ()  void
*   ()  void
*   ֵ:     void
* ˵:     This function is used for client ramdump entry
*******************************************************************************/
void ramdump_client_entry (void)
{
    unsigned long flags;

    if (!ramdump_client_init_flag)
        return;

    if (++ramdump_count > 1)
        while(TRUE); /* endless circle */

    /*
     * we need lock the irq, this can`t be interrupt.
     */
    OSS_LOCK(flags);

    /*
     * save all regs first.
     */
    ramdump_arch_save_all_regs();

    /* open tcm clock */
    ramdump_open_tcm_clock();

    /* t32 cmm scripts */
    ramdump_client_cmm_create();
    /* err info file */
    ramdump_client_error_log_create();

    /* special data copy to the copy addr
     * then other core read from the copy addr
     */
    ramdump_client_copy_data();
    /* recalc client cmm and err_log size */
    ramdump_client_cmm_and_log_recalc();
    /* set client ram data done flag */
    ramdump_client_ram_conf_done_flag = RAMDUMP_SYNC_RAM_CONTENT_DONE;

    /* clean all the caches to make sure all data in ddr */
    ramdump_arch_clean_caches();

#ifdef __USE_CLIENT_WITH_COLLECT__
    ramdump_collect_server_notify_clients_dump();
#endif

    /*
     * TODO! 
     * now endless circle, e.g., config restart or not is more better.
     */
    while (TRUE);

    OSS_UNLOCK(flags);
}

#ifdef __cplusplus
}
#endif

