/* -------------------------------------------------------------------------------------------------------------------@udN
 * Ȩ(C)2012, ͨѶɷ޹˾ 
 * 
 *   : drv_hash.c
 * 
------------------------------------------------------------------------------------------------------------*/

#include "drv_hash.h"
#include <sdio.h>

/**-------------------------------------------------------------------------------------------------------------------@n
 *Hash_set_len :
	ϢbitΪλõȼĴ
       --------------------------------------------------------------
 ע:
	ǵhashݳһ㶼ǰbyte룬ᳬ4G byte
	˼˺ܡ
	byte_Len ܳ4GúҪ޸ġ
 *--------------------------------------------------------------------------------------------------------------------*/
static void hash_SetLen(u32 byte_Len)
{
    REG32(HASH_LENGTH0) = byte_Len<<3;
    REG32(HASH_LENGTH1) = byte_Len>>29;
    REG32(HASH_LENGTH2) = 0;
    REG32(HASH_LENGTH3) = 0;
}

#ifdef HASH_CODE_SUPPORT_ALL
static void hash_SetHmacKey(u32* pHmacKey, u32* HmacKey_len)
{
    u32 udI;
	
    for(udI=0;udI<32;udI++)
    {
    	//Ĵߵַŵλݣݴǵ͵ַŸλ
    	if(udI<(32-HmacKey_len))
		REG32(HASH_HMACKEY+udI*4) = 0;
	else
		REG32(HASH_HMACKEY+udI*4) = pHmacKey[udI-(32-HmacKey_len)];
    }
}
#endif

/* hash ͽĳȣȵλword */
static void hash_GetResult(u32 udMode, u32* HashResult, u32* ResultLen)
{
    u32 udI, udResultLen=0;
	
#ifdef HASH_CODE_SUPPORT_ALL	
    switch(udMode)
    {
        case HASH_MODE_MD5:
	 case HASH_MODE_HMAC_MD5:
            udResultLen = 4;  /* 4*4bytes = 128bit*/
            break;
            
        case HASH_MODE_SHA1:
        case HASH_MODE_HMAC_SHA1:
            udResultLen = 5;  /* 160 bit */
            break;
            
        case HASH_MODE_SHA224:
	 case HASH_MODE_HMAC_SHA224:
            udResultLen = 7;  /* 224 bit */
            break;
            
        case HASH_MODE_SHA256:
	 case HASH_MODE_HMAC_SHA256:
            udResultLen = 8; /*  256 bit */
            break;
            
        case HASH_MODE_SHA384:
        case HASH_MODE_HMAC_SHA384: 	
            udResultLen = 12; /* 384 bit */
            break;
            
        case HASH_MODE_SHA512:
        case HASH_MODE_HMAC_SHA512:
            udResultLen = 16; /* 512 bit */
            break;
            
        default:
            break;
    }
#else
    udResultLen = 4;
#endif

    *ResultLen = udResultLen;
	
    for(udI=0;udI<udResultLen;udI++)   //hash֧128bit
    {
        //Ĵ͵ַresult ĸλ
        HashResult[udI] = REG32(HASH_RESULT+(16-udResultLen+udI)*4);
    }
}

/**-------------------------------------------------------------------------------------------------------------------@n
 * @brief HASHģӿ
 * 
 * :
 *     - Hash_Computeڽӿں, 书:
 *      - HASHģӿ
 *     
 * :
 input:
 	udMode--------hashģʽ
 	udBigEndian----С˸ʽ
 	ploadAddr------hashԴָ
 	loadLen--------Դݳ
 	pHmacKey------HMACģʽµԿ
 	HmacKey_len---Կ
 output:
	HashResult-----hash
 	ResultLen------hashĳ
 *   ֵ: 0:ɹ 1:ʧ

 *--------------------------------------------------------------------------------------------------------------------*/
u32 Hash_Calculate(u32 udMode, u32 udBigEndian, u32* ploadAddr, u32 loadLen, u32* pHmacKey, u32* HmacKey_len, u32* HashResult, u32* ResultLen)
{
	u32 udMessageLen_word;
	u32 udI;

	if((loadLen == 0) || (ploadAddr == NULL) || (HashResult == NULL) )
	{
		return 1;
	}
	
	//config hash mode and enable module
	REG32(HASH_CONTROL) = (udMode<<4)|(udBigEndian<<12)|1;

	hash_SetLen(loadLen);
	
#ifdef HASH_CODE_SUPPORT_ALL
	//write HMAC key
	if(udMode&0x10)
	{
		hash_SetHmacKey(pHmacKey, HmacKey_len);
	}
#endif

	REG32(HASH_START) = 1;//Hash_Start   

	//start write message data into fifo
	udMessageLen_word = (loadLen+3)/4;
	for(udI=0;udI<udMessageLen_word;udI++)
	{
		REG32(HASH_DATA) = ploadAddr[udI];
	}

	while(REG32(HASH_START) & 0x1); /* if cal busy, continue to wait*/

	//read Result
	hash_GetResult(udMode, HashResult, ResultLen);

	REG32(HASH_CONTROL) = 0;//Hash_DisableModule;

	return 0;
}
     
/** @} */
      
