/*
 * Linux driver for NAND NV Flash Translation Layer
 * Copyright (C) 2016, ZIXC Corporation.
 */

#include <common.h>
#include <linux/mtd/mtd.h>
#include <command.h>
#include <watchdog.h>
#include <malloc.h>
#include <asm/byteorder.h>
#include <nand.h>
#include <partition_table.h>   

extern partition_table_t * g_partition_table;

int do_partition(cmd_tbl_t * cmdtp, int flag, int argc, char * const argv[])
{

	/* at least two arguments please */

    printf("\n");
    printf("partition_table->magic = 0x%0x\n",g_partition_table->magic);
    printf("partition_table->platform_name = %s\n",g_partition_table->platform_name);
    printf("partition_table->version = 0x%0x\n",g_partition_table->version);
    printf("partition_table->entrys = 0x%0x\n",g_partition_table->entrys);
    printf("partition_table->crc = 0x%0x\n",g_partition_table->crc);

    uint32_t i = g_partition_table->entrys;
    partition_entry_t * part_entry = &g_partition_table->table[0];
    
    printf("\tpart_name\t\tpart_type\t\tpart_offset\t\tpart_size\n");   
    do
    {
        printf("\t%-8s\t\t%-8s\t\t0x%08x\t\t0x%08x\n",part_entry->part_name,
                                                    part_entry->part_type,
                                                    part_entry->part_offset,
                                                    part_entry->part_size);
        part_entry++;
    } while( --i != 0 );
    printf("\n");
    return 0;
}

U_BOOT_CMD(
	partition,	CONFIG_SYS_MAXARGS,	1,	do_partition,
	"print partition table",
	"\n"
);
