/*******************************************************************************
 * Copyright (C) 2016, ZIXC Corporation.
 *
 * File Name:cmd_compat_read.c
 * File Mark:
 * Description:
 * Others:
 * Version:       1.0
 * Author:        zangxiaofeng
 * Date:          2013-3-13
 * History 1:
 *     Date:
 *     Version:
 *     Author:
 *     Modification:
 * History 2:
  ********************************************************************************/


/****************************************************************************
* 	                                     Include files
****************************************************************************/
#include <common.h>
#include <command.h>
#include <net.h>
#include <jffs2/load_kernel.h>
#include "downloader_config.h"
#include "downloader_nand.h"
#include "downloader_serial.h"
#include <boot_mode.h>

#include "errno.h"
/****************************************************************************
*							Global Function Prototypes
****************************************************************************/
extern int g_iftype;

/*******************************************************************************
 * Function:do_compat_read
 * Description:
 * Parameters:
 *	 Input:
 *
 *	 Output:
 *
 * Returns:
 *
 *
 * Others:
 ********************************************************************************/
 int do_compat_read(cmd_tbl_t *cmdtp, int flag, int argc, char * const argv[])
{
    partition_entry_t *part = NULL;
    char *par = NULL;
    char ack[64]={0};
	unsigned int offset = 0;
	unsigned int size = 0;
	unsigned int ret = 0;
	
	if(argc<4)
    {
        return cmd_usage(cmdtp);
    }

	
	par = argv[1];
    offset = (unsigned int)simple_strtoul (argv[2], NULL, 16);
	size = (unsigned int)simple_strtoul (argv[3], NULL, 16);
	part = downloader_get_part(par);
	if(part == NULL)
	{
		sprintf(ack,"FAIL INVALID PARTITION TYPE");
        downloader_serial_write(ack, strlen(ack)+1);
	    return -1;
	}

	if(g_nor_flag == 1)
	{
	    if(memcmp(par,"zloader",7) == 0) {
			g_iftype = IF_TYPE_NOR;
			nand_init();
			ret = do_nor_read(part, par, offset,size); 
			/*лʼspi_nand*/
			g_iftype = IF_TYPE_SPI_NAND;
			nand_init();		
			return ret;
		}
	}

	if((read_boot_flashtype() == IF_TYPE_NOR) 
		&& (strcmp((const char *)part->part_type,"nand") == 0))

	{
        ret = do_nor_read(part, par, offset,size);
		return ret;
	}
	

	if(strcmp((const char *)part->part_type,"nand") == 0)
	{
	    ret = do_nand_read(part, par, offset, size);
		return ret;
	}
	else if (strcmp((const char *)part->part_type,"fs") == 0)
	{
	    ret = do_yaffs_read(part, par, offset, size);
		return ret;
	}
	else if (strcmp((const char *)part->part_type,"ddr") == 0)
	{
	    ret = do_ram_read(offset, size);
		return ret;
	}
	else if (strcmp((const char *)part->part_type,"raw") == 0)
	{
	    ret = do_raw_read(offset, size);
		return ret;
	}
	else
	{
	    sprintf(ack,"FAIL INVALID PARTITION TYPE");
        downloader_serial_write(ack, strlen(ack)+1);
	    return -1;
	}
}
U_BOOT_CMD(
	compat_read, CONFIG_SYS_MAXARGS, 0, do_compat_read,
	"upload: compat_read [partition][offset][size]",
	""
);






