/*******************************************************************************
 * Copyright (C) 2016, ZXIC Corporation.
 *
 * File Name:
 * File Mark:
 * Description:
 * Others:
 * Version:       1.0
 * Author:        zxic
 * Date:		  2016.12.15
 * modify
  ********************************************************************************/

/****************************************************************************
* 	                                           Include files
****************************************************************************/
#include <malloc.h> 
#include <errno.h>
#include <asm/io.h> 
#include <linux/mtd/mtd.h>
#include <asm-generic/ioctl.h>
#include <config.h>
#include <common.h>
#include <command.h>

#include <../drivers/hash/drv_hash.h>
#include <../drivers/rsa/drv_rsa.h>
#include <../drivers/hash/sha256.h>
#include <secure_verify.h>
#include <asm/arch/efuse.h>
#include <boot_mode.h>

/****************************************************************************
* 	                                           Local Macros
****************************************************************************/
#define E_N_LEN 256
#define HASH_LEN 128
#define reg32(addr)			(*(volatile unsigned long *)(addr))

/****************************************************************************
* 	                                           Local Types
****************************************************************************/


/****************************************************************************
* 	                                           Global Value
****************************************************************************/
/* Disable Secure Verify as Default. */
unsigned int guiEfuseStatus = 1;
unsigned char g_ddr_size_flag = 0;

static unsigned char gbEfuseReadFlag = 0;

otp_struct otpInfo;
unsigned int guiOtpStatus = 1;
extern int rootfs_flag;
extern int m0_flag;
extern int zsp_flag;
extern int g_iftype;
extern unsigned char g_nor_flag;

/****************************************************************************
* 	                                           Local Funcs
****************************************************************************/

static void efuse_read_prepare(void)
{
	//start read efuse all 256bit
	while((reg32(SYS_EFUSE_BASE + 0x4) & 1) == 1);// bit0=1 ctl is busy
	reg32(SYS_EFUSE_BASE + 0x4) = 1;
	while((reg32(SYS_EFUSE_BASE + 0x14) & 2) == 0);//bit1=0 read not over
}

static void efuse_program_32bit(u32 bit_offset, u32 data)
{
	while((reg32(SYS_EFUSE_BASE+0x4)&1)==1);// bit0=1 ctl is busy
	reg32(SYS_EFUSE_BASE+0x8) = bit_offset;
	reg32(SYS_EFUSE_BASE+0xc) = data;
	reg32(SYS_EFUSE_BASE+0x4) = (0<<4)|(2<<1)|1;//cs0 program 32bit
	while((reg32(SYS_EFUSE_BASE+0x4)&1)==1);// bit0=1 ctl is busy
	reg32(SYS_EFUSE_BASE+0x4) = (1<<4)|(2<<1)|1;//cs1 program 32bit
}

void efuse_program_secure_en(u32 en)
{
	while((reg32(SYS_EFUSE_BASE+0x4)&1)==1);// bit0=1 ctl is busy
	reg32(SYS_EFUSE_BASE+0x8) = 0;			//bit[7:0] secure_boot_en
	if(en)
		reg32(SYS_EFUSE_BASE+0xc) = 0xFF;
	reg32(SYS_EFUSE_BASE+0x4) = (0<<4)|(2<<1)|1;//cs0 program 32bit
	while((reg32(SYS_EFUSE_BASE+0x4)&1)==1);// bit0=1 ctl is busy
	reg32(SYS_EFUSE_BASE+0x4) = (1<<4)|(2<<1)|1;//cs1 program 32bit
}

void efuse_program_chip_flag(u32 flag)
{
	while((reg32(SYS_EFUSE_BASE+0x4)&1)==1);// bit0=1 ctl is busy
	reg32(SYS_EFUSE_BASE+0x8) = 0;			//bit[31:8] secure_chip_flag

	if(flag&0xFF != 0)
		reg32(SYS_EFUSE_BASE+0xc) = 0;
	else
		reg32(SYS_EFUSE_BASE+0xc) = flag;
	
	reg32(SYS_EFUSE_BASE+0x4) = (0<<4)|(2<<1)|1;//cs0 program 32bit
	while((reg32(SYS_EFUSE_BASE+0x4)&1)==1);// bit0=1 ctl is busy
	reg32(SYS_EFUSE_BASE+0x4) = (1<<4)|(2<<1)|1;//cs1 program 32bit
}

void efuse_program_puk_hash(u32 *key)
{
	efuse_program_32bit(32, key[0]);
	efuse_program_32bit(64, key[1]);
	efuse_program_32bit(96, key[2]);
	efuse_program_32bit(128, key[3]);
}
#if 0
/**-------------------------------------------------------------------------------------------------------------------@n
 * : chip_is_spe
 * : жоƬǷΪרоƬ
 *   ֵ: 0,оƬ    1,רоƬ
 *--------------------------------------------------------------------------------------------------------------------*/
u32 chip_is_spe(void)
{
	u8  tmp_chip_flag[3] = {0x53, 0x50, 0x45}; /*SPE*/
	u32 efuse_tmp_buf[5] = {0};
	efuse_struct *psEfuseInfo = NULL;

	psEfuseInfo = (efuse_struct *)efuse_tmp_buf;
	memcpy(psEfuseInfo, EFUSE_RAM_BASE, sizeof(efuse_struct));

	if(memcmp(psEfuseInfo->chip_flag,tmp_chip_flag,3))
		/*chip com*/
		return 0;

	/*chip spe*/
	return 1;
}
#endif

/*
* Convert BIGENDIAN To SMALLENDIAN.
*/
void BIG2SMALL(u32 *pBuffer, u32 uiLen)
{
	u32 uiLoop;
	u32 uiTmp = 0;

	for (uiLoop = 0; uiLoop < uiLen/sizeof(u32); uiLoop++)
	{
		uiTmp = pBuffer[uiLoop];
		pBuffer[uiLoop] = 0;
		pBuffer[uiLoop] += (uiTmp & 0x000000FF) << 24;
		pBuffer[uiLoop] += (uiTmp & 0x0000FF00) << 8;
		pBuffer[uiLoop] += (uiTmp & 0x00FF0000) >> 8;
		pBuffer[uiLoop] += (uiTmp & 0xFF000000) >> 24;
	}
}

void get_otp_secure_verify_status(void)
{
	u32 uiLen;
	otp_struct *psEfuseInfo = NULL;
	
	/*
	 * 0. secure flag0˳ȫboot
	 */
	psEfuseInfo = (otp_struct*)&otpInfo;
	if(psEfuseInfo->secure_flag != 0)
	{
		guiOtpStatus = 1;	   //Disable.
		BOOT_PRINTF(UBOOT_NOTICE, "secure_flag!=0xFF, SecureVerify->Disable.\n");
		return ;
	}	
	
	/*
	 * 1.efuseжpuk_hash[255:0], жȫΪ0˳ȫboot
	 */
	for(uiLen = 0; uiLen < 8; uiLen++)
	{
		if(psEfuseInfo->puk_hash[uiLen] != 0)
		{
			break;
		}
		if(uiLen == 7)
		{
			guiOtpStatus = 1;	   //Disable.
			BOOT_PRINTF(UBOOT_NOTICE, "PubKey_HASH=Invalid, SecureVerify->Disable.\n");
			return ;
		}
	}
	BOOT_PRINTF(UBOOT_NOTICE, "All Flag & Param is Valid, SecureVerify->ENABLE.\n");
	guiOtpStatus = 0;	   //Enable.
}

static void efuse_get_data(void)
{
	efuse_struct *psEfuseInfo = NULL;
	u32 uiLen = 0;

	/* Secure Verify. 1->Disable, 0->Enable. */
	if((reg32(EFUSE_BYPASS) & 1) == 1)
	{
		guiEfuseStatus = 1;	   //Disable.
		BOOT_PRINTF(UBOOT_NOTICE, "EFUSE_BYPASS=1, SecureVerify->Disable.\n");
		return ;
	}

	/* step 0*/
	psEfuseInfo = (efuse_struct*)EFUSE_RAM_BASE;

	/* get chip flag */
	if(((psEfuseInfo->secure_flag >> 8) == ZX297520V3ECO_GW_WINBD_256M_DDR)
		||((psEfuseInfo->secure_flag >> 8) == ZX297520V3ECO_ZW_WINBD_256M_DDR)
		||((psEfuseInfo->secure_flag >> 8) == ZX297520V3ECO_GW_UNILC_256M_DDR)
		||((psEfuseInfo->secure_flag >> 8) == ZX297520V3ECO_ZW_UNILC_256M_DDR)		
		||((psEfuseInfo->secure_flag >> 8) == ZX297520V3ECO_GW_APM_256M_DDR)
		|| ((psEfuseInfo->secure_flag >> 8) == ZX297520V3ECO_ZW_APM_256M_DDR))
	{
		g_ddr_size_flag = CHIP_DDR_IS_32M;
		BOOT_PRINTF(UBOOT_NOTICE, "secure_flag=0x%x.\n", psEfuseInfo->secure_flag);
	}
	else if(((psEfuseInfo->secure_flag >> 8) == ZX297520V3ECO_GW_UNILC_512M_DDR)
		||((psEfuseInfo->secure_flag >> 8) == ZX297520V3ECO_GW_APM_512M_DDR)
		||((psEfuseInfo->secure_flag >> 8) == ZX297520V3ECO_GW_ESMT_512M_DDR)
		||((psEfuseInfo->secure_flag >> 8) == ZX297520V3ECO_ZW_UNILC_512M_DDR)
		||((psEfuseInfo->secure_flag >> 8) == ZX297520V3ECO_AZW_UNILC_512M_DDR)
		||((psEfuseInfo->secure_flag >> 8) == ZX297520V3ECO_ZW_APM_512M_DDR)		
		||((psEfuseInfo->secure_flag >> 8) == ZX297520V3ECO_ZW_ESMT_512M_DDR))
	{
		g_ddr_size_flag = CHIP_DDR_IS_64M;
		BOOT_PRINTF(UBOOT_NOTICE, "secure_flag=0x%x.\n", psEfuseInfo->secure_flag);
	}
	else if(((psEfuseInfo->secure_flag >> 8) == ZX297520V3ECOSC_GW_NYC_2G_DDR)
		||((psEfuseInfo->secure_flag >> 8) == ZX297520V3ECOGG_GW_NYC_2G_DDR)
		||((psEfuseInfo->secure_flag >> 8) == ZX297520V3ECOGG_GW_NYC_NOR_2G_DDR)
		||((psEfuseInfo->secure_flag >> 8) == ZX297520V3ECOSC_GW_NYC_NOR_2G_DDR))
	{
		g_ddr_size_flag = CHIP_DDR_IS_256M;
		BOOT_PRINTF(UBOOT_NOTICE, "secure_flag=0x%x.\n", psEfuseInfo->secure_flag);
	}	
	else
	{	
		g_ddr_size_flag = CHIP_DDR_IS_128M;
		BOOT_PRINTF(UBOOT_NOTICE, "secure_flag=0x%x.\n", psEfuseInfo->secure_flag);
	}
	
	if((psEfuseInfo->secure_flag & 0xFF) != 0xFF)
	{
		guiEfuseStatus = 1;	   //Disable.
		BOOT_PRINTF(UBOOT_NOTICE, "secure_flag!=0xFF, SecureVerify->Disable.\n");
		return ;
	}

	/* step 1*/
	for(uiLen = 0; uiLen < 4; uiLen++)
	{
		if(psEfuseInfo->puk_hash[uiLen] != 0)
		{
			break;
		}
		if(uiLen == 3)
		{
			guiEfuseStatus = 1;	   //Disable.
			BOOT_PRINTF(UBOOT_NOTICE, "PubKey_HASH=Invalid, SecureVerify->Disable.\n");
			return ;
		}
	}
	BOOT_PRINTF(UBOOT_NOTICE, "All Flag & Param is Valid, SecureVerify->ENABLE.\n");
	guiEfuseStatus = 0;	   //Enable.
}

static u8 efuse_cmp_word(u32* src, u32* dst, u32 cnt)
{
	u32 i;
	for(i = 0; i < cnt; i++)
	{
		if(src[i] != dst[i])
		{
			return 1;
		}
	}
	return 0;
}

u8 rootfs_secure_verify(u32 addr)
{
    if(g_nor_flag == 1)
	{
		
	    u32 uiLen = 0;
		u32 uiRet = -1;
		u32 uiLoop = 0;
		image_header_t *puiLegacyRootfsAddr = NULL;
		sImageNewHeader *psRootfsHeader = NULL;
		u32 *puiDataLoadAddr = NULL;
		u32 *puiArrPubKeyEN = NULL;
		u32 *puiArrPubKey = NULL;
		u32 *puiArrHASH = NULL;
		otp_struct *psEfuseInfo = NULL;
		u32 uiHashResArr[8] = {0};
		u32 uiHashResLen = 0;
		u32 uiHashVerifySize = 0;
		u32 uiRsaResArr[64] = {0};
		u32 puiArrPubKeyE[64] = {0};
		T_Rsa_Paramter sRSAInput;
		u32 *puiRsaResAddr = NULL;
		u32 sRamKey[9] = {0x0,0x33fa3e31,0x90d8d15a,0x073cee04,0x82ac24aa,0x2262748e,0x1a3663c7,0x4b603f6f,0xd098e0d8};
		if(NULL == addr)
		{
			BOOT_PRINTF(UBOOT_ERR, "Bad Parameter(Empty Pointer)!\n");
			return -1;
		}
	
		psRootfsHeader = (sImageNewHeader *)addr;
		puiLegacyRootfsAddr = (image_header_t *)(addr + sizeof(sImageNewHeader));
		uiHashVerifySize = ___htonl(puiLegacyRootfsAddr->ih_size) + sizeof(image_header_t);
	
		//psEfuseInfo = (otp_struct*)sRamKey;
		psEfuseInfo = (otp_struct*)&otpInfo;
		
		/*
		 * step 0
		 */
		puiArrPubKeyEN = psRootfsHeader->uiPubKeyRsaE;
		uiLen = 380;
		puiArrPubKey = &(psRootfsHeader->uiPubKeyRsaELen);
		sha256_csum_wd((const unsigned char *)puiArrPubKey, uiLen, (unsigned char *)uiHashResArr);
		uiHashResLen = 8;	
		/*Сת*/
		BIG2SMALL(uiHashResArr, 32);
		
		BOOT_PRINTF(UBOOT_DBG, "secure_flag=0x%x.\n", psEfuseInfo->secure_flag);
	
		if(efuse_cmp_word(psEfuseInfo->puk_hash, uiHashResArr, uiHashResLen))
		{
			BOOT_PRINTF(UBOOT_ERR, "PubKey Hash Verify -> Failed !\n");
			return 1;
		}
		puiArrHASH = psRootfsHeader->uiHashY;
	
		/*
		 * step 1
		 */
		memcpy(puiArrPubKeyE+63, puiArrPubKeyEN, 4);
		sRSAInput.udCalMode = RSA_MOD_EXPO_WITH_INIT;
		sRSAInput.udNbitLen = 2048;
		sRSAInput.udEbitLen = 2048;
		sRSAInput.pudInputM = puiArrHASH;
		sRSAInput.pudInputE = puiArrPubKeyE;
		sRSAInput.pudInputN = psRootfsHeader->uiPubKeyRsaN;
		sRSAInput.pudOutputP = uiRsaResArr;
		
		uiRet = Rsa_Calculate(sRSAInput);
		if(uiRet != 0)
		{
			BOOT_PRINTF(UBOOT_ERR, "Rsa_Calculate ERROR(0x%x)!\n", uiRet);
			return 2;
		}
		puiRsaResAddr = sRSAInput.pudOutputP + (64 - uiHashResLen);
	
		/*
		 * step 2
		 */
		uiLen = uiHashVerifySize;
		puiDataLoadAddr = CONFIG_SYS_SDRAM_ROOTFS_BASE - sizeof(image_header_t);
	
		/* Cleanup Output Buffer. */
		uiHashResLen = 0;
		memset(uiHashResArr, 0, 8*sizeof(uiHashResArr[0]));
	
		sha256_csum_wd((const unsigned char *)puiDataLoadAddr, uiLen, (unsigned char *)uiHashResArr);
		uiHashResLen = 8;
		/*Сת*/
		BIG2SMALL(uiHashResArr, 32);
	
		if(efuse_cmp_word(puiRsaResAddr, uiHashResArr, uiHashResLen))
		{
			BOOT_PRINTF(UBOOT_ERR, "LegacyRootfs Verify -> Failed !\n");
			return 3;
		}

	}
	else
	{
	    
	    u32 uiLen = 0;
		u32 uiRet = -1;
		u32 uiLoop = 0;
		image_header_t *puiLegacyRootfsAddr = NULL;
		sImageNewHeader *psRootfsHeader = NULL;
		u32 *puiDataLoadAddr = NULL;
		u32 *puiArrPubKeyEN = NULL;
		u32 *puiArrHASH = NULL;
		efuse_struct *psEfuseInfo = NULL;
		u32 uiHashResArr[4] = {0};
		u32 uiHashResLen = 0;
		u32 uiHashVerifySize = 0;
		u32 uiRsaResArr[32] = {0};
		u32 puiArrPubKeyE[32] = {0};
		u32 puiArrPubKey[64] = {0};
		T_Rsa_Paramter sRSAInput;
		u32 *puiRsaResAddr = NULL;
		{
			BOOT_PRINTF(UBOOT_ERR, "Bad Parameter(Empty Pointer)!\n");
			return -1;
		}
	
		psRootfsHeader = (sImageNewHeader *)addr;
		puiLegacyRootfsAddr = (image_header_t *)(addr + sizeof(sImageNewHeader));
		uiHashVerifySize = ___htonl(puiLegacyRootfsAddr->ih_size) + sizeof(image_header_t);
	
		psEfuseInfo = (efuse_struct*)EFUSE_RAM_BASE;
		
		/*
		 * step 0
		 */
	    
		uiLen = E_N_LEN;
		puiArrPubKeyEN = psRootfsHeader->uiPubKeyRsaE;
		memcpy(puiArrPubKeyE+31, puiArrPubKeyEN, 4);
		memcpy(puiArrPubKey+31, puiArrPubKeyEN, 4);
		memcpy(puiArrPubKey+32, psRootfsHeader->uiPubKeyRsaN, 128);

		Hash_Calculate(HASH_MODE_MD5, HASH_SMALL_ENDIAN, puiArrPubKey, uiLen, NULL, 0, uiHashResArr, &uiHashResLen);

		BOOT_PRINTF(UBOOT_DBG, "secure_flag=0x%x.\n", psEfuseInfo->secure_flag);

		if(efuse_cmp_word(psEfuseInfo->puk_hash, uiHashResArr, uiHashResLen))
		{
			BOOT_PRINTF(UBOOT_ERR, "PubKey Hash Verify -> Failed !\n");
			return 1;
		}
		puiArrHASH = psRootfsHeader->uiHashY;
		
		/*
		 * step 1
		 */
		sRSAInput.udCalMode = RSA_MOD_EXPO_WITH_INIT;
		sRSAInput.udNbitLen = 1024;
		sRSAInput.udEbitLen = 1024;
		sRSAInput.pudInputM = puiArrHASH;
		sRSAInput.pudInputE = puiArrPubKeyE;
		sRSAInput.pudInputN = psRootfsHeader->uiPubKeyRsaN;
		sRSAInput.pudOutputP = uiRsaResArr;
		
		uiRet = Rsa_Calculate(sRSAInput);
		if(uiRet != 0)
		{
			BOOT_PRINTF(UBOOT_ERR, "Rsa_Calculate ERROR(0x%x)!\n", uiRet);
			return 2;
		}
		puiRsaResAddr = sRSAInput.pudOutputP + (32 - uiHashResLen);
	
		/*
		 * step 2
		 */
		uiLen = uiHashVerifySize;
		puiDataLoadAddr = CONFIG_SYS_SDRAM_ROOTFS_BASE - sizeof(image_header_t);
	
		/* Cleanup Output Buffer. */
		uiHashResLen = 0;
		memset(uiHashResArr, 0, 4*sizeof(uiHashResArr[0]));
	
		uiRet = Hash_Calculate(HASH_MODE_MD5, HASH_SMALL_ENDIAN, puiDataLoadAddr, uiLen, NULL, 0, uiHashResArr, &uiHashResLen);
		if(uiRet != 0)
		{
			BOOT_PRINTF(UBOOT_ERR, "Hash_Calculate ERROR(0x%x)!\n", uiRet);
			return -1;
		}
	
		if(efuse_cmp_word(puiRsaResAddr, uiHashResArr, uiHashResLen))
		{
			BOOT_PRINTF(UBOOT_ERR, "LegacyRootfs Verify -> Failed !\n");
			return 3;
		}
	}
    
	return 0;
}

u8 secure_verify(u32 addr)
{
    if(g_nor_flag != 1){
		u32 uiLen = 0;
		u32 uiRet = -1;
		u32 uiLoop = 0;
		image_header_t *puiLegacyImgAddr = NULL;
		sImageNewHeader *psImageHeader = NULL;
		u32 *puiDataLoadAddr = NULL;
		u32 *puiArrPubKeyEN = NULL;
		u32 *puiArrHASH = NULL;

		efuse_struct *psEfuseInfo = NULL;

		u32 uiHashResArr[4] = {0};
		u32 uiHashResLen = 0;
		u32 uiHashVerifySize = 0;
		u32 uiRsaResArr[32] = {0};
		u32 puiArrPubKeyE[32] = {0};
		u32 puiArrPubKey[64] = {0};

		T_Rsa_Paramter sRSAInput;
		u32 *puiRsaResAddr = NULL;

		if(NULL == addr)
		{
			BOOT_PRINTF(UBOOT_ERR, "Bad Parameter(Empty Pointer)!\n");
			return -1;
		}

		psImageHeader = (sImageNewHeader *)addr;

		if(rootfs_flag == 1)
		{
	        puiLegacyImgAddr = (image_header_t *)(addr + sizeof(sImageNewHeader) + sizeof(sImageNewHeader) + sizeof(image_header_t));
		    uiHashVerifySize = ___htonl(puiLegacyImgAddr->ih_size) + sizeof(image_header_t) + sizeof(image_header_t) + sizeof(sImageNewHeader);
		}
		else
		{
	        puiLegacyImgAddr = (image_header_t *)(addr + sizeof(sImageNewHeader));
		    uiHashVerifySize = ___htonl(puiLegacyImgAddr->ih_size) + sizeof(image_header_t);
		}

		psEfuseInfo = (efuse_struct*)EFUSE_RAM_BASE;

		BOOT_PRINTF(UBOOT_NOTICE, "uiHashVerifySize=0x%x, EFUSE_RAM_BASE=0x%x.\n", uiHashVerifySize, EFUSE_RAM_BASE);

		/*
		 * step 0
		 */
		uiLen = E_N_LEN;
		puiArrPubKeyEN = psImageHeader->uiPubKeyRsaE;
		memcpy(puiArrPubKeyE+31, puiArrPubKeyEN, 4);
		memcpy(puiArrPubKey+31, puiArrPubKeyEN, 4);
		memcpy(puiArrPubKey+32, psImageHeader->uiPubKeyRsaN, 128);

		Hash_Calculate(HASH_MODE_MD5, HASH_SMALL_ENDIAN, puiArrPubKey, uiLen, NULL, 0, uiHashResArr, &uiHashResLen);

		BOOT_PRINTF(UBOOT_DBG, "secure_flag=0x%x.\n", psEfuseInfo->secure_flag);

		if(efuse_cmp_word(psEfuseInfo->puk_hash, uiHashResArr, uiHashResLen))
		{
			BOOT_PRINTF(UBOOT_ERR, "PubKey Hash Verify -> Failed !\n");
			return 1;
		}
		puiArrHASH = psImageHeader->uiHashY;

		/*
		 * step 1
		 */
		sRSAInput.udCalMode = RSA_MOD_EXPO_WITH_INIT;
		sRSAInput.udNbitLen = 1024;
		sRSAInput.udEbitLen = 1024;
		sRSAInput.pudInputM = puiArrHASH;
		sRSAInput.pudInputE = puiArrPubKeyE;
		sRSAInput.pudInputN = psImageHeader->uiPubKeyRsaN;
		sRSAInput.pudOutputP = uiRsaResArr;

		uiRet = Rsa_Calculate(sRSAInput);
		if(uiRet != 0)
		{
			BOOT_PRINTF(UBOOT_ERR, "Rsa_Calculate ERROR(0x%x)!\n", uiRet);
			return 2;
		}
		puiRsaResAddr = sRSAInput.pudOutputP + (32 - uiHashResLen);

		/*
		 * step 2
		 */
		uiLen = uiHashVerifySize;
		if(rootfs_flag == 1)
		{
	        puiDataLoadAddr = ___htonl(puiLegacyImgAddr->ih_load) - sizeof(image_header_t) - sizeof(image_header_t) - sizeof(sImageNewHeader);
		}
		else
		{
		    if(1 == m0_flag || 1 == zsp_flag){
				puiDataLoadAddr = (uchar *)addr + sizeof(sImageNewHeader);

			}else{
				puiDataLoadAddr = ___htonl(puiLegacyImgAddr->ih_load) - sizeof(image_header_t);
			}			

		}
		
		/* Cleanup Output Buffer. */
		uiHashResLen = 0;
		memset(uiHashResArr, 0, 4*sizeof(uiHashResArr[0]));

		uiRet = Hash_Calculate(HASH_MODE_MD5, HASH_SMALL_ENDIAN, puiDataLoadAddr, uiLen, NULL, 0, uiHashResArr, &uiHashResLen);
		if(uiRet != 0)
		{
			BOOT_PRINTF(UBOOT_ERR, "Hash_Calculate ERROR(0x%x)!\n", uiRet);
			return -1;
		}

		if(efuse_cmp_word(puiRsaResAddr, uiHashResArr, uiHashResLen))
		{
			BOOT_PRINTF(UBOOT_ERR, "LegacyImg Verify -> Failed !\n");
			return 3;
		}

	}
	else
    {
        u32 uiLen = 0;
		u32 uiRet = -1;
		u32 uiLoop = 0;
		image_header_t *puiLegacyImgAddr = NULL;
		sImageNewHeader *psImageHeader = NULL;
		u32 *puiDataLoadAddr = NULL;
		u32 *puiArrPubKeyEN = NULL;
		u32 *puiArrPubKey = NULL;
		u32 *puiArrHASH = NULL;
		otp_struct *psEfuseInfo = NULL;
		u32 uiHashResArr[8] = {0};
		u32 uiHashResLen = 0;
		u32 uiHashVerifySize = 0;
		u32 uiRsaResArr[64] = {0};
        u32 puiArrPubKeyE[64] = {0};
		T_Rsa_Paramter sRSAInput;
		u32 *puiRsaResAddr = NULL;
        u32 sRamKey[9] = {0x0,0x33fa3e31,0x90d8d15a,0x073cee04,0x82ac24aa,0x2262748e,0x1a3663c7,0x4b603f6f,0xd098e0d8};
		if(NULL == addr)
		{
			BOOT_PRINTF(UBOOT_ERR, "Bad Parameter(Empty Pointer)!\n");
			return -1;
		}

		psImageHeader = (sImageNewHeader *)addr;

	    if(rootfs_flag == 1)
		{
	        puiLegacyImgAddr = (image_header_t *)(addr + sizeof(sImageNewHeader) + sizeof(sImageNewHeader) + sizeof(image_header_t));
		    uiHashVerifySize = ___htonl(puiLegacyImgAddr->ih_size) + sizeof(image_header_t) + sizeof(image_header_t) + sizeof(sImageNewHeader);
		}
		else
		{
	        puiLegacyImgAddr = (image_header_t *)(addr + sizeof(sImageNewHeader));
		    uiHashVerifySize = ___htonl(puiLegacyImgAddr->ih_size) + sizeof(image_header_t);
		}

		psEfuseInfo = (otp_struct*)&otpInfo;
		//psEfuseInfo = (otp_struct*)sRamKey;
		
		/*
		 * step 0
		 */
		uiLen = 380;
		puiArrPubKey = &(psImageHeader->uiPubKeyRsaELen);
		puiArrPubKeyEN = psImageHeader->uiPubKeyRsaE;
        sha256_csum_wd((const unsigned char *)puiArrPubKey, uiLen, (unsigned char *)uiHashResArr);
	    uiHashResLen = 8;	
		/*Сת*/
	    BIG2SMALL(uiHashResArr, 32);

		BOOT_PRINTF(UBOOT_DBG, "secure_flag=0x%x.\n", psEfuseInfo->secure_flag);

		if(efuse_cmp_word(psEfuseInfo->puk_hash, uiHashResArr, uiHashResLen))
		{
			BOOT_PRINTF(UBOOT_ERR, "PubKey Hash Verify -> Failed !\n");
			return 1;
		}
		puiArrHASH = psImageHeader->uiHashY;

		/*
		 * step 1
		 */
		memcpy(puiArrPubKeyE+63, puiArrPubKeyEN, 4);
		sRSAInput.udCalMode = RSA_MOD_EXPO_WITH_INIT;
		sRSAInput.udNbitLen = 2048;
		sRSAInput.udEbitLen = 2048;
		sRSAInput.pudInputM = puiArrHASH;
		sRSAInput.pudInputE = puiArrPubKeyE;
		sRSAInput.pudInputN = psImageHeader->uiPubKeyRsaN;
		sRSAInput.pudOutputP = uiRsaResArr;

		uiRet = Rsa_Calculate(sRSAInput);
		if(uiRet != 0)
		{
			BOOT_PRINTF(UBOOT_ERR, "Rsa_Calculate ERROR(0x%x)!\n", uiRet);
			return 2;
		}
		puiRsaResAddr = sRSAInput.pudOutputP + (64 - uiHashResLen);

		/*
		 * step 2
		 */
		uiLen = uiHashVerifySize;
		if(rootfs_flag == 1)
		{
	        puiDataLoadAddr = ___htonl(puiLegacyImgAddr->ih_load) - sizeof(image_header_t) - sizeof(image_header_t) - sizeof(sImageNewHeader);
		}
		else
		{
		    if(1 == m0_flag || 1 == zsp_flag){
				puiDataLoadAddr = (uchar *)addr + sizeof(sImageNewHeader);
				
			}else{
			    puiDataLoadAddr = ___htonl(puiLegacyImgAddr->ih_load) - sizeof(image_header_t);

			}
		}
	   
		uiHashResLen = 0;
		memset(uiHashResArr, 0, 8*sizeof(uiHashResArr[0]));

		sha256_csum_wd((const unsigned char *)puiDataLoadAddr, uiLen, (unsigned char *)uiHashResArr);
		uiHashResLen = 8;
		/*Сת*/
	    BIG2SMALL(uiHashResArr, 32);

		if(efuse_cmp_word(puiRsaResAddr, uiHashResArr, uiHashResLen))
		{
			BOOT_PRINTF(UBOOT_ERR, "LegacyImg Verify -> Failed !\n");
			return 3;
		}

	}

	return 0;
}

void efuse_get_devinfo(efuse_struct *efuse_info)
{
	u32 i;
	efuse_struct *s_efuse = (efuse_struct*)EFUSE_RAM_BASE;
	
	efuse_read_prepare();
	
	efuse_info->secure_flag = s_efuse->secure_flag;

	for(i = 0; i < 4; i ++)
	{
		efuse_info->puk_hash[i] = s_efuse->puk_hash[i];
	}

	for(i = 0; i < 3; i ++)
	{
		efuse_info->dev_id[i] = s_efuse->dev_id[i];

	}	
	
}
/*******************************************************************************
* Function: efuse_init
* Description:
* Parameters:
*   Input:
*
*   Output:
*
* Returns:
*
* Others:
********************************************************************************/
int efuse_init(void)
{
	/* Init Once is Enough. */
	if(gbEfuseReadFlag == 0)
	{
		efuse_read_prepare();
		gbEfuseReadFlag = 1;
		BOOT_PRINTF(UBOOT_DBG, "gbEfuseReadFlag=1.\n");
	}

	/* Efuse Status decide ENABLE/DISABLE SecureVerify. */
	efuse_get_data();

	/*OTP status*/

	if(g_nor_flag == 1)
	{	
        g_iftype = IF_TYPE_NOR;
		nand_init();
		/*лʼspi_nand*/
		g_iftype = IF_TYPE_SPI_NAND;
		nand_init();

		get_otp_secure_verify_status();
	}
		
	return 0;
}


