/*******************************************************************************
* Copyright (C) 2014, ZTE Corporation.
*
* File Name:   hal_gpio.h
* File Mark:
* Description: 
* Others:
* Version:       v1.0
* Author:        zhangdongdong
* Date:          2015-07-31
* History 1:
*     Date:
*     Version:
*     Author:
*     Modification:
* History 2:
********************************************************************************/

#ifndef _HAL_GPIO_H
#define _HAL_GPIO_H


/****************************************************************************
*                                           Include files
****************************************************************************/

/****************************************************************************
*                                           Macros
****************************************************************************/
#define reg32(addr)			(*(volatile unsigned long *)(addr))

#define get_reg_val(regAddr)            reg32(regAddr)
#define set_reg_val(regAddr,regVal)     reg32(regAddr) = regVal

#define set_reg_bit(regName, bitAddr, bitValue)      \
do{                                                  \
    if(bitValue == TRUE)                             \
        reg32(regName) |= (0x1<<bitAddr);            \
    else                                             \
        reg32(regName) &= ~(0x1<<bitAddr);           \
}while(0)

#define set_reg_bits(regName, bitsAddr, bitsLen, bitsValue)   \
do{                                                             \
    reg32(regName) = (reg32(regName)&(~(((0x1<<bitsLen)-0x1)<<bitsAddr)))|(bitsValue<<bitsAddr);\
}while(0)

#define INVLID_ADDR 0xffffffff
#define INVLID_VALUE 0xffff
/****************************************************************************
*                                           Types
****************************************************************************/

typedef signed char SINT8;
typedef unsigned char UINT8;

typedef signed short SINT16;
typedef unsigned short UINT16;

typedef signed int SINT32;
typedef unsigned int UINT32;
typedef signed char  CHAR;

typedef struct _T_GpioRegCfgInfo
{
    UINT32 regBase;          /*gpio operation register base address*/
    UINT16 offset;           /*gpio operation domain offset in register*/
    UINT16 size;             /*gpio operation domain size*/
} T_GpioRegCfgInfo;

typedef struct _T_Gpio
{
    const char name[22];                     /*gpio name*/
    const UINT32 gpio;
    UINT32 flag;
    const T_GpioRegCfgInfo pdFuncSel;        /*gpio pd func sel*/
    const T_GpioRegCfgInfo aonFuncSel;       /*gpio aon func sel*/
    const T_GpioRegCfgInfo topFuncSel;       /*gpio top func sel, 0:aon  1:pd*/
    const T_GpioRegCfgInfo ioCfg;            /*gpio config*/
} T_Gpio;

typedef enum{
	
	NAND_WE             = 0  ,
	NAND_CSN            = 1  ,
	NAND_READY          = 2  ,
	NAND_CLE_            = 3  ,
	NAND_ALE_            = 4  ,
	NAND_RE             = 5  ,
	NAND_WP             = 6  ,
	NAND_DATA0          = 7  ,
	NAND_DATA1          = 8  ,
	NAND_DATA2          = 9  ,
	NAND_DATA3          = 10 ,
	NAND_DATA4          = 11 ,
	NAND_DATA5          = 12 ,
	NAND_DATA6          = 13 ,
	NAND_DATA7          = 14 ,
	CLK_OUT0            = 15 ,
	CLK_OUT1            = 16 ,
	CLK_OUT2            = 17 ,
	CLK_32K_OUT         = 18 ,
	CLK_REQ0            = 19 ,
	PWR_CTRL1           = 20 ,
	SSP0_CS             = 21 ,
	SSP0_CLK            = 22 ,
	SSP0_RXD            = 23 ,
	SSP0_TXD            = 24 ,
	UART0_RXD           = 25 ,
	UART0_TXD           = 26 ,
	UART0_CTS           = 27 ,
	UART0_RTS           = 28 ,
	I2S0_WS             = 29 ,
	I2S0_CLK            = 30 ,
	I2S0_DIN            = 31 ,
	I2S0_DOUT           = 32 ,
	I2S1_WS             = 33 ,
	I2S1_CLK            = 34 ,
	I2S1_DIN            = 35 ,
	I2S1_DOUT           = 36 ,
	SCL0                = 37 ,
	SDA0                = 38 ,
	SCL1                = 39 ,
	SDA1                = 40 ,
	EXT_INT0            = 41 ,
	EXT_INT1            = 42 ,
	EXT_INT2            = 43 ,
	EXT_INT3            = 44 ,
	EXT_INT4            = 45 ,
	EXT_INT5            = 46 ,
	EXT_INT6            = 47 ,
	EXT_INT7            = 48 ,
	SD1_CLK             = 49 ,
	SD1_CMD             = 50 ,
	SD1_DATA0           = 51 ,
	SD1_DATA1           = 52 ,
	SD1_DATA2           = 53 ,
	SD1_DATA3           = 54 ,
	JTAG_TCK            = 55 ,
	JTAG_TDI            = 56 ,
	JTAG_TDO            = 57 ,
	JTAG_TMS            = 58 ,
	JTAG_TRST           = 59 ,
	KBC_0               = 60 ,
	KBC_1               = 61 ,
	KBC_2               = 62 ,
	KBC_3               = 63 ,
	KBR_0               = 64 ,
	KBR_1               = 65 ,
	KBR_2               = 66 ,
	KBR_3               = 67 ,
	LTE_TDD_TXRX_DATA0  = 68 ,
	LTE_TDD_TXRX_DATA1  = 69 ,
	LTE_TDD_TXRX_DATA2  = 70 ,
	LTE_TDD_TXRX_DATA3  = 71 ,
	LTE_TDD_TXRX_DATA4  = 72 ,
	LTE_TDD_TXRX_DATA5  = 73 ,
	LTE_TDD_TXRX_DATA6  = 74 ,
	LTE_TDD_TXRX_DATA7  = 75 ,
	LTE_TDD_TXRX_DATA8  = 76 ,
	LTE_TDD_TXRX_DATA9  = 77 ,
	LTE_TDD_TXRX_DATA10 = 78 ,
	LTE_TDD_TXRX_DATA11 = 79 ,
	LTE_TDD_RX_DATA0    = 80 ,
	LTE_TDD_RX_DATA1    = 81 ,
	LTE_TDD_RX_DATA2    = 82 ,
	LTE_TDD_RX_DATA3    = 83 ,
	LTE_TDD_RX_DATA4    = 84 ,
	LTE_TDD_RX_DATA5    = 85 ,
	LTE_TDD_RX_DATA6    = 86 ,
	LTE_TDD_RX_DATA7    = 87 ,
	LTE_TDD_RX_DATA8    = 88 ,
	LTE_TDD_RX_DATA9    = 89 ,
	LTE_TDD_RX_DATA10   = 90 ,
	LTE_TDD_RX_DATA11   = 91 ,
	FCLK                = 92 ,
	FRAME_TX            = 93 ,
	FRAME_RX            = 94 ,
	MCLK                = 95 ,
	LTE_REF_CLK         = 96 ,
	LTE_TXRX_EN         = 97 ,
	LTE_TXRX_SWITCH     = 98 ,
	RESETB_OUT          = 99 ,
	PDN_GSM             = 100,
	WAKE_UP             = 101,
	RF_SPI0_STR0        = 102,
	RF_SPI0_STR1        = 103,
	RF_SPI0_CLK         = 104,
	RF_SPI0_DIN         = 105,
	RF_SPI0_DATA        = 106,
	RF_SPI1_STR         = 107,
	RF_SPI1_CLK         = 108,
	RF_SPI1_DIN         = 109,
	RF_SPI1_DATA        = 110,
	RF_CONTROL0         = 111,
	RF_CONTROL1         = 112,
	RF_CONTROL2         = 113,
	RF_CONTROL3         = 114,
	RF_CONTROL4         = 115,
	RF_CONTROL5         = 116,
	RF_CONTROL6         = 117,
	RF_CONTROL7         = 118,
	RF_CONTROL8         = 119,
	RF_CONTROL9         = 120,
	RF_CONTROL10        = 121,
	RF_CONTROL11        = 122,
	RF_CONTROL12        = 123,
	RF_CONTROL13        = 124,
	RF_CONTROL14        = 125,
	RF_CONTROL15        = 126,
	RF_CONTROL16        = 127,
	RF_CONTROL17        = 128,
	RF_CONTROL18        = 129,
	RF_CONTROL19        = 130,
	RF_CONTROL20        = 131,
	RF_CONTROL21        = 132,
	RF_CONTROL22        = 133,
	RF_CONTROL23        = 134,
	RMII_CLK_I          = 135,
	RMII_CLK_O          = 136,
	RMII_TXEN           = 137,
	RMII_RXEN           = 138,
	RMII_RXD0           = 139,
	RMII_RXD1           = 140,
	RMII_TXD0           = 141,
	RMII_TXD1           = 142,
	MDC_SCLK            = 143,
	MDC_SDIO            = 144,
	PHY_RST             = 145,
				
}T_ZDrvGpio_Name;

#endif

