/*********************************************************************
 Copyright 2014 by  ZTE Corporation.
*
* FileName::    spifc.c
* File Mark:
* Description:  
* Others:
* Version:  
* Author:  
* Date:   

* History 1:
*     Date: 
*     Version:
*     Author: 
*     Modification:
* History 2:
**********************************************************************/

#include <malloc.h> 
#include <errno.h>
#include <asm/io.h> 
#include <linux/mtd/mtd.h>
#include <asm-generic/ioctl.h>
#include <config.h>
#include <common.h>
#include <command.h>
#include <asm/arch/nand.h> 
#include <linux/mtd/nand.h>
#include <asm/arch/lsp_crpm.h>
#include <drvs_gpio.h>
#include "zxic_spifc.h"
#include "spi_nand.h"
#include <../drivers/dma/zx29_dma.h>

extern struct nand_flash_device_para nand_flash_para[];
extern struct mtd_info nand_info[];
extern struct nand_chip nand_chip[];
extern struct nand_flash_device_para *g_nand_dev_info;
extern unsigned char  g_maf_id;
extern unsigned char g_dev_id;
extern g_nor_flag;
struct spi_nand_info spifc_nand;
struct spi_nand_info *g_spifc = &spifc_nand;

#define	TRANS_USE_DMA	1

/* SPI NAND FLASH COMMAND FORMAT TYPE */
/********************************************************************************
  [Instruction]                 |--write enable
                                |--write disable
                                |--reset

  [Instruction]                 |--addr width is 24 bit
  [addr]                        |--page read to cache
                                |--block erase
                                |--program execute

  [Instruction]                 |--addr width is 8 bit
  [addr]                        |--set feature
  [data_tx]                     |--addr width is 16 bit
                                |--program load(X1,X4)
                                |--program load random data(X1,X4)
                                |--program load random data quad IO

  [Instruction]                 |--addr width is 8 bit
  [addr]                        |--get feature
  [data_rx]                     |--read id
  
  [Instruction]                 |--addr width is 16 bit
  [addr]                        |--dummy cycel 8/4/2
  [dummy]                       |--read form cache(X1,X2,X4)
  [data_rx]                     |--read form cache(dual,quad)IO

********************************************************************************/
uint32_t spifc_get_reg_base(void)
{
	return (uint32_t)SYS_SPI_NAND_BASE;
}

/*******************************************************************************
 * Function:    spifc_set_timing
 * Description: 
 * Parameters:
 *	 Input:
 *
 *	 Output:
 *
 * Returns:
 *
 *
 * Others:
 ********************************************************************************/
void spifc_set_timing(uint32_t rd_delay, uint32_t cs_setup, 
                                uint32_t cs_hold, uint32_t cs_desel)
{
    volatile struct spifc_reg_t* spi	= (struct spifc_reg_t*)spifc_get_reg_base();
    
    spi->SFC_TIMING = 0;
    spi->SFC_TIMING  |= ((rd_delay&0x3) << 16)|((cs_setup&0x7) <<11)|
                        ((cs_hold&0x7) << 6)|((cs_desel&0xf) << 0);
}

/*******************************************************************************
 * Function:    spifc_set_clk
 * Description: 
 * Parameters:
 *	 Input:
 *
 *	 Output:
 *
 * Returns:
 *
 *
 * Others:
 ********************************************************************************/
void spifc_set_clk(void)
{
    uint32_t clk_reg = 0;

	clk_reg = readl(SPIFC_CLKSEL);
	clk_reg &= ~0x00000070;

	if((g_maf_id == NAND_MFR_EMST) && (g_dev_id == NAND_DEVID_EMST_F50D1G41LB_1G))
	{
		clk_reg |= (0x3 << 4);       /*104MHz*/
	}
	else
	{
		clk_reg |= (0x2 << 4);       /*124.8MHz*/
	}

	writel(clk_reg, SPIFC_CLKSEL);  

    return;
}

/*******************************************************************************
 * Function:    spi_fc_enable
 * Description: 
 * Parameters:
 *	 Input:
 *
 *	 Output:
 *
 * Returns:
 *
 *
 * Others:
 ********************************************************************************/
static void spi_fc_enable(void)
{
    volatile struct spifc_reg_t* spi	= (struct spifc_reg_t*)spifc_get_reg_base();
    
    if( spi->SFC_EN & FC_EN_BACK )
        return;
    
    spi->SFC_EN |= FC_EN;  
    spi->SFC_CTRL0 |= FC_SCLK_PAUSE_EN;
}


/*******************************************************************************
 * Function:    spi_fc_disable
 * Description: 
 * Parameters:
 *	 Input:
 *
 *	 Output:
 *
 * Returns:
 *
 *
 * Others:
 ********************************************************************************/
static void spi_fc_disable( void )
{
    volatile struct spifc_reg_t* spi	= (struct spifc_reg_t*)spifc_get_reg_base();
    
    if( !(spi->SFC_EN & FC_EN_BACK) )
        return;

    spi->SFC_EN &= (~FC_EN);    
}


/*******************************************************************************
 * Function:    spi_fc_clear_fifo
 * Description: 
 * Parameters:
 *	 Input:
 *
 *	 Output:
 *
 * Returns:
 *
 *
 * Others:
 ********************************************************************************/
void spi_fc_clear_fifo( void )
{
    volatile struct spifc_reg_t* spi	= (struct spifc_reg_t*)spifc_get_reg_base();
    
    spi->SFC_CTRL0 |= (FC_RXFIFO_THRES | FC_TXFIFO_THRES | 
                       FC_RXFIFO_CLR | FC_TXFIFO_CLR);
}


/*******************************************************************************
 * Function:    spi_fc_config_ctrl
 * Description: FIFOݣǷʹDMA
 * Parameters:
 *	 Input:
 *
 *	 Output:
 *
 * Returns:
 *
 *
 * Others:  
 ********************************************************************************/
static void spi_fc_config_ctrl( uint32_t dma )
{
    volatile struct spifc_reg_t* spi	= (struct spifc_reg_t*)spifc_get_reg_base();
    
    /* config DMA */
    if( dma == FC_DMA_TX )
        spi->SFC_CTRL0 |= FC_TX_DMA_EN;
    else if( dma == FC_DMA_RX )
        spi->SFC_CTRL0 |= FC_RX_DMA_EN;
	else
		spi->SFC_CTRL0 &= ~(FC_RX_DMA_EN|FC_TX_DMA_EN);
}


/*******************************************************************************
 * Function:    spi_fc_setup_cmd
 * Description: 
 * Parameters:
 *	 Input:
 *
 *	 Output:
 *
 * Returns:
 *
 *
 * Others:
 ********************************************************************************/
static void spi_fc_setup_cmd( struct spiflash_cmd_t *cmd, 
                                                uint32_t addr, uint32_t len )
{   
    volatile struct spifc_reg_t* spi	= (struct spifc_reg_t*)spifc_get_reg_base();
    uint32_t wrap = 0;	
    uint32_t tmp = 0;

    /*  */  
    spi->SFC_INS = cmd->cmd;

    /* ݳ */
    if( len )
        spi->SFC_BYTE_NUM = len - 1;
    else
        spi->SFC_BYTE_NUM = 0;  

    switch( len )
    {
        case 2048:
            wrap = WRAP_SIZE_MAIN;
            break;
        case 2112:
            wrap = WRAP_SIZE_MAIN_OOB;
            break;
        case 64:
            wrap = WRAP_SIZE_OOB;
            break;
        default:
            wrap = 0;
            break;
    }

    /* ַ */
    switch( spi->SFC_INS )
    {
        case CMD_READ_FROM_CACHE:
        //  case CMD_READ_FROM_CACHE_X2:
        case CMD_READ_FROM_CACHE_X4:
        case CMD_READ_FROM_CACHE_QIO:
        case CMD_PROGRAM_LOAD:
        case CMD_PROGRAM_LOAD_X4:
            // case CMD_PROGRAM_LOAD_RANDOM:
            //  case CMD_PROGRAM_LOAD_RANDOM_X4:
            //case CMD_PROGRAM_LOAD_RANDOM_QIO:
            addr |= wrap;
            break;
            
        default:
            addr = addr;
            break;
    }
    spi->SFC_ADDR = addr;  

    /* ַ롢ڡ/д ʹ */
    spi->SFC_CTRL1 = 0;
    spi->SFC_CTRL1 = ((cmd->addr_tx_en << FC_ADDR_TX_EN) |  
                      (cmd->dumy_tx_en << FC_DUMMY_TX_EN) | 
                      (cmd->data_rx_en << FC_READ_DAT_EN) | 
                      (cmd->data_tx_en << FC_WRITE_DAT_EN)); 
                    

    /* ַ(1234ֽ)ַ/߶ȡģʽ */
    tmp = spi->SFC_CTRL2;
    tmp &= 0x1f;
    tmp |= ((cmd->dumy_bytes << FC_DUMMY_BYTE_NUM) |
            (cmd->dumy_bits << FC_DUMMY_BIT_NUM) |
            (cmd->addr_width << FC_ADDR_BYTE_NUM));
    spi->SFC_CTRL2 = tmp;
}


/*******************************************************************************
 * Function:    spi_fc_clear_int
 * Description: 
 * Parameters:
 *	 Input:
 *
 *	 Output:
 *
 * Returns:
 *
 *
 * Others:
 ********************************************************************************/
 void spi_fc_clear_int( void )
{
    volatile struct spifc_reg_t* spi	= (struct spifc_reg_t*)spifc_get_reg_base();
    
    if(spi->SFC_INT_RAW & 0x2)
        printf("Spi-Nand Int Format error!\n");

    spi->SFC_INT_SW_CLR = 0xFF; //clear int ?
    
}

/*******************************************************************************
 * Function:    spi_nand_wait_cmd_end
 * Description: 
 * Parameters:
 *	 Input:
 *
 *	 Output:
 *
 * Returns:
 *
 *
 * Others:
 ********************************************************************************/
static int spi_fc_wait_cmd_end( void )
{
    volatile struct spifc_reg_t* spi	= (struct spifc_reg_t*)spifc_get_reg_base();
    uint32_t int_status = 0;
    
    while( spi->SFC_START & FC_BUSY ); 

    while(!(spi->SFC_INT_RAW & FC_INT_RAW_CMD_END));
    
    int_status = spi->SFC_INT_RAW;
    spi->SFC_INT_SW_CLR = int_status;           /* ж */   

    if( int_status & FC_INT_RAW_TX_UNDERRUN )
    {   
        printf("    Spi-fc Nand Failed: TX_UNDERRUN\n");
        return -EIO;
    }

    if( int_status & FC_INT_RAW_RX_OVERRUN )
    {   
        printf("    Spi-fc Nand Failed: RX_UNDERRUN\n");
        return -EIO;
    }

    if( int_status & FC_INT_RAW_WDOG_OVERRUN )
    {   
        printf("    Spi-fc Nand Failed: WDOG_OVERRUN\n");
        return -EIO;
    }

    if( int_status & FC_INT_RAW_FMT_ERR )
    {   
        printf("    Spi-fc Nand Failed: FMT_ERR\n");
        return -EIO;
    }

    if( int_status & FC_INT_RAW_CMD_END )
    {   
        return SUCCESS;
    }
    else
    {
        return -EIO;
    }  
    
}


/*******************************************************************************
 * Function:    spi_fc_read_fifo_one_byte
 * Description: 
 * Parameters:
 *	 Input:
 *
 *	 Output:
 *
 * Returns:
 *
 *
 * Others:  only for:
                [Instruction]                 |--addr width is 8 bit
                [addr]                        |--get feature
                [data_rx]   
 ********************************************************************************/
static int spi_fc_read_fifo_one_byte( uint8_t *value )
{
    uint32_t sw = 0;
    volatile struct spifc_reg_t* spi	= (struct spifc_reg_t*)spifc_get_reg_base();

    sw = spi->SFC_SW;
    
    if( ((sw >> FC_RX_FIFO_CNT) & FC_RX_FIFO_CNT_MASK) != 1 )
    {
        printf("[SPI-NAND][-ERROR-][spi_fc_read_fifo_one_byte][SFC_SW] = 0x%0x\n", sw );
        return -EIO;
    }

    *value = (uint8_t)spi->SFC_DATA;   
    
    return SUCCESS;
}


/*******************************************************************************
 * Function:    spi_fc_read_fifo
 * Description:fifoݣֱĸ 
 * Parameters:
 *	 Input:
 *
 *	 Output:
 *
 * Returns:
 *
 *
 * Others:
 ********************************************************************************/
static uint32_t spi_fc_read_fifo( uint32_t len, uint8_t *buf )
{
    volatile struct spifc_reg_t* spi	= (struct spifc_reg_t*)spifc_get_reg_base();
    uint32_t *p = (uint32_t *)buf;
    uint32_t cnt = 0;
   
    while(cnt < ((len+3)>>2))  
    {
        if(spi->SFC_SW & (FC_RX_FIFO_CNT_MASK<<FC_RX_FIFO_CNT))//rx fifo not empty
        {           
            p[cnt++]= spi->SFC_DATA;
        }
    }


    return (cnt<<2);

}


/*******************************************************************************
 * Function:    spi_fc_write_fifo_one_byte
 * Description:
 * Parameters:
 *	 Input:
 *
 *	 Output:
 *
 * Returns:
 *
 *
 * Others:
 ********************************************************************************/
uint32_t spi_fc_write_fifo_one_byte(uint32_t len, uint8_t* value)
{
    uint32_t sw = 0;
    volatile struct spifc_reg_t* spi	= (struct spifc_reg_t*)spifc_get_reg_base();

    sw = spi->SFC_SW;
    
    if( ((sw >> FC_TX_FIFO_CNT) & FC_TX_FIFO_CNT_MASK) != 0x10 )/* Ϊ */
    {
        printf("[SPI-NAND][-ERROR-][spi_fc_write_fifo_one_byte][SFC_SW] = 0x%0x\n", sw );
        return -EIO;
    }

    spi->SFC_DATA = (uint32_t)(*value);   
    
    return SUCCESS;
}


/*******************************************************************************
 * Function:    spi_fc_write_fifo
 * Description: 
 * Parameters:
 *	 Input:
 *
 *	 Output:
 *
 * Returns:
 *
 *
 * Others:
 ********************************************************************************/
static uint32_t spi_fc_write_fifo(uint8_t* buf, uint32_t buf_len, uint8_t* oob, uint32_t oob_len)
{
    uint32_t *main_area = (uint32_t *)buf;
    uint32_t *spear_area = (uint32_t *)oob;
    uint32_t cnt = 0;
    volatile struct spifc_reg_t* spi = (struct spifc_reg_t*)spifc_get_reg_base();

    while(cnt < (buf_len>>2))  
    {
        if(spi->SFC_SW & (FC_TX_FIFO_CNT_MASK<<FC_TX_FIFO_CNT))//tx fifo not full
        {           
            spi->SFC_DATA = main_area[cnt++];
        }
    }

    cnt = 0;
    if( oob != NULL )
    {
		while(cnt < (oob_len>>2))  			
        {
            if(spi->SFC_SW & (FC_TX_FIFO_CNT_MASK<<FC_TX_FIFO_CNT))//tx fifo not full
            {           
                spi->SFC_DATA = spear_area[cnt++];
            }
        }
    }

    return (cnt<<2);
}
/*******************************************************************************
 * Function:    spi_fc_start
 * Description: 
 * Parameters:
 *	 Input:
 *
 *	 Output:
 *
 * Returns:
 *
 *
 * Others:
 ********************************************************************************/
static void spi_fc_start( void )
{
    volatile struct spifc_reg_t* spi	= (struct spifc_reg_t*)spifc_get_reg_base();
    
    spi->SFC_START |= FC_START;
}

/*******************************************************************************
 * Function:    spifc_get_feature
 * Description: 
 * Parameters:
 *	 Input:
 *
 *	 Output:
 *
 * Returns:
 *
 *
 * Others:   [Instruction]                 |--addr width is 8 bit
             [addr]                        |--get feature
             [data_rx]                     |--read id
            
 ********************************************************************************/
 static int spifc_get_feature( uint32_t reg_addr, uint8_t *value)
 {   
    int ret = SUCCESS;
    uint32_t retries = SPI_NAND_RETRIE;
    
    struct spiflash_cmd_t cmd = {   CMD_GET_FEATURE,        /* ָ */
                                    1,                      /* ַ뷢ʹ */
                                    FC_ADDR_BYTE_NUM_8,     /* ַ볤 */
                                    0,                      /* ʹ---д */
                                    1,                      /* ʹ--- */
                                    0,                      /* еȴʹ */
                                    0,                      /* еȴ x8 */
                                    0                       /* еȴ x1 */
                                };
    do
    {
        if(g_nor_flag == 1)
		{
		    zDrvGpio_SetOutputValue(GPIO86,GPIO_LOW);
		}
        spi_fc_clear_fifo();
        spi_fc_clear_int();
        spi_fc_config_ctrl(FC_DMA_NONE);        
        spi_fc_setup_cmd(&cmd, reg_addr, 1);        /*  */      
        spi_fc_start();                             /* ʼ */
        ret = spi_fc_wait_cmd_end();                /* ȴ */
        if( ret != SUCCESS )
        {
            continue;   /* ʧܣѭش */
        }

        ret = spi_fc_read_fifo_one_byte(value);          /* ȡ */
        if( ret != SUCCESS ) 
        {
            continue;   /* ʧܣѭش */
        }
		
		if(g_nor_flag == 1)
		{
		    zDrvGpio_SetOutputValue(GPIO86,GPIO_HIGH);
		}
      
        break;        
    } while( --retries != 0 );
     
    return ret;
}

 
/*******************************************************************************
 * Function:    spifc_set_feature
 * Description: 
 * Parameters:
 *	 Input:
 *
 *	 Output:
 *
 * Returns:
 *
 *
 * Others:   [Instruction]                 |--addr width is 8 bit
             [addr]                        |--set feature
             [data_tx]              
            
 ********************************************************************************/
 static int spifc_set_feature( uint32_t reg_addr, uint8_t *value)
{   
    int ret = SUCCESS;
    uint32_t retries = SPI_NAND_RETRIE;
    
    struct spiflash_cmd_t cmd = {   CMD_SET_FEATURE,        /* ָ */
                                    1,                      /* ַ뷢ʹ */
                                    FC_ADDR_BYTE_NUM_8,     /* ַ볤 */
                                    1,                      /* ʹ---д */
                                    0,                      /* ʹ--- */
                                    0,                      /* еȴʹ */
                                    0,                      /* еȴ x8 */
                                    0                       /* еȴ x1 */
                                };
    do
    {
		if(g_nor_flag == 1)
		{
			zDrvGpio_SetOutputValue(GPIO86,GPIO_LOW);
		}
        spi_fc_clear_fifo();
        spi_fc_clear_int();
        spi_fc_config_ctrl(FC_DMA_NONE);        
        spi_fc_setup_cmd(&cmd, reg_addr, 1);        /*  */    
        spi_fc_write_fifo_one_byte(1, value);
        spi_fc_start();                             /* ʼ */
        ret = spi_fc_wait_cmd_end();                /* ȴ */
        if( ret != SUCCESS )
        {
            continue;   /* ʧܣѭش */
        }
		
		if(g_nor_flag == 1)
		{
			zDrvGpio_SetOutputValue(GPIO86,GPIO_HIGH);
		}

        break;        
    } while( --retries != 0 );
     
    return ret;
}

/*******************************************************************************
 * Function:    spifc_reset
 * Description: 
 * Parameters:
 *	 Input:
 *
 *	 Output:
 *
 * Returns:
 *
 *
 * Others:
 ********************************************************************************/
static int spifc_reset( void )
{   
    int ret = SUCCESS;
    uint32_t retries = SPI_NAND_RETRIE;
    uint8_t status = 0;
    struct spiflash_cmd_t cmd = {   CMD_RESET,              /* ָ */
                                    0,                      /* ַ뷢ʹ */
                                    0,                      /* ַ볤 */
                                    0,                      /* ʹ---д */
                                    0,                      /* ʹ--- */
                                    0,                      /* еȴʹ */
                                    0,                      /* еȴ x8 */
                                    0                       /* еȴ x1 */
                                };
    do
    {
		if(g_nor_flag == 1)
		{
			zDrvGpio_SetOutputValue(GPIO86,GPIO_LOW);
		}
        spi_fc_setup_cmd(&cmd, 0, 0);       /*  */
        spi_fc_start();                     /* ʼ */
        ret = spi_fc_wait_cmd_end();        /* ȴ */
        if( ret != SUCCESS )    
            continue;   /* ʧܣѭش */
		
		if(g_nor_flag == 1)
		{
		    zDrvGpio_SetOutputValue(GPIO86,GPIO_HIGH);
			udelay(5);
		}		

		/* ȴRESETִ */ //sunzhaoxing must wait
		do
		{
			spifc_get_feature(REG_STATUS, &status); 
		}
		while ( status & OIP); 

        break;
    } while( --retries != 0 );
     
    return ret;
}

static int spifc_switch_die(unsigned char die)
{
	int ret = SUCCESS;
	uint8_t value = die;
    uint8_t status = 0;
	uint32_t retries = SPI_NAND_RETRIE;
		
	struct spiflash_cmd_t cmd = {	CMD_WINBOND_DIE_SWITCH, /* ????? */
									0,						/* ?????1? */
									0,						 /* ????3? */
									1,						/* ?y?Y1?---D */
									0,						/* ??y?Y1?---? */
									0,						/* ???D̨y??1? */
									0,						/* ???D̨y?? x8 */
									0						/* ???D̨y?? x1 */
								};

	
    do
    {
		if(g_nor_flag == 1)
		{
			zDrvGpio_SetOutputValue(GPIO86,GPIO_LOW);
		}
        spi_fc_clear_fifo();
        spi_fc_clear_int();
        spi_fc_config_ctrl(FC_DMA_NONE);       
		spi_fc_setup_cmd(&cmd, 0, 1);		/* ?????? */	  
        spi_fc_write_fifo_one_byte(1, &value);
        spi_fc_start();                             /* ?a??? */
        ret = spi_fc_wait_cmd_end();                /* ̨y???? */
        if( ret != SUCCESS )
        {
            continue;   /* ??㨹??????-?2??? */
        }
		
		if(g_nor_flag == 1)
		{
			zDrvGpio_SetOutputValue(GPIO86,GPIO_HIGH);
		}

        break;        
    } while( --retries != 0 );

    return ret;
}

/*******************************************************************************
 * Function:    spifc_write_enable
 * Description: 
 * Parameters:
 *	 Input:
 *
 *	 Output:
 *
 * Returns:
 *
 *
 * Others:
 ********************************************************************************/
static int spifc_write_enable( void )
{      
    int ret = SUCCESS;
    uint32_t retries = SPI_NAND_RETRIE;
	uint8_t status = 0;
    struct spiflash_cmd_t cmd = {   CMD_WRITE_ENABLE,       /* ָ */
                                    0,                      /* ַ뷢ʹ */
                                    0,                      /* ַ볤 */
                                    0,                      /* ʹ---д */
                                    0,                      /* ʹ--- */
                                    0,                      /* еȴʹ */
                                    0,                      /* еȴ x8 */
                                    0                       /* еȴ x1 */
                                };
	while(1)
	{
		if(g_nor_flag == 1)
		{
			zDrvGpio_SetOutputValue(GPIO86,GPIO_LOW);
		}

		do
		{
			spi_fc_clear_fifo();
			spi_fc_clear_int();
			spi_fc_config_ctrl(FC_DMA_NONE);
			spi_fc_setup_cmd(&cmd, 0x0, 0); 		 /*  */
			spi_fc_start(); 						 /* ʼ */
			ret = spi_fc_wait_cmd_end(); 			/* ȴ */
			if ( ret != SUCCESS )
			{
				continue;	/* ʧܣѭش */
			}
	
			break;
		}
		while ( --retries != 0 );

		if(g_nor_flag == 1)
		{
			zDrvGpio_SetOutputValue(GPIO86,GPIO_HIGH);
            udelay(5);
		}
		
		/* ȴϴִ */
		do
		{
			spifc_get_feature(REG_STATUS, &status); 
		}
		while ( status & OIP); 
	
		if(status&WEL)//sunzhaoxing
			break;
	
		retries = SPI_NAND_RETRIE;
			
	}
     
    return ret;
}


/*******************************************************************************
 * Function:    spifc_write_disable
 * Description: 
 * Parameters:
 *	 Input:
 *
 *	 Output:
 *
 * Returns:
 *
 *
 * Others:
 ********************************************************************************/
static int spifc_write_disable( void )
{  
    int ret = SUCCESS;
    uint32_t retries = SPI_NAND_RETRIE;
    struct spiflash_cmd_t cmd = {   CMD_WRITE_DISABLE,      /* ָ */
                                    0,                      /* ַ뷢ʹ */
                                    0,                      /* ַ볤 */
                                    0,                      /* ʹ---д */
                                    0,                      /* ʹ--- */
                                    0,                      /* еȴʹ */
                                    0,                      /* еȴ x8 */
                                    0                       /* еȴ x1 */
                                };
    do
    {
		if(g_nor_flag == 1)
		{
			zDrvGpio_SetOutputValue(GPIO86,GPIO_LOW);
		}
        spi_fc_clear_fifo();
        spi_fc_clear_int();
        spi_fc_config_ctrl(FC_DMA_NONE);        
        spi_fc_setup_cmd(&cmd, 0x0, 0);          /*  */      
        spi_fc_start();                          /* ʼ */
        ret = spi_fc_wait_cmd_end();             /* ȴ */
        if( ret != SUCCESS )
        {
            continue;   /* ʧܣѭش */
        }
		
		if(g_nor_flag == 1)
		{
			zDrvGpio_SetOutputValue(GPIO86,GPIO_HIGH);
		}  

       break;        
    } while( --retries != 0 );
     
    return ret;
}

/*******************************************************************************
 * Function:    spi_fc_setup_tansmod
 * Description:
 * Parameters:
 *   Input:
 *
 *   Output:
 *
 * Returns:
 *
 *
 * Others:
 ********************************************************************************/
static void spi_fc_setup_tansmod(uint32_t mod)
{
    uint32_t tmpReg;
    volatile struct spifc_reg_t* spi  = (struct spifc_reg_t*)spifc_get_reg_base();

    tmpReg = spi->SFC_CTRL2;
    tmpReg &= 0xffffffe0;

    switch (mod)
    {
        case RDQIO_MODE:
            tmpReg |= FC_ADDR_MULTI_LINE_EN |
                      FC_DAT_MULTI_LINE_EN |
                      FC_TRANS_MOD;
            break;

        case PLX4_MODE:
        case RDX4_MODE:
            tmpReg |= FC_DAT_MULTI_LINE_EN | FC_TRANS_MOD;
            break;

        /* case DUAL_MODE:
             tmpReg |=FC_DAT_MULTI_LINE_EN;
          break; */

        default:   /*signle mode*/
            break;
    }

    spi->SFC_CTRL2 = tmpReg;

}

/*******************************************************************************
 * Function:    spifc_read_id
 * Description: 
 * Parameters:
 *	 Input:
 *
 *	 Output:
 *
 * Returns:
 *
 *
 * Others:  [Instruction]                 |--addr width is 8 bit
            [addr]                        |--get feature
            [data_rx]                     |--read id
 ********************************************************************************/

static int spifc_read_id(uint32_t reg_addr, uint8_t *value, uint8_t len)
{   
    int ret = 0;
    uint32_t retries = SPI_NAND_RETRIE;
    
    struct spiflash_cmd_t cmd = {   CMD_READ_ID,            /* ָ */
                                    1,                      /* ַ뷢ʹ */
                                    FC_ADDR_BYTE_NUM_8,     /* ַ볤 */
                                    0,                      /* ʹ---д */
                                    1,                      /* ʹ--- */
                                    0,                      /* еȴʹ */
                                    0,                      /* еȴ x8 */
                                    0                       /* еȴ x1 */
                                };

    do
    {
		if(g_nor_flag == 1)
		{
			zDrvGpio_SetOutputValue(GPIO86,GPIO_LOW);
		}
        spi_fc_clear_fifo();
        spi_fc_clear_int();
        spi_fc_config_ctrl(FC_DMA_NONE);        
        spi_fc_setup_cmd(&cmd, reg_addr, len);        /*  */      
        spi_fc_start();                             /* ʼ */
        ret = spi_fc_wait_cmd_end();                /* ȴ */
        if( ret != SUCCESS )
        {
            //spi_fc_disable();
            continue;   /* ʧܣѭش */
        }

        ret = spi_fc_read_fifo(len,value);     /* ȡ */
        if( ret != SUCCESS ) 
        {
            //spi_fc_disable();
            continue;   /* ʧܣѭش */
        }
		
		if(g_nor_flag == 1)
		{
			zDrvGpio_SetOutputValue(GPIO86,GPIO_HIGH);
		}

        break;        
    } while( --retries != 0 );
    
    return 0;
}


/*******************************************************************************
 * Function:    spifc_erase
 * Description: 
 * Parameters:
 *	 Input:
 *
 *	 Output:
 *
 * Returns:
 *
 *
 * Others:  [Instruction]       |--addr width is 24 bit(page/block addr!!!!)
            [addr]            
                                |--block erase
                              
 ********************************************************************************/
static int spifc_erase(uint32_t page_addr)
{   
    //volatile struct spifc_reg_t* spi	= (struct spifc_reg_t*)spifc_get_reg_base();
    
    int ret = SUCCESS;
    uint32_t retries = SPI_NAND_RETRIE;
    uint8_t status = 0;
    
    struct spiflash_cmd_t cmd = {   CMD_BLOCK_ERASE,        /* ָ */
                                    1,                      /* ַ뷢ʹ */
                                    FC_ADDR_BYTE_NUM_24,    /* ַ볤 */
                                    0,                      /* ʹ---д */
                                    0,                      /* ʹ--- */
                                    0,                      /* еȴʹ */
                                    0,                      /* еȴ x8 */
                                    0                       /* еȴ x1 */
                                };
    do
    {
		if(g_nor_flag == 1)
		{
			zDrvGpio_SetOutputValue(GPIO86,GPIO_LOW);
		}

        spi_fc_clear_fifo();
        spi_fc_clear_int();
        spi_fc_config_ctrl(FC_DMA_NONE);        
        spi_fc_setup_cmd(&cmd, page_addr, 0);   /*  */      
        spi_fc_start();                          /* ʼ */
        ret = spi_fc_wait_cmd_end();             /* ȴ */
        if( ret != SUCCESS )
        {
            continue;   /* ʧܣѭش */
        }

		if(g_nor_flag == 1)
		{
			zDrvGpio_SetOutputValue(GPIO86,GPIO_HIGH);
       		udelay(5);
		}

        /* ȴִ */
        do
        {
            ret = spifc_get_feature(REG_STATUS, &status);
        }while( status & OIP);
            if( status & E_FAIL )
            {   
                printf("[SPI-NAND][ERASE][status] = 0x%0x\n", status);
                return NAND_STATUS_FAIL;
            }            
       
        break;        
    }
     while( --retries != 0 );
     
    return ret;
}

/*******************************************************************************
 * Function:    spifc_read_page_to_cache
 * Description: 
 * Parameters:
 *	 Input:
 *
 *	 Output:
 *
 * Returns:
 *
 *
 * Others:  [Instruction]       |--addr width is 24 bit(page/block addr!!!!)
            [addr]              |--page read
                                |--block erase
                                |--program execute
 ********************************************************************************/
static int spifc_read_page_to_cache(uint32_t page_addr)
{   
    //volatile struct spifc_reg_t* spi	= (struct spifc_reg_t*)spifc_get_reg_base();
    
    int ret = SUCCESS;
    uint32_t retries = SPI_NAND_RETRIE;
    uint8_t status = 0;
    
    struct spiflash_cmd_t cmd = {   CMD_READ_PAGE_TO_CACHE, /* ָ */
                                    1,                      /* ַ뷢ʹ */
                                    FC_ADDR_BYTE_NUM_24,    /* ַ볤 */
                                    0,                      /* ʹ---д */
                                    0,                      /* ʹ--- */
                                    0,                      /* еȴʹ */
                                    0,                      /* еȴ x8 */
                                    0                       /* еȴ x1 */
                                };
    do
    {
		if(g_nor_flag == 1)
		{
			zDrvGpio_SetOutputValue(GPIO86,GPIO_LOW);
		}
        spi_fc_clear_fifo();
        spi_fc_clear_int();
        spi_fc_config_ctrl(FC_DMA_NONE);        
        spi_fc_setup_cmd(&cmd, page_addr, 0);   /*  */      
        spi_fc_start();                          /* ʼ */
        ret = spi_fc_wait_cmd_end();             /* ȴ */
        if( ret != SUCCESS )
        {
            continue;   /* ʧܣѭش */
        }
		
		if(g_nor_flag == 1)
		{
			zDrvGpio_SetOutputValue(GPIO86,GPIO_HIGH);
		    udelay(5);
		}
        /* ȴִ */
        do
        {
            spifc_get_feature(REG_STATUS, &status);
        }while( status & OIP);

        break;        
    }
     while( --retries != 0 );
     
    return ret;
}

#if TRANS_USE_DMA
/*
 * config dma 
 *
 * dir  -- FC_DMA_RX/FC_DMA_TX
 */ 
static void spifc_config_dma(uint8_t *buf, uint32_t len, int dir)
{
	dma_channel_def chan_para;
	dma_peripheral_id channel_id = 0;
    volatile struct spifc_reg_t* spi = (struct spifc_reg_t*)spifc_get_reg_base();

	if(dir == FC_DMA_RX)
	{	
		chan_para.src_addr = &(spi->SFC_DATA);
		chan_para.dest_addr = (unsigned int)buf;
		channel_id	= DMA_CH_SPIFC_RX;	
		chan_para.dma_control.tran_mode = TRAN_PERI_TO_MEM;
		
	}
	else if(dir == FC_DMA_TX)
	{	
		chan_para.src_addr = (unsigned int)buf;
		chan_para.dest_addr = &(spi->SFC_DATA);
		channel_id	= DMA_CH_SPIFC_TX;	
		chan_para.dma_control.tran_mode = TRAN_MEM_TO_PERI;
	}
	else
		BUG();
		
	chan_para.count = len;
	chan_para.dma_control.irq_mode  		= DMA_ALL_IRQ_DISABLE;
	chan_para.dma_control.src_burst_size	= DMA_BURST_SIZE_32BIT;
	chan_para.dma_control.src_burst_len		= DMA_BURST_LEN_8;
	chan_para.dma_control.dest_burst_size 	= DMA_BURST_SIZE_32BIT;
	chan_para.dma_control.dest_burst_len	= DMA_BURST_LEN_8;
	
	dma_config(channel_id, &chan_para);	
	
	dma_start(channel_id, NULL, NULL);
}

static int spifc_wait_dma_done(int dir)
{
	dma_peripheral_id channel_id = 0;

	if(dir == FC_DMA_RX)
		channel_id = DMA_CH_SPIFC_RX;
	else if(dir == FC_DMA_TX)
		channel_id = DMA_CH_SPIFC_TX;
	else
		BUG();

	while(1)
    {
        if(dma_get_status(channel_id) == DMA_TRANSFER_DONE)
            break;
    }

	dma_disable_channel(channel_id);
	
	return 0;
}
#endif
/*******************************************************************************
 * Function:    spifc_read_from_cache
 * Description: 
 * Parameters:
 *	 Input:
 *
 *	 Output:
 *
 * Returns:
 *
 *
 * Others:  [Instruction]                 |--addr width is 16 bit
            [addr]                        |--dummy cycel 8/4/2
            [dummy]                       |--read form cache(X1,X2,X4)
            [data_rx]                     |--read form cache(dual,quad)IO
 ********************************************************************************/
static int spifc_read_from_cache(uint32_t column_addr, uint32_t len, uint8_t *buf)
{   
    int ret = SUCCESS;
    uint32_t retries = SPI_NAND_RETRIE;
    uint32_t len_tmp = 0;
    uint32_t trans_mode = spi_nand_get_trans_mode(READ_TRANSFER_MODE);
    struct spiflash_cmd_t cmd;

    spi_fc_setup_tansmod(trans_mode);

    switch (trans_mode)
    {
        case RDQIO_MODE:
            cmd.cmd = CMD_READ_FROM_CACHE_QIO;       /* ָ */
            cmd.dumy_bytes = 0;                      /* еȴ x8 */
            if(g_maf_id == 0xEF)
			{
				cmd.dumy_bits = 4;                      /* еȴ x1 */
			}
			else
			{
				cmd.dumy_bits = 2;						 /* еȴ x1 */
			}
            break;
        case RDX4_MODE: 
            cmd.cmd = CMD_READ_FROM_CACHE_X4;        /* ָ */
            cmd.dumy_bytes = 1;                      /* еȴ x8 */
            cmd.dumy_bits = 0;                       /* еȴ x1 */
            break;
        default:
            cmd.cmd = CMD_READ_FROM_CACHE;           /* ָ */
            cmd.dumy_bytes = 1;                      /* еȴ x8 */
            cmd.dumy_bits = 0;                       /* еȴ x1 */
            break;
    }
	
    cmd.addr_tx_en = 1;                      /* ַ뷢ʹ */
    cmd.addr_width = FC_ADDR_BYTE_NUM_16;    /* ַ볤 */
    cmd.data_tx_en = 0;                      /* ʹ---д */
    cmd.data_rx_en = 1;                      /* ʹ--- */
    cmd.dumy_tx_en = 1;                      /* еȴʹ */

    do
    {
		if(g_nor_flag == 1)
		{
			zDrvGpio_SetOutputValue(GPIO86,GPIO_LOW);
		}
        spi_fc_clear_fifo();
        spi_fc_clear_int();
        spi_fc_setup_cmd(&cmd, column_addr, len);       /*  */      

#if TRANS_USE_DMA
		spifc_config_dma(buf, len, FC_DMA_RX);		
		spi_fc_config_ctrl(FC_DMA_RX);
		spi_fc_start(); 								/* ʼ */		
#else
		spi_fc_config_ctrl(FC_DMA_NONE);        
		spi_fc_start(); 								/* ʼ */		

		len_tmp = spi_fc_read_fifo(len, buf);			/* ȡ */
		if( len_tmp != len ) 
		{
			ret = -2;
			continue;	/* ʧܣѭش */
		}
#endif

        ret = spi_fc_wait_cmd_end();                    /* ȴ */
        if( ret != SUCCESS )
        {
            continue;   /* ʧܣѭش */
        }

#if TRANS_USE_DMA
		spifc_wait_dma_done(FC_DMA_RX);
		spi_fc_config_ctrl(FC_DMA_NONE); 
#endif

        if(g_nor_flag == 1)
		{
			zDrvGpio_SetOutputValue(GPIO86,GPIO_HIGH);
		}


        break;        
    } while( --retries != 0 );

    spi_fc_setup_tansmod(SINGLE_MODE);
	
    return ret;
}

/*******************************************************************************
 * Function:    spifc_page_load
 * Description: 
 * Parameters:
 *	 Input:
 *
 *	 Output:
 *
 * Returns:
 *
 *
 * Others:  [Instruction]                 
            [addr]                        
            [data_tx]                     |--addr width is 16 bit
                                          |--program load(X1,X4)
 ********************************************************************************/
static int spifc_page_load(uint32_t column_addr, uint8_t* buf, uint32_t page_len, 
						uint8_t *oob, uint32_t oob_len)
{   
    int ret = SUCCESS;
    uint32_t retries = SPI_NAND_RETRIE;
    uint32_t trans_mode = spi_nand_get_trans_mode(WRITE_TRANSFER_MODE);
    struct spiflash_cmd_t cmd;

    switch (trans_mode)
    {
        case PLX4_MODE:
             cmd.cmd = CMD_PROGRAM_LOAD_X4;  /* ָ */
           break;
        default:
             cmd.cmd = CMD_PROGRAM_LOAD;
            break;
    }
	
    cmd.addr_tx_en = 1;                      /* ַ뷢ʹ */
    cmd.addr_width = FC_ADDR_BYTE_NUM_16;    /* ַ볤 */
    cmd.data_tx_en = 1;                      /* ʹ---д */
    cmd.data_rx_en = 0;                      /* ʹ--- */
    cmd.dumy_tx_en = 0;                      /* еȴʹ */
    cmd.dumy_bytes = 0;                      /* еȴ x8 */
    cmd.dumy_bits = 0;                       /* еȴ x1 */
                              
    do
    {
		if(g_nor_flag == 1)
		{
			zDrvGpio_SetOutputValue(GPIO86,GPIO_LOW);
		}
		spi_fc_clear_fifo();
        spi_fc_clear_int();
        spi_fc_setup_cmd(&cmd, column_addr, page_len+oob_len);       /*  */ 
#if TRANS_USE_DMA
		if(oob)
			spifc_config_dma(buf, page_len+oob_len, FC_DMA_TX);
		else
			spifc_config_dma(buf, page_len, FC_DMA_TX);
		spi_fc_config_ctrl(FC_DMA_TX);
		spi_fc_setup_tansmod(trans_mode);		
		spi_fc_start(); 								/* ʼ */		
#else
		spi_fc_config_ctrl(FC_DMA_NONE);      
		spi_fc_setup_tansmod(trans_mode);
        spi_fc_start();                                 /* ʼ */
        spi_fc_write_fifo(buf, page_len, oob, oob_len);               /*֤*/
#endif		
        ret = spi_fc_wait_cmd_end();                    /* ȴ */
        if( ret != SUCCESS )
        {
            continue;   /* ʧܣѭش */
        }
#if TRANS_USE_DMA
		spifc_wait_dma_done(FC_DMA_TX);
		spi_fc_config_ctrl(FC_DMA_NONE); 
#endif

        if(g_nor_flag == 1)
		{
			zDrvGpio_SetOutputValue(GPIO86,GPIO_HIGH);
		}


        break;        
    } while( --retries != 0 );
     
    spi_fc_setup_tansmod(SINGLE_MODE);
    return ret;
}


/*******************************************************************************
 * Function:    spifc_program_exec
 * Description: 
 * Parameters:
 *	 Input:
 *
 *	 Output:
 *
 * Returns:
 *
 *
 * Others:  [Instruction]       |--addr width is 24 bit(page/block addr!!!!)
            [addr]              |--program execute
                                                               
 ********************************************************************************/
static int spifc_program_exec(uint32_t page_addr)
{    
    int ret = SUCCESS;
    uint32_t retries = SPI_NAND_RETRIE;
    uint8_t status = 0;
    
    struct spiflash_cmd_t cmd = {   CMD_PROGRAM_EXECUTE,    /* ָ */
                                    1,                      /* ַ뷢ʹ */
                                    FC_ADDR_BYTE_NUM_24,    /* ַ볤 */
                                    0,                      /* ʹ---д */
                                    0,                      /* ʹ--- */
                                    0,                      /* еȴʹ */
                                    0,                      /* еȴ x8 */
                                    0                       /* еȴ x1 */
                                };
    do
    {
		if(g_nor_flag == 1)
		{
			zDrvGpio_SetOutputValue(GPIO86,GPIO_LOW);
		}
        spi_fc_clear_fifo();
        spi_fc_clear_int();
        spi_fc_config_ctrl(FC_DMA_NONE);        
        spi_fc_setup_cmd(&cmd, page_addr, 0);       /*  */      
        spi_fc_start();                             /* ʼ */
        ret = spi_fc_wait_cmd_end();                /* ȴ */
        if( ret != SUCCESS )
        {
            continue;   /* ʧܣѭش */
        }

		if(g_nor_flag == 1)
		{
			zDrvGpio_SetOutputValue(GPIO86,GPIO_HIGH);
            udelay(5);
		}

        /* ȴִ */
        do
        {
            spifc_get_feature(REG_STATUS, &status);
        }while( status & OIP);
		
        if( status & P_FAIL )
        {
            return NAND_STATUS_FAIL;
        }   
         break;  
    }
     while( --retries != 0 );
     
    return ret;
}

/*******************************************************************************
 * Function:    spifc_hw_init
 * Description: 
 * Parameters:
 *	 Input:
 *
 *	 Output:
 *
 * Returns:
 *
 *
 * Others:
 ********************************************************************************/
int winbond_dev_id2 = 0;

static void spifc_hw_init(struct spi_nand_info *spi_nand)
{
	uint8_t id[4];
    struct nand_flash_device_para * table = nand_flash_para;
    struct nand_flash_timing *time = NULL;

    zDrvGpio_SetFunc(GPIO98, GPIO98_SPIFC_DATA3);
	zDrvGpio_SetFunc(GPIO97, GPIO97_SPIFC_DATA2);
	zDrvGpio_SetFunc(GPIO96, GPIO96_SPIFC_DATA1);
	zDrvGpio_SetFunc(GPIO95, GPIO95_SPIFC_DATA0);
	zDrvGpio_SetFunc(GPIO93,GPIO93_SPIFC_CS);
    if(g_nor_flag == 1)
	{
        zDrvGpio_SetFunc(GPIO93,GPIO93_GPIO93);
	  	zDrvGpio_SetOutputValue(GPIO93, GPIO_HIGH);
	  	zDrvGpio_SetFunc(GPIO86,GPIO86_GPIO86);
	  	zDrvGpio_SetDirection(GPIO86, GPIO_OUT);
	}
	zDrvGpio_SetFunc(GPIO94,GPIO94_SPIFC_CLK);

	spi_fc_enable();

    spifc_read_id(0x0,id, 3);
	spi_fc_disable();
	winbond_dev_id2 = id[2];
    printf("\n[SPI-NAND]: maf_id = 0x%0x\n", id[0]);
    printf("[SPI-NAND]: dev_id = 0x%0x\n", id[1]);
	printf("[SPI-NAND]: dev_id = 0x%0x\n", id[2]);
    
    for (; table->manuf_id != 0; table++)
    {
        if( table->manuf_id == 0 )
        {
            printf("Can not find the nand chip id...\n");
            BUG();
        }
        if ((id[0] == table->manuf_id) && (id[1] == table->device_id)&&(table->res_id == 0) )
        {
            break;
        }		
    }

	spi_nand->para = table;

    g_nand_dev_info = table;	/* maybe remove later */
    
    time = &(table->nand_timeing);
    spifc_set_clk();
    spi_fc_enable();
    spifc_set_timing(time->Twhr, time->Trr1, time->Tadl, time->Trr2 );
}

static struct spi_nand_ctrl_info spifc_ops = 
{
	.reset		 		= spifc_reset,
	.switch_die			= spifc_switch_die,
	.read_id	 		= spifc_read_id,
	.get_feature 		= spifc_get_feature,
	.set_feature 		= spifc_set_feature,
	.read_page_to_cache	= spifc_read_page_to_cache,
	.read_from_cache	= spifc_read_from_cache,
	.page_load 			= spifc_page_load,
	.program_exec		= spifc_program_exec,
	.write_enable		= spifc_write_enable,
	.write_disable		= spifc_write_disable,
	.erase 				= spifc_erase,
};

int board_nand_init_spifc(struct nand_chip *nand)
{
	int ret = -1; 
	struct spi_nand_info *spifc = g_spifc;
    
    spifc->mtd = (struct mtd_info *)&nand_info;
    spifc->nand = (struct nand_chip *)&nand_chip;
    spifc->buf.dma_buf = (dma_addr_t)CONFIG_NAND_DMA_BUF_ADDR;
    spifc->buf.buf = (uint8_t *)spifc->buf.dma_buf;

	spifc_hw_init(spifc);
	ret = spi_nand_register(spifc, &spifc_ops);
	if(ret)
	{
       	debug("board_nand_init_spifc:(err=%d)", ret);
		return ret;	
	}

	spi_nand_debug_init();

	return 0;
}

