#ifndef _MPU_H
#define _MPU_H

typedef volatile struct 
{
    int32_t dwNum;
    int32_t dwBase;
    int32_t dwSize;
    int32_t dwMemAttr;
    int32_t dwShare;
    int32_t dwAP;
    int32_t dwXN;
    int32_t dwSubRegion;
}T_Region_Attr;

#define  MPU_REGION_SO                         (0)// strongly-ordered memory
#define  MPU_REGION_SD                         (1)// 豸memory
#define  MPU_REGION_NM_INC_ONC                 (4)// nomal memory,cache
#define  MPU_REGION_NM_IWBWA_OWBWA             (7)// nomal memory, дд
#define  MPU_REGION_NSD                        (8)// ǹ豸memory
#define  MPU_REGION_NM_IWBWA_ONC               (17)// nomal memory,cacheL2 cacheԵL1 cache дд
#define  MPU_REGION_NM_INC_OWBWA               (20)// nomal memory,cacheL1 cacheԵL2 cache дд
//#define  MPU_REGION_NM_IWBWA_OWBWA             (21)// nomal memory,ԵL1 cache дд䣬ԵL2 cache дд


/* mpuؼĴλ궨 */
/* MPU ַĴ
*  λãcp15 0 c6 c1 0
*  ˵ַ
*  ʹ˵1)ֻȨģʽ·        2)С 
*  Example MRC p15,0,<Rt>,c6,c1,0 ; Read 
*  +---------------------------+-----------+
*  |            31- 5          |   4 - 0   |
*  +---------------------------+-----------+
*  |        Base Address       |  Reserved |
*  +---------------------------+-----------+
*/ 

/* mpuؼĴλ궨 */
/* MPU СʹܼĴ
*  λãcp15 0 c6 c1 2
*  ˵Сʹ
*  ʹ˵1)ֻȨģʽ· 
*  Example MRC p15,0,<Rt>,c6,c1,2 ; Read
*  +---------------------------+-----------+
*  | 31-16|     15-8     | 7-6 | 5-1  |  0 |
*  +---------------------------+-----------+
*  |  Re  | SubRegion Dis|  Re | Size | En |
*  +---------------------------+-----------+
*/
#define MPU_EN_POS                      (0)
#define MPU_EN_MASK                     (0x1 << MPU_EN_POS)

#define MPU_SIZE_POS                    (1)
#define MPU_SIZE_MASK                   (0x1f << MPU_SIZE_POS)

#define MPU_SUBREGION_DIS_POS           (8)
#define MPU_SUBREGION_DIS_MASK          (0xff << MPU_SUBREGION_DIS_POS)

#define MPU_REGIONG_EN
#define MPU_REGIONG_DIS

#define REGION_SIZE_256B    0x07
#define REGION_SIZE_512B    0x08
#define REGION_SIZE_1K      0x09
#define REGION_SIZE_2K      0x0a
#define REGION_SIZE_4K      0x0b
#define REGION_SIZE_8K      0x0c
#define REGION_SIZE_16K     0x0d
#define REGION_SIZE_32K     0x0e
#define REGION_SIZE_64K     0x0f
#define REGION_SIZE_128K    0x10
#define REGION_SIZE_256K    0x11
#define REGION_SIZE_512K    0x12
#define REGION_SIZE_1M      0x13
#define REGION_SIZE_2M      0x14
#define REGION_SIZE_4M      0x15
#define REGION_SIZE_8M      0x16
#define REGION_SIZE_16M     0x17
#define REGION_SIZE_32M     0x18
#define REGION_SIZE_64M     0x19
#define REGION_SIZE_128M    0x1a
#define REGION_SIZE_256M    0x1b
#define REGION_SIZE_512M    0x1c
#define REGION_SIZE_1G      0x1d
#define REGION_SIZE_2G      0x1e
#define REGION_SIZE_4G      0x1f

/* mpuؼĴλ궨 */
/* MPU ԿƼĴ
*  λãcp15 0 c6 c1 4
*  ˵
*  ʹ˵1)ֻȨģʽ· 
*  Example MRC p15,0,<Rt>,c6,c1,4 ; Read
*  +------------------------------+-----------------+
*  | 31-13 | 12 | 11 | 10-8 | 7-6 | 5-3 | 2 | 1 | 0 |
*  +------------------------------+-----------------+
*  |  Re   | XN | Re |  AP  |  Re | TEX | S | C | B |
*  +------------------------------+-----------------+
*/
#define MPU_REGION_B_POS                (0)
#define MPU_REGION_B_MASK               (0x1 << MPU_REGION_B_POS)

#define MPU_REGION_C_POS                (1)
#define MPU_REGION_C_MASK               (0x1 << MPU_REGION_C_POS)

#define MPU_REGION_S_POS                (2)
#define MPU_REGION_S_MASK               (0x1 << MPU_REGION_S_POS)

#define MPU_REGION_TEX_POS              (3)
#define MPU_REGION_TEX_MASK             (0x7 << MPU_REGION_TEX_POS)

#define MPU_REGION_AP_POS               (8)
#define MPU_REGION_AP_MASK              (0x7 << MPU_REGION_AP_POS)

#define MPU_REGION_XN_POS               (12)
#define MPU_REGION_XN_MASK              (0x1 << MPU_REGION_XN_POS)

/* mpuؼĴλ궨 */
/* MPU ѡĴ
*  λãcp15 0 c6 c2 0
*  ˵ַ
*  ʹ˵1)ֻȨģʽ·        2)С 
*  Example MRC p15,0,<Rt>,c6,c2,0 ; Read 
*  +---------------------------+-----------+
*  |            31- 4          |   3 - 0   |
*  +---------------------------+-----------+
*  |             Re            |  Region   |
*  +---------------------------+-----------+
*/ 


#define MPU_REGION_NUM_POS              (0)
#define MPU_REGION_NUM_MASK             (0xf << MPU_REGION_NUM_POS)




int32_t MPU_RegionInit(T_Region_Attr* ptRegion);
void MPU_Init(void);
int32_t MPU_Size2Sec(int32_t dwSize);
void MPU_RegionDisable(int32_t dwNum, int32_t dwEnable);


#endif

