/*
 * zx234290-core.c  --  Device access for ZX234290 PMICs
 *
 * Copyright 2016 ZTE Inc.
 *
 * Author: yuxiang<yu.xiang5@zte.com.cn>
 *
 *  This program is free software; you can redistribute  it and/or modify it
 *  under  the terms of  the GNU General  Public License as published by the
 *  Free Software Foundation;  either version 2 of the  License, or (at your
 *  option) any later version.
 *
 */

#include <linux/module.h>
#include <linux/moduleparam.h>
#include <linux/init.h>
#include <linux/slab.h>
#include <linux/gpio.h>
#include <linux/mfd/core.h>
#include <linux/mfd/zx234290.h>

#include <linux/debugfs.h>
#include <asm/uaccess.h>

#include <mach/gpio-names.h>
#include <linux/gpio_keys.h>

#include <mach/iomap.h>
#include <linux/delay.h>

#include <mach/peri_cfg.h>

/*the power on info, boot_reason */
typedef enum
{
	POWER_ON_NORMAL = 0,
	POWER_ON_FOTA,
	POWER_ON_CHARGING,
	POWER_ON_RTC,
	POWER_ON_RESET,
	POWER_ON_HDT_TEST,
	POWER_ON_EXCEPTRESET,
	POWER_ON_LOCALUPDATE,
	POWER_ON_BOOST_IN,
	POWER_ON_AMT,
	POWER_ON_PRODUCTION,
	POWER_ON_INVALID,
}T_ZDrvSys_PowerOn_Type;

#ifdef CONFIG_KEYBOARD_ZX234290_UFI
/* --------------------------------------------------------------------
 *  Keypad (power_on, ufi, ufi_reset) for ufi
 * -------------------------------------------------------------------- */
static struct gpio_keys_button zx297510_keypad[] = {
	[0] = {
		.gpio		= AO_GPIO_13,		/* UFI_RESET */
		.desc		= "reset",
		.active_low	= 1,     //Ƿ͵ƽЧ1: Ϊ͵ƽ  0: Ϊߵƽ
		},
	[1] = {
		.gpio		= AO_GPIO_14,		/* POWER - gpioΪЧ */
		.desc		= "power",
		.active_low	= 0,
		},
	[2] = {
		.gpio		= AO_GPIO_12,		/* WIFI */
		.desc		= "wifi",
		.active_low	= 1,
		},
};

static struct gpio_keys_platform_data zx297510_keypad_data = {
	.buttons	= zx297510_keypad,
	.nbuttons	= ARRAY_SIZE(zx297510_keypad),
};
#endif

static struct mfd_cell zx234290_cell[] = {
	{
		.name = "zx234290-regulators",
	},
	{
		.name = "zx234290-rtc",
	},
	{
		.name = "zx234290-gpadc",
	},
	#ifdef CONFIG_KEYBOARD_ZX234290_UFI
	{
		.name = "zx234290_keypad",
		.id 	=	-1,
		.platform_data = &zx297510_keypad_data,
		.pdata_size    = sizeof(zx297510_keypad_data),
	},
	#endif
};

unsigned int boot_reason = POWER_ON_NORMAL;

unsigned int * get_boot_reason_addr(void)
{
	return (unsigned int *)POWERON_TYPE_BASE;
}
EXPORT_SYMBOL(get_boot_reason_addr);

static void get_boot_reason(void)
{
#ifdef POWERON_TYPE_BASE
	boot_reason = *(unsigned int *)POWERON_TYPE_BASE;

//cl:ȥҪں˴ӡ
//	printk(KERN_INFO "[PMU] get boot_reason = %d from 0x%p.\n",
//								boot_reason, (void *)POWERON_TYPE_BASE);
#else
	printk(KERN_INFO "[PMU] boot_reason is unknown.\n");
#endif
}

#if 1
int zx234290_set_bits(struct zx234290 *zx234290, u8 reg, u8 mask)
{
	u8 data;
	int err;

	mutex_lock(&zx234290->io_mutex);

	err = zx234290->read(zx234290, reg, 1, &data);
	if (err) {
		dev_err(zx234290->dev, "Read from reg 0x%x failed\n", reg);
		goto out;
	}

	data |= mask;
	err = zx234290->write(zx234290, reg, 1, &data);
	if (err)
		dev_err(zx234290->dev, "Write to reg 0x%x failed\n", reg);

out:
	mutex_unlock(&zx234290->io_mutex);
	return err;
}
EXPORT_SYMBOL_GPL(zx234290_set_bits);

int zx234290_clear_bits(struct zx234290 *zx234290, u8 reg, u8 mask)
{
	u8 data;
	int err;

	mutex_lock(&zx234290->io_mutex);
	err = zx234290->read(zx234290, reg, 1, &data);
	if (err) {
		dev_err(zx234290->dev, "Read from reg 0x%x failed\n", reg);
		goto out;
	}

	data &= ~mask;
	err = zx234290->write(zx234290, reg, 1, &data);
	if (err)
		dev_err(zx234290->dev, "Write to reg 0x%x failed\n", reg);

out:
	mutex_unlock(&zx234290->io_mutex);
	return err;
}
EXPORT_SYMBOL_GPL(zx234290_clear_bits);
#endif

static inline int zx234290_read(struct zx234290 *zx234290, u8 reg)
{
	u8 val;
	int err;

	err = zx234290->read(zx234290, reg, 1, &val);
	if (err < 0)
		return err;

	return val;
}

static inline int zx234290_write(struct zx234290 *zx234290, u8 reg, u8 val)
{
	return zx234290->write(zx234290, reg, 1, &val);
}

#if 1
int zx234290_reg_read(struct zx234290 *zx234290, u8 reg)
{
	int data;

	mutex_lock(&zx234290->io_mutex);

	data = zx234290_read(zx234290, reg);
	if (data < 0)
		dev_err(zx234290->dev, "Read from reg 0x%x failed\n", reg);

	mutex_unlock(&zx234290->io_mutex);
	return data;
}
EXPORT_SYMBOL_GPL(zx234290_reg_read);

int zx234290_reg_write(struct zx234290 *zx234290, u8 reg, u8 val)
{
	int err;

	mutex_lock(&zx234290->io_mutex);

	err = zx234290_write(zx234290, reg, val);
	if (err < 0)
		dev_err(zx234290->dev, "Write for reg 0x%x failed\n", reg);

	mutex_unlock(&zx234290->io_mutex);
	return err;
}
EXPORT_SYMBOL_GPL(zx234290_reg_write);
#endif

extern int zx234290_i2c_write_simple(u8 reg, void *src);
extern int zx234290_i2c_read_simple(u8 reg, void *dest);
int Zx234290_SetVldo6Onoff(void)
{
    int ret = 0;
    u8 reg_addr=0, reg_val=0;
    reg_addr = 0x21;
    ret = zx234290_i2c_read_simple(reg_addr,&reg_val);
    if (ret) {
        return -EIO;
    }
    reg_val = reg_val&(~(1<<5));
    ret = zx234290_i2c_write_simple(reg_addr, &reg_val);
    if (ret) {
        return -EIO;
    }
    return 0;
}
EXPORT_SYMBOL(Zx234290_SetVldo6Onoff);
#if 0
int zx297510_write_pmu_flag_charging(void)
{
	int ret = 0;
	unsigned char reg = 0;
	ret = zx234290_i2c_read_simple(0xf, &reg);
	reg = reg|0xff;
	ret += zx234290_i2c_write_simple(0xf, &reg);
	ret = zx234290_i2c_read_simple(0xe, &reg);
	reg = reg|0x3;
	ret += zx234290_i2c_write_simple(0xe, &reg);
	return ret;
}
#endif
//static void __iomem* PMU_ADDR_VIR;
//#define GPIO_PMU_PSHOLD ZX29_GPIO_51
unsigned int gpio_num_pshold;
gpio_func_id gpio_func_pshold;
int pshold_gpio_flag=0xff;
void zx234290_pshold_pull_down(void)
{
	//PMU_ADDR_VIR = ioremap(0x10d6c0,4);
	//__raw_writel(0x0,PMU_ADDR_VIR);
	if(pshold_gpio_flag)
		pshold_gpio_flag = gpio_request(gpio_num_pshold, "pshold1");
	zx29_gpio_config(gpio_num_pshold, gpio_func_pshold);
	//zx29_gpio_set_direction(gpio_num_pshold, GPIO_IN); //set output;v3 gpio24(pshold) direction is reverse
	zx29_gpio_set_direction(gpio_num_pshold, GPIO_OUT);
	zx29_gpio_output_data(gpio_num_pshold, 0);
}

//extern int zx234290_rtc_disable_timer_alarm();
EXPORT_SYMBOL(zx234290_pshold_pull_down);

/***********yuwei added at 20170523**************/
void zx234290_pshold_pull_up(void)
{
    //PMU_ADDR_VIR = ioremap(0x10d6c0,4);
    //__raw_writel(0x0,PMU_ADDR_VIR);
	if(pshold_gpio_flag)
		pshold_gpio_flag = gpio_request(gpio_num_pshold, "pshold1");

	zx29_gpio_config(gpio_num_pshold, gpio_func_pshold);
	//zx29_gpio_set_direction(gpio_num_pshold, GPIO_IN); //set output;v3 gpio24(pshold) direction is reverse
	zx29_gpio_set_direction(gpio_num_pshold, GPIO_OUT);
	zx29_gpio_output_data(gpio_num_pshold, 1);

//	printk("[yuwei] %s, pshold_gpio =%d, for charging in poweroff.\n",__FUNCTION__,pshold_gpio_flag);
}
/**************/

static int zx234290_set_softon(int on)
{
	u8 reg = 0;
    int ret;

    ret = zx234290_i2c_read_simple(ZX234290_REG_ADDR_SYS_CTRL, &reg);
    if (ret) {
        return -EIO;
    }

    if ((reg >> ZX234290_SOFTON_LSH) != on) {
        reg ^= (0x01 << ZX234290_SOFTON_LSH);
        ret = zx234290_i2c_write_simple(ZX234290_REG_ADDR_SYS_CTRL, &reg);
        if (ret) {
            return -EIO;
        }
    }

    return 0;
}

static bool debug_stop_poweroff = false;
module_param(debug_stop_poweroff, bool, 0644);
extern void zx29_restart(char str,const char * cmd);
static void zx234290_power_off(void)
{
	//void __iomem *reset_charging_reg;
	//reset_charging_reg = ZX29_TOP_VA;
	//zx234290_rtc_disable_timer_alarm();
	//Zx234290_SetVldo6Onoff();
	u8 reg_poweron = 0;
    int ret;

	if(debug_stop_poweroff )
	{
		printk(KERN_INFO"debug_stop_poweroff= 0x%x, for debug, bug_on!!!!\n", debug_stop_poweroff);
		panic("poweroff");
	}
	zx234290_set_softon(0);
	zx234290_pshold_pull_down();
#if 1
	while(1){
		ret = zx234290_i2c_read_simple(ZX234290_REG_ADDR_STSA, &reg_poweron);	
		if (ret) {
			printk(KERN_INFO"power off pmu i2c read err\n");
			break;
		}
		if((reg_poweron&(1<<ZX234290_STATUSA_POWERON_LSH))== 0)
			break;
	}
	msleep(50);
	/*reset to charging*/
	zx29_restart(NULL,"drv_key reboot");
#endif
}


#if defined(CONFIG_DEBUG_FS)
static ssize_t debugfs_regs_write(struct file *file, const char __user *buf,size_t nbytes, loff_t *ppos)
{
	struct zx234290 *zx234290 = file->private_data;

	unsigned int val1, val2;
	u8 reg, value;
	int ret;
	char *kern_buf;

	kern_buf = kzalloc(nbytes, GFP_KERNEL);

	if (!kern_buf) {
		printk(KERN_INFO "zx234290-core: Failed to allocate buffer\n");
		return -ENOMEM;
	}

	if (copy_from_user(kern_buf, (void  __user *)buf, nbytes)) {
		kfree(kern_buf);
		return -ENOMEM;
	}
	printk(KERN_INFO "%s input str=%s,nbytes=%d \n", __func__, kern_buf,nbytes);

	ret = sscanf(kern_buf, "%x:%x", &val1, &val2);
	if (ret < 2 || val1 > ZX234290_MAX_REGISTER ) {
		printk(KERN_INFO "zx234290-core: failed to read user buf, ret=%d, input 0x%x:0x%x\n",
				ret, val1, val2);
		kfree(kern_buf);
		return -EINVAL;
	}
	kfree(kern_buf);

	reg = val1 & 0xff;
	value = val2 & 0xff;
	printk(KERN_INFO "%s input %x,%x; reg=%x,value=%x\n", __func__, val1, val2, reg, value);
	ret = zx234290_i2c_write_simple(reg, &value);

	return ret ? ret : nbytes;
}

static int debugfs_regs_show(struct seq_file *s, void *v)
{
	int i;
	u8 value[ZX234290_MAX_REGISTER];
	int ret=0;
	u8 reg_rtc_ctrl2 = 0;

	printk(KERN_INFO "%s\n", __func__);
	memset(value, 0, sizeof(value));
	for (i = 0; i < ZX234290_MAX_REGISTER; i++){
		ret = zx234290_i2c_read_simple(i, &(value[i]));
		if(ret){
			printk(KERN_INFO "%s err=%d, break\n", __func__, ret);
			seq_printf(s, "%s err=%d, break", __func__, ret);
			return ret;
		}
	}

	for (i = 0; i < ZX234290_MAX_REGISTER; i++) {
		if((i+1)%9 == 0)
			seq_printf(s, "\n");

		seq_printf(s, "[0x%x]%02x ", i, value[i]);
	}

	reg_rtc_ctrl2 = value[ZX234290_REG_ADDR_RTC_CTRL2];
	seq_printf(s, "\nAF=%d,TF=%d,Alarm %s,Timer %s\n",(reg_rtc_ctrl2&0x8),(reg_rtc_ctrl2&0x4),
		  			(reg_rtc_ctrl2&0x2)? "enable":"disable",(reg_rtc_ctrl2&0x1)? "enable":"disable");
	if(value[ZX234290_REG_ADDR_BUCK_FAULT_STATUS]||value[ZX234290_REG_ADDR_LDO_FAULT_STATUS])
		seq_printf(s, "ldo or bulk fault!!!!!\n ");
	else
		seq_printf(s, "no ldo or bulk fault\n ");
	if(value[ZX234290_REG_ADDR_TIMER_CTRL]&0x80)
		seq_printf(s, "timer enable\n ");
	else
		seq_printf(s, "timer disable\n ");

	return ret;
}

#define DEBUGFS_FILE_ENTRY(name) \
static int debugfs_##name##_open(struct inode *inode, struct file *file) \
{\
return single_open(file, debugfs_##name##_show, inode->i_private); \
}\
\
static const struct file_operations debugfs_##name##_fops = { \
.owner= THIS_MODULE, \
.open= debugfs_##name##_open, \
.write=debugfs_##name##_write, \
.read= seq_read, \
.llseek= seq_lseek, \
.release= single_release, \
}


DEBUGFS_FILE_ENTRY(regs);

static int debugfs_adc_get(void *data, u64 *val)
{
	switch ((int)data) {
	case 0:
		*val = get_battery_voltage();
		break;
	case 1:
		*val = get_adc1_voltage();
		break;
	case 2:
		*val = get_adc2_voltage();
		break;
	default:
		*val = -1;
		break;
	}

    return 0;
}

DEFINE_SIMPLE_ATTRIBUTE(fops_adc_ro, debugfs_adc_get, NULL, "%llumV\n");

static struct dentry *g_pmu_root;

extern unsigned long int_irq_times;
extern unsigned long  int_thread_times;

static void debugfs_pmu_init(struct zx234290 *zx234290)
{
	struct dentry *root;
	struct dentry *node;
	int i;

	if(!zx234290)
		return;

	//create root
	root = debugfs_create_dir("pmu_zx29", NULL);
	if (!root)	{
		dev_err(&zx234290->dev, "debugfs_create_dir err=%d\n", IS_ERR(root));
		goto err;
	}

	//print regs;
	node = debugfs_create_file("regs", S_IRUGO | S_IWUGO, root, zx234290,  &debugfs_regs_fops);
	if (!node){
		dev_err(&zx234290->dev, "debugfs_create_dir err=%d\n", IS_ERR(node));
		goto err;
	}

	//print adc0;
	node = debugfs_create_file("adc0", S_IRUGO, root, 0,  &fops_adc_ro);
	if (!node){
		dev_err(&zx234290->dev, "debugfs_create_dir err=%d\n", IS_ERR(node));
		goto err;
	}

	//print adc1;
	node = debugfs_create_file("adc1", S_IRUGO, root, 1,  &fops_adc_ro);
	if (!node){
		dev_err(&zx234290->dev, "debugfs_create_dir err=%d\n", IS_ERR(node));
		goto err;
	}

	//print adc2;
	node = debugfs_create_file("adc2", S_IRUGO, root, 2,  &fops_adc_ro);
	if (!node){
		dev_err(&zx234290->dev, "debugfs_create_dir err=%d\n", IS_ERR(node));
		goto err;
	}

	//print u32
	node = debugfs_create_u32("irq_cnt", S_IRUGO, root, &int_irq_times);
	if (!node){
		dev_err(&zx234290->dev, "debugfs_create_u32  irq_cnt err=%d\n", IS_ERR(node));
		goto err;
	}

	//print u32
	node = debugfs_create_u32("thread_cnt", S_IRUGO, root, &int_thread_times);
	if (!node){
		dev_err(&zx234290->dev, "debugfs_create_u32  thread_cnt err=%d\n", IS_ERR(node));
		goto err;
	}

	g_pmu_root = (void *)root;
	return;
err:
	dev_err(&zx234290->dev, "debugfs_pmu_init err\n");
}

#endif

int zx234290_device_init(struct zx234290 *zx234290)
{
	struct zx234290_board *pmic_plat_data = zx234290->dev->platform_data;
	//struct zx234290_platform_data *init_data;
	int ret;
	int irq;

	get_boot_reason();
    /*
	init_data = kzalloc(sizeof(struct zx234290_platform_data), GFP_KERNEL);
	if (init_data == NULL)
		return -ENOMEM;
    */
	mutex_init(&zx234290->io_mutex);
	dev_set_drvdata(zx234290->dev, zx234290);

	ret = mfd_add_devices(zx234290->dev, -1,
			      zx234290_cell, ARRAY_SIZE(zx234290_cell),
			      NULL, 0);
	if (ret < 0)
		goto err;

    gpio_num_pshold = pmic_plat_data->pshold_gpio_num;//by yuxiang
    gpio_func_pshold= pmic_plat_data->pshold_gpio_func;//by yuxiang
	if (!pm_power_off)
		pm_power_off = zx234290_power_off;

#ifdef PSHOLD_PULLUP_IN_POWEROFFCHARGING
	/* CPE MDL don't control ps_hold pin. */
	if (boot_reason == POWER_ON_CHARGING) {
		zx234290_pshold_pull_up();
	}
#endif
/***********PJT added **************/
	zx234290_get_chip_version();
	zDrvZx234290_LdoInit();
    if (POWER_ON_CHARGING == boot_reason) {
		 zDrvZx234290_ChgOnSleepConfig();
  	} else {
		zDrvZx234290_NormalSleepConfig();
	}

/*************************/
#if (defined AP_NO_NEED_PMU_INT_FOR_PHONE) || (defined _USE_VEHICLE_DC)

#else
	//init_data->irq = pmic_plat_data->irq;
	//init_data->irq_base = pmic_plat_data->irq_base;
	irq = gpio_to_irq(pmic_plat_data->irq_gpio_num);
	ret = zx234290_irq_init(zx234290, irq, pmic_plat_data);
	if (ret < 0)
		goto err;
#endif


#if defined(CONFIG_DEBUG_FS)
	debugfs_pmu_init(zx234290);
#endif
	//kfree(init_data);
	return ret;

err:
	//kfree(init_data);
	mfd_remove_devices(zx234290->dev);
	kfree(zx234290);
	return ret;
}

void zx234290_device_exit(struct zx234290 *zx234290)
{
#if defined(CONFIG_DEBUG_FS)
	if(g_pmu_root){
		printk(KERN_INFO "zx234290_device_exit:debugfs_remove_recursive \n");
		debugfs_remove_recursive(g_pmu_root);
	}
#endif
	mfd_remove_devices(zx234290->dev);
	kfree(zx234290);
}


MODULE_AUTHOR("yuxiang");
MODULE_DESCRIPTION("ZX234290 chip family multi-function driver");
MODULE_LICENSE("GPL");
