/*
 * zx234290-regulator-wrapper.c  --  regulator for ZX234290 PMICs
 *
 * Copyright 2016 ZTE Inc.
 *
 * Author: yuxiang<yu.xiang5@zte.com.cn>
 *
 *  This program is free software; you can redistribute  it and/or modify it
 *  under  the terms of  the GNU General  Public License as published by the
 *  Free Software Foundation;  either version 2 of the  License, or (at your
 *  option) any later version.
 *
 */
#include <linux/init.h>        /* For init/exit macros */
#include <linux/module.h>      /* For MODULE_ marcros  */
#include <linux/interrupt.h>
#include <linux/spinlock.h>
#include <linux/platform_device.h>

#include <linux/device.h>
#include <linux/delay.h>
#include <linux/mutex.h>
#include <linux/mfd/zx234290.h>

static int zDrvZx234290_DischargerConfig(void)
{
    int nRet = 0;
    int index = 0 ;

    /*enable all discharger*/
    for(index = DISCHARGER_LDO_9; index < DISCHARGER_MAX; index++)
    {
        if(index == DISCHARGER_BUCK_X || index == DISCHARGER_LDO_X)
            continue;
        nRet = zx234290_SetDischarger(index, DISCHARGER_ENABLE);
    	if (0 != nRet)
    	{
    		return -EIO;
    	}
    }
    /*config, buck0 discharger disable*/
    /*
    nRet = Zx234290_SetDischarger(DISCHARGER_BUCK_0, DISCHARGER_DISBALE);
    if (DRV_SUCCESS != nRet)
    {
    	return DRV_ERROR;
    }*/

    return 0;
}
#if 1
extern int pmu_chip_ver;

int zDrvZx234290_NormalSleepConfig(void)
{
	int nRet = 0;

	/* if chg_pwron, this bucks will be closed, we open them again when system reset... */
    //zx234290_set_buck3_onoff(LDO_ENABLE_ON);        /*RF 1V6*/
    zx234290_set_buck4_onoff(LDO_ENABLE_ON);        /*PA 3V6*/
    //zx234290_set_ldo8_onoff(LDO_ENABLE_ON);         /*ZSP JTAG/SD 2V85*/
	//zx234290_set_ldo6_onoff(LDO_ENABLE_ON);         /*SIM1 1V8ﲻÿSIMԼӰʱ*/
	if (pmu_chip_ver != 297)
	zx234290_set_ldo10_onoff(LDO_ENABLE_ON);        /*adc0.9v/dac0.9v/avdd_pll0.9v/avdd_abb0.9v*/
    zx234290_set_ldo1_onoff(LDO_ENABLE_ON);         /*USB 0V9*/
    zx234290_set_ldo5_onoff(LDO_ENABLE_ON);         /*USB 3V3*/
	
	//nRet = Zx234290_SetBUCK1SleepMode(BUCK1_SLP_AUTO_ECO_SLP);
	nRet = zx234290_set_buck1_sleep_mode(BUCK1_SLP_SHUTDOWN);
	if (0 != nRet)
	{
		return -EIO;
	}

    nRet = zx234290_set_buck2_sleep_mode(BUCK234_SLP_ECO_WITH_ECO);
	if (0 != nRet)
	{
		return -EIO;
	}
	//nRet = Zx234290_SetBUCK3SleepMode(BUCK234_SLP_ECO_WITH_ECO);
	nRet = zx234290_set_buck3_sleep_mode(BUCK234_SLP_SHUTDOWN);
	if (0 != nRet)
	{
		return -EIO;
	}

	nRet = zx234290_set_buck4_sleep_mode(BUCK234_SLP_SHUTDOWN);
	if (0 != nRet)
	{
		return -EIO;
	}
	nRet = zx234290_set_ldo2_sleep_mode(LDOA_SLP_ECO_VOLT);
	if (0 != nRet)
	{
		return -EIO;
	}
	nRet = zx234290_set_ldo3_sleep_mode(LDOA_SLP_ECO_VOLT);
	if (0 != nRet)
	{
		return -EIO;
	}

	nRet = zx234290_set_ldo4_sleep_mode(LDOB_SLP_SHUTDOWN);
	if (0 != nRet)
	{
		return -EIO;
	}

	nRet = zx234290_set_ldo6_sleep_mode(LDOB_SLP_ECO_VOLT);
	if (0 != nRet)
	{
		return -EIO;
	}

	nRet = zx234290_set_ldo7_sleep_mode(LDOA_SLP_ECO_VOLT);
	if (0 != nRet)
	{
		return -EIO;
	}

	nRet = zx234290_set_ldo8_sleep_mode(LDOA_SLP_ECO_VOLT);//עͺŻܹ
	if (0 != nRet)
	{
		return -EIO;
	}

	nRet = zx234290_set_ldo9_sleep_mode(LDOA_SLP_ECO_VOLT);
	if (0 != nRet)
	{
		return -EIO;
	}

    nRet = zx234290_set_ldo10_sleep_mode(LDOA_SLP_ECO_VOLT);
	if (0 != nRet)
	{
		return -EIO;
	}

	return 0;
}
/* for chaging power on */
int zDrvZx234290_ChgOnSleepConfig(void)
{
    //zx234290_set_buck3_onoff(LDO_ENABLE_OFF);        /*RF 1V6*/
    zx234290_set_buck4_onoff(LDO_ENABLE_OFF);        /*PA 3V6*/
    //zx234290_set_ldo1_onoff(LDO_ENABLE_OFF);         /*USB 0V9*/
    //zx234290_set_ldo5_onoff(LDO_ENABLE_OFF);         /*USB 3V3*/
    zx234290_set_ldo6_onoff(LDO_ENABLE_OFF);         /*SIM1 1V8*/
    //zx234290_set_ldo7_onoff(LDO_ENABLE_OFF);       /*RF 2V85*/
    //zx234290_set_ldo8_onoff(LDO_ENABLE_ON);         /*ZSP JTAG/SD 2V85 ͺŻܹ*/
    //zx234290_set_ldo9_onoff(LDO_ENABLE_OFF);         /*PLL 0V9*/
    zx234290_set_ldo10_onoff(LDO_ENABLE_OFF);        /*ABB DIG*/

	zx234290_set_buck1_sleep_mode(BUCK1_SLP_SHUTDOWN);  /*vdcore*/
    zx234290_set_buck2_sleep_mode(BUCK234_SLP_ECO_WITH_ECO);/*ddr1.2v/mcp1.2v/hsic1.2v*/
    zx234290_set_buck3_sleep_mode(BUCK234_SLP_SHUTDOWN);   /*RF 1V6*/
    //zx234290_set_buck4_sleep_mode(BUCK234_SLP_SHUTDOWN);   /*PA 3V6*/
    //zx234290_set_ldo1_sleep_mode(LDOA_SLP_SHUTDOWN);       /*USB 0V9*/
    //zx234290_set_ldo5_sleep_mode(LDOA_SLP_SHUTDOWN);       /*USB 3V3*/
	zx234290_set_ldo2_sleep_mode(LDOA_SLP_ECO_VOLT_SLP);    /*io1.8v/mcp1.8v/sd01.8v*/
	zx234290_set_ldo3_sleep_mode(LDOA_SLP_ECO_VOLT_SLP);	/*vp111.8v/vddr_pll1.8v/*/
	zx234290_set_ldo4_sleep_mode(LDOA_SLP_SHUTDOWN);		/*vcxo*/
    //zx234290_set_ldo6_sleep_mode(LDOA_SLP_SHUTDOWN);       /*SIM1 1V8*/
    zx234290_set_ldo7_sleep_mode(LDOA_SLP_ECO_VOLT_SLP);  /*RF 2V85 -- 26M */
    zx234290_set_ldo8_sleep_mode(LDOA_SLP_ECO_VOLT_SLP);       /*ZSP JTAG/SD 2V85/LCD*/
    zx234290_set_ldo9_sleep_mode(LDOA_SLP_ECO_VOLT_SLP);       /*PLL 0V9*/
    //zx234290_set_ldo10_sleep_mode(LDOA_SLP_SHUTDOWN);      /*ABB DIG*/

	return 0;
}


#endif

int zDrvZx234290_LdoInit(void)
{
    int ret = 0;

	//zDrvZx234290_Config();
	ret = zDrvZx234290_LdoRstErr();
    
	ret += zx234290_set_buck1_active_mode(BUCK_NRM_FORCE_PWM);
	
	ret += zx234290_set_buck2_active_mode(BUCK_NRM_FORCE_PWM);
	
	ret += zx234290_set_buck3_active_mode(BUCK_NRM_FORCE_PWM);
	
	ret += zx234290_set_buck4_active_mode(BUCK_NRM_FORCE_PWM);

    
	ret += zDrvZx234290_DischargerConfig();

	//zDrvZx234290_SleepConfig();

    ret += zx234290_SetLlpEnable(LLP_ENABLE);
    ret += zx234290_SetTllpToDo(LLP_SHUTDOWN);
   // ret += zx234290_SetRestartDly(LLP_DLY_500MS);  //LLP_DLY_250MS 
    if(ret != 0)
	{
		printk("zx234290 zDrvZx234290_LdoInit err\n");
		return -1;
	}

	return 0;
}
#if 1	/* vdd_CORE0 -- 0.9V -- BUCK1 */
/*******************************************************************************
 * Function:
 * Description:
 * Parameters:
 *	 Input:
 *
 *	 Output:
 *
 * Returns:
 *
 *
 * Others:
 ********************************************************************************/
int zx234290_setcore_onoff(T_ZDrvPmic_Enable status)
{
	int ret = 0;

	ret = zx234290_set_buck1_onoff((T_ZDrvZx234290_LDO_ENABLE)status);

	return ret;
}

T_ZDrvPmic_Enable zx234290_getcore_onoff(void)
{
	int status;

	status	= zx234290_get_buck1_onoff();

	return (T_ZDrvPmic_Enable)status;
}
int zx234290_setcore_voltage(int vol)
{
	int ret = 0;
	switch (vol)
	{
		case 900:
		{
			ret = zx234290_set_buck1_voltage(VBUCKA_0_900);
			break;
		}

		case 1100:
		{
			ret = zx234290_set_buck1_voltage(VBUCKA_1_100);
			break;
		}
		default:
		{
			ret = -EINVAL;
		}
	}

	return ret;
}

int zx234290_getcore_voltage(void)
{
	int	vget;
	T_ZDrvZx234290_VbuckA vol;

	vol = zx234290_get_buck1_voltage();
	switch (vol)
	{
		case VBUCKA_0_900:
		{
			vget = 900;
			break;
		}

		case VBUCKA_1_100:
		{
			vget = 1100;
			break;
		}

		default:
		{
			return -EINVAL;
		}
	}

	return vget;
}

int zx234290_setcore_sleepmode(T_ZDrvPmic_SlpMode mode)
{
	int ret = 0;

    switch (mode)
	{
		case PM_SLPMODE_AUTO_NORMAL:
		case PM_SLPMODE_ECO_NRMV:
		case PM_SLPMODE_ECO_SLPV:
        case PM_SLPMODE_OFF:
		{
			ret = zx234290_set_buck1_sleep_mode((T_ZDrvZx234290_BUCK1_SLPMODE)mode);
			break;
		}
		default:
		{
			ret = -EINVAL;
		}
	}

	return ret;
}

T_ZDrvPmic_SlpMode zx234290_getcore_sleepmode(void)
{
	T_ZDrvPmic_SlpMode	getMode;
	T_ZDrvZx234290_BUCK1_SLPMODE	mode;

	mode = zx234290_get_buck1_sleep_mode();
	switch (mode)
	{
		case BUCK1_SLP_AUTO_WITHOUT_ECO:
		{
			getMode = PM_SLPMODE_AUTO_NORMAL;
			break;			
		}
		case BUCK1_SLP_AUTO_ECO:	
		{
			getMode = PM_SLPMODE_ECO_NRMV;
			break;			
		}
		case BUCK1_SLP_AUTO_ECO_SLP:
		{
			getMode = PM_SLPMODE_ECO_SLPV;
			break;			
		}

		case BUCK1_SLP_SHUTDOWN:
		{
			getMode = PM_SLPMODE_OFF;
			break;
		}
		default:
		{
			return PM_SLPMODE_NOT_SUPPORT;
		}
	}

	return getMode;
}

int zx234290_setcore_sleepvoltage(int vol) 	 /* buck1 sleep vol */
{
	int ret = 0;
	switch (vol)
	{
        case 800:
		{
			ret = zx234290_set_buck1_sleep_voltage(VBUCKA_0_800);
			break;
		}
		case 900:
		{
			ret = zx234290_set_buck1_sleep_voltage(VBUCKA_0_900);
			break;
		}

		case 1100:
		{
			ret = zx234290_set_buck1_sleep_voltage(VBUCKA_1_100);
			break;
		}
		default:
		{
			ret = -EINVAL;
		}
	}

	return ret;
}
#endif


#if 1	/*	USB 0.9V-- LDO1 */
/*******************************************************************************
 * Function:
 * Description:
 * Parameters:
 *	 Input:
 *
 *	 Output:
 *
 * Returns:
 *
 *
 * Others:
 ********************************************************************************/
int zx234290_setusb_v0v9_onoff(T_ZDrvPmic_Enable status)
{
	int ret = 0;

	ret = zx234290_set_ldo1_onoff((T_ZDrvZx234290_LDO_ENABLE)status);

	return ret;
}

int zx234290_setusb_v0v9_onoff_PSM(T_ZDrvPmic_Enable status)
{
	int ret = 0;

	ret = zx234290_set_ldo1_onoff_PSM((T_ZDrvZx234290_LDO_ENABLE)status);

	return ret;
}

T_ZDrvPmic_Enable zx234290_getusb_v0v9_onoff(void)
{
	int status;

	status	= zx234290_get_ldo1_onoff();

	return (T_ZDrvPmic_Enable)status;
}

int zx234290_setusb_v0v9_voltage(int vol)
{
	int ret = 0;
	switch (vol)
	{
		case 900:
		{
			ret = zx234290_set_ldo1_voltage(VLDOA_0_900);
			break;
		}
		default:
		{
			ret = -EINVAL;
		}
	}
	return ret;
}

int zx234290_getusb_v0v9_voltage(void)
{
	int  vget;
	T_ZDrvZx234290_VldoA   vol;

	vol = zx234290_get_ldo1_voltage();
	switch (vol)
	{
		case VLDOA_0_900:
		{
			vget = 900;
			break;
		}
		default:
		{
			return -EINVAL;
		}
	}

	return vget;
}

int zx234290_setusb_v0v9_sleepmode(T_ZDrvPmic_SlpMode mode)
{
	int ret = 0;

    switch (mode)
	{
		case PM_SLPMODE_AUTO_NORMAL:
		case PM_SLPMODE_ECO_NRMV:
		case PM_SLPMODE_ECO_SLPV:
        case PM_SLPMODE_OFF:
		{
			ret = zx234290_set_ldo1_sleep_mode((T_ZDrvZx234290_LDOA_SLPMODE)mode);
			break;
		}
		default:
		{
			ret = -EINVAL;
		}
	}
	return ret;

}

T_ZDrvPmic_SlpMode zx234290_getusb_v0v9_sleepmode(void)
{
	T_ZDrvPmic_SlpMode	getMode;
	T_ZDrvZx234290_LDOA_SLPMODE	 mode;

	mode = zx234290_get_ldo1_sleep_mode();
	switch (mode)
	{
		case LDOA_SLP_NRM_MODE:
		{
			getMode = PM_SLPMODE_AUTO_NORMAL;
			break;
		}
		case LDOA_SLP_ECO_VOLT:
		{
			getMode = PM_SLPMODE_ECO_NRMV;
			break;
		}
        case LDOA_SLP_ECO_VOLT_SLP:
		{
			getMode = PM_SLPMODE_ECO_SLPV;
			break;
		}
		case LDOA_SLP_SHUTDOWN:
		{
			getMode = PM_SLPMODE_OFF;
			break;
		}
		default:
		{
			return PM_SLPMODE_NOT_SUPPORT;
		}
	}
	return getMode;
}

#endif

#if 1	/*	USB 3.3V-- LDO1 */
/*******************************************************************************
 * Function:
 * Description:
 * Parameters:
 *	 Input:
 *
 *	 Output:
 *
 * Returns:
 *
 *
 * Others:
 ********************************************************************************/
int zx234290_setusb_v3v3_onoff(T_ZDrvPmic_Enable status)
{
	int ret = 0;

	ret = zx234290_set_ldo5_onoff((T_ZDrvZx234290_LDO_ENABLE)status);

	return ret;
}

int zx234290_setusb_v3v3_onoff_PSM(T_ZDrvPmic_Enable status)
{
	int ret = 0;

	ret = zx234290_set_ldo5_onoff_PSM((T_ZDrvZx234290_LDO_ENABLE)status);

	return ret;
}


T_ZDrvPmic_Enable zx234290_getusb_v3v3_onoff(void)
{
	int status;

	status	= zx234290_get_ldo5_onoff();

	return (T_ZDrvPmic_Enable)status;
}

int zx234290_setusb_v3v3_voltage(int vol)
{
	int ret = 0;
	switch (vol)
	{
		case 3300:
		{
			ret = zx234290_set_ldo5_voltage(VLDOC_3_300);
			break;
		}
		default:
		{
			ret = -EINVAL;
		}
	}
	return ret;
}

int zx234290_getusb_v3v3_voltage(void)
{
	int vget;
	T_ZDrvZx234290_VldoB	vol;

	vol = zx234290_get_ldo5_voltage();
	switch (vol)
	{
		case VLDOC_3_300:
		{
			vget = 3300;
			break;
		}
		default:
		{
			return -EINVAL;
		}
	}

	return vget;
}

int zx234290_setusb_v3v3_sleepmode(T_ZDrvPmic_SlpMode mode)
{
	int ret = 0;

    switch (mode)
	{
		case PM_SLPMODE_AUTO_NORMAL:
		case PM_SLPMODE_ECO_NRMV:
		case PM_SLPMODE_ECO_SLPV:
        case PM_SLPMODE_OFF:
		{
			ret = zx234290_set_ldo5_sleep_mode((T_ZDrvZx234290_LDOB_SLPMODE)mode);
			break;
		}
		default:
		{
			ret = -EINVAL;
		}
	}
	return ret;

}

T_ZDrvPmic_SlpMode zx234290_getusb_v3v3_sleepmode(void)
{
	T_ZDrvPmic_SlpMode	getMode;
	T_ZDrvZx234290_LDOB_SLPMODE	 mode;

	mode = zx234290_get_ldo5_sleep_mode();
	switch (mode)
	{
		case LDOA_SLP_NRM_MODE:
		{
			getMode = PM_SLPMODE_AUTO_NORMAL;
			break;
		}
		case LDOA_SLP_ECO_VOLT:
		{
			getMode = PM_SLPMODE_ECO_NRMV;
			break;
		}
        case LDOA_SLP_ECO_VOLT_SLP:
		{
			getMode = PM_SLPMODE_ECO_SLPV;
			break;
		}
		case LDOA_SLP_SHUTDOWN:
		{
			getMode = PM_SLPMODE_OFF;
			break;
		}
		default:
		{
			return PM_SLPMODE_NOT_SUPPORT;
		}
	}
	return getMode;
}
#endif

#if 1	/* SIM1 1.8V/3.0V -- LDO6 */
/*******************************************************************************
 * Function:
 * Description:
 * Parameters:
 *	 Input:
 *
 *	 Output:
 *
 * Returns:
 *
 *
 * Others:
 ********************************************************************************/
int zx234290_setsim1_onoff(T_ZDrvPmic_Enable status)
{
	int ret = 0;

	ret = zx234290_set_ldo6_onoff((T_ZDrvZx234290_LDO_ENABLE)status);

	return ret;
}


T_ZDrvPmic_Enable zx234290_getsim1_onoff(void)
{
	int status;

	status	= zx234290_get_ldo6_onoff();

	return (T_ZDrvPmic_Enable)status;
}
int zx234290_setsim1_voltage(int vol)
{
	int ret = 0;
	switch (vol)
	{
		case 1800:
		{
			ret = zx234290_set_ldo6_voltage(VLDOD_1_800);
			break;
		}

		case 3000:
		{
			ret = zx234290_set_ldo6_voltage(VLDOD_3_000);
			break;
		}

		default:
		{
			ret = -EINVAL;
		}
	}

	return ret;
}
int zx234290_getsim1_voltage(void)
{
	int vget;
	T_ZDrvZx234290_VldoD vol;

	vol = zx234290_get_ldo6_voltage();
	switch (vol)
	{
		case VLDOD_1_800:
		{
			vget = 1800;
			break;
		}

		case VLDOD_3_000:
		{
			vget = 3000;
			break;
		}

		default:
		{
			return -EINVAL;
		}
	}

	return vget;
}

int zx234290_setsim1_sleepmode(T_ZDrvPmic_SlpMode mode)
{
	int ret = 0;

    switch (mode)
	{
		case PM_SLPMODE_AUTO_NORMAL:
		case PM_SLPMODE_ECO_NRMV:
        case PM_SLPMODE_OFF:
		{
			ret = zx234290_set_ldo6_sleep_mode((T_ZDrvZx234290_LDOB_SLPMODE)mode);
			break;
		}
		default:
		{
			ret = -EINVAL;
		}
	}

	return ret;
}

T_ZDrvPmic_SlpMode zx234290_getsim1_sleepmode(void)
{
	T_ZDrvPmic_SlpMode	getMode;
	T_ZDrvZx234290_LDOB_SLPMODE	 mode;

	mode = zx234290_get_ldo6_sleep_mode();
	switch (mode)
	{
		case LDOB_SLP_NRM_MODE:
		{
			getMode = PM_SLPMODE_AUTO_NORMAL;
			break;			
		}
		case LDOB_SLP_ECO_VOLT:
		{
			getMode = PM_SLPMODE_ECO_NRMV;
			break;			
		}
		case LDOB_SLP_SHUTDOWN:
		{
			getMode = PM_SLPMODE_OFF;
			break;			
		}
		default:
		{
			return PM_SLPMODE_NOT_SUPPORT;
		}
	}

	return getMode;
}
#endif

#if 1	/* SIM2 1.8V/3.0V -- LDO6 */
/*******************************************************************************
 * Function:
 * Description:
 * Parameters:
 *	 Input:
 *
 *	 Output:
 *
 * Returns:
 *
 *
 * Others:
 ********************************************************************************/
int zx234290_setsim2_onoff(T_ZDrvPmic_Enable status)
{
	int ret = 0;

	ret = zx234290_set_ldo10_onoff((T_ZDrvZx234290_LDO_ENABLE)status);

	return ret;
}


T_ZDrvPmic_Enable zx234290_getsim2_onoff(void)
{
	T_ZDrvZx234290_LDO_ENABLE status;

	status	= zx234290_get_ldo10_onoff();

	return (T_ZDrvPmic_Enable)status;
}

int zx234290_setsim2_voltage(int vol)
{
	int ret = 0;
	switch (vol)
	{
		case 1800:
		{
			ret = zx234297_set_ldo10_voltageF(VLDOF_1_800);
			break;
		}

		case 3000:
		{
			ret = zx234297_set_ldo10_voltageF(VLDOF_3_000);
			break;
		}

		default:
		{
			ret = -EINVAL;
		}
	}

	return ret;
}
int zx234290_getsim2_voltage(void)
{
	int vget;
	T_ZDrvZx234297_VldoF vol;

	vol = zx234290_get_ldo10_voltageF();
	switch (vol)
	{
		case VLDOF_1_800:
		{
			vget = 1800;
			break;
		}

		case VLDOF_3_000:
		{
			vget = 3000;
			break;
		}

		default:
		{
			return -EINVAL;
		}
	}

	return vget;
}

int zx234290_setsim2_sleepmode(T_ZDrvPmic_SlpMode mode)
{
	int ret = 0;

    switch (mode)
	{
		case PM_SLPMODE_AUTO_NORMAL:
		case PM_SLPMODE_ECO_NRMV:
        case PM_SLPMODE_OFF:
		{
			ret = zx234290_set_ldo10_sleep_mode((T_ZDrvZx234290_LDOA_SLPMODE)mode);
			break;
		}
		default:
		{
			ret = -EINVAL;
		}
	}

	return ret;
}

T_ZDrvPmic_SlpMode zx234290_getsim2_sleepmode(void)
{
	T_ZDrvPmic_SlpMode	getMode;
	T_ZDrvZx234290_LDOA_SLPMODE	 mode;

	mode = zx234290_get_ldo10_sleep_mode();
	switch (mode)
	{
		case LDOA_SLP_NRM_MODE:
		{
			getMode = PM_SLPMODE_AUTO_NORMAL;
			break;			
		}
		case LDOA_SLP_ECO_VOLT:
		{
			getMode = PM_SLPMODE_ECO_NRMV;
			break;			
		}
		case LDOA_SLP_ECO_VOLT_SLP:
		{
			getMode = PM_SLPMODE_ECO_SLPV;
			break;			
		}	
		case LDOA_SLP_SHUTDOWN:
		{
			getMode = PM_SLPMODE_OFF;
			break;			
		}
		default:
		{
			return PM_SLPMODE_NOT_SUPPORT;
		}
	}

	return getMode;
}
#endif


#if 1	/* SD1- 1.8V/2.8V --LDO8 */
/*******************************************************************************
 * Function:
 * Description:
 * Parameters:
 *	 Input:
 *
 *	 Output:
 *
 * Returns:
 *
 *
 * Others:
 ********************************************************************************/
int zx234290_setsd1_onoff(T_ZDrvPmic_Enable status)
{
	int ret = 0;

	ret = zx234290_set_ldo8_onoff((T_ZDrvZx234290_LDO_ENABLE)status);

	return ret;
}

T_ZDrvPmic_Enable zx234290_getsd1_onoff(void)
{
	int status;

	status = zx234290_get_ldo8_onoff();

	return (T_ZDrvPmic_Enable)status;
}
int zx234290_setsd1_voltage(int vol)
{
	int ret = 0;

    switch (vol)
	{
        case 1800:
		{
			ret = zx234290_set_ldo8_voltage(VLDOD_1_800);
			break;
		}
		case 2800:
		{
			ret = zx234290_set_ldo8_voltage(VLDOD_2_800);
			break;
		}
		default:
		{
			ret = -EINVAL;
		}
	}

	return ret;
}

int zx234290_getsd1_voltage(void)
{
	int vget;
	T_ZDrvZx234290_VldoD vol;

	vol = zx234290_get_ldo8_voltage();

	switch (vol)
	{
        case VLDOD_1_800:
		{
			vget = 1800;
			break;
		}

		case VLDOD_2_800:
		{
			vget = 2800;
			break;
		}

		default:
		{
			return -EINVAL;
		}
	}

	return vget;
}

int zx234290_setsd1_sleepmode(T_ZDrvPmic_SlpMode mode)
{
	int ret = 0;

    switch (mode)
	{
		case PM_SLPMODE_AUTO_NORMAL:
		case PM_SLPMODE_ECO_NRMV:
        case PM_SLPMODE_ECO_SLPV:
        case PM_SLPMODE_OFF:
		{
			ret = zx234290_set_ldo8_sleep_mode((T_ZDrvZx234290_LDOA_SLPMODE)mode);
			break;
		}
		default:
		{
			ret = -EINVAL;
		}
	}

	return ret;
}

T_ZDrvPmic_SlpMode zx234290_getsd1_sleepmode(void)
{
	T_ZDrvPmic_SlpMode	getMode;
	T_ZDrvZx234290_LDOA_SLPMODE	 mode;

    mode = zx234290_get_ldo8_sleep_mode();

	switch (mode)
	{
		case LDOA_SLP_NRM_MODE:
		{		
			getMode = PM_SLPMODE_AUTO_NORMAL;
			break;
		}
		case LDOA_SLP_ECO_VOLT:	
		{		
			getMode = PM_SLPMODE_ECO_NRMV;
			break;
		}
        case LDOA_SLP_ECO_VOLT_SLP:	
		{		
			getMode = PM_SLPMODE_ECO_SLPV;
			break;
		}
		case LDOA_SLP_SHUTDOWN:
		{
			getMode = PM_SLPMODE_OFF;
			break;
		}
		default:
		{
			return PM_SLPMODE_NOT_SUPPORT;
		}
	}

	return getMode;
}

#endif

#if 1
int zDrvPmic_SetNormal_Onoff(T_ZDrvPmic_Regulator regulator, T_ZDrvPmic_Enable enable)
{
    int ret = 0;

    switch (regulator)
    {
        case VSD1:
            ret = zx234290_setsd1_onoff(enable);
            break;

        case VSIM1:
            ret = zx234290_setsim1_onoff(enable);
            break;
			
        case VSIM2:
            ret = zx234290_setsim2_onoff(enable);
            break;
			
        case VUSB_0V9:
            ret = zx234290_setusb_v0v9_onoff(enable);
            break;

        case VUSB_3V3:
            ret = zx234290_setusb_v3v3_onoff(enable);
            break;

		default:
			return -EINVAL;
    }

    return ret;
}
EXPORT_SYMBOL(zDrvPmic_SetNormal_Onoff);


int zDrvPmic_SetNormal_Onoff_PSM(T_ZDrvPmic_Regulator regulator, T_ZDrvPmic_Enable enable)
{
    int ret = 0;

    switch (regulator)
    {
        case VSD1:
            ret = zx234290_setsd1_onoff(enable);
            break;

        case VSIM1:
            ret = zx234290_setsim1_onoff(enable);
            break;

        case VUSB_0V9:
            ret = zx234290_setusb_v0v9_onoff_PSM(enable);
            break;

        case VUSB_3V3:
            ret = zx234290_setusb_v3v3_onoff_PSM(enable);
            break;

		default:
			return -EINVAL;
    }

    return ret;
}
EXPORT_SYMBOL(zDrvPmic_SetNormal_Onoff_PSM);



int zDrvPmic_SetNormal_Voltage(T_ZDrvPmic_Regulator regulator, int voltage)
{
    int ret = 0;

    switch (regulator)
    {
        case VSD1:
            ret = zx234290_setsd1_voltage(voltage);
            break;

        case VSIM1:
            ret = zx234290_setsim1_voltage(voltage);
            break;
        case VSIM2:
            ret = zx234290_setsim2_voltage(voltage);
            break;
        case VUSB_0V9:
            ret = zx234290_setusb_v0v9_voltage(voltage);
            break;

        case VUSB_3V3:
            ret = zx234290_setusb_v0v9_voltage(voltage);
            break;

		default:
			return -EINVAL;
    }

    return ret;
}
EXPORT_SYMBOL(zDrvPmic_SetNormal_Voltage);



int zDrvPmic_SetSleep_Voltage(T_ZDrvPmic_Regulator regulator, int voltage)
{
    int ret = 0;

    switch (regulator)
    {
        case VCORE0:
            break;

        case VCORE1:
            {
            ret = zx234290_setcore_voltage(voltage);
            if (ret != 0)
            {
                return ret;
            }
            break;
        }

		default:
			return -EINVAL;
    }

    return ret;
}

EXPORT_SYMBOL(zDrvPmic_SetSleep_Voltage);


int zDrvPmic_GetNormal_Onoff(T_ZDrvPmic_Regulator regulator, T_ZDrvPmic_Enable* enable)
{
    int ret = 0;

    switch (regulator)
    {

        case VSD1:
            *enable = zx234290_getsd1_onoff();
            break;

        case VSIM1:
            *enable = zx234290_getsim1_onoff();
            break;

        case VUSB_0V9:
            *enable = zx234290_getusb_v0v9_onoff();
            break;

        case VUSB_3V3:
            *enable = zx234290_getusb_v3v3_onoff();
            break;

		default:
			return -EINVAL;
    }

    return ret;
}

EXPORT_SYMBOL(zDrvPmic_GetNormal_Onoff);


int zDrvPmic_GetNormal_Voltage(T_ZDrvPmic_Regulator regulator, int* voltage)
{
    int ret = 0;

    switch (regulator)
    {

        case VSD1:
            *voltage = zx234290_getsd1_voltage();
            break;

        case VSIM1:
            *voltage = zx234290_getsim1_voltage();
            break;

        case VUSB_0V9:
            *voltage = zx234290_getusb_v0v9_voltage();
            break;

        case VUSB_3V3:
            *voltage = zx234290_getusb_v3v3_voltage();
            break;

		default:
			return -EINVAL;
    }

    return ret;
}

EXPORT_SYMBOL(zDrvPmic_GetNormal_Voltage);
#endif

