/*
 * Gadget Driver for Android ADB
 *
 * Copyright (C) 2008 Google, Inc.
 * Author: Mike Lockwood <lockwood@android.com>
 *
 * This software is licensed under the terms of the GNU General Public
 * License version 2, as published by the Free Software Foundation, and
 * may be copied, distributed, and modified under those terms.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 */

#include <linux/module.h>
#include <linux/init.h>
#include <linux/poll.h>
#include <linux/delay.h>
#include <linux/wait.h>
#include <linux/err.h>
#include <linux/interrupt.h>
#include <linux/sched.h>
#include <linux/types.h>
#include <linux/device.h>
#include <linux/miscdevice.h>
#include <linux/soc/zte/rpm/rpmsg.h>
#include <linux/soc/zte/rpm/icp.h>
#include <linux/android_notify.h>

#define ADB_BULK_BUFFER_SIZE           4096
#define ADB_AGENT_BUF_SIZE           640
#define ADB_RPMSG_MAX_SIZE           512
#define ADB_RPMSG_CH                  channel_3

 struct adb_dev *g_adb_agent;
ssize_t adb_server_write2usb( const char *buf,size_t count);
extern int usb_rpmsg_notify_ap(usb_rpmsg_cmd *notify, int has_param);
extern int usb_get_adb_agent(void);

void adb_recv_from_ap(void *buf, unsigned int len)
{
	int i;
	unsigned char *data;
	struct adb_dev *dev = _adb_dev;
	char*tmp= (char*)buf;
	if(dev == NULL)
		return;
	

	if (len==0){
	USBSTACK_DBG("adb_recv_from_cap, len 0, notify \n ", len);
		atomic_set(&dev->write_busy, 0);		
		wake_up(&dev->agt_write_wq);
		return ;
	}
	USBSTACK_DBG("adb_recv_from_cap, len %d, write2usb \n ", len);
#if 0
	if(len < 32){
		printk(" adb_recv_from_ap, send to usb start:\n");
		for(i = 0; i < len; i++){
			printk(" %x", tmp[i]);
			if((i != 0) &&(i % 16) == 0)
				printk("\n");
		}
		printk("\n adb_recv_from_ap, send to usb end\n");
	}
#endif
	
	adb_server_write2usb((char *)buf, len);
	g_adb_agent->set_test = 0;
} 
#if 0
static ssize_t adb_server_read(struct file *fp, char __user *buf,
				size_t count, loff_t *pos)
{
	struct adb_dev *dev = fp->private_data;
	struct usb_request *req;
	int r = count, xfer;
	int ret;

	pr_debug("adb_read(%d)\n", count);
	if (!_adb_dev)
		return -ENODEV;

	if (count > ADB_BULK_BUFFER_SIZE)
		return -EINVAL;

	if (adb_lock(&dev->read_excl))
		return -EBUSY;

	/* we will block until we're online */
	while (!(dev->online || dev->agt_error)) {
		pr_debug("adb_read: waiting for online state\n");
		ret = wait_event_interruptible(dev->read_wq,
				(dev->online || dev->agt_error));
		if (ret < 0) {
			adb_unlock(&dev->read_excl);
			return ret;
		}
	}
	if (dev->agt_error) {
		r = -EIO;
		printk("adb_read block fail ret:%d", r);
		goto done;
	}

requeue_req:
	/* queue a request */
	req = dev->rx_req;
	req->length = count;
	dev->rx_done = 0;
	if(!dev->online){
		printk("adb_read dev is offline\n");
		r = -EIO;
		goto done;
	}
	ret = usb_ep_queue(dev->ep_out, req, GFP_ATOMIC);
	if (ret < 0) {
		pr_debug("adb_read: failed to queue req %p (%d)\n", req, ret);
		r = -EIO;
		dev->agt_error = 1;
		printk("adb_read ep-queue fail ret:%d", r);
		goto done;
	} else {
		pr_debug("rx %p queue\n", req);
	}

	/* wait for a request to complete */
	ret = wait_event_interruptible(dev->read_wq, dev->rx_done);
	if (ret < 0) {
		if (ret != -ERESTARTSYS)
			dev->agt_error = 1;
		r = ret;
		usb_ep_dequeue(dev->ep_out, req);
		printk("adb_read stop ret: 0x%x", ret);
		goto done;
	}
	if (!dev->agt_error) {
		if(!dev->online){
			printk("adb_read dev is offline cannot requeue req\n");
			r = -EIO;
			goto done;
		}
		/* If we got a 0-len packet, throw it back and try again. */
		if (req->actual == 0)
			goto requeue_req;

		pr_debug("rx %p %d\n", req, req->actual);
		xfer = (req->actual < count) ? req->actual : count;
		if (copy_to_user(buf, req->buf, xfer))
			r = -EFAULT;

	} else{
		printk("adb_read fail %d", r);
		r = -EIO;
	}

done:
	adb_unlock(&dev->read_excl);
	pr_debug("adb_read returning %d\n", r);
	return r;
}
#endif

void adb_agent_inform_work(struct work_struct *work)
{
	struct adb_dev	*dev = container_of(work, struct adb_dev, agent_inform_work);
	
	kobject_uevent(&adb_device.this_device->kobj, (dev->agent_state == 1) ? KOBJ_OFFLINE : KOBJ_ONLINE);
}


int adb_rpmsg_write2ap(void *buf, unsigned int len)
{
	int ret = 0;
	int i;
	char *tmp = (char *)buf;
	
	int transfer_cnt, total_cnt; 
	if (!g_adb_agent)
		return -1;
	
	T_ZDrvRpMsg_Msg rpmsg = {0};

	rpmsg.actorID = CAP_ID;
	rpmsg.chID = ADB_RPMSG_CH;	
	rpmsg.flag = 0;
	rpmsg.flag |= 1;
	USBSTACK_DBG("adb_rpmsg_write2ap datalen:%d\n",  len);
#if 0
	if(len && len < 32){
		printk(" data from usb, send to cap start:\n");
		for(i = 0; i < len; i++){
			printk(" %x", tmp[i]);
			if((i != 0) &&(i % 16) == 0)
				printk("\n");
		}
		printk("\n data from usb, send to cap end\n");
	}
#endif	
	if(len == 0){//just send notify
		rpmsg.len = len;
		ret = zDrvRpMsg_Write_Cap(&rpmsg);
		if(ret < 0)
			printk("adb_rpmsg_write2ap notify send fail, ret:%d\n", ret);	
		return ret;
	}
	total_cnt = len;
	while(total_cnt){
		transfer_cnt = total_cnt > ADB_RPMSG_MAX_SIZE ? ADB_RPMSG_MAX_SIZE: total_cnt;
		memcpy(g_adb_agent->rx2agt_buf, tmp, transfer_cnt);
		rpmsg.len = transfer_cnt;
		rpmsg.buf = g_adb_agent->rx2agt_buf;
		atomic_set(&g_adb_agent->write_busy, 1);		
		ret = zDrvRpMsg_Write_Cap(&rpmsg);
		if(rpmsg.len != ret){
			atomic_set(&g_adb_agent->write_busy, 0);
			printk("[adb_rpmsg_write2ap] msg send error:(%d)", ret);
			return ret;
		}
		//should wait for ap recv ok
			USBSTACK_DBG("adb_rpmsg_recv_thread, brfore agt_write_wq len:%d, write_busy:%d\n",  transfer_cnt, atomic_read(&g_adb_agent->write_busy));
		ret = wait_event_interruptible(g_adb_agent->agt_write_wq,
			(!atomic_read(&g_adb_agent->write_busy)) || g_adb_agent->agt_error);
		USBSTACK_DBG("adb_rpmsg_recv_thread, after agt_write_wq len:%d, write_busy:%d\n",  transfer_cnt, atomic_read(&g_adb_agent->write_busy));

		if (ret < 0) {
			break;
		}
		total_cnt -= transfer_cnt;
		tmp += transfer_cnt;
		if(g_adb_agent->agt_error){
			printk("adb_rpmsg_write2ap, agt_error break, trans len left:%d\n", total_cnt);
			ret = -1;
			break;
		}
	}
	atomic_set(&g_adb_agent->write_busy, 0);
	
	return 0;  
}

ssize_t adb_server_write2usb( const char *buf,size_t count)
{
	struct usb_request *req = NULL;
	int r = count, xfer;
	int ret = 0;
	if (!g_adb_agent)
		return -ENODEV;
	//pr_debug("adb_write(%d)\n", count);
	//printk("adb_server_write2usb begin\n");

#ifdef CONFIG_PM
	if (g_adb_agent->suspend_state == 1){
		g_dbg_adb_times++;
		//usb_printk("%s, %u  wrtime:%d\n", __func__, __LINE__,  g_dbg_adb_times);
		//USBSTACK_DBG("%s, %u  wrtime:%d", __func__, __LINE__,  g_dbg_adb_times);
		return -EBUSY;
#if 0
        usb_gadget_wakeup(dev->cdev->gadget);
		do{
			msleep(2);
		}while(dev->suspend_state==1);
#endif
	}
#endif
	if (adb_lock(&g_adb_agent->write_excl)){
		printk("adb_write write_excl lock fail\n");
		return -EBUSY;
	}
	
	if(g_adb_agent->agent_start == 0 || g_adb_agent->agent_state == 0){
		printk("adb_write dev->agt_error\n");
		adb_unlock(&g_adb_agent->write_excl);
		return -EIO;		
	}
	
	while (count > 0) {
		if (g_adb_agent->agt_error) {
			printk("adb_write dev->agt_error\n");
			r = -EIO;
			break;
		}

		/* get an idle tx request to use */
		req = NULL;
	USBSTACK_DBG("adb_server_write2usb waiting write_wq, agt_error:%d, txempty:%d\n",g_adb_agent->agt_error, list_empty(&g_adb_agent->tx_idle));
		atomic_set(&g_adb_agent->agt_write_flag, 1);
		ret = wait_event_interruptible(g_adb_agent->write_wq,
			(req = adb_req_get(g_adb_agent, &g_adb_agent->tx_idle)) || g_adb_agent->agt_error);

			USBSTACK_DBG("adb_server_write2usb req:0x%x\n", req);
		atomic_set(&g_adb_agent->agt_write_flag, 0);	
		if (ret < 0) {
			r = ret;
			break;
		}
		if(g_adb_agent->agt_error || (g_adb_agent->adb_ready == 0) || (g_adb_agent->agent_state == 0)){
			printk("write2usb get agt_error err, break write\n");
			r = -EIO;
			break;			
		}

		if (req != 0) {
			if (count > ADB_BULK_BUFFER_SIZE)
				xfer = ADB_BULK_BUFFER_SIZE;
			else
				xfer = count;
			memcpy(req->buf, buf, xfer);
			adb_rpmsg_write2ap(NULL, 0);
			if(g_adb_agent->agt_error){
				printk("after write2ap get agt_error err, break write\n");
				r = -EIO;
				break;			
			}			
			req->length = xfer;
			//printk("adb_server_write2usb, req:%x, datalen:%d\n", req, req->length);
			ret = usb_ep_queue(g_adb_agent->ep_in, req, GFP_ATOMIC);
			if (ret < 0) {
				printk("adb_write: xfer agt_error %d\n", ret);
				g_adb_agent->agt_error = 1;
				r = -EIO;
				break;
			}

			buf += xfer;
			count -= xfer;

			/* zero this so we don't try to free it on error exit */
			req = NULL;
		}
	}

	if (req)
		adb_req_put(g_adb_agent, &g_adb_agent->tx_idle, req);

	adb_unlock(&g_adb_agent->write_excl);
	USBSTACK_DBG("adb_server_write2usb returning %d\n", r);
	return r;
}
#if 1
static int adb_agent_open(void)
{
	//pr_info("adb_open\n");
	if (!g_adb_agent)
		return -ENODEV;
	//if(g_adb_agent->)
	
	printk("%s", __func__);



	/* clear the agt_error latch */
	g_adb_agent->agt_error = 0;

	//adb_ready_callback();

	if(atomic_read(&g_adb_agent->enable_excl)){
		g_adb_agent->online = 1;
		wake_up(&g_adb_agent->agt_start_wait);
	}

	return 0;
}
#endif

void adb_agent_dequeue_rx(struct adb_dev *dev)
{
	
	if (dev->agent_start){
		printk("adb_agent_dequeue_rx  agent_start  dequeue\n");
		usb_ep_dequeue(dev->ep_out, dev->rx_req);
		
	}		
}
int adb_agent_close(void)
{
	int ret;
	//pr_info("adb_release\n");
	USBSTACK_DBG("%s", __func__);
	printk("adb_agent_close\n");
	//adb_closed_callback();
	struct usb_request *req = g_adb_agent->rx_req;


	g_adb_agent->agent_start = 0;
	g_adb_agent->agent_state = 0;
	g_adb_agent->agt_error = 1;
	printk("adb_agent_close,agt_write_flag:%d, write_busy:%d\n", atomic_read(&g_adb_agent->agt_write_flag), atomic_read(&g_adb_agent->write_busy));
	if(atomic_read(&g_adb_agent->write_busy) || atomic_read(&g_adb_agent->agt_write_flag)){
		printk("adb_agent_close, write_busy is 1\n");
		atomic_set(&g_adb_agent->write_busy, 0);
		wake_up(&g_adb_agent->agt_write_wq);
		wake_up(&g_adb_agent->write_wq);
		g_adb_agent->set_test |= 0x4;
	}
#if 0	
	g_adb_agent->rx_done = 1;
	wake_up(&g_adb_agent->read_wq);
#endif	
#if 0
	//if(atomic_read(&g_adb_agent->read_excl)){		
		USBSTACK_DBG("adb_agent_close, disable and reenable ep_out");
		ret = usb_ep_disable(g_adb_agent->ep_out);
		if(ret){
			printk("adb_agent_close, usb_ep_disable fail,%d\n", ret);
			WARN_ON(1);
		}
		ret = usb_ep_enable(g_adb_agent->ep_out);
		if(ret){
			printk("adb_agent_close, usb_ep_enable fail,%d\n", ret);
			WARN_ON(1);
		}
			USBSTACK_DBG("adb_agent_close, ep_out enable ok\n");

	//}
#endif	
	if(list_empty(&g_adb_agent->tx_idle) && atomic_read(&g_adb_agent->write_excl)){
		printk("adb_agent_close, disable and reenable ep_in");
		ret = usb_ep_disable(g_adb_agent->ep_in);
		if(ret){
			printk("adb_agent_close, usb_ep_disable fail,%d\n", ret);
			WARN_ON(1);
		}
		ret = usb_ep_enable(g_adb_agent->ep_in);
		if(ret){
			printk("adb_agent_close, usb_ep_enable fail,%d\n", ret);
			WARN_ON(1);
		}		
	}
	if(atomic_read(&g_adb_agent->open_excl))
		adb_unlock(&g_adb_agent->open_excl);
	return 0;
}

int adb_agent_monitor_thread(void *ptr)
{
	unsigned long			flags;
	struct adb_dev *dev = (struct adb_dev *)ptr;

	int ret;	
	
	while(!kthread_should_stop()){
		USBSTACK_DBG("adb_agent_monitor_thread waiting for agent_monitor_wq\n");
		ret = wait_event_interruptible(dev->agent_monitor_wq,
				(atomic_read(&dev->agent_switch) ||kthread_should_stop()));
		if (ret < 0) {
			USBSTACK_DBG("monitor_thread wait fail\n");
			//return ret;
			continue;
		}
		
		if(kthread_should_stop())
		{
			printk("unbind thread stop");
			break;
		}
		USBSTACK_DBG("adb_agent_monitor_thread,got, agent_switch:%d, agent_state:%d\n", 
			atomic_read(&dev->agent_switch), dev->agent_state);
		atomic_set(&dev->agent_switch, 0);
		if(dev->agent_state){//enable agent				
			adb_server_plug_notify(USB_RPMSG_NOTIFY_ADB_ONLINE);
			dev->agent_start = 1;	
			dev->agt_error = 0;
		//wakeup adb read and return	
		//dev->rx_done = 1;
		//wake_up(&dev->read_wq);
			if (atomic_read(&dev->read_excl)){
				adb_agent_dequeue_rx(dev);
			}
			wake_up(&dev->agt_start_wait);
		}else{	
			//dev->agent_start = 0;
			//disable agent
			adb_server_plug_notify(USB_RPMSG_NOTIFY_ADB_OFFLINE);
			adb_agent_close();
		}
		
		schedule_work(&dev->agent_inform_work);
		
	}
	return 0;
}

int adb_rpmsg_agent_state(void)
{
	if(!g_adb_agent){
		printk("adb_rpmsg_agent_state, adb is NULL, fail\n");
		return -1;
	}

	return g_adb_agent->agent_state;
}
EXPORT_SYMBOL_GPL(adb_rpmsg_agent_state);

int adb_enable_rpmsg_agent(int flag)
{
	if(!g_adb_agent){
		printk("adb_enable_rpmsg_agent, adb is NULL, fail\n");
		return -1;
	}
	if(g_adb_agent->adb_ready == 0){
		printk("adb_enable_rpmsg_agent, adb has not init ok, return\n");
		return;
	}
	g_adb_agent->agent_state = ((flag != 0) ? 1 : 0);
	atomic_set(&g_adb_agent->agent_switch, 1);
	printk("adb_enable_rpmsg_agent,now %s adb agent\n", (g_adb_agent->agent_state == 1) ? "start" : "stop");
	//do switch agent in monitor thread
	wake_up(&g_adb_agent->agent_monitor_wq);
	return 0;
}
EXPORT_SYMBOL_GPL(adb_enable_rpmsg_agent);


void adb_agent_switch_work(struct work_struct *work)
{
	struct adb_dev	*dev = container_of(work, struct adb_dev, agent_switch_work);

	if(usb_get_adb_agent() == 1){
		printk("agent_switch_work, switch to CAP\n");
		adb_enable_rpmsg_agent(1);
		return;
	}
	
	printk("agent_switch_work, switch to AP\n");
	adb_enable_rpmsg_agent(0);
	
}

void adb_rpmsg_recv_thread(void *ptr)
{

	unsigned long			flags;
	struct adb_dev *dev = (struct adb_dev *)ptr;
	struct usb_request *req;
	int r , xfer;
	int ret = 0;
	r = xfer = 0;
	
	while(!kthread_should_stop()){	
		/* we will block until we're online */
		while (!dev->agent_start) {
			USBSTACK_DBG("adb_rpmsg_recv_thread: waiting foragt_start_wait\n");
			ret = wait_event_interruptible(dev->agt_start_wait,
					( dev->agent_start ||kthread_should_stop()));
			if (ret < 0) {
				//adb_unlock(&dev->read_excl);
				return ret;
			}
		}
		
		if(kthread_should_stop())
		{
			USBSTACK_DBG("unbind thread stop");
			break;
		}
			USBSTACK_DBG("adb_rpmsg_recv_thread: now send request\n");

requeue_req:
		/* queue a request */
		req = dev->rx_req;
		req->length = ADB_BULK_BUFFER_SIZE;
		dev->rx_done = 0;
		if(!dev->online){
			USBSTACK_DBG("rpmsg_recv dev is offline\n");
			r = -EIO;
			goto done;
		}
#if 0		
		if(atomic_read(&dev->adb_read_flag)){
			printk("\nadb_rpmsg_recv_thread adb_read_flag, wait_read_wq\n");
			goto wait_read_wq;
		}	
#endif		
		USBSTACK_DBG("\nadb_rpmsg_recv_thread read usb again\n");
		ret = usb_ep_queue(dev->ep_out, req, GFP_ATOMIC);
		if (ret < 0) {
			pr_debug("rpmsg_recv: failed to queue req %p (%d)\n", req, ret);
			r = -EIO;
			dev->agt_error = 1;
			USBSTACK_DBG("rpmsg_recv ep-queue fail ret:%d", r);
			goto done;
		} else {
			USBSTACK_DBG("rx %p queue\n", req);
		}
		atomic_set(&dev->agt_read_flag, 1);
		
		/* wait for a request to complete */
wait_read_wq:		
		ret = wait_event_interruptible(dev->read_wq, dev->rx_done);
			USBSTACK_DBG("adb_rpmsg_recv_thread: read from usb end, ret:%d, agt_error:%d\n", ret, dev->agt_error);
		
		atomic_set(&dev->agt_read_flag, 0);
		if (ret < 0) {
			if (ret != -ERESTARTSYS)
				dev->agt_error = 1;
			r = ret;
			usb_ep_dequeue(dev->ep_out, req);
			printk("rpmsg_recv stop ret: 0x%x", ret);
			goto done;
		}
		if (!dev->agt_error) {
			if(!dev->online){
				USBSTACK_DBG("rpmsg_recv dev is offline cannot requeue req\n");
				r = -EIO;
				goto done;
			}
			/* If we got a 0-len packet, throw it back and try again. */
			if (req->actual == 0){
				USBSTACK_DBG("rpmsg_recv actual is 0, requeue_req again\n");				
				goto requeue_req;
			}
			//printk("rpmsg_recv rx %p actual:%d\n", req, req->actual);
			
			xfer = req->actual;
			r = adb_rpmsg_write2ap(req->buf, xfer);
			if(ret){
				printk("adb_rpmsg_write fail, err:%d \n", ret);
			}
			
			goto requeue_req;
		} else{
			if(dev->agent_start){
				USBSTACK_DBG("rpmsg_recv  fail ,len:%d, status:%d\n", req->actual, req->status);				
				r = -EIO;
				dev->rx_done = 0;
			}else{
				USBSTACK_DBG("adb_rpmsg_write wake_up agt_read_wq, len:%d, status:%d\n", req->actual, req->status);
			
				wake_up(&dev->agt_read_wq);
			}
			
		}

done:
		//adb_unlock(&dev->read_excl);
		USBSTACK_DBG("rpmsg_recv returning %d\n", r);

				
	}
}

void adb_server_plug_notify(e_usb_rpmsg_cmd_type plug_type)
{
	usb_rpmsg_cmd notify; 
	memset(&notify, 0, sizeof(notify));
	notify.cmd = plug_type;
	usb_rpmsg_notify_ap(&notify, 0);
}

int adb_server_init(struct adb_dev *dev)
{
	int ret = 0;
	dev->agt_error = 0;
	init_waitqueue_head(&dev->agent_monitor_wq);
	init_waitqueue_head(&dev->agt_start_wait);
	init_waitqueue_head(&dev->agt_read_wq);
	init_waitqueue_head(&dev->agt_write_wq);	
	INIT_WORK(&dev->agent_inform_work, adb_agent_inform_work);
	INIT_DELAYED_WORK(&dev->agent_switch_work, adb_agent_switch_work);
	atomic_set(&dev->agent_switch, 0);
	atomic_set(&dev->write_busy, 0);
	atomic_set(&dev->agt_read_flag, 0);
	atomic_set(&dev->adb_read_flag, 0);
	
	/* create channel */
	//if(zDrvRpMsg_CreateChannel(AP_ID, ADB_RPMSG_CH, ADB_BULK_BUFFER_SIZE))
	if(zDrvRpMsg_CreateChannel_Cap(CAP_ID, ADB_RPMSG_CH, ADB_AGENT_BUF_SIZE))
	{
		printk("[adb_server_init] Failed create psm icp channel ! \n");
		BUG();
	}
	
	printk("[adb_server_init] Success create psm icp channel!!! \n");	
	//macro not defined now, using 1 replace
	//zDrvRpMsg_RegCallBack(AP_ID, ADB_RPMSG_CH, adb_recv_from_ap);
	zDrvRpMsg_RegCallBack_Cap(CAP_ID, ADB_RPMSG_CH, adb_recv_from_ap);
	dev->rpmsg_thread = kthread_run(adb_rpmsg_recv_thread, (unsigned long)dev+1, "adb_rpmsg_recv");
	BUG_ON(IS_ERR(dev->rpmsg_thread));
	
	dev->agent_monitor_thread = kthread_run(adb_agent_monitor_thread, (unsigned long)dev+1, "adb_agent_monitor");
	BUG_ON(IS_ERR(dev->agent_monitor_thread));
	g_adb_agent = dev;
	//alloc 512
	g_adb_agent->rx2agt_buf = kmalloc(ADB_BULK_BUFFER_SIZE, GFP_KERNEL);
	if(!g_adb_agent->rx2agt_buf){
		panic("rx2agt_buf malloc fail\n");
	}
	return ret;		
}

int adb_server_release(void)
{

	flush_work_sync(&g_adb_agent->agent_inform_work);
	kthread_stop(g_adb_agent->rpmsg_thread);
	kthread_stop(g_adb_agent->agent_monitor_thread);
	
	if(g_adb_agent->rx2agt_buf)
		kfree(g_adb_agent->rx2agt_buf);
	
	g_adb_agent	= NULL;	
	return 0;
}
