/*
 * u_diag.h -- interface to USB gadget "wincomm log" utilities
 *
 * Copyright (C) 2019 ZTE Corporation
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 */

#ifndef __U_DIAG_H
#define __U_DIAG_H

typedef void (*usb_diag_rx_complete_callback)(void *buf, unsigned int len);
typedef void (*usb_diag_tx_complete_callback)(void *buf);

struct u_diag {
	struct usb_function		func;

	/* port is managed by diag_{connect,disconnect} */
	struct diag_port			*ioport;

	struct usb_ep			*in;
	struct usb_ep			*out;

	/* REVISIT avoid this CDC-ACM support harder ... */
	struct usb_cdc_line_coding port_line_coding;	/* 9600-8-N-1 etc */

	/* notification callbacks */
	void (*connect)(struct gserial *p);
	void (*disconnect)(struct gserial *p);
	int (*send_break)(struct gserial *p, int duration);
#ifdef CONFIG_PM
	u32 suspend_state;
#endif
};

#endif /* __U_DIAG_H */
