/*
 * usb attributes rpmsg server
 *
 * Copyright (C) 2023 Sanechips, Inc.
 * Author: Guo Shanning <10117327@sanechips.com.cn>
 *
 * This software is licensed under the terms of the GNU General Public
 * License version 2, as published by the Free Software Foundation, and
 * may be copied, distributed, and modified under those terms.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 */

#include <linux/module.h>
#include <linux/init.h>
#include <linux/delay.h>
#include <linux/wait.h>
#include <linux/err.h>
#include <linux/interrupt.h>
#include <linux/kthread.h>
#include <linux/sched.h>
#include <linux/types.h>
#include <linux/device.h>
#include <linux/soc/zte/rpm/rpmsg.h>
#include <linux/soc/zte/rpm/icp.h>
#include <linux/android_notify.h>

//#define ADB_BULK_BUFFER_SIZE           4096
#define USB_AGENT_BUF_SIZE           256
#define USB_RPMSG_CH                  channel_5

extern void usb_set_rpmsg_resp(int type, char*resp);
extern void android_set_rpmsg_resp(int type, char*resp);
extern void usb_parse_cap_notify(int type);

struct task_struct	*rpmsg_thread;
wait_queue_head_t usb_agt_wq;
wait_queue_head_t usb_write_wq;
atomic_t rpmsg_flag;
atomic_t write_busy;

char usb_msg[USB_AGENT_BUF_SIZE] = {0};
char usb_resp[USB_AGENT_BUF_SIZE] = {0};
#if 0
#define USB_RPMSG_RESP  1
#define USB_RPMSG_NOTIFY  2

typedef enum __usb_rpmsg_cmd_type{
	USB_RPMSG_CMD = 0,
	USB_RPMSG_GET_NET_TYPE = USB_RPMSG_CMD,
	USB_RPMSG_GET_USB_SPEED,
	USB_RPMSG_GET_USB_STATE,
	USB_RPMSG_GET_USB_LINK_STATE,
	//USB_RPMSG_GET_,
	//USB_RPMSG_GET_,
	
	USB_RPMSG_CMD_MAX,
}e_usb_rpmsg_cmd_type;


typedef struct __usb_cmd_msg{
	int cmd;
	char *param;	
}usb_rpmsg_cmd;

#endif

int usb_rpmsg2ap(void *buf, unsigned int len);


int usb_rpmsg_notify_ap(usb_rpmsg_cmd *notify, int has_param)
{
	usb_rpmsg_cmd *t_data = NULL;
	
	memset(usb_resp, 0, USB_AGENT_BUF_SIZE);
	t_data = (usb_rpmsg_cmd *)usb_resp;
	t_data->cmd = notify->cmd;
	if(has_param){
		memcpy(t_data->param, notify->param, strlen(notify->param));
	}
	printk("---usb_rpmsg_notify_ap, datalen:%d\n", strlen(usb_resp));
	return usb_rpmsg2ap(usb_resp, strlen(usb_resp));
}
EXPORT_SYMBOL_GPL(usb_rpmsg_notify_ap);

int usb_plug_notify_ap(e_usb_rpmsg_cmd_type plug_type)
{
	usb_rpmsg_cmd notify; 
	memset(&notify, 0, sizeof(notify));
	notify.cmd = plug_type;
	printk("----usb_plug_notify_ap, type:%d\n", plug_type);
	return usb_rpmsg_notify_ap(&notify, 0);
}
EXPORT_SYMBOL_GPL(usb_plug_notify_ap);

int usb_dispatch_cmd(char * buf, int len)
{
	int ret = 0;
	memset(usb_resp, 0, USB_AGENT_BUF_SIZE);
	wmb();
	usb_rpmsg_cmd *resp = (usb_rpmsg_cmd *)usb_resp;

			//printk("usb_dispatch_cmd, len:%d\n", len);

	usb_rpmsg_cmd *t_cmd = (usb_rpmsg_cmd *)buf;
	if(t_cmd->cmd < USB_RPMSG_CMD || t_cmd->cmd >= USB_RPMSG_CMD_MAX){
		printk("usb_dispatch_cmd, invalid cmd\n");
		return -1;
	}
	
#if 1
	//usb_set_rpmsg_resp(t_cmd->cmd, usb_resp);
	android_set_rpmsg_resp(t_cmd->cmd, usb_resp);
#else

	switch(t_cmd->cmd){
		case USB_RPMSG_GET_NET_TYPE:
		case USB_RPMSG_GET_USB_SPEED:
		case USB_RPMSG_GET_USB_STATE:
		case USB_RPMSG_GET_USB_LINK_STATE:
			usb_set_rpmsg_resp(t_cmd->cmd, usb_resp);
		//case:
			break;
		default:
			break;
	}
#endif
	
	return usb_rpmsg2ap(usb_resp, 4+strlen(resp->param));	
}


void usb_rpmsg_from_ap(void *buf, unsigned int len)
{
	int i;
	unsigned char *data;
	
	char*tmp= (char*)buf;
	usb_rpmsg_cmd *msg = NULL; 

	if (len==0){
		printk("usb_rpmsg_from_ap, len 0, notify \n ", len);
		atomic_set(&write_busy, 0);
		wake_up(&usb_write_wq);
		return ;
	}
	//printk("usb_rpmsg_from_ap, len %d, \n ", len);
#if 0
	if(len < 32){
		printk(" adb_recv_from_ap, send to usb start:\n");
		for(i = 0; i < len; i++){
			printk(" %x", tmp[i]);
			if((i != 0) &&(i % 16) == 0)
				printk("\n");
		}
		printk("\n adb_recv_from_ap, send to usb end\n");
	}
#endif
	memcpy(usb_msg,buf, len);
	//usb_rpmsg2ap((char *)buf, len);
	msg = (usb_rpmsg_cmd *)usb_msg;
	if(msg->cmd > USB_RPMSG_CMD_MAX){
		usb_parse_cap_notify(msg->cmd);
		return;
	}
	atomic_set(&rpmsg_flag, 1);
	wake_up(&usb_agt_wq);
} 


int usb_rpmsg2ap(void *buf, unsigned int len)
{
	int ret = 0;
	int i;
	T_ZDrvRpMsg_Msg rpmsg;
	char *tmp = (char *)buf;
	
	int transfer_cnt, total_cnt; 
	
	
	rpmsg.actorID =  CAP_ID;
	rpmsg.chID = USB_RPMSG_CH;	
	rpmsg.flag |= 1;
	
	printk("usb_rpmsg2ap datalen:%d\n",  len);
#if 0
	if(len && len < 32){
		printk(" data from usb, send to cap start:\n");
		for(i = 0; i < len; i++){
			printk(" %x", tmp[i]);
			if((i != 0) &&(i % 16) == 0)
				printk("\n");
		}
		printk("\n data from usb, send to cap end\n");
	}
#endif	
	if(len == 0){//just send notify
		rpmsg.len = len;
		ret = zDrvRpMsg_Write_Cap(&rpmsg);
		if(ret < 0)
			printk("usb_rpmsg2ap notify send fail, ret:%d\n", ret);	
		return ret;
	}
	total_cnt = len;
#if 1	
		rpmsg.len = len;
		rpmsg.buf = usb_resp;
		
		ret = zDrvRpMsg_Write_Cap(&rpmsg);
		if(rpmsg.len != ret){
			atomic_set(&write_busy, 0);
			printk("[usb_rpmsg2ap] msg send error:(%d)", ret);
			return ret;
		}		
#else
	while(total_cnt){
		transfer_cnt = total_cnt > USB_AGENT_BUF_SIZE ? USB_AGENT_BUF_SIZE: total_cnt;
		memcpy(usb_resp, tmp, transfer_cnt);
		rpmsg.len = transfer_cnt;
		rpmsg.buf = usb_resp;
		
		ret = zDrvRpMsg_Write_Cap(&rpmsg);
		if(rpmsg.len != ret){
			atomic_set(&write_busy, 0);
			printk("[usb_rpmsg2ap] msg send error:(%d)", ret);
			return ret;
		}
		//should wait for ap recv ok
			printk("usb_rpmsg2ap, brfore agt_write_wq len:%d, write_busy:%d\n",  transfer_cnt, atomic_read(&write_busy));
		ret = wait_event_interruptible(usb_write_wq, !atomic_read(&write_busy));
		printk("usb_rpmsg2ap, after agt_write_wq len:%d, write_busy:%d\n",  transfer_cnt, atomic_read(&write_busy));

		if (ret < 0) {
			break;
		}
		total_cnt -= transfer_cnt;
		tmp += transfer_cnt;
		
	}
#endif	
	atomic_set(&write_busy, 0);
	
	return 0;  
}


void usb_rpmsg_thread(void *ptr)
{

	unsigned long			flags;
	
	int r , xfer;
	int ret = 0;
	r = xfer = 0;
	usb_rpmsg_cmd *t_cmd = NULL;
	
	while(!kthread_should_stop()){	
		/* we will block until we're online */
		
		//printk("usb_rpmsg_thread: waiting foragt_start_wait\n");
		ret = wait_event_interruptible(usb_agt_wq,
				(atomic_read(&rpmsg_flag) ||kthread_should_stop()));
		if (ret < 0) {
			//adb_unlock(&dev->read_excl);
			return ret;
		}
			
		
		atomic_set(&rpmsg_flag, 0);
		if(kthread_should_stop())
		{
			printk("unbind thread stop");
			break;
		}
		
		//printk("usb_rpmsg_thread: now usb_dispatch_cmd\n");

		t_cmd = (usb_rpmsg_cmd *)usb_msg;
		//android_set_rpmsg_resp(t_cmd->cmd, usb_resp);
		usb_dispatch_cmd(usb_msg, 4+ strlen(t_cmd->param));
	}
}



int usb_server_init(void)
{
	int ret = 0;
	
	atomic_set(&rpmsg_flag, 0);
	atomic_set(&write_busy, 0);
	init_waitqueue_head(&usb_agt_wq);
	
	/* create channel */
	if(zDrvRpMsg_CreateChannel_Cap(CAP_ID, USB_RPMSG_CH,USB_AGENT_BUF_SIZE))
	{
		printk("[usb_server_init] Failed create psm icp channel ! \n");
		BUG();
	}
	
	//printk("[usb_server_init] Success create psm icp channel!!! \n");
	zDrvRpMsg_RegCallBack_Cap(CAP_ID, USB_RPMSG_CH, usb_rpmsg_from_ap);
	
	rpmsg_thread = kthread_run(usb_rpmsg_thread, NULL, "usb_rpmsg_thread");
	BUG_ON(IS_ERR(rpmsg_thread));
#if 0	
	dev->agent_monitor_thread = kthread_run(adb_agent_monitor_thread, (unsigned long)dev+1, "adb_agent_monitor");
	BUG_ON(IS_ERR(dev->agent_monitor_thread));
#endif	
	memset(usb_msg, 0, USB_AGENT_BUF_SIZE);
}
EXPORT_SYMBOL_GPL(usb_server_init);

