/*
|| sanchips corp add:20130819@zhouqiansheng  for usb proxy
     Refer to the scheme of usb division flow,
     we are supposed to add a new usb proxy module instead of adb driver.
*/
#include <linux/module.h>
#include <linux/init.h>
#include <linux/wait.h>
#include <linux/err.h>
#include <linux/slab.h>
#include <linux/types.h>

#include <linux/ioctl.h>
#include <linux/fs.h>
#include <linux/device.h>


#include "usb_proxy_icp.h"
#include "usb_proxy_main.h"


struct usbproxy_request* usbproxy_alloc_request(gfp_t gfp_flags)
{
	struct usbproxy_request *req;

	req = kzalloc(sizeof(*req), gfp_flags);
	if (!req)
		return NULL;

	return req;
}
EXPORT_SYMBOL(usbproxy_alloc_request);

void usbproxy_free_request(struct usbproxy_request *req)
{
    kfree(req);
}
EXPORT_SYMBOL(usbproxy_free_request);

int usbproxy_write(struct usbproxy_request *req)
{
    void *destbuf = NULL;
    int ret = 0;
    
    destbuf = usbproxy_sharemem_get( USBPROXY_TYPE_WRITE );
    if( destbuf == NULL )
    {
        PROXY_ERR("[usbproxy] get write sharemem fail!\n");

        return -1;
    }

    ret = usbproxy_sharemem_write(destbuf, req ->buf, req ->length);

    if(ret < 0)
    {
        PROXY_ERR("[usbproxy] write sharemem fail!\n");
        usbproxy_sharemem_put( destbuf );
        return -1;
    }

    req ->actual += ret;
    
    usbproxy_sharemem_put( destbuf );

    if( ret != req ->length )
    {
        PROXY_ERR("[usbproxy] warning! read data lost want[%d] actual[%d]\n", 
                    req ->length, ret );
    }

    req ->complete(req);

    return ret;
}
EXPORT_SYMBOL(usbproxy_write);

int usbproxy_read(struct usbproxy_request *req)
{
    void *src_buf = NULL;
    int ret = 0;
    
    src_buf = usbproxy_sharemem_get( USBPROXY_TYPE_READ );
    if( src_buf == NULL )
    {
        PROXY_ERR("[usbproxy] get read sharemem fail!\n");
        return -1;
    }
    ret = usbproxy_sharemem_read(req ->buf, src_buf, req ->length);
    if(ret < 0)
    {
        PROXY_ERR("[usbproxy] read sharemem fail!\n");
        usbproxy_sharemem_put( src_buf );
        return -1;
    }

    req ->actual += ret;
    
    usbproxy_sharemem_put( src_buf );
    
    if( ret != req ->length )
    {
        PROXY_ERR("[usbproxy] warning! read data want[%d] actual[%d]\n", 
                    req ->length, ret );
    }

    req ->complete(req);
    return ret;
}
EXPORT_SYMBOL(usbproxy_read);

/*
static void usb_proxy_init(void)
{
    
}


static void usb_proxy_exit(void)
{

}*/

extern void adb_proxy_init(void);

static int __init init(void)
{
    usbproxy_sharemem_init();

    /*adb_proxy_init();*/
    
	return 0;	
}
module_init(init);

static void __exit cleanup(void)
{
    return;
}
module_exit(cleanup);

