/*
 * linux/ipc/cross_msg.h
 * Copyright (C) 2023 Sanechips Technology Co., Ltd.
 */
#ifndef _CROSS_MSG_H
#define _CROSS_MSG_H

#ifdef CONFIG_SYSVIPC_CROSSMSG
#include <linux/soc/zte/rpm/rpmsg.h>

#define CROSS_MSG_ACT		CAP_ID
#define CROSS_MSG_CHN		13
#define CROSS_MSG_CHN_CAP	14
#define CROSS_MSG_SIZE		((size_t)0x1000)
#define CROSS_MSG_NUM		(4)
#define CROSS_CHN_SIZE		((size_t)CROSS_MSG_SIZE * CROSS_MSG_NUM)
#define CROSS_PRINT			"[MESSAGE QUEUE] "
#define CROSS_DEBUG			0

#define CROSS_MSG_HEAD		0xABBA
#define CROSS_MSG_MASK		0xFFFF0000
#define CROSS_REMOTE_MASK	0x80000000

enum msg_function {
	MSGGET_F = 0xAA,
	MSGCTL_F = 0xBB,
	MSGSND_F = 0xCC,
	MSGRCV_F = 0xDD
};

struct msgget_para {
	key_t key;
	int msgflg;
};

struct msgctl_para {
	struct msgget_para getp;
	int cmd;
};

struct msgsnd_para {
	struct msgget_para getp;
	int msgflg;
	size_t msgsz;
};

typedef struct msg_para {
	unsigned short head;
	unsigned short ops;
	union {
		struct msgctl_para ctlp;
		struct msgsnd_para sndp;
		struct {
			int ret;
			int merrno;
		};
	};
} T_sc_msg_header;

#endif
#endif // _CROSS_MSG_H

