/*
 * Common module linker script, always used when linking a module.
 * Archs are free to supply their own linker scripts.  ld will
 * combine them automatically.
 */
SECTIONS {
	/DISCARD/ : { *(.discard) }

  .text 0: {
    cpko_text_start = .;
	/* 1   as_gsm */
	/* 1.1 com    */
	*(.ps_2g_func)
	__gsm_modem_section_end = .;
	*ctypes.o(.text)
	*ms.o(.text)
	*ms_decode_freq.o(.text)
	*ms_hwtrc.o(.text)
	*ms_inspect.o(.text)
	*ms_interface.o(.text)
	*ms_msg_gprs_cnt.o(.text)
	*ms_msg_ll_sn.o(.text)
	*ms_msg_sn_ir.o(.text)
	*ms_os_pool.o(.text)
	*ms_radioblock.o(.text)
	*sctpred.o(.text)
	*zps_gas_sigtrace.o(.text)
	*zps_gsm_com.o(.text)
	*zps_pack_common.o(.text)
	*zps_pack_gmac.o(.text)
	*zps_pack_grlc.o(.text)
	*zps_pack_grr.o(.text)
	*zps_pack_lapdm.o(.text)
	*zps_pack_llc.o(.text)
	*zps_pack_rr.o(.text)
	*zps_pack_sndcp.o(.text)
	/* 1.2 gmac   */
	*mac.o(.text)
	*mac_ap.o(.text)
	*mac_am.o(.text)
	*mac_com.o(.text)
	*mac_drop.o(.text)
	*mac_free.o(.text)
	*mac_create_message.o(.text)
	*mac_pdlan.o(.text)
	*mac_control_queue.o(.text)
	*mac_debug_decoders.o(.text)
	*mac_decoders.o(.text)
	*mac_dt.o(.text)
	*mac_edt.o(.text)
	*mac_im.o(.text)
	*mac_polling_callback_functions.o(.text)
	*mac_polling_queue.o(.text)
	*zps_gmac_psho.o(.text)
	*mac_sm.o(.text)
	*mac_tm.o(.text)
	*mac_ut.o(.text)
	/* 1.3 grlc
	*rlc.o(.text)
	*rlc_atc.o(.text)
	*rlc_downlink_object.o(.text)
	*rlc_downlink_tbf_param.o(.text)
	*rlc_downlink_transfer.o(.text)
	*rlc_op1.o(.text)
	*rlc_op1e.o(.text)
	*rlc_op2.o(.text)
	*rlc_op3.o(.text)
	*rlc_op4.o(.text)
	*rlc_op5.o(.text)
	*rlc_uplink_object.o(.text)
	*zps_grlc_psho.o(.text) */
	/* 1.4 grr */
	*grr_1.o(.text)
	*grr_2.o(.text)
	*grr_dtm_op1.o(.text)
	*grr_ir_op1.o(.text)
	*grr_op1.o(.text)
	*grr_op2.o(.text)
	*grr_op3.o(.text)
	*grr_op4.o(.text)
	*grr_op5.o(.text)
	*grr_op6.o(.text)
	*grr_op7.o(.text)
	*grr_op8.o(.text)
	*grr_op9.o(.text)
	*grr_op18.o(.text)
	/* 1.5 gsma */
	*zps_gsma_com.o(.text)
	*zps_gsma_grrgrrc.o(.text)
	*zps_gsma_main.o(.text)
	*zps_gsma_uplane.o(.text)
	*zps_gsma_urrcnas.o(.text)
	/* 1.6 rrc */
	*rrc.o(.text)
	*rrc_dtm_op1.o(.text)
	*rrc_ir_op1.o(.text)
	*rrc_op1.o(.text)
	*rrc_op2.o(.text)
	*rrc_op3.o(.text)
	*rrc_op4.o(.text)
	*rrc_op5.o(.text)
	/* 1.7 lapdm */
	*dll.o(.text)
	*dll_op1.o(.text)
	*l2.o(.text)
	*zps_lapdm_common.o(.text)
	/* 1.8 llc */
	*llc.o(.text)
	*llc_ack.o(.text)
	*llc_glob.o(.text)
	*llc_if_hw.o(.text)
	*llc_if_rlc.o(.text)
	*llc_uack.o(.text)
	*llc_xid.o(.text)
	*lle_op2.o(.text)
	/* 1.9 rrop */
	*rr_ir_op1.o(.text)
	*rr_op1.o(.text)
	*rr_op2.o(.text)
	*rr_op3.o(.text)
	*rr_op4.o(.text)
	*rr_op5.o(.text)
	/* 1.10 sndcp */
	*rfc1144.o(.text)
	*snp.o(.text)
	*snp_ack_d.o(.text)
	*snp_ack_u.o(.text)
	*snp_com.o(.text)
	*snp_dc.o(.text)
	*snp_gc.o(.text)
	*snp_glob.o(.text)
	*snp_hc.o(.text)
	*snp_msg.o(.text)
	*snp_opl.o(.text)
	*snp_opl_dc.o(.text)
	*snp_opl_hc.o(.text)
	*snp_opp.o(.text)
	*snp_pc.o(.text)
	*snp_uack_d.o(.text)
	*snp_uack_u.o(.text)
	*snp_xc.o(.text)
	*snp_xid.o(.text)

	/* 2   as_utran */	
	. = ALIGN(4096);
	__utran_modem_text_start = .;
	*(.ps_3g_func)
	__utran_modem_section_end = .;
	/* 2.1   ul1t */
	/* 2.1.1 l1t  */
	*zps_l1t_camp.o(.text)
	*zps_l1t_fach.o(.text)
	*zps_l1t_hsupa.o(.text)
	*zps_l1t_l1u_com.o(.text)
	*zps_l1t_l1u_irat_misc.o(.text)
	*zps_l1t_l1ud_meas.o(.text)
	*zps_l1t_meas.o(.text)
	*zps_l1t_meas_gap.o(.text)
	*zps_l1t_meas_gsm.o(.text)
	*zps_l1t_meas_lte.o(.text)
	*zps_l1t_meas_tstamp.o(.text)
	*zps_l1t_meas_w.o(.text)
	*zps_l1t_pub.o(.text)
	*zps_l1tl_dpch.o(.text)
	*zps_l1tl_hsdpa.o(.text)
	*zps_l1tl_pch.o(.text)
	/* 2.2   ul2_up */
	/* 2.2.1 u_mac  */
	*umacc.o(.text)
	*umaccallback.o(.text)
	*umacdl.o(.text)
	*umacedcp.o(.text)
	*umacehs.o(.text)
	*umachsdpa.o(.text)
	*umachsupa.o(.text)
	*umaci.o(.text)
	*umacmcr.o(.text)
	*umactimer.o(.text)
	*umacul.o(.text)
	/* 2.2.2 u_rlc  */
	*zps_urlc_buffer.o(.text)
	*zps_urlc_cipher.o(.text)
	*zps_urlc_com.o(.text)
	*zps_urlc_csoverpa_buf.o(.text)
	*zps_urlc_dl.o(.text)
	*zps_urlc_dl_cfg.o(.text)
	*zps_urlc_dl_ctrlpdu.o(.text)
	*zps_urlc_dl_edcp.o(.text)
	*zps_urlc_dl_pdu.o(.text)
	*zps_urlc_dl_sdu.o(.text)
	*zps_urlc_main.o(.text)
	*zps_urlc_timer.o(.text)
	*zps_urlc_trace.o(.text)
	*zps_urlc_ul.o(.text)
	*zps_urlc_ul_cfg.o(.text)
	*zps_urlc_ul_ctrlpdu.o(.text)
	*zps_urlc_ul_edcp.o(.text)
	*zps_urlc_ul_pdu.o(.text)
	*zps_urlc_ul_sdu.o(.text)
	/* 2.3   urrc */
	/* 2.3.1 u_cer  */
	*urrc_cer_accesscontrol.o(.text)
	*urrc_cer_commonfunc.o(.text)
	*urrc_cer_connstateproc.o(.text)
	*urrc_cer_etwsproc.o(.text)
	*urrc_cer_fdduecapabilityproc.o(.text)
	*urrc_cer_interfacefunc.o(.text)
	*urrc_cer_linktable.o(.text)
	*urrc_cer_mainctrl.o(.text)
	*urrc_cer_pubuecapabilityproc.o(.text)
	*urrc_cer_rrcconnrel.o(.text)
	*urrc_cer_rrcconnsetup.o(.text)
	*urrc_cer_sec_cc.o(.text)
	*urrc_cer_sec_ciph.o(.text)
	*urrc_cer_sec_f9.o(.text)
	*urrc_cer_sec_ip.o(.text)
	*urrc_cer_sec_pub.o(.text)
	*urrc_cer_sec_res.o(.text)
	*urrc_cer_sec_smc.o(.text)
	*urrc_cer_sec_start.o(.text)
	*urrc_cer_tdduecapabilityproc.o(.text)
	/* 2.3.2 u_cmr  */
	*urrc_cmr_fun.o(.text)
	/* 2.3.3 u_csr  */
	*urrc_csr_entry.o(.text)
	*urrc_csr_externfunc.o(.text)
	*urrc_csr_pubfunc.o(.text)
	*urrc_csr_pubproc.o(.text)
	*urrc_csr_sendmsgfunc.o(.text)
	*urrc_csr_start.o(.text)
	*urrc_csr_storemng.o(.text)
	*urrc_csr_waitbchopen.o(.text)
	*urrc_csr_waitcellsearch.o(.text)
	*urrc_csr_waitgetrf.o(.text)
	*urrc_csr_waitinactive.o(.text)
	*urrc_csr_waitiratcamp.o(.text)
	*urrc_csr_waitiratcco.o(.text)
	*urrc_csr_waitiratho.o(.text)
	*urrc_csr_waitl1rel.o(.text)
	*urrc_csr_waitl1rsrc.o(.text)
	*urrc_csr_waitrbcho.o(.text)
	*urrc_csr_waitrsrcfree.o(.text)
	*urrc_csr_waitscanrssi.o(.text)
	*urrc_csr_waitumacind.o(.text)
	/* 2.3.4 u_mcr  */
	*umac_mcr_delmeas.o(.text)
	*umac_mcr_distribute.o(.text)
	*umac_mcr_evaluate.o(.text)
	*umac_mcr_main.o(.text)
	*umac_mcr_measrepind.o(.text)
	*umac_mcr_rrcmsg.o(.text)
	*umac_mcr_timer_expiry.o(.text)
	*umac_mcr_unite.o(.text)
	*urrc_mcr_cellreselect.o(.text)
	*urrc_mcr_cellreselect_r8later.o(.text)
	*urrc_mcr_common.o(.text)
	*urrc_mcr_delmeas.o(.text)
	*urrc_mcr_distribute.o(.text)
	*urrc_mcr_evaluate.o(.text)
	*urrc_mcr_gapcfg.o(.text)
	*urrc_mcr_main.o(.text)
	*urrc_mcr_mainstates.o(.text)
	*urrc_mcr_mc_proc.o(.text)
	*urrc_mcr_mcunite.o(.text)
	*urrc_mcr_measreport.o(.text)
	*urrc_mcr_measrst.o(.text)
	*urrc_mcr_outputlog.o(.text)
	*urrc_mcr_read_sib11.o(.text)
	*urrc_mcr_read_sib12.o(.text)
	*urrc_mcr_read_sib18.o(.text)
	*urrc_mcr_read_sib19.o(.text)
	*urrc_mcr_startmeas.o(.text)
	*urrc_mcr_storemacmc.o(.text)
	*urrc_mcr_sysinfo_change.o(.text)
	*urrc_mcr_tdd_read_sib11.o(.text)
	*urrc_mcr_timer_expiry.o(.text)
	/* 2.3.5 u_mtc  */
	*urrc_mtc_func.o(.text)
	*urrc_mtc_init.o(.text)
	*utran_data_convert_main.o(.text)
	/* 2.3.6 u_rbc  */
	*urrc_rbc_build_rlc_cfg.o(.text)
	*urrc_rbc_cell_change_order.o(.text)
	*urrc_rbc_cfg_efach.o(.text)
	*urrc_rbc_cfg_fach.o(.text)
	*urrc_rbc_cfg_pch.o(.text)
	*urrc_rbc_cfg_prach_sccpch_state.o(.text)
	*urrc_rbc_common.o(.text)
	*urrc_rbc_db_function.o(.text)
	*urrc_rbc_db_rb_function.o(.text)
	*urrc_rbc_db_trch_function.o(.text)
	*urrc_rbc_dch_cfg.o(.text)
	*urrc_rbc_default_cfg.o(.text)
	*urrc_rbc_fach_multiplexing_option_select.o(.text)
	*urrc_rbc_fdd_build_mac_cfg.o(.text)
	*urrc_rbc_fdd_build_phy_cfg.o(.text)
	*urrc_rbc_fdd_cfg_cbs.o(.text)
	*urrc_rbc_fdd_cfg_efach.o(.text)
	*urrc_rbc_fdd_cfg_fach.o(.text)
	*urrc_rbc_fdd_cfg_pch.o(.text)
	*urrc_rbc_fdd_common.o(.text)
	*urrc_rbc_fdd_db_phy_function.o(.text)
	*urrc_rbc_fdd_dch_cfg.o(.text)
	*urrc_rbc_fdd_ie_store_phy.o(.text)
	*urrc_rbc_fdd_rb_control.o(.text)
	*urrc_rbc_fdd_rb_control_store_res.o(.text)
	*urrc_rbc_ho_from_utran.o(.text)
	*urrc_rbc_ho_to_utran.o(.text)
	*urrc_rbc_ie_operation.o(.text)
	*urrc_rbc_ie_store_rb.o(.text)
	*urrc_rbc_ie_store_trch.o(.text)
	*urrc_rbc_initial_state.o(.text)
	*urrc_rbc_main.o(.text)
	*urrc_rbc_msg_ie_map.o(.text)
	*urrc_rbc_rb_control.o(.text)
	*urrc_rbc_tdd_build_mac_cfg.o(.text)
	*urrc_rbc_tdd_build_phy_cfg.o(.text)
	*urrc_rbc_tdd_cfg_cbs.o(.text)
	*urrc_rbc_tdd_cfg_efach.o(.text)
	*urrc_rbc_tdd_cfg_fach.o(.text)
	*urrc_rbc_tdd_cfg_pch.o(.text)
	*urrc_rbc_tdd_common.o(.text)
	*urrc_rbc_tdd_db_phy_function.o(.text)
	*urrc_rbc_tdd_dch_cfg.o(.text)
	*urrc_rbc_tdd_ie_store_phy.o(.text)
	*urrc_rbc_tdd_rb_control.o(.text)
	*urrc_rbc_tdd_rb_control_store_res.o(.text)
	*urrc_rbc_validity_check_main.o(.text)
	*urrc_rbc_validity_check_phych_ie.o(.text)
	*urrc_rbc_validity_check_rb_ie.o(.text)
	*urrc_rbc_validity_check_trch_ie.o(.text)
	*urrc_rbc_validity_check_ue_capability.o(.text)
	*urrc_rbc_wait_cmr_ack_state.o(.text)
	*urrc_rbc_wait_csr_ack_state.o(.text)
	*urrc_rbc_wait_cu_in_cfg_rlc_ack_state.o(.text)
	*urrc_rbc_wait_l2_phy_cfg_state.o(.text)
	*urrc_rbc_wait_mac_act_ind_state.o(.text)
	*urrc_rbc_wait_pdcp_reloc_cnf_state.o(.text)
	*urrc_rbc_wait_rlc_ack_state.o(.text)
	/* 2.3.7 u_sir  */
	*urrc_sir_bchdata.o(.text)
	*urrc_sir_bchproc.o(.text)
	*urrc_sir_db.o(.text)
	*urrc_sir_hipricellsel_master.o(.text)
	*urrc_sir_hipricellsel_pub.o(.text)
	*urrc_sir_hipricellsel_slave.o(.text)
	*urrc_sir_int.o(.text)
	*urrc_sir_main.o(.text)
	*urrc_sir_msghdl.o(.text)
	*urrc_sir_ncellsel.o(.text)
	*urrc_sir_plmnlist_master.o(.text)
	*urrc_sir_plmnlist_pub.o(.text)
	*urrc_sir_plmnlist_slave.o(.text)
	*urrc_sir_pub.o(.text)
	*urrc_sir_readcgi.o(.text)
	*urrc_sir_readncell.o(.text)
	*urrc_sir_readpredefconf.o(.text)
	*urrc_sir_scellupdate.o(.text)
	*urrc_sir_send.o(.text)
	*urrc_sir_sibhdl.o(.text)
	*urrc_sir_sicontainer.o(.text)
	/* 2.4   wl1w */
	/* 2.4.1 l1w  */
	*l1w_camp.o(.text)
	*l1w_fach.o(.text)
	*l1w_hsupa.o(.text)
	*l1w_meas.o(.text)
	*l1w_meas_gap.o(.text)
	*l1w_meas_gsm.o(.text)
	*l1w_meas_lte.o(.text)
	*l1w_meas_td.o(.text)
	*l1w_meas_tstamp.o(.text)
	*l1w_pub.o(.text)
	*l1wl_dpch.o(.text)
	*l1wl_hsdpa.o(.text)
	*l1wl_pch.o(.text)
	/* 2.5   wl2_up */
	/* 2.5.1 w_mac  */
	*wmac_cfg_list.o(.text)
	*wmac_com.o(.text)
	*wmac_dl_func.o(.text)
	*wmac_dl_lcf.o(.text)
	*wmac_dl_tcf.o(.text)
	*wmac_drv_func.o(.text)
	*wmac_dtx_drx_func.o(.text)
	*wmac_l1w_func.o(.text)
	*wmac_meas_func.o(.text)
	*wmac_rach_func.o(.text)
	*wmac_ring.o(.text)
	*wmac_rnti.o(.text)
	*wmac_sci_func.o(.text)
	*wmac_thread.o(.text)
	*wmac_timer.o(.text)
	*wmac_trace.o(.text)
	*wmac_ul_func.o(.text)
	*wmac_ul_lcf.o(.text)
	*wmac_upa_func.o(.text)
	*wmac_upa_grant.o(.text)
	*wmac_upa_harq.o(.text)
	*wmac_wrrc_func.o(.text)
	*wmacdl.o(.text)
	*wmacdpa.o(.text)
	*wmacedcp.o(.text)
	*wmacpowctrl.o(.text)
	*wmactfcsel.o(.text)
	*wmacul.o(.text)
	*wmacupaetfcres.o(.text)
	*wmacupaetfcsel.o(.text)
	*wmacupasi.o(.text)
	/* 2.5.2 w_rlc  */
	*wrlc_buffer.o(.text)
	*wrlc_cipher.o(.text)
	*wrlc_com.o(.text)
	*wrlc_csoverpa_buf.o(.text)
	*wrlc_discard_time.o(.text)
	*wrlc_dl.o(.text)
	*wrlc_dl_cfg.o(.text)
	*wrlc_dl_ctrlpdu.o(.text)
	*wrlc_dl_edcp.o(.text)
	*wrlc_dl_pdu.o(.text)
	*wrlc_dl_sdu.o(.text)
	*wrlc_log.o(.text)
	*wrlc_main.o(.text)
	*wrlc_timer.o(.text)
	*wrlc_trace.o(.text)
	*wrlc_ul.o(.text)
	*wrlc_ul_cfg.o(.text)
	*wrlc_ul_ctrlpdu.o(.text)
	*wrlc_ul_edcp.o(.text)
	*wrlc_ul_pdcp_sdu_proc.o(.text)
	*wrlc_ul_pdu.o(.text)
	*wrlc_ul_rrc_sdu_proc.o(.text)
	*wrlc_ul_sdu.o(.text)
	
	/* 3   as_lte */			
	. = ALIGN(4096);
	__lte_modem_text_start = .;
	/* 3.1    el2_up */
	/* 3.1.1  el2_com */
	*(.ps_4g_func)
	__lte_modem_section_end = .;
	*aes.o(.text)
	*f8.o(.text)
	*f9.o(.text)
	*lte_l2_logoutput.o(.text)
	*lte_l2_roadtest.o(.text)
	*lte_userplane_hw_int.o(.text)
	*lte_userplane_main.o(.text)
	*snow3g.o(.text)
	*zuc.o(.text)
	/* 3.1.2  eu_mac */
	*eumac_com.o(.text)
	*eumac_ephy_func.o(.text)
	*eumac_eurrc_func.o(.text)
	*eumacdl_func.o(.text)
	*eumacul_config_func.o(.text)
	*eumacul_func.o(.text)
	*eumacul_ra_func.o(.text)
	*eumacul_timer_func.o(.text)
	/* 3.1.3  eu_pdcp */
	*epdcp.o(.text)
	*epdcp_cipher_integrity.o(.text)
	*epdcp_downlink_process.o(.text)
	*epdcp_func.o(.text)
	*epdcp_loop_test.o(.text)
	*epdcp_mem_pool.o(.text)
	*epdcp_process_msg.o(.text)
	*epdcp_rb_config.o(.text)
	*epdcp_reestablish.o(.text)
	*epdcp_table.o(.text)
	*epdcp_uplink_process.o(.text)
	/* 3.1.4  eu_rlc */
	*eurlc_func.o(.text)
	*eurlc_pool.o(.text)
	*eurlcdl.o(.text)
	*eurlcdl_config.o(.text)
	*eurlcdl_process_data.o(.text)
	*eurlcdl_reestablish.o(.text)
	*eurlcdl_timer.o(.text)
	*eurlcul.o(.text)
	*eurlcul_config.o(.text)
	*eurlcul_process_data.o(.text)
	*eurlcul_reestablish.o(.text)
	*eurlcul_timer.o(.text)
	/* 3.1.5  mel2 */
	*mel2_func.o(.text)
	/* 3.2    eudbg */
	*eudbg.o(.text)
	/* 3.3    eurrc */
	/* 3.3.1  eu_asn1 */
	*eperbasiccdec.o(.text)
	*epercdec.o(.text)
	*eperdemain.o(.text)
	*eperenmain.o(.text)
	*eurrccdec_complex.o(.text)
	*eurrccdec_complexmember.o(.text)
	*eurrccdec_defaultvalue.o(.text)
	*eurrccdec_simple.o(.text)
	*eurrccdec0.o(.text)
	*zps_eurrc_asn1_basic.o(.text)
	/* 3.3.2  eu_cer */	
	*eucer.o(.text)
	*eucer_asc_cfg_func.o(.text)
	*eucer_build_peer_msg_func.o(.text)
	*eucer_db_connection_func.o(.text)
	*eucer_db_framework_func.o(.text)
	*eucer_db_mac_func.o(.text)
	*eucer_db_meas_func.o(.text)
	*eucer_db_phy_func.o(.text)
	*eucer_db_rb_func.o(.text)
	*eucer_db_security_func.o(.text)
	*eucer_db_state_func.o(.text)
	*eucer_eucsr_cfg_func.o(.text)
	*eucer_eumac_cfg_func.o(.text)
	*eucer_eumcr_cfg_func.o(.text)
	*eucer_eupdcp_cfg_func.o(.text)
	*eucer_euphy_cfg_func.o(.text)
	*eucer_eurlc_cfg_func.o(.text)
	*eucer_ie_cfg_func.o(.text)
	*eucer_ie_map_func.o(.text)
	*eucer_msg_handling_func.o(.text)
	*eucer_msg_send_func.o(.text)
	*eucer_prds_cco_to_irat.o(.text)
	*eucer_prds_cco_to_lte.o(.text)
	*eucer_prds_config_sublayer.o(.text)
	*eucer_prds_counter_check.o(.text)
	*eucer_prds_dl_info_transfer.o(.text)
	*eucer_prds_ephy_inactive.o(.text)
	*eucer_prds_eurrc_inactive.o(.text)
	*eucer_prds_handover.o(.text)
	*eucer_prds_ho_to_irat.o(.text)
	*eucer_prds_ho_to_lte.o(.text)
	*eucer_prds_leave_conn_for_idle.o(.text)
	*eucer_prds_mbms_func.o(.text)
	*eucer_prds_rrc_conn_est.o(.text)
	*eucer_prds_rrc_conn_reconfig.o(.text)
	*eucer_prds_rrc_conn_reest.o(.text)
	*eucer_prds_rrc_conn_rel.o(.text)
	*eucer_prds_rrc_conn_rel_by_nas.o(.text)
	*eucer_prds_security_mode_cmd.o(.text)
	*eucer_prds_selfHo_func.o(.text)
	*eucer_prds_tgtchcfg_func.o(.text)
	*eucer_prds_ue_cap_enq.o(.text)
	*eucer_prds_ue_info_req.o(.text)
	*eucer_prds_ul_info_transfer.o(.text)
	*eucer_test.o(.text)
	*eucer_timer_handling_func.o(.text)
	/* 3.3.3  eu_csr */	
	*eucsr.o(.text)
	*eucsr_collision_proc.o(.text)
	*eucsr_common_func.o(.text)
	*eucsr_data_typedef.o(.text)
	*eucsr_interface.o(.text)
	*eucsr_msg_handling.o(.text)
	*eucsr_msg_sending.o(.text)
	*eucsr_procedure_func.o(.text)
	*eucsr_tpch_handling_func.o(.text)
	/* 3.3.4  eu_mcr */	
	*eumcr.o(.text)
	*eumcr_cell_fun.o(.text)
	*eumcr_db_fun.o(.text)
	*eumcr_irat_config.o(.text)
	*eumcr_irat_report.o(.text)
	*eumcr_irat_resel.o(.text)
	*eumcr_irat_result.o(.text)
	*eumcr_l1_config.o(.text)
	*eumcr_l1_irat_config.o(.text)
	*eumcr_l1_results.o(.text)
	*eumcr_meas_config.o(.text)
	*eumcr_meas_report.o(.text)
	*eumcr_msg_handling.o(.text)
	*eumcr_resel.o(.text)
	*eumcr_send_msg.o(.text)
	*eumcr_timer_fun.o(.text)
	*eumcr_utils_fun.o(.text)
	/* 3.3.5  eu_mtc */	
	*eurrc.o(.text)
	*eurrc_func.o(.text)
	/* 3.3.6  eu_mtc */	
	*eurrc.o(.text)
	*eurrc_func.o(.text)
	/* 3.3.7  eu_sir */	
	*eusir.o(.text)
	*eusir_interface.o(.text)
	*eusir_sibhdl.o(.text)
	/* 3.4    l1e */
	*l1e.o(.text)
	*l1e_bch.o(.text)
	*l1e_com.o(.text)
	*l1e_csr.o(.text)
	*l1e_gsm_irat_meas.o(.text)
	*l1e_mon.o(.text)
	*l1e_msg_handle.o(.text)
	*l1e_ps_ephy_comm.o(.text)
	*l1e_rach.o(.text)
	*l1e_sup_meas.o(.text)
	*l1e_td_irat_meas.o(.text)
	*l1e_time_func.o(.text)
	*l1e_tstamp.o(.text)
	*l1e_w_irat_meas.o(.text)

	/* 4   as_com */
	. = ALIGN(4096);
	__comm_modem_text_start = .;
	*(.ps_comm_func)
	__comm_modem_section_end = .;
	/* 4.1  com */
	*ascom.o(.text)
	/* 4.2  asc */
	*zps_asc_camplostcov.o(.text)
	*zps_asc_cco.o(.text)
	*zps_asc_com.o(.text)
	*zps_asc_ho.o(.text)
	*zps_asc_hplmn.o(.text)
	*zps_asc_main.o(.text)
	*zps_asc_plmncsg.o(.text)
	*zps_asc_reseldirect.o(.text)
	/* 4.3  asn1 */
	*perbasiccdec.o(.text)
	*percdec.o(.text)
	*perdemain.o(.text)
	*perenmain.o(.text)
	*urrccdec0.o(.text)
	*urrcintchk.o(.text)
	*urrcmsrach.o(.text)
	*urrcsysinfocont.o(.text)
	*zps_urrc_asn1_basic.o(.text)
	*zps_urrc_asn1_complex.o(.text)
	*zps_urrc_asn1_complexmember.o(.text)
	*zps_urrc_asn1_defval.o(.text)
	*zps_urrc_asn1_simple.o(.text)
	/* 4.4  pdcp */
	*zps_updcp_cfg.o(.text)
	*zps_updcp_com.o(.text)
	*zps_updcp_ctrl.o(.text)
	*zps_updcp_dl.o(.text)
	*zps_updcp_dl_buf.o(.text)
	*zps_updcp_hc.o(.text)
	*zps_updcp_rabm.o(.text)
	*zps_updcp_reloc.o(.text)
	*zps_updcp_ul.o(.text)
	/* 4.5  pdi */
	*zps_pdi_looptest.o(.text)
	*zps_pdi_main.o(.text)
	*zps_pdi_sellstat.o(.text)
	/* 4.6  rohc */
	/* 4.6.1  rohcadaptor */
	*zps_rohcadaptor.o(.text)
	/* 4.6.2  rohcv1 */
	*zps_rohcv1_codec.o(.text)
	*zps_rohcv1_common.o(.text)
	*zps_rohcv1_compctrl.o(.text)
	*zps_rohcv1_comppktanalyse.o(.text)
	*zps_rohcv1_crc.o(.text)
	*zps_rohcv1_ctxmng.o(.text)
	*zps_rohcv1_decompctrl.o(.text)
	*zps_rohcv1_encodepkt.o(.text)
	*zps_rohcv1_fdbkmng.o(.text)
	*zps_rohcv1_getpkttype.o(.text)
	*zps_rohcv1_instmng.o(.text)
	*zps_rohcv1_interface.o(.text)
	*zps_rohcv1_orgpktanalyse.o(.text)
	/* 4.6.3  rohcv2 */
	*zps_rohcv2_codec.o(.text)
	*zps_rohcv2_common.o(.text)
	*zps_rohcv2_compctrl.o(.text)
	*zps_rohcv2_comppktanalyse.o(.text)
	*zps_rohcv2_comppktfilter.o(.text)
	*zps_rohcv2_crc.o(.text)
	*zps_rohcv2_ctxmng.o(.text)
	*zps_rohcv2_decidepkttype.o(.text)
	*zps_rohcv2_decompcrcchk.o(.text)
	*zps_rohcv2_decompctrl.o(.text)
	*zps_rohcv2_decompdecode.o(.text)
	*zps_rohcv2_encodepkt.o(.text)
	*zps_rohcv2_fdbkmng.o(.text)
	*zps_rohcv2_instmng.o(.text)
	*zps_rohcv2_interface.o(.text)
	*zps_rohcv2_origpktanalyse.o(.text)
	*zps_rohcv2_recoverorighd.o(.text)
	/* 4.7  sci */
	*zps_sci_codec_ctrl.o(.text)
	*zps_sci_com.o(.text)
	*zps_sci_entity.o(.text)
	*zps_sci_if_7502.o(.text)
	*zps_sci_if_7550.o(.text)
	*zps_sci_if_io_dev.o(.text)
	*zps_sci_main.o(.text)
	*zps_sci_simu_if.o(.text)
	*zps_sci_trace.o(.text)
	/* 5  pscom */
	*hmac_sha.o(.text)
	*pscom.o(.text)
	*psdev.o(.text)
	*psl1com.o(.text)
	*psmsgtrace.o(.text)
	*pstest.o(.text)
	*tdstubforlte.o(.text)
	/* 6  nas */
	/* 6.1  ati */
	*zat_com.o(.text)
	*zat_ext_fnc.o(.text)
	*zat_fnc.o(.text)
	*zat_fnc_sup.o(.text)
	*zat_var.o(.text)
	*zati_cc.o(.text)
	*zati_com.o(.text)
	*zati_csd_fnc.o(.text)
	*zati_distribute_fnc.o(.text)
	*zati_esm.o(.text)
	*zati_fnc.o(.text)
	*zati_func.o(.text)
	*zati_main.o(.text)
	*zati_othr.o(.text)
	*zati_pdi_fnc.o(.text)
	*zati_sm.o(.text)
	*zati_sms.o(.text)
	*zati_ss.o(.text)
	*zati_umm.o(.text)
	/* 6.2  cbs */
	*cbscommfunc.o(.text)
	*cbsmain.o(.text)
	*cbsmanagemidsn.o(.text)
	*cbsmsgfunc.o(.text)
	/* 6.3  cc */
	*cccommonfunc.o(.text)
	*cclowermsgproc.o(.text)
	*ccmain.o(.text)
	*ccpeermsgproc.o(.text)
	*cctimerexpiryproc.o(.text)
	*ccuppermsgproc.o(.text)
	/* 6.4  csn1 */
	*csn1_basic.o(.text)
	*csn1_decoder.o(.text)
	*csn1_encoder.o(.text)
	*csn1_ende1.o(.text)
	*csn1_ende2.o(.text)
	*csn1_ende3.o(.text)
	*csn1_ende4.o(.text)
	*csn1_ende5.o(.text)
	*csn1_ende6.o(.text)
	*csn1_ende7.o(.text)
	*csn1_shared.o(.text)
	*zps_gsm_csn_demain.o(.text)
	*zps_gsm_csn_enmain.o(.text)
	/* 6.5  emm */
	*emm_as.o(.text)
	*emm_attach.o(.text)
	*emm_comproc.o(.text)
	*emm_detach.o(.text)
	*emm_main.o(.text)
	*emm_send.o(.text)
	*emm_tau.o(.text)
	*emm_test.o(.text)
	*emm_upper.o(.text)
	*emm_util.o(.text)
	/* 6.6  esm */
	*esm_common.o(.text)
	*esm_dispatch.o(.text)
	*esm_etft.o(.text)
	*esm_l3_msg_send.o(.text)
	*esm_l3msg_porc.o(.text)
	*esm_msg_send.o(.text)
	*esm_proc_action.o(.text)
	*esm_pub.o(.text)
	*esm_rat.o(.text)
	/* 6.7  gmm */
	*gmmas.o(.text)
	*gmmattachproc.o(.text)
	*gmmcommonproc.o(.text)
	*gmmdetachproc.o(.text)
	*gmmmainproc.o(.text)
	*gmmprocfunc.o(.text)
	*gmmrauproc.o(.text)
	*gmmserviceproc.o(.text)
	*gmmtimer.o(.text)
	*gmmuicc.o(.text)
	/* 6.8  l3cdec */
	*basic.o(.text)
	*berbasiccdec.o(.text)
	*bercdec.o(.text)
	*grrbasic.o(.text)
	*grrcdec.o(.text)
	*grrcdecie.o(.text)
	*grrmsgcodede.o(.text)
	*grrmsgcodeen.o(.text)
	*l3cdec0.o(.text)
	*l3cdec1.o(.text)
	*l3cdec2.o(.text)
	*l3cdec3.o(.text)
	*l3cdecie.o(.text)
	*l3cdecjiang.o(.text)
	*l3csn0.o(.text)
	*l3csnde.o(.text)
	*l3csnen.o(.text)
	*l3msgcodede.o(.text)
	*l3msgcodeen.o(.text)
	*l3rpcodede.o(.text)
	*l3rpcodeen.o(.text)
	*psl3sscdec0.o(.text)
	*psl3sscdec0_dep.o(.text)
	*psl3sscdec0_indep.o(.text)
	*psl3ssde.o(.text)
	*psl3ssen.o(.text)
	/* 6.9  mm */
	*mm_cmproc.o(.text)
	*mm_comnproc.o(.text)
	*mm_mainproc.o(.text)
	*mm_pubfun.o(.text)
	*mm_specproc.o(.text)
	/* 6.10  nascom */
	*nascom.o(.text)
	/* 6.11  smm */
	*smcom.o(.text)
	*smcomproc.o(.text)
	*smctrl.o(.text)
	*smmsgchk.o(.text)
	*smmsgproc.o(.text)
	*smparatrans.o(.text)
	*smsendmsg.o(.text)
	/* 6.12  sms */
	*smscommfunc.o(.text)
	*smsmain.o(.text)
	*smsmsgfunc.o(.text)
	*smsstatefunc.o(.text)
	*smstimerexpiryfunc.o(.text)
	/* 6.13  ss */
	*sscommfunc.o(.text)
	*sslowermsg.o(.text)
	*ssmain.o(.text)
	*sspeermsg.o(.text)
	*ssuppermsg.o(.text)
	/* 6.14  stm */
	*zstm_common.o(.text)
	*zstm_dm_fnc.o(.text)
	*zstm_fnc.o(.text)
	*zstm_pb_fnc.o(.text)
	*zstm_pb_logic.o(.text)
	*zstm_pb3g_fnc.o(.text)
	*zstm_sms_fnc.o(.text)
	*zstm_sms_logic.o(.text)
	/* 6.15  taf */
	*tafctrl.o(.text)
	*tafds.o(.text)
	*tafdta.o(.text)
	*tafint.o(.text)
	*tafl1sim.o(.text)
	*tafl2r.o(.text)
	*tafnurlc.o(.text)
	*tafra.o(.text)
	*tafrlp.o(.text)
	/* 6.16  tc */
	*tc.o(.text)
	*tc_lte.o(.text)
	/* 6.17  tft */
	*tft.o(.text)
	/* 6.18  uicc */
	*uicc_appmngr.o(.text)
	*uicc_cache.o(.text)
	*uicc_cardaccess.o(.text)
	*uicc_cardinit.o(.text)
	*uicc_cardmngr.o(.text)
	*uicc_cardslot.o(.text)
	*uicc_command.o(.text)
	*uicc_commonfunc.o(.text)
	*uicc_devmeth.o(.text)
	*uicc_event.o(.text)
	*uicc_filemeth.o(.text)
	*uicc_isimappmngr.o(.text)
	*uicc_isimfileservice.o(.text)
	*uicc_isiminit.o(.text)
	*uicc_isimsecurity.o(.text)
	*uicc_main.o(.text)
	*uicc_refresh.o(.text)
	*uicc_securitycomm.o(.text)
	*uicc_simappmngr.o(.text)
	*uicc_simfileservice.o(.text)
	*uicc_simsecurity.o(.text)
	*uicc_usat.o(.text)
	*uicc_usimappmngr.o(.text)
	*uicc_usimfileservice.o(.text)
	*uicc_usimsecurity.o(.text)
	*uicc_vcard.o(.text)
	*uicc_vcardauth.o(.text)
	*uicc_vcardrsa.o(.text)
	/* 6.19  uicccdec */
	*basicaction.o(.text)
	*usatbasic.o(.text)
	*usatcdecber.o(.text)
	*usatcdecsimpl.o(.text)
	*usatmsgdecode.o(.text)
	*usatmsgencode.o(.text)
	*usimcdec.o(.text)
	*usimmsgdecode.o(.text)
	*usimmsgencode.o(.text)
	*usimothercdec.o(.text)
	/* 6.20  umm */
	*ummas.o(.text)
	*ummcom.o(.text)
	*ummctrl.o(.text)
	*ummentry.o(.text)
	*ummfun.o(.text)
	*ummplmn.o(.text)
	*ummtimer.o(.text)
	*ummup.o(.text)
	*ummupdate.o(.text)
	/* 6.21  usat */
	*usat_atmain.o(.text)
	*usat_atrecv.o(.text)
	*usat_main.o(.text)
	. = ALIGN(4096);
	modem_text_end = .;
	*(EXCLUDE_FILE(*ctypes.o
	*ms.o
	*ms_decode_freq.o
	*ms_hwtrc.o
	*ms_inspect.o
	*ms_interface.o
	*ms_msg_gprs_cnt.o
	*ms_msg_ll_sn.o
	*ms_msg_sn_ir.o
	*ms_os_pool.o
	*ms_radioblock.o
	*sctpred.o
	*zps_gas_sigtrace.o
	*zps_gsm_com.o
	*zps_pack_common.o
	*zps_pack_gmac.o
	*zps_pack_grlc.o
	*zps_pack_grr.o
	*zps_pack_lapdm.o
	*zps_pack_llc.o
	*zps_pack_rr.o
	*zps_pack_sndcp.o
	/* 1.2 gmac   */
	*mac.o
	*mac_ap.o
	*mac_am.o
	*mac_com.o
	*mac_drop.o
	*mac_free.o
	*mac_create_message.o
	*mac_pdlan.o
	*mac_control_queue.o
	*mac_debug_decoders.o
	*mac_decoders.o
	*mac_dt.o
	*mac_edt.o
	*mac_im.o
	*mac_polling_callback_functions.o
	*mac_polling_queue.o
	*zps_gmac_psho.o
	*mac_sm.o
	*mac_tm.o
	*mac_ut.o
	/* 1.3 grlc
	*rlc.o
	*rlc_atc.o
	*rlc_downlink_object.o
	*rlc_downlink_tbf_param.o
	*rlc_downlink_transfer.o
	*rlc_op1.o
	*rlc_op1e.o
	*rlc_op2.o
	*rlc_op3.o
	*rlc_op4.o
	*rlc_op5.o
	*rlc_uplink_object.o
	*zps_grlc_psho.o */
	/* 1.4 grr */
	*grr_1.o
	*grr_2.o
	*grr_dtm_op1.o
	*grr_ir_op1.o
	*grr_op1.o
	*grr_op2.o
	*grr_op3.o
	*grr_op4.o
	*grr_op5.o
	*grr_op6.o
	*grr_op7.o
	*grr_op8.o
	*grr_op9.o
	*grr_op18.o
	/* 1.5 gsma */
	*zps_gsma_com.o
	*zps_gsma_grrgrrc.o
	*zps_gsma_main.o
	*zps_gsma_uplane.o
	*zps_gsma_urrcnas.o
	/* 1.6 rrc */
	*rrc.o
	*rrc_dtm_op1.o
	*rrc_ir_op1.o
	*rrc_op1.o
	*rrc_op2.o
	*rrc_op3.o
	*rrc_op4.o
	*rrc_op5.o
	/* 1.7 lapdm */
	*dll.o
	*dll_op1.o
	*l2.o
	*zps_lapdm_common.o
	/* 1.8 llc */
	*llc.o
	*llc_ack.o
	*llc_glob.o
	*llc_if_hw.o
	*llc_if_rlc.o
	*llc_uack.o
	*llc_xid.o
	*lle_op2.o
	/* 1.9 rrop */
	*rr_ir_op1.o
	*rr_op1.o
	*rr_op2.o
	*rr_op3.o
	*rr_op4.o
	*rr_op5.o
	/* 1.10 sndcp */
	*rfc1144.o
	*snp.o
	*snp_ack_d.o
	*snp_ack_u.o
	*snp_com.o
	*snp_dc.o
	*snp_gc.o
	*snp_glob.o
	*snp_hc.o
	*snp_msg.o
	*snp_opl.o
	*snp_opl_dc.o
	*snp_opl_hc.o
	*snp_opp.o
	*snp_pc.o
	*snp_uack_d.o
	*snp_uack_u.o
	*snp_xc.o
	*snp_xid.o
	*zps_l1t_camp.o
	*zps_l1t_fach.o
	*zps_l1t_hsupa.o
	*zps_l1t_l1u_com.o
	*zps_l1t_l1u_irat_misc.o
	*zps_l1t_l1ud_meas.o
	*zps_l1t_meas.o
	*zps_l1t_meas_gap.o
	*zps_l1t_meas_gsm.o
	*zps_l1t_meas_lte.o
	*zps_l1t_meas_tstamp.o
	*zps_l1t_meas_w.o
	*zps_l1t_pub.o
	*zps_l1tl_dpch.o
	*zps_l1tl_hsdpa.o
	*zps_l1tl_pch.o
	/* 2.2   ul2_up */
	/* 2.2.1 u_mac  */
	*umacc.o
	*umaccallback.o
	*umacdl.o
	*umacedcp.o
	*umacehs.o
	*umachsdpa.o
	*umachsupa.o
	*umaci.o
	*umacmcr.o
	*umactimer.o
	*umacul.o
	/* 2.2.2 u_rlc  */
	*zps_urlc_buffer.o
	*zps_urlc_cipher.o
	*zps_urlc_com.o
	*zps_urlc_csoverpa_buf.o
	*zps_urlc_dl.o
	*zps_urlc_dl_cfg.o
	*zps_urlc_dl_ctrlpdu.o
	*zps_urlc_dl_edcp.o
	*zps_urlc_dl_pdu.o
	*zps_urlc_dl_sdu.o
	*zps_urlc_main.o
	*zps_urlc_timer.o
	*zps_urlc_trace.o
	*zps_urlc_ul.o
	*zps_urlc_ul_cfg.o
	*zps_urlc_ul_ctrlpdu.o
	*zps_urlc_ul_edcp.o
	*zps_urlc_ul_pdu.o
	*zps_urlc_ul_sdu.o
	/* 2.3   urrc */
	/* 2.3.1 u_cer  */
	*urrc_cer_accesscontrol.o
	*urrc_cer_commonfunc.o
	*urrc_cer_connstateproc.o
	*urrc_cer_etwsproc.o
	*urrc_cer_fdduecapabilityproc.o
	*urrc_cer_interfacefunc.o
	*urrc_cer_linktable.o
	*urrc_cer_mainctrl.o
	*urrc_cer_pubuecapabilityproc.o
	*urrc_cer_rrcconnrel.o
	*urrc_cer_rrcconnsetup.o
	*urrc_cer_sec_cc.o
	*urrc_cer_sec_ciph.o
	*urrc_cer_sec_f9.o
	*urrc_cer_sec_ip.o
	*urrc_cer_sec_pub.o
	*urrc_cer_sec_res.o
	*urrc_cer_sec_smc.o
	*urrc_cer_sec_start.o
	*urrc_cer_tdduecapabilityproc.o
	/* 2.3.2 u_cmr  */
	*urrc_cmr_fun.o
	/* 2.3.3 u_csr  */
	*urrc_csr_entry.o
	*urrc_csr_externfunc.o
	*urrc_csr_pubfunc.o
	*urrc_csr_pubproc.o
	*urrc_csr_sendmsgfunc.o
	*urrc_csr_start.o
	*urrc_csr_storemng.o
	*urrc_csr_waitbchopen.o
	*urrc_csr_waitcellsearch.o
	*urrc_csr_waitgetrf.o
	*urrc_csr_waitinactive.o
	*urrc_csr_waitiratcamp.o
	*urrc_csr_waitiratcco.o
	*urrc_csr_waitiratho.o
	*urrc_csr_waitl1rel.o
	*urrc_csr_waitl1rsrc.o
	*urrc_csr_waitrbcho.o
	*urrc_csr_waitrsrcfree.o
	*urrc_csr_waitscanrssi.o
	*urrc_csr_waitumacind.o
	/* 2.3.4 u_mcr  */
	*umac_mcr_delmeas.o
	*umac_mcr_distribute.o
	*umac_mcr_evaluate.o
	*umac_mcr_main.o
	*umac_mcr_measrepind.o
	*umac_mcr_rrcmsg.o
	*umac_mcr_timer_expiry.o
	*umac_mcr_unite.o
	*urrc_mcr_cellreselect.o
	*urrc_mcr_cellreselect_r8later.o
	*urrc_mcr_common.o
	*urrc_mcr_delmeas.o
	*urrc_mcr_distribute.o
	*urrc_mcr_evaluate.o
	*urrc_mcr_gapcfg.o
	*urrc_mcr_main.o
	*urrc_mcr_mainstates.o
	*urrc_mcr_mc_proc.o
	*urrc_mcr_mcunite.o
	*urrc_mcr_measreport.o
	*urrc_mcr_measrst.o
	*urrc_mcr_outputlog.o
	*urrc_mcr_read_sib11.o
	*urrc_mcr_read_sib12.o
	*urrc_mcr_read_sib18.o
	*urrc_mcr_read_sib19.o
	*urrc_mcr_startmeas.o
	*urrc_mcr_storemacmc.o
	*urrc_mcr_sysinfo_change.o
	*urrc_mcr_tdd_read_sib11.o
	*urrc_mcr_timer_expiry.o
	/* 2.3.5 u_mtc  */
	*urrc_mtc_func.o
	*urrc_mtc_init.o
	*utran_data_convert_main.o
	/* 2.3.6 u_rbc  */
	*urrc_rbc_build_rlc_cfg.o
	*urrc_rbc_cell_change_order.o
	*urrc_rbc_cfg_efach.o
	*urrc_rbc_cfg_fach.o
	*urrc_rbc_cfg_pch.o
	*urrc_rbc_cfg_prach_sccpch_state.o
	*urrc_rbc_common.o
	*urrc_rbc_db_function.o
	*urrc_rbc_db_rb_function.o
	*urrc_rbc_db_trch_function.o
	*urrc_rbc_dch_cfg.o
	*urrc_rbc_default_cfg.o
	*urrc_rbc_fach_multiplexing_option_select.o
	*urrc_rbc_fdd_build_mac_cfg.o
	*urrc_rbc_fdd_build_phy_cfg.o
	*urrc_rbc_fdd_cfg_cbs.o
	*urrc_rbc_fdd_cfg_efach.o
	*urrc_rbc_fdd_cfg_fach.o
	*urrc_rbc_fdd_cfg_pch.o
	*urrc_rbc_fdd_common.o
	*urrc_rbc_fdd_db_phy_function.o
	*urrc_rbc_fdd_dch_cfg.o
	*urrc_rbc_fdd_ie_store_phy.o
	*urrc_rbc_fdd_rb_control.o
	*urrc_rbc_fdd_rb_control_store_res.o
	*urrc_rbc_ho_from_utran.o
	*urrc_rbc_ho_to_utran.o
	*urrc_rbc_ie_operation.o
	*urrc_rbc_ie_store_rb.o
	*urrc_rbc_ie_store_trch.o
	*urrc_rbc_initial_state.o
	*urrc_rbc_main.o
	*urrc_rbc_msg_ie_map.o
	*urrc_rbc_rb_control.o
	*urrc_rbc_tdd_build_mac_cfg.o
	*urrc_rbc_tdd_build_phy_cfg.o
	*urrc_rbc_tdd_cfg_cbs.o
	*urrc_rbc_tdd_cfg_efach.o
	*urrc_rbc_tdd_cfg_fach.o
	*urrc_rbc_tdd_cfg_pch.o
	*urrc_rbc_tdd_common.o
	*urrc_rbc_tdd_db_phy_function.o
	*urrc_rbc_tdd_dch_cfg.o
	*urrc_rbc_tdd_ie_store_phy.o
	*urrc_rbc_tdd_rb_control.o
	*urrc_rbc_tdd_rb_control_store_res.o
	*urrc_rbc_validity_check_main.o
	*urrc_rbc_validity_check_phych_ie.o
	*urrc_rbc_validity_check_rb_ie.o
	*urrc_rbc_validity_check_trch_ie.o
	*urrc_rbc_validity_check_ue_capability.o
	*urrc_rbc_wait_cmr_ack_state.o
	*urrc_rbc_wait_csr_ack_state.o
	*urrc_rbc_wait_cu_in_cfg_rlc_ack_state.o
	*urrc_rbc_wait_l2_phy_cfg_state.o
	*urrc_rbc_wait_mac_act_ind_state.o
	*urrc_rbc_wait_pdcp_reloc_cnf_state.o
	*urrc_rbc_wait_rlc_ack_state.o
	/* 2.3.7 u_sir  */
	*urrc_sir_bchdata.o
	*urrc_sir_bchproc.o
	*urrc_sir_db.o
	*urrc_sir_hipricellsel_master.o
	*urrc_sir_hipricellsel_pub.o
	*urrc_sir_hipricellsel_slave.o
	*urrc_sir_int.o
	*urrc_sir_main.o
	*urrc_sir_msghdl.o
	*urrc_sir_ncellsel.o
	*urrc_sir_plmnlist_master.o
	*urrc_sir_plmnlist_pub.o
	*urrc_sir_plmnlist_slave.o
	*urrc_sir_pub.o
	*urrc_sir_readcgi.o
	*urrc_sir_readncell.o
	*urrc_sir_readpredefconf.o
	*urrc_sir_scellupdate.o
	*urrc_sir_send.o
	*urrc_sir_sibhdl.o
	*urrc_sir_sicontainer.o
	/* 2.4   wl1w */
	/* 2.4.1 l1w  */
	*l1w_camp.o
	*l1w_fach.o
	*l1w_hsupa.o
	*l1w_meas.o
	*l1w_meas_gap.o
	*l1w_meas_gsm.o
	*l1w_meas_lte.o
	*l1w_meas_td.o
	*l1w_meas_tstamp.o
	*l1w_pub.o
	*l1wl_dpch.o
	*l1wl_hsdpa.o
	*l1wl_pch.o
	/* 2.5   wl2_up */
	/* 2.5.1 w_mac  */
	*wmac_cfg_list.o
	*wmac_com.o
	*wmac_dl_func.o
	*wmac_dl_lcf.o
	*wmac_dl_tcf.o
	*wmac_drv_func.o
	*wmac_dtx_drx_func.o
	*wmac_l1w_func.o
	*wmac_meas_func.o
	*wmac_rach_func.o
	*wmac_ring.o
	*wmac_rnti.o
	*wmac_sci_func.o
	*wmac_thread.o
	*wmac_timer.o
	*wmac_trace.o
	*wmac_ul_func.o
	*wmac_ul_lcf.o
	*wmac_upa_func.o
	*wmac_upa_grant.o
	*wmac_upa_harq.o
	*wmac_wrrc_func.o
	*wmacdl.o
	*wmacdpa.o
	*wmacedcp.o
	*wmacpowctrl.o
	*wmactfcsel.o
	*wmacul.o
	*wmacupaetfcres.o
	*wmacupaetfcsel.o
	*wmacupasi.o
	/* 2.5.2 w_rlc  */
	*wrlc_buffer.o
	*wrlc_cipher.o
	*wrlc_com.o
	*wrlc_csoverpa_buf.o
	*wrlc_discard_time.o
	*wrlc_dl.o
	*wrlc_dl_cfg.o
	*wrlc_dl_ctrlpdu.o
	*wrlc_dl_edcp.o
	*wrlc_dl_pdu.o
	*wrlc_dl_sdu.o
	*wrlc_log.o
	*wrlc_main.o
	*wrlc_timer.o
	*wrlc_trace.o
	*wrlc_ul.o
	*wrlc_ul_cfg.o
	*wrlc_ul_ctrlpdu.o
	*wrlc_ul_edcp.o
	*wrlc_ul_pdcp_sdu_proc.o
	*wrlc_ul_pdu.o
	*wrlc_ul_rrc_sdu_proc.o
	*wrlc_ul_sdu.o
	/* 3.1    el2_up */
	/* 3.1.1  el2_com */
	*aes.o
	*f8.o
	*f9.o
	*lte_l2_logoutput.o
	*lte_l2_roadtest.o
	*lte_userplane_hw_int.o
	*lte_userplane_main.o
	*snow3g.o
	*zuc.o
	/* 3.1.2  eu_mac */
	*eumac_com.o
	*eumac_ephy_func.o
	*eumac_eurrc_func.o
	*eumacdl_func.o
	*eumacul_config_func.o
	*eumacul_func.o
	*eumacul_ra_func.o
	*eumacul_timer_func.o
	/* 3.1.3  eu_pdcp */
	*epdcp.o
	*epdcp_cipher_integrity.o
	*epdcp_downlink_process.o
	*epdcp_func.o
	*epdcp_loop_test.o
	*epdcp_mem_pool.o
	*epdcp_process_msg.o
	*epdcp_rb_config.o
	*epdcp_reestablish.o
	*epdcp_table.o
	*epdcp_uplink_process.o
	/* 3.1.4  eu_rlc */
	*eurlc_func.o
	*eurlc_pool.o
	*eurlcdl.o
	*eurlcdl_config.o
	*eurlcdl_process_data.o
	*eurlcdl_reestablish.o
	*eurlcdl_timer.o
	*eurlcul.o
	*eurlcul_config.o
	*eurlcul_process_data.o
	*eurlcul_reestablish.o
	*eurlcul_timer.o
	/* 3.1.5  mel2 */
	*mel2_func.o
	/* 3.2    eudbg */
	*eudbg.o
	/* 3.3    eurrc */
	/* 3.3.1  eu_asn1 */
	*eperbasiccdec.o
	*epercdec.o
	*eperdemain.o
	*eperenmain.o
	*eurrccdec_complex.o
	*eurrccdec_complexmember.o
	*eurrccdec_defaultvalue.o
	*eurrccdec_simple.o
	*eurrccdec0.o
	*zps_eurrc_asn1_basic.o
	/* 3.3.2  eu_cer */	
	*eucer.o
	*eucer_asc_cfg_func.o
	*eucer_build_peer_msg_func.o
	*eucer_db_connection_func.o
	*eucer_db_framework_func.o
	*eucer_db_mac_func.o
	*eucer_db_meas_func.o
	*eucer_db_phy_func.o
	*eucer_db_rb_func.o
	*eucer_db_security_func.o
	*eucer_db_state_func.o
	*eucer_eucsr_cfg_func.o
	*eucer_eumac_cfg_func.o
	*eucer_eumcr_cfg_func.o
	*eucer_eupdcp_cfg_func.o
	*eucer_euphy_cfg_func.o
	*eucer_eurlc_cfg_func.o
	*eucer_ie_cfg_func.o
	*eucer_ie_map_func.o
	*eucer_msg_handling_func.o
	*eucer_msg_send_func.o
	*eucer_prds_cco_to_irat.o
	*eucer_prds_cco_to_lte.o
	*eucer_prds_config_sublayer.o
	*eucer_prds_counter_check.o
	*eucer_prds_dl_info_transfer.o
	*eucer_prds_ephy_inactive.o
	*eucer_prds_eurrc_inactive.o
	*eucer_prds_handover.o
	*eucer_prds_ho_to_irat.o
	*eucer_prds_ho_to_lte.o
	*eucer_prds_leave_conn_for_idle.o
	*eucer_prds_mbms_func.o
	*eucer_prds_rrc_conn_est.o
	*eucer_prds_rrc_conn_reconfig.o
	*eucer_prds_rrc_conn_reest.o
	*eucer_prds_rrc_conn_rel.o
	*eucer_prds_rrc_conn_rel_by_nas.o
	*eucer_prds_security_mode_cmd.o
	*eucer_prds_selfHo_func.o
	*eucer_prds_tgtchcfg_func.o
	*eucer_prds_ue_cap_enq.o
	*eucer_prds_ue_info_req.o
	*eucer_prds_ul_info_transfer.o
	*eucer_test.o
	*eucer_timer_handling_func.o
	/* 3.3.3  eu_csr */	
	*eucsr.o
	*eucsr_collision_proc.o
	*eucsr_common_func.o
	*eucsr_data_typedef.o
	*eucsr_interface.o
	*eucsr_msg_handling.o
	*eucsr_msg_sending.o
	*eucsr_procedure_func.o
	*eucsr_tpch_handling_func.o
	/* 3.3.4  eu_mcr */	
	*eumcr.o
	*eumcr_cell_fun.o
	*eumcr_db_fun.o
	*eumcr_irat_config.o
	*eumcr_irat_report.o
	*eumcr_irat_resel.o
	*eumcr_irat_result.o
	*eumcr_l1_config.o
	*eumcr_l1_irat_config.o
	*eumcr_l1_results.o
	*eumcr_meas_config.o
	*eumcr_meas_report.o
	*eumcr_msg_handling.o
	*eumcr_resel.o
	*eumcr_send_msg.o
	*eumcr_timer_fun.o
	*eumcr_utils_fun.o
	/* 3.3.5  eu_mtc */	
	*eurrc.o
	*eurrc_func.o
	/* 3.3.6  eu_mtc */	
	*eurrc.o
	*eurrc_func.o
	/* 3.3.7  eu_sir */	
	*eusir.o
	*eusir_interface.o
	*eusir_sibhdl.o
	/* 3.4    l1e */
	*l1e.o
	*l1e_bch.o
	*l1e_com.o
	*l1e_csr.o
	*l1e_gsm_irat_meas.o
	*l1e_mon.o
	*l1e_msg_handle.o
	*l1e_ps_ephy_comm.o
	*l1e_rach.o
	*l1e_sup_meas.o
	*l1e_td_irat_meas.o
	*l1e_time_func.o
	*l1e_tstamp.o
	*l1e_w_irat_meas.o
	/* 4  as_com */
	/* 4.1  com */
	*ascom.o
	/* 4.2  asc */
	*zps_asc_camplostcov.o
	*zps_asc_cco.o
	*zps_asc_com.o
	*zps_asc_ho.o
	*zps_asc_hplmn.o
	*zps_asc_main.o
	*zps_asc_plmncsg.o
	*zps_asc_reseldirect.o
	/* 4.3  asn1 */
	*perbasiccdec.o
	*percdec.o
	*perdemain.o
	*perenmain.o
	*urrccdec0.o
	*urrcintchk.o
	*urrcmsrach.o
	*urrcsysinfocont.o
	*zps_urrc_asn1_basic.o
	*zps_urrc_asn1_complex.o
	*zps_urrc_asn1_complexmember.o
	*zps_urrc_asn1_defval.o
	*zps_urrc_asn1_simple.o
	/* 4.4  pdcp */
	*zps_updcp_cfg.o
	*zps_updcp_com.o
	*zps_updcp_ctrl.o
	*zps_updcp_dl.o
	*zps_updcp_dl_buf.o
	*zps_updcp_hc.o
	*zps_updcp_rabm.o
	*zps_updcp_reloc.o
	*zps_updcp_ul.o
	/* 4.5  pdi */
	*zps_pdi_looptest.o
	*zps_pdi_main.o
	*zps_pdi_sellstat.o
	/* 4.6  rohc */
	/* 4.6.1  rohcadaptor */
	*zps_rohcadaptor.o
	/* 4.6.2  rohcv1 */
	*zps_rohcv1_codec.o
	*zps_rohcv1_common.o
	*zps_rohcv1_compctrl.o
	*zps_rohcv1_comppktanalyse.o
	*zps_rohcv1_crc.o
	*zps_rohcv1_ctxmng.o
	*zps_rohcv1_decompctrl.o
	*zps_rohcv1_encodepkt.o
	*zps_rohcv1_fdbkmng.o
	*zps_rohcv1_getpkttype.o
	*zps_rohcv1_instmng.o
	*zps_rohcv1_interface.o
	*zps_rohcv1_orgpktanalyse.o
	/* 4.6.3  rohcv2 */
	*zps_rohcv2_codec.o
	*zps_rohcv2_common.o
	*zps_rohcv2_compctrl.o
	*zps_rohcv2_comppktanalyse.o
	*zps_rohcv2_comppktfilter.o
	*zps_rohcv2_crc.o
	*zps_rohcv2_ctxmng.o
	*zps_rohcv2_decidepkttype.o
	*zps_rohcv2_decompcrcchk.o
	*zps_rohcv2_decompctrl.o
	*zps_rohcv2_decompdecode.o
	*zps_rohcv2_encodepkt.o
	*zps_rohcv2_fdbkmng.o
	*zps_rohcv2_instmng.o
	*zps_rohcv2_interface.o
	*zps_rohcv2_origpktanalyse.o
	*zps_rohcv2_recoverorighd.o
	/* 4.7  sci */
	*zps_sci_codec_ctrl.o
	*zps_sci_com.o
	*zps_sci_entity.o
	*zps_sci_if_7502.o
	*zps_sci_if_7550.o
	*zps_sci_if_io_dev.o
	*zps_sci_main.o
	*zps_sci_simu_if.o
	*zps_sci_trace.o
	/* 5  pscom */
	*hmac_sha.o
	*pscom.o
	*psdev.o
	*psl1com.o
	*psmsgtrace.o
	*pstest.o
	*tdstubforlte.o
	/* 6  nas */
	/* 6.1  ati */
	*zat_com.o
	*zat_ext_fnc.o
	*zat_fnc.o
	*zat_fnc_sup.o
	*zat_var.o
	*zati_cc.o
	*zati_com.o
	*zati_csd_fnc.o
	*zati_distribute_fnc.o
	*zati_esm.o
	*zati_fnc.o
	*zati_func.o
	*zati_main.o
	*zati_othr.o
	*zati_pdi_fnc.o
	*zati_sm.o
	*zati_sms.o
	*zati_ss.o
	*zati_umm.o
	/* 6.2  cbs */
	*cbscommfunc.o
	*cbsmain.o
	*cbsmanagemidsn.o
	*cbsmsgfunc.o
	/* 6.3  cc */
	*cccommonfunc.o
	*cclowermsgproc.o
	*ccmain.o
	*ccpeermsgproc.o
	*cctimerexpiryproc.o
	*ccuppermsgproc.o
	/* 6.4  csn1 */
	*csn1_basic.o
	*csn1_decoder.o
	*csn1_encoder.o
	*csn1_ende1.o
	*csn1_ende2.o
	*csn1_ende3.o
	*csn1_ende4.o
	*csn1_ende5.o
	*csn1_ende6.o
	*csn1_ende7.o
	*csn1_shared.o
	*zps_gsm_csn_demain.o
	*zps_gsm_csn_enmain.o
	/* 6.5  emm */
	*emm_as.o
	*emm_attach.o
	*emm_comproc.o
	*emm_detach.o
	*emm_main.o
	*emm_send.o
	*emm_tau.o
	*emm_test.o
	*emm_upper.o
	*emm_util.o
	/* 6.6  esm */
	*esm_common.o
	*esm_dispatch.o
	*esm_etft.o
	*esm_l3_msg_send.o
	*esm_l3msg_porc.o
	*esm_msg_send.o
	*esm_proc_action.o
	*esm_pub.o
	*esm_rat.o
	/* 6.7  gmm */
	*gmmas.o
	*gmmattachproc.o
	*gmmcommonproc.o
	*gmmdetachproc.o
	*gmmmainproc.o
	*gmmprocfunc.o
	*gmmrauproc.o
	*gmmserviceproc.o
	*gmmtimer.o
	*gmmuicc.o
	/* 6.8  l3cdec */
	*basic.o
	*berbasiccdec.o
	*bercdec.o
	*grrbasic.o
	*grrcdec.o
	*grrcdecie.o
	*grrmsgcodede.o
	*grrmsgcodeen.o
	*l3cdec0.o
	*l3cdec1.o
	*l3cdec2.o
	*l3cdec3.o
	*l3cdecie.o
	*l3cdecjiang.o
	*l3csn0.o
	*l3csnde.o
	*l3csnen.o
	*l3msgcodede.o
	*l3msgcodeen.o
	*l3rpcodede.o
	*l3rpcodeen.o
	*psl3sscdec0.o
	*psl3sscdec0_dep.o
	*psl3sscdec0_indep.o
	*psl3ssde.o
	*psl3ssen.o
	/* 6.9  mm */
	*mm_cmproc.o
	*mm_comnproc.o
	*mm_mainproc.o
	*mm_pubfun.o
	*mm_specproc.o
	/* 6.10  nascom */
	*nascom.o
	/* 6.11  smm */
	*smcom.o
	*smcomproc.o
	*smctrl.o
	*smmsgchk.o
	*smmsgproc.o
	*smparatrans.o
	*smsendmsg.o
	/* 6.12  sms */
	*smscommfunc.o
	*smsmain.o
	*smsmsgfunc.o
	*smsstatefunc.o
	*smstimerexpiryfunc.o
	/* 6.13  ss */
	*sscommfunc.o
	*sslowermsg.o
	*ssmain.o
	*sspeermsg.o
	*ssuppermsg.o
	/* 6.14  stm */
	*zstm_common.o
	*zstm_dm_fnc.o
	*zstm_fnc.o
	*zstm_pb_fnc.o
	*zstm_pb_logic.o
	*zstm_pb3g_fnc.o
	*zstm_sms_fnc.o
	*zstm_sms_logic.o
	/* 6.15  taf */
	*tafctrl.o
	*tafds.o
	*tafdta.o
	*tafint.o
	*tafl1sim.o
	*tafl2r.o
	*tafnurlc.o
	*tafra.o
	*tafrlp.o
	/* 6.16  tc */
	*tc.o
	*tc_lte.o
	/* 6.17  tft */
	*tft.o
	/* 6.18  uicc */
	*uicc_appmngr.o
	*uicc_cache.o
	*uicc_cardaccess.o
	*uicc_cardinit.o
	*uicc_cardmngr.o
	*uicc_cardslot.o
	*uicc_command.o
	*uicc_commonfunc.o
	*uicc_devmeth.o
	*uicc_event.o
	*uicc_filemeth.o
	*uicc_isimappmngr.o
	*uicc_isimfileservice.o
	*uicc_isiminit.o
	*uicc_isimsecurity.o
	*uicc_main.o
	*uicc_refresh.o
	*uicc_securitycomm.o
	*uicc_simappmngr.o
	*uicc_simfileservice.o
	*uicc_simsecurity.o
	*uicc_usat.o
	*uicc_usimappmngr.o
	*uicc_usimfileservice.o
	*uicc_usimsecurity.o
	*uicc_vcard.o
	*uicc_vcardauth.o
	*uicc_vcardrsa.o
	/* 6.19  uicccdec */
	*basicaction.o
	*usatbasic.o
	*usatcdecber.o
	*usatcdecsimpl.o
	*usatmsgdecode.o
	*usatmsgencode.o
	*usimcdec.o
	*usimmsgdecode.o
	*usimmsgencode.o
	*usimothercdec.o
	/* 6.20  umm */
	*ummas.o
	*ummcom.o
	*ummctrl.o
	*ummentry.o
	*ummfun.o
	*ummplmn.o
	*ummtimer.o
	*ummup.o
	*ummupdate.o
	/* 6.21  usat */
	*usat_atmain.o
	*usat_atrecv.o
	*usat_main.o).text)
	*(.ps_static_func)
    *(.stub)
    *(.gnu.warning)
	cpko_text_end = .;
  }

  .init.text 0: {
    KEEP(*(.init.text))
  }

  .exit.text 0: {
    KEEP(*(.exit.text))
  }
 
  NXPSW_SO_ProcessInt_Scalar 0: {
    *(NXPSW_SO_ProcessInt_Scalar*)
  }

  NXPSW_SO_ProcessInt_Vector 0: {
    *(NXPSW_SO_ProcessInt_Vector*)
  }
  
  NXPSW_SO_MARKER 0: {
    *(NXPSW_SO_MARKER*)
  }
  
  NXPSW_SO_ProcessInt_FIR 0: {
    cpko_nxp_start = .;
    *(NXPSW_SO_ProcessInt_FIR*)
	cpko_nxp_end = .;
  }
  
  NXPSW_SO_ProcessInt_BIQUAD 0: {
    *(NXPSW_SO_ProcessInt_BIQUAD*)
  }
  
  NXPSW_SO_ProcessInt_FSB 0: {
    *(NXPSW_SO_ProcessInt_FSB*)
  }
  
  NXPSW_SO_ProcessInt_LVCOMMON 0: {
    *(NXPSW_SO_ProcessInt_LVCOMMON*)
  }
  
  NXPSW_SO_ProcessInt_FFT 0: {
    *(NXPSW_SO_ProcessInt_FFT*)
  }
  
  NXPSW_SO_ProcessInt_NLMS 0: {
    *(NXPSW_SO_ProcessInt_NLMS*)
  }
  
  NXPSW_SO_ProcessInt_FilterCalc 0: {
    *(NXPSW_SO_ProcessInt_FilterCalc*)
  }
  
  NXPSW_SO_ProcessInt_Birec 0: {
    *(NXPSW_SO_ProcessInt_Birec*)
  }
  
  NXPSW_SO_ProcessInt_PCD 0: {
    *(NXPSW_SO_ProcessInt_PCD*)
  }
  
  .text.unlikely 0: {
    *(.text.unlikely)
  }
  
  .fini 0: {
    *(SORT(.fini))
  }

  .rodata 0: {
    *(.rodata)
  }

  .modinfo 0: {
	KEEP(*(.modinfo))
  }

  .rodata.str1.4 0: {
    *(.rodata.str1.4)
  }

  .rodata.str1.1 0: {
    *(.rodata.str1.1)
  }

  .ARM.extab.init.text 0: {
    *(.ARM.extab.init.text)
  }

  .ARM.exidx.init.text 0: {
    *(.ARM.exidx.init.text)
  }

  .ARM.extab.exit.text 0: {
    *(.ARM.extab.exit.text)
  }

  .ARM.exidx.exit.text 0: {
    *(.ARM.exidx.exit.text)
  }

  .rodata.str 0: {
    *(.rodata.str)
  }

  __bug_table 0: {
	*(__bug_table)
  }

  .ARM.extab.text.unlikely 0: {
    *(.ARM.extab.text.unlikely)
  }

  .ARM.exidx.text.unlikely 0: {
    *(.ARM.exidx.text.unlikely)
  }

  .rodata1 0: {
    *(.rodata1)
  }

  .ARM.extab 0: {
    *(.ARM.extab)
  }

  .data 0: {
    cpko_data_start = .;
    *(.data)
	cpko_data_end = .;
  }

  .exitcall.exit 0: {
    *(.exitcall*)
  }

  .initcall6.init 0: {
    *(.initcall6*)
  }
  
  .gnu.linkonce.this_module 0: {
    *(.gnu.linkonce.this_module*)
  }
  
  .ARM.exidx 0: {
    *(.ARM.exidx)
  }
 
  .note.gnu.build-id 0: {
    *(.note.gnu.build-id*)
  }
  
  .bss 0: {
    cpko_bss_start = .;
    *(.dynbss)
    *(.bss)
    *(COMMON)
	cpko_bss_end = .;
  }
	
	__ksymtab		: { *(SORT(___ksymtab+*)) }
	__ksymtab_gpl		: { *(SORT(___ksymtab_gpl+*)) }
	__ksymtab_unused	: { *(SORT(___ksymtab_unused+*)) }
	__ksymtab_unused_gpl	: { *(SORT(___ksymtab_unused_gpl+*)) }
	__ksymtab_gpl_future	: { *(SORT(___ksymtab_gpl_future+*)) }
	__kcrctab		: { *(SORT(___kcrctab+*)) }
	__kcrctab_gpl		: { *(SORT(___kcrctab_gpl+*)) }
	__kcrctab_unused	: { *(SORT(___kcrctab_unused+*)) }
	__kcrctab_unused_gpl	: { *(SORT(___kcrctab_unused_gpl+*)) }
	__kcrctab_gpl_future	: { *(SORT(___kcrctab_gpl_future+*)) }
}
