/*******************************************************************************
 * Copyright (C) 2014, ZTE Corporation.
 *
 * File Name:    drvs_io_kpd.h
 * File Mark:
 * Description:
 * Others:
 * Version:       1.0
 * Author:        yuxiang
 * Date:          2014-07-11
 * History 1:
 *     Date:
 *     Version:
 *     Author:
 *     Modification:
 * History 2:
  ********************************************************************************/

#ifndef _DRVS_IO_KPD_H
#define _DRVS_IO_KPD_H

/****************************************************************************
*                                           Include files
****************************************************************************/
#include "drvs_io.h"

/****************************************************************************
*                                           Macros
****************************************************************************/
#define ZDRV_DEV_KPD            "kpd"

/****************************************************************************
*                                           Types
****************************************************************************/

/* tianbao zhou 20171122 */
typedef enum
{
    KPD_VK_NULL,

    KPD_VK_1,                   /* number 1 */
    KPD_VK_2,                   /* number 2 */
    KPD_VK_3,                   /* number 3 */
    KPD_VK_4,                   /* number 4 */
    KPD_VK_5,                   /* number 5 */
    KPD_VK_6,                   /* number 6 */
    KPD_VK_7,                   /* number 7 */
    KPD_VK_8,                   /* number 8 */
    KPD_VK_9,                   /* number 9 */
    KPD_VK_0,                   /* number 0 */
    KPD_VK_STAR,                /* 11: key * */
    KPD_VK_HASH,                /* 12: key # */

    KPD_VK_NV_UP,               /* 13: key up */
    KPD_VK_NV_DOWN,             /* 14: key down */
    KPD_VK_NV_LEFT,             /* 15: key left */
    KPD_VK_NV_RIGHT,            /* 16: key right */
    KPD_VK_NV_CENTER,           /* 17: key ok */
    KPD_VK_SOFT_LEFT,           /* 18: left soft */
    KPD_VK_SOFT_RIGHT,          /* 19: right soft */
    KPD_VK_CALL,                /* 20: call key */

    /* Use only KPD_VK_POWER if a key is both KPD_VK_CANCEL and KPD_VK_POWER */
    KPD_VK_CANCEL,              /* cancel key. */
    KPD_VK_POWER,               /* 22: power key. */

    KPD_VK_SOFT_1,              /* 23: soft key 1 for additional functional key */
    KPD_VK_SOFT_2,              /* 24: soft key 2 for additional functional key */
    KPD_VK_SOFT_3,              /* 25: soft key 3 for additional functional key */
    KPD_VK_SOFT_4,              /* 26: soft key 4 for additional functional key */

    KPD_VK_SIDE_UP,             /* 27: up key on the side */
    KPD_VK_SIDE_DOWN,           /* 28: down key on the side */
    KPD_VK_WEB,                 /* 29: web key */
    KPD_VK_CAMERA,              /* 30: camera key */
    KPD_VK_FLIP,                /* 31: flip key */

    KPD_VK_SHORTCUT1,			/* 32: */
    KPD_VK_SHORTCUT2,
    KPD_VK_SHORTCUT3,
    KPD_VK_SHORTCUT4,
    KPD_VK_SHORTCUT5,
    KPD_VK_SHORTCUT6,
    KPD_VK_VOLUME,              /* 38: ڽݼ */
    KPD_VK_SETTING,             /* 39:  */
    KPD_VK_WEATHERPORT,         /* 40: Ԥ */
    KPD_VK_MESSAGE,             /* 41:  */
    KPD_VK_12580,				/* 42: */
    KPD_VK_SOS,					/* 43: */
    KPD_VK_REDIAL,              /* 44: ز */
    KPD_VK_HEADFREE,            /* 45:  */
    KPD_VK_HEADSET,             /* 46: ժ  һ */
    KPD_VK_HEADSETUP,           /* 47: ժ */
    KPD_VK_HEADSETDOWN,         /* 48: һ */

    KPD_VK_WIFI,
    KPD_VK_RESET,
    KPD_VK_WPS,

    KPD_VK_NUM					/* 52 */
} T_ZDrvKpd_VirtualKey;

/* key state */
typedef enum
{
    KEY_RELEASED,         /* key has been released */
    KEY_PRESSED,          /* key has been pressed */

    MAX_KEY_STATE
} T_ZDrvKpd_KeyState;

typedef struct
{
    T_ZDrvKpd_VirtualKey    key;    /* key code */
    T_ZDrvKpd_KeyState      state;  /* key state */
    UINT8                   times;  /* scaned times when pressed, and by this can get the de pressed
                                     * time equal to times x scan interval( 100ms ) */
} T_ZDrvKpd_KeyItem;

#if IOKEYS(IOCTL_KPD_SET_BLG_BRIGHTNESS) || IOKEYS(IOCTL_KPD_GET_BLG_STATUS)
typedef UINT8 T_ZDrvKpd_BlgBrightness;  /* 0~255 */
#endif

#if IOKEYS(IOCTL_KPD_GET_BLG_STATUS)
typedef struct
{
    UINT8 isBlgOn;
    T_ZDrvKpd_BlgBrightness brightness;
} T_ZDrvKpd_BlgStatus;
#endif


#endif/*_DRVS_IO_KPD_H*/

