/*******************************************************************************
 * Copyright (C) 2016, ZTE Corporation.
 *
 * File Name:
 * File Mark:
 * Description:
 * Others:
 * Version:       V1.0
 * Author:        yuxiang
 * Date:          2016-01-27
 * History 1:
 *     Date:
 *     Version:
 *     Author:
 *     Modification:
 * History 2:
  ********************************************************************************/

#ifndef _DRVS_PMIC_REGULATOR_H
#define _DRVS_PMIC_REGULATOR_H

#if defined(_USE_PMIC_ZX234290)
/* ========================== Ĵλ ======================== */
#if 1
/* 0x06  STATUS REG -- STARTUP */
#define ZX234290_SYSPOR_STATUS_PWRON_STARTUP      (0x1 << 0)  /* PWR ON button */
#define ZX234290_SYSPOR_STATUS_RTC_ALARM_STARTUP    (0x1 << 1)
#define ZX234290_SYSPOR_STATUS_PSHOLD_STARTUP     (0x1 << 2)
#define ZX234290_SYSPOR_STATUS_PWRONLLP_STARTUP     (0x1 << 3)


/* discharger   */
#define ZX234290_DISCHG1_LSB_LSH            (0)
#define ZX234290_DISCHG1_LSB_WID            (4)

#define ZX234290_DISCHG1_MSB_LSH            (5)
#define ZX234290_DISCHG1_MSB_WID            (2)

#define ZX234290_DISCHG2_LSH            (0)
#define ZX234290_DISCHG2_WID            (8)


/* BUCK VOLTAGE */
#define ZX234290_BUCK01_VSEL_LSH            (0)
#define ZX234290_BUCK01_VSEL_WID            (6)

/* BUCK SLEEP VOLTAGE */
#define ZX234290_BUCK01_SLEEP_VSEL_LSH      (0)
#define ZX234290_BUCK01_SLEEP_VSEL_WID      (6)

/* BUCKS MODE CTROL */
#define ZX234290_REGULATOR_MODE_WID         (2)

#define ZX234290_BUCK0_SLPMODE_LSH          (0)
#define ZX234290_BUCK0_NRMMODE_LSH          (2)
#define ZX234290_BUCK1_SLPMODE_LSH          (4)
#define ZX234290_BUCK1_NRMMODE_LSH          (6) /*[7:6]*/
#define ZX234290_BUCK2_SLPMODE_LSH          (0)
#define ZX234290_BUCK2_NRMMODE_LSH          (2)
#define ZX234290_BUCK3_SLPMODE_LSH          (4)
#define ZX234290_BUCK3_NRMMODE_LSH          (6)
#define ZX234290_BUCK4_SLPMODE_LSH          (0)
#define ZX234290_BUCK4_NRMMODE_LSH          (2)

/* LDO MODE, ONLY SLEEP MODE     */
#define ZX234290_LDO1_SLPMODE_LSH           (0)
#define ZX234290_LDO2_SLPMODE_LSH           (2)
#define ZX234290_LDO3_SLPMODE_LSH           (4)
#define ZX234290_LDO4_SLPMODE_LSH           (6)
#define ZX234290_LDO5_SLPMODE_LSH           (0)
#define ZX234290_LDO6_SLPMODE_LSH           (2)
#define ZX234290_LDO7_SLPMODE_LSH           (4)
#define ZX234290_LDO8_SLPMODE_LSH           (6)
#define ZX234290_LDO9_SLPMODE_LSH           (2)
#define ZX234290_LDO10_SLPMODE_LSH          (4)
//#define ZX234290_LDO11_SLPMODE_LSH            (6)

/* LDO VOLTAGE SELECT */
#define ZX234290_LDO_VSEL_WID               (4)

#define ZX234290_LDO1_VSEL_LSH              (0) /* [3:0]    */
#define ZX234290_LDO2_VSEL_LSH              (4) /* [7:4]    */
#define ZX234290_LDO3_VSEL_LSH              (0)
#define ZX234290_LDO4_VSEL_LSH              (4)
#define ZX234290_LDO5_VSEL_LSH              (0)
#define ZX234290_LDO6_VSEL_LSH              (4)
#define ZX234290_LDO7_VSEL_LSH              (0)
#define ZX234290_LDO8_VSEL_LSH              (4)
#define ZX234290_LDO9_VSEL_LSH              (4)
#define ZX234290_LDO10_VSEL_LSH             (0)
#define ZX234290_LDO11_VSEL_LSH             (0) /* [3:0]    */

#define ZX234290_VORTC_VSEL_WID             (2)
#define ZX234290_VORTC_VSEL_LSH             (4) /* [5][4]   */
#define ZX234290_LDO5_VSEL_WID              (2) /* [1][0]*/


/* LDO SLEEP VOLTAGE    */
#define ZX234290_BUCK2_VSEL_WID             (5)

#define ZX234290_BUCK2_VSEL_LSH             (0)

#define ZX234290_LDO1_SLP_VSEL_LSH          (0) /* [3:0]    */
#define ZX234290_LDO2_SLP_VSEL_LSH          (4) /* [7:4]    */
#define ZX234290_LDO3_SLP_VSEL_LSH          (0)
#define ZX234290_LDO7_SLP_VSEL_LSH          (0)
#define ZX234290_LDO8_SLP_VSEL_LSH          (0)
#define ZX234290_LDO11_SLP_VSEL_LSH         (0) /* [3:0]    */

/* ENABLE 0x21-0x22 */
#define ZX234290_LDOS_ON_WID                (1)

#define ZX234290_LDO1_ON_LSH                (0)
#define ZX234290_LDO2_ON_LSH                (1)
#define ZX234290_LDO3_ON_LSH                (2)
#define ZX234290_LDO4_ON_LSH                (3)
#define ZX234290_LDO5_ON_LSH                (4)
#define ZX234290_LDO6_ON_LSH                (5)
#define ZX234290_LDO7_ON_LSH                (6)
#define ZX234290_LDO8_ON_LSH                (7)

#define ZX234290_LDO9_ON_LSH                (1)
#define ZX234290_LDO10_ON_LSH               (2)
#define ZX234290_BUCK1_ON_LSH               (4)
#define ZX234290_BUCK2_ON_LSH               (5)
#define ZX234290_BUCK3_ON_LSH               (6)
#define ZX234290_BUCK4_ON_LSH               (7)

/* LONG PRESSED TIME    */
#define ZX234290_PWRON_TIME_LSH             (0)
#define ZX234290_PWRON_TIME_WID             (2)
#define ZX234290_PWRON_LONGPRESS_EN_LSH     (2)
#define ZX234290_PWRON_LONGPRESS_EN_WID     (1)
#define ZX234290_PWRON_LLP_TODO_LSH         (3) /* LLP long long pressed */
#define ZX234290_PWRON_LLP_TODO_WID         (1)

/* sys ctrol 0x07   */
#define ZX234290_SINK1_EN_LSH               (0)
#define ZX234290_SINK1_EN_WID               (1)
#define ZX234290_SINK2_EN_LSH               (1)
#define ZX234290_SINK2_EN_WID               (1)
#define ZX234290_ADC1_EN_LSH                (4)
#define ZX234290_ADC1_EN_WID                (1)
#define ZX234290_ADC2_EN_LSH                (3)
#define ZX234290_ADC2_EN_WID                (1)
#define ZX234290_ADC_START_LSH              (5)
#define ZX234290_ADC_START_WID              (1)

/* 0x08 */
#define ZX234290_SINK2_CURSEL_LSH           (0)
#define ZX234290_SINK2_CURSEL_WID           (4)
/* 0x09 */
#define ZX234290_SINK1_CURSEL_LSH           (0)
#define ZX234290_SINK1_CURSEL_WID           (4)

#define ZX234290_LDO_RSTERR_LSH		(0)
#define ZX234290_LDO_RSTERR_WID		(1)

#endif  /* end of ZX234290 */

#define ZX234290_BITFVAL(var, lsh)   ( (var) << (lsh) )
#define ZX234290_BITFMASK(wid, lsh)  ( ((1U << (wid)) - 1) << (lsh) )
#define ZX234290_BITFEXT(var, wid, lsh)   ((var & ZX234290_BITFMASK(wid, lsh)) >> (lsh))

/* =========================== ṹĶ ========================== */

/* VBA - BUCK1  6bit */
typedef enum _T_ZDrvZx234290_VbuckA
{
    VBUCKA_0_675 = 0x00,
    VBUCKA_0_700 = 0x02,
    VBUCKA_0_750 = 0x06,
    VBUCKA_0_800 = 0x0a,
    VBUCKA_0_850 = 0x0e,
    VBUCKA_0_900 = 0x12,/*default*/
    VBUCKA_0_950 = 0x16,
    VBUCKA_1_000 = 0x1a,
    VBUCKA_1_050 = 0x1e,
    VBUCKA_1_100 = 0x22,
    VBUCKA_1_150 = 0x26,
    VBUCKA_1_200 = 0x2a,
    VBUCKA_1_250 = 0x2e,

    VBUCKA_MAX

}T_ZDrvZx234290_VbuckA;

/* VBC - BUCK2 */
typedef enum _T_ZDrvZx234290_VbuckC
{
    VBUCKC_0_850 = 0x00,
    VBUCKC_0_900 = 0x02,
    VBUCKC_0_950 = 0x04,
    VBUCKC_1_000 = 0x06,
    VBUCKC_1_050 = 0x08,
    VBUCKC_1_100 = 0x0a,
    VBUCKC_1_150 = 0x0c,
    VBUCKC_1_200 = 0x0e,/*default*/
    VBUCKC_1_250 = 0x10,
    VBUCKC_1_300 = 0x12,
    VBUCKC_1_350 = 0x14,
    VBUCKC_1_400 = 0x16,
    VBUCKC_1_450 = 0x18,
    VBUCKC_1_500 = 0x1a,
    VBUCKC_1_550 = 0x1c,
    VBUCKC_1_600 = 0x1e,

    VBUCKC_MAX

}T_ZDrvZx234290_VbuckC;

/* VLA - ldo1/9/10  */
typedef enum _T_ZDrvZx234290_VldoA
{
    VLDOA_0_725 = 0,
    VLDOA_0_750 = 1,
    VLDOA_0_775 = 2,
    VLDOA_0_800 = 3,
    VLDOA_0_825 = 4,
    VLDOA_0_850 = 5,
    VLDOA_0_875 = 6,
    VLDOA_0_900 = 7,
    VLDOA_0_925 = 8,
    VLDOA_0_950 = 9,
    VLDOA_0_975 = 10,
    VLDOA_1_000 = 11,
    VLDOA_1_025 = 12,
    VLDOA_1_050 = 13,
    VLDOA_1_075 = 14,
    VLDOA_1_100 = 15,

    VLDOA_MAX

}T_ZDrvZx234290_VldoA;

/* VLB - ldo5 2bit  */
typedef enum _T_ZDrvZx234290_VldoB
{
    VLDOB_3_300 = 0,
    VLDOB_3_150 = 1,
    VLDOB_3_000 = 2,
    VLDOB_1_800 = 3,    /* 11   */

    VLDOB_MAX

}T_ZDrvZx234290_VldoB;

/* VLC - ldo2/ldo3  */
typedef enum _T_ZDrvZx234290_VldoC
{
    VLDOC_0_750 = 0,
    VLDOC_0_800 = 1,
    VLDOC_0_850 = 2,
    VLDOC_0_900 = 3,
    VLDOC_0_950 = 4,
    VLDOC_1_000 = 5,
    VLDOC_1_050 = 6,
    VLDOC_1_100 = 7,
    VLDOC_1_200 = 8,
    VLDOC_1_500 = 9,
    VLDOC_1_800 = 10,
    VLDOC_2_000 = 11,
    VLDOC_2_500 = 12,
    VLDOC_2_800 = 13,
    VLDOC_3_000 = 14,
    VLDOC_3_300 = 15,

    VLDOC_MAX

}T_ZDrvZx234290_VldoC;

/* VLD - ldo4/6/7/8 */
typedef enum _T_ZDrvZx234290_VldoD
{
    VLDOD_1_400 = 0,
    VLDOD_1_500 = 1,
    VLDOD_1_600 = 2,
    VLDOD_1_800 = 3,
    VLDOD_1_850 = 4,
    VLDOD_2_000 = 5,
    VLDOD_2_050 = 6,
    VLDOD_2_500 = 7,
    VLDOD_2_550 = 8,
    VLDOD_2_700 = 9,
    VLDOD_2_750 = 10,
    VLDOD_2_800 = 11,
    VLDOD_2_850 = 12,
    VLDOD_2_900 = 13,
    VLDOD_2_950 = 14,
    VLDOD_3_000 = 15,

    VLDOD_MAX

}T_ZDrvZx234290_VldoD;

/*  VORTC 2bit  */
typedef enum _T_ZDrvZx234290_VldoE
{
    VLDOE_1_800 = 0,
    VLDOE_2_500 = 1,
    VLDOE_3_000 = 2,
    VLDOE_3_300 = 3,    /* 11   */

    VLDOE_MAX

}T_ZDrvZx234290_VldoE;


/* BUCK3/4 EXTERNAL ADJUSTABLE  */

typedef enum _T_ZDrvZx234290_LDO_ENABLE
{
    LDO_ENABLE_OFF  = 0,   /* 00 */
    LDO_ENABLE_ON   = 1,   /* 10 */

    LDO_AVTICE_MAX
}T_ZDrvZx234290_LDO_ENABLE;

typedef enum _T_ZDrvZx234290_LLP_ENABLE
{
    LLP_DISBALE  = 0,   /* 00 */
    LLP_ENABLE    = 1,   /* 10 */

    LLP_ENABLE_MAX
}T_ZDrvZx234290_LLP_ENABLE;

typedef enum _T_ZDrvZx234290_LLP_TODO
{
    LLP_SHUTDOWN  = 0,   /* 00 */
    LLP_RESTART   = 1,   /* 10 */

    LLP_TODO_MAX
}T_ZDrvZx234290_LLP_TODO;

typedef enum _T_ZDrvZx234290_LP_TIME
{
    LP_TIME_1S  = 0,
    LP_TIME_2S  ,
    LP_TIME_3S  ,
    LP_TIME_4S  ,

    LP_TIME_MAX
}T_ZDrvZx234290_LP_TIME;
typedef enum _T_ZDrvZx234290_TIME_IT
{
    LLP_DLY_128MS  = 0,
    LLP_DLY_500MS  ,
    LLP_DLY_1000MS  ,
    LLP_DLY_1500MS  ,

    LLP_DLY_MAX
}T_ZDrvZx234290_TIME_IT;

typedef enum _T_ZDrvZx234290_LLP_TIME
{
    LLP_TIME_6S  = 0,
    LLP_TIME_7S  ,
    LLP_TIME_8S  ,
    LLP_TIME_10S  ,

    LLP_TIME_MAX
}T_ZDrvZx234290_LLP_TIME;


/*
     BUCKSģʽΪģʽ˯ģʽ ģʽֻעPFM/PWMעء
    ˯ģʽעPFM/PWM/ECO/OFF/NRMӦýΪ ˯ģʽ״̬עPWM/PFM
    ҹע򿪹رգOFFڿŵµģʽĬϿ
    NRMMODEѹ˯ߵѹ
    LDOS˯ģʽһģʽɡҲNRM/ECO/OFF⼸״̬
*/

/* BUCK1/2/3/4 NORMAL MODE */
typedef enum _T_ZDrvZx234290_BUCK_NRMMODE
{
    BUCK_NRM_AUTO_WITH_ECO      = 0,    /* 00/01 AUTO PWM/PSM ECO */
    BUCK_NRM_FORCE_PWM  = 2,    /* 10 FORCE PWM */
    BUCK_NRM_AUTO_WITHOUT_ECO   = 3,  /* 00/01 AUTO PWM/PSM ECO */
    BUCK_NRMMODE_MAX
}T_ZDrvZx234290_BUCK_NRMMODE;

/* BUCK1 SLPMODE */
typedef enum _T_ZDrvZx234290_BUCK1_SLPMODE
{
    BUCK1_SLP_AUTO_WITHOUT_ECO              = 0,    /* 00/11 AUTO PWM/PFM */
    BUCK1_SLP_AUTO_ECO    = 1,  /*BUCK1_SLP_AUTO_ECO_VOLT output voltage configred by FBDC1[5:0]*/
    BUCK1_SLP_AUTO_ECO_SLP    = 2,  /* output voltage configred by FBDC1_SLP[5:0]*/
    BUCK1_SLP_SHUTDOWN              = 3,    /* 11 OFF */
    BUCK1_SLPMODE_MAX
}T_ZDrvZx234290_BUCK1_SLPMODE;

/* BUCK2/3/4 SLPMODE */
typedef enum _T_ZDrvZx234290_BUCK234_SLPMODE
{
    BUCK234_SLP_AUTO_WITHOUT_ECO            = 0,    /* 00 AUTO PWM/PFM without eco*/
    BUCK234_SLP_ECO_WITH_ECO                = 1,    /* 0110 ECO */
    BUCK234_SLP_SHUTDOWN                = 3,    /* 11 OFF */

    BUCK234_SLPMODE_MAX
}T_ZDrvZx234290_BUCK234_SLPMODE;

/* LDO1/2/3/7/8/9/10 SLPMODE */
typedef enum _T_ZDrvZx234290_LDOA_SLPMODE
{
    LDOA_SLP_NRM_MODE           = 0,    /* VOLDOx[3:0]  */
    LDOA_SLP_ECO_VOLT           = 1,    /* VOLDOx[3:0]  */
    LDOA_SLP_ECO_VOLT_SLP       = 2,    /* VOLDOx_SLP[3:0]  */
    LDOA_SLP_SHUTDOWN           = 3,    /* 11 OFF */
    LDOA_SLPMODE_MAX
}T_ZDrvZx234290_LDOA_SLPMODE;

/* LDO4/5/6/ SLPMODE    */
typedef enum _T_ZDrvZx234290_LDOB_SLPMODE
{
    LDOB_SLP_NRM_MODE               = 0,    /* VOLDOx[3:0]  */
    LDOB_SLP_ECO_VOLT               = 1,    /* VOLDOx[3:0]  */
    LDOB_SLP_NRM_MODE_VOLT          = 2,    /* VOLDOx[3:0]  */
    LDOB_SLP_SHUTDOWN               = 3,    /* 11 OFF */
    LDOB_SLPMODE_MAX
}T_ZDrvZx234290_LDOB_SLPMODE;

#endif

typedef enum _T_ZDrvZx234290_LdoDischarger
{
    DISCHARGER_LDO_9  = 0,
    DISCHARGER_LDO_10,
    DISCHARGER_LDO_X,   /*not support*/
    DISCHARGER_BUCK_4,
    DISCHARGER_BUCK_3,
    DISCHARGER_BUCK_2,
    DISCHARGER_BUCK_1,
    DISCHARGER_BUCK_X,  /*not support*/

    DISCHARGER_LDO_1,
    DISCHARGER_LDO_2,
    DISCHARGER_LDO_3,
    DISCHARGER_LDO_4,
    DISCHARGER_LDO_5,
    DISCHARGER_LDO_6,
    DISCHARGER_LDO_7,
    DISCHARGER_LDO_8,

    DISCHARGER_MAX
}T_ZDrvZx234290_LdoDischarger;

typedef enum _T_ZDrvZx234290_DISCHARGER_ENABLE
{
    DISCHARGER_DISBALE  = 0,   /* 00 */
    DISCHARGER_ENABLE    = 1,   /* 10 */

    DISCHARGER_ENABLE_MAX
}T_ZDrvZx234290_DISCHARGER_ENABLE;

typedef enum _T_ZDrvZx234290_LdoList
{
    LDOLIST_BUCK_1  = 0,
    LDOLIST_BUCK_2,
    LDOLIST_BUCK_3,
    LDOLIST_BUCK_4,
    LDOLIST_LDO_1,
    LDOLIST_LDO_2,
    LDOLIST_LDO_3,

    LDOLIST_LDO_4,
    LDOLIST_LDO_5,
    LDOLIST_LDO_6,//default off
    LDOLIST_LDO_7,
    LDOLIST_LDO_8,
    LDOLIST_LDO_9,//default off
    LDOLIST_LDO_10,
    LDOLIST_LDO_RTC,

    LDOLIST_MAX
}T_ZDrvZx234290_LdoList;


typedef enum _T_ZDrvZx234290_ResetType
{
#if 0
    ZX234290_USER_RST_UNDEFINE  = 0,
    ZX234290_USER_RST_TO_NORMAL = 1,
    ZX234290_USER_RST_TO_CHARGER = 2,
    ZX234290_USER_RST_TO_ALARM = 3,
    ZX234290_USER_RST_TO_EXCEPT = 4,
#else
    ZX234290_USER_RST_TO_NORMAL = 0,
    ZX234290_USER_RST_TO_CHARGER = 1,
    ZX234290_USER_RST_TO_ALARM = 2,
    ZX234290_USER_RST_UNDEFINE  = 3,
    /* ZX234290_USER_RST_TO_EXCEPT = 4, */
#endif

    ZX234290_USER_RST_MAX
}T_ZDrvZx234290_ResetType;


/* -----------------------  -------------------------------- */
#if defined(_USE_PMIC_ZX234290)
SINT32 Zx234290_SetTllpToDo(T_ZDrvZx234290_LLP_TODO enable);
SINT32 Zx234290_SetLlpEnable(T_ZDrvZx234290_LLP_ENABLE enable);
SINT32 Zx234290_SetLpTime(T_ZDrvZx234290_LP_TIME time);
SINT32 Zx234290_SetRestartDly(T_ZDrvZx234290_TIME_IT time);
SINT32 Zx234290_SetLlpTime(T_ZDrvZx234290_LLP_TIME time);
int Zx234290_SetUserReg_PSM(UINT8 data);


SINT32 Zx234290_SetDischarger(T_ZDrvZx234290_LdoDischarger ldo, T_ZDrvZx234290_DISCHARGER_ENABLE enable);
SINT32 Zx234290_PrintLdoOnoff(T_ZDrvZx234290_LdoList LdoId, UINT8 status);
SINT32 Zx234290_PrintLdoVol(T_ZDrvZx234290_LdoList LdoId, UINT8 vol);
SINT32 Zx234290_PrintLdoSleep(T_ZDrvZx234290_LdoList LdoId, UINT8 status);


/* regulator */
SINT32 Zx234290_SetVbuck1Onoff(T_ZDrvZx234290_LDO_ENABLE status);
T_ZDrvZx234290_LDO_ENABLE Zx234290_GetVbuck1Onoff(VOID);
SINT32 Zx234290_SetVbuck1(T_ZDrvZx234290_VbuckA vol);
T_ZDrvZx234290_VbuckA Zx234290_GetVbuck1(VOID);
SINT32 Zx234290_SetBUCK1SleepMode(T_ZDrvZx234290_BUCK1_SLPMODE status);
T_ZDrvZx234290_BUCK1_SLPMODE Zx234290_GetBUCK1SleepMode(VOID);
SINT32 Zx234290_SetVbuck1SLPV(T_ZDrvZx234290_VbuckA vol);

SINT32 Zx234290_SetVbuck2Onoff(T_ZDrvZx234290_LDO_ENABLE status);
T_ZDrvZx234290_LDO_ENABLE Zx234290_GetVbuck2Onoff(VOID);
SINT32 Zx234290_SetVbuck2(T_ZDrvZx234290_VbuckC vol);
T_ZDrvZx234290_VbuckC Zx234290_GetVbuck2(VOID);
SINT32 Zx234290_SetBUCK2SleepMode(T_ZDrvZx234290_BUCK234_SLPMODE status);
T_ZDrvZx234290_BUCK234_SLPMODE Zx234290_GetBUCK2SleepMode(VOID);

SINT32 Zx234290_SetVbuck3Onoff(T_ZDrvZx234290_LDO_ENABLE status);
T_ZDrvZx234290_LDO_ENABLE Zx234290_GetVbuck3Onoff(VOID);
SINT32 Zx234290_SetVbuck3ActiveMode(T_ZDrvZx234290_BUCK_NRMMODE status);
SINT32 Zx234290_SetBUCK3SleepMode(T_ZDrvZx234290_BUCK234_SLPMODE status);
T_ZDrvZx234290_BUCK234_SLPMODE Zx234290_GetBUCK3SleepMode(VOID);

SINT32 Zx234290_SetVbuck4Onoff(T_ZDrvZx234290_LDO_ENABLE status);
T_ZDrvZx234290_LDO_ENABLE Zx234290_GetVbuck4Onoff(VOID);
SINT32 Zx234290_SetVbuck4ActiveMode(T_ZDrvZx234290_BUCK_NRMMODE status);
SINT32 Zx234290_SetBUCK4SleepMode(T_ZDrvZx234290_BUCK234_SLPMODE status);
T_ZDrvZx234290_BUCK234_SLPMODE Zx234290_GetBUCK4SleepMode(VOID);

SINT32 Zx234290_SetVldo1Onoff(T_ZDrvZx234290_LDO_ENABLE status);
T_ZDrvZx234290_LDO_ENABLE Zx234290_GetVldo1Onoff(VOID);
SINT32 Zx234290_SetVldo1(T_ZDrvZx234290_VldoA vol);
T_ZDrvZx234290_VldoA Zx234290_GetVldo1(VOID);
SINT32 Zx234290_SetLDO1SleepMode(T_ZDrvZx234290_LDOA_SLPMODE status);
T_ZDrvZx234290_LDOA_SLPMODE Zx234290_GetLDO1SleepMode(VOID);

SINT32 Zx234290_SetVldo2Onoff(T_ZDrvZx234290_LDO_ENABLE status);
T_ZDrvZx234290_LDO_ENABLE Zx234290_GetVldo2Onoff(VOID);
SINT32 Zx234290_SetVldo2(T_ZDrvZx234290_VldoC vol);
T_ZDrvZx234290_VldoC Zx234290_GetVldo2(VOID);
SINT32 Zx234290_SetLDO2SleepMode(T_ZDrvZx234290_LDOA_SLPMODE status);
T_ZDrvZx234290_LDOA_SLPMODE Zx234290_GetLDO2SleepMode(VOID);

SINT32 Zx234290_SetVldo3Onoff(T_ZDrvZx234290_LDO_ENABLE status);
T_ZDrvZx234290_LDO_ENABLE Zx234290_GetVldo3Onoff(VOID);
SINT32 Zx234290_SetVldo3(T_ZDrvZx234290_VldoC vol);
T_ZDrvZx234290_VldoC Zx234290_GetVldo3(VOID);
SINT32 Zx234290_SetLDO3SleepMode(T_ZDrvZx234290_LDOA_SLPMODE status);
T_ZDrvZx234290_LDOA_SLPMODE Zx234290_GetLDO3SleepMode(VOID);

SINT32 Zx234290_SetVldo4Onoff(T_ZDrvZx234290_LDO_ENABLE status);
T_ZDrvZx234290_LDO_ENABLE Zx234290_GetVldo4Onoff(VOID);
SINT32 Zx234290_SetVldo4(T_ZDrvZx234290_VldoD vol);
T_ZDrvZx234290_VldoD Zx234290_GetVldo4(VOID);
SINT32 Zx234290_SetLDO4SleepMode(T_ZDrvZx234290_LDOB_SLPMODE status);
T_ZDrvZx234290_LDOB_SLPMODE Zx234290_GetLDO4SleepMode(VOID);
SINT32 Zx234290_SetLDO4SleepMode_PSM(T_ZDrvZx234290_LDOB_SLPMODE status);

SINT32 Zx234290_SetVldo5Onoff(T_ZDrvZx234290_LDO_ENABLE status);
T_ZDrvZx234290_LDO_ENABLE Zx234290_GetVldo5Onoff(VOID);
SINT32 Zx234290_SetVldo5(T_ZDrvZx234290_VldoB vol);
T_ZDrvZx234290_VldoB Zx234290_GetVldo5(VOID);
extern SINT32 Zx234290_SetLDO5SleepMode(T_ZDrvZx234290_LDOB_SLPMODE status);
extern T_ZDrvZx234290_LDOB_SLPMODE Zx234290_GetLDO5SleepMode(VOID);

SINT32 Zx234290_SetVldo6Onoff(T_ZDrvZx234290_LDO_ENABLE status);
T_ZDrvZx234290_LDO_ENABLE Zx234290_GetVldo6Onoff(VOID);
SINT32 Zx234290_SetVldo6(T_ZDrvZx234290_VldoD vol);
T_ZDrvZx234290_VldoD Zx234290_GetVldo6(VOID);
SINT32 Zx234290_SetLDO6SleepMode(T_ZDrvZx234290_LDOB_SLPMODE status);
T_ZDrvZx234290_LDOB_SLPMODE Zx234290_GetLDO6SleepMode(VOID);

SINT32 Zx234290_SetVldo7Onoff(T_ZDrvZx234290_LDO_ENABLE status);
T_ZDrvZx234290_LDO_ENABLE Zx234290_GetVldo7Onoff(VOID);
SINT32 Zx234290_SetVldo7(T_ZDrvZx234290_VldoD vol);
T_ZDrvZx234290_VldoD Zx234290_GetVldo7(VOID);
SINT32 Zx234290_SetLDO7SleepMode(T_ZDrvZx234290_LDOA_SLPMODE status);
T_ZDrvZx234290_LDOA_SLPMODE Zx234290_GetLDO7SleepMode(VOID);

SINT32 Zx234290_SetVldo8Onoff(T_ZDrvZx234290_LDO_ENABLE status);
T_ZDrvZx234290_LDO_ENABLE Zx234290_GetVldo8Onoff(VOID);
SINT32 Zx234290_SetVldo8(T_ZDrvZx234290_VldoD vol);
T_ZDrvZx234290_VldoD Zx234290_GetVldo8(VOID);
SINT32 Zx234290_SetLDO8SleepMode(T_ZDrvZx234290_LDOA_SLPMODE status);
T_ZDrvZx234290_LDOA_SLPMODE Zx234290_GetLDO8SleepMode(VOID);

SINT32 Zx234290_SetVldo9Onoff(T_ZDrvZx234290_LDO_ENABLE status);
T_ZDrvZx234290_LDO_ENABLE Zx234290_GetVldo9Onoff(VOID);
SINT32 Zx234290_SetVldo9(T_ZDrvZx234290_VldoA vol);
T_ZDrvZx234290_VldoA Zx234290_GetVldo9(VOID);
SINT32 Zx234290_SetLDO9SleepMode(T_ZDrvZx234290_LDOA_SLPMODE status);
T_ZDrvZx234290_LDOA_SLPMODE Zx234290_GetLDO9SleepMode(VOID);

SINT32 Zx234290_SetVldo10Onoff(T_ZDrvZx234290_LDO_ENABLE status);
T_ZDrvZx234290_LDO_ENABLE Zx234290_GetVldo10Onoff(VOID);
SINT32 Zx234290_SetVldo10(T_ZDrvZx234290_VldoA vol);
T_ZDrvZx234290_VldoA Zx234290_GetVldo10(VOID);
extern SINT32 Zx234290_SetLDO10SleepMode(T_ZDrvZx234290_LDOA_SLPMODE status);
extern T_ZDrvZx234290_LDOA_SLPMODE Zx234290_GetLDO10SleepMode(VOID);

SINT32 Zx234290_SetVortc(T_ZDrvZx234290_VldoE vol);
T_ZDrvZx234290_VldoE Zx234290_GetVortc(VOID);

SINT32 Zx234290_SetVldo1Onoff_Psm(T_ZDrvZx234290_LDO_ENABLE status);
SINT32 Zx234290_SetVldo5Onoff_Psm(T_ZDrvZx234290_LDO_ENABLE status);
SINT32 Zx234290_SetLDO1SleepMode_Psm(T_ZDrvZx234290_LDOA_SLPMODE status);
SINT32 Zx234290_SetLDO5SleepMode_Psm(T_ZDrvZx234290_LDOB_SLPMODE status);
int Zx234290_SetResetFalg(T_ZDrvZx234290_ResetType rsttype);
int Zx234290_SetResetFlag_Psm(T_ZDrvZx234290_ResetType rsttype);
SINT32 zDrvZx234290_LdoRstErr(VOID);
SINT32 Zx234290_getPoweronStatus(void);
SINT32 Zx234290_getPoweronStatus_PSM(void);
SINT32 Zx234290_setSoftOn(bool SoftOn);
SINT32 Zx234290_setSoftOn_PSM(bool SoftOn);
#endif

#endif /*_DRVS_PMIC_REGULATOR_H*/

