/*******************************************************************************
 * Copyright (C) 2007, ZTE Corporation.
 *
 * File Name:ring_queue.h
 * File Mark:
 * Description:
 * Others:
 * Version:       1.0
 * Author:        geanfeng
 * Date:          2013-09-25
 * History 1:
 *     Date:
 *     Version:
 *     Author:
 *     Modification:
 * History 2:
  ********************************************************************************/

#ifndef _RING_QUEUE_H
#define _RING_QUEUE_H

/****************************************************************************
* 	                                        Include files
****************************************************************************/
#include "drvs_general.h"
/****************************************************************************
* 	                                        Macros
****************************************************************************/

/****************************************************************************
* 	                                        Types
****************************************************************************/
typedef enum _T_USER_PROTECT_POLICY {
	QUEUE_PROTECT_RAW = 0,
	QUEUE_PROTECT_MUTEX,
	QUEUE_PROTECT_IRQ,
}T_USER_PROTECT_POLICY;

typedef enum _UNIT_STATUS{
    UNIT_OLD,
    UNIT_NEW
}UNIT_STATUS;
    
typedef struct _T_queue {
	UINT8 *unit_buffer;
	UINT32 unit_buffer_size;
	UINT32 unit_size;
	UINT32 unit_count;
	UINT32 write_pos;
	UINT32 read_pos;
    UINT32 *unit_status;
    UINT32 unit_index_en;
    UINT32 unit_index_de;
    
    UINT32 g_queueMsr;
	
	T_USER_PROTECT_POLICY multi_user_protect;
	ZOSS_SEMAPHORE_ID lock;
}T_queue;

/****************************************************************************
* 	                                        Constants
****************************************************************************/

/****************************************************************************
* 	                                        Global  Variables
****************************************************************************/

/****************************************************************************
* 	                                        Function Prototypes
****************************************************************************/
T_queue *queue_Create(UINT32 unit_count, UINT32 unit_size, T_USER_PROTECT_POLICY multi_user_protect);

SINT32 queue_Init(T_queue *queue, UINT8 *unit_buffer, 
						UINT32 unit_count, UINT32 unit_size, T_USER_PROTECT_POLICY protect_policy);

SINT32 queue_Enqueue(T_queue *queue, VOID *unit);

SINT32 queue_Dequeue(T_queue *queue, VOID *unit);

SINT32 queue_Empty(T_queue *queue);

SINT32 queue_Full(T_queue *queue);

VOID queue_Fush(T_queue *queue);

VOID queue_Destroy(T_queue *queue);


#endif/*_RING_QUEUE_H*/

