/*******************************************************************************
 * Copyright (C) 2007, ZTE Corporation.
 *
 * File Name:    USIM_reg.h
 * File Mark:    
 * Description:  
 * Others:        
 * Version:       1.0
 * Author:        wangxia
 * Date:          2008-2-21
 * History 1:      
 *     Date: 
 *     Version:
 *     Author: 
 *     Modification:  
 * History 2: 
  ********************************************************************************/

#ifndef SIM_REG_H
#define SIM_REG_H


/****************************************************************************
* 	                                        Include files
****************************************************************************/
/*#include "REG_CommonRegStruct.h"*/
#include "pub.h"
#include "drvs_cfg.h"
#include "drvs_uicc.h"

/****************************************************************************
* 	                                        Macros
****************************************************************************/
extern volatile UINT32  axi_ahb0_usim_base;
extern volatile UINT32  axi_ahb0_usim_base_sim_fifo_txd;
extern volatile UINT32  axi_ahb0_usim_base_sim_fifo_rxd;

#if 0
#ifndef SOC_USIM
#define AXI_AHB0_USIM_BASE     (GSM_MODEM2+0x100000)
#else
#define AXI_AHB0_USIM_BASE     (USIM1_REG_BASE)
#endif
#endif

#define AXI_AHB0_USIM_BASE 	(UINT32)axi_ahb0_usim_base

/****************************************************************************
* 	                                        Types
****************************************************************************/
#define SIM_LDO		*((volatile UINT32 *) (PAD_CTRL_REG_BASE + 0x83C))//switch between 1.8v and 3v

#define SIM_CLC           *((volatile UINT32 *) (AXI_AHB0_USIM_BASE + 0x0000))
#define SIM_ID            *((volatile UINT32 *) (AXI_AHB0_USIM_BASE + 0x0008))
#define SIM_RUN_CTRL     *((volatile UINT32 *) (AXI_AHB0_USIM_BASE + 0x0010))
#define SIM_CTRL          *((volatile UINT32 *) (AXI_AHB0_USIM_BASE + 0x0020))
#define SIM_BRF           *((volatile UINT32 *) (AXI_AHB0_USIM_BASE + 0x0024))
#define SIM_STATUS        *((volatile UINT32 *) (AXI_AHB0_USIM_BASE + 0x0028))
#define SIM_IRQEN         *((volatile UINT32 *) (AXI_AHB0_USIM_BASE + 0x002c))
#define SIM_RXSPC         *((volatile UINT32 *) (AXI_AHB0_USIM_BASE + 0x0030))
#define SIM_TXSPC         *((volatile UINT32 *) (AXI_AHB0_USIM_BASE + 0x0034))
#define SIM_CHTIMER       *((volatile UINT32 *) (AXI_AHB0_USIM_BASE + 0x0038))
#define SIM_CTRL2         *((volatile UINT32 *) (AXI_AHB0_USIM_BASE + 0x003c))
#define SIM_T1CTRL        *((volatile UINT32 *) (AXI_AHB0_USIM_BASE + 0x0040))
#define SIM_BWT           *((volatile UINT32 *) (AXI_AHB0_USIM_BASE + 0x0044))
#define SIM_TX            *((volatile UINT32 *) (AXI_AHB0_USIM_BASE + 0x0050))
#define SIM_RX            *((volatile UINT32 *) (AXI_AHB0_USIM_BASE + 0x0054))
#define SIM_INS           *((volatile UINT32 *) (AXI_AHB0_USIM_BASE + 0x0058))
#define SIM_P3            *((volatile UINT32 *) (AXI_AHB0_USIM_BASE + 0x005c))
#define SIM_SW1           *((volatile UINT32 *) (AXI_AHB0_USIM_BASE + 0x0060))
#define SIM_SW2           *((volatile UINT32 *) (AXI_AHB0_USIM_BASE + 0x0064))

#define SIM_IMSC          *((volatile UINT32 *) (AXI_AHB0_USIM_BASE + 0x0070))
#define SIM_RIS           *((volatile UINT32 *) (AXI_AHB0_USIM_BASE + 0x0074))
#define SIM_MIS           *((volatile UINT32 *) (AXI_AHB0_USIM_BASE + 0x0078))
#define SIM_ICR           *((volatile UINT32 *) (AXI_AHB0_USIM_BASE + 0x007c))
#define SIM_ISR           *((volatile UINT32 *) (AXI_AHB0_USIM_BASE + 0x0080))
#define SIM_DMA           *((volatile UINT32 *) (AXI_AHB0_USIM_BASE + 0x0084))
#define SIM_FIFO_IMSC    *((volatile UINT32 *) (AXI_AHB0_USIM_BASE + 0x0118))
#define SIM_FIFO_RIS     *((volatile UINT32 *) (AXI_AHB0_USIM_BASE + 0x011c))
#define SIM_FIFO_MIS     *((volatile UINT32 *) (AXI_AHB0_USIM_BASE + 0x0120))
#define SIM_FIFO_ICR     *((volatile UINT32 *) (AXI_AHB0_USIM_BASE + 0x0124))
#define SIM_FIFO_ISR     *((volatile UINT32 *) (AXI_AHB0_USIM_BASE + 0x0128))
#define SIM_FIFO_DMA     *((volatile UINT32 *) (AXI_AHB0_USIM_BASE + 0x012c))
#define SIM_FIFO_CFG     *((volatile UINT32 *) (AXI_AHB0_USIM_BASE + 0x010c))
#define SIM_RPS_STAT     *((volatile UINT32 *) (AXI_AHB0_USIM_BASE + 0x0108))
#define SIM_TPS_CTRL     *((volatile UINT32 *) (AXI_AHB0_USIM_BASE + 0x0104))
#define SIM_FFS_STAT     *((volatile UINT32 *) (AXI_AHB0_USIM_BASE + 0x0114))
#define SIM_MODE         *((volatile UINT32 *) (AXI_AHB0_USIM_BASE + 0x0100))

#if 0
#ifndef SOC_USIM
#define SIM_FIFO_TXD     *((volatile UINT32 *) (AXI_AHB0_USIM_BASE + 0x1000))
#define SIM_FIFO_RXD     *((volatile UINT32 *) (AXI_AHB0_USIM_BASE + 0x1400))
#else
#define SIM_FIFO_TXD     *((volatile UINT32 *) (AXI_AHB0_USIM_BASE + 0x200))
#define SIM_FIFO_RXD     *((volatile UINT32 *) (AXI_AHB0_USIM_BASE + 0x500))
 #endif
 #endif
 
#define SIM_FIFO_TXD     *((volatile UINT32 *) (axi_ahb0_usim_base_sim_fifo_txd))
#define SIM_FIFO_RXD     *((volatile UINT32 *) (axi_ahb0_usim_base_sim_fifo_rxd))

/**************************************************************************/
/* Structure of registers for Universal SIM				  				                              */
/*************************************************************************/
#ifndef EGOLDLITE
  typedef struct						// SIM Clock Register 
  {
          UINT32 SIM_DISR:1 ;
    /*const*/  UINT32 SIM_DISS:1 ;
      	  UINT32 SIM_SPEN:1 ;
      	  UINT32 SIM_EDIS:1 ;
      	  UINT32 SIM_SBWE:1 ;
      	  UINT32 SIM_FSOE:1 ;
    /*const*/  UINT32 _RESERVED_0:2;
		  UINT32 SIM_RMC:8;
	/*const*/  UINT32 _RESERVED_1:16;
  } tSIM_CLC;
#endif


   typedef struct						// USIM Run Control Register
  {
	  	  UINT32 RUN:1;
    /*const*/  UINT32 _RESERVED_0:31;
  }	tSIM_RUN_CTRL;


  typedef struct						// USIM Control Register
  {
	  	  UINT32 INCON:1;
	  	  UINT32 SIMT0:1;
	  	  UINT32 SIMIOL:1;
	  	  UINT32 SIMEN:1;
	  	  UINT32 SIMVCC:1;
	  	  UINT32 SIMRST:1;
	  	  UINT32 ERROFF:1;
	  	  UINT32 RPTOFF:1;
	  	  UINT32 APDWN:1;
	  	  UINT32 SIMPDWN:1;
	  	  UINT32 SIMON:1;
	  	  UINT32 CLKSEL:1;
	  	  UINT32 CLKHIGH:1;
	  	  UINT32 UARTON:1;
	  	  UINT32 SMCIOSWACT:1;
	  	  UINT32 SIMT1:1;
          #ifndef EGOLDLITE
	/*const*/  UINT32 _RESERVED_0:16;
          #endif
  }	tSIM_CTRL;

  typedef struct					   	// USIM Baud Rate Factor Register
  {
	  	  UINT32 BRF:7;
          #ifndef EGOLDLITE
	/*const*/  UINT32 _RESERVED_0:25;
          #else
	const UINT32 _RESERVED_0:9;
          #endif
  }	tSIM_BRF;

  typedef struct					// USIM Status Register
  {
   		  UINT32 UARTOK:1;
   		  UINT32 PARINT:1;
   		  UINT32 OVRRUN:1;
     	        UINT32 T0END:1;
    /*const*/  UINT32 SIMDET:1;
    	        UINT32 CHTIMEOUT:1;
   		  UINT32 T1END:1;
   		  UINT32 SIMT1PAR:1;
   		  UINT32 SIMT1BWT :1;
          #ifndef EGOLDLITE
	/*const*/  UINT32 _RESERVED_0:23;
          #else
	const UINT32 _RESERVED_0:7;
          #endif
  }	tSIM_STATUS;

  typedef struct					// USIM Interrupt Enable Register
  {
	      UINT32 ENOKINT:1;
	      UINT32 ENPAR:1;
	      UINT32 ENOVR:1;
	      UINT32 ENT0END:1;
	      UINT32 ENCHTIMER:1;
	      UINT32 ENBWTTIMER :1;
	      UINT32 ENT1END:1;
          #ifndef EGOLDLITE
	/*const*/  UINT32 _RESERVED_0:25;
          #else
	const UINT32 _RESERVED_0:9;
          #endif
  }	tSIM_IRQEN;
							
  typedef struct				   	  // USIM RX Spacing Register
  {
		  UINT32 RXSPC:8;
          #ifndef EGOLDLITE
	/*const*/  UINT32 _RESERVED_0:24;
          #else
	const UINT32 _RESERVED_0:8;
          #endif
  }	tSIM_RXSPC;
  
  typedef struct					// USIM TX Spacing Register
  {
	  	  UINT32 TXSPC:8;
          #ifndef EGOLDLITE
	/*const*/  UINT32 _RESERVED_0:24;
          #else
	const UINT32 _RESERVED_0:8;
          #endif
  }	tSIM_TXSPC;

#ifndef EGOLDLITE
  typedef struct					// USIM Work Waiting Timer Register
  {
   	  	  UINT32 CHTIMER:24;
    /*const*/  UINT32 _RESERVED_0:8;
  } tSIM_CHTIMER;

#else
  typedef struct					// USIM Work Waiting Timer Register LSB
  {
   	  	  UINT32 CHTIMER:16;
  } tSIM_CHTIMER0;

  typedef struct					// USIM Work Waiting Timer Register MSB
  {
   	  	  UINT32 CHTIMER:8;
    const UINT32 _RESERVED_0:8;
  } tSIM_CHTIMER1;
#endif

#ifndef EGOLDLITE
  typedef struct						// USIM 2 (2nd SIM) Control Register
  {  
     	  UINT32 SIM2SEL:1;
     	  UINT32 SIM2ON:1;
     	  UINT32 CLK2HIGH:1;
     	  UINT32 SIM1STDBY:1;
     	  UINT32 SIM2STDBY:1;
    /*const*/  UINT32 _RESERVED_0:27;
  } tSIM_CTRL2;
#endif

  typedef struct						// USIM T=1 Control Register
  {  
	  	  UINT32 SIMT1LEN:8;
	  	  UINT32 T1START:1;
	  	  UINT32 BGTEN:1;
	  	  UINT32 BWT_START:1;
          #ifndef EGOLDLITE
	/*const*/  UINT32 _RESERVED_0:21;
          #else
	const UINT32 _RESERVED_0:5;
          #endif
  }	tSIM_T1CTRL; 

#ifndef EGOLDLITE
  typedef struct					   		// USIM Block Waiting Timer
  {
	  	  UINT32 BWT:24;
	/*const*/  UINT32 _RESERVED_0:8;
  }	tSIM_BWT;
#else
  typedef struct					      	// USIM Block Waiting Timer LSB
  {
	  	  UINT32 BWT:16;
  }	tSIM_BWT1;

 typedef struct					   		// USIM Block Waiting Timer MSB
  {
	  	  UINT32 BWT:8;
	const UINT32 _RESERVED_0:8;
  }	tSIM_BWT2;
#endif

  typedef struct							// USIM instruction class register
  {
	  	  UINT32 INS:8;
	  	  UINT32 INSDIR:1;	  
          #ifndef EGOLDLITE
	/*const*/  UINT32 _RESERVED_0:23;
          #else
	const UINT32 _RESERVED_0:7;
          #endif
  }	tSIM_INS;
							   
  typedef struct							// USIM parameter 3 register
  {							 
	  	  UINT32 P3:8;
          #ifndef EGOLDLITE
	/*const*/  UINT32 _RESERVED_0:24;
          #else
	const UINT32 _RESERVED_0:8;
          #endif
  }	tSIM_P3; 

  typedef struct					// USIM Status Word 1 Register
  {
	/*const*/  UINT32 SW1:8;
          #ifndef EGOLDLITE
	/*const*/  UINT32 _RESERVED_0:24;
          #else
	const UINT32 _RESERVED_0:8;
          #endif
  }	tSIM_SW1;
					 
  typedef struct					// USIM Status Word 2 Register
  {
	/*const*/  UINT32 SW2:8 ;
          #ifndef EGOLDLITE
	/*const*/  UINT32 _RESERVED_0:24;
          #else
	const UINT32 _RESERVED_0:8;
          #endif
  }	tSIM_SW2;


  typedef struct				     // USIM transmit data register
  {
	  	  UINT32 SIMTX:8;
          #ifndef EGOLDLITE
	/*const*/  UINT32 _RESERVED_0:24;
          #else
	const UINT32 _RESERVED_0:8;
          #endif
  }	tSIM_TX; 

  typedef struct					// USIM receive data register
  {
	/*const*/  UINT32 SIMRX:8;
          #ifndef EGOLDLITE
	/*const*/  UINT32 _RESERVED_0:24;
          #else
	const UINT32 _RESERVED_0:8;
          #endif
  } tSIM_RX;


#ifdef SGOLD3
  typedef struct					// USIM transmit packet size  register
  {
	      UINT32 SIMTPS:9;
	/*const*/  UINT32 _RESERVED_0:23;
  } tSIM_TPS_CTRL;


  typedef struct					// USIM receive packet size status register
  {
	/*const*/  UINT32 SIMRPS:9;
	/*const*/  UINT32 _RESERVED_0:23;
  } tSIM_RPS_STAT;

  
    typedef struct					// USIM FIFO config register
  {
	      UINT32 SIMRXBS:2;
	/*const*/  UINT32 _RESERVED_0:2;
	      UINT32 SIMTXBS:2;
	/*const*/  UINT32 _RESERVED_1:2;
	      UINT32 SIMRXFA:2;
	/*const*/  UINT32 _RESERVED_2:2;
	      UINT32 SIMTXFA:2;
	/*const*/  UINT32 _RESERVED_3:2;
	      UINT32 SIMRXFC:1;
	      UINT32 SIMTXFC:1;
 	/*const*/  UINT32 _RESERVED_4:14;
  } tSIM_FIFO_CFG;


  typedef struct					// USIM FIFO fill state register
  {
	/*const*/  UINT32 SIMFFS:4;
	/*const*/  UINT32 _RESERVED_0:28;
  } tSIM_FFS_STAT;


  typedef struct					// USIM Switch to legacy mode
  {
	      UINT32 SIMLEGACY_N:1;
	/*const*/  UINT32 _RESERVED_0:31;
  } tSIM_MODE;
#endif

						
#ifndef EGOLDLITE
  typedef struct					// USIM Interrupt Mask Control Register
  {								
	  	  UINT32 ERR:1;
	  	  UINT32 IN:1;
	  	  UINT32 OK:1;
	/*const*/  UINT32 _RESERVED_0:29;
  }	tSIM_IMSC;
 	
  typedef struct 					// USIM Raw Interrupt Status Register
  {
	/*const*/  UINT32 ERR:1;
	/*const*/  UINT32 IN:1;
	/*const*/  UINT32 OK:1;
	/*const*/  UINT32 _RESERVED_0:29;
  }	tSIM_RIS;

  	
  typedef struct 					// USIM Masked Interrupt Status Register
  {
	/*const*/  UINT32 ERR:1;
	/*const*/  UINT32 IN:1;
	/*const*/  UINT32 OK:1;
	/*const*/  UINT32 _RESERVED_0:29;
  }	tSIM_MIS;	


  typedef struct 	
  {										// USIM Interrupt Clear Register
	  	  UINT32 ERR:1;
	  	  UINT32 IN:1;
	  	  UINT32 OK:1;
	/*const*/  UINT32 _RESERVED_0:29;
  }	tSIM_ICR;


  typedef struct 						// USIM Interrupt Set Register
  {
	  	  UINT32 ERR:1;
	  	  UINT32 IN:1;
	  	  UINT32 OK:1;
	/*const*/  UINT32 _RESERVED_0:29;
  }	tSIM_ISR;

					
  typedef struct 						  // USIM DMA Control Register
  {
	  	  UINT32 OKEN:1;
	/*const*/  UINT32 _RESERVED_0:31;
  }	tSIM_DMA;						    

  typedef struct					// USIM Interrupt Mask Control Register FIFO mode
  {								
	  	  UINT32 RX_LSREQ:1;
	   	  UINT32 TX_LSREQ:1;
	  	  UINT32 RX_SREQ:1;
	  	  UINT32 TX_SREQ:1;
	  	  UINT32 RX_LBREQ:1;
	  	  UINT32 TX_LBREQ:1;
	  	  UINT32 RX_BREQ:1;
	  	  UINT32 TX_BREQ:1;
	  	  UINT32 TXF_OFL_irq:1;
	  	  UINT32 RXF_UFL_irq:1;
	/*const*/  UINT32 _RESERVED_0:22;
  }	tSIM_FIFO_IMSC;

  typedef struct 					// USIM Raw Interrupt Status Register
  {
	/*const*/  UINT32 RX_LSREQ:1;
	/*const*/  UINT32 TX_LSREQ:1;
	/*const*/  UINT32 RX_SREQ:1;
	/*const*/  UINT32 TX_SREQ:1;
	/*const*/  UINT32 RX_LBREQ:1;
	/*const*/  UINT32 TX_LBREQ:1;
	/*const*/  UINT32 RX_BREQ:1;
	/*const*/  UINT32 TX_BREQ:1;
	/*const*/  UINT32 TXF_OFL_irq:1;
	/*const*/  UINT32 RXF_UFL_irq:1;
	/*const*/  UINT32 _RESERVED_0:22;
  }	tSIM_FIFO_RIS;


  typedef struct 					// USIM Masked Interrupt Status Register
  {
	/*const*/  UINT32 RX_LSREQ:1;
	/*const*/  UINT32 TX_LSREQ:1;
	/*const*/  UINT32 RX_SREQ:1;
	/*const*/  UINT32 TX_SREQ:1;
	/*const*/  UINT32 RX_LBREQ:1;
	/*const*/  UINT32 TX_LBREQ:1;
	/*const*/  UINT32 RX_BREQ:1;
	/*const*/  UINT32 TX_BREQ:1;
	/*const*/  UINT32 TXF_OFL_irq:1;
	/*const*/  UINT32 RXF_UFL_irq:1;
	/*const*/  UINT32 _RESERVED_0:22;
  }	tSIM_FIFO_MIS;


  typedef struct					    // USIM Interrupt Clear Register FIFO mode
  {								
	  	  UINT32 RX_LSREQ:1;
	   	  UINT32 TX_LSREQ:1;
	  	  UINT32 RX_SREQ:1;
	  	  UINT32 TX_SREQ:1;
	  	  UINT32 RX_LBREQ:1;
	  	  UINT32 TX_LBREQ:1;
	  	  UINT32 RX_BREQ:1;
	  	  UINT32 TX_BREQ:1;
	  	  UINT32 TXF_OFL_irq:1;
	  	  UINT32 RXF_UFL_irq:1;
	/*const*/  UINT32 _RESERVED_0:22;
  }	tSIM_FIFO_ICR;

  typedef struct					    // USIM Interrupt SET Register FIFO mode
  {								
	  	  UINT32 RX_LSREQ:1;
	   	  UINT32 TX_LSREQ:1;
	  	  UINT32 RX_SREQ:1;
	  	  UINT32 TX_SREQ:1;
	  	  UINT32 RX_LBREQ:1;
	  	  UINT32 TX_LBREQ:1;
	  	  UINT32 RX_BREQ:1;
	  	  UINT32 TX_BREQ:1;
	  	  UINT32 TXF_OFL_irq:1;
	  	  UINT32 RXF_UFL_irq:1;
	/*const*/  UINT32 _RESERVED_0:22;
  }	tSIM_FIFO_ISR;

  typedef struct					    // USIM DMA Control Register FIFO mode
  {								
	  	  UINT32 RX_LSREQ:1;
	   	  UINT32 TX_LSREQ:1;
	  	  UINT32 RX_SREQ:1;
	  	  UINT32 TX_SREQ:1;
	  	  UINT32 RX_LBREQ:1;
	  	  UINT32 TX_LBREQ:1;
	  	  UINT32 RX_BREQ:1;
	  	  UINT32 TX_BREQ:1;
	/*const*/  UINT32 _RESERVED_0:24;
  }	tSIM_FIFO_DMA;
#endif

/****************************************************************************
* 	                                        Constants
****************************************************************************/

/****************************************************************************
* 	                                        Global  Variables
****************************************************************************/
#if 0
volatile tSIM_DMA  sSIM_DMA =*((volatile tSIM_DMA  *) (AXI_AHB0_USIM_BASE + 0x0084));
volatile tSIM_T1CTRL sSIM_T1CTRL=*((volatile tSIM_T1CTRL *) (AXI_AHB0_USIM_BASE + 0x0040));
volatile tSIM_CTRL2 sSIM_CTRL2=*((volatile tSIM_CTRL2 *) (AXI_AHB0_USIM_BASE + 0x003c));
volatile tSIM_CTRL  sSIM_CTRL=*((volatile tSIM_CTRL *) (AXI_AHB0_USIM_BASE + 0x0020));
#endif
/****************************************************************************
* 	                                        Function Prototypes
****************************************************************************/
#endif/*SIM_REG_H*/

