/************************************************************************
* Ȩ (C)2007,ͨѶɷ޹˾
* 
* ļƣ ps_hisr.h
* ļʶ 
* ժҪ Ҫ滻nucleusӿΪOSSصĽӿ
*
* ޸     汾     ޸ı     ޸	     ޸      
* -----------------------------------------------------------------------
* 2008/06/27  	    V0.5		                                               
************************************************************************/

#ifndef MS_HISR
#define MS_HISR

/**************************************************************************
 *                        ͷļ                                      *
 **************************************************************************/
 #include "base_api.h"

/*****************************************************************************
* Typedef hisr_type_f
*****************************************************************************/
typedef VOID (*hisr_type_f) (VOID);

/*****************************************************************************
* Typedef ms_hisr_t
*****************************************************************************/
typedef struct ms_hisr_s
{
    /* hisr handling */
    volatile UINT32   event;   /* event staring the hisr */
    volatile UINT8     active;  /* hisr is active */
    
    NU_HISR   hisr_cb;      /* receive HISR structure */
    VOID     *hisr_device;  /* must be placed directly after hisr_cb */
    VOID     *hisr_stack;   /* enable with size */ 
} ms_hisr_t;


/*****************************************************************************
 * Function:     ms_hisr_create
 *-----------------------------------------------------------------------------
 * Purpose:   create a new hisr   
 *
 * Parameters:  mshisr pointer to hisrtype
 *              name  name
 *              size  of the new hisr
 *              priority hisr priority
 *              hisr_type_f hisr function 
 *              hisr_device device to call
 *
 * Returns:     void
 *
 * Remarks:     
 *****************************************************************************/

extern  VOID  ms_hisr_create(ms_hisr_t *mshisr, CHAR *name, SINT32 size,
                               SINT32 priority,  hisr_type_f used_hisr,
                               VOID *hisr_device);


/*****************************************************************************
 * Function:     ms_hisr_free
 *-----------------------------------------------------------------------------
 * Purpose:      frees an created hisr
 *
 * Parameters:   mshisr
 *
 * Returns:      
 *
 * Remarks:      
 *****************************************************************************/

// P98C-YXS extern  VOID  ms_hisr_free(ms_hisr_t *mshisr);


/*****************************************************************************
 * Function:     ms_hisr_get_io_associated_to_hisr
 *-----------------------------------------------------------------------------
 * Purpose:      Determines the io descriptor which contains the active HISR
 *
 * Parameters:   None
 *
 * Returns:      The UART descriptor
 *
 * Remarks:      - NU_Current_HISR_Pointer() is a very simple Nucleus function
 *****************************************************************************/

// P98C-YXS extern  VOID  *ms_hisr_get_associated(VOID);


/*****************************************************************************
 * Function:     ms_hisr_activate
 *-----------------------------------------------------------------------------
 * Purpose:   activates the hisr    
 *
 * Parameters:  mshisr pointer to hisrtype
 *
 * Returns:    void  
 *
 * Remarks:    none  
 *****************************************************************************/

extern  VOID  ms_hisr_activate(ms_hisr_t *mshisr);

/*****************************************************************************
 * Function:     ms_hisr_start
 *-----------------------------------------------------------------------------
 * Purpose:    starts the hisr according to the settings of 
 *               event and hisr_active. The event will be set
 *
 * Parameters:  mshisr pointer to hisrtype
 *              event event which has been set
 *
 * Returns:    void  
 *
 * Remarks:    none  
 *****************************************************************************/

// P98C-YXS extern  VOID  ms_hisr_start(ms_hisr_t *mshisr, UINT32 event);


/*****************************************************************************
 * Function:    ms_hisr_reset_event
 *-----------------------------------------------------------------------------
 * Purpose:     resets the hisr event int the hisr 
 *             
 *
 * Parameters:  mshisr pointer to hisrtype
 *              event event which has been reset
 *
 * Returns:    void  
 *
 * Remarks:    none  
 *****************************************************************************/

// P98C-YXS extern  VOID  ms_hisr_reset_event(ms_hisr_t *mshisr, UINT32 event);


/*****************************************************************************
 * Function:    ms_hisr_active
 *-----------------------------------------------------------------------------
 * Purpose:     sets the hisr active flag according to the 
 *              status of the hisr             
 *
 * Parameters:  mshisr pointer to hisrtype
 *              active  1 hisr is running
 *                      0 hisr is stopped
 *
 * Returns:    void  
 *
 * Remarks:    none  
 *****************************************************************************/

// P98C-YXS extern  VOID  ms_hisr_active(ms_hisr_t *mshisr, UINT8 active); 

extern  VOID ms_hisr_wait_sem(ms_hisr_t *mshisr);

#endif 


