/************************************************************************
* Ȩ(C)2007,ͨѶɷ޹˾
* ģ   ýģ
* ļƣ zte_stream.c    
* ļʶ 
* ժҪ ýƵ뺯ʵ
*
* ޸      汾     ޸ı       ޸       ޸      
* ----------------------------------------------------------------------
* 2009/6/22     1.0                                               
* 2012/07/18    P98CV3.2.3B01      P98C-CXX-0001           EC:617001630060ýͷ
************************************************************************/
   
/**************************************************************************
 *                        ͷļ                                      *
 **************************************************************************/
#include "pub.h"
#include "zte_display.h"
#include "zte_audioEx.h"
#include "drv_api.h"
#include "zte_dv.h"
#include "oss_api.h"
#include "ZMF_API.h"
#include "ZMF_OutDef.h"
#include "amr_alg.h"
#include "zMsp_Com.h"
#include "zte_stream.h"
#include "zte_osd.h"

/**************************************************************************
 *                                                                    *
 **************************************************************************/
/* Ƶ״̬ */
typedef enum
{
    STREAM_VIDEO_STATE_IDLE = 0,    /* ״̬               */
    STREAM_VIDEO_STATE_OPEN,        /* Ѿ             */
    STREAM_VIDEO_STATE_WORKING      /* ״̬         */ 
}STREAM_VIDEO_PLAY_STATE;

/* Ƶ״̬ */
typedef enum
{
    STREAM_AUDIO_STATE_IDLE = 0,    /* ״̬               */
    STREAM_AUDIO_STATE_OPEN,        /* Ѿ             */
    STREAM_AUDIO_STATE_WORKING      /* ״̬         */ 
}STREAM_AUDIO_PLAY_STATE;

#define AAC_DECODE_LEN   4096       /* AAC(˫)һ֡ */

/* Ƶ֡ */
typedef enum
{
    STREAM_VIDEO_F15 = 15,        /* ÿ15֡  */
    STREAM_VIDEO_F25 = 25         /* ÿ25֡  */
}STREAM_VIDEO_FRAMES;

/* ýģڲʹõĴ */
enum
{
    STREAM_OP_SUCCESS           = 0,       /* Ƶ           */
    STREAM_VIDEO_OP_ERROR       = -1,      /* ƵһԴ     */
    STREAM_VIDEO_OP_BUFFER_ERR  = -2,      /* ײBuffer     */
    STREAM_VIDEO_OP_DEVICE_ERR  = -3,      /* ײ豸쳣       */
    STREAM_VIDEO_OP_DECODE_ERR  = -4,      /* Ƶ           */
    STREAM_VIDEO_OP_POSTPPU_ERR = -5       /* Ƶ         */    
};
/**************************************************************************
 *                                                                      *
 **************************************************************************/
#define STREAM_VIDEO_DEC_MUTEX "stream_video_dec_mutex"  /* ӿýӿڻ */
#define MAX_STREAM_HEADER_LEN  32
/**************************************************************************
 *                                                                 *
 **************************************************************************/
/* ýģƵϢ */
typedef struct _T_Stream_Audio_ControlParam
{
    UINT32                     uiAudioFd;           /* Ƶ豸ID         */
    BOOL                       bFirstAudioDecFlage; /* ǷǵһƵ   */
    UINT32                     uiAudioBufsize;      /* ƵС */
    T_MediaAudioDecHandle     *pAudioDecHandle;     /* Ƶָ   */
    EMediaAudioType            eMediaAType;         /* Ƶʽ       */
    DD_STREAM_AUDIO_SET        stream_param;        /* ƵϢ   */
    T_ZDrvAudio_Channel        tChannelMode;        /* Ƶ豸ͨ   */
    T_ZDrvAudio_SampleRate     tSampleRate;         /* Ƶ         */
}T_Stream_Audio_ControlParam;

/* ýģƵϢ */
typedef struct _T_Stream_Video_ControlParam
{
    UINT32               uiVideoFd;           /* Ƶ豸ID            */
    BOOL                 bFirstVideoDecFlage; /* ǷǵһƵ   */
    RECT_T               play_rect;           /* ûõƵʾ     */
    RECT_T               real_play_rect;      /* ʵʵƵʾ    */   
    T_ZDrvVideo_BufInfo  tDftDecBuf;          /* ƵĹ̶Buffer */
    STREAM_VIDEO_FORMAT  eStreamVideoType;    /* Ƶʽ              */
    DecHandle            pVideoDecHandle;     /* Ƶָ      */
    UINT32               uiYOffset;           /* ȫYƫ */
    UINT32               uiUOffset;           /* ȫUƫ */
    UINT32               uiVOffset;           /* ȫVƫ */
    T_ZDrv_RotateType    eRotate;             /* ûõת      */
    ZOSS_MUTEX_ID        pVideoDecMutexID;    /* ӿýӿڻ   */
}T_Stream_Video_ControlParam;                 

typedef struct
{
    UINT8   *data_buffer;
    UINT32   data_length;
    UINT8    write_times;
    BOOL     bfirstframe;
}STREAM_HEADER_DATA;

/**************************************************************************
 *                           ֲԭ                                  *
 **************************************************************************/
static UINT8 zMspStream_AmrIF1GetFrameType(UINT32 uiDataLen);
static STREAM_VIDEO_FORMAT zMspStream_Video_CheckFrame(STREAM_DATA *param);
static VOID  zMspStream_FillDecParam(EMediaAudioType  eMediaAType, UINT8           *pRawData, 
                                     UINT32           uiDataLen,   T_ZMFOutPutUnit *pOutUnit);
static DecHandle zMspStream_OpenVideoDecoder(STREAM_VIDEO_FORMAT eStreamVideoType, STREAM_DATA *param);
static DecHandle zMspStream_VideoDecoderOpen(STREAM_DATA *param, T_ZDrvVideo_CodecStandard eVideoType);
static SINT32 zMspStream_VideoDecodeProc(STREAM_DATA *param);
static VOID zMspStream_RefreshYUVOffset(VOID);
static VOID zMspStream_VideoDecoderClose(DecHandle pHandle);
static VOID zMspStream_CloseVideoDecoder(STREAM_VIDEO_FORMAT eStreamVideoType, DecHandle pHandle);
static T_ZDrv_RotateType zMspStream_SetVideoRotate(DROTATION_MODE_E  rotate);
/**************************************************************************
 *                           ȫֱ                                      *
 **************************************************************************/
 /* ýƵ״̬ */
 static STREAM_VIDEO_PLAY_STATE    g_StreamVideoState = STREAM_VIDEO_STATE_IDLE;

 /* ýƵ״̬ */
 static STREAM_AUDIO_PLAY_STATE    g_StreamAudioState = STREAM_AUDIO_STATE_IDLE;
  
 static T_Stream_Audio_ControlParam g_StreamAudioCtlParam;
 static T_Stream_Video_ControlParam g_StreamVideoCtlParam;

 static STREAM_HEADER_DATA          g_Video_Header_Data;

static UINT32     uiVideoCount = 0;
static UINT32     uiAudioCount = 0;
/**************************************************************************
 *                     ȫֺʵ                                      *
 **************************************************************************/
/**
 * ƣ Stream_Video_Open
 *  ýƵ豸
 * ˵ 
 *   ֵ 豸ɹDCAMERA_OP_SUCCESS;򷵻DCAMERA_OP_ERROR
 * ˵ 
 */
DCAMERA_RETURN_VALUE_E Stream_Video_Open(void)
{
    SINT32 iVideoFd = -1;
    UINT32 uiFrames = STREAM_VIDEO_F15;
    SINT32 iRet     = -1;
    
    zOss_Printf(1, 1, "Stream_Video_Open --start ----cyx!!!!");
    /* жƵģʼ״̬ΪIDLE̬˳ */
    if(g_StreamVideoState != STREAM_VIDEO_STATE_IDLE)
    {
        zMspCom_Print();
        
        return DCAMERA_OP_ERROR;
    }

    /* Video豸 */
    iVideoFd = zMspCom_VideoOpen();
    if(iVideoFd < 0)
    {
        zMspCom_Print();
        
        return DCAMERA_OP_ERROR;
    }

    iRet = Zte_OsdInit((UINT32)iVideoFd, uiFrames);
    if(iRet != MSP_COM_OP_SUCCESS)
    {
        zMspCom_Print();
        
        /* رVideo豸 */
        zMspCom_VideoClose();
        
        return DCAMERA_OP_ERROR;        
    }
    
    //zMspOsd_SetUseDefTransColor(TRUE);
    
    /* ʼȫֱ */
    zOss_Memset(&g_StreamVideoCtlParam, 0, sizeof(T_Stream_Video_ControlParam));
    zOss_Memset(&(g_Video_Header_Data), 0, sizeof(g_Video_Header_Data));
    
    g_StreamVideoCtlParam.bFirstVideoDecFlage = TRUE;
    g_Video_Header_Data.bfirstframe           = TRUE;
    
    /* Ƶ豸ID */
    g_StreamVideoCtlParam.uiVideoFd = (UINT32)iVideoFd;
    
    /* Ƶ״̬Ϊ״̬ */
    g_StreamVideoState = STREAM_VIDEO_STATE_OPEN;
    
    zOss_Printf(1, 1, "Stream_Video_Open --end success ----cyx!!!!");
    return DCAMERA_OP_SUCCESS;
}

/**
 * ƣ Stream_Video_Close
 *  ͷý򿪵Ƶ豸
 * ˵ 
 *   ֵ ͷ豸ɹDCAMERA_OP_SUCCESS;򷵻DCAMERA_OP_ERROR
 * ˵ 
 */
DCAMERA_RETURN_VALUE_E Stream_Video_Close(void)
{

    zOss_Printf(1, 1, "Stream_Video_Close --start ----cyx!!!!");
    /* ״̬ */
    if(g_StreamVideoState != STREAM_VIDEO_STATE_OPEN && g_StreamVideoState != STREAM_VIDEO_STATE_WORKING)
    {
        zMspCom_Print();
        
        return DCAMERA_OP_ERROR;
    }

    /* رƵ */
    zMspStream_CloseVideoDecoder(g_StreamVideoCtlParam.eStreamVideoType, g_StreamVideoCtlParam.pVideoDecHandle);

    /* رVideo豸 */
    zMspCom_VideoClose();
    /* رOSD */
    Zte_OsdUnInit();
    
    /* λƵ豸ID */
    g_StreamVideoCtlParam.uiVideoFd = 0;

    g_StreamVideoCtlParam.bFirstVideoDecFlage = TRUE;
	g_Video_Header_Data.bfirstframe           = TRUE;

    g_StreamVideoCtlParam.eStreamVideoType = STREAM_VIDEO_NONE;
    
    /* λƵ״̬ΪIDLE״̬ */
    g_StreamVideoState = STREAM_VIDEO_STATE_IDLE;
    
    zOss_Printf(1, 1, "Stream_Video_Close --end success ----cyx!!!!");
    
    return DCAMERA_OP_SUCCESS; 
}

/**
 * ƣ Stream_Video_Init
 *  ýģʼ
 * ˵ 
 *   ֵ ɹDCAMERA_OP_SUCCESS;򷵻DCAMERA_OP_ERROR
 * ˵ 
 */
DCAMERA_RETURN_VALUE_E Stream_Video_Init(STREAM_VIDEO_FORMAT eStreamVideoType)
{
    zOss_Printf(1, 1, "Stream_Video_Init --start ----cyx!!!!");
    if(eStreamVideoType < STREAM_VIDEO_H263 || eStreamVideoType > STREAM_VIDEO_MP4)
    {
        zMspCom_Print();	
        return DCAMERA_OP_ERROR;
    }

    g_StreamVideoCtlParam.eStreamVideoType = eStreamVideoType;
    
    g_StreamVideoCtlParam.pVideoDecMutexID = zOss_CreateMutex(STREAM_VIDEO_DEC_MUTEX, ZOSS_NO_INHERIT);
    if(NULL == g_StreamVideoCtlParam.pVideoDecMutexID)
    {
	zMspCom_Print();
        return DCAMERA_OP_ERROR;         
    }

    zOss_Printf(1, 1, "Stream_Video_Init --end success ----cyx!!!!");
    return DCAMERA_OP_SUCCESS; 
}

/**
 * ƣ Stream_Video_Release
 *  ͷýģԴ
 * ˵ 
 *   ֵ ɹDCAMERA_OP_SUCCESS;򷵻DCAMERA_OP_ERROR
 * ˵ ʼɶʹ
 */
DCAMERA_RETURN_VALUE_E Stream_Video_Release(void)
{
    UINT32 uiRet = 0;

    zOss_Printf(1, 1, "Stream_Video_Release --start ----cyx!!!!");
	if(g_StreamVideoCtlParam.pVideoDecMutexID != NULL)
    {
        uiRet = zOss_DeleteMutex(g_StreamVideoCtlParam.pVideoDecMutexID);
        if(ZOSS_SUCCESS != uiRet)
        {
    	    zMspCom_Print();
            return DCAMERA_OP_ERROR;
        }
        g_StreamVideoCtlParam.pVideoDecMutexID = NULL;
	}
        /* P98C-CXX-0001 2012-7-18EC:617001630060ýͷ BEGIN */
	if( g_Video_Header_Data.data_buffer != NULL)
	{
	    zOss_Free(g_Video_Header_Data.data_buffer);
	    g_Video_Header_Data.data_buffer = NULL;
	}
        /* P98C-CXX-0001 2012-7-18EC:617001630060ýͷ END */
    zOss_Printf(1, 1, "Stream_Video_Release --end success ----cyx!!!!");
    return DCAMERA_OP_SUCCESS; 
}

/**
 * ƣ Stream_Video_Decode
 *  ýƵ롢
 * ˵ (IN)param:Ƶݽṹָ룬ָ볤
 *   ֵ ɹDCAMERA_OP_SUCCESS;򷵻DCAMERA_OP_ERROR
 * ˵ úṩҰƵ
 */
DCAMERA_RETURN_VALUE_E Stream_Video_Decode(STREAM_DATA *param)
{
    UINT32               uiRet             = 0;
    SINT32               iRet              = -1;
    RECT_T               tModifiedPlayRect = {0, };     
    T_ZDrvVideo_DecCfg  *pDecCfg           = NULL;
    
    zOss_Printf(1, 1, "Stream_Video_Decode --start ----cyx!!!!");
    
    /* ״̬ */
    if(g_StreamVideoState != STREAM_VIDEO_STATE_OPEN && g_StreamVideoState != STREAM_VIDEO_STATE_WORKING)
    {
        zMspCom_Print();
        
        return DCAMERA_OP_ERROR;
    }
    
    /*  */
    if(NULL == param || NULL == param->data_buffer)
    {
        zMspCom_Print();
        
        return DCAMERA_OP_ERROR;
    }

    uiRet = zOss_GetMutex(g_StreamVideoCtlParam.pVideoDecMutexID, ZOSS_WAIT_FOREVER);
    if(ZOSS_SUCCESS != uiRet)
    {
        zMspCom_Print();
        
        return DCAMERA_OP_ERROR;
    }

    /* һνʱҪʼ */
    if(g_StreamVideoCtlParam.bFirstVideoDecFlage)
    {
        /* ݴƵȷƵʽ */
        g_StreamVideoCtlParam.eStreamVideoType = zMspStream_Video_CheckFrame( param);

        if(g_StreamVideoCtlParam.eStreamVideoType == STREAM_VIDEO_H264)
        {
            if(g_Video_Header_Data.data_buffer == NULL
                && g_Video_Header_Data.write_times == 0)
            {
                g_Video_Header_Data.data_buffer = (UINT8 *)zOss_Malloc(MAX_STREAM_HEADER_LEN);
		/* P98C-CXX-0001 2012-7-18EC:617001630060ýͷ BEGIN */
		if( g_Video_Header_Data.data_buffer  == NULL)
		{
		    zOss_ASSERT(0);
		}
		/* P98C-CXX-0001 2012-7-18EC:617001630060ýͷ END */
                zOss_Memcpy(g_Video_Header_Data.data_buffer, param->data_buffer, param->data_length);
                g_Video_Header_Data.data_length = param->data_length;
                g_Video_Header_Data.write_times++;

				uiRet = zOss_PutMutex(g_StreamVideoCtlParam.pVideoDecMutexID);

                return DCAMERA_OP_SUCCESS;
            }
            else if(g_Video_Header_Data.write_times == 1)
            {
                zOss_Memcpy(g_Video_Header_Data.data_buffer + g_Video_Header_Data.data_length, 
                             param->data_buffer, param->data_length);
                g_Video_Header_Data.data_length += param->data_length;
                g_Video_Header_Data.write_times++;

				uiRet = zOss_PutMutex(g_StreamVideoCtlParam.pVideoDecMutexID);

                return DCAMERA_OP_SUCCESS;
            }
        }
	
        /* Ƶ*/
        if(g_StreamVideoCtlParam.eStreamVideoType == STREAM_VIDEO_H264
			&& g_Video_Header_Data.data_buffer    != NULL)
        {
            STREAM_DATA header_param = {0};
            
            header_param.data_buffer = g_Video_Header_Data.data_buffer;
            header_param.data_length = g_Video_Header_Data.data_length;
            g_StreamVideoCtlParam.pVideoDecHandle = zMspStream_OpenVideoDecoder(
                                                g_StreamVideoCtlParam.eStreamVideoType,
                                                &header_param);
        }
        else
        {
            g_StreamVideoCtlParam.pVideoDecHandle = zMspStream_OpenVideoDecoder(
                                                g_StreamVideoCtlParam.eStreamVideoType,
                                                param);
        }
        
        if(NULL == g_StreamVideoCtlParam.pVideoDecHandle)
        {
            zMspCom_Print();
            uiRet = zOss_PutMutex(g_StreamVideoCtlParam.pVideoDecMutexID);
            if(ZOSS_SUCCESS != uiRet)
            {
			    zMspCom_Print();
                return DCAMERA_OP_ERROR;
            }

            return DCAMERA_OP_ERROR;
        }

        pDecCfg = (T_ZDrvVideo_DecCfg  *)g_StreamVideoCtlParam.pVideoDecHandle;
        
        /* Ƶʾ */
        if(g_StreamVideoCtlParam.play_rect.width != 0
           && g_StreamVideoCtlParam.play_rect.height != 0)
        {
            iRet = zMspCom_VideoPlayRectModify(&tModifiedPlayRect, &(g_StreamVideoCtlParam.play_rect), 
                                           pDecCfg->tOutput.uiWidth, pDecCfg->tOutput.uiHeight);
            if(iRet != MSP_COM_OP_SUCCESS)
            {
                /* رƵ */
                zMspStream_CloseVideoDecoder(g_StreamVideoCtlParam.eStreamVideoType, g_StreamVideoCtlParam.pVideoDecHandle);
                zMspCom_Print();
                uiRet = zOss_PutMutex(g_StreamVideoCtlParam.pVideoDecMutexID);
                if(ZOSS_SUCCESS != uiRet)
                {
	            zMspCom_Print();
                    return DCAMERA_OP_ERROR;
                }

                return DCAMERA_OP_ERROR;
            }
        }
        else
        {
            tModifiedPlayRect = g_StreamVideoCtlParam.play_rect;
        }

        g_StreamVideoCtlParam.real_play_rect = tModifiedPlayRect;
        
        /* (ȫģʽ)Ƶĺʱƫ꣬
         * Чʣÿνظ 
         */
        zMspStream_RefreshYUVOffset();
        
        g_StreamVideoCtlParam.bFirstVideoDecFlage = FALSE;
	    uiVideoCount = 0;
    }

    /* һ֡Ƶ, */
    iRet = zMspStream_VideoDecodeProc(param);
    if(iRet != STREAM_OP_SUCCESS)
    {
        /* رƵ */
        zMspStream_CloseVideoDecoder(g_StreamVideoCtlParam.eStreamVideoType, g_StreamVideoCtlParam.pVideoDecHandle);

        g_StreamVideoCtlParam.bFirstVideoDecFlage = TRUE;
		g_Video_Header_Data.bfirstframe 		  = TRUE;

        zMspCom_Print();
        uiRet = zOss_PutMutex(g_StreamVideoCtlParam.pVideoDecMutexID);   
        if(ZOSS_SUCCESS != uiRet)
        {
            zMspCom_Print();
            return DCAMERA_OP_ERROR;
        }
        
        return DCAMERA_OP_ERROR;        
    }

    g_StreamVideoState = STREAM_VIDEO_STATE_WORKING;

    uiRet = zOss_PutMutex(g_StreamVideoCtlParam.pVideoDecMutexID);
	
    uiVideoCount++;
	
    if(ZOSS_SUCCESS != uiRet)
    {
        zMspCom_Print();
        return DCAMERA_OP_ERROR;
    }

    zOss_Printf(1, 1, "Stream_Video_Decode --end success ----cyx!!!!");
    return DCAMERA_OP_SUCCESS;     
}

/**
 * ƣ Stream_Video_SetParam
 *  ýƵá
 * ˵ (IN)param:òƵʾתǶ
 *   ֵ ɹDCAMERA_OP_SUCCESS;򷵻DCAMERA_OP_ERROR
 * ˵ 
 */
DCAMERA_RETURN_VALUE_E Stream_Video_SetParam(STREAM_SET_PARAM *param)
{
    SINT32               iRet              = -1;
    UINT32               uiRet             = 0;
    RECT_T               tModifiedPlayRect = {0, };
    T_ZDrvVideo_DecCfg  *pDecCfg           = NULL;

    /* ״̬ */
    if(g_StreamVideoState != STREAM_VIDEO_STATE_OPEN && g_StreamVideoState != STREAM_VIDEO_STATE_WORKING)
    {
        zMspCom_Print();
        
        return DCAMERA_OP_ERROR;
    }
    
    /*  */
    if(NULL == param)
    {
        zMspCom_Print();
        
        return DCAMERA_OP_ERROR;
    }

    /*  */
    if(param->rotate < ROTATE_0 || param->rotate >ROTATE_270)
    {
        zMspCom_Print();
        
        return DCAMERA_OP_ERROR;
    }

    uiRet = zOss_GetMutex(g_StreamVideoCtlParam.pVideoDecMutexID, ZOSS_WAIT_FOREVER);
    if(ZOSS_SUCCESS != uiRet)
    {
        zMspCom_Print();
        
        return DCAMERA_OP_ERROR;
    }

    /* ڴ״̬£ûнָ룬̬棬Ҫ̬ */
    if(STREAM_VIDEO_STATE_OPEN == g_StreamVideoState)
    {
        g_StreamVideoCtlParam.play_rect = param->play_rect;
        g_StreamVideoCtlParam.eRotate = zMspStream_SetVideoRotate(param->rotate);
    }
    else
    {
        UINT32               uiWidth;
        UINT32               uiHeight;
        T_ZDrv_RotateType    tRotate;
        T_ZDrvVideo_Setting  tVideoSetting;

        /* ϲMMIõȫ320*240п߻ */
        if (ROTATE_90 == param->rotate || ROTATE_270 == param->rotate)
        {
            UINT32 uiTempWidth = 0;

            uiTempWidth = param->play_rect.width;
            param->play_rect.width = param->play_rect.height;
            param->play_rect.height = uiTempWidth;
        }

        pDecCfg = (T_ZDrvVideo_DecCfg  *)g_StreamVideoCtlParam.pVideoDecHandle;
        
        uiWidth  = pDecCfg->tOutput.uiWidth;
        uiHeight = pDecCfg->tOutput.uiHeight;
        
        g_StreamVideoCtlParam.play_rect = param->play_rect;


        if((ROT_90 == pDecCfg->tRotate || ROT_270 == pDecCfg->tRotate) && (ROTATE_0 == param->rotate || ROTATE_180 == param->rotate)
           || (ROT_0 == pDecCfg->tRotate || ROT_180 == pDecCfg->tRotate) && (ROTATE_90 == param->rotate || ROTATE_270 == param->rotate))
        {
            uiWidth  = pDecCfg->tOutput.uiHeight;
            uiHeight = pDecCfg->tOutput.uiWidth;
        }

        /* Ƶʾ */
        if(g_StreamVideoCtlParam.play_rect.width != 0
           && g_StreamVideoCtlParam.play_rect.height != 0)
        {
            iRet = zMspCom_VideoPlayRectModify(&tModifiedPlayRect, 
                                               &(g_StreamVideoCtlParam.play_rect), 
                                               uiWidth, 
                                               uiHeight);
            if(iRet != MSP_COM_OP_SUCCESS)
            {
                zMspCom_Print();
                uiRet = zOss_PutMutex(g_StreamVideoCtlParam.pVideoDecMutexID);
                if(ZOSS_SUCCESS != uiRet)
                {
		    zMspCom_Print();
                    return DCAMERA_OP_ERROR;
                }

                return DCAMERA_OP_ERROR;
            }
        }
        else
        {
            tModifiedPlayRect = g_StreamVideoCtlParam.play_rect;
        }

        /* ýת */
        tRotate = zMspStream_SetVideoRotate(param->rotate);
        
        tVideoSetting.cmd         = VIDEO_SET_ROTATION;    
        tVideoSetting.param       = (VOID *)&tRotate;
        tVideoSetting.uiVideoInst = pDecCfg->uiVideoInst;

        iRet = zDrv_Ioctl(g_StreamVideoCtlParam.uiVideoFd, IOCTL_VIDEO_DECSETTING, &tVideoSetting);    
        if(iRet < 0)
        {
            zMspCom_Print();
            uiRet = zOss_PutMutex(g_StreamVideoCtlParam.pVideoDecMutexID);
            if(ZOSS_SUCCESS != uiRet)
            {
		zMspCom_Print();
                return DCAMERA_OP_ERROR;
            }

            return DCAMERA_OP_ERROR;
        }

        
        g_StreamVideoCtlParam.real_play_rect = tModifiedPlayRect;        

        g_StreamVideoCtlParam.eRotate = zMspStream_SetVideoRotate(param->rotate);
        
        if((ROT_90 == pDecCfg->tRotate || ROT_270 == pDecCfg->tRotate) && (ROTATE_0 == param->rotate || ROTATE_180 == param->rotate)
           || (ROT_0 == pDecCfg->tRotate || ROT_180 == pDecCfg->tRotate) && (ROTATE_90 == param->rotate || ROTATE_270 == param->rotate))
        {
            uiWidth  = pDecCfg->tOutput.uiWidth;
            uiHeight = pDecCfg->tOutput.uiHeight;

            pDecCfg->tOutput.uiWidth  = uiHeight;
            pDecCfg->tOutput.uiHeight = uiWidth;  
        }
        
        pDecCfg->tRotate = tRotate;

        /* (ȫģʽ)Ƶĺʱƫ꣬
         * Чʣÿνظ 
         */
        zMspStream_RefreshYUVOffset();
        
    }

    uiRet = zOss_PutMutex(g_StreamVideoCtlParam.pVideoDecMutexID);
    if(ZOSS_SUCCESS != uiRet)
    {
	zMspCom_Print();
        return DCAMERA_OP_ERROR;
    }

    return DCAMERA_OP_SUCCESS; 
}

/**
 * ƣStream_Audio_Open
 * ýƵ豸
 * ˵(IN)data_type:ý
 *           (IN)stream_param:ò
 *   ֵ ɹýƵž;򷵻NULL
 * ˵ 
 */
STREAM_AUDIO_HANDLE Stream_Audio_Open(DD_STEAMING_AUDIO data_type, DD_STREAM_AUDIO_SET *stream_param)
{
    SINT32 iRet     = -1;    
    SINT32 iAudioFd = -1;

    STREAM_AUDIO_HANDLE pStreamAudioHandle = NULL;

    zOss_Printf(1, 1, "Stream_Audio_Open --start ----cyx!!!!");
    /* ״̬ǷIDLE̬ */
    if(g_StreamAudioState != STREAM_AUDIO_STATE_IDLE)
    {
        zMspCom_Print();
        
        return NULL;
    }

    /* 飬Ŀǰֻ֧AMR/AAC/MP3ָʽƵ */
    if(data_type != DD_STREAMING_AMR_NB 
        && data_type != DD_STREAMING_AAC
        && data_type != DD_STREAMING_MP3)
    {
        zMspCom_Print();
        
        return NULL;
    }

    /* 飬òָҪڣֻAACֵЧ */ 
    if(NULL == stream_param)
    {
        zMspCom_Print();
        
        return NULL;
    }

    /* ʼȫֱ */
    zOss_Memset(&g_StreamAudioCtlParam, 0, sizeof(T_Stream_Audio_ControlParam));
    g_StreamAudioCtlParam.bFirstAudioDecFlage = TRUE;

    /* תƵݸʽΪж */
    if(DD_STREAMING_AMR_NB == data_type)
    {
        g_StreamAudioCtlParam.eMediaAType = ZM_CODEC_ID_AMR_NB;
    }
    else if(DD_STREAMING_AAC == data_type)
    {
        g_StreamAudioCtlParam.eMediaAType = ZM_CODEC_ID_AAC;
    }
    else
    {
        g_StreamAudioCtlParam.eMediaAType = ZM_CODEC_ID_MP3;
    }

    /* ؽ */    
    iRet = zMspCom_LoadAudioDecodeLib(g_StreamAudioCtlParam.eMediaAType);
    if(iRet != MSP_COM_OP_SUCCESS)
    {
        g_StreamAudioCtlParam.eMediaAType = ZM_CODEC_ID_NONE;
        zMspCom_Print();
        
        return NULL;
    }
    
    /* Ƶ豸 */
    iAudioFd = zMspCom_AudioOpen();
    if(iAudioFd < 0)
    {
        /* жƵ */
        zMspCom_UnLoadAudioDecodeLib(g_StreamAudioCtlParam.eMediaAType);
        g_StreamAudioCtlParam.eMediaAType = ZM_CODEC_ID_NONE;
        zMspCom_Print();
        
        return NULL;
    }

    iRet = zMspCom_SetOutputChannel(MSP_CHANNEL_OUTPUT_SPEAKER);
    if(iRet != MSP_COM_OP_SUCCESS)
    {
        zOss_ASSERT(0);
    }
    
    iRet = zMspCom_SetOutputVol(MSP_OUTPUT_VOLUME_LEVEL_3);
    if(iRet != MSP_COM_OP_SUCCESS)
    {
        zOss_ASSERT(0);
    }
    
    /* Ƶ豸ID */
    g_StreamAudioCtlParam.uiAudioFd = (UINT32)iAudioFd;

    /* ṹиָ룬ڶָҪڴ汣 */  
    zOss_Memcpy(&g_StreamAudioCtlParam.stream_param, stream_param, sizeof(DD_STREAM_AUDIO_SET));
    
    if(stream_param->dd_aac.headerLength > 0 && DD_STREAMING_AAC == data_type)
    {
        g_StreamAudioCtlParam.stream_param.dd_aac.headerAddr = (UINT8 *)zOss_Malloc(stream_param->dd_aac.headerLength);
        if(NULL != g_StreamAudioCtlParam.stream_param.dd_aac.headerAddr)
        {
            zOss_Memcpy(g_StreamAudioCtlParam.stream_param.dd_aac.headerAddr,
                        stream_param->dd_aac.headerAddr,
                        stream_param->dd_aac.headerLength);         
        }
        else
        {
            /* жƵ */
            zMspCom_UnLoadAudioDecodeLib(g_StreamAudioCtlParam.eMediaAType);
        
            g_StreamAudioCtlParam.eMediaAType = ZM_CODEC_ID_NONE;
            
            /* رƵ豸 */
            zMspCom_AudioClose();
            zMspCom_Print();
            
            return NULL;            
        }
    }

    pStreamAudioHandle = (STREAM_AUDIO_HANDLE )zOss_Malloc(sizeof(STREAM_AUDIO_PARAM));
    if(NULL == pStreamAudioHandle)
    {
        /* жƵ */
        zMspCom_UnLoadAudioDecodeLib(g_StreamAudioCtlParam.eMediaAType);
        
        g_StreamAudioCtlParam.eMediaAType = ZM_CODEC_ID_NONE;
            
        /* رƵ豸 */
        zMspCom_AudioClose();
        
        if(NULL != g_StreamAudioCtlParam.stream_param.dd_aac.headerAddr)
        {
            zOss_Free(g_StreamAudioCtlParam.stream_param.dd_aac.headerAddr);
            g_StreamAudioCtlParam.stream_param.dd_aac.headerAddr = NULL;
        }

        zMspCom_Print();
        
        return NULL;            
        
    }

    /* Ƶž */
    pStreamAudioHandle->stream_audio_type = data_type;   
    pStreamAudioHandle->stream_param_set  = g_StreamAudioCtlParam.stream_param;
    
    /* Ƶ״̬Ϊ״̬ */
    g_StreamAudioState = STREAM_AUDIO_STATE_OPEN;
    
    zOss_Printf(1, 1, "Stream_Audio_Open --end success ----cyx!!!!");
    return pStreamAudioHandle; 
}

/**
 * ƣStream_Audio_Close
 * رýƵ豸
 * ˵(IN)handle:ýƵž
 *   ֵ ɹAUDIO_NO_ERROR;򷵻ӦĴ롣
 * ˵ 
 */
AUDIO_RESULT_E Stream_Audio_Close(STREAM_AUDIO_HANDLE handle)
{
    zOss_Printf(1, 1, "Stream_Audio_Close --start ----cyx!!!!");
    /* ״̬ */
    if(g_StreamAudioState != STREAM_AUDIO_STATE_OPEN && g_StreamAudioState != STREAM_AUDIO_STATE_WORKING)
    {
        zMspCom_Print();
        
        return AUDIO_ERROR;
    }

    /*  */
    if(NULL == handle)
    {
        zMspCom_Print();
        
        return AUDIO_PARAM_ERROR;
    }
    
    /* رƵ豸 */
    zMspCom_AudioClose();
    g_StreamAudioCtlParam.uiAudioFd = 0;

    /* رƵ */
    if(g_StreamAudioCtlParam.pAudioDecHandle != NULL)
    {
        zMspCom_CloseAudioDecoder(g_StreamAudioCtlParam.pAudioDecHandle);
        g_StreamAudioCtlParam.pAudioDecHandle = NULL;
    }
    
    /* жƵ */
    zMspCom_UnLoadAudioDecodeLib(g_StreamAudioCtlParam.eMediaAType);     
    g_StreamAudioCtlParam.eMediaAType = ZM_CODEC_ID_NONE;

    /* ͷAACƵʽͷϢ */
    if(NULL != g_StreamAudioCtlParam.stream_param.dd_aac.headerAddr)
    {
        zOss_Free(g_StreamAudioCtlParam.stream_param.dd_aac.headerAddr);
        g_StreamAudioCtlParam.stream_param.dd_aac.headerAddr = NULL;
    }

    /* ͷƵž */
    zOss_Free(handle);
    handle = NULL;

    zOss_Memset(&g_StreamAudioCtlParam.stream_param, 0, sizeof(DD_STREAM_AUDIO_SET));
    g_StreamAudioCtlParam.eMediaAType = ZM_CODEC_ID_NONE;

    g_StreamAudioCtlParam.bFirstAudioDecFlage = TRUE;
    
    /* λƵ״̬ΪIDLE״̬ */
    g_StreamAudioState = STREAM_AUDIO_STATE_IDLE;

    zOss_Printf(1, 1, "Stream_Audio_Close --end success ----cyx!!!!");
    return AUDIO_NO_ERROR; 
}


 //static FILE  *s_pAudioDataFile = NULL;//for test
 //static UINT32 s_uiAudioDataCount = 0;

/**
 * ƣStream_Audio_Open
 * ýƵݽ
 * ˵(IN)handle:ýƵž
 *           (IN)buffer:Ƶָ
 *           (IN)buffer_size:Ƶݳ
 *   ֵ ɹAUDIO_NO_ERROR;򷵻ӦĴ롣
 * ˵ 
 */
AUDIO_RESULT_E Stream_Audio_Decode(STREAM_AUDIO_HANDLE  handle,
                                   UINT32              *buffer,
                                   UINT32               buffer_size)
{

    SINT32                 iRet = -1;
    UINT32                 uiUsedLen;
    T_ZMFOutPutUnit        tOutUnit;
    T_Audio_AacParam       tAacParam;    
    T_ZDrvAudio_BufInfo    tAudioBufInfo;
    T_ZDrvAudio_PlayParam  tPlayParam;
    T_Audio_DecodeParam    tAudioDecParam = {0,};
    
    zOss_Printf(1, 1, "Stream_Audio_Decode --start ----cyx!!!!");
    /* ״̬ */
    if(g_StreamAudioState != STREAM_AUDIO_STATE_OPEN && g_StreamAudioState != STREAM_AUDIO_STATE_WORKING)
    {
        zMspCom_Print();
        
        return AUDIO_ERROR;
    }
    
    /*  */
    if(NULL == handle || NULL == buffer)
    {
        zMspCom_Print();
        
        return AUDIO_PARAM_ERROR;
    }

    tAacParam.pDecConfig = handle->stream_param_set.dd_aac.headerAddr;
    tAacParam.iConfigLen = handle->stream_param_set.dd_aac.headerLength;

    /* MP3֣ͬܽ*/
    if(g_StreamAudioCtlParam.eMediaAType == ZM_CODEC_ID_MP3)
    {
        UINT32  uiIndex = 0;
        UINT8   *pBufferTmp = (UINT8 *)buffer;
        
        if(!(pBufferTmp[0] == 0xff && (pBufferTmp[1] & 0xe0) == 0xe0))
        {
            return DCAMERA_OP_SUCCESS; 
        }
    }

#if 0
    /* Դ룬Ƶ */
    {
        char * data_flag = "FFFFFFFFFFFFFFFF";
        
        if(s_pAudioDataFile == NULL && s_uiAudioDataCount < 100)
        {
            s_pAudioDataFile = zOss_FOpen("C:\\stream_amr.dat", "wb");
            zOss_ASSERT(s_pAudioDataFile != NULL);
        }

        if(s_pAudioDataFile != NULL && s_uiAudioDataCount >= 100)
        {
            zOss_FClose(s_pAudioDataFile);
            s_pAudioDataFile = NULL;
        }

        if(s_pAudioDataFile != NULL && s_uiAudioDataCount < 100)
        {
            zOss_FWrite(buffer, buffer_size, 1, s_pAudioDataFile);
            zOss_FWrite(data_flag, strlen(data_flag), 1, s_pAudioDataFile);
            zOss_FFlush(s_pAudioDataFile);
            s_uiAudioDataCount++;
        }
    }
#endif

    /* һνʱҪʼ */
    if(g_StreamAudioCtlParam.bFirstAudioDecFlage)
    {
        g_StreamAudioCtlParam.pAudioDecHandle = zMspCom_OpenAudioDecoder(g_StreamAudioCtlParam.eMediaAType, 
                                                                    (UINT8 *)buffer, 
                                                                     buffer_size,
                                                                         &tAacParam,
                                                                    &g_StreamAudioCtlParam.tChannelMode,
                                                                    &g_StreamAudioCtlParam.tSampleRate);
        if(NULL == g_StreamAudioCtlParam.pAudioDecHandle)
        {
            zMspCom_Print();
          
            return AUDIO_NO_ERROR;//˴ܷش󣬵ȴһ֡ݹٴγԴ򿪽
        }

        g_StreamAudioCtlParam.uiAudioBufsize = (AAC_DECODE_LEN * sizeof(short));

        tPlayParam.channel    = g_StreamAudioCtlParam.tChannelMode;
        tPlayParam.buffersize = g_StreamAudioCtlParam.uiAudioBufsize;

        /* ò */
        iRet = zDrv_Ioctl(g_StreamAudioCtlParam.uiAudioFd, IOCTL_AUDIO_SET_SAMPLE, (VOID *)&g_StreamAudioCtlParam.tSampleRate);
        
        /* ʼ */      
        iRet = zDrv_Ioctl(g_StreamAudioCtlParam.uiAudioFd, IOCTL_AUDIO_PLAY_START, (VOID *)&tPlayParam);
        if (iRet != DRV_SUCCESS)
        {
            zMspCom_CloseAudioDecoder(g_StreamAudioCtlParam.pAudioDecHandle);
            zMspCom_Print();

            return AUDIO_ERROR;
        } 
        
        /* һν־ΪFALSEرƵģʱλΪTRUE */
        g_StreamAudioCtlParam.bFirstAudioDecFlage = FALSE;
		
	uiAudioCount = 0;
    }

    /*  */
    zMspStream_FillDecParam(g_StreamAudioCtlParam.eMediaAType, (UINT8 *)buffer, buffer_size, &tOutUnit);

    /* Ƶ */
    tAudioBufInfo.buf        = NULL;
    tAudioBufInfo.buffersize = 0;
    iRet = zDrv_Ioctl(g_StreamAudioCtlParam.uiAudioFd, IOCTL_AUDIO_GET_BUFFER, (VOID*)&tAudioBufInfo);
    if ((iRet < 0) || (NULL == tAudioBufInfo.buf))
    {
        zMspCom_Print();
        
        return AUDIO_ERROR;
    }

    tAudioDecParam.pHandle     = g_StreamAudioCtlParam.pAudioDecHandle;
    tAudioDecParam.pOutUnit    = &tOutUnit;
    tAudioDecParam.pPhyBuf     = tAudioBufInfo.buf;
    tAudioDecParam.uiLen       = tAudioBufInfo.buffersize;
    /* һ֡Ƶݽ,Ƶ */
    uiUsedLen = zMspCom_AudioDecode(&tAudioDecParam);

    /* ĳΪ0DDжԣ˴Ϊܴʩ */
    if(uiUsedLen == 0)
    {
        uiUsedLen = 160;
        zOss_Memset(tAudioBufInfo.buf, 0, tAudioBufInfo.buffersize);
    }
    
    /* PCM */
    if(uiUsedLen == 0)
    {
        uiUsedLen = tAudioBufInfo.buffersize;
    }
    iRet = zDrv_Write(g_StreamAudioCtlParam.uiAudioFd, (const VOID *)tAudioBufInfo.buf, uiUsedLen);
    if(iRet < 0)
    {   
        zMspCom_Print();
        
        return AUDIO_ERROR;
    }

    uiAudioCount++;
    g_StreamAudioState = STREAM_AUDIO_STATE_WORKING;
    
    zOss_Printf(1, 1, "Stream_Audio_Decode --end success ----cyx!!!!");
    return AUDIO_NO_ERROR; 
}

/**************************************************************************
 *                      ֲʵ                                      *
 **************************************************************************/
/**
 * ƣzMspStream_AmrIF1GetFrameType
 * AMR֡ȡAMR IF1ʽ֡
 * ˵(IN)uiDataLen: AMR IF1ʽ֡
 *   ֵ AMR IF1ʽ֡͡
 * ˵ 
 */
static UINT8 zMspStream_AmrIF1GetFrameType(UINT32 uiDataLen)
{
    UINT8  uiFrameType = 8;

    switch(uiDataLen)
    {
        case 12:
        {
            uiFrameType = 0;  /* 4.75k */
            break;
        }
        case 13:
        {
            uiFrameType = 1;  /* 5.15k */
            break;
        }
        case 15:
        {
            uiFrameType = 2;  /* 5.9k */
            break;
        }
        case 17:
        {
            uiFrameType = 3;  /* 6.7k */
            break;
        }
        case 19:
        {
            uiFrameType = 4;  /* 7.4k */
            break;
        }
        case 20:
        {
            uiFrameType = 5;  /* 7.95k */
            break;
        }
        case 26:
        {
            uiFrameType = 6;  /* 10.2k */
            break;
        }
        case 31:
        {
            uiFrameType = 7;  /* 12.2k */
            break;
        }
        case 5:
        {
            uiFrameType = 8;  /* SID */
            break;
        }
        case 0:
        {
            uiFrameType = 15; /* no transmission */
            break;
        }
        default:
        {
            uiFrameType = 8;  /* SID */
            break;
        }
    }
    
    return uiFrameType;
}

/**
 * ƣ zMspStream_Video_CheckFrame 
 *  һǷH263H264MPEG4֡ͷȷ
              ֡ͷλ
 * ˵
 *   ֵ
 * ˵
 */
static STREAM_VIDEO_FORMAT zMspStream_Video_CheckFrame(STREAM_DATA *param)
{
    UINT8  *pTempPos = NULL;
    UINT32  uiBufLen = 0;
    UINT32  i = 0;

    if(param->data_length < 3)
    {
        return STREAM_VIDEO_NONE; 
    }
    
    pTempPos = (UINT8 *)(param->data_buffer);
    uiBufLen   = param->data_length;

    for(i = 0; i < uiBufLen -3; i++)
    {
        if(pTempPos[i] == 0x00 && pTempPos[i + 1] == 0x00 && ((pTempPos[i + 2] & 0xFC) == 0x80)) /* H.263 PSC*/
        {
            return STREAM_VIDEO_H263;
        }
        else if(pTempPos[i] == 0x00 && pTempPos[i + 1] == 0x00 && pTempPos[i + 2] == 0x01
	     && (pTempPos[i + 3] == 0xB0 || pTempPos[i + 3] == 0xB3 || pTempPos[i + 3] == 0xB5))/* MPEG4 PSC */
        {
            return STREAM_VIDEO_MP4;
        }
	    else if((pTempPos[i] == 0x00 && pTempPos[i + 1] == 0x00 && pTempPos[i+ 2] == 0x01)/* H.264 PSC*/
	     || (pTempPos[i] == 0x00 && pTempPos[i + 1] == 0x00 && pTempPos[i+ 2] == 0x00 && pTempPos[i+ 3] == 0x01))
        {
            return STREAM_VIDEO_H264;
        }
    }

    if(pTempPos[i] == 0x00 && pTempPos[i + 1] == 0x00 && ((pTempPos[i + 2] & 0xFC) == 0x80)) /* H.263 PSC*/
    {
        return STREAM_VIDEO_H263;
    }
    else if(pTempPos[i] == 0x00 && pTempPos[i + 1] == 0x00 && pTempPos[i+ 2] == 0x01)/* H.264 PSC*/
    {
        return STREAM_VIDEO_H264;
    }


    return STREAM_VIDEO_NONE; 
}

/**
 * ƣzMspStream_FillDecParam
 * Ƶ
 * ˵(IN)eMediaAType:     Ƶظʽ
 *           (IN)pRawData:        ԭʼ
 *           (IN)uiDataLen:       ԭʼݳ
 *           (IN/OUT)eMediaAType: Ĺ
 *   ֵ 
 * ˵ 
 */
static VOID zMspStream_FillDecParam(EMediaAudioType  eMediaAType, UINT8           *pRawData, 
                                    UINT32           uiDataLen,   T_ZMFOutPutUnit *pOutUnit)
{
    if(ZM_CODEC_ID_AMR_NB == eMediaAType)
    {
        pOutUnit->pPacket                                 = (UINT8 *)((UINT32)pRawData + 1);
        pOutUnit->u32Len                                  = uiDataLen - 1;
        pOutUnit->uFrameUnit.t_AMRFrameUnit.u8FrameType   = zMspStream_AmrIF1GetFrameType(pOutUnit->u32Len);
        pOutUnit->uFrameUnit.t_AMRFrameUnit.cFrameQuality = 0;
    }
    else
    {
        pOutUnit->pPacket = pRawData;
        pOutUnit->u32Len  = uiDataLen;
    }

    return;
}

/**
 * ƣ zMspStream_OpenVideoDecoder 
 *  Ƶ
 * ˵ (IN) eStreamVideoType Ƶݸʽ
 *   ֵ ʧܷNULL
 * ˵ 
 */
static DecHandle zMspStream_OpenVideoDecoder(STREAM_VIDEO_FORMAT eStreamVideoType, STREAM_DATA *param)
{
    DecHandle  pHandle = NULL;

    switch(eStreamVideoType)
    {        
        case STREAM_VIDEO_H263:
        {
            pHandle = zMspStream_VideoDecoderOpen(param, VIDEO_CODEC_STD_H263);
            
            break;
        }
        case STREAM_VIDEO_H264:
        {
            pHandle = zMspStream_VideoDecoderOpen(param, VIDEO_CODEC_STD_AVC);
            
            break;
        }
        case STREAM_VIDEO_MP4:
        {
            pHandle = zMspStream_VideoDecoderOpen(param, VIDEO_CODEC_STD_MPEG4);
            
            break;
        }

        default :
        {
            pHandle = NULL;
            
            break;
        }        
    }

    return pHandle;
}

/**
 * ƣ zMspStream_CloseVideoDecoder 
 *  رƵ
 * ˵ (IN) eStreamVideoType Ƶݸʽ
 *            (IN) pHandle     
 *   ֵ 
 * ˵ 
 */
static VOID zMspStream_CloseVideoDecoder(STREAM_VIDEO_FORMAT eStreamVideoType, DecHandle pHandle)
{
    switch(eStreamVideoType)
    {
        
        case STREAM_VIDEO_H263:
        case STREAM_VIDEO_H264:
        case STREAM_VIDEO_MP4:
        {
            zMspStream_VideoDecoderClose(pHandle);
            
            break;
        }

        default :
        {            
            break;
        }        
    }

    return;    
}

/**
 * ƣ zMspStream_VideoDecoderOpen 
 *  H263ʽƵ
 * ˵ (IN) param:Ƶݽṹָ
 *   ֵ ʧܷNULL
 * ˵ ΪH263ȴһ֡ݣ⴦;
 *            ʵΪ(T_ZDrvVideo_DecCfg *)
 */
static DecHandle zMspStream_VideoDecoderOpen(STREAM_DATA *param, T_ZDrvVideo_CodecStandard eVideoType)
{
    SINT32               iRet      = -1;
    T_ZMFOutPutUnit      tOutUnit;   
    T_ZDrvVideo_DecCfg  *pDecCfg   = NULL;
    T_ZDrvVideo_BufInfo  tBuf;

    pDecCfg = (T_ZDrvVideo_DecCfg *)zOss_Malloc(sizeof(T_ZDrvVideo_DecCfg));
    if(NULL == pDecCfg)
    {
	zMspCom_Print();
        return NULL;
    }
    zOss_Memset(pDecCfg, 0, sizeof(T_ZDrvVideo_DecCfg));

    tOutUnit.pPacket = param->data_buffer;
    tOutUnit.u32Len  = param->data_length;

    /* ȡӲBuffer */
    tBuf.bufType                = STREAM_TYPE;
    tBuf.bufSize.streamBufSize  = tOutUnit.u32Len;
    tBuf.pDataBuf.streamDataBuf = NULL;
    iRet = zDrv_Ioctl(g_StreamVideoCtlParam.uiVideoFd, IOCTL_VIDEO_GET_BUFINFO, &tBuf);
    if(iRet < 0 || NULL == tBuf.pDataBuf.streamDataBuf)
    {
	    zMspCom_Print();
        zOss_Free(pDecCfg); 
        
        return NULL;
    }

    /* ļƵ֡ӲBuffer׼룬ο޷ */
    zOss_Memcpy(tBuf.pDataBuf.streamDataBuf, tOutUnit.pPacket, tBuf.bufSize.streamBufSize);
 
    /* ʼ */
    pDecCfg->tInput.tCodecStd   = eVideoType;
    pDecCfg->tInput.pEncHeader  = tBuf.pDataBuf.streamDataBuf;
    pDecCfg->tInput.headerLenth = tBuf.bufSize.streamBufSize;
    pDecCfg->tRotate            = ROT_0;
    pDecCfg->tMirror            = MIR_NONE;
    pDecCfg->tOutput.tPixelFmt  = PIXEL_YCbCr420;

    /* ȫ */
    if(0 == g_StreamVideoCtlParam.play_rect.sx
       && 0 == g_StreamVideoCtlParam.play_rect.sy
       && g_uiScreenWidth == g_StreamVideoCtlParam.play_rect.width
       && g_uiScreenHeight == g_StreamVideoCtlParam.play_rect.height)
    {
        pDecCfg->tRotate = ROT_270;
    }
    else
    {
        pDecCfg->tRotate = ROT_0;
    }

    /* ʼbufferֶͷţͷ */
    iRet = zDrv_Ioctl(g_StreamVideoCtlParam.uiVideoFd, IOCTL_VIDEO_DECSTART, (VOID *)pDecCfg);
    if(iRet < 0)
    {
        zOss_Free(pDecCfg); 
        zMspCom_Print();
        
        return NULL;
    }

    /* תȵͼƬĿ */
    if(ROT_90  == pDecCfg->tRotate || ROT_270 == pDecCfg->tRotate)
    {
        UINT32  uiWidth;
        UINT32  uiHeight;
        
        uiWidth  = pDecCfg->tOutput.uiWidth;
        uiHeight = pDecCfg->tOutput.uiHeight;

        pDecCfg->tOutput.uiWidth  = uiHeight;
        pDecCfg->tOutput.uiHeight = uiWidth;        
    }

    /* ֧ƵͼƬΪ16Ƶʽ */
    if(pDecCfg->tOutput.uiWidth % 16 != 0
       || pDecCfg->tOutput.uiHeight % 16 != 0)
    {
        zOss_Free(pDecCfg); 
        zMspCom_Print();
        
        return NULL;
    }
        
    /* ̶ĽBuffer,ȫʱʹ */
    g_StreamVideoCtlParam.tDftDecBuf.bufType                   = YUV_TYPE;
    g_StreamVideoCtlParam.tDftDecBuf.bufSize.YuvBufSize.ySize  = (pDecCfg->tOutput.uiWidth) * (pDecCfg->tOutput.uiHeight);
    g_StreamVideoCtlParam.tDftDecBuf.bufSize.YuvBufSize.uSize  = (pDecCfg->tOutput.uiWidth) * (pDecCfg->tOutput.uiHeight) / 4;
    g_StreamVideoCtlParam.tDftDecBuf.bufSize.YuvBufSize.vSize  = (pDecCfg->tOutput.uiWidth) * (pDecCfg->tOutput.uiHeight) / 4;

    iRet = zDrv_Ioctl(g_StreamVideoCtlParam.uiVideoFd, IOCTL_VIDEO_GET_BUFINFO, &(g_StreamVideoCtlParam.tDftDecBuf));
    if(iRet < 0)
    {   
        zMspCom_Print();
        zOss_Free(pDecCfg); 
        
        return NULL;
    }
    
    return (DecHandle)pDecCfg;
}

/**
 * ƣ zMspStream_VideoDecoderClose 
 *  رH263ʽƵ
 * ˵ (IN) pHandle  zMspStream_H263DecoderOpenصĽ
 *   ֵ 
 * ˵ 
 */
static VOID zMspStream_VideoDecoderClose(DecHandle pHandle)
{
    SINT32               iRet    = 0;
    T_ZDrvVideo_DecCfg  *pDecCfg = NULL;

    if(NULL == pHandle)
    {
	    zMspCom_Print();
        return;
    }

    /* ͷŽĹ̶Buffer */
    iRet = zDrv_Ioctl(g_StreamVideoCtlParam.uiVideoFd, IOCTL_VIDEO_FREE_BUFFER, (VOID *)&(g_StreamVideoCtlParam.tDftDecBuf));
    if(iRet < 0)
    {
	    zMspCom_Print();
        return;
    }

    pDecCfg = (T_ZDrvVideo_DecCfg *)pHandle;

    iRet = zDrv_Ioctl(g_StreamVideoCtlParam.uiVideoFd, IOCTL_VIDEO_DECSTOP, (VOID *)(&(pDecCfg->uiVideoInst)));
    if(iRet < 0)
    {
	    zMspCom_Print();
        return;
    }

    zOss_Free(pDecCfg);

    g_StreamVideoCtlParam.pVideoDecHandle = NULL;

    return;
}

/**
 * ƣ zMspStream_VideoDecodeProc 
 *  ƵݵĽ롢
 * ˵ (IN) param  Ƶ
 *   ֵ ɹSTREAM_OP_SUCCESS
 * ˵ 
 */ 
static SINT32 zMspStream_VideoDecodeProc(STREAM_DATA *param)
{  
    BOOL                   bARGB = FALSE;
    SINT32                 iRet;
    UINT32                 uiVideoInst;       /* ʵ       */
    UINT32                 uiDisWidth;        /* ƵͼƬʾĿ   */
    UINT32                 uiDisHeight;       /* ƵͼƬʾĸ߶   */
    T_ZDrvVideo_DecCfg    *pDecCfg;           /* ò         */   
    T_ZDrvVideo_BufInfo    tDecBuf;           /* ӲBuffer   */
    T_ZDrvVideo_BufInfo    tPpuBuf;           /* ƵBuffer */
    T_ZDrvVideo_PpuInfo    tPpuInfo;          /*            */
    T_ZDrvVideo_DecParam   tDecParam;         /*              */
        
    /* ȡӲBuffer */
    if(g_StreamVideoCtlParam.eStreamVideoType == STREAM_VIDEO_H264
        && g_Video_Header_Data.bfirstframe
        && g_Video_Header_Data.data_buffer != NULL)
    {
        UINT8    *tmpStreamBuffer = NULL;
		
        tDecBuf.bufType                = STREAM_TYPE;
        tDecBuf.bufSize.streamBufSize  = param->data_length + g_Video_Header_Data.data_length;
        tDecBuf.pDataBuf.streamDataBuf = NULL;
        iRet = zDrv_Ioctl(g_StreamVideoCtlParam.uiVideoFd, IOCTL_VIDEO_GET_BUFINFO, &tDecBuf);
        if(iRet < 0 || NULL == tDecBuf.pDataBuf.streamDataBuf)
        {
            zMspCom_Print();
                
            return STREAM_VIDEO_OP_BUFFER_ERR;
        }
            
        /* ļƵ֡ӲBuffer׼룬ο޷ */
        zOss_Memcpy(tDecBuf.pDataBuf.streamDataBuf, g_Video_Header_Data.data_buffer, 
                    g_Video_Header_Data.data_length);
		tmpStreamBuffer = (UINT8 *)tDecBuf.pDataBuf.streamDataBuf + g_Video_Header_Data.data_length;
        zOss_Memcpy((PhyAddr *)tmpStreamBuffer, param->data_buffer, param->data_length);
        
        g_Video_Header_Data.bfirstframe = FALSE;
    }
    else
    {
        tDecBuf.bufType                = STREAM_TYPE;
        tDecBuf.bufSize.streamBufSize  = param->data_length;
        tDecBuf.pDataBuf.streamDataBuf = NULL;
        iRet = zDrv_Ioctl(g_StreamVideoCtlParam.uiVideoFd, IOCTL_VIDEO_GET_BUFINFO, &tDecBuf);
        if(iRet < 0 || NULL == tDecBuf.pDataBuf.streamDataBuf)
        {
            zMspCom_Print();
                
            return STREAM_VIDEO_OP_BUFFER_ERR;
        }
            
        /* ļƵ֡ӲBuffer׼룬ο޷ */
        zOss_Memcpy(tDecBuf.pDataBuf.streamDataBuf, param->data_buffer, tDecBuf.bufSize.streamBufSize);
    }

    /* ȡƵ */
    pDecCfg = (T_ZDrvVideo_DecCfg *)g_StreamVideoCtlParam.pVideoDecHandle;
    uiVideoInst = pDecCfg->uiVideoInst;

    /* ׼ʼһ֡Ƶ IOCTL_VIDEO_DECONEFRAME */
    tDecParam.uiVideoInst = uiVideoInst;
    tDecParam.pDataIn     = tDecBuf.pDataBuf.streamDataBuf;
    tDecParam.uiLenIn     = tDecBuf.bufSize.streamBufSize;
    tDecParam.hasDecdata  = TRUE;

    /* ȡƵͼƬʾĿ */
    uiDisWidth  = g_StreamVideoCtlParam.real_play_rect.width;
    uiDisHeight = g_StreamVideoCtlParam.real_play_rect.height;

    /* ԤʾͼƬĿĿ߲һ£ʱ뵽̶ĽBuffer */
    if(pDecCfg->tOutput.uiWidth != uiDisWidth || pDecCfg->tOutput.uiHeight != uiDisHeight)
    {
        /* ý */
        tDecParam.uiStride = pDecCfg->tOutput.uiWidth;
        tDecParam.pDataOut = g_StreamVideoCtlParam.tDftDecBuf.pDataBuf;
                
        /* Bufferڵӿʱͷ */
        iRet = zDrv_Ioctl(g_StreamVideoCtlParam.uiVideoFd, IOCTL_VIDEO_DECONEFRAME, &tDecParam);    
        if(iRet < 0)
        {
            /* ڴ˽Bufferǹ̶ģڴ˴ͷ */
            zMspCom_Print();
                
            return STREAM_VIDEO_OP_DECODE_ERR;
        }            
    }
    else /* ԤʾͼƬĿĿһʱ뵽ȫĺɫ */
    {
        T_ZDrv_YuvBuf tTempYuvBuf;            

        bARGB = FALSE;
            
        /* ȡƵӲBufferȫʱƵݸʽΪYUV420 */
        /* ȫģʽµĽ룬ͨСƵͼƬֱӽںɫ */
        tPpuBuf.bufType                   = YUV_TYPE;
        tPpuBuf.bufSize.YuvBufSize.ySize  = g_uiDefaultYSize;
        tPpuBuf.bufSize.YuvBufSize.uSize  = g_uiDefaultUSize;
        tPpuBuf.bufSize.YuvBufSize.vSize  = g_uiDefaultVSize;

        iRet = zDrv_Ioctl(g_StreamVideoCtlParam.uiVideoFd, IOCTL_VIDEO_GET_BUFINFO, &tPpuBuf);
        if(iRet < 0)
        {   
            zMspCom_Print();
                
            return STREAM_VIDEO_OP_BUFFER_ERR;
        }             

        /* ɫ */
        zOss_Memset((VOID *)tPpuBuf.pDataBuf.YuvBuf.Y,  0,   tPpuBuf.bufSize.YuvBufSize.ySize);
        zOss_Memset((VOID *)tPpuBuf.pDataBuf.YuvBuf.Cb, 128, tPpuBuf.bufSize.YuvBufSize.uSize);
        zOss_Memset((VOID *)tPpuBuf.pDataBuf.YuvBuf.Cr, 128, tPpuBuf.bufSize.YuvBufSize.vSize);

        /* עYUVΪPhyAddr *ָͣӷʱ1ڼ4 */
        tTempYuvBuf.Y  = (PhyAddr *)((UINT32)tPpuBuf.pDataBuf.YuvBuf.Y  + g_StreamVideoCtlParam.uiYOffset);
        tTempYuvBuf.Cb = (PhyAddr *)((UINT32)tPpuBuf.pDataBuf.YuvBuf.Cb + g_StreamVideoCtlParam.uiUOffset);
        tTempYuvBuf.Cr = (PhyAddr *)((UINT32)tPpuBuf.pDataBuf.YuvBuf.Cr + g_StreamVideoCtlParam.uiVOffset);

        /* ý */
        tDecParam.uiStride        = g_uiScreenWidth;            
        tDecParam.pDataOut.YuvBuf = tTempYuvBuf; 
            
        /* Bufferڵӿʱͷ */
        iRet = zDrv_Ioctl(g_StreamVideoCtlParam.uiVideoFd, IOCTL_VIDEO_DECONEFRAME, &tDecParam);    
        if(iRet < 0)
        {
            /* ͷŽBuffer */
            iRet = zDrv_Ioctl(g_StreamVideoCtlParam.uiVideoFd, IOCTL_VIDEO_FREE_BUFFER, (VOID *)&tPpuBuf);
            if(iRet < 0)
            {
	            zMspCom_Print();
				
                return STREAM_VIDEO_OP_DEVICE_ERR;
            }
            zMspCom_Print();
            
            return STREAM_VIDEO_OP_DECODE_ERR;
        }
    }


    /* ԤʾͼƬĿĿ߲һ£ʱ뵽̶ĽBuffer */
    if(pDecCfg->tOutput.uiWidth != uiDisWidth || pDecCfg->tOutput.uiHeight != uiDisHeight)
    {
        /* ȫģʽƵֱˢҪOSDĻϴ
         * ˴˴ݸʽΪARGB 
         */            
        if(g_uiScreenWidth == uiDisWidth && g_uiScreenHeight == uiDisHeight)
        {
            /* ͼŴȫ */
            bARGB = TRUE;
            
            /* ȡƵӲBufferƵȫʾʱΪARGBʽ */
            tPpuBuf.bufType             = ARGB_TYPE;
            tPpuBuf.bufSize.ARGBBufSize = g_uiDefaultARGBSize / 2;

            iRet = zDrv_Ioctl(g_StreamVideoCtlParam.uiVideoFd, IOCTL_VIDEO_GET_BUFINFO, &tPpuBuf);
            if(iRet < 0 || NULL == tPpuBuf.pDataBuf.ARGBdataBuf)
            {   
                zMspCom_Print();
                
                return STREAM_VIDEO_OP_BUFFER_ERR;
            }    

            /* ppuͼƬϢ */
            tPpuInfo.outputInfo.uiWidth       = g_uiScreenWidth;
            tPpuInfo.outputInfo.uiHeight      = g_uiScreenHeight;
            tPpuInfo.outputInfo.uiStride      = g_uiScreenWidth;
            tPpuInfo.outputInfo.tPixelFmt     = PIXEL_RGB565;//PIXEL_ARGB888;              /* YUV420 */
            tPpuInfo.outputInfo.pOutPutbuffer = tPpuBuf.pDataBuf;  
        
        }
        else
        {
            T_ZDrv_YuvBuf tTempYuvBuf;

            bARGB = FALSE;
            
            /* ȡƵӲBufferȫʱƵݸʽΪYUV420 */
            /* ȫģʽµƵͨСƵͼƬźںɫı */
            tPpuBuf.bufType                   = YUV_TYPE;
            tPpuBuf.bufSize.YuvBufSize.ySize  = g_uiDefaultYSize;
            tPpuBuf.bufSize.YuvBufSize.uSize  = g_uiDefaultUSize;
            tPpuBuf.bufSize.YuvBufSize.vSize  = g_uiDefaultVSize;

            iRet = zDrv_Ioctl(g_StreamVideoCtlParam.uiVideoFd, IOCTL_VIDEO_GET_BUFINFO, &tPpuBuf);
            if(iRet < 0)
            {   
                zMspCom_Print();
                
                return STREAM_VIDEO_OP_BUFFER_ERR;
            }             

            /* ɫ */
            zOss_Memset((VOID *)tPpuBuf.pDataBuf.YuvBuf.Y,  0,   tPpuBuf.bufSize.YuvBufSize.ySize);
            zOss_Memset((VOID *)tPpuBuf.pDataBuf.YuvBuf.Cb, 128, tPpuBuf.bufSize.YuvBufSize.uSize);
            zOss_Memset((VOID *)tPpuBuf.pDataBuf.YuvBuf.Cr, 128, tPpuBuf.bufSize.YuvBufSize.vSize);

            /* עYUVΪPhyAddr *ָͣӷʱ1ڼ4 */
            tTempYuvBuf.Y  = (PhyAddr *)((UINT32)tPpuBuf.pDataBuf.YuvBuf.Y  + g_StreamVideoCtlParam.uiYOffset);
            tTempYuvBuf.Cb = (PhyAddr *)((UINT32)tPpuBuf.pDataBuf.YuvBuf.Cb + g_StreamVideoCtlParam.uiUOffset);
            tTempYuvBuf.Cr = (PhyAddr *)((UINT32)tPpuBuf.pDataBuf.YuvBuf.Cr + g_StreamVideoCtlParam.uiVOffset);
            
            /* ppuͼƬϢ */
            tPpuInfo.outputInfo.uiWidth              = uiDisWidth;       /* ͼƬ       */
            tPpuInfo.outputInfo.uiHeight             = uiDisHeight;      /* ͼƬ       */
            tPpuInfo.outputInfo.uiStride             = g_uiScreenWidth;     /*            */
            tPpuInfo.outputInfo.tPixelFmt            = PIXEL_YCbCr420;   /* YUV420           */
            tPpuInfo.outputInfo.pOutPutbuffer.YuvBuf = tTempYuvBuf;      /* ͼƬʼַ */
        }

        /* ppuϢ */
        tPpuInfo.inputInfo.uiStartX       = 0;
        tPpuInfo.inputInfo.uiStartY       = 0;
        tPpuInfo.inputInfo.uiWidth        = pDecCfg->tOutput.uiWidth;
        tPpuInfo.inputInfo.uiHeight       = pDecCfg->tOutput.uiHeight;  
        tPpuInfo.inputInfo.uiStride       = pDecCfg->tOutput.uiWidth;    
        tPpuInfo.inputInfo.tPixelFmt      = pDecCfg->tOutput.tPixelFmt;  /* YUV420 */
        tPpuInfo.inputInfo.pInPutbuffer   = tDecParam.pDataOut; 
        tPpuInfo.tMirror  = MIR_NONE;
        tPpuInfo.tRotate = ROT_0;

        /* OSDʹ */
        tPpuInfo.osdInfo.bEnable          = FALSE;

        /* ƵƵ */
        iRet = zDrv_Ioctl(g_StreamVideoCtlParam.uiVideoFd, IOCTL_VIDEO_POSTPROCESS, &tPpuInfo);
        if(iRet < 0)
        {
            /* ڴ˽Bufferǹ̶ģڴ˴ͷţ˴ͷŵppuBuffer */
            iRet = zDrv_Ioctl(g_StreamVideoCtlParam.uiVideoFd, IOCTL_VIDEO_FREE_BUFFER, (VOID *)&tPpuBuf);
            if(iRet < 0)
            {
                return STREAM_VIDEO_OP_DEVICE_ERR;
            }

            zMspCom_Print();
            
            return STREAM_VIDEO_OP_POSTPPU_ERR;
        }                 
    }

    Zte_OsdUpdateVideoInput(&(tPpuBuf.pDataBuf), bARGB, &g_StreamVideoCtlParam.real_play_rect);
    
    return STREAM_OP_SUCCESS;    
}

/**
 * ƣ zMspStream_RefreshYUVOffset 
 *  Ƶĺʱƫ(ȫģʽ)
 * ˵ (IN) 
 *   ֵ 
 * ˵ ΪЧʹ
 */
static VOID zMspStream_RefreshYUVOffset(VOID)
{
    UINT32  uiXpos = 0;
    UINT32  uiYpos = 0;

    /* Ƶͼƫ(˴ΪЧʣÿν
     * м)
     */
    /* ƵͼƬYUVƫ */            
    uiXpos = g_StreamVideoCtlParam.real_play_rect.sx;
    uiYpos = g_StreamVideoCtlParam.real_play_rect.sy;

    /* עYUVΪPhyAddr *ָͣӷʱ1ڼ4 */
    g_StreamVideoCtlParam.uiYOffset = g_uiScreenWidth * uiYpos + uiXpos;
    g_StreamVideoCtlParam.uiUOffset = g_uiScreenWidth * uiYpos / 4 + uiXpos / 2;
    g_StreamVideoCtlParam.uiVOffset = g_uiScreenWidth * uiYpos / 4 + uiXpos / 2;

    return;    
}

/**
 * ƣ zMspStream_SetVideoRotate 
 *  Ƶת
 * ˵ (IN) 
 *   ֵ 
 * ˵ 
 */
static T_ZDrv_RotateType zMspStream_SetVideoRotate(DROTATION_MODE_E  rotate)
{
    T_ZDrv_RotateType  eRotate = ROT_0;

    switch(rotate)
    {
        case ROTATE_0:
        {
            eRotate = ROT_0;  
            break;
        }
        case  ROTATE_90:
        {
            eRotate = ROT_90;  
            break;
        }
        case ROTATE_180:
        {
            eRotate = ROT_180;  
            break;
        }
        case ROTATE_270:
        {
            eRotate = ROT_270;  
            break;
        }
        default:
        {
            eRotate = MAX_ROT_TYPE; 
            break;
        }
    }
    
    return eRotate;
    
}
