/*******************************************************************************
 * Copyright (C) 2008, ZTE Corporation.
 *
 * File Name:    drvs_usb_config.h
 * File Mark:
 * Description:
 * Others:
 * Version:       V1.0
 * Author:        Weizhigang
 * Date:          2009-6-18
 * History 1:
 *     Date:
 *     Version:
 *     Author:
 *     Modification:
  ********************************************************************************/
#ifndef _DRVS_USB_CONFIG_H
#define _DRVS_USB_CONFIG_H

/****************************************************************************
* 	                                        macro
****************************************************************************/
#define	MAX_ENDPOINT_NUM				13		//IN&OUT ENDPOINT INCLUDE EP0
#define	MAX_INTERFACE_NUM		    	12		//the usb hw only have 12 endpoint set, so the max ifac num is 12

#define POWER_DOMAIN_ISO				(0x0010d200+0x41*4)
#define POWER_DOMAIN_POWERON		(0x0010d200+0x42*4)
#define POWER_DOMAIN_RST				(0x0010d200+0x40*4)

#define SOC_CRM_BASE            (0x0010c000)
#define BOOT_SEL                (0x3c)
#define NAND_CFG                (0x34)
#define SOC_MOD_CLKEN0         (0x0010c00c)
#define SOC_MOD_CLKEN1         (0x0010c010)
#define SOC_MOD_RSTEN          (0x0010c018)
#define SOC_MOD_USBSTATECTRL   (0x0010c05c)
#define SOC_MOD_RSTEN1         (0x0010c064)

#ifdef _USE_PSM
#define     USE_USB_PSM    1
#endif
#define     USE_USB_PSM    1//usbʡ벻ʡ

#define CHARGER_DETECT 0


#define  USB_GET_EP_ADDR(ep_num,dir) 	((dir<<7)|(ep_num))


typedef SINT32 (*interface_bind)(UINT8* config_buf, VOID* context, UINT8 interfaceNum, UINT32 speed);

/****************************************************************************
* 	                                        type
****************************************************************************/
//define ep transfer mode
typedef enum _T_ZDrvUsb_EpXferMode
{
    EP_XFER_MODE_CPU=0,		//need to change hal define!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
    EP_XFER_MODE_DMA0=1,
    EP_XFER_MODE_DMA1REQ0=2,
    EP_XFER_MODE_DMA1REQ1=3
}
T_ZDrvUsb_EpXferMode;

//define ep receive mode
typedef enum _T_ZDrvUsb_EpXferEndCondition
{
    EP_UNKNOW_BASE =0,
    EP_LENGTH_BASE = 5,
    EP_PACKET_BASE = 6,
}
T_ZDrvUsb_EpXferEndCondition;

//define ep context
typedef struct _T_ZDrvUsb_EpContext
{
    BOOL bEpIsVaild;
    UINT32 uiEpAddr;
    T_ZDrvUsb_EpXferMode tEpXferMode;
    T_ZDrvUsb_EpXferEndCondition tEpXferEndCondi;
}
T_ZDrvUsb_EpContext;

//define ep context
typedef struct _T_ZDrvUsb_InterfacecContext
{
    BOOL bIfacIsVaild;
    UINT32 uiIfacFunction;
    T_ZDrvUsb_EpContext tInEpContext;
    T_ZDrvUsb_EpContext tOutEpContext;
    T_ZDrvUsb_EpContext tExtendEpContext;
    CHAR* pIfacName;
    interface_bind f_intf_bind;	
}
T_ZDrvUsb_InterfacecContext;

typedef struct _T_ZDrvUsb_DeviceContext
{
    CHAR* pVendroName;
    CHAR* pProductName;
    CHAR* pSerialNum;
    UINT32 uiVID;
    UINT32 uiPID;
    UINT8 DeviceClass;
    UINT8 DeviceSubClas;
    UINT8 DeviceProtocol;
}
T_ZDrvUsb_DeviceContext;

/*qihongfang add for usb context show on PC*/

typedef struct _T_ZDrvUsb_MSType
{
	CHAR* pCdromName;
	CHAR* pNandName;
	CHAR* pSdName;
	CHAR* pRamdiskName;
}
T_ZDrvUsb_MSType;

typedef struct _T_ZDrvUsb_MsContext
{
CHAR* pVendorName;
T_ZDrvUsb_MSType pProductName;
CHAR* pProductRevision;
}
T_ZDrvUsb_MsContext;

typedef struct _T_ZDrvUsb_ConfigContext
{
    BOOL bContextIsVaild;
    T_ZDrvUsb_DeviceContext tDeviceContext;		//we respect one config as one device
    T_ZDrvUsb_InterfacecContext tIfacContext[MAX_INTERFACE_NUM];
}
T_ZDrvUsb_ConfigContext;

typedef struct _T_ZDrvUsb_EcmFunctionDescriptor
{
    CHAR * EcmMacAddr;
    UINT32 bmEthernetStatistics;
    UINT16 wMaxSegmentSize;
    UINT16 wNumberMCFilters;
}
T_ZDrvUsb_EcmFunctionDescriptor;

typedef struct _T_ZDrvUsb_EcmContext
{
    BOOL bIsVaild;
    UINT8 ifacNum_CCI;		
    T_ZDrvUsb_EcmFunctionDescriptor tEcmFuncDes;
}
T_ZDrvUsb_EcmContext;


//------------------------------------------------------------------------------------------------------------------

typedef enum _T_ZDrvUsb_ConfigType
{
    USB_CONFIG0=0,
    USB_CONFIG1=1,
    USB_CONFIG2=2,
    USB_CONFIG3=3,
    USB_CONFIG4=4,
    USB_CONFIG5=5,
    USB_CONFIG6=6,
    USB_CONFIG7=7,
    USB_CONFIG8=8,
    USB_CONFIG9=9,
    USB_CONFIG10=10,
    USB_CONFIG11=11,
    USB_MAX_CONFIG_NUM,
    USB_CONFIG_NONE,
    USB_CONFIG_END=0xff	/* all device uninstalled */
}
T_ZDrvUsb_ConfigType;

typedef enum _T_ZDrvUsb_OSType
{
    OSType_Windows=0, //means xp,vista,win7
    OSType_Linux=1,
    OSType_Mac=2,
    OSType_Win8=3,
    OS_MAX_TYPE_NUM,
    OS_TYPE_END=0xff	/* all device uninstalled */
}
T_ZDrvUsb_OSType;

//define usb dev type
typedef enum _T_ZDrvUsb_DevType
{
    USB_AT =0,
    USB_MODEM,
    USB_LOG,
    USB_MAX_TYPE_NUM
}
T_ZDrvUsb_DevType;


//define usb phy mode
typedef enum _T_ZDrvUsb_PhyType
{
    USB_NORMAL =0,
    USB_HSIC = 1,      //usb hsic
    USB_DWC3=2       //usb 3.0
}
T_ZDrvUsb_PhyType;

typedef enum _T_ZDrvUsb_DRMode
{
    USB_NONE =0,
    USE_USB_DEVICE =1,
    USE_USB_HOST =2
}
T_ZDrvUsb_DRMode;

typedef struct _T_ZDrvUsb_IP
{
    T_ZDrvUsb_PhyType  usb_Tpye;;
    T_ZDrvUsb_DRMode   usb_DRMode;
}
T_ZDrvUsb_IP;

typedef enum _T_ZDrvUsb_NVTYPE
{
    NAND_TYPE =0,
    GLOBAL_TYPE =1
}
T_ZDrvUsb_NVTYPE;

/****************************************************************************
* 	                                        macro module define
****************************************************************************/
//Main Function Define (bit1~bit15)
#define DEV_NULL					      0
#define DEV_CDC                           (1<<1)
#define DEV_NDIS					      (1<<2)
#define DEV_MASSSTORAGE 			      (1<<3)
#define DEV_MAIN_FUNC_MASK		          (0x00FF)
#define DEV_ECM_CCI					      (1<<4)
#define DEV_ECM_DCI					      (1<<5)
#define DEV_RNDIS_CCI                     (1<<6)
#define DEV_RNDIS_DCI                     (1<<7)
#define DEV_ADB                           (1<<8)

//Sub Function Define (bit16~bit32)
#define DEV_MASSSTORAGE_CDROM 	          ((1<<16)|DEV_MASSSTORAGE)
#define DEV_MASSSTORAGE_SD 		          ((1<<17)|DEV_MASSSTORAGE)
#define DEV_MASSSTORAGE_NAND 		      ((1<<18)|DEV_MASSSTORAGE)
#define DEV_MASSSTORAGE_RAMDISK 	      ((1<<19)|DEV_MASSSTORAGE)

//basic endpoint class
#define USB_IN_EP_CPU(epNum,RcvMode) 				{TRUE,USB_GET_EP_ADDR(epNum,1),EP_XFER_MODE_CPU,RcvMode}
#define USB_OUT_EP_CPU(epNum,RcvMode) 	 			{TRUE,USB_GET_EP_ADDR(epNum,0),EP_XFER_MODE_CPU,RcvMode}
#define USB_IN_EP_DMA1REQ1(epNum,RcvMode) 	 		{TRUE,USB_GET_EP_ADDR(epNum,1),EP_XFER_MODE_DMA1REQ1,RcvMode}
#define USB_OUT_EP_DMA1REQ1(epNum,RcvMode) 	 		{TRUE,USB_GET_EP_ADDR(epNum,0),EP_XFER_MODE_DMA1REQ1,RcvMode}
#define USB_OUT_EP_DMA1REQ0(epNum,RcvMode) 			{TRUE,USB_GET_EP_ADDR(epNum,0),EP_XFER_MODE_DMA1REQ0,RcvMode}
#define USB_NULL_EP									{FALSE,0,0,0}

#define USB_EP_XFER_MODE 1
#define USB_EP_XFEREND_CONDI 2

#define USB_GET_EP_XFER_MODE(epNum) 			usbStack_GetEpInfo(epNum,USB_EP_XFER_MODE)
#define USB_GET_EP_XFER_END_CONDI(epNum) 		usbStack_GetEpInfo(epNum,USB_EP_XFEREND_CONDI)

//cdc interface class
//#define USB_IFAC_CDC_CPU(funCode,epNum,name) 	{TRUE,funCode,USB_IN_EP_CPU(epNum,EP_PACKET_BASE),USB_OUT_EP_CPU(epNum,EP_PACKET_BASE),USB_NULL_EP,name}
#define USB_IFAC_CDC_CPU(funCode,epNum,name,func) 	{TRUE,funCode,USB_IN_EP_CPU(epNum,EP_PACKET_BASE),USB_OUT_EP_CPU(epNum,EP_PACKET_BASE),USB_NULL_EP,name,func}

#define USB_IFAC_CDC_DMA(funCode,epNum,name,func)    {TRUE,funCode,USB_IN_EP_DMA1REQ1(epNum,EP_PACKET_BASE),USB_OUT_EP_DMA1REQ1(epNum,EP_PACKET_BASE),USB_NULL_EP,name,func}

#define USB_CCIFAC_ECM_CPU(funCode,epNum,name,func)	{TRUE,funCode,USB_NULL_EP,USB_NULL_EP,USB_IN_EP_CPU(epNum,EP_PACKET_BASE),name,func}
#define USB_DCIFAC_ECM_DMA(funCode,epNum,name,func)    {TRUE,funCode,USB_IN_EP_DMA1REQ1(epNum,EP_PACKET_BASE),USB_OUT_EP_DMA1REQ1(epNum,EP_PACKET_BASE),USB_NULL_EP,name,func}
//mass storage interface  class
#define USB_IFAC_MASS_CPU(funCode,epNum,name,func)   {TRUE,funCode,USB_IN_EP_CPU(epNum,EP_LENGTH_BASE),USB_OUT_EP_CPU(epNum,EP_LENGTH_BASE),USB_NULL_EP,name,func}
#define USB_IFAC_MASS_DMA(funCode,epNum,name,func)   {TRUE,funCode,USB_IN_EP_DMA1REQ1(epNum,EP_LENGTH_BASE),USB_OUT_EP_DMA1REQ0(epNum,EP_LENGTH_BASE),USB_NULL_EP,name,func}

//ndis interface class
#define USB_IFAC_NDIS_DMA(funCode,epNum1,epNum2,name,func) {TRUE,funCode,USB_IN_EP_DMA1REQ1(epNum1,EP_PACKET_BASE),USB_OUT_EP_DMA1REQ1(epNum1,EP_PACKET_BASE),USB_IN_EP_CPU(epNum2,EP_PACKET_BASE),name,func}
#define USB_IFAC_NDIS_CPU(funCode,epNum1,epNum2,name,func) {TRUE,funCode,USB_IN_EP_CPU(epNum1,EP_PACKET_BASE),USB_OUT_EP_CPU(epNum1,EP_PACKET_BASE),USB_IN_EP_CPU(epNum2,EP_PACKET_BASE),name,func}

//rndis interface class
#define USB_CIFAC_RNDIS_CPU(funCode,epNum,name,func)   {TRUE,funCode,USB_NULL_EP,USB_NULL_EP,USB_IN_EP_CPU(epNum,EP_PACKET_BASE),name,func}
#define USB_DIFAC_RNDIS_DMA(funCode,epNum,name,func)   {TRUE,funCode,USB_IN_EP_DMA1REQ1(epNum,EP_PACKET_BASE),USB_OUT_EP_DMA1REQ1(epNum,EP_PACKET_BASE),USB_NULL_EP,name,func}

//ecm interface class
#define USB_IFAC_ECM_DMA(funCode,epNum1,epNum2,name,func) {TRUE,funCode,USB_IN_EP_DMA1REQ1(epNum1,EP_PACKET_BASE),USB_OUT_EP_DMA1REQ1(epNum1,EP_PACKET_BASE),USB_IN_EP_CPU(epNum2,EP_PACKET_BASE),name,func}
#define USB_IFAC_ECM_CPU(funCode,epNum1,epNum2,name,func) {TRUE,funCode,USB_IN_EP_CPU(epNum1,EP_PACKET_BASE),USB_OUT_EP_CPU(epNum1,EP_PACKET_BASE),USB_IN_EP_CPU(epNum2,EP_PACKET_BASE),name,func}

#define USB_IFAC_ADB_CPU(funCode,epNum,name,func) 	{TRUE,funCode,USB_IN_EP_CPU(epNum,EP_PACKET_BASE),USB_OUT_EP_CPU(epNum,EP_PACKET_BASE),USB_NULL_EP,name,func}
#define USB_IFAC_ADB_DMA(funCode,epNum,name,func)    {TRUE,funCode,USB_IN_EP_DMA1REQ1(epNum,EP_PACKET_BASE),USB_OUT_EP_DMA1REQ1(epNum,EP_PACKET_BASE),USB_NULL_EP,name,func}


/*
#ifndef _USE_AMT
*/
#if 0
#if !defined(_USE_AMT)&&!defined(_USE_SMALL_VERSION)
//#define DEFAULT_SWITCH_CONFIG_ECM   USB_CONFIG1  //ECM config
//#define DEFAULT_INSERT_CONFIG       USB_CONFIG0  //first config with cdrom 
//#define DEFAULT_INSERT_CONFIG_AMT   USB_CONFIG3  //amt only
//#define DEFAULT_SWITCH_CONFIG_NDIS  USB_CONFIG2  //NDIS config
//#define DEFAULT_SWITCH_CONFIG_RNDIS USB_CONFIG4 //RNDIS CONFIG
#else/*AMT not config NDIS device*/
#define DEFAULT_SWITCH_CONFIG_ECM   USB_CONFIG3
#define DEFAULT_INSERT_CONFIG       USB_CONFIG3
#define DEFAULT_INSERT_CONFIG_AMT   USB_CONFIG3
#define DEFAULT_SWITCH_CONFIG_NDIS  USB_CONFIG3
#define DEFAULT_SWITCH_CONFIG_RNDIS USB_CONFIG3
#endif
#endif
/****************************************************************************
* 	                                        Function Prototypes
****************************************************************************/
/*******************************************************************************
 * Function: zDrvUsbStack_SwitchConfiguration
 * Description:usb to switch the usb configuration
 * Parameters:
 			ConfigNum : the new cofig num, the value should less than macro: MAX_CONFIG_NUM
 * Input:None
 * Output:None
 *
 * Returns:
 * Others:
 ********************************************************************************/
VOID zDrvUsbStack_SwitchConfiguration(T_ZDrvUsb_ConfigType ConfigNum);

/*******************************************************************************
 * Function: zDrvUsbStack_GetConfigInfo
 * Description: user can use this function to inquire function code corresponding to the confignum
 * Parameters:
 * Input: config num
 * Output:None
 *
 * Returns:function code, if configNum is vailed, return value is zero
 * Others:
 ********************************************************************************/
UINT32 zDrvUsbStack_GetConfigInfo(UINT32 ConfigNum);

/*******************************************************************************
 * Function: zDrvUsbStack_SetMsContext
 * Description: get Mass Storage VendorName;ProductName;and ProductRevision for diff project in ref
 * Parameters:
 * Input: config num
 * Output:None
 *
 * Returns:function code, if configNum is vailed, return value is zero
 * Others:
 ********************************************************************************/

VOID zDrvUsbStack_SetMsContext(T_ZDrvUsb_MsContext *MsPtr);

/*******************************************************************************
 * Function: zDrvUsbStack_GetIfacFunctionCode
 * Description: user can use this function to inquire the specify interface function code corresponding 
                      to the confignum
 * Parameters:
 * Input: config num
 * Output:None
 *
 * Returns:function code, if configNum is vailed, return value is zero
 * Others:
 ********************************************************************************/
UINT32 zDrvUsbStack_GetIfacFunctionCode(UINT32 ConfigNum, UINT32 ifacNum);

/*******************************************************************************
 * Function: usbHal_GetUsbConfigContext
 * Description: get usb config context
 * Parameters:
 *   Input: N/A
 *
 *   Output: N/A
 * Returns: N/A

********************************************************************************/
T_ZDrvUsb_ConfigContext *usbHal_GetUsbConfigContext(UINT32 ConfigNum);

/*******************************************************************************
 * Function: usbHal_GetEcmConfigContext
 * Description: get ecm parameter
 * Parameters:
 *   Input: N/A
 *
 *   Output: N/A
 * Returns: N/A

 * Others:	//not use

 ********************************************************************************/
T_ZDrvUsb_EcmContext * usbHal_GetEcmConfigContext(UINT8 ifacNum_CCI);

/*******************************************************************************
 * Function: usbHal_CleanEcmConfigContext
 * Description: clean ecm parameter state
 * Parameters:
 *   Input: N/A
 *
 *   Output: N/A
 * Returns: N/A

 * Others:	//not use

 ********************************************************************************/
VOID usbHal_CleanEcmConfigContext(VOID);

/*******************************************************************************
 * Function: usbHal_GetUsbMode
 * Description: get usb mode hisc or normal
 * Parameters:
 *   Input: N/A
 *
 *   Output: N/A
 * Returns: N/A

 * Others:	//not use

 ********************************************************************************/
T_ZDrvUsb_PhyType usbHal_GetUsbMode(VOID);

/*******************************************************************************
 * Function: usbStack_msSetNVflag
 * Description: used in datecard set AT\Log\Modem flag in NV 
 *                   with singn whether enum it
 * Parameters:
 *   Input: N/A
 *
 *   Output: N/A
 * Returns: N/A

 * Others:	//not use

 ********************************************************************************/
SINT32 usbStack_msSetNVflag(VOID);

/*******************************************************************************
 * Function: USBHSIC_ReConnect_Ind
 * Description: for usb trap ind to host
 * Parameters:
 *   Input: N/A
 *
 *   Output: N/A
 * Returns: N/A

 * Others:	//not use

 ********************************************************************************/
VOID usbHal_HSICReConnect_Ind(VOID);
/*******************************************************************************
* Function: zDrvUsb_GetCommDevName
* Description:
* Parameters:
*   Input:
*
*   Output:
*
* Returns:
*
* Others:
********************************************************************************/
SINT32 zDrvUsb_GetUsbDevName(T_ZDrvUsb_DevType usbType,char * DevName,UINT8 StrSize);

/*******************************************************************************
 * Function: zDrvUsb_Work_Ahb_Phy_Reset
 * Description:
 * 
 * Parameters:
 *   Input:
 *
 *   Output:
 *
 * Returns:
 *
 *
 * Others:
 ********************************************************************************/
 VOID zDrvUsb_Work_Ahb_Phy_Reset(VOID);

/*******************************************************************************
 * Function: zDrvUsb_PowerUp
 * Description:
 * 
 * Parameters:
 *   Input:
 *
 *   Output:
 *
 * Returns:
 *
 *
 * Others:
 ********************************************************************************/
 SINT32 zDrvUsb_PowerUp(VOID);

/*******************************************************************************
 * Function: zDrvUsb_Powerdown
 * Description:
 * 
 * Parameters:
 *   Input:
 *
 *   Output:
 *
 * Returns:
 *
 *
 * Others:
 ********************************************************************************/
 SINT32 zDrvUsb_Powerdown(VOID);

/*******************************************************************************
 * Function: zDrvUsb3_PowerUp
 * Description:
 * 
 * Parameters:
 *   Input:
 *
 *   Output:
 *
 * Returns:
 *
 *
 * Others:
 ********************************************************************************/
 SINT32 zDrvUsb3_PowerUp(VOID);

/*******************************************************************************
 * Function: zDrvUsb3_Powerdown
 * Description:
 * 
 * Parameters:
 *   Input:
 *
 *   Output:
 *
 * Returns:
 *
 *
 * Others:
 ********************************************************************************/
 SINT32 zDrvUsb3_Powerdown(VOID);

/*******************************************************************************
 * Function: pow_GetUsbLowPowerFlag
 * Description: get usb low power flag
 * Parameters:
 *   Input: N/A
 *
 *   Output: N/A
 * Returns: 
 *          
 *
 * Others:	//not use
 ********************************************************************************/

UINT32 pow_GetUsbLowPowerFlag(VOID);

#endif

