/*******************************************************************************
 * Copyright (C) 2007, ZTE Corporation.
 *
 * File Name:
 * File Mark:
 * Description:  This source file contains the low level drivers to control the UICC
 *   interface (which includes the UART and the DMA).
 * Others:
 * Version:       v0.1
 * Author:        knm
 * Date:          2007-03-28
 * History 1:
 *     Date:
 *     Version:
 *     Author:
 *     Modification:
 * History 2:
  ********************************************************************************/


/****************************************************************************
*                                              Include files
****************************************************************************/
#include "oss_api.h"
#include "pub_debug_info.h"
#include "uicc_stub.h"
#include "uicc_ctrl.h"
#include "uicc_access.h"
#include "uicc_drv.h"
#include "uicc_trc.h"

#include "USIM_reg.h"


//#include "drvs_dma.h"
//#include "drvs_pm_typedefine.h"
#include "drvs_ramlog.h"
#include "drvs_pm.h"
#include "drvs_gpio.h"
#include "drvs_uicc_ref.h"
#include "drvs_uicc.h"
#include "drvs_pcu.h"
#include "drvs_uicc.h"
//#include "linux/mfd/zx234290.h"

/****************************************************************************
* 	                                           Local Macros
****************************************************************************/
#ifdef DMAD2_ENABLE
#define UICC_DMA_Alloc_Sem_TAG  "UICC_sem"
#endif


/****************************************************************************
* 	                                           Local Types
****************************************************************************/

/****************************************************************************
* 	                                           Local Constants
****************************************************************************/

/****************************************************************************
* 	                                           Local Variables
****************************************************************************/
#ifdef DMAD2_ENABLE
static ubyte UICC_DMA_alloc = FALSE;
#endif
UINT16 gVsimType = PM_VOLT_MAX_STATUS;
ZOSS_SEMAPHORE_ID UICC_power_sem = NULL;
extern T_Ring_Queue *UICC_power_msg_queue;
#define T_DELAY_VCC_TO_IO        5000//1000 /* [us] The delay between activating Vcc and I/O. */  

/****************************************************************************
* 	                                          Global Constants
****************************************************************************/

/****************************************************************************
* 	                                          Global Variables
****************************************************************************/
#if 0
volatile tSIM_DMA* sSIM_DMA=((volatile tSIM_DMA *) (AXI_AHB0_USIM_BASE + 0x0084));
volatile tSIM_T1CTRL* sSIM_T1CTRL=((volatile tSIM_T1CTRL *) (AXI_AHB0_USIM_BASE + 0x0040));
volatile tSIM_CTRL2* sSIM_CTRL2=((volatile tSIM_CTRL2 *) (AXI_AHB0_USIM_BASE + 0x003c));
volatile tSIM_CTRL* sSIM_CTRL=((volatile tSIM_CTRL *) (AXI_AHB0_USIM_BASE + 0x0020));
#endif
#if 1
extern volatile tSIM_DMA* sSIM_DMA;
extern volatile tSIM_T1CTRL* sSIM_T1CTRL;
extern volatile tSIM_CTRL2* sSIM_CTRL2;
extern volatile tSIM_CTRL* sSIM_CTRL;
#endif

extern T_UICC_CARD_TYPE card_type_ctrl[3];

#ifdef INTERRUPT_TRACE
ulong UICC_interrupt_trace[UICC_INTERRUPT_CNT_SIZE];
ushort UICC_interrupt_cnt = 0;
#endif

#ifdef DMAD2_ENABLE
NU_SEMAPHORE UICC_DMA_Alloc_Sem;

dmad2_config_struct*  pUICC_Tx_DMA_Config;
#endif

/****************************************************************************
* 	                                          Global Function Prototypes
****************************************************************************/
extern volatile unsigned int *PCL_pad(int function);
extern VOID uiccDebug_Printf(char *fmt,...);
extern ubyte UICC_obtain_semaphore(ZOSS_SEMAPHORE_ID semaphore);
extern void deactivate_card_connections(void);

extern int zDrvPmic_SetNormal_Onoff(T_ZDrvPmic_Regulator regulator, T_ZDrvPmic_Enable enable);
extern int zDrvPmic_SetNormal_Voltage(T_ZDrvPmic_Regulator regulator, int voltage);


/****************************************************************************
* 	                                          Function Definitions
****************************************************************************/
/*******************************************************************************
  * Function: wait
  * Description:
  * Parameters:
  *	 Input:
	 *
	 *	 Output: 500/624 = 0.801us > 50 ns : usim ip limited
	 *
	 * Returns:
	 *
	 *
	 * Others:
********************************************************************************/
static inline VOID wait_time(UINT32 delay)
{
	if (UICC_ESIM_CARD == card_type_ctrl[0])
	{
		volatile UINT32 t = delay * 10; 
		while ((t--) > 0);
	}
	else
	{
		// volatile UINT32 t = delay * 10;
		// while ((t--) > 0);
	}
}

/******************************************************************************
* Function:... UICC_init_card_interface
* Parameters:. None.
* Returns:.... None.
* Description: Initialize the card InterFace, interrupts and the ports used for
*              card communication. Shall be called once after power on.
* Created:.... 24.05.00 by (Knud Nymann Mortensen / KNM)
* Modified:... DD.MM.YY by (Full name / initials)
*                Modifications note.
*******************************************************************************/
void UICC_init_card_interface(void)
{

#ifdef DMAD2_ENABLE
    ubyte DMA_Alloc_Return;
#endif

    /* Card Vcc can be used for alternative functions. Therefore the PIN needs to
       be reconfigurated. */
#if 0
    VOID (*old_lisr)(INT);
#endif

    /* Register the interrupts with Nucleus. */
    SIM_ICR  |= 0x0004;  /* Clear the OK interrupt request bit. */
    wait_time(50);/*add by wangxia 10.05.11*/


#if defined (UICC_FIFO_MODE)
    SIM_FIFO_ICR  |= 0x03FF;  /* Clear the FIFO interrupt request bit. */
    wait_time(50);/*add by wangxia 10.05.11*/
#endif

    SIM_ICR  |= 0x0001;  /* Clear the ERR interrupt request bit. */
    wait_time(50);/*add by wangxia 10.05.11*/

#ifdef UICC_ENABLE_IN_OUT_DETECTION
    SIM_ICR  |= 0x0002;  /* Clear the IN interrupt request bit. */
#endif

#ifdef DMAD2_ENABLE
    if (UICC_DMA_alloc ==FALSE)
    {
        UICC_DMA_alloc = TRUE;
        NU_Create_Semaphore( &UICC_DMA_Alloc_Sem, UICC_DMA_Alloc_Sem_TAG, 1, NU_FIFO );

        pUICC_Tx_DMA_Config = DMA_Obtain_Struct();

        /*Dummy init struct use for DMA_Alloc_Resources*/
#if defined (UICC_FIFO_MODE)
        pUICC_Tx_DMA_Config ->src_burst_size = dma_sbsize_4;
        pUICC_Tx_DMA_Config ->dest_burst_size  = dma_dbsize_4;
        pUICC_Tx_DMA_Config ->src_transfer_width = dma_swidth_word;
        pUICC_Tx_DMA_Config ->dest_transfer_width = dma_dwidth_word;
        pUICC_Tx_DMA_Config ->increment = dma_src_incr_only;
        pUICC_Tx_DMA_Config ->src_address    = NULL;
        pUICC_Tx_DMA_Config ->dest_address  = NULL;
#else
        pUICC_Tx_DMA_Config ->src_burst_size = dma_sbsize_1;
        pUICC_Tx_DMA_Config ->dest_burst_size  = dma_dbsize_1;
        pUICC_Tx_DMA_Config ->src_transfer_width = dma_swidth_byte;
        pUICC_Tx_DMA_Config ->dest_transfer_width = dma_dwidth_byte;
        pUICC_Tx_DMA_Config ->increment = dma_src_incr_only;
        pUICC_Tx_DMA_Config ->src_address    = NULL;
        pUICC_Tx_DMA_Config ->dest_address  = NULL;
#endif

        pUICC_Tx_DMA_Config ->transfer_size  = 10;

        pUICC_Tx_DMA_Config ->dma_master_select = dma_src_m1_dest_m1;

        pUICC_Tx_DMA_Config ->p_dma_config_static_struct->src_peripheral_id = memory_dma_sgold3;

        pUICC_Tx_DMA_Config ->p_dma_config_static_struct->dest_peripheral_id = usim_txrx_sgold3;

        pUICC_Tx_DMA_Config ->p_dma_config_static_struct->p_DMA_Allocation_Semaphore = &UICC_DMA_Alloc_Sem;

        pUICC_Tx_DMA_Config ->p_dma_config_static_struct->p_DMA_Transfer_Semaphore = NULL;

        pUICC_Tx_DMA_Config ->p_dma_config_static_struct->callback_end_function = NULL; /*not use interrupt set call back funktion to NULL*/

        pUICC_Tx_DMA_Config ->flow_control = dma_mem_to_perip_perip;  /* Memory to Peripheral; Peripheral is Flow Controller */

        DMA_Alloc_Return =  DMA_Alloc_Resources(pUICC_Tx_DMA_Config, dma_wait_for_allocation, statical_dma_transfer);   /* Static Allocated */

        if (DMA_Alloc_Return != dma_resource_allocated)
        {
#ifndef UICC_NO_DEBUG
            UICC_log_data_ptr[0] = (ubyte) DMA_Alloc_Return;
            UICC_raise_exception(TRAP_UICC_UART, UICC_DMA_ALLOC_FAILED, 1);
#endif
        }

    }
#endif

    UICC_enable_usim_ok_isr();
    UICC_enable_usim_err_isr();
#ifdef UICC_ENABLE_IN_OUT_DETECTION
    UICC_enable_usim_in_isr();
#endif

#if defined (SGOLD2) || defined (SGOLD3) || defined (SGOLDRADIO)
    SIM_TXSPC = 0x02;                   /* Spacing between TX characters. */
    wait_time(50);/*add by wangxia 10.05.11*/
#else
    if ((UICC_baseband_profile.version == SYS_BB_VER_SGOLD) &&
            (UICC_baseband_profile.revision < SYS_BB_REV_12))
    { /* ONLY for S-GOLD < ES2.5 */
        SIM_TXSPC = 0x00;                   /* Spacing between TX characters to avoid 'ghost' characters
        in after Tx parity error retransmission. */
        wait_time(50);/*add by wangxia 10.05.11*/
    }
    else
    { /* UTP: WS00002548 corrected. Tx space does not need to hold the TX space value of minimum 3. */
        SIM_TXSPC = 0x02;                   /* Spacing between TX characters. */
        wait_time(50);/*add by wangxia 10.05.11*/
    }
#endif /* SGOLDRADIO */
}

/******************************************************************************
* Function:... UICC_reset_card_interface
* Parameters:. None.
* Returns:.... None.
* Description: Reset the SIM HW control register to it's initial value.
* Created:.... 01.12.03 by (Knud Nymann Mortensen / KNM)
* Modified:... DD.MM.YY by (Full name / initials)
*                Modifications note.
*******************************************************************************/
void UICC_reset_card_interface(void)
{
#ifdef UICC_MODULE_TEST
    if (UICC_module_test_state == UICC_MODULE_TEST_HW_DECOUPLED)
    {
        UICC_simulated_hw_reg._SIM_CTRL = 0x0000;
        return;
    }
#endif

    SIM_CTRL = 0x0000;
}

/******************************************************************************
* Function:... UICC_enable_card_interface
* Parameters:. None.
* Returns:.... None.
* Description: This function enables the card card interface (SIMEN). The UART
*              will now be in RX-mode.
* Created:.... 24.05.00 by (Knud Nymann Mortensen / KNM)
* Modified:... DD.MM.YY by (Full name / initials)
*                Modifications note.
*******************************************************************************/
void UICC_enable_card_interface(void)
{
#ifdef UICC_MODULE_TEST
    if (UICC_module_test_state == UICC_MODULE_TEST_HW_DECOUPLED)
    {
        UICC_simulated_hw_reg._SIM_CTRL |= 0x0008; /* Enable the card enterface (SIMEN=1).  */
        UICC_switch_uart_clock_on();
        return;
    }
#endif

    SIM_CTRL |= 0x0008;             /* Enable the card enterface (SIMEN=1).  */
    wait_time(50);/*add by wangxia 10.05.11*/

    UICC_switch_uart_clock_on();
}

/******************************************************************************
* Function:... UICC_disable_card_interface
* Parameters:. None.
* Returns:.... None.
* Description: This function disables the card card interface (SIMEN).
* Created:.... 24.05.00 by (Knud Nymann Mortensen / KNM)
* Modified:... DD.MM.YY by (Full name / initials)
*                Modifications note.
*******************************************************************************/
void UICC_disable_card_interface(void)
{
#ifdef UICC_MODULE_TEST
    if (UICC_module_test_state == UICC_MODULE_TEST_HW_DECOUPLED)
    {
        UICC_simulated_hw_reg._SIM_CTRL &= 0xFFF7; /* SIMEN=0 */
        return;
    }
#endif

    SIM_CTRL &= 0xFFF7;             /* SIMEN=0                              */
    wait_time(50);/*add by wangxia 10.05.11*/
}

/******************************************************************************
* Function:... UICC_select_character_mode
* Parameters:. None.
* Returns:.... None.
* Description: This function initialise the card interface to operate in the
*              normal character based mode. This also means that the T=0 and T=1
*              instruction mode will be disabled.
* Created:.... 24.05.00 by (Knud Nymann Mortensen / KNM)
* Modified:... DD.MM.YY by (Full name / initials)
*                Modifications note.
*******************************************************************************/
void UICC_select_character_mode(void)
{
#ifdef UICC_MODULE_TEST
    if (UICC_module_test_state == UICC_MODULE_TEST_HW_DECOUPLED)
    {
        UICC_simulated_hw_reg._SIM_CTRL &= 0xFFFD; /* SIMT0=0 */
        return;
    }
#endif

    SIM_CTRL &= 0xFFFD;             /* SIMT0=0                              */
    wait_time(50);/*add by wangxia 10.05.11*/
}

/******************************************************************************
* Function:... UICC_select_T0_instruction_mode
* Parameters:. None.
* Returns:.... None.
* Description: This function initialise the card interface to operate in the
*              T=0 instruction mode which means that the T=0 protocol will be
*              handled by the HW. This also means that the normal character
*              based mode will be disabled.
* Created:.... 24.05.00 by (Knud Nymann Mortensen / KNM)
* Modified:... DD.MM.YY by (Full name / initials)
*                Modifications note.
*******************************************************************************/
void UICC_select_T0_instruction_mode(void)
{
#ifdef UICC_MODULE_TEST
    if (UICC_module_test_state == UICC_MODULE_TEST_HW_DECOUPLED)
    {
        UICC_simulated_hw_reg._SIM_CTRL |= 0x0002; /* Select T0 mode. */
        UICC_simulated_hw_reg._SIM_CTRL &= 0x7FFF; /* Disable T1 mode. */
        return;
    }
#endif

    sSIM_CTRL->SIMT0 = 1; /* Select T0 mode. */
    sSIM_CTRL->SIMT1 = 0; /* Disable T1 mode. */
}

/******************************************************************************
* Function:... UICC_select_T1_tx_instruction_mode
* Parameters:. None.
* Returns:.... None.
* Description: This function initialise the card interface to operate in the
*              T=1 transmit instruction mode which means that the receive part
*              of the T=1 protocol will be handled by the HW. This also means
*              that the normal character based mode will be disabled.
* Created:.... ?6.11.02 by (Knud Nymann Mortensen / KNM)
* Modified:... DD.MM.YY by (Full name / initials)
*                Modifications note.
*******************************************************************************/
void UICC_select_T1_tx_instruction_mode(void)
{
#ifdef UICC_MODULE_TEST
    if (UICC_module_test_state == UICC_MODULE_TEST_HW_DECOUPLED)
    {
        UICC_simulated_hw_reg._SIM_CTRL |= 0x8000; /* Select T1 mode. */
        UICC_simulated_hw_reg._SIM_CTRL &= 0xFFFD; /* Select T1 transmit (Tx) mode */
        return;
    }
#endif

    sSIM_CTRL->SIMT1 = 1;  /* Select T1 mode. */
    sSIM_CTRL->SIMT0 = 0;  /* Select T1 transmit (Tx) mode */
}

/******************************************************************************
* Function:... UICC_select_T1_rx_instruction_mode
* Parameters:. None.
* Returns:.... None.
* Description: This function initialise the card interface to operate in the
*              T=1 transmit instruction mode which means that the receive part
*              of the T=1 protocol will be handled by the HW. This also means
*              that the normal character based mode will be disabled.
* Created:.... ?6.11.02 by (Knud Nymann Mortensen / KNM)
* Modified:... DD.MM.YY by (Full name / initials)
*                Modifications note.
*******************************************************************************/
void UICC_select_T1_rx_instruction_mode(void)
{
#ifdef UICC_MODULE_TEST
    if (UICC_module_test_state == UICC_MODULE_TEST_HW_DECOUPLED)
    {
        UICC_simulated_hw_reg._SIM_CTRL |= 0x8000; /* Select T1 mode. */
        UICC_simulated_hw_reg._SIM_CTRL |= 0x0002; /* Select T1 receive (Rx) mode */
        return;
    }
#endif

    sSIM_CTRL->SIMT1 = 1;  /* Select T1 mode. */
    sSIM_CTRL->SIMT0 = 1;  /* Select T1 receive (Rx) mode */
}

/******************************************************************************
* Function:... UICC_switch_uart_clock_on
* Parameters:. None.
* Returns:.... None.
* Description: This function switches ON the UART and T=0 clock.
* Created:.... 24.05.00 by (Knud Nymann Mortensen / KNM)
* Modified:... DD.MM.YY by (Full name / initials)
*                Modifications note.
*******************************************************************************/
void UICC_switch_uart_clock_on(void)
{
#ifdef UICC_MODULE_TEST
    if (UICC_module_test_state == UICC_MODULE_TEST_HW_DECOUPLED)
    {
        UICC_simulated_hw_reg._SIM_CTRL |= 0x2000;             /* UARTON=1 */
        return;
    }
#endif

    SIM_CTRL |= 0x2000;             /* UARTON=1                             */
    wait_time(50);/*add by wangxia 10.05.11*/
}

/******************************************************************************
* Function:... UICC_switch_uart_clock_off
* Parameters:. None.
* Returns:.... None.
* Description: This function switches OFF the UART and T=0 clock.
* Created:.... 24.05.00 by (Knud Nymann Mortensen / KNM)
* Modified:... DD.MM.YY by (Full name / initials)
*                Modifications note.
*******************************************************************************/
void UICC_switch_uart_clock_off(void)
{
#ifdef UICC_MODULE_TEST
    if (UICC_module_test_state == UICC_MODULE_TEST_HW_DECOUPLED)
    {
        UICC_simulated_hw_reg._SIM_CTRL &= 0xDFFF;             /* UARTON=0 */
        return;
    }
#endif

    SIM_CTRL &= 0xDFFF;             /* UARTON=0                             */
    wait_time(50);/*add by wangxia 10.05.11*/
}

#if defined (SMPOWER3) || defined (SGOLDRADIO) || defined (POWER_CONCEPT_3)
/* ˶ԼĴĲΪĿǰûеԴģ飬ڿƿĵԴʱ
ϵȥ⣬ڲӦĴ쳣ʱرտƿԴеԴģʱٴĺĲʡ硣*/
static void voltage_ctrl(T_UICC_VOLTAGE_CLASS voltage_class, ubyte activate)
{
#if defined (SGOLDRADIO)
    /*======================*/
    /* SGOLDRadio           */
    /*======================*/
    PMU_DOMAIN_VOLTAGE_T voltage_level = PMU_DOMAIN_VOLTAGE_2V9;
    PMU_APPL_STATE_T enable = PMU_APP_ON;

    if (UICC_CLASS_C == voltage_class)
        voltage_level = PMU_DOMAIN_VOLTAGE_1V80;

    if (!activate)
        enable = PMU_APP_OFF;

    if (PMU_req_domain_voltage (PMU_DOMAIN_VSIM, voltage_level, enable) != STD_OK)
    {
#ifndef UICC_NO_DEBUG
        UICC_log_data_ptr[0] = (ubyte) voltage_level;
        UICC_raise_exception(TRAP_UICC_UART, (activate) ? UICC_ACTIVATE_VCC_FAILED : UICC_DEACTIVATE_VCC_FAILED, 1);
#endif
    }
#elif defined (POWER_CONCEPT_3)
    /*======================*/
    /* PC3                  */
    /*======================*/
    POW_VOLTAGE_T voltage_level = POW_SIM_3V_VOLTAGE;

    if (UICC_CLASS_C == voltage_class)
        voltage_level = POW_SIM_1V8_VOLTAGE;

    if (activate) /*activate VCC*/
    {
        if (POW_SetVoltageDemands(POW_SIM_VDD, voltage_level, POW_VOLTAGE_ENABLE) != POW_OK)
        {
#ifndef UICC_NO_DEBUG
            UICC_log_data_ptr[0] = (ubyte) voltage_level;
            UICC_raise_exception(TRAP_UICC_UART, UICC_ACTIVATE_VCC_FAILED, 1);
#endif
        }
    }
    else /*Deactivate VCC*/
    {
        if (POW_SetVoltageDemands(POW_SIM_VDD, voltage_level, POW_VOLTAGE_DISABLE) != POW_OK)
        {
#ifndef UICC_NO_DEBUG
            UICC_log_data_ptr[0] = (ubyte) voltage_level;
            UICC_raise_exception(TRAP_UICC_UART, UICC_DEACTIVATE_VCC_FAILED, 1);
#endif
        }

        /*IO, CLK and RESET LOW*/
        UICC_disable_io(UICC_current_reader); /*IO LOW*/
        UICC_set_low_clock_stop_level(UICC_current_reader);
        UICC_deactivate_rst(UICC_current_reader);

    }
#elif defined (SMPOWER3)
    /*======================*/
    /* SMPOWER3             */
    /*======================*/
    POW_DOMAIN_VOLTAGE_T voltage_level = POW_DOMAIN_VOLTAGE_2V9;

    if (UICC_CLASS_C == voltage_class)
        voltage_level = POW_DOMAIN_VOLTAGE_1V8;

    if (activate) /*activate VCC*/
    {
        if (PMU_req_domain_voltage (PMU_DOMAIN_VSIM, voltage_level, PMU_APP_ON) != STD_OK)
        {
#ifndef UICC_NO_DEBUG
            UICC_log_data_ptr[0] = (ubyte) voltage_level;
            UICC_raise_exception(TRAP_UICC_UART, UICC_ACTIVATE_VCC_FAILED, 1);
#endif
        }

    }
    else /*Deactivate VCC*/
    {
        if (PMU_req_domain_voltage (PMU_DOMAIN_VSIM, voltage_level, PMU_APP_OFF) != STD_OK)
        {
#ifndef UICC_NO_DEBUG
            UICC_log_data_ptr[0] = (ubyte) voltage_level;
            UICC_raise_exception(TRAP_UICC_UART, UICC_DEACTIVATE_VCC_FAILED, 1);
#endif
        }

        /*IO, CLK and RESET LOW*/
        UICC_disable_io(UICC_current_reader); /*IO LOW*/
        UICC_set_low_clock_stop_level(UICC_current_reader);
        UICC_deactivate_rst(UICC_current_reader);

    }
#endif
}
/* end of UICC_Driver_2007_10_25_dcm */

/******************************************************************************
* Function:... UICC_activate_vcc
* Parameters:. card_selector.
* Returns:.... None.
* Description: Activate VCC towards the card.
* Created:.... 24.05.00 by (Knud Nymann Mortensen / KNM)
* Modified:... 11.10.06 by (Knud Nymann Mortensen / KNM)
*                - Seperated the function out for SGOLDRadio (to clean up)
*******************************************************************************/
void UICC_activate_vcc(T_UICC_CARD_SELECTOR card_selector,
                       T_UICC_VOLTAGE_CLASS voltage_class,
                       ubyte sequence_number)
{
#ifdef UICC_MODULE_TEST
    if (UICC_module_test_state == UICC_MODULE_TEST_HW_DECOUPLED)
    {
        UICC_simulated_hw_reg._VOLTAGE_CTRL = (ulong)((card_selector<<16) | (voltage_class<<8) | sequence_number);
        return;
    }
#endif

    switch (card_selector)
    {
    case UICC_PRIMARY_CARD:
        /*-------------------------*/
        switch (sequence_number)
        {
        case 2:
            /*------*/
            voltage_ctrl(voltage_class, TRUE);
            break;

        case 1:
        default:
            /*------*/
            break;

        }

    case UICC_SECONDARY_CARD_1:
    default:
        /*-------------------------*/
        /* 2nd card currently NOT supported. */
        break;
    }
}

/******************************************************************************
* Function:... UICC_deactivate_vcc
* Parameters:. None.
* Returns:.... None.
* Description: Deactivate VCC towards the card.
* Created:.... 24.05.00 by (Knud Nymann Mortensen / KNM)
* Modified:... 11.10.06 by (Knud Nymann Mortensen / KNM)
*                - Seperated the function out for SGOLDRadio (to clean up)
*******************************************************************************/
void UICC_deactivate_vcc(T_UICC_CARD_SELECTOR card_selector)
{
#ifdef UICC_MODULE_TEST
    if (UICC_module_test_state == UICC_MODULE_TEST_HW_DECOUPLED)
    {
        UICC_simulated_hw_reg._VOLTAGE_CTRL = (ulong)((card_selector<<16) | 0xFF);
        return;
    }
#endif

    switch (card_selector)
    {
    case UICC_PRIMARY_CARD:
        /*-------------------------*/
        voltage_ctrl(UICC_CLASS_C, FALSE);
        break;

    case UICC_SECONDARY_CARD_1:
    default:
        /*-------------------------*/
        /* 2nd card currently NOT supported. */
        break;
    }
}


#else

SINT32 zDrvDDUicc_SendPowerMsg(T_UICC_VOLTAGE_CLASS voltage_class, T_ZDrvUicc_PowerAction action, T_ZDrvPmic_Regulator regulator)
{
    T_UICC_POWER_MSG msg = {0};
    SINT32 ret;
    
    msg.VsimType= voltage_class;
    msg.action = action;
    msg.regulator = regulator;

    ret = ringQueue_Enqueue(UICC_power_msg_queue, &msg);
    zDrv_ASSERT(ret == 0);

    zOss_PutSemaphore(UICC_power_sem);
    
    return ret;
}


/*  ˶ԼĴĲΪĿǰûеԴģ飬ڿƿĵԴʱ
ϵȥ⣬ڲӦĴ쳣ʱرտƿԴеԴģʱٴĺĲʡ硣*/
/******************************************************************************
* Function:... UICC_activate_vcc
* Parameters:. card_selector.
* Returns:.... None.
* Description: Activate VCC towards the card.
* Created:.... 24.05.00 by (Knud Nymann Mortensen / KNM)
* Modified:... 27.10.03 by (Full name / initials)
*                - Added voltage class indication as parameter and prepared the
*                 support for SM Power version 1.5
*******************************************************************************/
void UICC_activate_vcc(T_UICC_CARD_SELECTOR card_selector,
                       T_UICC_VOLTAGE_CLASS voltage_class,
                       ubyte sequence_number)
{
	T_ZDrvPmic_Regulator regulator = VSIM1;
#ifdef UICC_MODULE_TEST
    if (UICC_module_test_state == UICC_MODULE_TEST_HW_DECOUPLED)
    {
        UICC_simulated_hw_reg._VOLTAGE_CTRL = (ulong)((card_selector<<16) | (voltage_class<<8) | sequence_number);
        return;
    }
#endif

    if (UICC_ESIM_CARD == card_type_ctrl[card_selector])
    {
	     regulator = VSIM2;
    }
    else
    {
	     regulator = VSIM1;
    }
	
    switch (card_selector)
    {
    case UICC_PRIMARY_CARD:
        /*-------------------------*/
#ifdef USE_SMPOWER
        /* Based ont the SM Power version, activate the SIM voltage. */
        if (POW_get_power_chip_version() == POW_chip_version_10)
        { /* SM Power version 1.0 -> 3 SIM voltage supported ONLY! */
            /* Activate SIM voltage */
            if (sequence_number == 2)
            {
                POW_setVSIM1(PWCTRL5_LSIMMD_STB_VCXOENn, PWRCTRL1_LSIMMD_ON, PWCTRL5_LSIMV_2_85_V);
                POW_setVSIM2(PWCTRL5_LSIM2MD_STB_VCXOENn, PWRCTRL1_VSIM2ON_ON, PWCTRL5_LSIM2V_2_85_V);
#if defined DWD_HW_FP1E_FALCON
                SIM_CTRL |= 0x0010; /* SIMVCC=1 i.e. CCVZ_n is set to physical LOW level. */
#endif
            } /* else: do nothing. */
        }
        else /* SM Power version > 1.0 -> 3V & 1,8V SIM voltage supported */
#endif
        {
            switch (sequence_number)
            {
            case 1:
                /* Select SIM voltage level. */
#if !defined(SGOLD3) /* For the SGOLD3 wait to turn on when sequence number = 2 */
                if (voltage_class == UICC_CLASS_B)
                { /* CLASS B ~ 3V */
#ifdef USE_SMPOWER
                    POW_setVSIM1(PWCTRL5_LSIMMD_STB_VCXOENn, PWRCTRL1_LSIMMD_ON, PWCTRL5_LSIMV_2_85_V);
#endif
                }
                else
                { /* CLASS C ~ 1.8V */
#ifdef USE_SMPOWER
                    POW_setVSIM1(PWCTRL5_LSIMMD_STB_VCXOENn, PWRCTRL1_LSIMMD_ON, PWCTRL5_LSIMV_1_8_V);
#endif
                }
#endif

                break;
            case 2:
                /* Activate SIM voltage */
#if defined(SGOLD2) && !defined(DWD_HW_MPE_ICE)
                *PCL_pad(PAD_SIM_VCC) = PCL_ENABLE | PCL_NO_PUPD | PCL_PUSH_PULL  | PCL_RESET_OPTIONAL | PCL_GPIO | PCL_GPIO_OUT  | PCL_GPIO_D0;  /* GPIO low */
#elif defined(SGOLD3)
if (voltage_class == UICC_CLASS_B)
{ /* CLASS B ~ 3V */
#ifdef USE_SMPOWER
#if defined (SMPOWER3)
    if (PMU_req_domain_voltage (PMU_DOMAIN_VSIM, POW_DOMAIN_VOLTAGE_2V9, PMU_APP_ON) != STD_OK)
    {
#ifndef UICC_NO_DEBUG
        UICC_log_data_ptr[0] = (ubyte) POW_DOMAIN_VOLTAGE_2V9;
        UICC_raise_exception(TRAP_UICC_UART, UICC_ACTIVATE_VCC_FAILED, 1);
#endif
    }

#elif
POW_setVSIM1(PWCTRL5_LSIMMD_STB_VCXOENn, PWRCTRL1_LSIMMD_ON, PWCTRL5_LSIMV_2_85_V);

#endif
#endif
#if 0
    UICC_PowerUp_2V9();
#else
//gVsimType = PM_VSIM_3_000;
gVsimType = 3000;//PM_VOLT_3_000;

//				gVsimType = PM_VSIM_2_900;
#ifdef MTNET

zDrvRamlog_PRINTF(RAMLOG_MOD_UICC, "gVsimType is 3V\n");
uiccramlog_Printf("gVsimType is 3V\n");

#endif
//gUicc2_9Cnt++;
//zOss_PutSemaphore(UICC_power_sem);
zDrvDDUicc_SendPowerMsg(gVsimType, DRV_CARD_POWERUP,  regulator);

#endif
}
else
{ /* CLASS C ~ 1.8V */
#ifdef USE_SMPOWER
#if defined (SMPOWER3)
    if (PMU_req_domain_voltage (PMU_DOMAIN_VSIM, POW_DOMAIN_VOLTAGE_1V8, PMU_APP_ON) != STD_OK)
    {
#ifndef UICC_NO_DEBUG
        UICC_log_data_ptr[0] = (ubyte) POW_DOMAIN_VOLTAGE_1V8;
        UICC_raise_exception(TRAP_UICC_UART, UICC_ACTIVATE_VCC_FAILED, 1);
#endif
    }

#elif
POW_setVSIM1(PWCTRL5_LSIMMD_STB_VCXOENn, PWRCTRL1_LSIMMD_ON, PWCTRL5_LSIMV_1_8_V);
#endif
#endif
#if 0
    UICC_PowerUp_1V8();
#else
//gVsimType = PM_VSIM_1_800;
gVsimType = 1800;//PM_VOLT_1_800;

//gUicc1_8Cnt++;
#ifdef MTNET
zDrvRamlog_PRINTF(RAMLOG_MOD_UICC, "gVsimType is 1.8V\n");
uiccramlog_Printf("gVsimType is 1.8V\n");

#endif
//zOss_PutSemaphore(UICC_power_sem);
zDrvDDUicc_SendPowerMsg(gVsimType, DRV_CARD_POWERUP, regulator);

#endif
}
#else
SIM_CTRL |= 0x0010; /* SIMVCC=1 i.e. CCVZ_n is set to physical LOW level. */
#endif
                break;
            default:
                break;
            }
        }
        break;
    case UICC_SECONDARY_CARD_1:
    default:
        /*-------------------------*/
#ifdef USE_SMPOWER
        /* Based ont the SM Power version, activate the SIM voltage. */
        if (POW_get_power_chip_version() == POW_chip_version_10)
        { /* SM Power version 1.0 -> 3 SIM voltage supported ONLY! */
            POW_setVSIM2(PWCTRL5_LSIM2MD_STB_VCXOENn, PWRCTRL1_VSIM2ON_ON, PWCTRL5_LSIM2V_2_85_V);
        }
        else /* SM Power version > 1.0 -> 3V & 1,8V SIM voltage supported */
#endif
        {
            /* Select SIM voltage level. */
            if (voltage_class == UICC_CLASS_B)
            { /* CLASS B ~ 3V */
#ifdef USE_SMPOWER
                POW_setVSIM2(PWCTRL5_LSIM2MD_STB_VCXOENn, PWRCTRL1_VSIM2ON_ON, PWCTRL5_LSIM2V_2_85_V);
#endif
            }
            else
            { /* CLASS C ~ 1.8V */
#ifdef USE_SMPOWER
                POW_setVSIM2(PWCTRL5_LSIM2MD_STB_VCXOENn, PWRCTRL1_VSIM2ON_ON, PWCTRL5_LSIM2V_1_80_V);
#endif
            }
            /* Activate SIM voltage but as SMC_VZ_n is utilizing GPIO_50 this port must as
            such be initilized accordingly. */
#if !defined (SGOLDLITE)
            /* Due to inverted logic should the PIN be set LOW to set on the Vcc. */
		#if 0
            *PCL_pad(PAD_SMC_VZ_N) = 0x4500; /* GPIO output, GPIO low. */
		#endif
            //PCL_CLC = 0x00000100;
            //PCL_50 = 0x4500; /* GPIO output, GPIO low. */
#endif
        }
        break;
    }
}
/* end of UICC_Driver_2007_10_25_dcm */

/******************************************************************************
* Function:... UICC_deactivate_vcc
* Parameters:. None.
* Returns:.... None.
* Description: Deactivate VCC towards the card.
* Created:.... 24.05.00 by (Knud Nymann Mortensen / KNM)
* Modified:... DD.MM.YY by (Full name / initials)
*                Modifications note.
*******************************************************************************/
void UICC_deactivate_vcc(T_UICC_CARD_SELECTOR card_selector)
{
    T_ZDrvPmic_Regulator regulator = VSIM1;
#ifdef UICC_MODULE_TEST
    if (UICC_module_test_state == UICC_MODULE_TEST_HW_DECOUPLED)
    {
        UICC_simulated_hw_reg._VOLTAGE_CTRL = (ulong)((card_selector<<16) | 0xFF);
        return;
    }
#endif

    if (UICC_ESIM_CARD == card_type_ctrl[card_selector])
    {
	regulator = VSIM2;
    }
    else
    {
	regulator = VSIM1;
    }
    switch (card_selector)
    {
    case UICC_PRIMARY_CARD:
        /*-------------------------*/
#ifdef USE_SMPOWER
        /* Based ont the SM Power version, activate the SIM voltage. */
        if (POW_get_power_chip_version() == POW_chip_version_10)
        { /* SM Power version 1.0 */
            POW_setVSIM2(PWCTRL5_LSIM2MD_OFF, PWRCTRL1_VSIM2ON_OFF, PWCTRL5_LSIM2V_2_85_V /* param not used */);
#if defined (DWD_HW_FP1E_FALCON)
            SIM_CTRL &= 0xFFEF; /* SIMVCC=0 i.e. CCVZ_n is set to physical HIGH level. */
#endif
        }
        else /* SM Power version > 1.0 */
#endif
        {
#if defined(SGOLD2) && !defined(DWD_HW_MPE_ICE)
            *PCL_pad(PAD_SIM_VCC) = PCL_ENABLE | PCL_NO_PUPD | PCL_PUSH_PULL  | PCL_RESET_OPTIONAL | PCL_GPIO | PCL_GPIO_OUT  | PCL_GPIO_D1;  /* GPIO high */
#elif defined(SGOLD3)
#if defined (SMPOWER3)

/*IO, CLK and RESET LOW*/
UICC_disable_io(UICC_current_reader); /*IO LOW*/
UICC_set_low_clock_stop_level(UICC_current_reader);
UICC_deactivate_rst(UICC_current_reader);

if (PMU_req_domain_voltage (PMU_DOMAIN_VSIM, POW_DOMAIN_VOLTAGE_1V8, PMU_APP_OFF) != STD_OK)
{
#ifndef UICC_NO_DEBUG
    UICC_log_data_ptr[0] = (ubyte) POW_DOMAIN_VOLTAGE_1V8;
    UICC_raise_exception(TRAP_UICC_UART, UICC_DEACTIVATE_VCC_FAILED, 1);
#endif
}
#endif
#if 0
UICC_PowerDown();
#else
#ifdef MTNET
zDrvRamlog_PRINTF(RAMLOG_MOD_UICC, "will UICC_deactivate_vcc\n");
zDrvRamlog_PRINTF(RAMLOG_MOD_UICC, "gVsimType is 0V\n");
uiccramlog_Printf("will UICC_deactivate_vcc\n");
uiccramlog_Printf("gVsimType is 0V\n");

#endif
zDrvDDUicc_SendPowerMsg(gVsimType, DRV_CARD_POWERDOWN, regulator);

#endif
#else
SIM_CTRL &= 0xFFEF; /* SIMVCC=0 i.e. CCVZ_n is set to physical HIGH level. */
#endif
        }
        break;

    case UICC_SECONDARY_CARD_1:
    default:
        /*-------------------------*/
#ifdef USE_SMPOWER
        /* Based ont the SM Power version, activate the SIM voltage. */
        if (POW_get_power_chip_version() == POW_chip_version_10)
        { /* SM Power version 1.0 -> 3 SIM voltage supported ONLY! */
            POW_setVSIM2(PWCTRL5_LSIM2MD_OFF, PWRCTRL1_VSIM2ON_OFF, PWCTRL5_LSIM2V_2_85_V /* param not used */);
        }
        else /* SM Power version > 1.0 -> 3V & 1,8V SIM voltage supported */
#endif
        {
            /* Deactivate SIM voltage but as SMC_VZ_n is utilizing GPIO_50 this port must as
            such be initilized accordingly. */
#if !defined (SGOLDLITE)
            /* Due to inverted logic should the PIN be set HIGH to power off the Vcc. */
		#if 0
            *PCL_pad(PAD_SMC_VZ_N) = 0x4600; /* GPIO high. */
		#endif
            //PCL_CLC = 0x00000100;
            //sPCL_50.PX = 1; /* GPIO high. */
#endif
        }
        break;
    }
}
#endif /* SGOLDRADIO */

/******************************************************************************
* Function:... UICC_activate_rst
* Parameters:. None.
* Returns:.... None.
* Description: Activate the RST pin towards the card (set high).
* Created:.... 24.05.00 by (Knud Nymann Mortensen / KNM)
* Modified:... DD.MM.YY by (Full name / initials)
*                Modifications note.
*******************************************************************************/
void UICC_activate_rst(T_UICC_CARD_SELECTOR card_selector)
{
    switch (card_selector)
    {
    case UICC_PRIMARY_CARD:
#ifdef UICC_MODULE_TEST
        if (UICC_module_test_state == UICC_MODULE_TEST_HW_DECOUPLED)
        {
            UICC_simulated_hw_reg._SIM_CTRL |= 0x0020;             /* SIMRST=1 */
            return;
        }
#endif

        sSIM_CTRL->SIMRST = 1;

        break;

    case UICC_SECONDARY_CARD_1:
    default:
        /* SMC_RST is utilizing GPIO_52 and must as such be initilized accordingly. */
        break;
    }
}

/******************************************************************************
* Function:... UICC_deactivate_rst
* Parameters:. None.
* Returns:.... None.
* Description: Deactivate the RST pin towards the card-card (set low).
* Created:.... 24.05.00 by (Knud Nymann Mortensen / KNM)
* Modified:... DD.MM.YY by (Full name / initials)
*                Modifications note.
*******************************************************************************/
void UICC_deactivate_rst(T_UICC_CARD_SELECTOR card_selector)
{
    switch (card_selector)
    {
    case UICC_PRIMARY_CARD:
#ifdef UICC_MODULE_TEST
        if (UICC_module_test_state == UICC_MODULE_TEST_HW_DECOUPLED)
        {
            UICC_simulated_hw_reg._SIM_CTRL &= 0xFFDF;             /* SIMRST=0 */
            return;
        }
#endif

        sSIM_CTRL->SIMRST = 0;
        break;

    case UICC_SECONDARY_CARD_1:
    default:
        break;
    }
}

/******************************************************************************
* Function:... UICC_activate_clk
* Parameters:. None.
* Returns:.... None.
* Description: Activates the clock (CLK) towards the card.
* Created:.... 24.05.00 by (Knud Nymann Mortensen / KNM)
* Modified:... DD.MM.YY by (Full name / initials)
*                Modifications note.
*******************************************************************************/
void UICC_activate_clk(T_UICC_CARD_SELECTOR card_selector)
{
    switch (card_selector)
    {
    case UICC_PRIMARY_CARD:
#ifdef UICC_MODULE_TEST
        if (UICC_module_test_state == UICC_MODULE_TEST_HW_DECOUPLED)
        {
            UICC_simulated_hw_reg._SIM_CTRL |= 0x0400;             /* SIMON=1 */
            return;
        }
#endif

        sSIM_CTRL->SIMON = 1;

        break;

    case UICC_SECONDARY_CARD_1:
    default:
#ifdef UICC_MODULE_TEST
        if (UICC_module_test_state == UICC_MODULE_TEST_HW_DECOUPLED)
        {
            UICC_simulated_hw_reg._SIM_CTRL2 |= 0x0002;             /* SIM2ON=1 */
            return;
        }
#endif

        sSIM_CTRL2->SIM2ON = 1;         /* SMC_CLK is connected to GPIO52. */

        break;
    }
}

/******************************************************************************
* Function:... UICC_deactivate_clk
* Parameters:. None.
* Returns:.... None.
* Description: Deactivates the clock (CLK) towards the card.
* Created:.... 24.05.00 by (Knud Nymann Mortensen / KNM)
* Modified:... DD.MM.YY by (Full name / initials)
*                Modifications note.
*******************************************************************************/
void UICC_deactivate_clk(T_UICC_CARD_SELECTOR card_selector)
{
    switch (card_selector)
    {
    case UICC_PRIMARY_CARD:
#ifdef UICC_MODULE_TEST
        if (UICC_module_test_state == UICC_MODULE_TEST_HW_DECOUPLED)
        {
            UICC_simulated_hw_reg._SIM_CTRL &= 0xFBFF;             /* SIMON=0 */
            return;
        }
#endif

        sSIM_CTRL->SIMON = 0;

        break;

    case UICC_SECONDARY_CARD_1:
    default:
#ifdef UICC_MODULE_TEST
        if (UICC_module_test_state == UICC_MODULE_TEST_HW_DECOUPLED)
        {
            UICC_simulated_hw_reg._SIM_CTRL2 &= 0xFFFD;             /* SIM2ON=0 */
            return;
        }
#endif

        sSIM_CTRL2->SIM2ON = 0;         /* SMC_CLK is connected to GPIO52. */

        break;
    }
}

/******************************************************************************
* Function:... UICC_set_high_clock_stop_level
* Parameters:. None.
* Returns:.... None.
* Description: Set the card clock stop level to be at a high logical level.
* Created:.... 24.05.00 by (Knud Nymann Mortensen / KNM)
* Modified:... DD.MM.YY by (Full name / initials)
*                Modifications note.
*******************************************************************************/
void UICC_set_high_clock_stop_level(T_UICC_CARD_SELECTOR card_selector)
{
    switch (card_selector)
    {
    case UICC_PRIMARY_CARD:
#ifdef UICC_MODULE_TEST
        if (UICC_module_test_state == UICC_MODULE_TEST_HW_DECOUPLED)
        {
            UICC_simulated_hw_reg._SIM_CTRL |= 0x1000;             /* CLKHIGH=1 */
            return;
        }
#endif

        sSIM_CTRL->CLKHIGH = 1;

        break;

    case UICC_SECONDARY_CARD_1:
    default:
#ifdef UICC_MODULE_TEST
        if (UICC_module_test_state == UICC_MODULE_TEST_HW_DECOUPLED)
        {
            UICC_simulated_hw_reg._SIM_CTRL2 |= 0x0004;             /* CLK2HIGH=1 */
            return;
        }
#endif

        sSIM_CTRL2->CLK2HIGH = 1;       /* SMC_CLK is connected to GPIO52. */

        break;
    }
}

/******************************************************************************
* Function:... UICC_set_low_clock_stop_level
* Parameters:. None.
* Returns:.... None.
* Description: Set the card clock stop level to be at a low logical level.
* Created:.... 24.05.00 by (Knud Nymann Mortensen / KNM)
* Modified:... DD.MM.YY by (Full name / initials)
*                Modifications note.
*******************************************************************************/
void UICC_set_low_clock_stop_level(T_UICC_CARD_SELECTOR card_selector)
{
    switch (card_selector)
    {
    case UICC_PRIMARY_CARD:
#ifdef UICC_MODULE_TEST
        if (UICC_module_test_state == UICC_MODULE_TEST_HW_DECOUPLED)
        {
            UICC_simulated_hw_reg._SIM_CTRL &= 0xEFFF;             /* CLKHIGH=0 */
            return;
        }
#endif

        sSIM_CTRL->CLKHIGH = 0;

        break;

    case UICC_SECONDARY_CARD_1:
    default:
#ifdef UICC_MODULE_TEST
        if (UICC_module_test_state == UICC_MODULE_TEST_HW_DECOUPLED)
        {
            UICC_simulated_hw_reg._SIM_CTRL2 &= 0xFFFB;             /* CLK2HIGH=0 */
            return;
        }
#endif

        sSIM_CTRL2->CLK2HIGH = 0;

        break;
    }
}

/******************************************************************************
* Function:... UICC_select_high_clock_freq
* Parameters:. None.
* Returns:.... None.
* Description: Select card clock to operate at 3.25 MHz.
* Created:.... 24.05.00 by (Knud Nymann Mortensen / KNM)
* Modified:... DD.MM.YY by (Full name / initials)
*                Modifications note.
*******************************************************************************/
void UICC_select_high_clock_freq(void)
{
#ifdef UICC_MODULE_TEST
    if (UICC_module_test_state == UICC_MODULE_TEST_HW_DECOUPLED)
    {
        UICC_simulated_hw_reg._SIM_CTRL &= 0xF7FF;             /* CLKSEL=0 */
        return;
    }
#endif

    sSIM_CTRL->CLKSEL = 0;
}

/******************************************************************************
* Function:... UICC_select_low_clock_freq
* Parameters:. None.
* Returns:.... None.
* Description: Select card clock to operate at 1.08 MHz.
* Created:.... 24.05.00 by (Knud Nymann Mortensen / KNM)
* Modified:... DD.MM.YY by (Full name / initials)
*                Modifications note.
*******************************************************************************/
void UICC_select_low_clock_freq(void)
{
#ifdef UICC_MODULE_TEST
    if (UICC_module_test_state == UICC_MODULE_TEST_HW_DECOUPLED)
    {
        UICC_simulated_hw_reg._SIM_CTRL |= 0x0800;             /* CLKHIGH=1 */
        return;
    }
#endif

    sSIM_CTRL->CLKSEL = 1;
}

/******************************************************************************
* Function:... UICC_enable_io
* Parameters:. None.
* Returns:.... None.
* Description: Enable the I/O pin (set I/O line high).
* Created:.... 24.05.00 by (Knud Nymann Mortensen / KNM)
* Modified:... DD.MM.YY by (Full name / initials)
*                Modifications note.
*******************************************************************************/
void UICC_enable_io(T_UICC_CARD_SELECTOR card_selector)
{
    switch (card_selector)
    {
    case UICC_PRIMARY_CARD:
#ifdef UICC_MODULE_TEST
        if (UICC_module_test_state == UICC_MODULE_TEST_HW_DECOUPLED)
        {
            UICC_simulated_hw_reg._SIM_CTRL  |= 0x0004;             /* SIMIOL=1 */
            UICC_simulated_hw_reg._SIM_CTRL2 |= 0x0008;             /* SIM1STBY=1 */
            return;
        }
#endif

        sSIM_CTRL->SIMIOL = 1;
        sSIM_CTRL2->SIM1STDBY = 1;

        break;

    case UICC_SECONDARY_CARD_1:
    default:
#ifdef UICC_MODULE_TEST
        if (UICC_module_test_state == UICC_MODULE_TEST_HW_DECOUPLED)
        {
            UICC_simulated_hw_reg._SIM_CTRL  |= 0x0004;             /* SIMIOL=1 */
            UICC_simulated_hw_reg._SIM_CTRL2 |= 0x0010;             /* SIM2STBY=1 */
            return;
        }
#endif

        sSIM_CTRL->SIMIOL = 1;
        sSIM_CTRL2->SIM2STDBY = 1;  /* I/O of card 2 will be held at high level
                                            when card 1 becomes the active card. */
        break;
    }
}

/******************************************************************************
* Function:... UICC_disable_io
* Parameters:. None.
* Returns:.... None.
* Description: Disable the I/O pin (set I/O line low).
* Created:.... 24.05.00 by (Knud Nymann Mortensen / KNM)
* Modified:... DD.MM.YY by (Full name / initials)
*                Modifications note.
*******************************************************************************/
void UICC_disable_io(T_UICC_CARD_SELECTOR card_selector)
{
    switch (card_selector)
    {
    case UICC_PRIMARY_CARD:
#ifdef UICC_MODULE_TEST
        if (UICC_module_test_state == UICC_MODULE_TEST_HW_DECOUPLED)
        {
            UICC_simulated_hw_reg._SIM_CTRL  &= 0xFFFB;             /* SIMIOL=0 */
            UICC_simulated_hw_reg._SIM_CTRL2 &= 0xFFF7;             /* SIM1STBY=0 */
            return;
        }
#endif

        sSIM_CTRL->SIMIOL = 0;
        sSIM_CTRL2->SIM1STDBY = 0;  /* I/O of card 1 will be held at low level
                                            when card 2 becomes the active card. */
        break;

    case UICC_SECONDARY_CARD_1:
    default:
#ifdef UICC_MODULE_TEST
        if (UICC_module_test_state == UICC_MODULE_TEST_HW_DECOUPLED)
        {
            UICC_simulated_hw_reg._SIM_CTRL  &= 0xFFFB;             /* SIMIOL=0 */
            UICC_simulated_hw_reg._SIM_CTRL2 &= 0xFFEF;             /* SIM2STBY=0 */
            return;
        }
#endif

        sSIM_CTRL->SIMIOL = 0;
        sSIM_CTRL2->SIM2STDBY = 0;  /* I/O of card 2 will be held at low level
                                            when card 1 becomes the active card. */
        break;
    }
}

/******************************************************************************
* Function:... UICC_select_operative_card
* Parameters:. None.
* Returns:.... None.
* Description: Disable the I/O pin.
* Created:.... 24.05.00 by (Knud Nymann Mortensen / KNM)
* Modified:... DD.MM.YY by (Full name / initials)
*                Modifications note.
*******************************************************************************/
void UICC_select_operative_card(T_UICC_CARD_SELECTOR card_selector)
{
    switch (card_selector)
    {
    case UICC_PRIMARY_CARD:
#ifdef UICC_MODULE_TEST
        if (UICC_module_test_state == UICC_MODULE_TEST_HW_DECOUPLED)
        {
            UICC_simulated_hw_reg._SIM_CTRL2  &= 0xFFFE;             /* SIM2SEL=0 */
            return;
        }
#endif

        sSIM_CTRL2->SIM2SEL = 0;  /* Card 1 (CCIO) is the current operative card. */

        break;

    case UICC_SECONDARY_CARD_1:
    default:
#ifdef UICC_MODULE_TEST
        if (UICC_module_test_state == UICC_MODULE_TEST_HW_DECOUPLED)
        {
            UICC_simulated_hw_reg._SIM_CTRL2  |= 0x0001;             /* SIM2SEL=1 */
            return;
        }
#endif

        sSIM_CTRL2->SIM2SEL = 1;  /* Card 2 (CC2IO) is the current operative card. */

        break;
    }
}
/******************************************************************************
* Function:... UICC_select_direct_convention
* Parameters:. None.
* Returns:.... None.
* Description: Select DIRECT convention for the I/O line.
*              (Direct convention: Send LSB first, '1' is logical high)
* Created:.... 24.05.00 by (Knud Nymann Mortensen / KNM)
* Modified:... DD.MM.YY by (Full name / initials)
*                Modifications note.
*******************************************************************************/
void UICC_select_direct_convention(void)
{
#ifdef UICC_MODULE_TEST
    if (UICC_module_test_state == UICC_MODULE_TEST_HW_DECOUPLED)
    {
        UICC_simulated_hw_reg._SIM_CTRL  &= 0xFFFE;             /* INCON=0 */
        return;
    }
#endif

    SIM_CTRL &= 0xFFFE;            /* INCON=0                               */
    wait_time(50);/*add by wangxia 10.05.11*/
}

/******************************************************************************
* Function:... UICC_select_inverse_convention
* Parameters:. None.
* Returns:.... None.
* Description: Select INVERSE convention for the I/O line.
*              (Inverse convention: Send MSB first, '1' is logical low)
* Created:.... 24.05.00 by (Knud Nymann Mortensen / KNM)
* Modified:... DD.MM.YY by (Full name / initials)
*                Modifications note.
*******************************************************************************/
void UICC_select_inverse_convention(void)
{
#ifdef UICC_MODULE_TEST
    if (UICC_module_test_state == UICC_MODULE_TEST_HW_DECOUPLED)
    {
        UICC_simulated_hw_reg._SIM_CTRL |= 0x0001;             /* INCON=1 */
        return;
    }
#endif

    SIM_CTRL |= 0x0001;            /* INCON=1                               */
    wait_time(50);/*add by wangxia 10.05.11*/
}

/******************************************************************************
* Function:... UICC_enable_parity_error_detection
* Parameters:. None.
* Returns:.... None.
* Description: Enable parity error detection during transmission from the card.
* Created:.... 24.05.00 by (Knud Nymann Mortensen / KNM)
* Modified:... DD.MM.YY by (Full name / initials)
*                Modifications note.
*******************************************************************************/
void UICC_enable_parity_error_detection(void)
{
#ifdef UICC_MODULE_TEST
    if (UICC_module_test_state == UICC_MODULE_TEST_HW_DECOUPLED)
    {
        UICC_simulated_hw_reg._SIM_CTRL &= 0xFFBF;            /* ERROFF=0 */
        return;
    }
#endif

    SIM_CTRL &= 0xFFBF;            /* ERROFF=0                              */
    wait_time(50);/*add by wangxia 10.05.11*/
}

/******************************************************************************
* Function:... UICC_disable_parity_error_detection
* Parameters:. None.
* Returns:.... None.
* Description: Disable parity error detection during transmission from the card.
* Created:.... 24.05.00 by (Knud Nymann Mortensen / KNM)
* Modified:... DD.MM.YY by (Full name / initials)
*                Modifications note.
*******************************************************************************/
void UICC_disable_parity_error_detection(void)
{
#ifdef UICC_MODULE_TEST
    if (UICC_module_test_state == UICC_MODULE_TEST_HW_DECOUPLED)
    {
        UICC_simulated_hw_reg._SIM_CTRL |= 0x0040;            /* ERROFF=1 */
        return;
    }
#endif

    SIM_CTRL |= 0x0040;            /* ERROFF=1                              */
    wait_time(50);/*add by wangxia 10.05.11*/
}

/******************************************************************************
* Function:... UICC_enable_character_retransmission
* Parameters:. None.
* Returns:.... None.
* Description: Enable character retransmission during transmission to the card.
* Created:.... 24.05.00 by (Knud Nymann Mortensen / KNM)
* Modified:... DD.MM.YY by (Full name / initials)
*                Modifications note.
*******************************************************************************/
void UICC_enable_character_retransmission(void)
{
#ifdef UICC_MODULE_TEST
    if (UICC_module_test_state == UICC_MODULE_TEST_HW_DECOUPLED)
    {
        UICC_simulated_hw_reg._SIM_CTRL &= 0xFF7F;            /* RPTOFF=0 */
        return;
    }
#endif

    SIM_CTRL &= 0xFF7F;            /* RPTOFF=0                              */
    wait_time(50);/*add by wangxia 10.05.11*/
}

/******************************************************************************
* Function:... UICC_disable_character_retransmission
* Parameters:. None.
* Returns:.... None.
* Description: Disable character retransmission during transmission to the card.
* Created:.... 24.05.00 by (Knud Nymann Mortensen / KNM)
* Modified:... DD.MM.YY by (Full name / initials)
*                Modifications note.
*******************************************************************************/
void UICC_disable_character_retransmission(void)
{
#ifdef UICC_MODULE_TEST
    if (UICC_module_test_state == UICC_MODULE_TEST_HW_DECOUPLED)
    {
        UICC_simulated_hw_reg._SIM_CTRL |= 0x0080;            /* RPTOFF=1 */
        return;
    }
#endif

    SIM_CTRL |= 0x0080;            /* RPTOFF=1                              */
    wait_time(50);/*add by wangxia 10.05.11*/
}

/******************************************************************************
* Function:... UICC_transmission_rate_control
* Parameters:. brf_factor:  The card baud rate factor.
* Returns:.... None.
* Description: This function is used when coding the baud rate of which the
*              card-card interface should operate with.
* Created:.... 24.05.00 by (Knud Nymann Mortensen / KNM)
* Modified:... DD.MM.YY by (Full name / initials)
*                Modifications note.
*******************************************************************************/
void UICC_transmission_rate_control(ubyte brf_factor)
{
#ifdef UICC_MODULE_TEST
    if (UICC_module_test_state == UICC_MODULE_TEST_HW_DECOUPLED)
    {
        UICC_simulated_hw_reg._SIM_BRF = brf_factor & 0x7F;
        return;
    }
#endif

    SIM_BRF = brf_factor & 0x7F; /* Masking the no used bit off (b7).       */
    wait_time(50);/*add by wangxia 10.05.11*/
}

/******************************************************************************
* Function:... UICC_set_txtx_space
* Parameters:. rxtx_space:  Denotes the desired Rx-Tx character spacing.
*                           T=0 HW mode: the value should be given in 1/16 ETU
*                           scale (0x28 ~ 2.5 ETU).
*                           T=1 HW mode: the value should be given in ETU
*                           scale (0x28 ~ 40 ETU).
* Returns:.... None.
* Description: This function is used:
*              - in T=0 HW mode to set the character spacing between last received
*                Rx character and the following Tx characters.
*              - in T=1 HW mode to set block guard timer which is the distance
*                between the last character of a received block to the first
*                character of a transmit block.
* Created:.... 29.01.04 by (Knud Nymann Mortensen / KNM)
* Modified:... DD.MM.YY by (Full name / initials)
*                Modifications note.
*******************************************************************************/
void UICC_set_rxtx_space(ubyte rxtx_space)
{
#ifdef UICC_MODULE_TEST
    if (UICC_module_test_state == UICC_MODULE_TEST_HW_DECOUPLED)
    {
        UICC_simulated_hw_reg._SIM_RXSPC = rxtx_space;
        return;
    }
#endif

    SIM_RXSPC = rxtx_space; /* Set the Rx-Tx space. */
}

/******************************************************************************
* Function:... UICC_set_txtx_space
* Parameters:. txtx_space:  Denotes the desired Tx-Tx character spacing in ETU.
* Returns:.... None.
* Description: This function is set the character spacing between Tx characters.
* Created:.... 29.01.04 by (Knud Nymann Mortensen / KNM)
* Modified:... DD.MM.YY by (Full name / initials)
*                Modifications note.
*******************************************************************************/
void UICC_set_txtx_space(ubyte txtx_space)
{
#ifdef UICC_MODULE_TEST
    if (UICC_module_test_state == UICC_MODULE_TEST_HW_DECOUPLED)
    {
        UICC_simulated_hw_reg._SIM_TXSPC = txtx_space;
        return;
    }
#endif

    SIM_TXSPC = txtx_space; /* Set the Tx-Tx space [ETU]. */
}

/******************************************************************************
* Function:... UICC_send_character
* Parameters:. character: One 8 bit character to be send on I/O.
* Returns:.... None.
* Description: Send a single character on the serial card line.
* Created:.... 24.05.00 by (Knud Nymann Mortensen / KNM)
* Modified:... DD.MM.YY by (Full name / initials)
*                Modifications note.
*******************************************************************************/
void UICC_send_character(ubyte character)
{
#ifdef UICC_MODULE_TEST
    if (UICC_module_test_state == UICC_MODULE_TEST_HW_DECOUPLED)
    {
        UICC_simulated_hw_reg._SIM_TX = character;
        return;
    }
#endif

    SIM_TX = character;
}

/******************************************************************************
* Function:... UICC_get_character
* Parameters:. None.
* Returns:.... An 8 bit character received on the I/O line.
* Description: Read a single character from the serial I/O line.
* Created:.... 24.05.00 by (Knud Nymann Mortensen / KNM)
* Modified:... DD.MM.YY by (Full name / initials)
*                Modifications note.
*******************************************************************************/
ubyte UICC_get_character(void)
{
#ifdef UICC_MODULE_TEST
    if (UICC_module_test_state == UICC_MODULE_TEST_HW_DECOUPLED)
    {
        return(UICC_simulated_hw_reg._SIM_RX);
    }
#endif

    return (SIM_RX);
}

/******************************************************************************
* Function:... UICC_commence_t0_command
* Parameters: p3:     Command paramter P3 to be send.
*             ins:    Command instruction to be send.
*             rx_cmd: Direction of command data
*                       FALSE: Data transfer to the card (Tx).
*                       TRUE:  Data transfer from the card (Rx).
* Returns:.... None.
* Description: Start the T=0 command by writing first P3, and then INS with
*              data transfer direction.
* Created:.... 24.05.00 by (Knud Nymann Mortensen / KNM)
* Modified:... DD.MM.YY by (Full name / initials)
*                Modifications note.
*******************************************************************************/
void UICC_commence_t0_command(ubyte          p3,
                              ubyte          ins,
                              T_UICC_CMD_DIR cmd)
{
    ushort instruction = 0x0000;    /* Set the transmission direction
                                               default to Tx.                 */
    instruction = ins;

    if (cmd == UICC_RX_CMD)
    {
        instruction |= 0x0100;              /* Set the transmission direction
                                                   to Rx.                         */
    }

#ifdef UICC_MODULE_TEST
    if (UICC_module_test_state == UICC_MODULE_TEST_HW_DECOUPLED)
    {
        UICC_simulated_hw_reg._SIM_P3  = p3;
        UICC_simulated_hw_reg._SIM_INS = instruction;
        return;
    }
#endif

    SIM_P3  = p3;                         /* Set command parameter P3.      */

    SIM_INS = instruction;                /* Set command instruction (Note
                                               that the command execution is
                                               started when SIM_INS is written)*/
}

/******************************************************************************
* Function:... UICC_get_t0_command_response
* Parameters:. None.
* Returns:.... The command response codes SW1 and SW2.
* Description: The function fetches the response causes SW1 sand SW2 of a T=0
*              command.
* Created:.... 24.05.00 by (Knud Nymann Mortensen / KNM)
* Modified:... DD.MM.YY by (Full name / initials)
*                Modifications note.
*******************************************************************************/
T_UICC_CMD_RSP UICC_get_t0_command_response(void)
{
    T_UICC_CMD_RSP response;

#ifdef UICC_MODULE_TEST
    if (UICC_module_test_state == UICC_MODULE_TEST_HW_DECOUPLED)
    {
        response.sw1 = (ubyte) (UICC_simulated_hw_reg._SIM_SW1_SW2>>8);
        response.sw2 = (ubyte) (UICC_simulated_hw_reg._SIM_SW1_SW2);
        return (response);
    }
#endif

    response.sw1 = SIM_SW1;
    response.sw2 = SIM_SW2;

    return (response);
}

/******************************************************************************
* Function:... UICC_start_t1_mode
* Parameters:. data_lenght:  The length of the block
* Returns:.... None.
* Description: The function initiates the T=1 mode.
* Created:....06.11.02 by (Knud Nymann Mortensen / KNM)
* Modified:... DD.MM.YY by (Full name / initials)
*                Modifications note.
*******************************************************************************/
void UICC_start_t1_mode(ubyte data_length)
{
#ifdef UICC_MODULE_TEST
    if (UICC_module_test_state == UICC_MODULE_TEST_HW_DECOUPLED)
    {
        UICC_simulated_hw_reg._SIM_T1CTRL |= (0x0000 | data_length);
        UICC_simulated_hw_reg._SIM_T1CTRL |= 0x0100;
        return;
    }
#endif

    /**************** Check HW  version for ES1 and ES 2 for ES1 not have ALFEEN !!!!!!! *******/
#if defined(UICC_ALFEEN_ENABLE)
    SIM_T1CTRL |= 0x800; //Automatic Length Field Extraction Enable
    wait_time(50);/*add by wangxia 10.05.11*/
#endif

    sSIM_T1CTRL->SIMT1LEN = data_length;
    sSIM_T1CTRL->T1START = 1;
}

/******************************************************************************
* Function:... UICC_start_bwt_timer
* Parameters:. None.
* Returns:.... None.
* Description: The function starts the Block Waiting Timer (BWT).
* Created:....06.11.02 by (Knud Nymann Mortensen / KNM)
* Modified:... DD.MM.YY by (Full name / initials)
*                Modifications note.
*******************************************************************************/
void UICC_start_bwt_timer(void)
{
#ifdef UICC_MODULE_TEST
    if (UICC_module_test_state == UICC_MODULE_TEST_HW_DECOUPLED)
    {
        UICC_simulated_hw_reg._SIM_T1CTRL |= 0x0400;
        return;
    }
#endif

    sSIM_T1CTRL->BWT_START = 1;
}

/******************************************************************************
* Function:... UICC_stop_bwt_timer
* Parameters:. None.
* Returns:.... None.
* Description: The function stops the Block Waiting Timer (BWT).
* Created:....06.11.02 by (Knud Nymann Mortensen / KNM)
* Modified:... DD.MM.YY by (Full name / initials)
*                Modifications note.
*******************************************************************************/
void UICC_stop_bwt_timer(void)
{
#ifdef UICC_MODULE_TEST
    if (UICC_module_test_state == UICC_MODULE_TEST_HW_DECOUPLED)
    {
        UICC_simulated_hw_reg._SIM_T1CTRL &= 0xFBFF;
        return;
    }
#endif

    sSIM_T1CTRL->BWT_START = 0;
}

/******************************************************************************
* Function:... UICC_enable_bgt_timer
* Parameters:. None.
* Returns:.... None.
* Description: The function enables the Block Guard Timer (BGT).
* Created:....06.11.02 by (Knud Nymann Mortensen / KNM)
* Modified:... DD.MM.YY by (Full name / initials)
*                Modifications note.
*******************************************************************************/
void UICC_enable_bgt_timer(void)
{
#ifdef UICC_MODULE_TEST
    if (UICC_module_test_state == UICC_MODULE_TEST_HW_DECOUPLED)
    {
        UICC_simulated_hw_reg._SIM_T1CTRL |= 0x0200;
        return;
    }
#endif

    sSIM_T1CTRL->BGTEN = 1;
}

/******************************************************************************
* Function:... UICC_disable_bgt_timer
* Parameters:. None.
* Returns:.... None.
* Description: The function disables the Block Guard Timer (BGT).
* Created:....06.11.02 by (Knud Nymann Mortensen / KNM)
* Modified:... DD.MM.YY by (Full name / initials)
*                Modifications note.
*******************************************************************************/
void UICC_disable_bgt_timer(void)
{
#ifdef UICC_MODULE_TEST
    if (UICC_module_test_state == UICC_MODULE_TEST_HW_DECOUPLED)
    {
        UICC_simulated_hw_reg._SIM_T1CTRL &= 0xFDFF;
        return;
    }
#endif

    sSIM_T1CTRL->BGTEN = 0;
}

/******************************************************************************
* Function:... UICC_set_character_timer
* Parameters:. timer_etu_value: The character timer value given in ETU in the
*              range up to 16,777,216 ETU
* Returns:.... None.
* Description: The function set up the character timer used in T=0 (WWT) and T=1
*              mode (CWT).
* Created:.... 05.11.02 by (Knud Nymann Mortensen / KNM)
* Modified:... DD.MM.YY by (Full name / initials)
*                Modifications note.
*******************************************************************************/
void UICC_set_character_timer(ulong timer_etu_value)
{
#ifdef UICC_MODULE_TEST
    if (UICC_module_test_state == UICC_MODULE_TEST_HW_DECOUPLED)
    {
        UICC_simulated_hw_reg._SIM_CHTIMER = timer_etu_value & 0x00FFFFFF;
        return;
    }
#endif

    SIM_CHTIMER = timer_etu_value & 0x00FFFFFF;
    wait_time(50);/*add by wangxia 10.05.11*/
}

/******************************************************************************
* Function:... UICC_set_bwt_timer
* Parameters:. timer_etu_value: The character timer value given in ETU in the
*              range up to 16,777,216 ETU
* Returns:.... None.
* Description: The function set up the block waiting timer (BWT) used in T=1 mode.
* Created:.... 05.11.02 by (Knud Nymann Mortensen / KNM)
* Modified:... DD.MM.YY by (Full name / initials)
*                Modifications note.
*******************************************************************************/
void UICC_set_bwt_timer(ulong timer_etu_value)
{
#ifdef UICC_MODULE_TEST
    if (UICC_module_test_state == UICC_MODULE_TEST_HW_DECOUPLED)
    {
        UICC_simulated_hw_reg._SIM_BWT = timer_etu_value & 0x00FFFFFF;
        return;
    }
#endif

    SIM_BWT = timer_etu_value & 0x00FFFFFF;
    wait_time(50);/*add by wangxia 10.05.11*/
}

/******************************************************************************
* Function:... UICC_start_auto_deactivation
* Parameters:. None.
* Returns:.... None.
* Description: Start automatic deactivation now. That is powerering down the card
*              signals in the ISO/IEC 7816-3 specified order. The signals will
*              stay powered down until CI_end_auto_deactivation is executed.
* Created:.... 24.05.00 by (Knud Nymann Mortensen / KNM)
* Modified:... DD.MM.YY by (Full name / initials)
*                Modifications note.
*******************************************************************************/
void UICC_start_auto_deactivation(void)
{
#ifdef UICC_MODULE_TEST
    if (UICC_module_test_state == UICC_MODULE_TEST_HW_DECOUPLED)
    {
        UICC_simulated_hw_reg._SIM_CTRL |= 0x0200;            /* SIMPDWN=1 */
        return;
    }
#endif

    SIM_CTRL |= 0x0200;            /* SIMPDWN=1                             */
    wait_time(50);/*add by wangxia 10.05.11*/
}

/******************************************************************************
* Function:... UICC_end_auto_deactivation
* Parameters:. None.
* Returns:.... None.
* Description: Power down is ended which means that the card signals again can
*              be controlled manually.
* Created:.... 24.05.00 by (Knud Nymann Mortensen / KNM)
* Modified:... DD.MM.YY by (Full name / initials)
*                Modifications note.
*******************************************************************************/
void UICC_end_auto_deactivation(void)
{
#ifdef UICC_MODULE_TEST
    if (UICC_module_test_state == UICC_MODULE_TEST_HW_DECOUPLED)
    {
        UICC_simulated_hw_reg._SIM_CTRL &= 0xFDFF;            /* SIMPDWN=0 */
        return;
    }
#endif

    SIM_CTRL &= 0xFDFF;            /* SIMPDWN=0                             */
    wait_time(50);/*add by wangxia 10.05.11*/
}

/******************************************************************************
* Function:... UICC_enable_character_interrupt
* Parameters:. None.
* Returns:.... None.
* Description: Enable the character interrupt.
* Created:.... 24.05.00 by (Knud Nymann Mortensen / KNM)
* Modified:... DD.MM.YY by (Full name / initials)
*                Modifications note.
*******************************************************************************/
void UICC_enable_character_interrupt(void)
{
#ifdef UICC_MODULE_TEST
    if (UICC_module_test_state == UICC_MODULE_TEST_HW_DECOUPLED)
    {
        UICC_simulated_hw_reg._SIM_IRQEN |= 0x0001;           /* ENOKINT=1 */
        return;
    }
#endif

    SIM_IRQEN |= 0x0001;           /* ENOKINT=1                             */
    wait_time(50);/*add by wangxia 10.05.11*/
}

/******************************************************************************
* Function:... UICC_disable_character_interrupt
* Parameters:. None.
* Returns:.... None.
* Description: Disable the character interrupt.
* Created:.... 24.05.00 by (Knud Nymann Mortensen / KNM)
* Modified:... DD.MM.YY by (Full name / initials)
*                Modifications note.
*******************************************************************************/
void UICC_disable_character_interrupt(void)
{
#ifdef UICC_MODULE_TEST
    if (UICC_module_test_state == UICC_MODULE_TEST_HW_DECOUPLED)
    {
        UICC_simulated_hw_reg._SIM_IRQEN &= 0xFFFE;           /* ENOKINT=0 */
        return;
    }
#endif

    SIM_IRQEN &= 0xFFFE;           /* ENOKINT=0                             */
    wait_time(50);/*add by wangxia 10.05.11*/
}

/******************************************************************************
* Function:... UICC_enable_t0_end_interrupt
* Parameters:. None.
* Returns:.... None.
* Description: Enable the T=0 END interrupt.
* Created:.... 24.05.00 by (Knud Nymann Mortensen / KNM)
* Modified:... DD.MM.YY by (Full name / initials)
*                Modifications note.
*******************************************************************************/
void UICC_enable_t0_end_interrupt(void)
{
#ifdef UICC_MODULE_TEST
    if (UICC_module_test_state == UICC_MODULE_TEST_HW_DECOUPLED)
    {
        UICC_simulated_hw_reg._SIM_IRQEN |= 0x0008;           /* ENT0END=1 */
        return;
    }
#endif

    SIM_IRQEN |= 0x0008;           /* ENT0END=1                               */
    wait_time(50);/*add by wangxia 10.05.11*/
}

/******************************************************************************
* Function:... UICC_disable_t0_end_interrupt
* Parameters:. None.
* Returns:.... None.
* Description: Disable the T=0 END interrupt.
* Created:.... 24.05.00 by (Knud Nymann Mortensen / KNM)
* Modified:... DD.MM.YY by (Full name / initials)
*                Modifications note.
*******************************************************************************/
void UICC_disable_t0_end_interrupt(void)
{
#ifdef UICC_MODULE_TEST
    if (UICC_module_test_state == UICC_MODULE_TEST_HW_DECOUPLED)
    {
        UICC_simulated_hw_reg._SIM_IRQEN &= 0xFFF7;           /* ENT0END=0 */
        return;
    }
#endif

    SIM_IRQEN &= 0xFFF7;           /* ENT0END=0                               */
    wait_time(50);/*add by wangxia 10.05.11*/
}

/******************************************************************************
* Function:... UICC_enable_parity_error_interrupt
* Parameters:. None.
* Returns:.... None.
* Description: Enable parity error interrupt.
* Created:.... 24.05.00 by (Knud Nymann Mortensen / KNM)
* Modified:... DD.MM.YY by (Full name / initials)
*                Modifications note.
*******************************************************************************/
void UICC_enable_parity_error_interrupt(void)
{
#ifdef UICC_MODULE_TEST
    if (UICC_module_test_state == UICC_MODULE_TEST_HW_DECOUPLED)
    {
        UICC_simulated_hw_reg._SIM_IRQEN |= 0x0002;           /* ENPAR=1 */
        return;
    }
#endif

    SIM_IRQEN |= 0x0002;           /* ENPAR=1                              */
    wait_time(50);/*add by wangxia 10.05.11*/
}

/******************************************************************************
* Function:... UICC_disable_parity_error_interrupt
* Parameters:. None.
* Returns:.... None.
* Description: Disable parity error interrupt.
* Created:.... 24.05.00 by (Knud Nymann Mortensen / KNM)
* Modified:... DD.MM.YY by (Full name / initials)
*                Modifications note.
*******************************************************************************/
void UICC_disable_parity_error_interrupt(void)
{
#ifdef UICC_MODULE_TEST
    if (UICC_module_test_state == UICC_MODULE_TEST_HW_DECOUPLED)
    {
        UICC_simulated_hw_reg._SIM_IRQEN &= 0xFFFD;           /* ENPAR=0 */
        return;
    }
#endif

    SIM_IRQEN &= 0xFFFD;           /* ENPAR=0                              */
    wait_time(50);/*add by wangxia 10.05.11*/
}

/******************************************************************************
* Function:... UICC_enable_overrun_error_interrupt
* Parameters:. None.
* Returns:.... None.
* Description: Enable overrun error interrupt.
* Created:.... 24.05.00 by (Knud Nymann Mortensen / KNM)
* Modified:... DD.MM.YY by (Full name / initials)
*                Modifications note.
*******************************************************************************/
void UICC_enable_overrun_error_interrupt(void)
{
#ifdef UICC_MODULE_TEST
    if (UICC_module_test_state == UICC_MODULE_TEST_HW_DECOUPLED)
    {
        UICC_simulated_hw_reg._SIM_IRQEN |= 0x0004;           /* ENOVR=1 */
        return;
    }
#endif

    SIM_IRQEN |= 0x0004;           /* ENOVR=1                              */
    wait_time(50);/*add by wangxia 10.05.11*/
}

/******************************************************************************
* Function:... UICC_disable_overrun_error_interrupt
* Parameters:. None.
* Returns:.... None.
* Description: Disable overrun error interrupt.
* Created:.... 22.10.02 by (Knud Nymann Mortensen / KNM)
* Modified:... DD.MM.YY by (Full name / initials)
*                Modifications note.
*******************************************************************************/
void UICC_disable_overrun_error_interrupt(void)
{
#ifdef UICC_MODULE_TEST
    if (UICC_module_test_state == UICC_MODULE_TEST_HW_DECOUPLED)
    {
        UICC_simulated_hw_reg._SIM_IRQEN &= 0xFFFB;           /* ENOVR=0 */
        return;
    }
#endif

    SIM_IRQEN &= 0xFFFB;           /* ENOVR=0                              */
    wait_time(50);/*add by wangxia 10.05.11*/
}

/******************************************************************************
* Function:... UICC_enable_char_timeout_interrupt
* Parameters:. None.
* Returns:.... None.
* Description: Enable character timeout interrupt.
* Created:.... 22.10.02 by (Knud Nymann Mortensen / KNM)
* Modified:... DD.MM.YY by (Full name / initials)
*                Modifications note.
*******************************************************************************/
void UICC_enable_char_timeout_interrupt(void)
{
#ifdef UICC_MODULE_TEST
    if (UICC_module_test_state == UICC_MODULE_TEST_HW_DECOUPLED)
    {
        UICC_simulated_hw_reg._SIM_IRQEN |= 0x0010;           /* ENCHTIMER=1 */
        return;
    }
#endif

    SIM_IRQEN |= 0x0010;           /* ENCHTIMER=1                              */
    wait_time(50);/*add by wangxia 10.05.11*/
}

/******************************************************************************
* Function:... UICC_disable_char_timeout_interrupt
* Parameters:. None.
* Returns:.... None.
* Description: Disable character timeout interrupt.
* Created:.... 22.10.02 by (Knud Nymann Mortensen / KNM)
* Modified:... DD.MM.YY by (Full name / initials)
*                Modifications note.
*******************************************************************************/
void UICC_disable_char_timeout_interrupt(void)
{
#ifdef UICC_MODULE_TEST
    if (UICC_module_test_state == UICC_MODULE_TEST_HW_DECOUPLED)
    {
        UICC_simulated_hw_reg._SIM_IRQEN &= 0xFFEF;           /* ENCHTIMER=0 */
        return;
    }
#endif

    SIM_IRQEN &= 0xFFEF;           /* ENCHTIMER=0                              */
    wait_time(50);/*add by wangxia 10.05.11*/
}

/******************************************************************************
* Function:... UICC_enable_t1_end_interrupt
* Parameters:. None.
* Returns:.... None.
* Description: Enable the T=1 END interrupt.
* Created:.... 22.10.02 by (Knud Nymann Mortensen / KNM)
* Modified:... DD.MM.YY by (Full name / initials)
*                Modifications note.
*******************************************************************************/
void UICC_enable_t1_end_interrupt(void)
{
#ifdef UICC_MODULE_TEST
    if (UICC_module_test_state == UICC_MODULE_TEST_HW_DECOUPLED)
    {
        UICC_simulated_hw_reg._SIM_IRQEN |= 0x0040;           /* T1END=1 */
        return;
    }
#endif

    SIM_IRQEN |= 0x0040;           /* T1END=1                               */
    wait_time(50);/*add by wangxia 10.05.11*/
}

/******************************************************************************
* Function:... UICC_disable_t1_end_interrupt
* Parameters:. None.
* Returns:.... None.
* Description: Disable the T=1 END interrupt.
* Created:.... 22.10.02 by (Knud Nymann Mortensen / KNM)
* Modified:... DD.MM.YY by (Full name / initials)
*                Modifications note.
*******************************************************************************/
void UICC_disable_t1_end_interrupt(void)
{
#ifdef UICC_MODULE_TEST
    if (UICC_module_test_state == UICC_MODULE_TEST_HW_DECOUPLED)
    {
        UICC_simulated_hw_reg._SIM_IRQEN &= 0xFFBF;           /* T1END=0 */
        return;
    }
#endif

    SIM_IRQEN &= 0xFFBF;           /* T1END=0                               */
    wait_time(50);/*add by wangxia 10.05.11*/
}

/******************************************************************************
* Function:... UICC_enable_t1_bwt_interrupt
* Parameters:. None.
* Returns:.... None.
* Description: Enable the Block Waiting Timer (BWT) expiration interrupt.
* Created:.... 22.10.02 by (Knud Nymann Mortensen / KNM)
* Modified:... DD.MM.YY by (Full name / initials)
*                Modifications note.
*******************************************************************************/
void UICC_enable_t1_bwt_interrupt(void)
{
#ifdef UICC_MODULE_TEST
    if (UICC_module_test_state == UICC_MODULE_TEST_HW_DECOUPLED)
    {
        UICC_simulated_hw_reg._SIM_IRQEN |= 0x0020;           /* ENBWTTIMER=1 */
        return;
    }
#endif

    SIM_IRQEN |= 0x0020;           /* ENBWTTIMER=1                               */
}

/******************************************************************************
* Function:... UICC_disable_t1_bwt_interrupt
* Parameters:. None.
* Returns:.... None.
* Description: Disable the Block Waiting Timer (BWT) expiration interrupt.
* Created:.... 22.10.02 by (Knud Nymann Mortensen / KNM)
* Modified:... DD.MM.YY by (Full name / initials)
*                Modifications note.
*******************************************************************************/
void UICC_disable_t1_bwt_interrupt(void)
{
#ifdef UICC_MODULE_TEST
    if (UICC_module_test_state == UICC_MODULE_TEST_HW_DECOUPLED)
    {
        UICC_simulated_hw_reg._SIM_IRQEN &= 0xFFDF;           /* ENBWTTIMER=0 */
        return;
    }
#endif

    SIM_IRQEN &= 0xFFDF;           /* ENBWTTIMER=0                               */
}


/******************************************************************************
* Function:... UICC_enable_usim_ok_isr
* Parameters:. None.
* Returns:.... None.
* Description: Enables the USIM_OK_INT interrupt handling.
* Created:.... 22.10.02 by (Knud Nymann Mortensen / KNM)
* Modified:... DD.MM.YY by (Full name / initials)
*                Modifications note.
*******************************************************************************/
void UICC_enable_usim_ok_isr(void)
{
#ifdef UICC_MODULE_TEST
    if (UICC_module_test_state == UICC_MODULE_TEST_HW_DECOUPLED)
    {
        UICC_simulated_hw_reg._SIM_ICR  |= 0x0004;
        UICC_simulated_hw_reg._SIM_IMSC |= 0x0004;
        return;
    }
#endif

    SIM_ICR  |= 0x0004;  /* Clear the OK interrupt request bit. */
    wait_time(50);/*add by wangxia 10.05.11*/
    SIM_IMSC |= 0x0004;  /* Enable OK interrupt mask (OK=1).    */
    wait_time(50);/*add by wangxia 10.05.11*/
}

/******************************************************************************
* Function:... UICC_disable_usim_ok_isr
* Parameters:. None.
* Returns:.... None.
* Description: Disables the USIM_OK_INT interrupt handling.
* Created:.... 22.10.02 by (Knud Nymann Mortensen / KNM)
* Modified:... DD.MM.YY by (Full name / initials)
*                Modifications note.
*******************************************************************************/
void UICC_disable_usim_ok_isr(void)
{
#ifdef UICC_MODULE_TEST
    if (UICC_module_test_state == UICC_MODULE_TEST_HW_DECOUPLED)
    {
        UICC_simulated_hw_reg._SIM_IMSC &= 0xFFFB;
        return;
    }
#endif

    SIM_IMSC &= 0xFFFB;   /* OK=0 */
    wait_time(50);/*add by wangxia 10.05.11*/
}

/******************************************************************************
* Function:... UICC_enable_usim_err_isr
* Parameters:. None.
* Returns:.... None.
* Description: Enables the USIM_ERR_INT interrupt handling.
* Created:.... 22.10.02 by (Knud Nymann Mortensen / KNM)
* Modified:... DD.MM.YY by (Full name / initials)
*                Modifications note.
*******************************************************************************/
void UICC_enable_usim_err_isr(void)
{
#ifdef UICC_MODULE_TEST
    if (UICC_module_test_state == UICC_MODULE_TEST_HW_DECOUPLED)
    {
        UICC_simulated_hw_reg._SIM_ICR  |= 0x0001;
        UICC_simulated_hw_reg._SIM_IMSC |= 0x0001;
        return;
    }
#endif

    SIM_ICR  |= 0x0001;  /* Clear the ERR interrupt request bit. */
    wait_time(50);/*add by wangxia 10.05.11*/
    SIM_IMSC |= 0x0001;  /* Enable ERR intterrupt mask (ERR=1).  */
    wait_time(50);/*add by wangxia 10.05.11*/
}

/******************************************************************************
* Function:... UICC_disable_usim_err_isr
* Parameters:. None.
* Returns:.... None.
* Description: Disables the USIM_ERR_INT interrupt handling.
* Created:.... 22.10.02 by (Knud Nymann Mortensen / KNM)
* Modified:... DD.MM.YY by (Full name / initials)
*                Modifications note.
*******************************************************************************/
void UICC_disable_usim_err_isr(void)
{
#ifdef UICC_MODULE_TEST
    if (UICC_module_test_state == UICC_MODULE_TEST_HW_DECOUPLED)
    {
        UICC_simulated_hw_reg._SIM_IMSC &= 0xFFFE;
        return;
    }
#endif

    SIM_IMSC &= 0xFFFE;   /* ERR=1 */
    wait_time(50);/*add by wangxia 10.05.11*/
}

/******************************************************************************
* Function:... UICC_enable_usim_in_isr
* Parameters:. None.
* Returns:.... None.
* Description: Enables the USIM_IN_INT interrupt handling.
* Created:.... 22.10.02 by (Knud Nymann Mortensen / KNM)
* Modified:... DD.MM.YY by (Full name / initials)
*                Modifications note.
*******************************************************************************/
void UICC_enable_usim_in_isr(void)
{
#ifdef UICC_ENABLE_IN_OUT_DETECTION
    /*Initialize the CC_IN port to be used accordingly. */

    /* The use of the IN/OUT detection mechanism is platform specific and shall as
       such be defined with projects utilising this feature. */
#ifdef UICC_MODULE_TEST
    if (UICC_module_test_state == UICC_MODULE_TEST_HW_DECOUPLED)
    {
        UICC_simulated_hw_reg._SIM_ICR  |= 0x0002;
        UICC_simulated_hw_reg._SIM_IMSC |= 0x0002;
        return;
    }
#endif

    SIM_ICR  |= 0x0002;  /* Clear the IN interrupt request bit. */
    wait_time(50);/*add by wangxia 10.05.11*/
    SIM_IMSC |= 0x0002;  /* Enable IN interrupt mask (IN=1).    */
    wait_time(50);/*add by wangxia 10.05.11*/
#endif
}

/******************************************************************************
* Function:... UICC_disable_usim_in_isr
* Parameters:. None.
* Returns:.... None.
* Description: Disables the USIM_IN_INT interrupt handling.
* Created:.... 22.10.02 by (Knud Nymann Mortensen / KNM)
* Modified:... DD.MM.YY by (Full name / initials)
*                Modifications note.
*******************************************************************************/
void UICC_disable_usim_in_isr(void)
{
#ifdef UICC_ENABLE_IN_OUT_DETECTION

#ifdef UICC_MODULE_TEST
    if (UICC_module_test_state == UICC_MODULE_TEST_HW_DECOUPLED)
    {
        UICC_simulated_hw_reg._SIM_IMSC &= 0xFFFD;
        return;
    }
#endif

    SIM_IMSC &= 0xFFFD;   /* IN=0 */
    wait_time(50);/*add by wangxia 10.05.11*/
#endif
}

/******************************************************************************
* Function:... UICC_get_simstatus
* Parameters:. None.
* Returns:.... The SIMSTATUS interrupt source register.
* Description: This function reads out the SIMSTATUS interrupt source register.
* Created:.... 13.01.04 by (Knud Nymann Mortensen / KNM)
* Modified:... DD.MM.YY by (Full name / initials)
*                Modifications note.
*******************************************************************************/
ulong UICC_get_simstatus(void)
{
#ifdef UICC_MODULE_TEST
    if (UICC_module_test_state == UICC_MODULE_TEST_HW_DECOUPLED)
    {
        return(UICC_simulated_hw_reg._SIM_STATUS);
    }
#endif

    return(SIM_STATUS);
}

/******************************************************************************
* Function:... UICC_usim_ok_lisr
* Parameters:. None.
* Returns:.... None.
* Description: Called from the interrupt entry each time the USIM block has
*              generated an USIM_OK_INT interrupt.
* Created:.... 22.10.02 by (Knud Nymann Mortensen / KNM)
* Modified:... DD.MM.YY by (Full name / initials)
*                Modifications note.
*******************************************************************************/
void UICC_usim_ok_lisr(void)
{
    T_UICC_INT_EVENTS cause;

#ifdef UICC_MODULE_TEST
    ushort status;

    if (UICC_module_test_state == UICC_MODULE_TEST_HW_DECOUPLED)
    {
        status = UICC_simulated_hw_reg._SIM_STATUS;
        UICC_simulated_hw_reg._SIM_ICR |= 0x0004;
    }
    else
    {
        status = SIM_STATUS;
        SIM_ICR |= 0x0004; /* Clear the OK interrupt request bit. */
    }
#else
    ushort status = SIM_STATUS;
    //wait_time(50);/*add by wangxia 10.05.11*/
    SIM_ICR |= 0x0004; /* Clear the OK interrupt request bit. */
    wait_time(50);/*add by wangxia 10.05.11*/
#endif

#ifdef INTERRUPT_TRACE
    UICC_interrupt_trace[UICC_interrupt_cnt] = status | UICC_UART_OK_INT;
    if (++UICC_interrupt_cnt >= UICC_INTERRUPT_CNT_SIZE)
        UICC_interrupt_cnt = 0;
#endif

#ifdef UICC_DEBUG_OK_PORT_TOGGLE
    DEBUG_SET_PORT(UICC_DEBUG_OK_PORT_TOGGLE);
#endif

    if (status & 0x0001)
    {
        cause = UICC_CHARACTER_OK;         /* UARTOK */
    }
    else
    {
        cause = UICC_UNKNOWN_INT;        /* Should NOT be POSSIBLE */
    }

    UICC_control_card_access(cause);      /* Call the engine in the card access layer
                                               currently control access to the card. */
#ifdef UICC_DEBUG_OK_PORT_TOGGLE
    DEBUG_CLEAR_PORT(UICC_DEBUG_OK_PORT_TOGGLE);
#endif
}

/******************************************************************************
* Function:... UICC_usim_err_lisr
* Parameters:. None.
* Returns:.... None.
* Description: Called from the interrupt entry each time the USIM block has
*              generated an interrupt (PARINT, OVRRUN, T0END, CHTIMEOUT, T1END,
*              SIMT1PAR, SIMT1BWT) on USIM_ERR_INT.
* Created:.... 22.10.02 by (Knud Nymann Mortensen / KNM)
* Modified:... DD.MM.YY by (Full name / initials)
*                Modifications note.
*******************************************************************************/
#ifdef UICC_DEBUG_INF
UINT32 g_count1=0;
UINT32 g_count2=0;
UINT32 g_count3=0;
#endif
void UICC_usim_err_lisr(void)
{
    T_UICC_INT_EVENTS cause;

#ifdef UICC_MODULE_TEST
    ushort status;

    if (UICC_module_test_state == UICC_MODULE_TEST_HW_DECOUPLED)
    {
        status = UICC_simulated_hw_reg._SIM_STATUS;
        UICC_simulated_hw_reg._SIM_ICR |= 0x0001;
    }
    else
    {
        status = SIM_STATUS;
        SIM_ICR |= 0x0001; /* Clear the ERR interrupt request bit. */
    }
#else
    ushort status = SIM_STATUS;
    wait_time(50);/*add by wangxia 10.05.11*/
    SIM_ICR |= 0x0001; /* Clear the ERR interrupt request bit. */
    wait_time(50);/*add by wangxia 10.05.11*/
#endif

#ifdef INTERRUPT_TRACE
    UICC_interrupt_trace[UICC_interrupt_cnt] = status | UICC_UART_ERR_INT;
    if (++UICC_interrupt_cnt >= UICC_INTERRUPT_CNT_SIZE)
        UICC_interrupt_cnt = 0;
#endif

#ifdef UICC_DEBUG_ERR_PORT_TOGGLE
    DEBUG_SET_PORT(UICC_DEBUG_ERR_PORT_TOGGLE);
#endif

    if (status & 0x0008)
    {
        cause = UICC_T0_END;
#ifdef UICC_DEBUG_INF
        g_count1++;
#endif
    }
    else if (status & 0x0040)
    {
        cause = UICC_T1_END;
    }
    else if (status & 0x0002)
    {
        cause = UICC_PARITY_ERROR;
        SIM_STATUS &= ~0x0002; /* Clear the bit */
        wait_time(50);/*add by wangxia 10.05.11*/
    }
    else if (status & 0x0004)
    {
        cause = UICC_OVERRUN_ERROR;
#ifdef UICC_DEBUG_INF
        g_count2++;
#endif
    }
    else if (status & 0x0080)
    {
        cause = UICC_T1_PARITY_ERROR;
    }
    else if (status & 0x0020)
    {
        cause = UICC_CHTIMEOUT;
    }
    else if (status & 0x0100)
    {
        cause = UICC_T1_BWT_EXPIRED;
    }
    else
    {
        cause = UICC_UNKNOWN_INT;
#ifdef UICC_DEBUG_INF
        g_count3++;
#endif
    }

    UICC_control_card_access(cause);      /* Call the engine in the card access layer
                                            currently control access to the card. */

    SIM_STATUS = 0x0000;

#ifdef UICC_MODULE_TEST
    if (UICC_module_test_state == UICC_MODULE_TEST_HW_DECOUPLED)
    {
        UICC_simulated_hw_reg._SIM_STATUS = 0x0000;
    }
#endif

#ifdef UICC_DEBUG_ERR_PORT_TOGGLE
    DEBUG_CLEAR_PORT(UICC_DEBUG_ERR_PORT_TOGGLE);
#endif
}

#if defined (UICC_FIFO_MODE)
/******************************************************************************
* Function:... UICC_usim_fifo_lisr
* Parameters:. None.
* Returns:.... None.
* Description: Called from the interrupt entry each time the USIM block has
*                   generated an USIM_FIFO_INT interrupt.
* Created:.... 31-8-2005 by (Manh Tran / MTR)
* Modified:... DD.MM.YY by (Full name / initials)
*                Modifications note.
*******************************************************************************/
void UICC_usim_fifo_lisr(void)
{

#ifdef UICC_FIFO_ONLY
    ushort status;
    T_UICC_INT_EVENTS cause;

#ifdef UICC_MODULE_TEST
    if (UICC_module_test_state == UICC_MODULE_TEST_HW_DECOUPLED)
    {
        status = UICC_simulated_hw_reg._SIM_FIFO_MIS;
    }
    else
    {
        status = SIM_FIFO_MIS;
    }
#else
    status = SIM_FIFO_MIS;
#endif

    if (status & 0x0001)
    {
        cause = UICC_RX_LSREQ;
    }
    else if (status & 0x0002)
    {
        cause = UICC_TX_LSREQ;
    }
    else if (status & 0x0004)
    {
        cause = UICC_RX_SREQ;
    }
    else if (status & 0x0008)
    {
        cause = UICC_TX_SREQ;
    }
    else if (status & 0x0010)
    {
        cause = UICC_RX_LBREQ;
    }
    else if (status & 0x0020)
    {
        cause = UICC_TX_LBREQ;
    }
    else if (status & 0x0040)
    {
        cause = UICC_RX_BREQ;
    }
    else if (status & 0x0080)
    {
        cause = UICC_TX_BREQ;
    }
    else if (status & 0x0100)
    {
        cause = UICC_TXF_OFL_IRQ;
    }
    else if (status & 0x0200)
    {
        cause = UICC_RXF_UFL_IRQ;
    }
    else
    {
        cause = UICC_FIFO_UNKNOWN_INT;
    }

    UICC_control_card_access(cause);      /* Call the engine in the card access layer
                                            currently control access to the card. */

#ifdef UICC_MODULE_TEST
    if (UICC_module_test_state == UICC_MODULE_TEST_HW_DECOUPLED)
    {
    }
    else
    {
        SIM_FIFO_ICR |= 0x03FF; // Clear the FIFO interrupt request bit.
    }
#else
    SIM_FIFO_ICR |= 0x03FF; // Clear the FIFO interrupt request bit.
    wait_time(50);/*add by wangxia 10.05.11*/
#endif

#endif
}


/******************************************************************************
* Function:... UICC_init_fifo
* Parameters:. None.
* Returns:.... None.
* Description: Initial the FIFO register in FIFO mode.
* Created:.... 22.9.05 by (Manh Tran / MTR)
* Modified:... DD.MM.YY by (Full name / initials)
*                Modifications note.
*******************************************************************************/
void UICC_init_fifo(void)
{

#ifdef UICC_MODULE_TEST
    if (UICC_module_test_state == UICC_MODULE_TEST_HW_DECOUPLED)
    {
        return;
    }
#endif

#ifdef UICC_FIFO_ONLY
    SIM_FIFO_DMA = 0x00; /*Disable DMA request*/
    SIM_FIFO_CFG = 0x00030022; /*Burst size of 4 word, Byte alignment, FIFO  NOT as flow control */
#else
    SIM_FIFO_DMA = 0xFF; /*Enable DMA request*/
    SIM_FIFO_CFG = 0x00030022; /*Burst size of 4 word, Byte alignment, FIFO  as flow control */
#endif

    /* Enable all FIFO request interrup in Interrupt Mask Control Register*/
    SIM_FIFO_IMSC = 0x3FF; /*Mask LSREG,SREG,LBREQ,BREQ,(Transmit overflow, receive underflow debug only) */

    SIM_MODE |= 0x01; /*SIM_LEGACY_N = 1 enable FIFO MODE */
    wait_time(50);/*add by wangxia 10.05.11*/
    SIM_RUN_CTRL = 0x01; //RUN = ACTIVE
}

#endif
/******************************************************************************
* Function:... uicc_remove_isr
* Parameters:. None.
* Returns:.... None.
* Description: Called from the interrupt entry each time the USIM block has
*              detected an insertion or a removal of the card.
* Created:.... 22.10.02 by (Knud Nymann Mortensen / KNM)
* Modified:... DD.MM.YY by (Full name / initials)
*                Modifications note.
*******************************************************************************/
void uicc_remove_isr(void)
{
	UICC_obtain_semaphore(UICC_HOTPLUG_SEM);

    deactivate_card_connections();
 #if 0
	while(UICC_card_ctrl_state[UICC_current_reader] > UICC_INACTIVE
		&& UICC_card_ctrl_state[UICC_current_reader] != UICC_IDLE){
		zOss_Sleep(50);
	}
#endif
	#if 0
    if (UICC_card_ctrl_state[UICC_current_reader] == UICC_BUSY)
    {
       UICC_release_semaphore(UICC_TRANSPORT_APDU_SEM);
    }
	#endif
    //UICC_card_ctrl_state[UICC_current_reader] = UICC_INACTIVE;

    invoke_callback(  CARD_REMOVED, UICC_current_reader);
    uiccDebug_Printf("[%d]remove\n",zOss_GetTickCount());
    uiccramlog_Printf("[%d]remove\n",zOss_GetTickCount());
    zOss_DebugInfoRecord(MODULE_ID_PS_UICC, "[%d]remove\n",zOss_GetTickCount());
    UICC_release_semaphore(UICC_HOTPLUG_SEM);
}

/******************************************************************************
* Function:... uicc_insert_isr
* Parameters:. None.
* Returns:.... None.
* Description: Called from the interrupt entry each time the USIM block has
*              detected an insertion or a removal of the card.
* Created:.... 22.10.02 by (Knud Nymann Mortensen / KNM)
* Modified:... DD.MM.YY by (Full name / initials)
*                Modifications note.
*******************************************************************************/
void uicc_insert_isr(void)
{
	UICC_obtain_semaphore(UICC_HOTPLUG_SEM);

#if 0
	while(UICC_card_ctrl_state[UICC_current_reader] > UICC_INACTIVE){
		zOss_Sleep(50);
	}
#endif
        deactivate_card_connections();
  //      UICC_card_ctrl_state[UICC_current_reader] = UICC_INACTIVE;

        invoke_callback(CARD_INSERTED, UICC_current_reader);
        uiccDebug_Printf("[%d]insert\n",zOss_GetTickCount());
	 uiccramlog_Printf("[%d]insert\n",zOss_GetTickCount());
 	 zOss_DebugInfoRecord(MODULE_ID_PS_UICC, "[%d]insert\n",zOss_GetTickCount());
	UICC_release_semaphore(UICC_HOTPLUG_SEM);
}

hotplugCallback_func uicc_hotplugCallback = NULL;

void uicc_set_hotplugCallback(hotplugCallback_func func)
{
	uicc_hotplugCallback = func;
	
}


#if 0
extern UINT32 g_testsiminorout;
extern void invoke_callback(T_UICC_CARD_ACTION card_action, T_UICC_CARD_SELECTOR card_selector);
extern void deactivate_card_connections(void);
extern VOID uiccDebug_Printf(char *fmt,...);

#ifndef SOC_USIM
void UICC_usim_in_or_out_lisr(void)
{
    zDrvInt_MaskIrq(EX5_INT);

    usdelay(20000);

    //remove event
    if (g_testsiminorout == 0)
    {
        deactivate_card_connections();
        if (UICC_card_ctrl_state[UICC_current_reader] == UICC_BUSY)
        {
            UICC_release_semaphore(UICC_TRANSPORT_APDU_SEM);
        }
        UICC_card_ctrl_state[UICC_current_reader] = UICC_INACTIVE;

        invoke_callback(  CARD_REMOVED, UICC_current_reader);
        uiccDebug_Printf("[%d]remove",zOss_GetTickCount());

        g_testsiminorout = 1;
        zDrvPcu_SetIntLevel(EX5_INT_PCU,PCUINT_NEGEDGE);
    }
    else  //generate insert event
    {
        deactivate_card_connections();
        UICC_card_ctrl_state[UICC_current_reader] = UICC_INACTIVE;

        invoke_callback(CARD_INSERTED, UICC_current_reader);
        uiccDebug_Printf("[%d]insert",zOss_GetTickCount());

        g_testsiminorout = 0;
        zDrvPcu_SetIntLevel(EX5_INT_PCU,PCUINT_POSEDGE);
    }

    zDrvPcu_ClearInt(EX5_INT_PCU);
    zDrvInt_UnmaskIrq(EX5_INT);
}
#else
void UICC_socUsim_in_or_out_lisr(void)
{
    zDrvInt_MaskIrq(EX2_INT);
    usdelay(20000);

    //remove event
    if (g_testsiminorout == 0)
    {
        deactivate_card_connections();
        if (UICC_card_ctrl_state[UICC_current_reader] == UICC_BUSY)
        {
            UICC_release_semaphore(UICC_TRANSPORT_APDU_SEM);
        }
        UICC_card_ctrl_state[UICC_current_reader] = UICC_INACTIVE;

        invoke_callback(  CARD_REMOVED, UICC_current_reader);
        uiccDebug_Printf("[%d]remove",zOss_GetTickCount());

        g_testsiminorout = 1;
        zDrvPcu_SetIntLevel(EX2_INT_PCU,PCUINT_NEGEDGE);

    }
    else  //generate insert event
    {
        deactivate_card_connections();
        UICC_card_ctrl_state[UICC_current_reader] = UICC_INACTIVE;

        invoke_callback(CARD_INSERTED, UICC_current_reader);
        uiccDebug_Printf("[%d]insert",zOss_GetTickCount());

        g_testsiminorout = 0;
        zDrvPcu_SetIntLevel(EX2_INT_PCU,PCUINT_POSEDGE);

    }

    zDrvPcu_ClearInt(EX2_INT_PCU);
    zDrvInt_UnmaskIrq(EX2_INT);

}
#endif
#endif
/******************************************************************************
* Function:... UICC_usim_in_out_lisr
* Parameters:. None.
* Returns:.... None.
* Description: Called from the interrupt entry each time the USIM block has
*              detected an insertion or a removal of the card.
* Created:.... 22.10.02 by (Knud Nymann Mortensen / KNM)
* Modified:... DD.MM.YY by (Full name / initials)
*                Modifications note.
*******************************************************************************/
void UICC_usim_in_out_lisr(void)
{
#ifdef UICC_ENABLE_IN_OUT_DETECTION
    T_UICC_INT_EVENTS cause;

    UICC_resign_from_power_saving();

    SIM_IMSC &= 0xFFFD;   /* Disable IN/OUT interrupt */

#ifdef INTERRUPT_TRACE
    UICC_interrupt_trace[UICC_interrupt_cnt] = SIM_STATUS | UICC_IN_OUT_INT;
    if (++UICC_interrupt_cnt >= UICC_INTERRUPT_CNT_SIZE)
        UICC_interrupt_cnt = 0;
#endif

#ifdef UICC_MODULE_TEST
    if (UICC_module_test_state == UICC_MODULE_TEST_HW_DECOUPLED)
    {
        UICC_simulated_hw_reg._SIM_ICR |= 0x0002;
    }
    else
    {
        SIM_ICR |= 0x0002; /* Clear the IN interrupt request bit. */
    }

    if (UICC_simulated_hw_reg._SIM_STATUS & 0x0010)
    {
        cause = UICC_CARD_IN;
    }
    else
    {
        cause = UICC_CARD_OUT;
    }
#else
    SIM_IMSC &= 0xFFFD;   /* IN=0 */
    SIM_ICR |= 0x0002; /* Clear the IN interrupt request bit. */

    if (SIM_STATUS & 0x0010)
    {
        cause = UICC_CARD_IN;
    }
    else
    {
        cause = UICC_CARD_OUT;
    }
#endif

    UICC_in_out_control((T_UICC_CTRL_CARD_PRESENCE_EVENTS)cause);
#endif
}


#ifdef UICC_ENABLE_IN_OUT_DETECTION
/******************************************************************************
* Function:... UICC_check_card_presence
* Parameters:. None.
* Returns:.... The card presence status: TRUE -> Present and FALSE -> absent
* Description: Checks the current card presence status.
* Created:.... 19.12.05 by (Manh Tran / MTR)
* Modified:... DD.MM.YY by (Full name / initials)
*                Modifications note.
*******************************************************************************/
ubyte UICC_check_card_presence(void)
{
#ifdef UICC_MODULE_TEST
    if (UICC_module_test_state == UICC_MODULE_TEST_HW_DECOUPLED)
    {
        if (UICC_simulated_hw_reg._SIM_STATUS & 0x0010)
        {
            return(TRUE);  /* The card is present. */
        }
        else
        {
            return(FALSE); /* The card is not present. */
        }
    }
#endif

    if (SIM_STATUS & 0x0010)
    {
        return(TRUE);  /* The card is present. */
    }
    else
    {
        return(FALSE); /* The card is not present. */
    }
}
#endif

/******************************************************************************
* Function:... UICC_disable_dma_channel
* Parameters:. None.
* Returns:.... None.
* Description: Disables the DMA channel associated to the USIM block.
* Created:.... 05.11.02 by (Knud Nymann Mortensen / KNM)
* Modified:... DD.MM.YY by (Full name / initials)
*                Modifications note.
*******************************************************************************/
void UICC_disable_dma_channel(void)
{
#ifdef UICC_MODULE_TEST
    if (UICC_module_test_state == UICC_MODULE_TEST_HW_DECOUPLED)
    {
        UICC_simulated_hw_reg._SIM_DMA &= 0xFFFE;
        return;
    }
#endif

    sSIM_DMA->OKEN = 0;
}

/******************************************************************************
* Function:... UICC_PowerUp
* Parameters:. None.
* Returns:.... None.
* Description:
* Created:....
* Modified:...
*Modifications note.
*******************************************************************************/
VOID UICC_PowerThread(SINT32 arg)
{
    SINT32 ret;
    T_UICC_POWER_MSG msg = {0};
    
    while (1)
    {
        zOss_GetSemaphore(UICC_power_sem,ZOSS_WAIT_FOREVER);

        ret = ringQueue_Dequeue(UICC_power_msg_queue, &msg);
        if (ret != 0)
            continue;

        if (msg.action == DRV_CARD_POWERUP)
        {
            zDrvPmic_SetNormal_Voltage(msg.regulator, gVsimType);
	        zDrvPmic_SetNormal_Onoff(msg.regulator, PM_ENABLE);
			UICC_start_timer(T_DELAY_VCC_TO_IO);
        }
        else
        {
            zDrvPmic_SetNormal_Onoff(msg.regulator, PM_DISABLE);
        }

    }
}
#ifndef UICC_FIFO_ONLY

/******************************************************************************
* Function:... UICC_enable_dma_channel
* Parameters:. None.
* Returns:.... None.
* Description: Enables the DMA channel associated to the USIM block.
* Created:.... 05.11.02 by (Knud Nymann Mortensen / KNM)
* Modified:... DD.MM.YY by (Full name / initials)
*                Modifications note.
*******************************************************************************/
void UICC_enable_dma_channel(void)
{
#ifdef UICC_MODULE_TEST
    if (UICC_module_test_state == UICC_MODULE_TEST_HW_DECOUPLED)
    {
        UICC_simulated_hw_reg._SIM_DMA |= 0x0001;
        return;
    }
#endif

    sSIM_DMA->OKEN = 1;
}

/******************************************************************************
* Function:... UICC_dma_rx_control
* Parameters:. nof_bytes: The number of Rx bytes to be transferred.
*              dest_ptr:  A pointer to the data store to which data
*              should be transferred to.
*              flow_ctrl: indicates the flow controller of the current DMA
*              operation (USIM or DMA).
* Returns:.... None.
* Description: This function sets up the DMA controller to be able to transfer
*              data from Rx-register to data store.
* Created:.... 05.11.02 by (Knud Nymann Mortensen / KNM)
* Modified:... DD.MM.YY by (Full name / initials)
*                Modifications note.
*******************************************************************************/
void UICC_dma_rx_control(ushort nof_bytes,
                         ubyte  *dest_ptr,
                         T_UICC_DMA_FLOW_CONTROL flow_ctrl)

{
    T_ZDrvDma_ChannelDef  tChanCfgAsUiccRev;

    halDma_Disable((UINT16) DMA_CHNNL_USIM_RX);

    tChanCfgAsUiccRev.DestAddr = (UINT32)dest_ptr;

#ifdef UICC_FIFO_MODE
    tChanCfgAsUiccRev.SrcAddr = (UINT32)&SIM_FIFO_RXD;
#else
    tChanCfgAsUiccRev.SrcAddr = (UINT32)&SIM_RX;
#endif

    //config dma channel control register
    tChanCfgAsUiccRev.CONTROL.DmaEnable = DMA_ENABLE;

    tChanCfgAsUiccRev.CONTROL.ReqMod = DMA_PERIPHERAL_REQ;

    tChanCfgAsUiccRev.CONTROL.PeriReqSel = DMA_CHNNL_USIM_RX;

    tChanCfgAsUiccRev.CONTROL.SrcMod = DMA_ADDRMOD_FIFO;

    tChanCfgAsUiccRev.CONTROL.DestMod = DMA_ADDRMOD_RAM;

    tChanCfgAsUiccRev.CONTROL.IRQMod = DMA_IRQ_ENABLE;

    tChanCfgAsUiccRev.CONTROL.TransferSize = DMA_TRANSIZE_WORD;

    tChanCfgAsUiccRev.CONTROL.BurstSize = DMA_BURST_SIZE_1;

    tChanCfgAsUiccRev.CONTROL.TransNumber = nof_bytes;


    halDma_Config((UINT16) DMA_CHNNL_USIM_RX,tChanCfgAsUiccRev,UICC_dma_lisr);

}

/******************************************************************************
* Function:... UICC_dma_tx_control
* Parameters:. nof_bytes: The number of Rx bytes to be transferred.
*              src_ptr:  A pointer to the data store from which data should
*              be transferred.
*              flow_ctrl: indicates the flow controller of the current DMA
*              operation (USIM or DMA).
* Returns:.... None.
* Description: This function sets up the DMA controller to be able to transfer
*              data from data store to Tx-register.
* Created:.... 05.11.02 by (Knud Nymann Mortensen / KNM)
* Modified:... DD.MM.YY by (Full name / initials)
*                Modifications note.
*******************************************************************************/
void UICC_dma_tx_control(ushort                   nof_bytes,
                         ubyte                   *src_ptr,
                         T_UICC_DMA_FLOW_CONTROL flow_ctrl)
{
    /*[Begin] [wangxia-2007/12/13]*/
    T_ZDrvDma_ChannelDef  tChanCfgAsUiccTxd;
    /*[End] [wangxia-2007/12/13]*/


    /*[Begin] [wangxia-2007/12/13]*/
    halDma_Disable((UINT16) DMA_CHNNL_USIM_TX);
    /*[End] [wangxia-2007/12/13]*/



    tChanCfgAsUiccTxd.SrcAddr = (UINT32)src_ptr;

#ifdef UICC_FIFO_MODE
    tChanCfgAsUiccTxd.DestAddr = (UINT32)&SIM_FIFO_TXD;
#else
    tChanCfgAsUiccTxd.DestAddr = (UINT32)&SIM_TX;
#endif

    //config dma channel control register
    tChanCfgAsUiccTxd.CONTROL.DmaEnable = DMA_ENABLE;

    tChanCfgAsUiccTxd.CONTROL.ReqMod = DMA_PERIPHERAL_REQ;

    tChanCfgAsUiccTxd.CONTROL.PeriReqSel = DMA_CHNNL_USIM_TX;

    tChanCfgAsUiccTxd.CONTROL.SrcMod = DMA_ADDRMOD_RAM;

    tChanCfgAsUiccTxd.CONTROL.DestMod = DMA_ADDRMOD_FIFO;

    tChanCfgAsUiccTxd.CONTROL.IRQMod = DMA_IRQ_ENABLE;

    tChanCfgAsUiccTxd.CONTROL.TransferSize = DMA_TRANSIZE_WORD;

    tChanCfgAsUiccTxd.CONTROL.BurstSize = DMA_BURST_SIZE_1;

    tChanCfgAsUiccTxd.CONTROL.TransNumber = nof_bytes;

    SIM_TPS_CTRL = nof_bytes;



    halDma_Config((UINT16) DMA_CHNNL_USIM_TX,tChanCfgAsUiccTxd,UICC_dma_lisr);
}
/******************************************************************************
* Function:... UICC_dma_get_transfer_cnt
* Parameters:. None.
* Returns:.... The remaining transfer size.
* Description: This function reads out the current transfer size from the used
*              DMA channel.
* Created:.... 13.01.04 by (Knud Nymann Mortensen / KNM)
* Modified:... DD.MM.YY by (Full name / initials)
*                Modifications note.
*******************************************************************************/
ulong UICC_dma_get_transfer_cnt(void)
{
    return 1;
}

/******************************************************************************
* Function:... UICC_dma_disable_control
* Parameters:. None.
* Returns:.... None.
* Description: This function disables the DMA controller.
* Created:.... 13.11.02 by (Knud Nymann Mortensen / KNM)
* Modified:... DD.MM.YY by (Full name / initials)
*                Modifications note.
*******************************************************************************/
void UICC_dma_disable_control(void)
{

    halDma_Disable((UINT16) DMA_CHNNL_USIM_TX);
}


/******************************************************************************
* Function:... UICC_dma_lisr
* Parameters:. None.
* Returns:.... None.
* Description: UICC DMA interrupt entry.
* Created:.... 22.10.02 by (Knud Nymann Mortensen / KNM)
* Modified:... DD.MM.YY by (Full name / initials)
*                Modifications note.
*******************************************************************************/
void UICC_dma_lisr(T_ZDrvDma_IntStatus Int)

{

    switch (Int)
    {
    case DMA_INT_END:

        UICC_control_card_access(UICC_DMA_END);
        UICC_debug[UICC_debug_count][0] = 18;
        UICC_debug[UICC_debug_count][1] = gHalDma_Regs->INTCLEAR .INTCLEAR_BIT_SET.TC_CLEAR;
        UICC_debug[UICC_debug_count][2] =gHalDma_Regs->INTCLEAR .INTCLEAR_BIT_SET.ERR_CLEAR;
        UICC_debug_count = (UICC_debug_count+1) % 200;

        break;


    case DMA_INT_ERR:
        UICC_debug[UICC_debug_count][0] = 19;
        UICC_debug[UICC_debug_count][1] = gHalDma_Regs->INTCLEAR .INTCLEAR_BIT_SET.TC_CLEAR;
        UICC_debug[UICC_debug_count][2] = gHalDma_Regs->INTCLEAR .INTCLEAR_BIT_SET.ERR_CLEAR;
        UICC_debug_count = (UICC_debug_count+1) % 200;

        break;

    default:

        break;

    }

}

#endif

/* End of file. */
