/**************************************************************************
*
*                  Copyright (c) 2012 ZTE Corporation.
*
***************************************************************************
* ģ   : P98C_OSS
*    : oss_fs.h
* ļ : 
* ʵֹ : ļϵͳ
*      : chenxingfang
*      : V1.0
*  : 2012-08-10
* ˵ : 
**************************************************************************/

/**************************************************************************
* ޸ļ¼
**************************************************************************/
#ifndef _OSS_FS_H
#define _OSS_FS_H

/**************************************************************************
* #include
**************************************************************************/
#ifdef __cplusplus
extern "C"
{
#endif

/**************************************************************************
* 
**************************************************************************/
/* дλ */
#define ZOSS_SEEK_SET               0x0           /* set to offset                            */
#define ZOSS_SEEK_CUR               0x1           /* set to current position plus offset      */
#define ZOSS_SEEK_END               0x2           /* set to the size of the file plus offset  */

/* ò */
#define ZOSS_MAX_FILENAME_LEN       255         /* ļĿ¼󳤶, ·   */

/* ļĿ¼ԣ˽Ʊʾ */
#define ZOSS_ATTR_IFDIR             040000      /* Ŀ¼λ                       */
    
#define ZOSS_ATTR_RD_USR            0400        /* user                       */
#define ZOSS_ATTR_WR_USR            0200        /* userд                       */
#define ZOSS_ATTR_EX_USR            0100        /* userִ                     */
    
#define ZOSS_ATTR_RD_GRP            0040        /* group                      */
#define ZOSS_ATTR_WR_GRP            0020        /* groupд                      */
#define ZOSS_ATTR_EX_GRP            0010        /* groupִ                    */
    
#define ZOSS_ATTR_RD_OTH            0004        /* other                      */
#define ZOSS_ATTR_WR_OTH            0002        /* otherд                      */
#define ZOSS_ATTR_EX_OTH            0001        /* otherִ                    */
    
#define ZOSS_ATTR_RWX_USR           0700        /* userĶдִ               */
#define ZOSS_ATTR_RWX_GRP           0070        /* groupĶдִ              */
#define ZOSS_ATTR_RWX_OTH           0007        /* otherĶдִ              */
    
#define ZOSS_ATTR_RD_ALL            0444        /* user,group,otherĶ         */
#define ZOSS_ATTR_WR_ALL            0222        /* user,group,otherд         */
#define ZOSS_ATTR_EX_ALL            0111        /* usergroup,otherִ      */
    
#define ZOSS_ATTR_RWX_ALL           0777        /* usergroup,otherĶдִ  */

#ifdef _OS_LINUX
# define FILE   int
#endif

/**************************************************************************
* ݽṹ
**************************************************************************/
typedef struct  
{
#if defined(_OS_TOS) && defined(CYGPKG_FILEIO_DIRENT_DTYPE)
    mode_t  d_type;
#endif

    CHAR    d_name[ZOSS_MAX_FILENAME_LEN + 1];
}ZOSS_S_DIRENT;

typedef struct  
{
    UINT32  st_dev;     /* Device ID number             */
    UINT32  st_ino;     /* File serial number           */
    mode_t  st_mode;    /* Mode of file                 */
    UINT16  st_nlink;   /* Number of hard links to file */
    UINT32  st_uid;     /* User ID of file              */
    UINT32  st_gid;     /* Group ID of file             */
    UINT32  st_rdev;    /* Device ID if special file    */
    UINT32  st_size;    /* File size in bytes           */
    time_t  st_atime;   /* Time of last access          */
    time_t  st_mtime;   /* Time of last modification    */
    time_t  st_ctime;   /* Time of last status change   */
}ZOSS_S_STAT;

/**************************************************************************
* 
**************************************************************************/
UINT32  zOss_FCreate(const CHAR *filename);
FILE   *zOss_FOpen(const CHAR *filename, const CHAR *mode);
UINT32  zOss_FSeek(FILE *stream, SINT32 offset, SINT32 whence);
SSIZE_T zOss_FRead(VOID *data, SSIZE_T size, SSIZE_T count, FILE *stream);
SSIZE_T zOss_FWrite(const VOID *data, SSIZE_T size, SSIZE_T count, FILE *stream);
UINT32  zOss_FEof(FILE *stream);
UINT32  zOss_FError(FILE *stream);
UINT32  zOss_FTruncate(FILE *stream, UINT32 size);
UINT32  zOss_FFlush(FILE *stream);
UINT32  zOss_FTell(FILE *stream);
UINT32  zOss_FClose(FILE *stream);
UINT32  zOss_FRename(const CHAR *old_filename, const CHAR *new_filename);
UINT32  zOss_FDelete(const CHAR *filename);
UINT32  zOss_FLength(FILE *stream);
BOOL    zOss_FExist(const CHAR *filename);
UINT32  zOss_Mkdir(const CHAR *dirname);
UINT32  zOss_Rmdir(const CHAR *dirname);
UINT32  zOss_Rndir(const CHAR *old_dirname, const CHAR *new_dirname);
UINT32  zOss_GetPwd(CHAR *dirname, UINT32 dirnamelen);
UINT32  zOss_ChDir(CHAR *dirname);
BOOL    zOss_IsDir(const CHAR *dirname);
UINT32  zOss_OpenDir(const CHAR *dirname, VOID **dir_entry_ptr);
UINT32  zOss_CloseDir(VOID **dir_entry_ptr);
UINT32  zOss_ReadDir(VOID **dir_entry_ptr, ZOSS_S_DIRENT *dir_item_ptr);
VOID    zOss_Rewinddir(VOID *dir_entry_ptr);
UINT32  zOss_ChMod(const CHAR *pathname, mode_t attrs);
UINT32  zOss_Stat(const CHAR *pathname, ZOSS_S_STAT *buf);
UINT32  zOss_MountDisk(CHAR diskname);
UINT32  zOss_UnMountDisk(CHAR diskname);
UINT32  zOss_UnMountAllDisk(VOID);
UINT32  zOss_GetDiskFreeSpace(CHAR diskname, UINT64 *space);
UINT32  zOss_GetDiskCapacity(CHAR diskname, UINT64 *space);
UINT32  zOss_GetAllDynamicDisk(CHAR *disk, UINT32 size);
UINT32  zOss_SyncFS(VOID);
UINT32  zOss_MountDynamicDisk(CHAR *pWinDir, CHAR *pLinuxDir, CHAR *pDevName, char *pFsName);
UINT32  zOss_UnMountDynamicDisk(CHAR *pWinDir);
UINT32  zOss_FsMount(VOID);

/**************************************************************************
* ȫֱ
**************************************************************************/

#ifdef __cplusplus
}
#endif

#endif  /* _OSS_FS_H    */

