#ifndef ZTE_DISPLAY
#define ZTE_DISPLAY

//#include "..\..\gal\multimedia.h"
#include    "pub.h"

#define  ZTE_AUDIO	   2	/* audio  drv */
#define  ZTE_CAMERA    6	/* camera drv */
#define  ZTE_VIDEO_DEV 28	/* video  drv */


#define  VIDEO_MAX_PATH_LEN     1024

/*----------------------DC----------------------*/

typedef enum
{
    DCAMERA_OP_SUCCESS,
    DCAMERA_OP_ERROR,
}DCAMERA_RETURN_VALUE_E;

typedef enum
{
    LCD_MAIN = 0,
    LCD_SUB
}LCD_ID_E;

typedef enum
{
    DCAMERA_SENSOR_MAIN = 0,
    DCAMERA_SENSOR_SUB
}DCAMERA_SENSOR_E;


typedef enum
{
    EFFECT_NORMAL_VIDEO,
    EFFECT_B_AND_W_VIDEO,
    EFFECT_SEPIA_VIDEO,
    EFFECT_NEGA_VIDEO,
    EFFECT_EMBOSS_VIDEO
}EFFECT_TYPE_E;

typedef enum
{
    ZOOM_LEVEL_ONE = 0,
    ZOOM_LEVEL_TWO,
    ZOOM_LEVEL_THREE,
    ZOOM_LEVEL_FOUR,
    ZOOM_LEVEL_FIVE
}ZOOM_LEVEL_E;

typedef enum
{
    ROTATE_0,
    ROTATE_90,
    ROTATE_180,
    ROTATE_270,
    ROTATE_MAX
} DROTATION_MODE_E;

typedef enum
{
    BRITENESS_LEVEL_ONE = 0,
    BRITENESS_LEVEL_TWO,
    BRITENESS_LEVEL_THREE,
    BRITENESS_LEVEL_FOUR,
    BRITENESS_LEVEL_FIVE
}BRITENESS_E;

typedef enum
{
    CONTRAST_LEVEL_ONE = 0,
    CONTRAST_LEVEL_TWO,
    CONTRAST_LEVEL_THREE,
    CONTRAST_LEVEL_FOUR,
    CONTRAST_LEVEL_FIVE
}CONTRAST_E;

typedef enum
{
    CAPTURE_MODE_NIGHT = 0,
    CAPTURE_MODE_NORMAL
}CAPTURE_MODE_E;

typedef enum
{
    RESOLUTION_320X240 = 0,
    RESOLUTION_640X480,
    RESOLUTION_1280X960,
    RESOLUTION_1600X1200,
    RESOLUTION_70X70
}RESOLUTION_MODE_E;

typedef enum
{
    QUALITY_LOW = 0,
    QUALITY_NORMAL,
    QUALITY_HIGHT
}QUALITY_MODE_E;

typedef enum
{
    WHITEBALANCE_AUTO = 0,
    WHITEBALANCE_DAYLIGHT,
    WHITEBALANCE_CLOUDY,
    WHITEBALANCE_INCANDESCENCE,
    WHITEBALANCE_FLUORESCENCE
}WHITEBALANCE_MODE_E;

typedef enum {
    APP_PREVIEW_CAM = 0,
	APP_PREVIEW_VID
}APP_PREVIEW_E;

typedef struct
{
	UINT32 sx;
	UINT32 sy;
	UINT32 width;
	UINT32 height;
}RECT_T;

typedef struct
{
    UINT32  width;
    UINT32  height;
}DISPLAY_SIZE_T;

typedef struct
{
    BOOL                    hMirror;
	BOOL                    vMirror;
}MIRROR_PARAM_T;

typedef struct
{
	LCD_ID_E  			   lcd_id;
    APP_PREVIEW_E          previewtype;
	DCAMERA_SENSOR_E       sensor;
	RECT_T		           disp_rect;		 // ʾ
	EFFECT_TYPE_E          effect;           // Ч
	ZOOM_LEVEL_E           zoomlevel;        // ˮƽ
	DROTATION_MODE_E	   rotation_mode;	 // תǶ	
	BRITENESS_E            brightness;       // 
	CONTRAST_E             contrastness;     // Աȶ
	CAPTURE_MODE_E         mode;             // ģʽ
	RESOLUTION_MODE_E      resolution;       // ֱ
	QUALITY_MODE_E         quality;          // 
	WHITEBALANCE_MODE_E    whitebalance;     // ƽ
	MIRROR_PARAM_T         mirror;           // 
}PREVIEW_PARAM_T;

typedef struct
{
   UINT8                 *data_buffer;
   UINT32                 data_length;
   CHAR                  *data_display_ptr;  //LCDʾbufferָ
   BOOL	                  flash_enable;		//Ƿ	
}SNAPSHOT_PARAM_T;

typedef struct
{
    UINT8                 *data_buffer;
    UINT32                 data_length;
    CHAR                  *data_display_ptr;  //LCDʾbufferָ
    RECT_T  		       display_rect;	   // ʾƬ
    DROTATION_MODE_E	   rotation_mode;	   // תǶ	
}REVIEW_PARAM_T;

typedef struct
{	
   UINT8                 *buf_ptr;          //ָ
   UINT16                 color;	         //͸ɫ                      
}FRAME_PARAM_T;

/*----------------------DV----------------------*/

typedef enum
{
	VIDEO_MIC = 1,
	VIDEO_HEADSET	
}VIDEO_CODEC_PATH;

typedef enum
{
	FILE_3GP,
	FILE_MP4
}VIDEO_FILE_TYPE;

typedef enum
{
	ZTE_DV_TYPE,
	ZTE_VIDEO_TYPE,
	ZTE_STREAM_TYPE,
	ZTE_VT_TYPE
}DV_APP_TYPE;

typedef struct
{	
    CHAR				      *savefile_path;		 
    VIDEO_CODEC_PATH           codec_path;
    RECT_T 					   rec_rect;
    MIRROR_PARAM_T             mirror;
    DROTATION_MODE_E           rotate;
    QUALITY_MODE_E             quality; 
    UINT32					   maxStreamSize;
    BOOL				       audioenable;
    EFFECT_TYPE_E              effect;
    VIDEO_FILE_TYPE			   filetype;
}DV_RECORD_START_PARAM_T;

/*------------------------------VIDEO-------------------------------------*/
typedef enum
{
    VIDEO_FILE_TYPE_MP4,
    VIDEO_FILE_TYPE_3GP,
    VIDEO_FILE_TYPE_K3G,
    VIDEO_FILE_TYPE_UNKNOWN
} VIDEO_BUFFER_FILE_TYPE_E;

typedef enum
{
    CHANNEL_OUT_RECEIVER = 1,      /*Ͳ*/
    CHANNEL_OUT_SPEAKER ,          /*speaker*/		 
    CHANNEL_OUT_EARPHONE,          /**/
    CHANNEL_OUT_SPEAKER_EARPHONE,  /* + Speakerͬʱ*/
    CHANNEL_OUT_BLUETOOTH
}VIDEO_CHANNEL_OUT_TYPE_E;

typedef enum
{
    VIDEO_VOLUME_LEVEL_0,
    VIDEO_VOLUME_LEVEL_1,
    VIDEO_VOLUME_LEVEL_2,
    VIDEO_VOLUME_LEVEL_3,
    VIDEO_VOLUME_LEVEL_4,
    VIDEO_VOLUME_LEVEL_5
}VIDEO_VOLUME_LEVEL_E;

typedef enum
{
    VIDEO_SEEK_FROM_CUR,    /*ӵǰλseek*/
    VIDEO_SEEK_FROM_BEGIN   /*ӿʼSeek*/
}VIDEO_PLAY_SEEK_MODE;

typedef enum
{
    VIDEO_PLAY_STATE_IDLE,   /* ״̬               */
    VIDEO_PLAY_STATE_OPEN,   /* Ѿ             */
    VIDEO_PLAY_STATE_READY,  /* Ѿʼ(ֹͣ״̬) */ 
    VIDEO_PLAY_STATE_PLAY,   /*                */
    VIDEO_PLAY_STATE_PAUSE,  /* ͣ״̬             */
}VIDEO_PLAY_STATE;


typedef struct
{	
    char				            filepath[VIDEO_MAX_PATH_LEN+1];  /*ƵԴ·*/
    RECT_T 					        play_rect;
    DROTATION_MODE_E                rotate;                
    VIDEO_CHANNEL_OUT_TYPE_E        channel;
    VIDEO_VOLUME_LEVEL_E            volume;
    VIDEO_PLAY_STATE                curstate;
    UINT8                          *videoBuf;		                 /* ָƵbufferݵָ */
    UINT32                          videoBuffSize;                   /* ƵbufferĴС */
    VIDEO_BUFFER_FILE_TYPE_E        videotype; 		                 /* Ƶ */
}VIDEO_PLAY_PARAM_T;

typedef struct
{
    UINT32                         pos;
    VIDEO_PLAY_SEEK_MODE           seekmode;
}VIDEO_PLAY_SEEK_T; 

typedef struct
{   
    UINT32          dwTotalTime;
    DISPLAY_SIZE_T  tsize;              
    UINT32          dwOnlyHaveAudio;
}VIDEO_PLAY_INFO;

/*-----------------------------------STREAM----------------------------------*/

typedef struct
{
    UINT8                 *data_buffer;
    UINT32                 data_length;
}STREAM_DATA;

typedef struct
{
	RECT_T                 play_rect;
	DROTATION_MODE_E       rotate;
}STREAM_SET_PARAM;

/*------------------------------------OSD----------------------------------------*/
typedef enum
{
   OSD_DC_PREVIEW,
   OSD_DC_REVIEW,
   OSD_DV_RECORD,
   OSD_DV_PAUSE,
   OSD_DV_STOP,
   OSD_VIDEO_PLAY,
   OSD_VIDEO_PAUSE,
   OSD_VIDEO_STOP,
   OSD_STREAM_DECODE
}OSD_APP_TYPE;

typedef struct
{
	UINT8                 *data_buffer;
	RECT_T                 osdrect;
	RECT_T                 playrect;
}OSD_DISPLAY_T;

#endif
