/**************************************************************************
*
*                  Copyright (c) 2012 ZTE Corporation.
*
***************************************************************************
* ģ   : P98C_OSS
*    : sysmgt.c
* ļ : 
* ʵֹ : OSS
*      : xiaxinguo
*      : V1.0
*  : 2007-07-16
* ˵ : 
**************************************************************************/

/**************************************************************************
* ޸ļ¼
**************************************************************************/
/**************************************************************************
* ޸ı : 0001
*    : chenxingfang
* ޸ : 2012-09-17
* ޸ : ʽ淶PC-LINT߲ EC:617001782014
**************************************************************************/
/**************************************************************************
* ޸ı : 0002
*    : chenxingfang
* ޸ : 2012-09-27
* ޸ : ߲ EC:617001782003
**************************************************************************/

/**************************************************************************
* #include
**************************************************************************/
#include "oss_api.h"
#include "sup.h"
#include "drv_api.h"
#include "ThreadPriority.h"
#include "osa_ramdump.h"
#include "sup_task.h"

#ifdef __cplusplus
extern "C"
{
#endif

/**************************************************************************
* 궨
**************************************************************************/
#define SYSM_STATUS_STARTTASK   (ZOSS_STATUS_USERBASE + 1)
#define SYSM_TASK_NAME          "zOss_SysmTask"

/**************************************************************************
* ݽṹ
**************************************************************************/
typedef struct
{
    T_ZOss_TaskTabItem *curreatpTaskItem;
}T_P_DATA;

/**************************************************************************
* ֲԭ
**************************************************************************/
static VOID Sysm_MainProc(UINT8 state, UINT32 msgId, UINT8 *pBuf, UINT16 msgLen, UINT8 *private_data);
static UINT32 Sysm_PoweronTasks(VOID);
static UINT32 Sysm_InitTasks(T_ZOss_TaskTabItem *pTaskItem, UINT32 task_index); 

/**************************************************************************
* ȫֳ/
**************************************************************************/
ZOSS_TASK_ID                gSysm_SysMTaskID        = ZOSS_INVALID_TASK_ID;
static UINT32               gSysm_AckTaskIndex      = 0;
static BOOL                 bInit                   = FALSE;
static T_ZOss_TaskTabItem   *gSysm_TaskTab          = NULL;
ZOSS_TASK_ID                *gSysm_TaskIDTab        = NULL;
static UINT32               gSche_Max_TaskTab_Num   = 0;

/**************************************************************************
* ⲿ
**************************************************************************/
#ifdef _OS_OSE
extern UINT32 SYSTIME_Init(VOID);
#endif

#ifdef _OS_LINUX
extern void zx29_restart(char str, const char *cmd);
#endif

#ifdef _USE_WBT
extern VOID zWbt_Entry(VOID);
#endif

/**************************************************************************
* ȫֺʵ
**************************************************************************/
/**************************************************************************
* ƣzOss_Init
* OSSϵͳʼ
* ˵(IN)
            (OUT)
*   ֵɹZOSS_SUCCESS,򷵻ZOSS_ERROR
* ˵
**************************************************************************/
UINT32 zOss_Init(VOID)
{
    T_OSS_PARAM *pPlatCfg   = NULL;
    UINT32      nRet        = ZOSS_SUCCESS;
    
    if (bInit == TRUE)             /* Ƿѳʼ */
    {
        return ZOSS_SUCCESS;
    }

    /* oss cfg fs mount*/
#ifdef _OS_TOS
    nRet = zOss_FsMount();
    if (nRet != ZOSS_SUCCESS)
    {
        zOss_RamLog((CHAR *)"SysEntry: zOss_FsMount Fail, Code=%d!", nRet);
        return ZOSS_ERROR;
    }
#endif

    /* Timer Init */
#ifdef _OS_WIN
    nRet = TIMER_Init();
    if (nRet != ZOSS_SUCCESS)
    {
        zOss_RamLog((CHAR *)"SysEntry: TIMER_Init Fail, Code=%d!", nRet);
        return ZOSS_ERROR;
    }
    zOss_RamLog((CHAR *)"SysEntry(%d): TIMER_Init Start OK!", zOss_GetTickCount());
#endif
    
#if 0
    /* NV Init */
    #ifndef _USE_SMALL_VERSION
    nRet = NV_Init();
    if (nRet != ZOSS_SUCCESS)
    {
        zOss_RamLog((CHAR *)"SysEntry: NV_Init Fail, Code=%d!", nRet);
        return ZOSS_ERROR;
    }
    zOss_RamLog((CHAR *)"SysEntry(%d): NV_Init Start OK!", zOss_GetTickCount());
    #endif
#endif
    /*  */
    pPlatCfg = zOss_GetOssCfg();
    gSysm_TaskTab = pPlatCfg->SysmCfg.pSysm_TaskItemTab;
    gSche_Max_TaskTab_Num = pPlatCfg->SysmCfg.task_num;
    if (gSche_Max_TaskTab_Num > pPlatCfg->TaskCfg.max_task_num)
    {
        return ZOSS_ERROR;
    }
    if (gSche_Max_TaskTab_Num != 0)
    {
        gSysm_TaskIDTab = (ZOSS_TASK_ID *)zOss_Malloc(sizeof(ZOSS_TASK_ID) * gSche_Max_TaskTab_Num);
        if (gSysm_TaskIDTab == NULL)
        {
            return ZOSS_ERROR;
        }
        zOss_Memset((UINT8 *)gSysm_TaskIDTab, 0, sizeof(ZOSS_TASK_ID) * gSche_Max_TaskTab_Num);
    }
    
    /* ʼOSSģ飬Ⱥ򲻵ø */
    /* ʼSche */
    nRet = SCHE_Init();
    if (nRet == ZOSS_ERROR)
    {
        return ZOSS_ERROR;
    }
    /* ʼExcept */
    nRet = EXCEP_Init();
    if (nRet == ZOSS_ERROR)
    {
        return ZOSS_ERROR;
    }
    /* ʼtest */
#ifdef ZOSS_TEST_MODE
    nRet = TEST_Init();
    if (nRet == ZOSS_ERROR)
    {
        return ZOSS_ERROR;
    }
#endif
#ifdef _USE_PSM
    /* ʡʼ */
#ifdef _USE_PSM_NEW_FRAMEWORK
    nRet = zOss_PsmInit();
#else
    nRet = PSM_Init();
#endif
    if (nRet == ZOSS_ERROR)
    {
        return ZOSS_ERROR;
    }    
#endif

#ifdef _OS_WIN
    FS_Init();
#endif

#ifdef _OS_OSE
    nRet = SYSTIME_Init();
    if (nRet == ZOSS_ERROR)
    {
        return ZOSS_ERROR;
    }
#endif

#ifdef _USE_WBT
    zWbt_Entry();
#endif

    /* Ramdump Init */   
    zOss_RamdumpInit();

    bInit = TRUE;
    return ZOSS_SUCCESS;
}

/**************************************************************************
* ƣzOss_Start
* OSS
* ˵(IN)
            (OUT)
*   ֵɹZOSS_SUCCESS,򷵻ZOSS_ERROR
* ˵
**************************************************************************/
UINT32 zOss_Start(VOID)
{
    /* ϵͳ */
    ZOSS_TASK_ID taskId = zOss_CreateTask(SYSM_TASK_NAME, Sysm_MainProc, 2 * 1024, THR_SYSM_PRI, 1024, 0);
    if (ZOSS_INVALID_TASK_ID == taskId)
    {
        return ZOSS_ERROR;    
    }
    
    gSysm_SysMTaskID = taskId;
    return zOss_TaskSend(EV_POWERON, NULL, 0, taskId); /* ϵϢ */
}

/**************************************************************************
* ƣzOss_TaskStartOK
* Ӧ, ڴEVENT_INIT, ñ
            ֪ͨǼǱ.
* ˵(IN)
            (OUT)
*   ֵ
* ˵
**************************************************************************/
VOID zOss_TaskStartOK(VOID)
{
    UINT32 nRet = ZOSS_SUCCESS;
    
    if (ZOSS_INVALID_TASK_ID == gSysm_SysMTaskID)
    {
        gSysm_SysMTaskID = zOss_GetTaskID(SYSM_TASK_NAME);  /* ȡID */
    
        zOss_AssertExN(ZOSS_INVALID_TASK_ID != gSysm_SysMTaskID);
    }
    nRet = zOss_TaskSend(EV_POWERON_OK, NULL, 0, gSysm_SysMTaskID);

    zOss_ASSERT(nRet != ZOSS_ERROR);
}

/**************************************************************************
* ƣzOss_SysPowerdown
* ػ
* ˵(IN)
            (OUT)
*   ֵɹZOSS_SUCCESS,ʧܷZOSS_ERROR
* ˵
**************************************************************************/
UINT32 zOss_SysPowerdown(VOID)
{
    zOss_NvramFlush();
#ifdef _USE_OSS_FS
    zOss_SyncFS();
#endif
    zDrv_ShutDown();
    
    return ZOSS_SUCCESS;
}

/**************************************************************************
* ƣzOss_SysSoftReset
* 
* ˵(IN)
            (OUT)
*   ֵ
* ˵
**************************************************************************/
VOID zOss_SysSoftReset(T_ZOssSys_RESET_TYPE type)
{
    if (SYS_RESET_TO_EXCEPTRESET != type)
    {
        zOss_NvramFlush();
#ifdef _USE_OSS_FS
        zOss_SyncFS();
#endif
    }

#ifdef _OS_LINUX
    switch(type)
    {
        case SYS_RESET_TO_CHARGER:
            zx29_restart(0, "drv_key reboot");
            break;
        case SYS_RESET_TO_ALRAM:
            zx29_restart(0, "mmi_rtc reboot");
            break;
        case SYS_RESET_TO_EXCEPTRESET:
            zx29_restart(0, "drv_except reboot");
            break;			
        case SYS_RESET_TO_NORMAL:
        default:
            zx29_restart(0, NULL);
    }
#else
    switch(type)
    {
        case SYS_RESET_TO_NORMAL:
            zDrv_Soft_Reset(RESET_TO_NORMAL);
            break;
        case SYS_RESET_TO_CHARGER:
            zDrv_Soft_Reset(RESET_TO_CHARGER);
            break;
        case SYS_RESET_TO_ALRAM:
            zDrv_Soft_Reset(RESET_TO_ALRAM);
            break;
        case SYS_RESET_TO_EXCEPTRESET:
            zDrv_Soft_Reset(RESET_TO_EXCEPTRESET);
            break;
        default:
            zDrv_Soft_Reset(RESET_TO_NORMAL);
            break;
    }
#endif
}

/**************************************************************************
* ֲʵ
**************************************************************************/
/**************************************************************************
* ƣSysm_MainProc
* ƽ̨Эջ
* ˵(IN)
            state:״̬
            msgId:ϢID
            pBuf:Ϣ
            msgLen:Ϣ
            pPrivateData:˽
            (OUT)
*   ֵ
* ˵ѡ
**************************************************************************/
static VOID Sysm_MainProc(UINT8 state, UINT32 msgId, UINT8 *pBuf, UINT16 msgLen, UINT8 *pPrivateData)
{
    UINT32      task_index  = 0;
    UINT32      nRet        = 0;
    T_P_DATA    *ptPData    = NULL;
    
    ptPData = (T_P_DATA *)pPrivateData;
    switch (state)
    {
    case ZOSS_STATUS_INIT:
        {
            switch (msgId)
            {
            case EV_INIT:
                {
                    break;
                }
            case EV_POWERON:
                {
                    /*  */
                    ptPData->curreatpTaskItem = gSysm_TaskTab;
                    task_index = 0;
                    task_index = Sysm_InitTasks(ptPData->curreatpTaskItem, task_index);
                    if (gSche_Max_TaskTab_Num == task_index)
                    {
                        /* ȫ */
                        nRet = Sysm_PoweronTasks();
                        zOss_AssertExN(ZOSS_ERROR != nRet);
            
                        zOss_SetState(ZOSS_STATUS_WORK);
                    }
                    else if (gSche_Max_TaskTab_Num < task_index)
                    {
                        zOss_ASSERT(0);/*  */
                    }
                    else
                    {
                        zOss_SetState(SYSM_STATUS_STARTTASK);
                    }
                    break;
                }
            default:
                {
                    zOss_Printf(SUBMDL_SYSM, PRINT_LEVEL_DEBUG, "Sysm_MainProc > Recv unknown msgid=%d\n", msgId);
                    break;
                }
            }
            break;
        }
        
    case SYSM_STATUS_STARTTASK:
        {
            switch (msgId)
            {
            case EV_POWERON_OK:
                {
                    task_index = Sysm_InitTasks(ptPData->curreatpTaskItem, gSysm_AckTaskIndex + 1);
                    if (gSche_Max_TaskTab_Num == task_index)
                    {
                        /* ȫ */
                        nRet = Sysm_PoweronTasks();
                        if (ZOSS_SUCCESS == nRet)
                        {
                            zOss_Printf(SUBMDL_SYSM, PRINT_LEVEL_DEBUG, "Poweron All Task OK!!!\n");
                        }
                        else
                        {
                            zOss_Printf(SUBMDL_SYSM, PRINT_LEVEL_DEBUG, "Poweron Task Fail!!!\n");
                        }
                        zOss_SetState(ZOSS_STATUS_WORK);
                    }
                    else if (gSche_Max_TaskTab_Num < task_index)
                    {
                        /*  */
                    }
                    
                    break;
                }
            case EV_SYSM_DOWN:
                {
                    zOss_Printf(SUBMDL_SYSM, PRINT_LEVEL_DEBUG, "System Down!!!\n");
                    Nvram_Finish();
                    zOss_Sleep(500);
                    zDrv_ShutDown();
                    break;
                }
            default:
                {
                    zOss_Printf(SUBMDL_SYSM, PRINT_LEVEL_DEBUG, "Sysm_MainProc > Recv unknown msgid=%d\n", msgId);
                    break;
                }
            }
            break;
        }
        
    case ZOSS_STATUS_WORK:
        {
            switch (msgId)
            {
            case EV_SYSM_DOWN:
                {
                    zOss_Printf(SUBMDL_SYSM, PRINT_LEVEL_DEBUG, "System Down!!!\n");
                    Nvram_Finish();
                    zOss_Sleep(500);
                    zDrv_ShutDown();
                    break;
                }
            default:
                {
                    zOss_Printf(SUBMDL_SYSM, PRINT_LEVEL_DEBUG, "Sysm_MainProc > Recv unknown msgid=%d\n", msgId);
                    break;
                }
            }
            break;
        }
        
    default:
        {
            zOss_Printf(SUBMDL_SYSM, PRINT_LEVEL_DEBUG, "Sysm_MainProc: recv unknown msgid=%d\n", msgId);
            break;
        }
    }
}

/**************************************************************************
* ƣSysm_PoweronTasks
* עе
* ˵(IN)
            (OUT)
*   ֵɹZOSS_SUCCESS,򷵻ZOSS_ERROR
* ˵ѡ
**************************************************************************/
static UINT32 Sysm_PoweronTasks(VOID)
{
    UINT32 task_index   = 0;
    UINT32 nRet         = ZOSS_SUCCESS;
    
    for ( ; task_index < gTask_TaskNum; task_index++)
    {
        nRet = zOss_GetSemaphore(gSche_SaticTaskInitSema, ZOSS_WAIT_FOREVER);
        if (nRet != ZOSS_SUCCESS)
        {
            return ZOSS_ERROR;
        }
    }
    
    nRet = zOss_DeleteSemaphore(gSche_SaticTaskInitSema);
    
    if (nRet != ZOSS_SUCCESS)
    {
        return ZOSS_ERROR;
    }
    
    for ( task_index = 0; task_index < gSche_Max_TaskTab_Num; task_index++)
    {
        if (NULL != gSysm_TaskIDTab[task_index])
        {
            nRet = zOss_TaskSend(EV_POWERON, NULL, 0, gSysm_TaskIDTab[task_index]);
            if (ZOSS_ERROR == nRet)
            {
                zOss_Printf(SUBMDL_SYSM, PRINT_LEVEL_DEBUG, "Fail!\n");
                return nRet;
            }
        }
    }
    
    return nRet;
}

/**************************************************************************
* ƣSysm_InitTasks
* עе
* ˵(IN)
            pTaskItem:ע
            task_index:ע
            (OUT)
*   ֵɹǸ¸к,򷵻ZOSS_ERROR
* ˵ѡ
**************************************************************************/
static UINT32 Sysm_InitTasks(T_ZOss_TaskTabItem *pTaskItem, UINT32 task_index)
{
    UINT32 nRet = ZOSS_ERROR;
    
    zOss_AssertEx(pTaskItem != NULL && task_index <= gSche_Max_TaskTab_Num, ZOSS_ERROR);
    
    pTaskItem = pTaskItem + task_index;
    
    for ( ; task_index < gSche_Max_TaskTab_Num; task_index++)
    {
        if (1 == pTaskItem->is_use)
        {
            zOss_Printf(SUBMDL_SYSM, PRINT_LEVEL_DEBUG, "[%d]Start Task %s ", task_index, pTaskItem->task_name);
            
            /* ͳʼϢ */
            nRet = zOss_TaskSend(EV_INIT, NULL, 0, gSysm_TaskIDTab[task_index]);
            
            if (nRet == ZOSS_ERROR)
            {
                zOss_Printf(SUBMDL_SYSM, PRINT_LEVEL_DEBUG, "Fail!\n");
                return ZOSS_ERROR;
            }
            else
            {
                zOss_Printf(SUBMDL_SYSM, PRINT_LEVEL_DEBUG, "OK!\n");
            }
            
            if (1 == pTaskItem->ack_flag)
            {
                gSysm_AckTaskIndex = task_index;
                zOss_Printf(SUBMDL_SYSM, PRINT_LEVEL_DEBUG, "Wait Ack!!!\n");
                return task_index;
            }
        }
        
        pTaskItem++;
    }

    return task_index;
}

#ifdef __cplusplus
}
#endif

