/**
 * 
 * @file      log_agent.h
 * @brief     
 *            This file is part of ZCAT.
 *            zcatӦòlog_agent appͷļ
 *            
 * @details   
 * @author    Tools Team.
 * @email     
 * @copyright Copyright (C) 2013 Sanechips Technology Co., Ltd.
 * @warning   
 * @date      2019/02/02
 * @version   1.1
 * @pre       
 * @post      
 *            
 * @par       
 * Change History :
 * ---------------------------------------------------------------------------
 * date        version  author         description
 * ---------------------------------------------------------------------------
 * 2017/07/17  1.0      hou.bing       Create file
 * 2019/02/02  1.1      jiang.fenglin  ޸עͷʽΪdoxygen
 * 2019/07/08  1.2      jiang.fenglin  APFS/CPFSģʽ
 * ---------------------------------------------------------------------------
 * 
 * 
 */


#ifndef ZTE_LOG_AP_AGENT_H_
#define ZTE_LOG_AP_AGENT_H_

#include <unistd.h>
#include <stdlib.h>
#include <stdio.h>
#include <errno.h>
#include <sys/socket.h>
#include <fcntl.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <dirent.h>

//#include "../include/message.h"
//#include "../include/zte_log.h"


/********************************************
* receive result
********************************************/

#define RAMDUMP_RECEIVE_RESULT_SYS_CRASH 0x0010 

/********************************************
* verify result
********************************************/
#define KERNEL_LOG_DEFAULT_LEVEL LEVEL_INFOMATION
#define APP_LOG_DEFAULT_LEVEL    LEVEL_INFOMATION

#define AP_LOG_MAX_LENGTH   260
#define READ_BUFFER_SIZE    (1024 * 16)
#define MAX_DATA_LEN 2048

#define TRUE  1
#define FALSE 0

/* ͨѶģ */
#define MDL_TOOLS_BASE            (100)
#define SUBMDL_TOOLAGENT_SET      (85)
#define MDL_ZCAT                  (MDL_TOOLS_BASE + 15)      /* ZCAT     */
#define SUBMDL_ZCATAGT            (SUBMDL_TOOLAGENT_SET + 0) /* ZCATߴ */

#define MDL_PHONE                 (1)                        /* ֻ         */

/* ־־ */
#define DIR_LOG_TCARD_VALUE 0x01
#define DIR_LOG_NET_VALUE   0x02
#define DIR_LOG_USB_VALUE   0x03
#define DIR_LOG_USB_AP_VALUE   0x04

#define MAX_STRING_LENGTH    256
typedef int BOOL;
typedef void VOID;

typedef signed char         SINT8;  /* sc */
typedef unsigned char       UINT8;  /* c */

typedef short               SINT16; /* sw */
typedef unsigned short      UINT16; /* w */
typedef long                SINT32; /* sdw */
typedef unsigned int        UINT32; /* dw */
typedef unsigned long long  UINT64;

typedef struct
{
    unsigned char *buf;
    unsigned int bufIndex; // ָƫ
    unsigned int bufSize;
} T_HDLC_BUFFER_TYPE;

typedef enum
{
    LEVEL_EMERGENCY = 0,    // ڽ¼Ϣһϵͳ֮ǰʾϢ
    LEVEL_ALERT,            // Ҫȡ
    LEVEL_CRITICAL,         // ٽ״̬ͨ漰صӲʧ
    LEVEL_ERROR,            // ڱ״̬豸򾭳Ӳ
    LEVEL_WARNING,          // Կܳо棬ͨϵͳ
    LEVEL_NOTICE,           // бҪʾΣ밲ȫص״㱨
    LEVEL_INFOMATION,       // ʾϢʱӡҵӲϢ
    LEVEL_DEBUG,            // ڵϢ
    LEVEL_PRICNT
} E_ZCAT_AP_PRIORITY;

//AP Header ṹ
typedef struct
{
    unsigned char priority;
    unsigned char mod;
    unsigned short len;
} T_ZCAT_APLOG_HEADER;
typedef struct
{
    unsigned char *buf;
    unsigned short len;
    unsigned short newLine;
} T_AP_DEST_BUFFER_TYPE;

typedef struct
{
    unsigned char *buf;
    unsigned int beginIndex;
    unsigned int bufSize;
} T_AP_SRC_BUFFER_TYPE;

// ZCAT Headerṹ
typedef struct
{
    unsigned char   cmd_code;
    unsigned char   padding;
    unsigned short  reserved;
    unsigned int  length;
    unsigned int  timeStamp[2];
} T_ZCAT_HEADER;

//DIAG Header ṹ
typedef struct
{
    unsigned short diag_id;
    unsigned short len;
} T_ZCAT_DIAG_HEADER;

typedef struct
{
    UINT16 type;
    UINT8  operation;
    UINT8  reserved;
} T_ZCAT_DIAG_CONFIG_REQ;

typedef enum
{
    ZCAT_SIG_REPORT    = 1,
    ZCAT_EVT_REPORT    = 2,
    ZCAT_PRN_REPORT    = 3,
    ZCAT_DBG_REPORT    = 4,
    ZCAT_IPPPP_REPORT  = 5,
    ZCAT_DIAG_REPORT   = 6,
    ZCAT_DIAG_NULL,   //ֻռһλʹãʹPC

    ZCAT_AP_KERNEL_LOG = 8,
    ZCAT_AP_APP_LOG    = 9,

    ZCAT_CMDCODE_MAX
} T_ZCAT_CMDCODE;

typedef enum 
{
    ZCAT_SIG_TYPE               = ZCAT_SIG_REPORT,
    ZCAT_EVENT_TYPE             = ZCAT_EVT_REPORT,
    ZCAT_PRINT_TYPE             = ZCAT_PRN_REPORT,
    ZCAT_DBG_TYPE               = ZCAT_DBG_REPORT,
    ZCAT_IPPPP_TYPE             = ZCAT_IPPPP_REPORT,
    ZCAT_DIAG_TYPE              = ZCAT_DIAG_REPORT, 
    ZCAT_AP_KERNEL_TYPE         = ZCAT_AP_KERNEL_LOG,
    ZCAT_AP_APP_TYPE            = ZCAT_AP_APP_LOG,

    ZCAT_ALL_TYPE               = 0xFFFF
} ZCAT_ENUM_TYPE;

// Commṹ
typedef struct
{
    unsigned char  msg_type;                   /* Ϣ */
    unsigned char  pad;                        /* λ */
    unsigned short reserved;                   /* ֶΣΪ0xAAAA */
    unsigned char  tgt_mdl_no;                 /* Ŀ(Ϣ)ģģ */
    unsigned char  tgt_submdl_no;              /* Ŀ(Ϣ)ģģ */
    unsigned char  src_mdl_no;                 /* Դ(Ϣ)ģģ */
    unsigned char  src_submdl_no;              /* Դ(Ϣ)ģģ */
    unsigned int buf_len;                      /* Ϣݳ(Ϣͷ) */
} T_COMM_TYPE;

typedef enum
{
    ZCAT_STATE_INIT = 0,
    ZCAT_STATE_RUNNING,
    ZCAT_STATE_STOP,
    ZCAT_STATE_EXIT
} E_ZCAT_STATE;

typedef enum
{
    ZCAT_MODE_AP_USB = 0xC1,
    ZCAT_MODE_AP_NET,
    ZCAT_MODE_AP_TF,
    ZCAT_MODE_AP_FS,
    ZCAT_MODE_CP_USB,
    ZCAT_MODE_CP_TF,
    ZCAT_MODE_CP_NET,
    ZCAT_MODE_CP_FS,
#ifdef USE_CAP_SUPPORT
    ZCAT_MODE_CAP_FS,
    ZCAT_MODE_CAP_NET,
#endif
    ZCAT_MODE_LOG_OFF,
} E_ZCAT_MODE;

typedef enum
{
    ZCAT_IPC_SYN = 0xA0,
    ZCAT_IPC_ACK,
    ZCAT_IPC_ESTABLISHED,
    ZCAT_IPC_SET_TTY,
    ZCAT_IPC_SET_PERIPHERAL_MODE,
    ZCAT_IPC_STOP,
    ZCAT_IPC_START,
    ZCAT_IPC_EXIT, 
#ifdef USE_CAP_SUPPORT
    ZCAT_IPC_ALLOC_CAP_SMLOGBUF,
#endif
    ZCAT_IPC_READ_IRAM_ZCAT_MODE,
    ZCAT_IPC_SET_VEHICLE_WAKE_SIGN,
} E_ZCAT_IPC_HANDSHAKE;


typedef enum
{
    FLASH_MODE_NOMAL = 1,
    FLASH_MODE_U = 2
} E_FLASH_MODE;

typedef enum
{
    DIAG_FILTER_CONFIG = 1,
    DIAG_DROP_COUNT,
    DIAG_LINK_MSG,
    DIAG_SIG_CONTROL_MSG,
    DIAG_NV_MSG,
    DIAG_LTE_CONTROL_MSG,
    DIAG_PS_GLB_MSG,
    DIAG_PS_FILTERRANK_MSG,
    DIAG_UE_MEM_LOOKUP,
    DIAG_RAMDUMP_MSG,
    DIAG_TSPVERSION_MSG,
    DIAG_SYSVIEW_MSG,
    DIAG_CP_STATUS
}DIAG_CONDITION;


/*־T*/
typedef struct
{
    char log_dir[MAX_STRING_LENGTH];
    char log_name[MAX_STRING_LENGTH];
    char rule_path[MAX_STRING_LENGTH];
    int max_file_size;
    int max_file_num;  
    int log_overwrite;
    int compress_log_files;
    int file_counts;
    int output_fd;
    int file_size;
    int free_space_limit;
    UINT64 max_total_size; 
}T_LOG_SDCARD_PARA;

#endif /* ZTE_LOG_AP_AGENT_H_ */
