/*********************************************************************************
** Copyright @ Fibocom Technologies Co., Ltd. 2023-2030. All rights reserved.
** File name: fibo_vsim_api.h 
** Author: GaoZeng
** Version: V1.0.0
** Date: 2023.02.14
** Description: This file provides the declaration Vsim-related APIs and structs.
** Others: 
***********************************************************************************/
#ifndef __GHT_VSIM_API_H__
#define __GHT_VSIM_API_H__

#include "stdio.h"
#include "stdint.h"
#include "stdlib.h"
#include "string.h"
#include "ght_error.h"
#include "softap_api.h"
#include <sys/socket.h>

#define SIM_IMSI_LEN_MAX          16  /**  Maximum length of IMSI data. */
#define SIM_ICCID_LEN_MAX         21  /**  Maximum length of ICCID data. */
#define DATA_MAX_APN_LEN          57  /**  Maximum length of the APN. */
#define DATA_MAX_USERNAME_LEN     127 /**  Maximum length of the profile user name. */
#define DATA_MAX_PASSWORD_LEN     127 /**  Maximum length of the profile password. */
#define DATA_INTERFACE_NAME_LEN   16  /**  Interface name length. */
#define DATA_MAX_ADDR_COUNT       2   /**  Maximum number of IP addresses. */

//**************GHT VSIM Struct*********************//

typedef enum {
    E_SIM_TYPE_USIM, //ʵ忨
    E_SIM_TYPE_VSIM, //ƿ
    E_SIM_TYPE_SSIM, //Soft SIM
}SimTypeInSlot_t;


typedef enum {
    E_NW_RADIO_IF_NO_SRV = 0,
    E_NW_RADIO_IF_GSM = 1,
    E_NW_RADIO_IF_WCDMA = 2,
    E_NW_RADIO_IF_LTE = 3,
    E_NW_RADIO_IF_TDSCDMA = 4,
    E_NW_RADIO_IF_CDMA = 5,
    E_NW_RADIO_IF_CDMA2000 = 6,
}e_nw_rat_type_t;  //RAT value


typedef enum {
    E_NW_STATUS_SRV_NONE = 0,
    E_NW_STATUS_SRV_LIMITED = 1,
    E_NW_STATUS_SRV_AVAILABLE = 2,
}e_nw_srv_status_t;


typedef struct
{
	uint32_t tac;
	uint32_t cell_id;
	uint32_t roamingFlag; ///< 1:roaming,0:non roaming
}lte_scell_info_t;

typedef struct
{
	uint32_t lac;
	uint32_t cell_id;
}gsm_w_scell_info_t;



typedef struct
{
    e_nw_rat_type_t    curr_rat;
	e_nw_srv_status_t  nStatus;
	lte_scell_info_t   lte_scell_info;   //ֵѡûratָʾȡֵ
	gsm_w_scell_info_t gsm_w_scell_info; //ֵѡûratָʾȡֵ
}RegInfo_t;

typedef struct{
    uint16_t mcc;
    uint16_t mnc;
	uint32_t tac;
	uint32_t cell_id;
    uint16_t bandwidth;
    uint16_t pcid;//int16_t  rxlev;
    uint32_t arfcn;
}base_cell_info_t;//Hex format


typedef struct
{
    uint16_t  roamingFlag; ///< 1:roaming,0:non roaming
    int16_t  rsrp;
    int16_t  rsrq;
    uint16_t SINR;
    uint16_t netMode;  //0--tdd  1--fdd
    uint16_t band;
    base_cell_info_t base_Scell_info;
} lte_Scell_t;

typedef struct
{
    int16_t rsrp;
    int16_t rsrq;
    uint16_t netMode;  //0--tdd  1--fdd
    base_cell_info_t base_Ncell_info;
}lte_Ncell_t;

typedef struct
{
    uint16_t bsic; //only in GSM
    uint16_t band;
    uint16_t rscp; //only in W
    base_cell_info_t base_Ncell_info;
}gsm_W_Scell_t;


typedef struct
{
    uint16_t bsic; //only GSM
    uint16_t band;
    uint16_t rscp; //only in W
    base_cell_info_t base_Ncell_info;
}gsm_W_Ncell_t;

typedef struct
{
    lte_Scell_t     lteScell;
    uint16_t      lteNcellNum;
    lte_Ncell_t   lteNcell[6];
}lte_cellinfo_t;

typedef struct{
	gsm_W_Scell_t   scell_info;
    uint16_t   gsm_W_NcellNum;
    gsm_W_Ncell_t gsm_W_ncell[6];
}gsm_W_cellifo_t;

typedef struct{
	e_nw_rat_type_t    curr_rat;
    e_nw_srv_status_t  service_status; //0x00: in service; 0x01: not in
	lte_cellinfo_t   lte_cellinfo;
	gsm_W_cellifo_t  gsm_cellinfo;
}CellInfo_t;


typedef struct{
  uint32_t lwip_ul;
  uint32_t lwip_dl;
  uint32_t ppp_ul;
  uint32_t ppp_dl;
  uint32_t rndis_ul;
  uint32_t rndis_dl;
}NetInfo_t;  /**< λ: bit*/

typedef enum
{
    E_DATA_IP_FAMILY_UNKNOWN         = 0x00,    /**<  unknown  */
    E_DATA_IP_FAMILY_IPV4            = 0x04,    /**<  IPv4  */
    E_DATA_IP_FAMILY_IPV6            = 0x06,    /**<  IPv6  */
    E_DATA_IP_FAMILY_IPV4V6          = 0x0A    /**<  IPv4|IPv6  */
}e_data_ip_family_t;

typedef enum
{
    E_DATA_TECH_PREF_UNKNOWN         = 0x00,    /**<  unknown  */
    E_DATA_TECH_PREF_UMTS            = 0x01,    /**<  UMTS  */
    E_DATA_TECH_PREF_CDMA            = 0x02,    /**<  CDMA  */
    E_DATA_TECH_PREF_LTE             = 0x03,    /**<  LTE  */
    E_DATA_TECH_PREF_AUTO            = 0x04     /**<  AUTO  */
}e_data_tech_pref_t;

typedef enum
{
    E_AUTH_PREF_PAP_CHAP_NOT_ALLOWED  = 0x00,
    E_AUTH_PREF_PAP_ONLY_ALLOWED      = 0x01,
    E_AUTH_PREF_CHAP_ONLY_ALLOWED     = 0x02,
    E_AUTH_PREF_PAP_CHAP_BOTH_ALLOWED = 0x03
}e_data_auth_pref_t;


typedef struct
{
    uint8_t            profile_valid;                        /**< Must be set to TRUE if umts_profile is being passed. */
    uint8_t            profile_id;                           /**< profile ID. as well as called cid*/
    uint8_t            ip_family_valid;                      /**< Must be set to TRUE if ip_family is being passed. */
    e_data_ip_family_t ip_family;                            /**< Data IP Family */
    uint8_t            apn_name_valid;                       /**< Must be set to TRUE if apn_name is being passed. */
    char               apn_name[DATA_MAX_APN_LEN+1];         /**< Data APN Name. A character string that identifies a PDN*/
    uint8_t            user_name_valid;                      /**< Must be set to TRUE if user_name is being passed. */
    char               user_name[DATA_MAX_USERNAME_LEN+1];   /**< Username for the APN. */
    uint8_t            password_valid;                       /**< Must be set to TRUE if password is being passed. */
    char               password[DATA_MAX_PASSWORD_LEN+1];    /**< Password for the APN. */
    uint8_t            auth_pref_valid;                      /**< Must be set to TRUE if tech_pref is being passed. */
    e_data_auth_pref_t auth_pref;                            /**< Data auth Preference */
    uint8_t            tech_pref_valid;                      /**< Must be set to TRUE if tech_pref is being passed. */
    e_data_tech_pref_t tech_pref;                            /**< Data Tech Preference */
}Data_call_config_info_t;


typedef struct
{
    char   addr_valid;                       /**< Indicates whether a valid address is available. */
    struct sockaddr_storage addr;            /**< Stores the IP address. defined in kernel socket.h*/
}data_call_addr_t;

typedef struct
{
    data_call_addr_t      iface_addr_s;      /**< Network interface address. */
    uint32_t              iface_mask;        /**< Subnet mask.             */
    data_call_addr_t      gtwy_addr_s;       /**< Gateway server address.  */
    uint32_t              gtwy_mask;         /**< Gateway mask.            */
    data_call_addr_t      dnsp_addr_s;       /**< Primary DNS server address.   */
    data_call_addr_t      dnss_addr_s;       /**< Secondary DNS server address. */
}data_call_addr_info_t;

typedef struct
{
    char                  iface_name[DATA_INTERFACE_NAME_LEN + 1]; /**< Network interface name. */
    uint8_t               addr_info_len;                           /**< Must be set to the number of elements in addr_info. */
    data_call_addr_info_t addr_info[DATA_MAX_ADDR_COUNT];          /**< Data device address list. */
}Data_call_addr_info_list_t;

typedef enum{
  E_RF_RESOURCE_CALLBACK_EVENT = 0x00,   /**< ƵԴл. */
  E_NW_ATTACH_COMMPLETE_EVENT  = 0x32,   /**< ע. */
  E_DATA_PDN_ACT_SUCC_EVENT = 0x64,      /**< PDN ,ind_dataЯZGIPDNS:ַϢ  */
  E_GET_CELLINFO_BY_SIMID_EVENT  = 0x65,	 /**< ɨ. */
}E_MODEM_EVENT_ID;

typedef enum
{
    E_SIM_STAT_NOT_INSERTED = 0x00,
    E_SIM_STAT_READY        = 0x01,
    E_SIM_STAT_PIN          = 0x02,
    E_SIM_STAT_PUK          = 0x03,
    E_SIM_STAT_BUSY         = 0x04,
    E_SIM_STAT_UNKNOWN      = 0x05,
}E_SIM_STATUS;


/*********************************************************************
** ƣ VSIM_COMMAND
**  VSIMӦúModemͨŵĻصṹ
** 
*********************************************************************/

typedef int (*VSIM_COMMAND)(uint8_t *apdu_req, uint16_t apdu_req_len,uint8_t *apdu_rsp, uint16_t *apdu_rsp_len, uint8_t slot);
typedef int (*SoftSim_COMMAND)(uint8_t *apdu_req, uint16_t apdu_req_len,uint8_t *apdu_rsp, uint16_t *apdu_rsp_len, uint8_t slot);

/*********************************************************************
** ƣ FIBO_MODEM_EVENT
**  Ϣ¼֪ͨĽṹ
** ind_dataƽ̨Զ
** RFԴԭ1. For SIM1 TAU; 2. For SIM1 Regist Network;3. NULL;
** 
*********************************************************************/

typedef int32_t (*FIBO_MODEM_EVENT)(E_MODEM_EVENT_ID event_id, void *ind_data, uint32_t  ind_data_len);

/*********************************************************************
** ƣ fibo_mdm_event_regist
**  
**  Ϣ¼֪ͨעڣṩͻעϢ;
**   modem¼ind_cb֪ͨͻ
** IN: 
**     ind_cb: func pointer;
*********************************************************************/

extern int32_t fibo_mdm_event_regist(FIBO_MODEM_EVENT ind_cb);

/************************************************************************
** Function Name: fibo_vsim_init
** Description:
**     VSIMʼҪAPDUصΪδ modem;
** VSIMʼʱãModemյעᣬͻȴ¼ϱӿ
** ϱE_NW_ATTACH_COMMPLETE_EVENT
** IN:
**   vsim_apdu_process: func pointer;
**              nSimID: value in range of [0,1];
**************************************************************************/

extern void fibo_vsim_init(VSIM_COMMAND vsim_apdu_process, uint8_t nSimID);
extern void fibo_SoftSim_init(SoftSim_COMMAND softsim_apdu_process, uint8_t nSimID);

/**********************************************************
** Function Name: fibo_vsim_close
** Description:
**     رVSIM, modemdetach͹ؿȲ;
** IN: 
**    vsim_apdu_process: function pointer;
**               nSimID: value in range of [0,1];
***********************************************************/

extern void fibo_vsim_close(VSIM_COMMAND vsim_apdu_process, uint8_t nSimID);
extern void fibo_SoftSim_close(SoftSim_COMMAND softsim_apdu_process, uint8_t nSimID);

/**************************************************************
** Function Name: fibo_set_dualsim
** Description:
**     ˫лýӿڣSimIDлӦĹ
**      SIMATҲ֮л;
** IN: 
**    nSimID: value in range of [0,1];
***************************************************************/

extern int32_t fibo_set_dualsim(uint8_t nSimID);

/**************************************************************
** Function Name: fibo_set_dualsim
** Description:
**     ˫лȡӿڣȡǰATصSIM ID;
** OUT: 
**    nSimID: pointer to memery restored current SIM ID;
***************************************************************/

extern int32_t fibo_get_dualsim(uint8_t *nSimID);

/**************************************************************
** Function Name: fibo_set_dualsim
** Description:
**     ݿΪnSimIDָĿ;
**     ýӿڽлûʹõSIM
**     ӰSIM0SIM1PDNͬʱ
**     лʱǰһſϵPDNӶϿеĻ;
** IN: 
**    nSimID: value in range of [0,1];
***************************************************************/

extern int32_t fibo_set_datasim(uint8_t nSimID);

/**************************************************************
** Function Name: fibo_get_datasim
** Description:
**     ȡǰõݿID;
** OUT: 
**    nSimID: pointer to memery restored current SIM ID;
***************************************************************/

extern int32_t fibo_get_datasim(uint8_t *nSimID);

/**********************************************************
** Function Name: fibo_set_IMEI_by_simid
** Description:
**     VSIMӦIMEI;
** Note: IMEI粻棬ϵͳӦóʱ;
**       IMEISIM0עvSIMصĿйأ濨仯
** IN: 
**        imei: pointer to memery restored the IMEI to set;
**    imei_len: size of the memery pointed by "imei";
**      nSimID: value in range of [0,1];
***********************************************************/

extern int32_t fibo_set_IMEI_by_simid(uint8_t *imei, uint8_t imei_len, uint8_t nSimID);

/**********************************************************
** Function Name: fibo_set_IMEI_by_simid
** Description:
**     ȡVSIMӦIMEI;
** Note: 豸IMEI粻棬vsim_init֮;
** IN: 
**      nSimID: value in range of [0,1];
**    imei_len: size of the memery pointed by "imei";
** OUT:
**        imei: pointer to memery to restore the IMEI to get;
***********************************************************/

extern int32_t fibo_get_IMEI_by_simid(uint8_t *imei, uint8_t imei_len, uint8_t nSimID);

/**********************************************************
** Function Name: fibo_get_CCID_by_simid
** Description:
**     ȡָSIMICCID;
** IN: 
**      nSimID: value in range of [0,1];
**    ccid_len: size of the memery pointed by "ccid";
** OUT:
**        ccid: pointer to memery to restore the ICCID to get;
***********************************************************/

extern int32_t fibo_get_CCID_by_simid(uint8_t *ccid, uint8_t ccid_len, uint8_t nSimID);

/**********************************************************
** Function Name: fibo_get_MCC_MNC_by_simid
** Description:
**     ͻӿڣȡMCCMNC;
** IN: 
**      nSimID: value in range of [0,1];
** OUT:
**      mcc: pointer to memery to restore the mcc to get;
**      mnc: pointer to memery to restore the mnc to get;
** Note: 
*        please deliver a buffer of which size is range in [2,3];
***********************************************************/

extern int32_t fibo_get_MCC_MNC_by_simid(char *mcc, char *mnc, uint8_t nSimID);

/**********************************************************
** Function Name: fibo_set_cfun_mode
** Description:
**     CFUN;
** IN:
**    mode: value in [0,1,4]; 
**          0: close modem stack(MS);
**          1: open MS or out of Airplane;
**          4: into Airplane and close RF TRX channel;
***********************************************************/

extern int32_t fibo_set_cfun_mode(uint8_t mode);

/**********************************************************
** Function Name: fibo_get_cfun_mode
** Description:
**     ȡCFUN;
** OUT:
**    mode: value in [0,1,4]; 
**          0: close modem stack(MS);
**          1: open MS or out of Airplane;
**          4: into Airplane and close RF TRX channel;
***********************************************************/

extern int32_t fibo_get_cfun_mode(uint8_t *mode);

/**********************************************************
** Function Name: fibo_set_SysReset
** Description:
**     豸;
**
***********************************************************/

extern int32_t fibo_set_SysReset();

/**********************************************************
** Function Name: fibo_get_CSQ_by_simid
** Description:
**     ȡSIM IDصCSQ;
** OUT:
**      rssi: -110dbm~-51dbm in GSM;
**             rscp: -115dbm~-25dbm;rsrp: -140dbm~-44dbm in LTE;
**       ber:  Only in GSM
**            0  BER < 0.2 %
**            1  0.2 % < BER < 0.4 %
**            2  0.4 % < BER < 0.8 %
**            3  0.8 % < BER < 1.6 %
**            4  1.6 % < BER < 3.2 %
**            5  3.2 % < BER < 6.4 %
**            6  6.4 % < BER < 12.8 %
**            7  12.8 % < BER
**            99 δ֪򲻿ɲ
** IN: 
**      nSimID: value in range of [0,1];
***********************************************************/

extern int32_t fibo_get_CSQ_by_simid(int32_t *rssi, int32_t *ber, uint8_t nSimID);

/**********************************************************
** Function Name: fibo_getRegInfo
** Description:
**     ȡSIM IDصRegInfo;
**
***********************************************************/

extern int32_t fibo_get_RegInfo_by_simid(RegInfo_t *reg_info, uint8_t nSimID);

/**********************************************************
** Function Name: fibo_get_CellInfo_by_simid
** Description:
**     ȡSIM IDصCellInfo;
**
***********************************************************/

extern int32_t fibo_get_CellInfo_by_simid(uint8_t nSimID);

/**********************************************************
** Function Name: fibo_get_NetInfo_by_simid
** Description:
**     ȡSIM IDصϢ;
** OUT:
**     pNetInfo: 洢ȡϢ;λ: /bit
***********************************************************/

extern int32_t fibo_get_NetInfo_by_simid(NetInfo_t *pNetInfo, uint8_t nSimID);

/**********************************************************
** Function Name: fibo_set_APN_by_simid
** Description:
**     PDPprofileϢ;
** IN: 
**    profile_id: ָʾȥcid;
**    rndis_flag: 0x00: ò; 0x01:ò;
***********************************************************/

extern int32_t fibo_set_APN_by_simid(Data_call_config_info_t *data_call, uint8_t nSimID);

/******************************************************************************
** Function Name: fibo_start_Data_Call_by_simid
** Description:
**    ָprofile PDPӣZGACTCGACT·ò;
** IN: 
**       nSimID: value in range of [0,1];
**    data_call: pointer to memery restore apn profile;
**   rndis_flag: 0x00: ò; 0x01:ò;
******************************************************************************/

extern int32_t fibo_start_Data_Call_by_simid(Data_call_config_info_t *data_call, uint8_t rndis_flag, uint8_t nSimID);

/**********************************************************
** Function Name: fibo_stop_Data_Call_by_simid
** Description:
**    ȥָprofile PDPӣZGACTCGACT·ò;
** IN: 
**    profile_id: ָʾȥcid;
**    rndis_flag: 0x00: ò; 0x01:ò;
***********************************************************/

extern int32_t fibo_stop_Data_Call_by_simid(uint8_t profile_id, uint8_t rndis_flag, uint8_t nSimID);

/**********************************************************
** Function Name: fibo_get_Data_Addr_by_simid
** Description:
**     ȡָprofileĵַϢ;
** IN: 
**     profile_id: ָʾȡһ·cidϢ;
** OUT:
**     addr_list: ڴ洢ȡĵַϢ
***********************************************************/

extern int32_t fibo_get_Data_Addr_by_simid(uint8_t profile_id, Data_call_addr_info_list_t *addr_list, uint8_t nSimID);

/**********************************************************
** Function Name: fibo_get_SIM_Status_by_simid
** Description:
**     ȡָSIM ״̬Ϣ;
** IN: 
**     nSimID: value in range of [0,1];
** OUT:
**     sim_status: ڴ洢ȡSIM״̬Ϣ
***********************************************************/

extern int32_t fibo_get_SIM_Status_by_simid(E_SIM_STATUS *sim_status, uint8_t nSimID);


/**********************************************************
** Function Name: fibo_send_AT_by_simid
** Description:
**     ȡָSIM ATָͷؽ;
** IN: 
**     nSimID: value in range of [0,1];
**     req_at: ڴ洢͵ATָ;
**     info_fmt: ATӦĸʽʽ;
**     pval: ʽATӦ;
** OUT:
**     return 0ʾOKɹֵʾʧܴ;
ʾ:
int ret = 0;
ret = get_modem_info("AT+CFUN=1\r", NULL,  NULL);
//0ʾִгɹ

char *pstr = malloc(50);
memset(pstr,0,50);
ret = get_modem_info("AT+CIMI\r", "%s",  (void**)&pstr);
//+CIMI: 111111111111111غpstr==111111111111111

int n1 = 0;
int n2 = 0;
int n3 = 0;
void *p2[] = {&n1,&n2,&n3};
ret = get_modem_info("AT+CCIOTOPT?\r", "%d,%d,%d",	(void**)p2);
//+CCIOTOPT: 1,2,3n1==1 n2==2 n3==3
***********************************************************/

extern int32_t fibo_send_AT_by_simid(char *req_at, char *info_fmt, void **pval, uint8_t nSimID);


#endif //#ifndef __GHT_VSIM_API_H__
