/**
 * File: hw_breakpoint_manage.h 
 * Brief: Public APIs of hw breakpoint manager
 *
 * Copyright (C) 2017 Sanechips Technology Co., Ltd.
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation. 
 *
 */

#ifndef _HW_BREAKPOINT_MANAGE_H
#define _HW_BREAKPOINT_MANAGE_H

/*******************************************************************************
 *                           Include header files                              *
 ******************************************************************************/

/*******************************************************************************
 *                             Macro definitions                               *
 ******************************************************************************/
#ifdef CONFIG_HW_BREAKPOINT_MANAGE
#define HW_BREAKPOINT_SUCCESS	    		(0)
#define HW_BREAKPOINT_FAIL	    			(-0xFF)
#define HW_BREAKPOINT_COND_IN_RANGE			(0)
#define HW_BREAKPOINT_COND_OUT_RANGE	    (1)
#define HW_BREAKPOINT_ADDR_STEP_LEN			(4)
#define HW_BREAKPOINT_STEP_REGS_INDEX  		(0)
#define HW_BREAKPOINT_MODE_MAX_LEN 			(10)
#define HW_BREAKPOINT_COND_MAX_LEN 			(10)
#define HW_BREAKPOINT_BUF_MAX_LEN  			(256)
#define HW_BREAKPOINT_RESULT_MAX_LEN  		(512)
#define HW_BREAKPOINT_CMD_TYPE_LEN 			(50)
#define HW_BREAKPOINT_SETDATA_PARAM_NUM		(7)
#define HW_BREAKPOINT_SETPROGRAM_PARAM_NUM	(3)
#define HW_BREAKPOINT_DEL_PARAM_NUM			(1)
#define HW_BREAKPOINT_ENABLE_REGS			(0)	
#define HW_BREAKPOINT_DISABLE_REGS			(1)	
#define HW_BREAKPOINT_SHELLCMD_PREFIX		"brk"
#define HW_BREAKPOINT_ERR_TYPE	      		(0xE0)
#define HW_BREAKPOINT_ERR_COND  	   		(0xE1)
#define HW_BREAKPOINT_ERR_PARMAM_NUM 		(0xE2)
#define HW_BREAKPOINT_ERR_CMD 				(0xE3)
#define HW_BREAKPOINT_ERR_ADDR_LEN      	(0xE4)
#define HW_BREAKPOINT_ERR_NUM_OUTOFRANGE 	(0xE5)
#define HW_SPECIAL_CHARACTER(c) 			((c) == ' ' || (c) == '\t' || (c) == '\r' || (c) == '\n')
#define HW_BREAKPOINT_REG8(addr)			(*(volatile unsigned char*)(addr))
#define HW_BREAKPOINT_REG16(addr)			(*(volatile unsigned short*)(addr))
#define HW_BREAKPOINT_REG32(addr)			(*(volatile unsigned long*)(addr))
#define HW_MAX_BREAKPOINT_COUNT 			5
#define HW_ARM_OSLAR_UNLOCKED    			0x00001111
#define HW_ARM_OSLAR_LOCKED      			0xC5ACCE55

/*******************************************************************************
 *                             Type definitions                                *
******************************************************************************/
typedef struct
{
	u32 	num;
	u32     len;
	__u64	addr;
}hw_brk_setprogram_param_t;

typedef struct
{
	u8		cond;	
	u32 	num;
	int 	start_value;
	int 	end_value;
	u32 	type;	
	__u64	addr;
	u32 	addr_len;

}hw_brk_setdata_param_t;

typedef struct{
	u32 dscr;
	u32 wcr;	
	u32 wvr;
	u32 bcr;
	u32 bvr;
}hw_context_t;

typedef struct
{
	u32 active_num_wrps;
	u32 active_num_brps;
	u32 enable; 
	struct perf_event	**wrps_on_reg;
	struct perf_event	**brps_on_reg;
}hw_brk_pool_t;


/*******************************************************************************
 *                       Global variable declarations                          *
 ******************************************************************************/
extern	u32	breakpoint_step_flag;
extern	u32	breakpoint_far_val;

/*******************************************************************************
 *                       static function declarations                          *
 ******************************************************************************/

/*******************************************************************************
 *                       Global function declarations                          *
 ******************************************************************************/
extern int 	hw_breakpoint_pool_init(void);
extern bool	hw_breakpoint_match_databreak(u32 address);
extern int 	sarch_install_step_breakpoint(struct perf_event *bp);
extern void	hw_breakpoint_enable(void);
extern void hw_breakpoint_do_action(u8 enableflag);
extern void hw_breakpoint_context_save(void);
extern void hw_breakpoint_restore_context(void);
extern void dscr_write(u32 value);
extern u32 	far_read(void);

/*******************************************************************************
 *                      Inline function implementations                        *
 ******************************************************************************/
#endif /*CONFIG_HW_BREAKPOINT_MANAGE*/

#endif  // #ifndef _HW_MANAGE_H

